//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hdinsightcontainers/armhdinsightcontainers"
	"net/http"
	"net/url"
	"regexp"
)

// ClusterJobsServer is a fake server for instances of the armhdinsightcontainers.ClusterJobsClient type.
type ClusterJobsServer struct {
	// NewListPager is the fake for method ClusterJobsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, clusterPoolName string, clusterName string, options *armhdinsightcontainers.ClusterJobsClientListOptions) (resp azfake.PagerResponder[armhdinsightcontainers.ClusterJobsClientListResponse])

	// BeginRunJob is the fake for method ClusterJobsClient.BeginRunJob
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRunJob func(ctx context.Context, resourceGroupName string, clusterPoolName string, clusterName string, clusterJob armhdinsightcontainers.ClusterJob, options *armhdinsightcontainers.ClusterJobsClientBeginRunJobOptions) (resp azfake.PollerResponder[armhdinsightcontainers.ClusterJobsClientRunJobResponse], errResp azfake.ErrorResponder)
}

// NewClusterJobsServerTransport creates a new instance of ClusterJobsServerTransport with the provided implementation.
// The returned ClusterJobsServerTransport instance is connected to an instance of armhdinsightcontainers.ClusterJobsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewClusterJobsServerTransport(srv *ClusterJobsServer) *ClusterJobsServerTransport {
	return &ClusterJobsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armhdinsightcontainers.ClusterJobsClientListResponse]](),
		beginRunJob:  newTracker[azfake.PollerResponder[armhdinsightcontainers.ClusterJobsClientRunJobResponse]](),
	}
}

// ClusterJobsServerTransport connects instances of armhdinsightcontainers.ClusterJobsClient to instances of ClusterJobsServer.
// Don't use this type directly, use NewClusterJobsServerTransport instead.
type ClusterJobsServerTransport struct {
	srv          *ClusterJobsServer
	newListPager *tracker[azfake.PagerResponder[armhdinsightcontainers.ClusterJobsClientListResponse]]
	beginRunJob  *tracker[azfake.PollerResponder[armhdinsightcontainers.ClusterJobsClientRunJobResponse]]
}

// Do implements the policy.Transporter interface for ClusterJobsServerTransport.
func (c *ClusterJobsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ClusterJobsClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ClusterJobsClient.BeginRunJob":
		resp, err = c.dispatchBeginRunJob(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ClusterJobsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhdinsightcontainers.ClusterJobsClientListOptions
		if filterParam != nil {
			options = &armhdinsightcontainers.ClusterJobsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armhdinsightcontainers.ClusterJobsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ClusterJobsServerTransport) dispatchBeginRunJob(req *http.Request) (*http.Response, error) {
	if c.srv.BeginRunJob == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRunJob not implemented")}
	}
	beginRunJob := c.beginRunJob.get(req)
	if beginRunJob == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HDInsight/clusterpools/(?P<clusterPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runJob`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhdinsightcontainers.ClusterJob](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterPoolName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginRunJob(req.Context(), resourceGroupNameParam, clusterPoolNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRunJob = &respr
		c.beginRunJob.add(req, beginRunJob)
	}

	resp, err := server.PollerResponderNext(beginRunJob, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginRunJob.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRunJob) {
		c.beginRunJob.remove(req)
	}

	return resp, nil
}
