//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AssessedDisk.
func (a AssessedDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "gigabytesForRecommendedDiskSize", a.GigabytesForRecommendedDiskSize)
	populate(objectMap, "gigabytesProvisioned", a.GigabytesProvisioned)
	populate(objectMap, "megabytesPerSecondOfRead", a.MegabytesPerSecondOfRead)
	populate(objectMap, "megabytesPerSecondOfWrite", a.MegabytesPerSecondOfWrite)
	populate(objectMap, "monthlyStorageCost", a.MonthlyStorageCost)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "numberOfReadOperationsPerSecond", a.NumberOfReadOperationsPerSecond)
	populate(objectMap, "numberOfWriteOperationsPerSecond", a.NumberOfWriteOperationsPerSecond)
	populate(objectMap, "recommendedDiskSize", a.RecommendedDiskSize)
	populate(objectMap, "recommendedDiskType", a.RecommendedDiskType)
	populate(objectMap, "suitability", a.Suitability)
	populate(objectMap, "suitabilityDetail", a.SuitabilityDetail)
	populate(objectMap, "suitabilityExplanation", a.SuitabilityExplanation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessedDisk.
func (a *AssessedDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "gigabytesForRecommendedDiskSize":
			err = unpopulate(val, "GigabytesForRecommendedDiskSize", &a.GigabytesForRecommendedDiskSize)
			delete(rawMsg, key)
		case "gigabytesProvisioned":
			err = unpopulate(val, "GigabytesProvisioned", &a.GigabytesProvisioned)
			delete(rawMsg, key)
		case "megabytesPerSecondOfRead":
			err = unpopulate(val, "MegabytesPerSecondOfRead", &a.MegabytesPerSecondOfRead)
			delete(rawMsg, key)
		case "megabytesPerSecondOfWrite":
			err = unpopulate(val, "MegabytesPerSecondOfWrite", &a.MegabytesPerSecondOfWrite)
			delete(rawMsg, key)
		case "monthlyStorageCost":
			err = unpopulate(val, "MonthlyStorageCost", &a.MonthlyStorageCost)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "numberOfReadOperationsPerSecond":
			err = unpopulate(val, "NumberOfReadOperationsPerSecond", &a.NumberOfReadOperationsPerSecond)
			delete(rawMsg, key)
		case "numberOfWriteOperationsPerSecond":
			err = unpopulate(val, "NumberOfWriteOperationsPerSecond", &a.NumberOfWriteOperationsPerSecond)
			delete(rawMsg, key)
		case "recommendedDiskSize":
			err = unpopulate(val, "RecommendedDiskSize", &a.RecommendedDiskSize)
			delete(rawMsg, key)
		case "recommendedDiskType":
			err = unpopulate(val, "RecommendedDiskType", &a.RecommendedDiskType)
			delete(rawMsg, key)
		case "suitability":
			err = unpopulate(val, "Suitability", &a.Suitability)
			delete(rawMsg, key)
		case "suitabilityDetail":
			err = unpopulate(val, "SuitabilityDetail", &a.SuitabilityDetail)
			delete(rawMsg, key)
		case "suitabilityExplanation":
			err = unpopulate(val, "SuitabilityExplanation", &a.SuitabilityExplanation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessedMachine.
func (a AssessedMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", a.ETag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessedMachine.
func (a *AssessedMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &a.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessedMachineProperties.
func (a AssessedMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bootType", a.BootType)
	populate(objectMap, "confidenceRatingInPercentage", a.ConfidenceRatingInPercentage)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", a.CreatedTimestamp)
	populate(objectMap, "datacenterMachineArmId", a.DatacenterMachineArmID)
	populate(objectMap, "datacenterManagementServerArmId", a.DatacenterManagementServerArmID)
	populate(objectMap, "datacenterManagementServerName", a.DatacenterManagementServerName)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "disks", a.Disks)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "megabytesOfMemory", a.MegabytesOfMemory)
	populate(objectMap, "megabytesOfMemoryForRecommendedSize", a.MegabytesOfMemoryForRecommendedSize)
	populate(objectMap, "monthlyBandwidthCost", a.MonthlyBandwidthCost)
	populate(objectMap, "monthlyComputeCostForRecommendedSize", a.MonthlyComputeCostForRecommendedSize)
	populate(objectMap, "monthlyPremiumStorageCost", a.MonthlyPremiumStorageCost)
	populate(objectMap, "monthlyStandardSSDStorageCost", a.MonthlyStandardSSDStorageCost)
	populate(objectMap, "monthlyStorageCost", a.MonthlyStorageCost)
	populate(objectMap, "networkAdapters", a.NetworkAdapters)
	populate(objectMap, "numberOfCores", a.NumberOfCores)
	populate(objectMap, "numberOfCoresForRecommendedSize", a.NumberOfCoresForRecommendedSize)
	populate(objectMap, "operatingSystemName", a.OperatingSystemName)
	populate(objectMap, "operatingSystemType", a.OperatingSystemType)
	populate(objectMap, "operatingSystemVersion", a.OperatingSystemVersion)
	populate(objectMap, "percentageCoresUtilization", a.PercentageCoresUtilization)
	populate(objectMap, "percentageMemoryUtilization", a.PercentageMemoryUtilization)
	populate(objectMap, "recommendedSize", a.RecommendedSize)
	populate(objectMap, "suitability", a.Suitability)
	populate(objectMap, "suitabilityDetail", a.SuitabilityDetail)
	populate(objectMap, "suitabilityExplanation", a.SuitabilityExplanation)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", a.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessedMachineProperties.
func (a *AssessedMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootType":
			err = unpopulate(val, "BootType", &a.BootType)
			delete(rawMsg, key)
		case "confidenceRatingInPercentage":
			err = unpopulate(val, "ConfidenceRatingInPercentage", &a.ConfidenceRatingInPercentage)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &a.CreatedTimestamp)
			delete(rawMsg, key)
		case "datacenterMachineArmId":
			err = unpopulate(val, "DatacenterMachineArmID", &a.DatacenterMachineArmID)
			delete(rawMsg, key)
		case "datacenterManagementServerArmId":
			err = unpopulate(val, "DatacenterManagementServerArmID", &a.DatacenterManagementServerArmID)
			delete(rawMsg, key)
		case "datacenterManagementServerName":
			err = unpopulate(val, "DatacenterManagementServerName", &a.DatacenterManagementServerName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &a.Disks)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "megabytesOfMemory":
			err = unpopulate(val, "MegabytesOfMemory", &a.MegabytesOfMemory)
			delete(rawMsg, key)
		case "megabytesOfMemoryForRecommendedSize":
			err = unpopulate(val, "MegabytesOfMemoryForRecommendedSize", &a.MegabytesOfMemoryForRecommendedSize)
			delete(rawMsg, key)
		case "monthlyBandwidthCost":
			err = unpopulate(val, "MonthlyBandwidthCost", &a.MonthlyBandwidthCost)
			delete(rawMsg, key)
		case "monthlyComputeCostForRecommendedSize":
			err = unpopulate(val, "MonthlyComputeCostForRecommendedSize", &a.MonthlyComputeCostForRecommendedSize)
			delete(rawMsg, key)
		case "monthlyPremiumStorageCost":
			err = unpopulate(val, "MonthlyPremiumStorageCost", &a.MonthlyPremiumStorageCost)
			delete(rawMsg, key)
		case "monthlyStandardSSDStorageCost":
			err = unpopulate(val, "MonthlyStandardSSDStorageCost", &a.MonthlyStandardSSDStorageCost)
			delete(rawMsg, key)
		case "monthlyStorageCost":
			err = unpopulate(val, "MonthlyStorageCost", &a.MonthlyStorageCost)
			delete(rawMsg, key)
		case "networkAdapters":
			err = unpopulate(val, "NetworkAdapters", &a.NetworkAdapters)
			delete(rawMsg, key)
		case "numberOfCores":
			err = unpopulate(val, "NumberOfCores", &a.NumberOfCores)
			delete(rawMsg, key)
		case "numberOfCoresForRecommendedSize":
			err = unpopulate(val, "NumberOfCoresForRecommendedSize", &a.NumberOfCoresForRecommendedSize)
			delete(rawMsg, key)
		case "operatingSystemName":
			err = unpopulate(val, "OperatingSystemName", &a.OperatingSystemName)
			delete(rawMsg, key)
		case "operatingSystemType":
			err = unpopulate(val, "OperatingSystemType", &a.OperatingSystemType)
			delete(rawMsg, key)
		case "operatingSystemVersion":
			err = unpopulate(val, "OperatingSystemVersion", &a.OperatingSystemVersion)
			delete(rawMsg, key)
		case "percentageCoresUtilization":
			err = unpopulate(val, "PercentageCoresUtilization", &a.PercentageCoresUtilization)
			delete(rawMsg, key)
		case "percentageMemoryUtilization":
			err = unpopulate(val, "PercentageMemoryUtilization", &a.PercentageMemoryUtilization)
			delete(rawMsg, key)
		case "recommendedSize":
			err = unpopulate(val, "RecommendedSize", &a.RecommendedSize)
			delete(rawMsg, key)
		case "suitability":
			err = unpopulate(val, "Suitability", &a.Suitability)
			delete(rawMsg, key)
		case "suitabilityDetail":
			err = unpopulate(val, "SuitabilityDetail", &a.SuitabilityDetail)
			delete(rawMsg, key)
		case "suitabilityExplanation":
			err = unpopulate(val, "SuitabilityExplanation", &a.SuitabilityExplanation)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &a.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessedMachineResultList.
func (a AssessedMachineResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessedMachineResultList.
func (a *AssessedMachineResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessedNetworkAdapter.
func (a AssessedNetworkAdapter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "ipAddresses", a.IPAddresses)
	populate(objectMap, "macAddress", a.MacAddress)
	populate(objectMap, "megabytesPerSecondReceived", a.MegabytesPerSecondReceived)
	populate(objectMap, "megabytesPerSecondTransmitted", a.MegabytesPerSecondTransmitted)
	populate(objectMap, "monthlyBandwidthCosts", a.MonthlyBandwidthCosts)
	populate(objectMap, "netGigabytesTransmittedPerMonth", a.NetGigabytesTransmittedPerMonth)
	populate(objectMap, "suitability", a.Suitability)
	populate(objectMap, "suitabilityDetail", a.SuitabilityDetail)
	populate(objectMap, "suitabilityExplanation", a.SuitabilityExplanation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessedNetworkAdapter.
func (a *AssessedNetworkAdapter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &a.IPAddresses)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &a.MacAddress)
			delete(rawMsg, key)
		case "megabytesPerSecondReceived":
			err = unpopulate(val, "MegabytesPerSecondReceived", &a.MegabytesPerSecondReceived)
			delete(rawMsg, key)
		case "megabytesPerSecondTransmitted":
			err = unpopulate(val, "MegabytesPerSecondTransmitted", &a.MegabytesPerSecondTransmitted)
			delete(rawMsg, key)
		case "monthlyBandwidthCosts":
			err = unpopulate(val, "MonthlyBandwidthCosts", &a.MonthlyBandwidthCosts)
			delete(rawMsg, key)
		case "netGigabytesTransmittedPerMonth":
			err = unpopulate(val, "NetGigabytesTransmittedPerMonth", &a.NetGigabytesTransmittedPerMonth)
			delete(rawMsg, key)
		case "suitability":
			err = unpopulate(val, "Suitability", &a.Suitability)
			delete(rawMsg, key)
		case "suitabilityDetail":
			err = unpopulate(val, "SuitabilityDetail", &a.SuitabilityDetail)
			delete(rawMsg, key)
		case "suitabilityExplanation":
			err = unpopulate(val, "SuitabilityExplanation", &a.SuitabilityExplanation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Assessment.
func (a Assessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", a.ETag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Assessment.
func (a *Assessment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &a.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentOptions.
func (a AssessmentOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentOptions.
func (a *AssessmentOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentOptionsProperties.
func (a AssessmentOptionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reservedInstanceSupportedCurrencies", a.ReservedInstanceSupportedCurrencies)
	populate(objectMap, "reservedInstanceSupportedLocations", a.ReservedInstanceSupportedLocations)
	populate(objectMap, "reservedInstanceSupportedOffers", a.ReservedInstanceSupportedOffers)
	populate(objectMap, "reservedInstanceVmFamilies", a.ReservedInstanceVMFamilies)
	populate(objectMap, "vmFamilies", a.VMFamilies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentOptionsProperties.
func (a *AssessmentOptionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reservedInstanceSupportedCurrencies":
			err = unpopulate(val, "ReservedInstanceSupportedCurrencies", &a.ReservedInstanceSupportedCurrencies)
			delete(rawMsg, key)
		case "reservedInstanceSupportedLocations":
			err = unpopulate(val, "ReservedInstanceSupportedLocations", &a.ReservedInstanceSupportedLocations)
			delete(rawMsg, key)
		case "reservedInstanceSupportedOffers":
			err = unpopulate(val, "ReservedInstanceSupportedOffers", &a.ReservedInstanceSupportedOffers)
			delete(rawMsg, key)
		case "reservedInstanceVmFamilies":
			err = unpopulate(val, "ReservedInstanceVMFamilies", &a.ReservedInstanceVMFamilies)
			delete(rawMsg, key)
		case "vmFamilies":
			err = unpopulate(val, "VMFamilies", &a.VMFamilies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentOptionsResultList.
func (a AssessmentOptionsResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentOptionsResultList.
func (a *AssessmentOptionsResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentProperties.
func (a AssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureDiskType", a.AzureDiskType)
	populate(objectMap, "azureHybridUseBenefit", a.AzureHybridUseBenefit)
	populate(objectMap, "azureLocation", a.AzureLocation)
	populate(objectMap, "azureOfferCode", a.AzureOfferCode)
	populate(objectMap, "azurePricingTier", a.AzurePricingTier)
	populate(objectMap, "azureStorageRedundancy", a.AzureStorageRedundancy)
	populate(objectMap, "azureVmFamilies", a.AzureVMFamilies)
	populate(objectMap, "confidenceRatingInPercentage", a.ConfidenceRatingInPercentage)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", a.CreatedTimestamp)
	populate(objectMap, "currency", a.Currency)
	populate(objectMap, "discountPercentage", a.DiscountPercentage)
	populate(objectMap, "eaSubscriptionId", a.EaSubscriptionID)
	populate(objectMap, "monthlyBandwidthCost", a.MonthlyBandwidthCost)
	populate(objectMap, "monthlyComputeCost", a.MonthlyComputeCost)
	populate(objectMap, "monthlyPremiumStorageCost", a.MonthlyPremiumStorageCost)
	populate(objectMap, "monthlyStandardSSDStorageCost", a.MonthlyStandardSSDStorageCost)
	populate(objectMap, "monthlyStorageCost", a.MonthlyStorageCost)
	populate(objectMap, "numberOfMachines", a.NumberOfMachines)
	populate(objectMap, "percentile", a.Percentile)
	populateDateTimeRFC3339(objectMap, "perfDataEndTime", a.PerfDataEndTime)
	populateDateTimeRFC3339(objectMap, "perfDataStartTime", a.PerfDataStartTime)
	populateDateTimeRFC3339(objectMap, "pricesTimestamp", a.PricesTimestamp)
	populate(objectMap, "reservedInstance", a.ReservedInstance)
	populate(objectMap, "scalingFactor", a.ScalingFactor)
	populate(objectMap, "sizingCriterion", a.SizingCriterion)
	populate(objectMap, "stage", a.Stage)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "timeRange", a.TimeRange)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", a.UpdatedTimestamp)
	populate(objectMap, "vmUptime", a.VMUptime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentProperties.
func (a *AssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureDiskType":
			err = unpopulate(val, "AzureDiskType", &a.AzureDiskType)
			delete(rawMsg, key)
		case "azureHybridUseBenefit":
			err = unpopulate(val, "AzureHybridUseBenefit", &a.AzureHybridUseBenefit)
			delete(rawMsg, key)
		case "azureLocation":
			err = unpopulate(val, "AzureLocation", &a.AzureLocation)
			delete(rawMsg, key)
		case "azureOfferCode":
			err = unpopulate(val, "AzureOfferCode", &a.AzureOfferCode)
			delete(rawMsg, key)
		case "azurePricingTier":
			err = unpopulate(val, "AzurePricingTier", &a.AzurePricingTier)
			delete(rawMsg, key)
		case "azureStorageRedundancy":
			err = unpopulate(val, "AzureStorageRedundancy", &a.AzureStorageRedundancy)
			delete(rawMsg, key)
		case "azureVmFamilies":
			err = unpopulate(val, "AzureVMFamilies", &a.AzureVMFamilies)
			delete(rawMsg, key)
		case "confidenceRatingInPercentage":
			err = unpopulate(val, "ConfidenceRatingInPercentage", &a.ConfidenceRatingInPercentage)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &a.CreatedTimestamp)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &a.Currency)
			delete(rawMsg, key)
		case "discountPercentage":
			err = unpopulate(val, "DiscountPercentage", &a.DiscountPercentage)
			delete(rawMsg, key)
		case "eaSubscriptionId":
			err = unpopulate(val, "EaSubscriptionID", &a.EaSubscriptionID)
			delete(rawMsg, key)
		case "monthlyBandwidthCost":
			err = unpopulate(val, "MonthlyBandwidthCost", &a.MonthlyBandwidthCost)
			delete(rawMsg, key)
		case "monthlyComputeCost":
			err = unpopulate(val, "MonthlyComputeCost", &a.MonthlyComputeCost)
			delete(rawMsg, key)
		case "monthlyPremiumStorageCost":
			err = unpopulate(val, "MonthlyPremiumStorageCost", &a.MonthlyPremiumStorageCost)
			delete(rawMsg, key)
		case "monthlyStandardSSDStorageCost":
			err = unpopulate(val, "MonthlyStandardSSDStorageCost", &a.MonthlyStandardSSDStorageCost)
			delete(rawMsg, key)
		case "monthlyStorageCost":
			err = unpopulate(val, "MonthlyStorageCost", &a.MonthlyStorageCost)
			delete(rawMsg, key)
		case "numberOfMachines":
			err = unpopulate(val, "NumberOfMachines", &a.NumberOfMachines)
			delete(rawMsg, key)
		case "percentile":
			err = unpopulate(val, "Percentile", &a.Percentile)
			delete(rawMsg, key)
		case "perfDataEndTime":
			err = unpopulateDateTimeRFC3339(val, "PerfDataEndTime", &a.PerfDataEndTime)
			delete(rawMsg, key)
		case "perfDataStartTime":
			err = unpopulateDateTimeRFC3339(val, "PerfDataStartTime", &a.PerfDataStartTime)
			delete(rawMsg, key)
		case "pricesTimestamp":
			err = unpopulateDateTimeRFC3339(val, "PricesTimestamp", &a.PricesTimestamp)
			delete(rawMsg, key)
		case "reservedInstance":
			err = unpopulate(val, "ReservedInstance", &a.ReservedInstance)
			delete(rawMsg, key)
		case "scalingFactor":
			err = unpopulate(val, "ScalingFactor", &a.ScalingFactor)
			delete(rawMsg, key)
		case "sizingCriterion":
			err = unpopulate(val, "SizingCriterion", &a.SizingCriterion)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &a.Stage)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "timeRange":
			err = unpopulate(val, "TimeRange", &a.TimeRange)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &a.UpdatedTimestamp)
			delete(rawMsg, key)
		case "vmUptime":
			err = unpopulate(val, "VMUptime", &a.VMUptime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentResultList.
func (a AssessmentResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentResultList.
func (a *AssessmentResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectorAgentProperties.
func (c CollectorAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populateDateTimeRFC3339(objectMap, "lastHeartbeatUtc", c.LastHeartbeatUTC)
	populate(objectMap, "spnDetails", c.SpnDetails)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectorAgentProperties.
func (c *CollectorAgentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeatUTC", &c.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "spnDetails":
			err = unpopulate(val, "SpnDetails", &c.SpnDetails)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectorBodyAgentSpnProperties.
func (c CollectorBodyAgentSpnProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationId", c.ApplicationID)
	populate(objectMap, "audience", c.Audience)
	populate(objectMap, "authority", c.Authority)
	populate(objectMap, "objectId", c.ObjectID)
	populate(objectMap, "tenantId", c.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectorBodyAgentSpnProperties.
func (c *CollectorBodyAgentSpnProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &c.ApplicationID)
			delete(rawMsg, key)
		case "audience":
			err = unpopulate(val, "Audience", &c.Audience)
			delete(rawMsg, key)
		case "authority":
			err = unpopulate(val, "Authority", &c.Authority)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &c.ObjectID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectorProperties.
func (c CollectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentProperties", c.AgentProperties)
	populate(objectMap, "createdTimestamp", c.CreatedTimestamp)
	populate(objectMap, "discoverySiteId", c.DiscoverySiteID)
	populate(objectMap, "updatedTimestamp", c.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectorProperties.
func (c *CollectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentProperties":
			err = unpopulate(val, "AgentProperties", &c.AgentProperties)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulate(val, "CreatedTimestamp", &c.CreatedTimestamp)
			delete(rawMsg, key)
		case "discoverySiteId":
			err = unpopulate(val, "DiscoverySiteID", &c.DiscoverySiteID)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulate(val, "UpdatedTimestamp", &c.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "gigabytesAllocated", d.GigabytesAllocated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Disk.
func (d *Disk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "gigabytesAllocated":
			err = unpopulate(val, "GigabytesAllocated", &d.GigabytesAllocated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DownloadURL.
func (d DownloadURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentReportUrl", d.AssessmentReportURL)
	populateDateTimeRFC3339(objectMap, "expirationTime", d.ExpirationTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURL.
func (d *DownloadURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentReportUrl":
			err = unpopulate(val, "AssessmentReportURL", &d.AssessmentReportURL)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &d.ExpirationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", g.ETag)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Group.
func (g *Group) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &g.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupBodyProperties.
func (g GroupBodyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "machines", g.Machines)
	populate(objectMap, "operationType", g.OperationType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupBodyProperties.
func (g *GroupBodyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "machines":
			err = unpopulate(val, "Machines", &g.Machines)
			delete(rawMsg, key)
		case "operationType":
			err = unpopulate(val, "OperationType", &g.OperationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupProperties.
func (g GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "areAssessmentsRunning", g.AreAssessmentsRunning)
	populate(objectMap, "assessments", g.Assessments)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", g.CreatedTimestamp)
	populate(objectMap, "groupStatus", g.GroupStatus)
	populate(objectMap, "groupType", g.GroupType)
	populate(objectMap, "machineCount", g.MachineCount)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", g.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupProperties.
func (g *GroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "areAssessmentsRunning":
			err = unpopulate(val, "AreAssessmentsRunning", &g.AreAssessmentsRunning)
			delete(rawMsg, key)
		case "assessments":
			err = unpopulate(val, "Assessments", &g.Assessments)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &g.CreatedTimestamp)
			delete(rawMsg, key)
		case "groupStatus":
			err = unpopulate(val, "GroupStatus", &g.GroupStatus)
			delete(rawMsg, key)
		case "groupType":
			err = unpopulate(val, "GroupType", &g.GroupType)
			delete(rawMsg, key)
		case "machineCount":
			err = unpopulate(val, "MachineCount", &g.MachineCount)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &g.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupResultList.
func (g GroupResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupResultList.
func (g *GroupResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVCollector.
func (h HyperVCollector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", h.ETag)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVCollector.
func (h *HyperVCollector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &h.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVCollectorList.
func (h HyperVCollectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVCollectorList.
func (h *HyperVCollectorList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportCollector.
func (i ImportCollector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", i.ETag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportCollector.
func (i *ImportCollector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &i.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportCollectorList.
func (i ImportCollectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportCollectorList.
func (i *ImportCollectorList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportCollectorProperties.
func (i ImportCollectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdTimestamp", i.CreatedTimestamp)
	populate(objectMap, "discoverySiteId", i.DiscoverySiteID)
	populate(objectMap, "updatedTimestamp", i.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportCollectorProperties.
func (i *ImportCollectorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdTimestamp":
			err = unpopulate(val, "CreatedTimestamp", &i.CreatedTimestamp)
			delete(rawMsg, key)
		case "discoverySiteId":
			err = unpopulate(val, "DiscoverySiteID", &i.DiscoverySiteID)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulate(val, "UpdatedTimestamp", &i.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Machine.
func (m Machine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", m.ETag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Machine.
func (m *Machine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &m.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineProperties.
func (m MachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bootType", m.BootType)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", m.CreatedTimestamp)
	populate(objectMap, "datacenterManagementServerArmId", m.DatacenterManagementServerArmID)
	populate(objectMap, "datacenterManagementServerName", m.DatacenterManagementServerName)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "discoveryMachineArmId", m.DiscoveryMachineArmID)
	populate(objectMap, "disks", m.Disks)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "groups", m.Groups)
	populate(objectMap, "megabytesOfMemory", m.MegabytesOfMemory)
	populate(objectMap, "networkAdapters", m.NetworkAdapters)
	populate(objectMap, "numberOfCores", m.NumberOfCores)
	populate(objectMap, "operatingSystemName", m.OperatingSystemName)
	populate(objectMap, "operatingSystemType", m.OperatingSystemType)
	populate(objectMap, "operatingSystemVersion", m.OperatingSystemVersion)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", m.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineProperties.
func (m *MachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootType":
			err = unpopulate(val, "BootType", &m.BootType)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &m.CreatedTimestamp)
			delete(rawMsg, key)
		case "datacenterManagementServerArmId":
			err = unpopulate(val, "DatacenterManagementServerArmID", &m.DatacenterManagementServerArmID)
			delete(rawMsg, key)
		case "datacenterManagementServerName":
			err = unpopulate(val, "DatacenterManagementServerName", &m.DatacenterManagementServerName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "discoveryMachineArmId":
			err = unpopulate(val, "DiscoveryMachineArmID", &m.DiscoveryMachineArmID)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &m.Disks)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &m.Groups)
			delete(rawMsg, key)
		case "megabytesOfMemory":
			err = unpopulate(val, "MegabytesOfMemory", &m.MegabytesOfMemory)
			delete(rawMsg, key)
		case "networkAdapters":
			err = unpopulate(val, "NetworkAdapters", &m.NetworkAdapters)
			delete(rawMsg, key)
		case "numberOfCores":
			err = unpopulate(val, "NumberOfCores", &m.NumberOfCores)
			delete(rawMsg, key)
		case "operatingSystemName":
			err = unpopulate(val, "OperatingSystemName", &m.OperatingSystemName)
			delete(rawMsg, key)
		case "operatingSystemType":
			err = unpopulate(val, "OperatingSystemType", &m.OperatingSystemType)
			delete(rawMsg, key)
		case "operatingSystemVersion":
			err = unpopulate(val, "OperatingSystemVersion", &m.OperatingSystemVersion)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &m.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineResultList.
func (m MachineResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineResultList.
func (m *MachineResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkAdapter.
func (n NetworkAdapter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "ipAddresses", n.IPAddresses)
	populate(objectMap, "macAddress", n.MacAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkAdapter.
func (n *NetworkAdapter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &n.DisplayName)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &n.IPAddresses)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultList.
func (o OperationResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultList.
func (o *OperationResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionCollection.
func (p PrivateEndpointConnectionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionCollection.
func (p *PrivateEndpointConnectionCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceCollection.
func (p PrivateLinkResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceCollection.
func (p *PrivateLinkResourceCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populateAny(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Project.
func (p *Project) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProjectProperties.
func (p ProjectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assessmentSolutionId", p.AssessmentSolutionID)
	populateDateTimeRFC3339(objectMap, "createdTimestamp", p.CreatedTimestamp)
	populate(objectMap, "customerStorageAccountArmId", p.CustomerStorageAccountArmID)
	populate(objectMap, "customerWorkspaceId", p.CustomerWorkspaceID)
	populate(objectMap, "customerWorkspaceLocation", p.CustomerWorkspaceLocation)
	populateDateTimeRFC3339(objectMap, "lastAssessmentTimestamp", p.LastAssessmentTimestamp)
	populate(objectMap, "numberOfAssessments", p.NumberOfAssessments)
	populate(objectMap, "numberOfGroups", p.NumberOfGroups)
	populate(objectMap, "numberOfMachines", p.NumberOfMachines)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "projectStatus", p.ProjectStatus)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", p.PublicNetworkAccess)
	populate(objectMap, "serviceEndpoint", p.ServiceEndpoint)
	populateDateTimeRFC3339(objectMap, "updatedTimestamp", p.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectProperties.
func (p *ProjectProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentSolutionId":
			err = unpopulate(val, "AssessmentSolutionID", &p.AssessmentSolutionID)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateDateTimeRFC3339(val, "CreatedTimestamp", &p.CreatedTimestamp)
			delete(rawMsg, key)
		case "customerStorageAccountArmId":
			err = unpopulate(val, "CustomerStorageAccountArmID", &p.CustomerStorageAccountArmID)
			delete(rawMsg, key)
		case "customerWorkspaceId":
			err = unpopulate(val, "CustomerWorkspaceID", &p.CustomerWorkspaceID)
			delete(rawMsg, key)
		case "customerWorkspaceLocation":
			err = unpopulate(val, "CustomerWorkspaceLocation", &p.CustomerWorkspaceLocation)
			delete(rawMsg, key)
		case "lastAssessmentTimestamp":
			err = unpopulateDateTimeRFC3339(val, "LastAssessmentTimestamp", &p.LastAssessmentTimestamp)
			delete(rawMsg, key)
		case "numberOfAssessments":
			err = unpopulate(val, "NumberOfAssessments", &p.NumberOfAssessments)
			delete(rawMsg, key)
		case "numberOfGroups":
			err = unpopulate(val, "NumberOfGroups", &p.NumberOfGroups)
			delete(rawMsg, key)
		case "numberOfMachines":
			err = unpopulate(val, "NumberOfMachines", &p.NumberOfMachines)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &p.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "projectStatus":
			err = unpopulate(val, "ProjectStatus", &p.ProjectStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &p.PublicNetworkAccess)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &p.ServiceEndpoint)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "UpdatedTimestamp", &p.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProjectResultList.
func (p ProjectResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectResultList.
func (p *ProjectResultList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceID.
func (r ResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceID.
func (r *ResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerCollector.
func (s ServerCollector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", s.ETag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerCollector.
func (s *ServerCollector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &s.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServerCollectorList.
func (s ServerCollectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServerCollectorList.
func (s *ServerCollectorList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateGroupBody.
func (u UpdateGroupBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", u.ETag)
	populate(objectMap, "properties", u.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateGroupBody.
func (u *UpdateGroupBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &u.ETag)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMFamily.
func (v VMFamily) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", v.Category)
	populate(objectMap, "familyName", v.FamilyName)
	populate(objectMap, "targetLocations", v.TargetLocations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMFamily.
func (v *VMFamily) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &v.Category)
			delete(rawMsg, key)
		case "familyName":
			err = unpopulate(val, "FamilyName", &v.FamilyName)
			delete(rawMsg, key)
		case "targetLocations":
			err = unpopulate(val, "TargetLocations", &v.TargetLocations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMUptime.
func (v VMUptime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "daysPerMonth", v.DaysPerMonth)
	populate(objectMap, "hoursPerDay", v.HoursPerDay)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMUptime.
func (v *VMUptime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysPerMonth":
			err = unpopulate(val, "DaysPerMonth", &v.DaysPerMonth)
			delete(rawMsg, key)
		case "hoursPerDay":
			err = unpopulate(val, "HoursPerDay", &v.HoursPerDay)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCollector.
func (v VMwareCollector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", v.ETag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCollector.
func (v *VMwareCollector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &v.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareCollectorList.
func (v VMwareCollectorList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareCollectorList.
func (v *VMwareCollectorList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
