//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysql"
	"net/http"
	"net/url"
	"regexp"
)

// TopQueryStatisticsServer is a fake server for instances of the armmysql.TopQueryStatisticsClient type.
type TopQueryStatisticsServer struct {
	// Get is the fake for method TopQueryStatisticsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, queryStatisticID string, options *armmysql.TopQueryStatisticsClientGetOptions) (resp azfake.Responder[armmysql.TopQueryStatisticsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByServerPager is the fake for method TopQueryStatisticsClient.NewListByServerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByServerPager func(resourceGroupName string, serverName string, parameters armmysql.TopQueryStatisticsInput, options *armmysql.TopQueryStatisticsClientListByServerOptions) (resp azfake.PagerResponder[armmysql.TopQueryStatisticsClientListByServerResponse])
}

// NewTopQueryStatisticsServerTransport creates a new instance of TopQueryStatisticsServerTransport with the provided implementation.
// The returned TopQueryStatisticsServerTransport instance is connected to an instance of armmysql.TopQueryStatisticsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTopQueryStatisticsServerTransport(srv *TopQueryStatisticsServer) *TopQueryStatisticsServerTransport {
	return &TopQueryStatisticsServerTransport{
		srv:                  srv,
		newListByServerPager: newTracker[azfake.PagerResponder[armmysql.TopQueryStatisticsClientListByServerResponse]](),
	}
}

// TopQueryStatisticsServerTransport connects instances of armmysql.TopQueryStatisticsClient to instances of TopQueryStatisticsServer.
// Don't use this type directly, use NewTopQueryStatisticsServerTransport instead.
type TopQueryStatisticsServerTransport struct {
	srv                  *TopQueryStatisticsServer
	newListByServerPager *tracker[azfake.PagerResponder[armmysql.TopQueryStatisticsClientListByServerResponse]]
}

// Do implements the policy.Transporter interface for TopQueryStatisticsServerTransport.
func (t *TopQueryStatisticsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TopQueryStatisticsClient.Get":
		resp, err = t.dispatchGet(req)
	case "TopQueryStatisticsClient.NewListByServerPager":
		resp, err = t.dispatchNewListByServerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TopQueryStatisticsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topQueryStatistics/(?P<queryStatisticId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	queryStatisticIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("queryStatisticId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, queryStatisticIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).QueryStatistic, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TopQueryStatisticsServerTransport) dispatchNewListByServerPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByServerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByServerPager not implemented")}
	}
	newListByServerPager := t.newListByServerPager.get(req)
	if newListByServerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/topQueryStatistics`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmysql.TopQueryStatisticsInput](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByServerPager(resourceGroupNameParam, serverNameParam, body, nil)
		newListByServerPager = &resp
		t.newListByServerPager.add(req, newListByServerPager)
		server.PagerResponderInjectNextLinks(newListByServerPager, req, func(page *armmysql.TopQueryStatisticsClientListByServerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByServerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByServerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByServerPager) {
		t.newListByServerPager.remove(req)
	}
	return resp, nil
}
