//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/UsageList.json
func ExampleUsagesClient_NewListPager_listUsages() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsagesClient().NewListPager("westus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsagesListResult = armnetwork.UsagesListResult{
		// 	Value: []*armnetwork.Usage{
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Virtual Networks"),
		// 				Value: to.Ptr("VirtualNetworks"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](8),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/VirtualNetworks"),
		// 			Limit: to.Ptr[int64](50),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Static Public IP Addresses"),
		// 				Value: to.Ptr("StaticPublicIPAddresses"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](3),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/StaticPublicIPAddresses"),
		// 			Limit: to.Ptr[int64](20),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Security Groups"),
		// 				Value: to.Ptr("NetworkSecurityGroups"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](1),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/NetworkSecurityGroups"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Public IP Addresses"),
		// 				Value: to.Ptr("PublicIPAddresses"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](8),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/PublicIPAddresses"),
		// 			Limit: to.Ptr[int64](60),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Interfaces"),
		// 				Value: to.Ptr("NetworkInterfaces"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](2),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/NetworkInterfaces"),
		// 			Limit: to.Ptr[int64](350),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Load Balancers"),
		// 				Value: to.Ptr("LoadBalancers"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](2),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/LoadBalancers"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Application Gateways"),
		// 				Value: to.Ptr("ApplicationGateways"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](1),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/ApplicationGateways"),
		// 			Limit: to.Ptr[int64](50),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route Tables"),
		// 				Value: to.Ptr("RouteTables"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/RouteTables"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route Filters"),
		// 				Value: to.Ptr("RouteFilters"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/RouteFilters"),
		// 			Limit: to.Ptr[int64](1000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Watchers"),
		// 				Value: to.Ptr("NetworkWatchers"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/NetworkWatchers"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Packet Captures"),
		// 				Value: to.Ptr("PacketCaptures"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/PacketCaptures"),
		// 			Limit: to.Ptr[int64](10),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("DNS servers per Virtual Network"),
		// 				Value: to.Ptr("DnsServersPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/DnsServersPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](9),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Subnets per Virtual Network"),
		// 				Value: to.Ptr("SubnetsPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/SubnetsPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](1000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("IP Configurations per Virtual Network"),
		// 				Value: to.Ptr("IPConfigurationsPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/IPConfigurationsPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](4096),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Peerings per Virtual Network"),
		// 				Value: to.Ptr("PeeringsPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/PeeringsPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](10),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Security rules per Network Security Group"),
		// 				Value: to.Ptr("SecurityRulesPerNetworkSecurityGroup"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/SecurityRulesPerNetworkSecurityGroup"),
		// 			Limit: to.Ptr[int64](200),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Security rules addresses or ports per Network Security Group"),
		// 				Value: to.Ptr("SecurityRuleAddressesOrPortsPerNetworkSecurityGroup"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/SecurityRuleAddressesOrPortsPerNetworkSecurityGroup"),
		// 			Limit: to.Ptr[int64](2000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Inbound Rules per Load Balancer"),
		// 				Value: to.Ptr("InboundRulesPerLoadBalancer"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/InboundRulesPerLoadBalancer"),
		// 			Limit: to.Ptr[int64](150),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Frontend IP Configurations per Load Balancer"),
		// 				Value: to.Ptr("FrontendIPConfigurationPerLoadBalancer"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/FrontendIPConfigurationPerLoadBalancer"),
		// 			Limit: to.Ptr[int64](10),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Outbound Rules per Load Balancer"),
		// 				Value: to.Ptr("outboundRulesPerLoadBalancer"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/outboundRulesPerLoadBalancer"),
		// 			Limit: to.Ptr[int64](5),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Routes per Route Table"),
		// 				Value: to.Ptr("RoutesPerRouteTable"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/RoutesPerRouteTable"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Secondary IP Configurations per Network Interface"),
		// 				Value: to.Ptr("SecondaryIPConfigurationsPerNetworkInterface"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/SecondaryIPConfigurationsPerNetworkInterface"),
		// 			Limit: to.Ptr[int64](256),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Inbound rules per Network Interface"),
		// 				Value: to.Ptr("InboundRulesPerNetworkInterface"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/InboundRulesPerNetworkInterface"),
		// 			Limit: to.Ptr[int64](500),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route filter rules per Route Filter"),
		// 				Value: to.Ptr("RouteFilterRulesPerRouteFilter"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/RouteFilterRulesPerRouteFilter"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route filters per Express route BGP Peering"),
		// 				Value: to.Ptr("RouteFiltersPerExpressRouteBgpPeering"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/westus/usages/RouteFiltersPerExpressRouteBgpPeering"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/UsageListSpacedLocation.json
func ExampleUsagesClient_NewListPager_listUsagesSpacedLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewUsagesClient().NewListPager("West US", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsagesListResult = armnetwork.UsagesListResult{
		// 	Value: []*armnetwork.Usage{
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Virtual Networks"),
		// 				Value: to.Ptr("VirtualNetworks"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](12),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/VirtualNetworks"),
		// 			Limit: to.Ptr[int64](50),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Static Public IP Addresses"),
		// 				Value: to.Ptr("StaticPublicIPAddresses"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](1),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/StaticPublicIPAddresses"),
		// 			Limit: to.Ptr[int64](20),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Security Groups"),
		// 				Value: to.Ptr("NetworkSecurityGroups"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](3),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/NetworkSecurityGroups"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Public IP Addresses"),
		// 				Value: to.Ptr("PublicIPAddresses"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](12),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/PublicIPAddresses"),
		// 			Limit: to.Ptr[int64](60),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Public Ip Prefixes"),
		// 				Value: to.Ptr("PublicIpPrefixes"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/PublicIpPrefixes"),
		// 			Limit: to.Ptr[int64](2147483647),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Interfaces"),
		// 				Value: to.Ptr("NetworkInterfaces"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](2),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/NetworkInterfaces"),
		// 			Limit: to.Ptr[int64](24000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Load Balancers"),
		// 				Value: to.Ptr("LoadBalancers"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/LoadBalancers"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Application Gateways"),
		// 				Value: to.Ptr("ApplicationGateways"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](3),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/ApplicationGateways"),
		// 			Limit: to.Ptr[int64](50),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route Tables"),
		// 				Value: to.Ptr("RouteTables"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](5),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/RouteTables"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route Filters"),
		// 				Value: to.Ptr("RouteFilters"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/RouteFilters"),
		// 			Limit: to.Ptr[int64](1000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Watchers"),
		// 				Value: to.Ptr("NetworkWatchers"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/NetworkWatchers"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Packet Captures"),
		// 				Value: to.Ptr("PacketCaptures"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/PacketCaptures"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Application Security Groups."),
		// 				Value: to.Ptr("ApplicationSecurityGroups"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/ApplicationSecurityGroups"),
		// 			Limit: to.Ptr[int64](500),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("DDoS Protection Plans."),
		// 				Value: to.Ptr("DdosProtectionPlans"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/DdosProtectionPlans"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Service Endpoint Policies"),
		// 				Value: to.Ptr("ServiceEndpointPolicies"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/ServiceEndpointPolicies"),
		// 			Limit: to.Ptr[int64](200),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Network Intent Policies"),
		// 				Value: to.Ptr("NetworkIntentPolicies"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/NetworkIntentPolicies"),
		// 			Limit: to.Ptr[int64](200),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("DNS servers per Virtual Network"),
		// 				Value: to.Ptr("DnsServersPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/DnsServersPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](9),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Subnets per Virtual Network"),
		// 				Value: to.Ptr("SubnetsPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/SubnetsPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](1000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("IP Configurations per Virtual Network"),
		// 				Value: to.Ptr("IPConfigurationsPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/IPConfigurationsPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](16384),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Peerings per Virtual Network"),
		// 				Value: to.Ptr("PeeringsPerVirtualNetwork"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/PeeringsPerVirtualNetwork"),
		// 			Limit: to.Ptr[int64](50),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Security rules per Network Security Group"),
		// 				Value: to.Ptr("SecurityRulesPerNetworkSecurityGroup"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/SecurityRulesPerNetworkSecurityGroup"),
		// 			Limit: to.Ptr[int64](1000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Security rules per Network Intent Policy"),
		// 				Value: to.Ptr("SecurityRulesPerNetworkIntentPolicy"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/SecurityRulesPerNetworkIntentPolicy"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Routes per Network Intent Policy"),
		// 				Value: to.Ptr("RoutesPerNetworkIntentPolicy"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/RoutesPerNetworkIntentPolicy"),
		// 			Limit: to.Ptr[int64](100),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Security rules addresses or ports per Network Security Group"),
		// 				Value: to.Ptr("SecurityRuleAddressesOrPortsPerNetworkSecurityGroup"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/SecurityRuleAddressesOrPortsPerNetworkSecurityGroup"),
		// 			Limit: to.Ptr[int64](2000),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Inbound Rules per Load Balancer"),
		// 				Value: to.Ptr("InboundRulesPerLoadBalancer"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/InboundRulesPerLoadBalancer"),
		// 			Limit: to.Ptr[int64](150),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Frontend IP Configurations per Load Balancer"),
		// 				Value: to.Ptr("FrontendIPConfigurationPerLoadBalancer"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/FrontendIPConfigurationPerLoadBalancer"),
		// 			Limit: to.Ptr[int64](10),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Outbound Rules per Load Balancer"),
		// 				Value: to.Ptr("OutboundRulesPerLoadBalancer"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/OutboundRulesPerLoadBalancer"),
		// 			Limit: to.Ptr[int64](5),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Routes per Route Table"),
		// 				Value: to.Ptr("RoutesPerRouteTable"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/RoutesPerRouteTable"),
		// 			Limit: to.Ptr[int64](400),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Secondary IP Configurations per Network Interface"),
		// 				Value: to.Ptr("SecondaryIPConfigurationsPerNetworkInterface"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/SecondaryIPConfigurationsPerNetworkInterface"),
		// 			Limit: to.Ptr[int64](256),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Inbound rules per Network Interface"),
		// 				Value: to.Ptr("InboundRulesPerNetworkInterface"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/InboundRulesPerNetworkInterface"),
		// 			Limit: to.Ptr[int64](500),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route filter rules per Route Filter"),
		// 				Value: to.Ptr("RouteFilterRulesPerRouteFilter"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/RouteFilterRulesPerRouteFilter"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 		},
		// 		{
		// 			Name: &armnetwork.UsageName{
		// 				LocalizedValue: to.Ptr("Route filters per Express route BGP Peering"),
		// 				Value: to.Ptr("RouteFiltersPerExpressRouteBgpPeering"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/locations/West US/usages/RouteFiltersPerExpressRouteBgpPeering"),
		// 			Limit: to.Ptr[int64](1),
		// 			Unit: to.Ptr(armnetwork.UsageUnitCount),
		// 	}},
		// }
	}
}
