//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnginx

import "time"

// AnalysisCreate - The request body for creating an analysis for an NGINX configuration.
type AnalysisCreate struct {
	// REQUIRED
	Config *AnalysisCreateConfig
}

type AnalysisCreateConfig struct {
	Files          []*ConfigurationFile
	Package        *ConfigurationPackage
	ProtectedFiles []*ConfigurationFile

	// The root file of the NGINX config file(s). It must match one of the files' filepath.
	RootFile *string
}

// AnalysisDiagnostic - An error object found during the analysis of an NGINX configuration.
type AnalysisDiagnostic struct {
	// REQUIRED
	Description *string

	// REQUIRED
	Directive *string

	// REQUIRED; the filepath of the most relevant config file
	File *string

	// REQUIRED
	Line *float32

	// REQUIRED
	Message *string

	// REQUIRED
	Rule *string

	// Unique identifier for the error
	ID *string
}

// AnalysisResult - The response body for an analysis request. Contains the status of the analysis and any errors.
type AnalysisResult struct {
	// REQUIRED; The status of the analysis.
	Status *string
	Data   *AnalysisResultData
}

type AnalysisResultData struct {
	Errors []*AnalysisDiagnostic
}

// AutoUpgradeProfile - Autoupgrade settings of a deployment.
type AutoUpgradeProfile struct {
	// REQUIRED; Channel used for autoupgrade.
	UpgradeChannel *string
}

type Certificate struct {
	Location   *string
	Properties *CertificateProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY
	Type *string
}

type CertificateErrorResponseBody struct {
	Code    *string
	Message *string
}

type CertificateListResponse struct {
	NextLink *string
	Value    []*Certificate
}

type CertificateProperties struct {
	CertificateError       *CertificateErrorResponseBody
	CertificateVirtualPath *string
	KeyVaultSecretID       *string
	KeyVirtualPath         *string

	// READ-ONLY
	KeyVaultSecretCreated *time.Time

	// READ-ONLY
	KeyVaultSecretVersion *string

	// READ-ONLY
	ProvisioningState *ProvisioningState

	// READ-ONLY
	SHA1Thumbprint *string
}

type Configuration struct {
	Location   *string
	Properties *ConfigurationProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY
	Type *string
}

type ConfigurationFile struct {
	Content     *string
	VirtualPath *string
}

// ConfigurationListResponse - Response of a list operation.
type ConfigurationListResponse struct {
	// Link to the next set of results, if any.
	NextLink *string

	// Results of a list operation.
	Value []*Configuration
}

type ConfigurationPackage struct {
	Data           *string
	ProtectedFiles []*string
}

type ConfigurationProperties struct {
	Files          []*ConfigurationFile
	Package        *ConfigurationPackage
	ProtectedFiles []*ConfigurationFile
	RootFile       *string

	// READ-ONLY
	ProvisioningState *ProvisioningState
}

type Deployment struct {
	Identity   *IdentityProperties
	Location   *string
	Properties *DeploymentProperties
	SKU        *ResourceSKU

	// Dictionary of
	Tags map[string]*string

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY
	Type *string
}

type DeploymentListResponse struct {
	NextLink *string
	Value    []*Deployment
}

type DeploymentProperties struct {
	// Autoupgrade settings of a deployment.
	AutoUpgradeProfile       *AutoUpgradeProfile
	EnableDiagnosticsSupport *bool
	Logging                  *Logging

	// The managed resource group to deploy VNet injection related network resources.
	ManagedResourceGroup *string
	NetworkProfile       *NetworkProfile

	// Information on how the deployment will be scaled.
	ScalingProperties *DeploymentScalingProperties
	UserProfile       *DeploymentUserProfile

	// READ-ONLY; The IP address of the deployment.
	IPAddress *string

	// READ-ONLY
	NginxVersion *string

	// READ-ONLY
	ProvisioningState *ProvisioningState
}

// DeploymentScalingProperties - Information on how the deployment will be scaled.
type DeploymentScalingProperties struct {
	// The settings for enabling automatic scaling of the deployment. If this field is specified, 'scale.capacity' must be empty.
	AutoScaleSettings *DeploymentScalingPropertiesAutoScaleSettings
	Capacity          *int32
}

// DeploymentScalingPropertiesAutoScaleSettings - The settings for enabling automatic scaling of the deployment. If this field
// is specified, 'scale.capacity' must be empty.
type DeploymentScalingPropertiesAutoScaleSettings struct {
	// REQUIRED
	Profiles []*ScaleProfile
}

type DeploymentUpdateParameters struct {
	Identity   *IdentityProperties
	Location   *string
	Properties *DeploymentUpdateProperties
	SKU        *ResourceSKU

	// Dictionary of
	Tags map[string]*string
}

type DeploymentUpdateProperties struct {
	// Autoupgrade settings of a deployment.
	AutoUpgradeProfile       *AutoUpgradeProfile
	EnableDiagnosticsSupport *bool
	Logging                  *Logging

	// Information on how the deployment will be scaled.
	ScalingProperties *DeploymentScalingProperties
	UserProfile       *DeploymentUserProfile
}

type DeploymentUserProfile struct {
	// The preferred support contact email address of the user used for sending alerts and notification. Can be an empty string
	// or a valid email address.
	PreferredEmail *string
}

type FrontendIPConfiguration struct {
	PrivateIPAddresses []*PrivateIPAddress
	PublicIPAddresses  []*PublicIPAddress
}

type IdentityProperties struct {
	Type *IdentityType

	// Dictionary of
	UserAssignedIdentities map[string]*UserIdentityProperties

	// READ-ONLY
	PrincipalID *string

	// READ-ONLY
	TenantID *string
}

type Logging struct {
	StorageAccount *StorageAccount
}

type NetworkInterfaceConfiguration struct {
	SubnetID *string
}

type NetworkProfile struct {
	FrontEndIPConfiguration       *FrontendIPConfiguration
	NetworkInterfaceConfiguration *NetworkInterfaceConfiguration
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write deployments'.
	Description *string

	// Operation type, e.g., read, write, delete, etc.
	Operation *string

	// Service provider: Nginx.NginxPlus
	Provider *string

	// Type on which the operation is performed, e.g., 'deployments'.
	Resource *string
}

// OperationListResult - Result of GET request to list Nginx.NginxPlus operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the Nginx.NginxPlus provider.
	Value []*OperationResult
}

// OperationResult - A Nginx.NginxPlus REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

type PrivateIPAddress struct {
	PrivateIPAddress          *string
	PrivateIPAllocationMethod *NginxPrivateIPAllocationMethod
	SubnetID                  *string
}

type PublicIPAddress struct {
	ID *string
}

type ResourceSKU struct {
	// REQUIRED; Name of the SKU.
	Name *string
}

// ScaleProfile - The autoscale profile.
type ScaleProfile struct {
	// REQUIRED; The capacity parameters of the profile.
	Capacity *ScaleProfileCapacity

	// REQUIRED
	Name *string
}

// ScaleProfileCapacity - The capacity parameters of the profile.
type ScaleProfileCapacity struct {
	// REQUIRED; The maximum number of NCUs the deployment can be autoscaled to.
	Max *int32

	// REQUIRED; The minimum number of NCUs the deployment can be autoscaled to.
	Min *int32
}

type StorageAccount struct {
	AccountName   *string
	ContainerName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

type UserIdentityProperties struct {
	// READ-ONLY
	ClientID *string

	// READ-ONLY
	PrincipalID *string
}
