//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
)

// PreRulesServer is a fake server for instances of the armpanngfw.PreRulesClient type.
type PreRulesServer struct {
	// BeginCreateOrUpdate is the fake for method PreRulesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, globalRulestackName string, priority string, resource armpanngfw.PreRulesResource, options *armpanngfw.PreRulesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.PreRulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PreRulesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, globalRulestackName string, priority string, options *armpanngfw.PreRulesClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.PreRulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PreRulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, globalRulestackName string, priority string, options *armpanngfw.PreRulesClientGetOptions) (resp azfake.Responder[armpanngfw.PreRulesClientGetResponse], errResp azfake.ErrorResponder)

	// GetCounters is the fake for method PreRulesClient.GetCounters
	// HTTP status codes to indicate success: http.StatusOK
	GetCounters func(ctx context.Context, globalRulestackName string, priority string, options *armpanngfw.PreRulesClientGetCountersOptions) (resp azfake.Responder[armpanngfw.PreRulesClientGetCountersResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PreRulesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(globalRulestackName string, options *armpanngfw.PreRulesClientListOptions) (resp azfake.PagerResponder[armpanngfw.PreRulesClientListResponse])

	// RefreshCounters is the fake for method PreRulesClient.RefreshCounters
	// HTTP status codes to indicate success: http.StatusNoContent
	RefreshCounters func(ctx context.Context, globalRulestackName string, priority string, options *armpanngfw.PreRulesClientRefreshCountersOptions) (resp azfake.Responder[armpanngfw.PreRulesClientRefreshCountersResponse], errResp azfake.ErrorResponder)

	// ResetCounters is the fake for method PreRulesClient.ResetCounters
	// HTTP status codes to indicate success: http.StatusOK
	ResetCounters func(ctx context.Context, globalRulestackName string, priority string, options *armpanngfw.PreRulesClientResetCountersOptions) (resp azfake.Responder[armpanngfw.PreRulesClientResetCountersResponse], errResp azfake.ErrorResponder)
}

// NewPreRulesServerTransport creates a new instance of PreRulesServerTransport with the provided implementation.
// The returned PreRulesServerTransport instance is connected to an instance of armpanngfw.PreRulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPreRulesServerTransport(srv *PreRulesServer) *PreRulesServerTransport {
	return &PreRulesServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armpanngfw.PreRulesClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armpanngfw.PreRulesClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armpanngfw.PreRulesClientListResponse]](),
	}
}

// PreRulesServerTransport connects instances of armpanngfw.PreRulesClient to instances of PreRulesServer.
// Don't use this type directly, use NewPreRulesServerTransport instead.
type PreRulesServerTransport struct {
	srv                 *PreRulesServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armpanngfw.PreRulesClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armpanngfw.PreRulesClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armpanngfw.PreRulesClientListResponse]]
}

// Do implements the policy.Transporter interface for PreRulesServerTransport.
func (p *PreRulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PreRulesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PreRulesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PreRulesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PreRulesClient.GetCounters":
		resp, err = p.dispatchGetCounters(req)
	case "PreRulesClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	case "PreRulesClient.RefreshCounters":
		resp, err = p.dispatchRefreshCounters(req)
	case "PreRulesClient.ResetCounters":
		resp, err = p.dispatchResetCounters(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PreRulesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules/(?P<priority>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.PreRulesResource](req)
		if err != nil {
			return nil, err
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		priorityParam, err := url.PathUnescape(matches[regex.SubexpIndex("priority")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), globalRulestackNameParam, priorityParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PreRulesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules/(?P<priority>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		priorityParam, err := url.PathUnescape(matches[regex.SubexpIndex("priority")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), globalRulestackNameParam, priorityParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PreRulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules/(?P<priority>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	priorityParam, err := url.PathUnescape(matches[regex.SubexpIndex("priority")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), globalRulestackNameParam, priorityParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PreRulesResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PreRulesServerTransport) dispatchGetCounters(req *http.Request) (*http.Response, error) {
	if p.srv.GetCounters == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCounters not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules/(?P<priority>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getCounters`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	priorityParam, err := url.PathUnescape(matches[regex.SubexpIndex("priority")])
	if err != nil {
		return nil, err
	}
	firewallNameUnescaped, err := url.QueryUnescape(qp.Get("firewallName"))
	if err != nil {
		return nil, err
	}
	firewallNameParam := getOptional(firewallNameUnescaped)
	var options *armpanngfw.PreRulesClientGetCountersOptions
	if firewallNameParam != nil {
		options = &armpanngfw.PreRulesClientGetCountersOptions{
			FirewallName: firewallNameParam,
		}
	}
	respr, errRespr := p.srv.GetCounters(req.Context(), globalRulestackNameParam, priorityParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RuleCounter, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PreRulesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(globalRulestackNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpanngfw.PreRulesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}

func (p *PreRulesServerTransport) dispatchRefreshCounters(req *http.Request) (*http.Response, error) {
	if p.srv.RefreshCounters == nil {
		return nil, &nonRetriableError{errors.New("fake for method RefreshCounters not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules/(?P<priority>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/refreshCounters`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	priorityParam, err := url.PathUnescape(matches[regex.SubexpIndex("priority")])
	if err != nil {
		return nil, err
	}
	firewallNameUnescaped, err := url.QueryUnescape(qp.Get("firewallName"))
	if err != nil {
		return nil, err
	}
	firewallNameParam := getOptional(firewallNameUnescaped)
	var options *armpanngfw.PreRulesClientRefreshCountersOptions
	if firewallNameParam != nil {
		options = &armpanngfw.PreRulesClientRefreshCountersOptions{
			FirewallName: firewallNameParam,
		}
	}
	respr, errRespr := p.srv.RefreshCounters(req.Context(), globalRulestackNameParam, priorityParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PreRulesServerTransport) dispatchResetCounters(req *http.Request) (*http.Response, error) {
	if p.srv.ResetCounters == nil {
		return nil, &nonRetriableError{errors.New("fake for method ResetCounters not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/preRules/(?P<priority>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetCounters`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	priorityParam, err := url.PathUnescape(matches[regex.SubexpIndex("priority")])
	if err != nil {
		return nil, err
	}
	firewallNameUnescaped, err := url.QueryUnescape(qp.Get("firewallName"))
	if err != nil {
		return nil, err
	}
	firewallNameParam := getOptional(firewallNameUnescaped)
	var options *armpanngfw.PreRulesClientResetCountersOptions
	if firewallNameParam != nil {
		options = &armpanngfw.PreRulesClientResetCountersOptions{
			FirewallName: firewallNameParam,
		}
	}
	respr, errRespr := p.srv.ResetCounters(req.Context(), globalRulestackNameParam, priorityParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RuleCounterReset, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
