//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpostgresqlflexibleservers_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresql/armpostgresqlflexibleservers/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/preview/2023-12-01-preview/examples/ConfigurationListByServer.json
func ExampleConfigurationsClient_NewListByServerPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlflexibleservers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConfigurationsClient().NewListByServerPager("testrg", "testserver", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConfigurationListResult = armpostgresqlflexibleservers.ConfigurationListResult{
		// 	Value: []*armpostgresqlflexibleservers.Configuration{
		// 		{
		// 			Name: to.Ptr("application_name"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/application_name"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the application name to be reported in statistics and logs."),
		// 				AllowedValues: to.Ptr("[A-Za-z0-9._-]*"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr(""),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr(""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("array_nulls"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/array_nulls"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables input of NULL elements in arrays."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Starts the autovacuum subprocess."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_analyze_scale_factor"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_analyze_scale_factor"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Number of tuple inserts, updates, or deletes prior to analyze as a fraction of reltuples."),
		// 				AllowedValues: to.Ptr("0-100"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_analyze_threshold"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_analyze_threshold"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Minimum number of tuple inserts, updates, or deletes prior to analyze."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("50"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("50"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_naptime"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_naptime"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Time to sleep between autovacuum runs."),
		// 				AllowedValues: to.Ptr("1-2147483"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("60"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("60"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_vacuum_cost_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_vacuum_cost_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost delay in milliseconds, for autovacuum."),
		// 				AllowedValues: to.Ptr("-1-100"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_vacuum_cost_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_vacuum_cost_limit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost amount available before napping, for autovacuum."),
		// 				AllowedValues: to.Ptr("-1-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("-1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_vacuum_scale_factor"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_vacuum_scale_factor"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Number of tuple updates or deletes prior to vacuum as a fraction of reltuples."),
		// 				AllowedValues: to.Ptr("0-100"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_vacuum_threshold"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_vacuum_threshold"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Minimum number of tuple updates or deletes prior to vacuum."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("50"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("50"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("autovacuum_work_mem"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/autovacuum_work_mem"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum memory to be used by each autovacuum worker process."),
		// 				AllowedValues: to.Ptr("-1-2097151"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("-1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("backend_flush_after"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/backend_flush_after"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Number of pages after which previously performed writes are flushed to disk."),
		// 				AllowedValues: to.Ptr("0-256"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("backslash_quote"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/backslash_quote"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets whether \"\\'\" is allowed in string literals."),
		// 				AllowedValues: to.Ptr("safe_encoding,on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("safe_encoding"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("safe_encoding"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("bgwriter_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/bgwriter_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Background writer sleep time between rounds."),
		// 				AllowedValues: to.Ptr("10-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("200"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("200"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("bgwriter_flush_after"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/bgwriter_flush_after"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Number of pages after which previously performed writes are flushed to disk."),
		// 				AllowedValues: to.Ptr("0-256"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("64"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("bgwriter_lru_maxpages"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/bgwriter_lru_maxpages"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Background writer maximum number of LRU pages to flush per round."),
		// 				AllowedValues: to.Ptr("0-1073741823"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("100"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("100"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("bgwriter_lru_multiplier"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/bgwriter_lru_multiplier"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Multiple of the average buffer usage to free per round."),
		// 				AllowedValues: to.Ptr("0-10"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("bytea_output"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/bytea_output"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the output format for bytea."),
		// 				AllowedValues: to.Ptr("escape,hex"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("hex"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("hex"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("check_function_bodies"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/check_function_bodies"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Checks function bodies during CREATE FUNCTION."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("checkpoint_completion_target"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/checkpoint_completion_target"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Time spent flushing dirty buffers during checkpoint, as fraction of checkpoint interval."),
		// 				AllowedValues: to.Ptr("0-1"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.5"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.5"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("checkpoint_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/checkpoint_timeout"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum time between automatic WAL checkpoints."),
		// 				AllowedValues: to.Ptr("30-86400"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("300"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("300"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("checkpoint_warning"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/checkpoint_warning"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables warnings if checkpoint segments are filled more frequently than this."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("30"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("30"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("client_encoding"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/client_encoding"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the client's character set encoding."),
		// 				AllowedValues: to.Ptr("BIG5,EUC_CN,EUC_JP,EUC_JIS_2004,EUC_KR,EUC_TW,GB18030,GBK,ISO_8859_5,ISO_8859_6,ISO_8859_7,ISO_8859_8,JOHAB,KOI8R,KOI8U,LATIN1,LATIN2,LATIN3,LATIN4,LATIN5,LATIN6,LATIN7,LATIN8,LATIN9,LATIN10,MULE_INTERNAL,SJIS,SHIFT_JIS_2004,SQL_ASCII,UHC,UTF8,WIN866,WIN874,WIN1250,WIN1251,WIN1252,WIN1253,WIN1254,WIN1255,WIN1256,WIN1257,WIN1258"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("sql_ascii"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("sql_ascii"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("client_min_messages"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/client_min_messages"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the message levels that are sent to the client."),
		// 				AllowedValues: to.Ptr("debug5,debug4,debug3,debug2,debug1,log,notice,warning,error"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("notice"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("notice"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("commit_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/commit_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the delay in microseconds between transaction commit and flushing WAL to disk."),
		// 				AllowedValues: to.Ptr("0-100000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("commit_siblings"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/commit_siblings"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum concurrent open transactions before performing commit_delay."),
		// 				AllowedValues: to.Ptr("0-1000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("5"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("5"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("constraint_exclusion"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/constraint_exclusion"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner to use constraints to optimize queries."),
		// 				AllowedValues: to.Ptr("partition,on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("partition"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("partition"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu_index_tuple_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/cpu_index_tuple_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of processing each index entry during an index scan."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.005"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.005"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu_operator_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/cpu_operator_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of processing each operator or function call."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.0025"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.0025"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cpu_tuple_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/cpu_tuple_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of processing each tuple (row)."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.01"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.01"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("cursor_tuple_fraction"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/cursor_tuple_fraction"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the fraction of a cursor's rows that will be retrieved."),
		// 				AllowedValues: to.Ptr("0-1"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("DateStyle"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/DateStyle"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the display format for date and time values."),
		// 				AllowedValues: to.Ptr("(ISO|POSTGRES|SQL|GERMAN)(, (DMY|MDY|YMD))?"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr("ISO, MDY"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("ISO, MDY"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("deadlock_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/deadlock_timeout"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the amount of time, in milliseconds, to wait on a lock before checking for deadlock."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("1000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_pretty_print"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/debug_pretty_print"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Indents parse and plan tree displays."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_print_parse"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/debug_print_parse"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each query's parse tree."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_print_plan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/debug_print_plan"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each query's execution plan."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("debug_print_rewritten"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/debug_print_rewritten"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each query's rewritten parse tree."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_statistics_target"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_statistics_target"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default statistics target."),
		// 				AllowedValues: to.Ptr("1-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("100"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("100"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_tablespace"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_tablespace"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default tablespace to create tables and indexes in."),
		// 				AllowedValues: to.Ptr("[A-Za-z._]*"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr(""),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr(""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_text_search_config"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_text_search_config"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets default text search configuration."),
		// 				AllowedValues: to.Ptr("[A-Za-z._]+"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr("pg_catalog.english"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("pg_catalog.english"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_transaction_deferrable"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_transaction_deferrable"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default deferrable status of new transactions."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_transaction_isolation"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_transaction_isolation"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the transaction isolation level of each new transaction."),
		// 				AllowedValues: to.Ptr("serializable,repeatable read,read committed,read uncommitted"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("read committed"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("read committed"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_transaction_read_only"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_transaction_read_only"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the default read-only status of new transactions."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("default_with_oids"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/default_with_oids"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Creates new tables with OIDs by default."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("effective_cache_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/effective_cache_size"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's assumption about the size of the disk cache."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("3145728"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("3145728"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_bitmapscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_bitmapscan"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of bitmap-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_gathermerge"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_gathermerge"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of gather merge plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_hashagg"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_hashagg"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of hashed aggregation plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_hashjoin"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_hashjoin"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of hash join plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_indexonlyscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_indexonlyscan"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of index-only-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_indexscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_indexscan"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of index-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_material"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_material"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of materialization."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_mergejoin"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_mergejoin"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of merge join plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_nestloop"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_nestloop"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of nested loop join plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_seqscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_seqscan"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of sequential-scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_sort"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_sort"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of explicit sort steps."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("enable_tidscan"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/enable_tidscan"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables the planner's use of TID scan plans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("escape_string_warning"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/escape_string_warning"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Warns about backslash escapes in ordinary string literals."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("exit_on_error"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/exit_on_error"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Terminates session on any error."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("extra_float_digits"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/extra_float_digits"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the number of digits displayed for floating-point values."),
		// 				AllowedValues: to.Ptr("-15-3"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("force_parallel_mode"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/force_parallel_mode"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Forces use of parallel query facilities."),
		// 				AllowedValues: to.Ptr("off,on,regress"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("from_collapse_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/from_collapse_limit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the FROM-list size beyond which subqueries are not collapsed."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables genetic query optimization."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_effort"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo_effort"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: effort is used to set the default for other GEQO parameters."),
		// 				AllowedValues: to.Ptr("1-10"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("5"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("5"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_generations"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo_generations"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: number of iterations of the algorithm."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_pool_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo_pool_size"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: number of individuals in the population."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_seed"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo_seed"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: seed for random path selection."),
		// 				AllowedValues: to.Ptr("0-1"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_selection_bias"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo_selection_bias"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("GEQO: selective pressure within the population."),
		// 				AllowedValues: to.Ptr("1.5-2"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("geqo_threshold"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/geqo_threshold"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the threshold of FROM items beyond which GEQO is used."),
		// 				AllowedValues: to.Ptr("2-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("12"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("12"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("gin_fuzzy_search_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/gin_fuzzy_search_limit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed result for exact search by GIN."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("gin_pending_list_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/gin_pending_list_limit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum size of the pending list for GIN index."),
		// 				AllowedValues: to.Ptr("64-2097151"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("4096"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("4096"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("idle_in_transaction_session_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/idle_in_transaction_session_timeout"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed duration of any idling transaction."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("IntervalStyle"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/IntervalStyle"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the display format for interval values."),
		// 				AllowedValues: to.Ptr("postgres,postgres_verbose,sql_standard,iso_8601"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("postgres"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("postgres"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("join_collapse_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/join_collapse_limit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the FROM-list size beyond which JOIN constructs are not flattened."),
		// 				AllowedValues: to.Ptr("1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("lc_monetary"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/lc_monetary"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the locale for formatting monetary amounts."),
		// 				AllowedValues: to.Ptr("[A-Za-z0-9._ -]+"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr("en_US.utf-8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("en_US.utf-8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("lc_numeric"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/lc_numeric"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the locale for formatting numbers."),
		// 				AllowedValues: to.Ptr("[A-Za-z0-9._ -]+"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr("en_US.utf-8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("en_US.utf-8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("lo_compat_privileges"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/lo_compat_privileges"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables backward compatibility mode for privilege checks on large objects."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("lock_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/lock_timeout"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed duration (in milliseconds) of any wait for a lock. 0 turns this off."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_autovacuum_min_duration"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_autovacuum_min_duration"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum execution time above which autovacuum actions will be logged."),
		// 				AllowedValues: to.Ptr("-1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("-1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_checkpoints"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_checkpoints"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each checkpoint."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_connections"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_connections"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each successful connection."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_destination"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_destination"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the destination for server log output."),
		// 				AllowedValues: to.Ptr("stderr,csvlog"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("stderr"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("stderr"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_disconnections"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_disconnections"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs end of a session, including duration."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_duration"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_duration"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs the duration of each completed SQL statement."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_error_verbosity"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_error_verbosity"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the verbosity of logged messages."),
		// 				AllowedValues: to.Ptr("terse,default,verbose"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("default"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("default"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_lock_waits"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_lock_waits"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs long lock waits."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_min_duration_statement"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_min_duration_statement"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum execution time (in milliseconds) above which statements will be logged. -1 disables logging statement durations."),
		// 				AllowedValues: to.Ptr("-1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("-1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_min_error_statement"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_min_error_statement"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Causes all statements generating error at or above this level to be logged."),
		// 				AllowedValues: to.Ptr("debug5,debug4,debug3,debug2,debug1,info,notice,warning,error,log,fatal,panic"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("error"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("error"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_min_messages"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_min_messages"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the message levels that are logged."),
		// 				AllowedValues: to.Ptr("debug5,debug4,debug3,debug2,debug1,info,notice,warning,error,log,fatal,panic"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("warning"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("warning"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_replication_commands"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_replication_commands"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs each replication command."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_statement"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_statement"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the type of statements logged."),
		// 				AllowedValues: to.Ptr("none,ddl,mod,all"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("none"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("none"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_statement_stats"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_statement_stats"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("For each query, writes cumulative performance statistics to the server log."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("log_temp_files"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/log_temp_files"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Logs the use of temporary files larger than this number of kilobytes."),
		// 				AllowedValues: to.Ptr("-1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("-1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("maintenance_work_mem"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/maintenance_work_mem"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum memory to be used for maintenance operations."),
		// 				AllowedValues: to.Ptr("1024-2097151"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("332800"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("332800"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_parallel_workers"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_parallel_workers"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of parallel workers than can be active at one time."),
		// 				AllowedValues: to.Ptr("0-1024"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("8"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("8"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_parallel_workers_per_gather"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_parallel_workers_per_gather"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of parallel processes per executor node."),
		// 				AllowedValues: to.Ptr("0-1024"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_pred_locks_per_page"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_pred_locks_per_page"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of predicate-locked tuples per page."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_pred_locks_per_relation"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_pred_locks_per_relation"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of predicate-locked pages and tuples per relation."),
		// 				AllowedValues: to.Ptr("-2147483648-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("-2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("-2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_standby_archive_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_standby_archive_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum delay before canceling queries when a hot standby server is processing archived WAL data."),
		// 				AllowedValues: to.Ptr("-1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("30000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("30000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_standby_streaming_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_standby_streaming_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum delay before canceling queries when a hot standby server is processing streamed WAL data."),
		// 				AllowedValues: to.Ptr("-1-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("30000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("30000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_sync_workers_per_subscription"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_sync_workers_per_subscription"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Maximum number of table synchronization workers per subscription."),
		// 				AllowedValues: to.Ptr("0-262143"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("2"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("2"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("max_wal_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/max_wal_size"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the WAL size that triggers a checkpoint."),
		// 				AllowedValues: to.Ptr("2-2097151"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("1024"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1024"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("min_parallel_index_scan_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/min_parallel_index_scan_size"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum amount of index data for a parallel scan."),
		// 				AllowedValues: to.Ptr("0-715827882"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("64"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("min_parallel_table_scan_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/min_parallel_table_scan_size"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum amount of table data for a parallel scan."),
		// 				AllowedValues: to.Ptr("0-715827882"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("1024"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1024"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("min_wal_size"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/min_wal_size"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the minimum size to shrink the WAL to."),
		// 				AllowedValues: to.Ptr("2-2097151"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("80"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("80"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("operator_precedence_warning"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/operator_precedence_warning"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Emits a warning for constructs that changed meaning since PostgreSQL 9.4."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("parallel_setup_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/parallel_setup_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of starting up worker processes for parallel query."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("1000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("parallel_tuple_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/parallel_tuple_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of passing each tuple (row) from worker to master backend."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("0.1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0.1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("quote_all_identifiers"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/quote_all_identifiers"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("When generating SQL fragments, quotes all identifiers."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("random_page_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/random_page_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of a nonsequentially fetched disk page."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("4"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("4"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("row_security"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/row_security"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables row security."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("search_path"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/search_path"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the schema search order for names that are not schema-qualified."),
		// 				AllowedValues: to.Ptr("[A-Za-z.\"$, ]+"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr("\"$user\", public"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("\"$user\", public"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("seq_page_cost"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/seq_page_cost"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the planner's estimate of the cost of a sequentially fetched disk page."),
		// 				AllowedValues: to.Ptr("0-1.79769e+308"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeNumeric),
		// 				DefaultValue: to.Ptr("1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("session_replication_role"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/session_replication_role"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the session's behavior for triggers and rewrite rules."),
		// 				AllowedValues: to.Ptr("origin,replica,local"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("origin"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("origin"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("standard_conforming_strings"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/standard_conforming_strings"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Causes '...' strings to treat backslashes literally."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("statement_timeout"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/statement_timeout"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum allowed duration (in milliseconds) of any statement. 0 turns this off."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("synchronize_seqscans"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/synchronize_seqscans"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Enables synchronized sequential scans."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("synchronous_commit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/synchronous_commit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the current transaction's synchronization level."),
		// 				AllowedValues: to.Ptr("local,remote_write,on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("tcp_keepalives_count"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/tcp_keepalives_count"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Maximum number of TCP keepalive retransmits."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("9"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("9"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("tcp_keepalives_idle"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/tcp_keepalives_idle"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Time between issuing TCP keepalives."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("120"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("120"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("tcp_keepalives_interval"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/tcp_keepalives_interval"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Time between TCP keepalive retransmits."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("30"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("30"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("temp_buffers"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/temp_buffers"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum number of temporary buffers used by each database session."),
		// 				AllowedValues: to.Ptr("100-1073741823"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("1024"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1024"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("temp_tablespaces"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/temp_tablespaces"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the tablespace(s) to use for temporary tables and sort files."),
		// 				AllowedValues: to.Ptr("[A-Za-z._]*"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr(""),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr(""),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("TimeZone"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/TimeZone"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the time zone for displaying and interpreting time stamps."),
		// 				AllowedValues: to.Ptr("[A-Za-z0-9/+_-]+"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataType("String")),
		// 				DefaultValue: to.Ptr("UTC"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("UTC"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("track_activities"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/track_activities"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Collects information about executing commands."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("track_counts"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/track_counts"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Collects statistics on database activity."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("on"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("on"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("track_functions"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/track_functions"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Collects function-level statistics on database activity."),
		// 				AllowedValues: to.Ptr("none,pl,all"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("none"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("none"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("track_io_timing"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/track_io_timing"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Collects timing statistics for database I/O activity."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("transform_null_equals"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/transform_null_equals"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Treats \"expr=NULL\" as \"expr IS NULL\"."),
		// 				AllowedValues: to.Ptr("on,off"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
		// 				DefaultValue: to.Ptr("off"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("off"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_cost_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_cost_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost delay in milliseconds."),
		// 				AllowedValues: to.Ptr("0-100"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_cost_limit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_cost_limit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost amount available before napping."),
		// 				AllowedValues: to.Ptr("1-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("200"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("200"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_cost_page_dirty"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_cost_page_dirty"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost for a page dirtied by vacuum."),
		// 				AllowedValues: to.Ptr("0-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("20"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("20"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_cost_page_hit"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_cost_page_hit"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost for a page found in the buffer cache."),
		// 				AllowedValues: to.Ptr("0-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("1"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_cost_page_miss"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_cost_page_miss"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Vacuum cost for a page not found in the buffer cache."),
		// 				AllowedValues: to.Ptr("0-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("10"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("10"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_defer_cleanup_age"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_defer_cleanup_age"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Number of transactions by which VACUUM and HOT cleanup should be deferred, if any."),
		// 				AllowedValues: to.Ptr("0-1000000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("0"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_freeze_min_age"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_freeze_min_age"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Minimum age at which VACUUM should freeze a table row."),
		// 				AllowedValues: to.Ptr("0-1000000000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("50000000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("50000000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_freeze_table_age"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_freeze_table_age"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Age at which VACUUM should scan whole table to freeze tuples."),
		// 				AllowedValues: to.Ptr("0-2000000000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("150000000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("150000000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_multixact_freeze_min_age"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_multixact_freeze_min_age"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Minimum age at which VACUUM should freeze a MultiXactId in a table row."),
		// 				AllowedValues: to.Ptr("0-1000000000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("5000000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("5000000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vacuum_multixact_freeze_table_age"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/vacuum_multixact_freeze_table_age"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Multixact age at which VACUUM should scan whole table to freeze tuples."),
		// 				AllowedValues: to.Ptr("0-2000000000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("150000000"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("150000000"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("wal_receiver_status_interval"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/wal_receiver_status_interval"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the maximum interval between WAL receiver status reports to the primary."),
		// 				AllowedValues: to.Ptr("0-2147483"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("10"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("10"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("wal_writer_delay"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/wal_writer_delay"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Time between WAL flushes performed in the WAL writer."),
		// 				AllowedValues: to.Ptr("1-10000"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("200"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("200"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("wal_writer_flush_after"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/wal_writer_flush_after"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Amount of WAL written out by WAL writer that triggers a flush."),
		// 				AllowedValues: to.Ptr("0-2147483647"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("128"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("128"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("work_mem"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/work_mem"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets the amount of memory to be used by internal sort operations and hash tables before writing to temporary disk files."),
		// 				AllowedValues: to.Ptr("4096-2097151"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeInteger),
		// 				DefaultValue: to.Ptr("115712"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("115712"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("xmlbinary"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/xmlbinary"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets how binary values are to be encoded in XML."),
		// 				AllowedValues: to.Ptr("base64,hex"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("base64"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("base64"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("xmloption"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/xmloption"),
		// 			Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
		// 				Description: to.Ptr("Sets whether XML data in implicit parsing and serialization operations is to be considered as documents or content fragments."),
		// 				AllowedValues: to.Ptr("content,document"),
		// 				DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
		// 				DefaultValue: to.Ptr("content"),
		// 				Source: to.Ptr("system-default"),
		// 				Value: to.Ptr("content"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/preview/2023-12-01-preview/examples/ConfigurationGet.json
func ExampleConfigurationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlflexibleservers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConfigurationsClient().Get(ctx, "testrg", "testserver", "array_nulls", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Configuration = armpostgresqlflexibleservers.Configuration{
	// 	Name: to.Ptr("array_nulls"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/array_nulls"),
	// 	Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
	// 		Description: to.Ptr("Enable input of NULL elements in arrays."),
	// 		AllowedValues: to.Ptr("on,off"),
	// 		DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeBoolean),
	// 		DefaultValue: to.Ptr("on"),
	// 		Source: to.Ptr("system-default"),
	// 		Value: to.Ptr("on"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/postgresql/resource-manager/Microsoft.DBforPostgreSQL/preview/2023-12-01-preview/examples/ConfigurationUpdate.json
func ExampleConfigurationsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlflexibleservers.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewConfigurationsClient().BeginUpdate(ctx, "testrg", "testserver", "event_scheduler", armpostgresqlflexibleservers.ConfigurationForUpdate{
		Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
			Source: to.Ptr("user-override"),
			Value:  to.Ptr("on"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Configuration = armpostgresqlflexibleservers.Configuration{
	// 	Name: to.Ptr("event_scheduler"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/flexibleServers/configurations"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBforPostgreSQL/flexibleServers/testserver/configurations/event_scheduler"),
	// 	Properties: &armpostgresqlflexibleservers.ConfigurationProperties{
	// 		Description: to.Ptr("Indicates the status of the Event Scheduler."),
	// 		AllowedValues: to.Ptr("ON,OFF,DISABLED"),
	// 		DataType: to.Ptr(armpostgresqlflexibleservers.ConfigurationDataTypeEnumeration),
	// 		DefaultValue: to.Ptr("OFF"),
	// 		Source: to.Ptr("user-override"),
	// 		Value: to.Ptr("ON"),
	// 	},
	// }
}
