//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/quota/armquota"
	"net/http"
	"net/url"
	"regexp"
)

// GroupQuotaSubscriptionRequestsServer is a fake server for instances of the armquota.GroupQuotaSubscriptionRequestsClient type.
type GroupQuotaSubscriptionRequestsServer struct {
	// Get is the fake for method GroupQuotaSubscriptionRequestsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, managementGroupID string, groupQuotaName string, requestID string, options *armquota.GroupQuotaSubscriptionRequestsClientGetOptions) (resp azfake.Responder[armquota.GroupQuotaSubscriptionRequestsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method GroupQuotaSubscriptionRequestsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(managementGroupID string, groupQuotaName string, options *armquota.GroupQuotaSubscriptionRequestsClientListOptions) (resp azfake.PagerResponder[armquota.GroupQuotaSubscriptionRequestsClientListResponse])
}

// NewGroupQuotaSubscriptionRequestsServerTransport creates a new instance of GroupQuotaSubscriptionRequestsServerTransport with the provided implementation.
// The returned GroupQuotaSubscriptionRequestsServerTransport instance is connected to an instance of armquota.GroupQuotaSubscriptionRequestsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGroupQuotaSubscriptionRequestsServerTransport(srv *GroupQuotaSubscriptionRequestsServer) *GroupQuotaSubscriptionRequestsServerTransport {
	return &GroupQuotaSubscriptionRequestsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armquota.GroupQuotaSubscriptionRequestsClientListResponse]](),
	}
}

// GroupQuotaSubscriptionRequestsServerTransport connects instances of armquota.GroupQuotaSubscriptionRequestsClient to instances of GroupQuotaSubscriptionRequestsServer.
// Don't use this type directly, use NewGroupQuotaSubscriptionRequestsServerTransport instead.
type GroupQuotaSubscriptionRequestsServerTransport struct {
	srv          *GroupQuotaSubscriptionRequestsServer
	newListPager *tracker[azfake.PagerResponder[armquota.GroupQuotaSubscriptionRequestsClientListResponse]]
}

// Do implements the policy.Transporter interface for GroupQuotaSubscriptionRequestsServerTransport.
func (g *GroupQuotaSubscriptionRequestsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GroupQuotaSubscriptionRequestsClient.Get":
		resp, err = g.dispatchGet(req)
	case "GroupQuotaSubscriptionRequestsClient.NewListPager":
		resp, err = g.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GroupQuotaSubscriptionRequestsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if g.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Quota/groupQuotas/(?P<groupQuotaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptionRequests/(?P<requestId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	groupQuotaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupQuotaName")])
	if err != nil {
		return nil, err
	}
	requestIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Get(req.Context(), managementGroupIDParam, groupQuotaNameParam, requestIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GroupQuotaSubscriptionRequestStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GroupQuotaSubscriptionRequestsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if g.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := g.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Quota/groupQuotas/(?P<groupQuotaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subscriptionRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		groupQuotaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupQuotaName")])
		if err != nil {
			return nil, err
		}
		resp := g.srv.NewListPager(managementGroupIDParam, groupQuotaNameParam, nil)
		newListPager = &resp
		g.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armquota.GroupQuotaSubscriptionRequestsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		g.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		g.newListPager.remove(req)
	}
	return resp, nil
}
