//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GroupQuotaSubscriptionRequestsClient contains the methods for the GroupQuotaSubscriptionRequests group.
// Don't use this type directly, use NewGroupQuotaSubscriptionRequestsClient() instead.
type GroupQuotaSubscriptionRequestsClient struct {
	internal *arm.Client
}

// NewGroupQuotaSubscriptionRequestsClient creates a new instance of GroupQuotaSubscriptionRequestsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGroupQuotaSubscriptionRequestsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GroupQuotaSubscriptionRequestsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GroupQuotaSubscriptionRequestsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get API to check the status of a subscriptionIds request by requestId. Use the polling API - OperationsStatus URI
// specified in Azure-AsyncOperation header field, with retry-after duration in seconds
// to check the intermediate status. This API provides the finals status with the request details and status.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - requestID - Request Id.
//   - options - GroupQuotaSubscriptionRequestsClientGetOptions contains the optional parameters for the GroupQuotaSubscriptionRequestsClient.Get
//     method.
func (client *GroupQuotaSubscriptionRequestsClient) Get(ctx context.Context, managementGroupID string, groupQuotaName string, requestID string, options *GroupQuotaSubscriptionRequestsClientGetOptions) (GroupQuotaSubscriptionRequestsClientGetResponse, error) {
	var err error
	const operationName = "GroupQuotaSubscriptionRequestsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, managementGroupID, groupQuotaName, requestID, options)
	if err != nil {
		return GroupQuotaSubscriptionRequestsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GroupQuotaSubscriptionRequestsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GroupQuotaSubscriptionRequestsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GroupQuotaSubscriptionRequestsClient) getCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, requestID string, options *GroupQuotaSubscriptionRequestsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests/{requestId}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if requestID == "" {
		return nil, errors.New("parameter requestID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{requestId}", url.PathEscape(requestID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GroupQuotaSubscriptionRequestsClient) getHandleResponse(resp *http.Response) (GroupQuotaSubscriptionRequestsClientGetResponse, error) {
	result := GroupQuotaSubscriptionRequestsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GroupQuotaSubscriptionRequestStatus); err != nil {
		return GroupQuotaSubscriptionRequestsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List API to check the status of a subscriptionId requests by requestId. Request history is maintained for
// 1 year.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - options - GroupQuotaSubscriptionRequestsClientListOptions contains the optional parameters for the GroupQuotaSubscriptionRequestsClient.NewListPager
//     method.
func (client *GroupQuotaSubscriptionRequestsClient) NewListPager(managementGroupID string, groupQuotaName string, options *GroupQuotaSubscriptionRequestsClientListOptions) *runtime.Pager[GroupQuotaSubscriptionRequestsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GroupQuotaSubscriptionRequestsClientListResponse]{
		More: func(page GroupQuotaSubscriptionRequestsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GroupQuotaSubscriptionRequestsClientListResponse) (GroupQuotaSubscriptionRequestsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GroupQuotaSubscriptionRequestsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, managementGroupID, groupQuotaName, options)
			}, nil)
			if err != nil {
				return GroupQuotaSubscriptionRequestsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GroupQuotaSubscriptionRequestsClient) listCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, options *GroupQuotaSubscriptionRequestsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/subscriptionRequests"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GroupQuotaSubscriptionRequestsClient) listHandleResponse(resp *http.Response) (GroupQuotaSubscriptionRequestsClientListResponse, error) {
	result := GroupQuotaSubscriptionRequestsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GroupQuotaSubscriptionRequestStatusList); err != nil {
		return GroupQuotaSubscriptionRequestsClientListResponse{}, err
	}
	return result, nil
}
