//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// DefenderForStorageServer is a fake server for instances of the armsecurity.DefenderForStorageClient type.
type DefenderForStorageServer struct {
	// Create is the fake for method DefenderForStorageClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceID string, settingName armsecurity.SettingName, defenderForStorageSetting armsecurity.DefenderForStorageSetting, options *armsecurity.DefenderForStorageClientCreateOptions) (resp azfake.Responder[armsecurity.DefenderForStorageClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DefenderForStorageClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceID string, settingName armsecurity.SettingName, options *armsecurity.DefenderForStorageClientGetOptions) (resp azfake.Responder[armsecurity.DefenderForStorageClientGetResponse], errResp azfake.ErrorResponder)
}

// NewDefenderForStorageServerTransport creates a new instance of DefenderForStorageServerTransport with the provided implementation.
// The returned DefenderForStorageServerTransport instance is connected to an instance of armsecurity.DefenderForStorageClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDefenderForStorageServerTransport(srv *DefenderForStorageServer) *DefenderForStorageServerTransport {
	return &DefenderForStorageServerTransport{srv: srv}
}

// DefenderForStorageServerTransport connects instances of armsecurity.DefenderForStorageClient to instances of DefenderForStorageServer.
// Don't use this type directly, use NewDefenderForStorageServerTransport instead.
type DefenderForStorageServerTransport struct {
	srv *DefenderForStorageServer
}

// Do implements the policy.Transporter interface for DefenderForStorageServerTransport.
func (d *DefenderForStorageServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DefenderForStorageClient.Create":
		resp, err = d.dispatchCreate(req)
	case "DefenderForStorageClient.Get":
		resp, err = d.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DefenderForStorageServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if d.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/defenderForStorageSettings/(?P<settingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.DefenderForStorageSetting](req)
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	settingNameParam, err := parseWithCast(matches[regex.SubexpIndex("settingName")], func(v string) (armsecurity.SettingName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.SettingName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Create(req.Context(), resourceIDParam, settingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DefenderForStorageSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DefenderForStorageServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/defenderForStorageSettings/(?P<settingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	settingNameParam, err := parseWithCast(matches[regex.SubexpIndex("settingName")], func(v string) (armsecurity.SettingName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.SettingName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceIDParam, settingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DefenderForStorageSetting, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
