//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp/v2"
	"net/http"
	"reflect"
	"regexp"
)

// DiscoverySolutionNLPSubscriptionScopeServer is a fake server for instances of the armselfhelp.DiscoverySolutionNLPSubscriptionScopeClient type.
type DiscoverySolutionNLPSubscriptionScopeServer struct {
	// Post is the fake for method DiscoverySolutionNLPSubscriptionScopeClient.Post
	// HTTP status codes to indicate success: http.StatusOK
	Post func(ctx context.Context, options *armselfhelp.DiscoverySolutionNLPSubscriptionScopeClientPostOptions) (resp azfake.Responder[armselfhelp.DiscoverySolutionNLPSubscriptionScopeClientPostResponse], errResp azfake.ErrorResponder)
}

// NewDiscoverySolutionNLPSubscriptionScopeServerTransport creates a new instance of DiscoverySolutionNLPSubscriptionScopeServerTransport with the provided implementation.
// The returned DiscoverySolutionNLPSubscriptionScopeServerTransport instance is connected to an instance of armselfhelp.DiscoverySolutionNLPSubscriptionScopeClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiscoverySolutionNLPSubscriptionScopeServerTransport(srv *DiscoverySolutionNLPSubscriptionScopeServer) *DiscoverySolutionNLPSubscriptionScopeServerTransport {
	return &DiscoverySolutionNLPSubscriptionScopeServerTransport{srv: srv}
}

// DiscoverySolutionNLPSubscriptionScopeServerTransport connects instances of armselfhelp.DiscoverySolutionNLPSubscriptionScopeClient to instances of DiscoverySolutionNLPSubscriptionScopeServer.
// Don't use this type directly, use NewDiscoverySolutionNLPSubscriptionScopeServerTransport instead.
type DiscoverySolutionNLPSubscriptionScopeServerTransport struct {
	srv *DiscoverySolutionNLPSubscriptionScopeServer
}

// Do implements the policy.Transporter interface for DiscoverySolutionNLPSubscriptionScopeServerTransport.
func (d *DiscoverySolutionNLPSubscriptionScopeServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiscoverySolutionNLPSubscriptionScopeClient.Post":
		resp, err = d.dispatchPost(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiscoverySolutionNLPSubscriptionScopeServerTransport) dispatchPost(req *http.Request) (*http.Response, error) {
	if d.srv.Post == nil {
		return nil, &nonRetriableError{errors.New("fake for method Post not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/discoverSolutions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armselfhelp.DiscoveryNlpRequest](req)
	if err != nil {
		return nil, err
	}
	var options *armselfhelp.DiscoverySolutionNLPSubscriptionScopeClientPostOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armselfhelp.DiscoverySolutionNLPSubscriptionScopeClientPostOptions{
			DiscoverSolutionRequest: &body,
		}
	}
	respr, errRespr := d.srv.Post(req.Context(), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiscoveryNlpResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
