//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicelinker/armservicelinker/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// LinkersServer is a fake server for instances of the armservicelinker.LinkersClient type.
type LinkersServer struct {
	// BeginCreateDryrun is the fake for method LinkersClient.BeginCreateDryrun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateDryrun func(ctx context.Context, resourceURI string, dryrunName string, parameters armservicelinker.DryrunResource, options *armservicelinker.LinkersClientBeginCreateDryrunOptions) (resp azfake.PollerResponder[armservicelinker.LinkersClientCreateDryrunResponse], errResp azfake.ErrorResponder)

	// DeleteDryrun is the fake for method LinkersClient.DeleteDryrun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteDryrun func(ctx context.Context, resourceURI string, dryrunName string, options *armservicelinker.LinkersClientDeleteDryrunOptions) (resp azfake.Responder[armservicelinker.LinkersClientDeleteDryrunResponse], errResp azfake.ErrorResponder)

	// GenerateConfigurations is the fake for method LinkersClient.GenerateConfigurations
	// HTTP status codes to indicate success: http.StatusOK
	GenerateConfigurations func(ctx context.Context, resourceURI string, linkerName string, options *armservicelinker.LinkersClientGenerateConfigurationsOptions) (resp azfake.Responder[armservicelinker.LinkersClientGenerateConfigurationsResponse], errResp azfake.ErrorResponder)

	// GetDryrun is the fake for method LinkersClient.GetDryrun
	// HTTP status codes to indicate success: http.StatusOK
	GetDryrun func(ctx context.Context, resourceURI string, dryrunName string, options *armservicelinker.LinkersClientGetDryrunOptions) (resp azfake.Responder[armservicelinker.LinkersClientGetDryrunResponse], errResp azfake.ErrorResponder)

	// NewListDaprConfigurationsPager is the fake for method LinkersClient.NewListDaprConfigurationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDaprConfigurationsPager func(resourceURI string, options *armservicelinker.LinkersClientListDaprConfigurationsOptions) (resp azfake.PagerResponder[armservicelinker.LinkersClientListDaprConfigurationsResponse])

	// NewListDryrunPager is the fake for method LinkersClient.NewListDryrunPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDryrunPager func(resourceURI string, options *armservicelinker.LinkersClientListDryrunOptions) (resp azfake.PagerResponder[armservicelinker.LinkersClientListDryrunResponse])

	// BeginUpdateDryrun is the fake for method LinkersClient.BeginUpdateDryrun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateDryrun func(ctx context.Context, resourceURI string, dryrunName string, parameters armservicelinker.DryrunPatch, options *armservicelinker.LinkersClientBeginUpdateDryrunOptions) (resp azfake.PollerResponder[armservicelinker.LinkersClientUpdateDryrunResponse], errResp azfake.ErrorResponder)
}

// NewLinkersServerTransport creates a new instance of LinkersServerTransport with the provided implementation.
// The returned LinkersServerTransport instance is connected to an instance of armservicelinker.LinkersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLinkersServerTransport(srv *LinkersServer) *LinkersServerTransport {
	return &LinkersServerTransport{
		srv:                            srv,
		beginCreateDryrun:              newTracker[azfake.PollerResponder[armservicelinker.LinkersClientCreateDryrunResponse]](),
		newListDaprConfigurationsPager: newTracker[azfake.PagerResponder[armservicelinker.LinkersClientListDaprConfigurationsResponse]](),
		newListDryrunPager:             newTracker[azfake.PagerResponder[armservicelinker.LinkersClientListDryrunResponse]](),
		beginUpdateDryrun:              newTracker[azfake.PollerResponder[armservicelinker.LinkersClientUpdateDryrunResponse]](),
	}
}

// LinkersServerTransport connects instances of armservicelinker.LinkersClient to instances of LinkersServer.
// Don't use this type directly, use NewLinkersServerTransport instead.
type LinkersServerTransport struct {
	srv                            *LinkersServer
	beginCreateDryrun              *tracker[azfake.PollerResponder[armservicelinker.LinkersClientCreateDryrunResponse]]
	newListDaprConfigurationsPager *tracker[azfake.PagerResponder[armservicelinker.LinkersClientListDaprConfigurationsResponse]]
	newListDryrunPager             *tracker[azfake.PagerResponder[armservicelinker.LinkersClientListDryrunResponse]]
	beginUpdateDryrun              *tracker[azfake.PollerResponder[armservicelinker.LinkersClientUpdateDryrunResponse]]
}

// Do implements the policy.Transporter interface for LinkersServerTransport.
func (l *LinkersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LinkersClient.BeginCreateDryrun":
		resp, err = l.dispatchBeginCreateDryrun(req)
	case "LinkersClient.DeleteDryrun":
		resp, err = l.dispatchDeleteDryrun(req)
	case "LinkersClient.GenerateConfigurations":
		resp, err = l.dispatchGenerateConfigurations(req)
	case "LinkersClient.GetDryrun":
		resp, err = l.dispatchGetDryrun(req)
	case "LinkersClient.NewListDaprConfigurationsPager":
		resp, err = l.dispatchNewListDaprConfigurationsPager(req)
	case "LinkersClient.NewListDryrunPager":
		resp, err = l.dispatchNewListDryrunPager(req)
	case "LinkersClient.BeginUpdateDryrun":
		resp, err = l.dispatchBeginUpdateDryrun(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LinkersServerTransport) dispatchBeginCreateDryrun(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreateDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateDryrun not implemented")}
	}
	beginCreateDryrun := l.beginCreateDryrun.get(req)
	if beginCreateDryrun == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicelinker.DryrunResource](req)
		if err != nil {
			return nil, err
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreateDryrun(req.Context(), resourceURIParam, dryrunNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateDryrun = &respr
		l.beginCreateDryrun.add(req, beginCreateDryrun)
	}

	resp, err := server.PollerResponderNext(beginCreateDryrun, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.beginCreateDryrun.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateDryrun) {
		l.beginCreateDryrun.remove(req)
	}

	return resp, nil
}

func (l *LinkersServerTransport) dispatchDeleteDryrun(req *http.Request) (*http.Response, error) {
	if l.srv.DeleteDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteDryrun not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.DeleteDryrun(req.Context(), resourceURIParam, dryrunNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LinkersServerTransport) dispatchGenerateConfigurations(req *http.Request) (*http.Response, error) {
	if l.srv.GenerateConfigurations == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateConfigurations not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/linkers/(?P<linkerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateConfigurations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armservicelinker.ConfigurationInfo](req)
	if err != nil {
		return nil, err
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	linkerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("linkerName")])
	if err != nil {
		return nil, err
	}
	var options *armservicelinker.LinkersClientGenerateConfigurationsOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armservicelinker.LinkersClientGenerateConfigurationsOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := l.srv.GenerateConfigurations(req.Context(), resourceURIParam, linkerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LinkersServerTransport) dispatchGetDryrun(req *http.Request) (*http.Response, error) {
	if l.srv.GetDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDryrun not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GetDryrun(req.Context(), resourceURIParam, dryrunNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DryrunResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LinkersServerTransport) dispatchNewListDaprConfigurationsPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListDaprConfigurationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDaprConfigurationsPager not implemented")}
	}
	newListDaprConfigurationsPager := l.newListDaprConfigurationsPager.get(req)
	if newListDaprConfigurationsPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/daprConfigurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListDaprConfigurationsPager(resourceURIParam, nil)
		newListDaprConfigurationsPager = &resp
		l.newListDaprConfigurationsPager.add(req, newListDaprConfigurationsPager)
		server.PagerResponderInjectNextLinks(newListDaprConfigurationsPager, req, func(page *armservicelinker.LinkersClientListDaprConfigurationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDaprConfigurationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListDaprConfigurationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDaprConfigurationsPager) {
		l.newListDaprConfigurationsPager.remove(req)
	}
	return resp, nil
}

func (l *LinkersServerTransport) dispatchNewListDryrunPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListDryrunPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDryrunPager not implemented")}
	}
	newListDryrunPager := l.newListDryrunPager.get(req)
	if newListDryrunPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/dryruns`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListDryrunPager(resourceURIParam, nil)
		newListDryrunPager = &resp
		l.newListDryrunPager.add(req, newListDryrunPager)
		server.PagerResponderInjectNextLinks(newListDryrunPager, req, func(page *armservicelinker.LinkersClientListDryrunResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDryrunPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListDryrunPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDryrunPager) {
		l.newListDryrunPager.remove(req)
	}
	return resp, nil
}

func (l *LinkersServerTransport) dispatchBeginUpdateDryrun(req *http.Request) (*http.Response, error) {
	if l.srv.BeginUpdateDryrun == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateDryrun not implemented")}
	}
	beginUpdateDryrun := l.beginUpdateDryrun.get(req)
	if beginUpdateDryrun == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceLinker/dryruns/(?P<dryrunName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armservicelinker.DryrunPatch](req)
		if err != nil {
			return nil, err
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		dryrunNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dryrunName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginUpdateDryrun(req.Context(), resourceURIParam, dryrunNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateDryrun = &respr
		l.beginUpdateDryrun.add(req, beginUpdateDryrun)
	}

	resp, err := server.PollerResponderNext(beginUpdateDryrun, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginUpdateDryrun.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateDryrun) {
		l.beginUpdateDryrun.remove(req)
	}

	return resp, nil
}
