//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armworkloadssapvirtualinstance

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// WorkloadsClient contains the methods for the WorkloadsClient group.
// Don't use this type directly, use NewWorkloadsClient() instead.
type WorkloadsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewWorkloadsClient creates a new instance of WorkloadsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewWorkloadsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*WorkloadsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &WorkloadsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// SAPAvailabilityZoneDetails - Get the recommended SAP Availability Zone Pair Details for your region.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - location - The name of Azure region.
//   - options - WorkloadsClientSAPAvailabilityZoneDetailsOptions contains the optional parameters for the WorkloadsClient.SAPAvailabilityZoneDetails
//     method.
func (client *WorkloadsClient) SAPAvailabilityZoneDetails(ctx context.Context, location string, options *WorkloadsClientSAPAvailabilityZoneDetailsOptions) (WorkloadsClientSAPAvailabilityZoneDetailsResponse, error) {
	var err error
	const operationName = "WorkloadsClient.SAPAvailabilityZoneDetails"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.sapAvailabilityZoneDetailsCreateRequest(ctx, location, options)
	if err != nil {
		return WorkloadsClientSAPAvailabilityZoneDetailsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkloadsClientSAPAvailabilityZoneDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WorkloadsClientSAPAvailabilityZoneDetailsResponse{}, err
	}
	resp, err := client.sapAvailabilityZoneDetailsHandleResponse(httpResp)
	return resp, err
}

// sapAvailabilityZoneDetailsCreateRequest creates the SAPAvailabilityZoneDetails request.
func (client *WorkloadsClient) sapAvailabilityZoneDetailsCreateRequest(ctx context.Context, location string, options *WorkloadsClientSAPAvailabilityZoneDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/locations/{location}/sapVirtualInstanceMetadata/default/getAvailabilityZoneDetails"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.SAPAvailabilityZoneDetails != nil {
		if err := runtime.MarshalAsJSON(req, *options.SAPAvailabilityZoneDetails); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// sapAvailabilityZoneDetailsHandleResponse handles the SAPAvailabilityZoneDetails response.
func (client *WorkloadsClient) sapAvailabilityZoneDetailsHandleResponse(resp *http.Response) (WorkloadsClientSAPAvailabilityZoneDetailsResponse, error) {
	result := WorkloadsClientSAPAvailabilityZoneDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPAvailabilityZoneDetailsResult); err != nil {
		return WorkloadsClientSAPAvailabilityZoneDetailsResponse{}, err
	}
	return result, nil
}

// SAPDiskConfigurations - Get the SAP Disk Configuration Layout prod/non-prod SAP System.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - location - The name of Azure region.
//   - options - WorkloadsClientSAPDiskConfigurationsOptions contains the optional parameters for the WorkloadsClient.SAPDiskConfigurations
//     method.
func (client *WorkloadsClient) SAPDiskConfigurations(ctx context.Context, location string, options *WorkloadsClientSAPDiskConfigurationsOptions) (WorkloadsClientSAPDiskConfigurationsResponse, error) {
	var err error
	const operationName = "WorkloadsClient.SAPDiskConfigurations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.sapDiskConfigurationsCreateRequest(ctx, location, options)
	if err != nil {
		return WorkloadsClientSAPDiskConfigurationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkloadsClientSAPDiskConfigurationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WorkloadsClientSAPDiskConfigurationsResponse{}, err
	}
	resp, err := client.sapDiskConfigurationsHandleResponse(httpResp)
	return resp, err
}

// sapDiskConfigurationsCreateRequest creates the SAPDiskConfigurations request.
func (client *WorkloadsClient) sapDiskConfigurationsCreateRequest(ctx context.Context, location string, options *WorkloadsClientSAPDiskConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/locations/{location}/sapVirtualInstanceMetadata/default/getDiskConfigurations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.SAPDiskConfigurations != nil {
		if err := runtime.MarshalAsJSON(req, *options.SAPDiskConfigurations); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// sapDiskConfigurationsHandleResponse handles the SAPDiskConfigurations response.
func (client *WorkloadsClient) sapDiskConfigurationsHandleResponse(resp *http.Response) (WorkloadsClientSAPDiskConfigurationsResponse, error) {
	result := WorkloadsClientSAPDiskConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPDiskConfigurationsResult); err != nil {
		return WorkloadsClientSAPDiskConfigurationsResponse{}, err
	}
	return result, nil
}

// SAPSizingRecommendations - Get SAP sizing recommendations by providing input SAPS for application tier and memory required
// for database tier
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - location - The name of Azure region.
//   - options - WorkloadsClientSAPSizingRecommendationsOptions contains the optional parameters for the WorkloadsClient.SAPSizingRecommendations
//     method.
func (client *WorkloadsClient) SAPSizingRecommendations(ctx context.Context, location string, options *WorkloadsClientSAPSizingRecommendationsOptions) (WorkloadsClientSAPSizingRecommendationsResponse, error) {
	var err error
	const operationName = "WorkloadsClient.SAPSizingRecommendations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.sapSizingRecommendationsCreateRequest(ctx, location, options)
	if err != nil {
		return WorkloadsClientSAPSizingRecommendationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkloadsClientSAPSizingRecommendationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WorkloadsClientSAPSizingRecommendationsResponse{}, err
	}
	resp, err := client.sapSizingRecommendationsHandleResponse(httpResp)
	return resp, err
}

// sapSizingRecommendationsCreateRequest creates the SAPSizingRecommendations request.
func (client *WorkloadsClient) sapSizingRecommendationsCreateRequest(ctx context.Context, location string, options *WorkloadsClientSAPSizingRecommendationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/locations/{location}/sapVirtualInstanceMetadata/default/getSizingRecommendations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.SAPSizingRecommendation != nil {
		if err := runtime.MarshalAsJSON(req, *options.SAPSizingRecommendation); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// sapSizingRecommendationsHandleResponse handles the SAPSizingRecommendations response.
func (client *WorkloadsClient) sapSizingRecommendationsHandleResponse(resp *http.Response) (WorkloadsClientSAPSizingRecommendationsResponse, error) {
	result := WorkloadsClientSAPSizingRecommendationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result); err != nil {
		return WorkloadsClientSAPSizingRecommendationsResponse{}, err
	}
	return result, nil
}

// SAPSupportedSKU - Get a list of SAP supported SKUs for ASCS, Application and Database tier.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - location - The name of Azure region.
//   - options - WorkloadsClientSAPSupportedSKUOptions contains the optional parameters for the WorkloadsClient.SAPSupportedSKU
//     method.
func (client *WorkloadsClient) SAPSupportedSKU(ctx context.Context, location string, options *WorkloadsClientSAPSupportedSKUOptions) (WorkloadsClientSAPSupportedSKUResponse, error) {
	var err error
	const operationName = "WorkloadsClient.SAPSupportedSKU"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.sapSupportedSKUCreateRequest(ctx, location, options)
	if err != nil {
		return WorkloadsClientSAPSupportedSKUResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkloadsClientSAPSupportedSKUResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WorkloadsClientSAPSupportedSKUResponse{}, err
	}
	resp, err := client.sapSupportedSKUHandleResponse(httpResp)
	return resp, err
}

// sapSupportedSKUCreateRequest creates the SAPSupportedSKU request.
func (client *WorkloadsClient) sapSupportedSKUCreateRequest(ctx context.Context, location string, options *WorkloadsClientSAPSupportedSKUOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/locations/{location}/sapVirtualInstanceMetadata/default/getSapSupportedSku"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.SAPSupportedSKU != nil {
		if err := runtime.MarshalAsJSON(req, *options.SAPSupportedSKU); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// sapSupportedSKUHandleResponse handles the SAPSupportedSKU response.
func (client *WorkloadsClient) sapSupportedSKUHandleResponse(resp *http.Response) (WorkloadsClientSAPSupportedSKUResponse, error) {
	result := WorkloadsClientSAPSupportedSKUResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPSupportedResourceSKUsResult); err != nil {
		return WorkloadsClientSAPSupportedSKUResponse{}, err
	}
	return result, nil
}
