# Humanize: Turn stiff AI text 🤖 into human-sounding gold 🪙

**Humanize** aims to help make AI writing sound more like a real person wrote it. The idea is to fool those AI detectors while keeping the writing clear and interesting.

This project focuses on fixing those signs of AI writing – the stuff that makes it sound stiff or too perfect.

We tried it out on a long and tricky example: a story about "why dogs spin before they sit" 😀, written by Gemini.  Here's how the output did on some AI checkers:

* Quillbot: 59% AI
* ZeroGPT: 54% AI
* GPTZero: 87% AI
* Writer.com: 15% AI

Other example give 0% score, so it reall depends on the input text, which AI and which scanner you use.

Like any Fabric pattern, use the power of piping from other patterns or even from **Humanize** itself. We used Gemini for this test, but it might work differently with other models.  So play around and see what you find... and yes, this text have been Humanized (and revised) 😉

Have fun using **Humanize**!

## Input AI text example:
```
The Mystery of the Spinning Dog

In the world of canine behavior, one of the most curious rituals is the practice of spinning before settling down. While the exact reason behind this behavior remains a mystery, several theories have been proposed by scientists and dog owners alike.

The Ancient Instinct

Some believe that this spinning behavior is a remnant of the dogs' wild ancestors. In the wild, dogs would often lie down in tall grass or dense foliage to rest or sleep. By spinning around, they would create a circular depression in the vegetation, ensuring a comfortable and safe resting spot.

The Comfort Seeker

Another theory suggests that dogs spin to create a sense of comfort and security. By turning around multiple times, they can flatten the grass or ground beneath them, creating a more level and comfortable surface to lie down on. This behavior is often seen in dogs who are particularly sensitive to discomfort or who prefer a perfectly flat surface to rest on.

The Scent Marker

A third theory proposes that dogs spin to leave their scent on the ground. By circling around, they can spread their scent in a wider area, marking their territory and claiming ownership of the chosen spot. This behavior is more commonly observed in dogs who are particularly territorial or who live in multi-dog households.

The Playful Spirit

Finally, some dog owners believe that spinning is simply a playful behavior. Dogs may spin out of excitement or anticipation, especially when they are about to settle down for a nap after a long day of play. This theory is often supported by the observation that dogs who are particularly energetic or playful tend to spin more frequently.

A Combination of Factors

While the exact reason behind dog spinning remains unknown, it is likely a combination of these factors. Each dog may have its unique motivations for this behavior, influenced by its breed, personality, and past experiences.

Observing Your Dog

If you have a dog that spins before settling down, you can try to observe its behavior to gain a better understanding of its motivations. Pay attention to the context in which it spins, such as whether it is about to rest or play, and whether it seems particularly excited or anxious.

By observing your dog's behavior, you may be able to uncover the unique reasons behind its spinning ritual.
```
## Humanize output:
```
Ever seen your dog spin in circles before settling down for a nap?  It's a pretty common thing, but why do they do it?  Nobody's entirely sure, but there are a few good guesses.

One idea is that it's an instinct from their wolf ancestors.  Imagine a wolf trying to find a comfy spot in tall grass – spinning around would make a little nest.

Another thought is that it's all about comfort.  Spinning flattens things out, making a nice, even spot for a nap. You see this a lot in dogs who are picky about where they sleep.

Some people think it's about marking their territory.  Spinning spreads their scent, kind of like saying, "This is mine!"  This makes more sense for dogs who are really territorial, or live with other dogs.

And then there's the "it's just fun" theory.  Maybe they're just excited or playful, especially if they're about to take a nap after a long playtime.

It's probably a mix of all these things.  Every dog is different, so their reasons might be a little different too.  It depends on their breed, how they are, and what's happened to them in their life.

If your dog does this, try watching them.  What are they doing right before they start spinning? Are they tired, or excited?  Paying attention might give you a clue about why *your* dog does it.  It's a fun little mystery to solve together!
```
