// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: cc/arduino/cli/commands/v1/lib.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represent a library installation location.
type LibraryInstallLocation int32

const (
	// In the `libraries` subdirectory of the user directory (sketchbook). This is
	// the default if not specified.
	LibraryInstallLocation_LIBRARY_INSTALL_LOCATION_USER LibraryInstallLocation = 0
	// In the configured 'builtin.libraries' directory.
	LibraryInstallLocation_LIBRARY_INSTALL_LOCATION_BUILTIN LibraryInstallLocation = 1
)

// Enum value maps for LibraryInstallLocation.
var (
	LibraryInstallLocation_name = map[int32]string{
		0: "LIBRARY_INSTALL_LOCATION_USER",
		1: "LIBRARY_INSTALL_LOCATION_BUILTIN",
	}
	LibraryInstallLocation_value = map[string]int32{
		"LIBRARY_INSTALL_LOCATION_USER":    0,
		"LIBRARY_INSTALL_LOCATION_BUILTIN": 1,
	}
)

func (x LibraryInstallLocation) Enum() *LibraryInstallLocation {
	p := new(LibraryInstallLocation)
	*p = x
	return p
}

func (x LibraryInstallLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibraryInstallLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[0].Descriptor()
}

func (LibraryInstallLocation) Type() protoreflect.EnumType {
	return &file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[0]
}

func (x LibraryInstallLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibraryInstallLocation.Descriptor instead.
func (LibraryInstallLocation) EnumDescriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{0}
}

// Represent the result of the library search.
type LibrarySearchStatus int32

const (
	// No search results were found.
	LibrarySearchStatus_LIBRARY_SEARCH_STATUS_FAILED LibrarySearchStatus = 0
	// Search results were found.
	LibrarySearchStatus_LIBRARY_SEARCH_STATUS_SUCCESS LibrarySearchStatus = 1
)

// Enum value maps for LibrarySearchStatus.
var (
	LibrarySearchStatus_name = map[int32]string{
		0: "LIBRARY_SEARCH_STATUS_FAILED",
		1: "LIBRARY_SEARCH_STATUS_SUCCESS",
	}
	LibrarySearchStatus_value = map[string]int32{
		"LIBRARY_SEARCH_STATUS_FAILED":  0,
		"LIBRARY_SEARCH_STATUS_SUCCESS": 1,
	}
)

func (x LibrarySearchStatus) Enum() *LibrarySearchStatus {
	p := new(LibrarySearchStatus)
	*p = x
	return p
}

func (x LibrarySearchStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibrarySearchStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[1].Descriptor()
}

func (LibrarySearchStatus) Type() protoreflect.EnumType {
	return &file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[1]
}

func (x LibrarySearchStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibrarySearchStatus.Descriptor instead.
func (LibrarySearchStatus) EnumDescriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{1}
}

// Represent the library layout.
type LibraryLayout int32

const (
	// Library is in the 1.0 Arduino library format.
	LibraryLayout_LIBRARY_LAYOUT_FLAT LibraryLayout = 0
	// Library is in the 1.5 Arduino library format.
	LibraryLayout_LIBRARY_LAYOUT_RECURSIVE LibraryLayout = 1
)

// Enum value maps for LibraryLayout.
var (
	LibraryLayout_name = map[int32]string{
		0: "LIBRARY_LAYOUT_FLAT",
		1: "LIBRARY_LAYOUT_RECURSIVE",
	}
	LibraryLayout_value = map[string]int32{
		"LIBRARY_LAYOUT_FLAT":      0,
		"LIBRARY_LAYOUT_RECURSIVE": 1,
	}
)

func (x LibraryLayout) Enum() *LibraryLayout {
	p := new(LibraryLayout)
	*p = x
	return p
}

func (x LibraryLayout) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibraryLayout) Descriptor() protoreflect.EnumDescriptor {
	return file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[2].Descriptor()
}

func (LibraryLayout) Type() protoreflect.EnumType {
	return &file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[2]
}

func (x LibraryLayout) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibraryLayout.Descriptor instead.
func (LibraryLayout) EnumDescriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{2}
}

// Represent the location of the library.
type LibraryLocation int32

const (
	// In the configured 'builtin.libraries' directory.
	LibraryLocation_LIBRARY_LOCATION_BUILTIN LibraryLocation = 0
	// In the `libraries` subdirectory of the user directory (sketchbook).
	LibraryLocation_LIBRARY_LOCATION_USER LibraryLocation = 1
	// In the `libraries` subdirectory of a platform.
	LibraryLocation_LIBRARY_LOCATION_PLATFORM_BUILTIN LibraryLocation = 2
	// When `LibraryLocation` is used in a context where a board is specified,
	// this indicates the library is in the `libraries` subdirectory of a
	// platform referenced by the board's platform.
	LibraryLocation_LIBRARY_LOCATION_REFERENCED_PLATFORM_BUILTIN LibraryLocation = 3
	// Outside the `libraries` folders managed by the CLI.
	LibraryLocation_LIBRARY_LOCATION_UNMANAGED LibraryLocation = 4
)

// Enum value maps for LibraryLocation.
var (
	LibraryLocation_name = map[int32]string{
		0: "LIBRARY_LOCATION_BUILTIN",
		1: "LIBRARY_LOCATION_USER",
		2: "LIBRARY_LOCATION_PLATFORM_BUILTIN",
		3: "LIBRARY_LOCATION_REFERENCED_PLATFORM_BUILTIN",
		4: "LIBRARY_LOCATION_UNMANAGED",
	}
	LibraryLocation_value = map[string]int32{
		"LIBRARY_LOCATION_BUILTIN":                     0,
		"LIBRARY_LOCATION_USER":                        1,
		"LIBRARY_LOCATION_PLATFORM_BUILTIN":            2,
		"LIBRARY_LOCATION_REFERENCED_PLATFORM_BUILTIN": 3,
		"LIBRARY_LOCATION_UNMANAGED":                   4,
	}
)

func (x LibraryLocation) Enum() *LibraryLocation {
	p := new(LibraryLocation)
	*p = x
	return p
}

func (x LibraryLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibraryLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[3].Descriptor()
}

func (LibraryLocation) Type() protoreflect.EnumType {
	return &file_cc_arduino_cli_commands_v1_lib_proto_enumTypes[3]
}

func (x LibraryLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibraryLocation.Descriptor instead.
func (LibraryLocation) EnumDescriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{3}
}

type LibraryDownloadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to download.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *LibraryDownloadRequest) Reset() {
	*x = LibraryDownloadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDownloadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDownloadRequest) ProtoMessage() {}

func (x *LibraryDownloadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDownloadRequest.ProtoReflect.Descriptor instead.
func (*LibraryDownloadRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{0}
}

func (x *LibraryDownloadRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryDownloadRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryDownloadRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LibraryDownloadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*LibraryDownloadResponse_Progress
	//	*LibraryDownloadResponse_Result_
	Message isLibraryDownloadResponse_Message `protobuf_oneof:"message"`
}

func (x *LibraryDownloadResponse) Reset() {
	*x = LibraryDownloadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDownloadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDownloadResponse) ProtoMessage() {}

func (x *LibraryDownloadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDownloadResponse.ProtoReflect.Descriptor instead.
func (*LibraryDownloadResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{1}
}

func (m *LibraryDownloadResponse) GetMessage() isLibraryDownloadResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *LibraryDownloadResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*LibraryDownloadResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *LibraryDownloadResponse) GetResult() *LibraryDownloadResponse_Result {
	if x, ok := x.GetMessage().(*LibraryDownloadResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isLibraryDownloadResponse_Message interface {
	isLibraryDownloadResponse_Message()
}

type LibraryDownloadResponse_Progress struct {
	// Progress of the library download.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type LibraryDownloadResponse_Result_ struct {
	// Download result.
	Result *LibraryDownloadResponse_Result `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

func (*LibraryDownloadResponse_Progress) isLibraryDownloadResponse_Message() {}

func (*LibraryDownloadResponse_Result_) isLibraryDownloadResponse_Message() {}

type LibraryInstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to install.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Set to true to skip installation of specified library's dependencies,
	// defaults to false.
	NoDeps bool `protobuf:"varint,4,opt,name=no_deps,json=noDeps,proto3" json:"no_deps,omitempty"`
	// Set to true to skip installation if a different version of the library or
	// one of its dependencies is already installed, defaults to false.
	NoOverwrite bool `protobuf:"varint,5,opt,name=no_overwrite,json=noOverwrite,proto3" json:"no_overwrite,omitempty"`
	// Install the library and dependencies in the specified location.
	InstallLocation LibraryInstallLocation `protobuf:"varint,6,opt,name=install_location,json=installLocation,proto3,enum=cc.arduino.cli.commands.v1.LibraryInstallLocation" json:"install_location,omitempty"`
}

func (x *LibraryInstallRequest) Reset() {
	*x = LibraryInstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryInstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryInstallRequest) ProtoMessage() {}

func (x *LibraryInstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryInstallRequest.ProtoReflect.Descriptor instead.
func (*LibraryInstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{2}
}

func (x *LibraryInstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryInstallRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryInstallRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *LibraryInstallRequest) GetNoDeps() bool {
	if x != nil {
		return x.NoDeps
	}
	return false
}

func (x *LibraryInstallRequest) GetNoOverwrite() bool {
	if x != nil {
		return x.NoOverwrite
	}
	return false
}

func (x *LibraryInstallRequest) GetInstallLocation() LibraryInstallLocation {
	if x != nil {
		return x.InstallLocation
	}
	return LibraryInstallLocation_LIBRARY_INSTALL_LOCATION_USER
}

type LibraryInstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*LibraryInstallResponse_Progress
	//	*LibraryInstallResponse_TaskProgress
	//	*LibraryInstallResponse_Result_
	Message isLibraryInstallResponse_Message `protobuf_oneof:"message"`
}

func (x *LibraryInstallResponse) Reset() {
	*x = LibraryInstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryInstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryInstallResponse) ProtoMessage() {}

func (x *LibraryInstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryInstallResponse.ProtoReflect.Descriptor instead.
func (*LibraryInstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{3}
}

func (m *LibraryInstallResponse) GetMessage() isLibraryInstallResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *LibraryInstallResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*LibraryInstallResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *LibraryInstallResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*LibraryInstallResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *LibraryInstallResponse) GetResult() *LibraryInstallResponse_Result {
	if x, ok := x.GetMessage().(*LibraryInstallResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isLibraryInstallResponse_Message interface {
	isLibraryInstallResponse_Message()
}

type LibraryInstallResponse_Progress struct {
	// Progress of the library download.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type LibraryInstallResponse_TaskProgress struct {
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type LibraryInstallResponse_Result_ struct {
	// Download result.
	Result *LibraryInstallResponse_Result `protobuf:"bytes,3,opt,name=result,proto3,oneof"`
}

func (*LibraryInstallResponse_Progress) isLibraryInstallResponse_Message() {}

func (*LibraryInstallResponse_TaskProgress) isLibraryInstallResponse_Message() {}

func (*LibraryInstallResponse_Result_) isLibraryInstallResponse_Message() {}

type LibraryUpgradeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Set to true to skip installation of specified library's dependencies,
	// defaults to false.
	NoDeps bool `protobuf:"varint,3,opt,name=no_deps,json=noDeps,proto3" json:"no_deps,omitempty"`
}

func (x *LibraryUpgradeRequest) Reset() {
	*x = LibraryUpgradeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeRequest) ProtoMessage() {}

func (x *LibraryUpgradeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeRequest.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{4}
}

func (x *LibraryUpgradeRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryUpgradeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryUpgradeRequest) GetNoDeps() bool {
	if x != nil {
		return x.NoDeps
	}
	return false
}

type LibraryUpgradeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*LibraryUpgradeResponse_Progress
	//	*LibraryUpgradeResponse_TaskProgress
	//	*LibraryUpgradeResponse_Result_
	Message isLibraryUpgradeResponse_Message `protobuf_oneof:"message"`
}

func (x *LibraryUpgradeResponse) Reset() {
	*x = LibraryUpgradeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeResponse) ProtoMessage() {}

func (x *LibraryUpgradeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeResponse.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{5}
}

func (m *LibraryUpgradeResponse) GetMessage() isLibraryUpgradeResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *LibraryUpgradeResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*LibraryUpgradeResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *LibraryUpgradeResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*LibraryUpgradeResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *LibraryUpgradeResponse) GetResult() *LibraryUpgradeResponse_Result {
	if x, ok := x.GetMessage().(*LibraryUpgradeResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isLibraryUpgradeResponse_Message interface {
	isLibraryUpgradeResponse_Message()
}

type LibraryUpgradeResponse_Progress struct {
	// Progress of the library download.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type LibraryUpgradeResponse_TaskProgress struct {
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type LibraryUpgradeResponse_Result_ struct {
	// Download result.
	Result *LibraryUpgradeResponse_Result `protobuf:"bytes,3,opt,name=result,proto3,oneof"`
}

func (*LibraryUpgradeResponse_Progress) isLibraryUpgradeResponse_Message() {}

func (*LibraryUpgradeResponse_TaskProgress) isLibraryUpgradeResponse_Message() {}

func (*LibraryUpgradeResponse_Result_) isLibraryUpgradeResponse_Message() {}

type LibraryUninstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to uninstall.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *LibraryUninstallRequest) Reset() {
	*x = LibraryUninstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUninstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUninstallRequest) ProtoMessage() {}

func (x *LibraryUninstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUninstallRequest.ProtoReflect.Descriptor instead.
func (*LibraryUninstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{6}
}

func (x *LibraryUninstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryUninstallRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryUninstallRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type LibraryUninstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*LibraryUninstallResponse_TaskProgress
	//	*LibraryUninstallResponse_Result_
	Message isLibraryUninstallResponse_Message `protobuf_oneof:"message"`
}

func (x *LibraryUninstallResponse) Reset() {
	*x = LibraryUninstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUninstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUninstallResponse) ProtoMessage() {}

func (x *LibraryUninstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUninstallResponse.ProtoReflect.Descriptor instead.
func (*LibraryUninstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{7}
}

func (m *LibraryUninstallResponse) GetMessage() isLibraryUninstallResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *LibraryUninstallResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*LibraryUninstallResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *LibraryUninstallResponse) GetResult() *LibraryUninstallResponse_Result {
	if x, ok := x.GetMessage().(*LibraryUninstallResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isLibraryUninstallResponse_Message interface {
	isLibraryUninstallResponse_Message()
}

type LibraryUninstallResponse_TaskProgress struct {
	// Description of the current stage of the uninstallation.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type LibraryUninstallResponse_Result_ struct {
	// Uninstall result.
	Result *LibraryUninstallResponse_Result `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

func (*LibraryUninstallResponse_TaskProgress) isLibraryUninstallResponse_Message() {}

func (*LibraryUninstallResponse_Result_) isLibraryUninstallResponse_Message() {}

type LibraryUpgradeAllRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *LibraryUpgradeAllRequest) Reset() {
	*x = LibraryUpgradeAllRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeAllRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeAllRequest) ProtoMessage() {}

func (x *LibraryUpgradeAllRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeAllRequest.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeAllRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{8}
}

func (x *LibraryUpgradeAllRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

type LibraryUpgradeAllResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*LibraryUpgradeAllResponse_Progress
	//	*LibraryUpgradeAllResponse_TaskProgress
	//	*LibraryUpgradeAllResponse_Result_
	Message isLibraryUpgradeAllResponse_Message `protobuf_oneof:"message"`
}

func (x *LibraryUpgradeAllResponse) Reset() {
	*x = LibraryUpgradeAllResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeAllResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeAllResponse) ProtoMessage() {}

func (x *LibraryUpgradeAllResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeAllResponse.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeAllResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{9}
}

func (m *LibraryUpgradeAllResponse) GetMessage() isLibraryUpgradeAllResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *LibraryUpgradeAllResponse) GetProgress() *DownloadProgress {
	if x, ok := x.GetMessage().(*LibraryUpgradeAllResponse_Progress); ok {
		return x.Progress
	}
	return nil
}

func (x *LibraryUpgradeAllResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*LibraryUpgradeAllResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *LibraryUpgradeAllResponse) GetResult() *LibraryUpgradeAllResponse_Result {
	if x, ok := x.GetMessage().(*LibraryUpgradeAllResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isLibraryUpgradeAllResponse_Message interface {
	isLibraryUpgradeAllResponse_Message()
}

type LibraryUpgradeAllResponse_Progress struct {
	// Progress of the downloads of files needed for the upgrades.
	Progress *DownloadProgress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type LibraryUpgradeAllResponse_TaskProgress struct {
	// Description of the current stage of the upgrade.
	TaskProgress *TaskProgress `protobuf:"bytes,2,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type LibraryUpgradeAllResponse_Result_ struct {
	// Upgrade result.
	Result *LibraryUpgradeAllResponse_Result `protobuf:"bytes,3,opt,name=result,proto3,oneof"`
}

func (*LibraryUpgradeAllResponse_Progress) isLibraryUpgradeAllResponse_Message() {}

func (*LibraryUpgradeAllResponse_TaskProgress) isLibraryUpgradeAllResponse_Message() {}

func (*LibraryUpgradeAllResponse_Result_) isLibraryUpgradeAllResponse_Message() {}

type LibraryResolveDependenciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Name of the library.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The version of the library to check dependencies of. If no version is
	// specified, dependencies of the newest version will be listed.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// If true the computed solution will try to keep exising libraries
	// at their current version.
	DoNotUpdateInstalledLibraries bool `protobuf:"varint,4,opt,name=do_not_update_installed_libraries,json=doNotUpdateInstalledLibraries,proto3" json:"do_not_update_installed_libraries,omitempty"`
}

func (x *LibraryResolveDependenciesRequest) Reset() {
	*x = LibraryResolveDependenciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryResolveDependenciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryResolveDependenciesRequest) ProtoMessage() {}

func (x *LibraryResolveDependenciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryResolveDependenciesRequest.ProtoReflect.Descriptor instead.
func (*LibraryResolveDependenciesRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{10}
}

func (x *LibraryResolveDependenciesRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryResolveDependenciesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryResolveDependenciesRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *LibraryResolveDependenciesRequest) GetDoNotUpdateInstalledLibraries() bool {
	if x != nil {
		return x.DoNotUpdateInstalledLibraries
	}
	return false
}

type LibraryResolveDependenciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dependencies of the library.
	Dependencies []*LibraryDependencyStatus `protobuf:"bytes,1,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *LibraryResolveDependenciesResponse) Reset() {
	*x = LibraryResolveDependenciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryResolveDependenciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryResolveDependenciesResponse) ProtoMessage() {}

func (x *LibraryResolveDependenciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryResolveDependenciesResponse.ProtoReflect.Descriptor instead.
func (*LibraryResolveDependenciesResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{11}
}

func (x *LibraryResolveDependenciesResponse) GetDependencies() []*LibraryDependencyStatus {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type LibraryDependencyStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the library dependency.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The required version of the library dependency.
	VersionRequired string `protobuf:"bytes,2,opt,name=version_required,json=versionRequired,proto3" json:"version_required,omitempty"`
	// Version of the library dependency currently installed.
	VersionInstalled string `protobuf:"bytes,3,opt,name=version_installed,json=versionInstalled,proto3" json:"version_installed,omitempty"`
}

func (x *LibraryDependencyStatus) Reset() {
	*x = LibraryDependencyStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDependencyStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDependencyStatus) ProtoMessage() {}

func (x *LibraryDependencyStatus) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDependencyStatus.ProtoReflect.Descriptor instead.
func (*LibraryDependencyStatus) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{12}
}

func (x *LibraryDependencyStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryDependencyStatus) GetVersionRequired() string {
	if x != nil {
		return x.VersionRequired
	}
	return ""
}

func (x *LibraryDependencyStatus) GetVersionInstalled() string {
	if x != nil {
		return x.VersionInstalled
	}
	return ""
}

type LibrarySearchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Set to true to not populate the releases field in the response (may save a
	// lot of bandwidth/CPU).
	OmitReleasesDetails bool `protobuf:"varint,2,opt,name=omit_releases_details,json=omitReleasesDetails,proto3" json:"omit_releases_details,omitempty"`
	// Keywords for the search.
	SearchArgs string `protobuf:"bytes,3,opt,name=search_args,json=searchArgs,proto3" json:"search_args,omitempty"`
}

func (x *LibrarySearchRequest) Reset() {
	*x = LibrarySearchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibrarySearchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibrarySearchRequest) ProtoMessage() {}

func (x *LibrarySearchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibrarySearchRequest.ProtoReflect.Descriptor instead.
func (*LibrarySearchRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{13}
}

func (x *LibrarySearchRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibrarySearchRequest) GetOmitReleasesDetails() bool {
	if x != nil {
		return x.OmitReleasesDetails
	}
	return false
}

func (x *LibrarySearchRequest) GetSearchArgs() string {
	if x != nil {
		return x.SearchArgs
	}
	return ""
}

type LibrarySearchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results of the search.
	Libraries []*SearchedLibrary `protobuf:"bytes,1,rep,name=libraries,proto3" json:"libraries,omitempty"`
	// Whether the search yielded results.
	Status LibrarySearchStatus `protobuf:"varint,2,opt,name=status,proto3,enum=cc.arduino.cli.commands.v1.LibrarySearchStatus" json:"status,omitempty"`
}

func (x *LibrarySearchResponse) Reset() {
	*x = LibrarySearchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibrarySearchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibrarySearchResponse) ProtoMessage() {}

func (x *LibrarySearchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibrarySearchResponse.ProtoReflect.Descriptor instead.
func (*LibrarySearchResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{14}
}

func (x *LibrarySearchResponse) GetLibraries() []*SearchedLibrary {
	if x != nil {
		return x.Libraries
	}
	return nil
}

func (x *LibrarySearchResponse) GetStatus() LibrarySearchStatus {
	if x != nil {
		return x.Status
	}
	return LibrarySearchStatus_LIBRARY_SEARCH_STATUS_FAILED
}

type SearchedLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Library name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The index data for the available versions of the library. The key of the
	// map is the library version.
	Releases map[string]*LibraryRelease `protobuf:"bytes,2,rep,name=releases,proto3" json:"releases,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The index data for the latest version of the library.
	Latest *LibraryRelease `protobuf:"bytes,3,opt,name=latest,proto3" json:"latest,omitempty"`
	// The available versions of this library.
	AvailableVersions []string `protobuf:"bytes,4,rep,name=available_versions,json=availableVersions,proto3" json:"available_versions,omitempty"`
}

func (x *SearchedLibrary) Reset() {
	*x = SearchedLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchedLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchedLibrary) ProtoMessage() {}

func (x *SearchedLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchedLibrary.ProtoReflect.Descriptor instead.
func (*SearchedLibrary) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{15}
}

func (x *SearchedLibrary) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchedLibrary) GetReleases() map[string]*LibraryRelease {
	if x != nil {
		return x.Releases
	}
	return nil
}

func (x *SearchedLibrary) GetLatest() *LibraryRelease {
	if x != nil {
		return x.Latest
	}
	return nil
}

func (x *SearchedLibrary) GetAvailableVersions() []string {
	if x != nil {
		return x.AvailableVersions
	}
	return nil
}

type LibraryRelease struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value of the `author` field in library.properties.
	Author string `protobuf:"bytes,1,opt,name=author,proto3" json:"author,omitempty"`
	// Value of the `version` field in library.properties.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Value of the `maintainer` field in library.properties.
	Maintainer string `protobuf:"bytes,3,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// Value of the `sentence` field in library.properties.
	Sentence string `protobuf:"bytes,4,opt,name=sentence,proto3" json:"sentence,omitempty"`
	// Value of the `paragraph` field in library.properties.
	Paragraph string `protobuf:"bytes,5,opt,name=paragraph,proto3" json:"paragraph,omitempty"`
	// Value of the `url` field in library.properties.
	Website string `protobuf:"bytes,6,opt,name=website,proto3" json:"website,omitempty"`
	// Value of the `category` field in library.properties.
	Category string `protobuf:"bytes,7,opt,name=category,proto3" json:"category,omitempty"`
	// Value of the `architectures` field in library.properties.
	Architectures []string `protobuf:"bytes,8,rep,name=architectures,proto3" json:"architectures,omitempty"`
	// The type categories of the library, as defined in the libraries index.
	// Possible values: `Arduino`, `Partner`, `Recommended`, `Contributed`,
	// `Retired`.
	Types []string `protobuf:"bytes,9,rep,name=types,proto3" json:"types,omitempty"`
	// Information about the library archive file.
	Resources *DownloadResource `protobuf:"bytes,10,opt,name=resources,proto3" json:"resources,omitempty"`
	// Value of the `license` field in library.properties.
	License string `protobuf:"bytes,11,opt,name=license,proto3" json:"license,omitempty"`
	// Value of the `includes` field in library.properties.
	ProvidesIncludes []string `protobuf:"bytes,12,rep,name=provides_includes,json=providesIncludes,proto3" json:"provides_includes,omitempty"`
	// The names of the library's dependencies, as defined by the 'depends'
	// field of library.properties.
	Dependencies []*LibraryDependency `protobuf:"bytes,13,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
}

func (x *LibraryRelease) Reset() {
	*x = LibraryRelease{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryRelease) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryRelease) ProtoMessage() {}

func (x *LibraryRelease) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryRelease.ProtoReflect.Descriptor instead.
func (*LibraryRelease) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{16}
}

func (x *LibraryRelease) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *LibraryRelease) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *LibraryRelease) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *LibraryRelease) GetSentence() string {
	if x != nil {
		return x.Sentence
	}
	return ""
}

func (x *LibraryRelease) GetParagraph() string {
	if x != nil {
		return x.Paragraph
	}
	return ""
}

func (x *LibraryRelease) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *LibraryRelease) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *LibraryRelease) GetArchitectures() []string {
	if x != nil {
		return x.Architectures
	}
	return nil
}

func (x *LibraryRelease) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *LibraryRelease) GetResources() *DownloadResource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *LibraryRelease) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *LibraryRelease) GetProvidesIncludes() []string {
	if x != nil {
		return x.ProvidesIncludes
	}
	return nil
}

func (x *LibraryRelease) GetDependencies() []*LibraryDependency {
	if x != nil {
		return x.Dependencies
	}
	return nil
}

type LibraryDependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Library name of the dependency.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Version constraint of the dependency.
	VersionConstraint string `protobuf:"bytes,2,opt,name=version_constraint,json=versionConstraint,proto3" json:"version_constraint,omitempty"`
}

func (x *LibraryDependency) Reset() {
	*x = LibraryDependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDependency) ProtoMessage() {}

func (x *LibraryDependency) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDependency.ProtoReflect.Descriptor instead.
func (*LibraryDependency) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{17}
}

func (x *LibraryDependency) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryDependency) GetVersionConstraint() string {
	if x != nil {
		return x.VersionConstraint
	}
	return ""
}

type DownloadResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Download URL of the library archive.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Filename of the library archive.
	ArchiveFilename string `protobuf:"bytes,2,opt,name=archive_filename,json=archiveFilename,proto3" json:"archive_filename,omitempty"`
	// Checksum of the library archive.
	Checksum string `protobuf:"bytes,3,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// File size of the library archive.
	Size int64 `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	// The directory under the staging subdirectory of the data directory the
	// library archive file will be downloaded to.
	CachePath string `protobuf:"bytes,5,opt,name=cache_path,json=cachePath,proto3" json:"cache_path,omitempty"`
}

func (x *DownloadResource) Reset() {
	*x = DownloadResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DownloadResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownloadResource) ProtoMessage() {}

func (x *DownloadResource) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownloadResource.ProtoReflect.Descriptor instead.
func (*DownloadResource) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{18}
}

func (x *DownloadResource) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *DownloadResource) GetArchiveFilename() string {
	if x != nil {
		return x.ArchiveFilename
	}
	return ""
}

func (x *DownloadResource) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

func (x *DownloadResource) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *DownloadResource) GetCachePath() string {
	if x != nil {
		return x.CachePath
	}
	return ""
}

type LibraryListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Whether to include built-in libraries (from platforms and the Arduino
	// IDE) in the listing.
	All bool `protobuf:"varint,2,opt,name=all,proto3" json:"all,omitempty"`
	// Whether to list only libraries for which there is a newer version than
	// the installed version available in the libraries index.
	Updatable bool `protobuf:"varint,3,opt,name=updatable,proto3" json:"updatable,omitempty"`
	// If set filters out the libraries not matching name.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// By setting this field all duplicate libraries are filtered out leaving
	// only the libraries that will be used to compile for the specified board
	// FQBN.
	Fqbn string `protobuf:"bytes,5,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *LibraryListRequest) Reset() {
	*x = LibraryListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryListRequest) ProtoMessage() {}

func (x *LibraryListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryListRequest.ProtoReflect.Descriptor instead.
func (*LibraryListRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{19}
}

func (x *LibraryListRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *LibraryListRequest) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

func (x *LibraryListRequest) GetUpdatable() bool {
	if x != nil {
		return x.Updatable
	}
	return false
}

func (x *LibraryListRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LibraryListRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

type LibraryListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of installed libraries.
	InstalledLibraries []*InstalledLibrary `protobuf:"bytes,1,rep,name=installed_libraries,json=installedLibraries,proto3" json:"installed_libraries,omitempty"`
}

func (x *LibraryListResponse) Reset() {
	*x = LibraryListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryListResponse) ProtoMessage() {}

func (x *LibraryListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryListResponse.ProtoReflect.Descriptor instead.
func (*LibraryListResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{20}
}

func (x *LibraryListResponse) GetInstalledLibraries() []*InstalledLibrary {
	if x != nil {
		return x.InstalledLibraries
	}
	return nil
}

type InstalledLibrary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the library.
	Library *Library `protobuf:"bytes,1,opt,name=library,proto3" json:"library,omitempty"`
	// When the `updatable` field of the `LibraryList` request is set to `true`,
	// this will contain information on the latest version of the library in the
	// libraries index.
	Release *LibraryRelease `protobuf:"bytes,2,opt,name=release,proto3" json:"release,omitempty"`
}

func (x *InstalledLibrary) Reset() {
	*x = InstalledLibrary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstalledLibrary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstalledLibrary) ProtoMessage() {}

func (x *InstalledLibrary) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstalledLibrary.ProtoReflect.Descriptor instead.
func (*InstalledLibrary) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{21}
}

func (x *InstalledLibrary) GetLibrary() *Library {
	if x != nil {
		return x.Library
	}
	return nil
}

func (x *InstalledLibrary) GetRelease() *LibraryRelease {
	if x != nil {
		return x.Release
	}
	return nil
}

type Library struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Library name (value of `name` field in library.properties).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the `author` field in library.properties.
	Author string `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// Value of the `maintainer` field in library.properties.
	Maintainer string `protobuf:"bytes,3,opt,name=maintainer,proto3" json:"maintainer,omitempty"`
	// Value of the `sentence` field in library.properties.
	Sentence string `protobuf:"bytes,4,opt,name=sentence,proto3" json:"sentence,omitempty"`
	// Value of the `paragraph` field in library.properties.
	Paragraph string `protobuf:"bytes,5,opt,name=paragraph,proto3" json:"paragraph,omitempty"`
	// Value of the `url` field in library.properties.
	Website string `protobuf:"bytes,6,opt,name=website,proto3" json:"website,omitempty"`
	// Value of the `category` field in library.properties.
	Category string `protobuf:"bytes,7,opt,name=category,proto3" json:"category,omitempty"`
	// Value of the `architectures` field in library.properties.
	Architectures []string `protobuf:"bytes,8,rep,name=architectures,proto3" json:"architectures,omitempty"`
	// The type categories of the library. Possible values: `Arduino`,
	// `Partner`, `Recommended`, `Contributed`, `Retired`.
	Types []string `protobuf:"bytes,9,rep,name=types,proto3" json:"types,omitempty"`
	// The path of the library directory.
	InstallDir string `protobuf:"bytes,10,opt,name=install_dir,json=installDir,proto3" json:"install_dir,omitempty"`
	// The location of the library's source files.
	SourceDir string `protobuf:"bytes,11,opt,name=source_dir,json=sourceDir,proto3" json:"source_dir,omitempty"`
	// The location of the library's `utility` directory.
	UtilityDir string `protobuf:"bytes,12,opt,name=utility_dir,json=utilityDir,proto3" json:"utility_dir,omitempty"`
	// If `location` is `platform_builtin` or `referenced_platform_builtin`, the
	// identifying string for the platform containing the library
	// (e.g., `arduino:avr@1.8.2`).
	ContainerPlatform string `protobuf:"bytes,14,opt,name=container_platform,json=containerPlatform,proto3" json:"container_platform,omitempty"`
	// Value of the `dot_a_linkage` field in library.properties.
	DotALinkage bool `protobuf:"varint,17,opt,name=dot_a_linkage,json=dotALinkage,proto3" json:"dot_a_linkage,omitempty"`
	// Value of the `precompiled` field in library.properties.
	Precompiled bool `protobuf:"varint,18,opt,name=precompiled,proto3" json:"precompiled,omitempty"`
	// Value of the `ldflags` field in library.properties.
	LdFlags string `protobuf:"bytes,19,opt,name=ld_flags,json=ldFlags,proto3" json:"ld_flags,omitempty"`
	// A library.properties file is not present in the library's root directory.
	IsLegacy bool `protobuf:"varint,20,opt,name=is_legacy,json=isLegacy,proto3" json:"is_legacy,omitempty"`
	// Value of the `version` field in library.properties.
	Version string `protobuf:"bytes,21,opt,name=version,proto3" json:"version,omitempty"`
	// Value of the `license` field in library.properties.
	License string `protobuf:"bytes,22,opt,name=license,proto3" json:"license,omitempty"`
	// The data from the library's library.properties file, including unused
	// fields.
	Properties map[string]string `protobuf:"bytes,23,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The location type of the library installation.
	Location LibraryLocation `protobuf:"varint,24,opt,name=location,proto3,enum=cc.arduino.cli.commands.v1.LibraryLocation" json:"location,omitempty"`
	// The library format type.
	Layout LibraryLayout `protobuf:"varint,25,opt,name=layout,proto3,enum=cc.arduino.cli.commands.v1.LibraryLayout" json:"layout,omitempty"`
	// The example sketches provided by the library.
	Examples []string `protobuf:"bytes,26,rep,name=examples,proto3" json:"examples,omitempty"`
	// Value of the `includes` field in library.properties or, if missing, the
	// list of include files available on the library source root directory.
	ProvidesIncludes []string `protobuf:"bytes,27,rep,name=provides_includes,json=providesIncludes,proto3" json:"provides_includes,omitempty"`
	// Map of FQBNs that specifies if library is compatible with this library.
	CompatibleWith map[string]bool `protobuf:"bytes,28,rep,name=compatible_with,json=compatibleWith,proto3" json:"compatible_with,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// This value is set to true if the library is in development and should not
	// be treated as read-only. This status is determined by the presence of a
	// `.development` file in the library root directory.
	InDevelopment bool `protobuf:"varint,29,opt,name=in_development,json=inDevelopment,proto3" json:"in_development,omitempty"`
}

func (x *Library) Reset() {
	*x = Library{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Library) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Library) ProtoMessage() {}

func (x *Library) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Library.ProtoReflect.Descriptor instead.
func (*Library) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{22}
}

func (x *Library) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Library) GetAuthor() string {
	if x != nil {
		return x.Author
	}
	return ""
}

func (x *Library) GetMaintainer() string {
	if x != nil {
		return x.Maintainer
	}
	return ""
}

func (x *Library) GetSentence() string {
	if x != nil {
		return x.Sentence
	}
	return ""
}

func (x *Library) GetParagraph() string {
	if x != nil {
		return x.Paragraph
	}
	return ""
}

func (x *Library) GetWebsite() string {
	if x != nil {
		return x.Website
	}
	return ""
}

func (x *Library) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Library) GetArchitectures() []string {
	if x != nil {
		return x.Architectures
	}
	return nil
}

func (x *Library) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *Library) GetInstallDir() string {
	if x != nil {
		return x.InstallDir
	}
	return ""
}

func (x *Library) GetSourceDir() string {
	if x != nil {
		return x.SourceDir
	}
	return ""
}

func (x *Library) GetUtilityDir() string {
	if x != nil {
		return x.UtilityDir
	}
	return ""
}

func (x *Library) GetContainerPlatform() string {
	if x != nil {
		return x.ContainerPlatform
	}
	return ""
}

func (x *Library) GetDotALinkage() bool {
	if x != nil {
		return x.DotALinkage
	}
	return false
}

func (x *Library) GetPrecompiled() bool {
	if x != nil {
		return x.Precompiled
	}
	return false
}

func (x *Library) GetLdFlags() string {
	if x != nil {
		return x.LdFlags
	}
	return ""
}

func (x *Library) GetIsLegacy() bool {
	if x != nil {
		return x.IsLegacy
	}
	return false
}

func (x *Library) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Library) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *Library) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Library) GetLocation() LibraryLocation {
	if x != nil {
		return x.Location
	}
	return LibraryLocation_LIBRARY_LOCATION_BUILTIN
}

func (x *Library) GetLayout() LibraryLayout {
	if x != nil {
		return x.Layout
	}
	return LibraryLayout_LIBRARY_LAYOUT_FLAT
}

func (x *Library) GetExamples() []string {
	if x != nil {
		return x.Examples
	}
	return nil
}

func (x *Library) GetProvidesIncludes() []string {
	if x != nil {
		return x.ProvidesIncludes
	}
	return nil
}

func (x *Library) GetCompatibleWith() map[string]bool {
	if x != nil {
		return x.CompatibleWith
	}
	return nil
}

func (x *Library) GetInDevelopment() bool {
	if x != nil {
		return x.InDevelopment
	}
	return false
}

type ZipLibraryInstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Path to the archived library.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Set to true to overwrite an already installed library with the same name.
	// Defaults to false.
	Overwrite bool `protobuf:"varint,3,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
}

func (x *ZipLibraryInstallRequest) Reset() {
	*x = ZipLibraryInstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZipLibraryInstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZipLibraryInstallRequest) ProtoMessage() {}

func (x *ZipLibraryInstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZipLibraryInstallRequest.ProtoReflect.Descriptor instead.
func (*ZipLibraryInstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{23}
}

func (x *ZipLibraryInstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *ZipLibraryInstallRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ZipLibraryInstallRequest) GetOverwrite() bool {
	if x != nil {
		return x.Overwrite
	}
	return false
}

type ZipLibraryInstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*ZipLibraryInstallResponse_TaskProgress
	//	*ZipLibraryInstallResponse_Result_
	Message isZipLibraryInstallResponse_Message `protobuf_oneof:"message"`
}

func (x *ZipLibraryInstallResponse) Reset() {
	*x = ZipLibraryInstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZipLibraryInstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZipLibraryInstallResponse) ProtoMessage() {}

func (x *ZipLibraryInstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZipLibraryInstallResponse.ProtoReflect.Descriptor instead.
func (*ZipLibraryInstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{24}
}

func (m *ZipLibraryInstallResponse) GetMessage() isZipLibraryInstallResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *ZipLibraryInstallResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*ZipLibraryInstallResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *ZipLibraryInstallResponse) GetResult() *ZipLibraryInstallResponse_Result {
	if x, ok := x.GetMessage().(*ZipLibraryInstallResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isZipLibraryInstallResponse_Message interface {
	isZipLibraryInstallResponse_Message()
}

type ZipLibraryInstallResponse_TaskProgress struct {
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type ZipLibraryInstallResponse_Result_ struct {
	// Installation result.
	Result *ZipLibraryInstallResponse_Result `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

func (*ZipLibraryInstallResponse_TaskProgress) isZipLibraryInstallResponse_Message() {}

func (*ZipLibraryInstallResponse_Result_) isZipLibraryInstallResponse_Message() {}

type GitLibraryInstallRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// URL to the repository containing the library.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Set to true to overwrite an already installed library with the same name.
	// Defaults to false.
	Overwrite bool `protobuf:"varint,3,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
}

func (x *GitLibraryInstallRequest) Reset() {
	*x = GitLibraryInstallRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitLibraryInstallRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitLibraryInstallRequest) ProtoMessage() {}

func (x *GitLibraryInstallRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitLibraryInstallRequest.ProtoReflect.Descriptor instead.
func (*GitLibraryInstallRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{25}
}

func (x *GitLibraryInstallRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *GitLibraryInstallRequest) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *GitLibraryInstallRequest) GetOverwrite() bool {
	if x != nil {
		return x.Overwrite
	}
	return false
}

type GitLibraryInstallResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*GitLibraryInstallResponse_TaskProgress
	//	*GitLibraryInstallResponse_Result_
	Message isGitLibraryInstallResponse_Message `protobuf_oneof:"message"`
}

func (x *GitLibraryInstallResponse) Reset() {
	*x = GitLibraryInstallResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitLibraryInstallResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitLibraryInstallResponse) ProtoMessage() {}

func (x *GitLibraryInstallResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitLibraryInstallResponse.ProtoReflect.Descriptor instead.
func (*GitLibraryInstallResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{26}
}

func (m *GitLibraryInstallResponse) GetMessage() isGitLibraryInstallResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *GitLibraryInstallResponse) GetTaskProgress() *TaskProgress {
	if x, ok := x.GetMessage().(*GitLibraryInstallResponse_TaskProgress); ok {
		return x.TaskProgress
	}
	return nil
}

func (x *GitLibraryInstallResponse) GetResult() *GitLibraryInstallResponse_Result {
	if x, ok := x.GetMessage().(*GitLibraryInstallResponse_Result_); ok {
		return x.Result
	}
	return nil
}

type isGitLibraryInstallResponse_Message interface {
	isGitLibraryInstallResponse_Message()
}

type GitLibraryInstallResponse_TaskProgress struct {
	// Description of the current stage of the installation.
	TaskProgress *TaskProgress `protobuf:"bytes,1,opt,name=task_progress,json=taskProgress,proto3,oneof"`
}

type GitLibraryInstallResponse_Result_ struct {
	// Installation result.
	Result *GitLibraryInstallResponse_Result `protobuf:"bytes,2,opt,name=result,proto3,oneof"`
}

func (*GitLibraryInstallResponse_TaskProgress) isGitLibraryInstallResponse_Message() {}

func (*GitLibraryInstallResponse_Result_) isGitLibraryInstallResponse_Message() {}

type LibraryDownloadResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LibraryDownloadResponse_Result) Reset() {
	*x = LibraryDownloadResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryDownloadResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryDownloadResponse_Result) ProtoMessage() {}

func (x *LibraryDownloadResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryDownloadResponse_Result.ProtoReflect.Descriptor instead.
func (*LibraryDownloadResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{1, 0}
}

type LibraryInstallResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LibraryInstallResponse_Result) Reset() {
	*x = LibraryInstallResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryInstallResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryInstallResponse_Result) ProtoMessage() {}

func (x *LibraryInstallResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryInstallResponse_Result.ProtoReflect.Descriptor instead.
func (*LibraryInstallResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{3, 0}
}

type LibraryUpgradeResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LibraryUpgradeResponse_Result) Reset() {
	*x = LibraryUpgradeResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeResponse_Result) ProtoMessage() {}

func (x *LibraryUpgradeResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeResponse_Result.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{5, 0}
}

type LibraryUninstallResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LibraryUninstallResponse_Result) Reset() {
	*x = LibraryUninstallResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUninstallResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUninstallResponse_Result) ProtoMessage() {}

func (x *LibraryUninstallResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUninstallResponse_Result.ProtoReflect.Descriptor instead.
func (*LibraryUninstallResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{7, 0}
}

type LibraryUpgradeAllResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LibraryUpgradeAllResponse_Result) Reset() {
	*x = LibraryUpgradeAllResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryUpgradeAllResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryUpgradeAllResponse_Result) ProtoMessage() {}

func (x *LibraryUpgradeAllResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryUpgradeAllResponse_Result.ProtoReflect.Descriptor instead.
func (*LibraryUpgradeAllResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{9, 0}
}

type ZipLibraryInstallResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ZipLibraryInstallResponse_Result) Reset() {
	*x = ZipLibraryInstallResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZipLibraryInstallResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZipLibraryInstallResponse_Result) ProtoMessage() {}

func (x *ZipLibraryInstallResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZipLibraryInstallResponse_Result.ProtoReflect.Descriptor instead.
func (*ZipLibraryInstallResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{24, 0}
}

type GitLibraryInstallResponse_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GitLibraryInstallResponse_Result) Reset() {
	*x = GitLibraryInstallResponse_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitLibraryInstallResponse_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitLibraryInstallResponse_Result) ProtoMessage() {}

func (x *GitLibraryInstallResponse_Result) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitLibraryInstallResponse_Result.ProtoReflect.Descriptor instead.
func (*GitLibraryInstallResponse_Result) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP(), []int{26, 0}
}

var File_cc_arduino_cli_commands_v1_lib_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_lib_proto_rawDesc = []byte{
	0x0a, 0x24, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x62,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63,
	0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x88, 0x01, 0x0a, 0x16,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd0, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09,
	0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xa2, 0x02, 0x0a, 0x15, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x5f, 0x64, 0x65, 0x70, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x6e, 0x6f, 0x44, 0x65, 0x70, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x6e, 0x6f, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0b, 0x6e, 0x6f, 0x4f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12,
	0x5d, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f,
	0x02, 0x0a, 0x16, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x53, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x22, 0x86, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x5f, 0x64, 0x65, 0x70, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x6e, 0x6f, 0x44, 0x65, 0x70, 0x73, 0x22, 0x9f, 0x02, 0x0a, 0x16, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x53, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd7, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x55, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x6e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0x5c, 0x0a, 0x18, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22,
	0xa5, 0x02, 0x0a, 0x19, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73,
	0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61,
	0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x55,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xdd, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a,
	0x21, 0x64, 0x6f, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x64, 0x6f, 0x4e, 0x6f, 0x74, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x22, 0x7d, 0x0a, 0x22, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a,
	0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x22, 0x85, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x22, 0xad,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x6f, 0x6d, 0x69,
	0x74, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x6f, 0x6d, 0x69, 0x74, 0x52, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x72, 0x67, 0x73, 0x22, 0xab,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x09, 0x6c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
	0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x09, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xd8, 0x02, 0x0a,
	0x0f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75,
	0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x06, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79,
	0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x12,
	0x2d, 0x0a, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x67,
	0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x40, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf4, 0x03, 0x0a, 0x0e, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08,
	0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x61,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72,
	0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x24, 0x0a, 0x0d,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x63,
	0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x2b,
	0x0a, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x73, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0c, 0x64,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79,
	0x52, 0x0c, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x22, 0x56,
	0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x22, 0x9e, 0x01, 0x0a, 0x10, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x29, 0x0a,
	0x10, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x73, 0x75, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x61, 0x63, 0x68,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x50, 0x61, 0x74, 0x68, 0x22, 0xae, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x10, 0x0a, 0x03, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61,
	0x6c, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x22, 0x74, 0x0a, 0x13, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5d, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x22, 0x97,
	0x01, 0x0a, 0x10, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x07, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x12, 0x44, 0x0a, 0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x52,
	0x07, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x22, 0xf8, 0x08, 0x0a, 0x07, 0x4c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x77, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x77, 0x65, 0x62,
	0x73, 0x69, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x12, 0x24, 0x0a, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x69, 0x72, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x72, 0x12, 0x1f, 0x0a, 0x0b,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x44, 0x69, 0x72, 0x12, 0x2d, 0x0a,
	0x12, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x22, 0x0a, 0x0d,
	0x64, 0x6f, 0x74, 0x5f, 0x61, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0b, 0x64, 0x6f, 0x74, 0x41, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x67, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x65, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x64, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x64, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x69, 0x73, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x69, 0x73, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x53,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x17, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x06,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73,
	0x18, 0x1b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x73,
	0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x18, 0x1c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63,
	0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c,
	0x65, 0x57, 0x69, 0x74, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x57, 0x69, 0x74, 0x68, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6e,
	0x5f, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x1d, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x69, 0x6e, 0x44, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e,
	0x74, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x41, 0x0a, 0x13, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x57, 0x69,
	0x74, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x8e, 0x01, 0x0a, 0x18, 0x5a, 0x69, 0x70, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e,
	0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x19, 0x5a, 0x69, 0x70, 0x4c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x56, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f,
	0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x5a, 0x69, 0x70, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x22, 0x8c, 0x01, 0x0a, 0x18, 0x47, 0x69, 0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x22,
	0xd9, 0x01, 0x0a, 0x19, 0x47, 0x69, 0x74, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a,
	0x0d, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00,
	0x52, 0x0c, 0x74, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x56,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x06,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2a, 0x61, 0x0a, 0x16, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59,
	0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20, 0x4c, 0x49, 0x42, 0x52,
	0x41, 0x52, 0x59, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x4c, 0x4f, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x54, 0x49, 0x4e, 0x10, 0x01, 0x2a, 0x5a,
	0x0a, 0x13, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x20, 0x0a, 0x1c, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59,
	0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4c, 0x49, 0x42, 0x52, 0x41,
	0x52, 0x59, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x2a, 0x46, 0x0a, 0x0d, 0x4c, 0x69,
	0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x13, 0x4c,
	0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x5f, 0x4c, 0x41, 0x59, 0x4f, 0x55, 0x54, 0x5f, 0x46, 0x4c,
	0x41, 0x54, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x5f,
	0x4c, 0x41, 0x59, 0x4f, 0x55, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x55, 0x52, 0x53, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x2a, 0xc3, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52,
	0x59, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x54,
	0x49, 0x4e, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x5f,
	0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x25, 0x0a, 0x21, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x42, 0x55, 0x49,
	0x4c, 0x54, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x30, 0x0a, 0x2c, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52,
	0x59, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x46, 0x45, 0x52,
	0x45, 0x4e, 0x43, 0x45, 0x44, 0x5f, 0x50, 0x4c, 0x41, 0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x42,
	0x55, 0x49, 0x4c, 0x54, 0x49, 0x4e, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x4c, 0x49, 0x42, 0x52,
	0x41, 0x52, 0x59, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x4d,
	0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x04, 0x42, 0x48, 0x5a, 0x46, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63,
	0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_lib_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_lib_proto_rawDescData = file_cc_arduino_cli_commands_v1_lib_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_lib_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_lib_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_lib_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_lib_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_lib_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_lib_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_cc_arduino_cli_commands_v1_lib_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_cc_arduino_cli_commands_v1_lib_proto_goTypes = []any{
	(LibraryInstallLocation)(0),                // 0: cc.arduino.cli.commands.v1.LibraryInstallLocation
	(LibrarySearchStatus)(0),                   // 1: cc.arduino.cli.commands.v1.LibrarySearchStatus
	(LibraryLayout)(0),                         // 2: cc.arduino.cli.commands.v1.LibraryLayout
	(LibraryLocation)(0),                       // 3: cc.arduino.cli.commands.v1.LibraryLocation
	(*LibraryDownloadRequest)(nil),             // 4: cc.arduino.cli.commands.v1.LibraryDownloadRequest
	(*LibraryDownloadResponse)(nil),            // 5: cc.arduino.cli.commands.v1.LibraryDownloadResponse
	(*LibraryInstallRequest)(nil),              // 6: cc.arduino.cli.commands.v1.LibraryInstallRequest
	(*LibraryInstallResponse)(nil),             // 7: cc.arduino.cli.commands.v1.LibraryInstallResponse
	(*LibraryUpgradeRequest)(nil),              // 8: cc.arduino.cli.commands.v1.LibraryUpgradeRequest
	(*LibraryUpgradeResponse)(nil),             // 9: cc.arduino.cli.commands.v1.LibraryUpgradeResponse
	(*LibraryUninstallRequest)(nil),            // 10: cc.arduino.cli.commands.v1.LibraryUninstallRequest
	(*LibraryUninstallResponse)(nil),           // 11: cc.arduino.cli.commands.v1.LibraryUninstallResponse
	(*LibraryUpgradeAllRequest)(nil),           // 12: cc.arduino.cli.commands.v1.LibraryUpgradeAllRequest
	(*LibraryUpgradeAllResponse)(nil),          // 13: cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse
	(*LibraryResolveDependenciesRequest)(nil),  // 14: cc.arduino.cli.commands.v1.LibraryResolveDependenciesRequest
	(*LibraryResolveDependenciesResponse)(nil), // 15: cc.arduino.cli.commands.v1.LibraryResolveDependenciesResponse
	(*LibraryDependencyStatus)(nil),            // 16: cc.arduino.cli.commands.v1.LibraryDependencyStatus
	(*LibrarySearchRequest)(nil),               // 17: cc.arduino.cli.commands.v1.LibrarySearchRequest
	(*LibrarySearchResponse)(nil),              // 18: cc.arduino.cli.commands.v1.LibrarySearchResponse
	(*SearchedLibrary)(nil),                    // 19: cc.arduino.cli.commands.v1.SearchedLibrary
	(*LibraryRelease)(nil),                     // 20: cc.arduino.cli.commands.v1.LibraryRelease
	(*LibraryDependency)(nil),                  // 21: cc.arduino.cli.commands.v1.LibraryDependency
	(*DownloadResource)(nil),                   // 22: cc.arduino.cli.commands.v1.DownloadResource
	(*LibraryListRequest)(nil),                 // 23: cc.arduino.cli.commands.v1.LibraryListRequest
	(*LibraryListResponse)(nil),                // 24: cc.arduino.cli.commands.v1.LibraryListResponse
	(*InstalledLibrary)(nil),                   // 25: cc.arduino.cli.commands.v1.InstalledLibrary
	(*Library)(nil),                            // 26: cc.arduino.cli.commands.v1.Library
	(*ZipLibraryInstallRequest)(nil),           // 27: cc.arduino.cli.commands.v1.ZipLibraryInstallRequest
	(*ZipLibraryInstallResponse)(nil),          // 28: cc.arduino.cli.commands.v1.ZipLibraryInstallResponse
	(*GitLibraryInstallRequest)(nil),           // 29: cc.arduino.cli.commands.v1.GitLibraryInstallRequest
	(*GitLibraryInstallResponse)(nil),          // 30: cc.arduino.cli.commands.v1.GitLibraryInstallResponse
	(*LibraryDownloadResponse_Result)(nil),     // 31: cc.arduino.cli.commands.v1.LibraryDownloadResponse.Result
	(*LibraryInstallResponse_Result)(nil),      // 32: cc.arduino.cli.commands.v1.LibraryInstallResponse.Result
	(*LibraryUpgradeResponse_Result)(nil),      // 33: cc.arduino.cli.commands.v1.LibraryUpgradeResponse.Result
	(*LibraryUninstallResponse_Result)(nil),    // 34: cc.arduino.cli.commands.v1.LibraryUninstallResponse.Result
	(*LibraryUpgradeAllResponse_Result)(nil),   // 35: cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse.Result
	nil,                                        // 36: cc.arduino.cli.commands.v1.SearchedLibrary.ReleasesEntry
	nil,                                        // 37: cc.arduino.cli.commands.v1.Library.PropertiesEntry
	nil,                                        // 38: cc.arduino.cli.commands.v1.Library.CompatibleWithEntry
	(*ZipLibraryInstallResponse_Result)(nil),   // 39: cc.arduino.cli.commands.v1.ZipLibraryInstallResponse.Result
	(*GitLibraryInstallResponse_Result)(nil),   // 40: cc.arduino.cli.commands.v1.GitLibraryInstallResponse.Result
	(*Instance)(nil),                           // 41: cc.arduino.cli.commands.v1.Instance
	(*DownloadProgress)(nil),                   // 42: cc.arduino.cli.commands.v1.DownloadProgress
	(*TaskProgress)(nil),                       // 43: cc.arduino.cli.commands.v1.TaskProgress
}
var file_cc_arduino_cli_commands_v1_lib_proto_depIdxs = []int32{
	41, // 0: cc.arduino.cli.commands.v1.LibraryDownloadRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	42, // 1: cc.arduino.cli.commands.v1.LibraryDownloadResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	31, // 2: cc.arduino.cli.commands.v1.LibraryDownloadResponse.result:type_name -> cc.arduino.cli.commands.v1.LibraryDownloadResponse.Result
	41, // 3: cc.arduino.cli.commands.v1.LibraryInstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	0,  // 4: cc.arduino.cli.commands.v1.LibraryInstallRequest.install_location:type_name -> cc.arduino.cli.commands.v1.LibraryInstallLocation
	42, // 5: cc.arduino.cli.commands.v1.LibraryInstallResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	43, // 6: cc.arduino.cli.commands.v1.LibraryInstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	32, // 7: cc.arduino.cli.commands.v1.LibraryInstallResponse.result:type_name -> cc.arduino.cli.commands.v1.LibraryInstallResponse.Result
	41, // 8: cc.arduino.cli.commands.v1.LibraryUpgradeRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	42, // 9: cc.arduino.cli.commands.v1.LibraryUpgradeResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	43, // 10: cc.arduino.cli.commands.v1.LibraryUpgradeResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	33, // 11: cc.arduino.cli.commands.v1.LibraryUpgradeResponse.result:type_name -> cc.arduino.cli.commands.v1.LibraryUpgradeResponse.Result
	41, // 12: cc.arduino.cli.commands.v1.LibraryUninstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	43, // 13: cc.arduino.cli.commands.v1.LibraryUninstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	34, // 14: cc.arduino.cli.commands.v1.LibraryUninstallResponse.result:type_name -> cc.arduino.cli.commands.v1.LibraryUninstallResponse.Result
	41, // 15: cc.arduino.cli.commands.v1.LibraryUpgradeAllRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	42, // 16: cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse.progress:type_name -> cc.arduino.cli.commands.v1.DownloadProgress
	43, // 17: cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	35, // 18: cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse.result:type_name -> cc.arduino.cli.commands.v1.LibraryUpgradeAllResponse.Result
	41, // 19: cc.arduino.cli.commands.v1.LibraryResolveDependenciesRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	16, // 20: cc.arduino.cli.commands.v1.LibraryResolveDependenciesResponse.dependencies:type_name -> cc.arduino.cli.commands.v1.LibraryDependencyStatus
	41, // 21: cc.arduino.cli.commands.v1.LibrarySearchRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	19, // 22: cc.arduino.cli.commands.v1.LibrarySearchResponse.libraries:type_name -> cc.arduino.cli.commands.v1.SearchedLibrary
	1,  // 23: cc.arduino.cli.commands.v1.LibrarySearchResponse.status:type_name -> cc.arduino.cli.commands.v1.LibrarySearchStatus
	36, // 24: cc.arduino.cli.commands.v1.SearchedLibrary.releases:type_name -> cc.arduino.cli.commands.v1.SearchedLibrary.ReleasesEntry
	20, // 25: cc.arduino.cli.commands.v1.SearchedLibrary.latest:type_name -> cc.arduino.cli.commands.v1.LibraryRelease
	22, // 26: cc.arduino.cli.commands.v1.LibraryRelease.resources:type_name -> cc.arduino.cli.commands.v1.DownloadResource
	21, // 27: cc.arduino.cli.commands.v1.LibraryRelease.dependencies:type_name -> cc.arduino.cli.commands.v1.LibraryDependency
	41, // 28: cc.arduino.cli.commands.v1.LibraryListRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	25, // 29: cc.arduino.cli.commands.v1.LibraryListResponse.installed_libraries:type_name -> cc.arduino.cli.commands.v1.InstalledLibrary
	26, // 30: cc.arduino.cli.commands.v1.InstalledLibrary.library:type_name -> cc.arduino.cli.commands.v1.Library
	20, // 31: cc.arduino.cli.commands.v1.InstalledLibrary.release:type_name -> cc.arduino.cli.commands.v1.LibraryRelease
	37, // 32: cc.arduino.cli.commands.v1.Library.properties:type_name -> cc.arduino.cli.commands.v1.Library.PropertiesEntry
	3,  // 33: cc.arduino.cli.commands.v1.Library.location:type_name -> cc.arduino.cli.commands.v1.LibraryLocation
	2,  // 34: cc.arduino.cli.commands.v1.Library.layout:type_name -> cc.arduino.cli.commands.v1.LibraryLayout
	38, // 35: cc.arduino.cli.commands.v1.Library.compatible_with:type_name -> cc.arduino.cli.commands.v1.Library.CompatibleWithEntry
	41, // 36: cc.arduino.cli.commands.v1.ZipLibraryInstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	43, // 37: cc.arduino.cli.commands.v1.ZipLibraryInstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	39, // 38: cc.arduino.cli.commands.v1.ZipLibraryInstallResponse.result:type_name -> cc.arduino.cli.commands.v1.ZipLibraryInstallResponse.Result
	41, // 39: cc.arduino.cli.commands.v1.GitLibraryInstallRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	43, // 40: cc.arduino.cli.commands.v1.GitLibraryInstallResponse.task_progress:type_name -> cc.arduino.cli.commands.v1.TaskProgress
	40, // 41: cc.arduino.cli.commands.v1.GitLibraryInstallResponse.result:type_name -> cc.arduino.cli.commands.v1.GitLibraryInstallResponse.Result
	20, // 42: cc.arduino.cli.commands.v1.SearchedLibrary.ReleasesEntry.value:type_name -> cc.arduino.cli.commands.v1.LibraryRelease
	43, // [43:43] is the sub-list for method output_type
	43, // [43:43] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_lib_proto_init() }
func file_cc_arduino_cli_commands_v1_lib_proto_init() {
	if File_cc_arduino_cli_commands_v1_lib_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryDownloadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryDownloadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryInstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryInstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUpgradeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUpgradeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUninstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUninstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUpgradeAllRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUpgradeAllResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryResolveDependenciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryResolveDependenciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryDependencyStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*LibrarySearchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*LibrarySearchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*SearchedLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryRelease); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryDependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*DownloadResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*InstalledLibrary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*Library); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*ZipLibraryInstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*ZipLibraryInstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*GitLibraryInstallRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*GitLibraryInstallResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryDownloadResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryInstallResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUpgradeResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUninstallResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[31].Exporter = func(v any, i int) any {
			switch v := v.(*LibraryUpgradeAllResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[35].Exporter = func(v any, i int) any {
			switch v := v.(*ZipLibraryInstallResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[36].Exporter = func(v any, i int) any {
			switch v := v.(*GitLibraryInstallResponse_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[1].OneofWrappers = []any{
		(*LibraryDownloadResponse_Progress)(nil),
		(*LibraryDownloadResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[3].OneofWrappers = []any{
		(*LibraryInstallResponse_Progress)(nil),
		(*LibraryInstallResponse_TaskProgress)(nil),
		(*LibraryInstallResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[5].OneofWrappers = []any{
		(*LibraryUpgradeResponse_Progress)(nil),
		(*LibraryUpgradeResponse_TaskProgress)(nil),
		(*LibraryUpgradeResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[7].OneofWrappers = []any{
		(*LibraryUninstallResponse_TaskProgress)(nil),
		(*LibraryUninstallResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[9].OneofWrappers = []any{
		(*LibraryUpgradeAllResponse_Progress)(nil),
		(*LibraryUpgradeAllResponse_TaskProgress)(nil),
		(*LibraryUpgradeAllResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[24].OneofWrappers = []any{
		(*ZipLibraryInstallResponse_TaskProgress)(nil),
		(*ZipLibraryInstallResponse_Result_)(nil),
	}
	file_cc_arduino_cli_commands_v1_lib_proto_msgTypes[26].OneofWrappers = []any{
		(*GitLibraryInstallResponse_TaskProgress)(nil),
		(*GitLibraryInstallResponse_Result_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_lib_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_lib_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_lib_proto_depIdxs,
		EnumInfos:         file_cc_arduino_cli_commands_v1_lib_proto_enumTypes,
		MessageInfos:      file_cc_arduino_cli_commands_v1_lib_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_lib_proto = out.File
	file_cc_arduino_cli_commands_v1_lib_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_lib_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_lib_proto_depIdxs = nil
}
