// Code generated by smithy-go-codegen DO NOT EDIT.

package applicationsignals

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/applicationsignals/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing service level objective (SLO). If you omit parameters, the
// previous values of those parameters are retained.
//
// You cannot change from a period-based SLO to a request-based SLO, or change
// from a request-based SLO to a period-based SLO.
func (c *Client) UpdateServiceLevelObjective(ctx context.Context, params *UpdateServiceLevelObjectiveInput, optFns ...func(*Options)) (*UpdateServiceLevelObjectiveOutput, error) {
	if params == nil {
		params = &UpdateServiceLevelObjectiveInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateServiceLevelObjective", params, optFns, c.addOperationUpdateServiceLevelObjectiveMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateServiceLevelObjectiveOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateServiceLevelObjectiveInput struct {

	// The Amazon Resource Name (ARN) or name of the service level objective that you
	// want to update.
	//
	// This member is required.
	Id *string

	// Use this array to create burn rates for this SLO. Each burn rate is a metric
	// that indicates how fast the service is consuming the error budget, relative to
	// the attainment goal of the SLO.
	BurnRateConfigurations []types.BurnRateConfiguration

	// An optional description for the SLO.
	Description *string

	// A structure that contains the attributes that determine the goal of the SLO.
	// This includes the time period for evaluation and the attainment threshold.
	Goal *types.Goal

	// If this SLO is a request-based SLO, this structure defines the information
	// about what performance metric this SLO will monitor.
	//
	// You can't specify both SliConfig and RequestBasedSliConfig in the same
	// operation.
	RequestBasedSliConfig *types.RequestBasedServiceLevelIndicatorConfig

	// If this SLO is a period-based SLO, this structure defines the information about
	// what performance metric this SLO will monitor.
	SliConfig *types.ServiceLevelIndicatorConfig

	noSmithyDocumentSerde
}

type UpdateServiceLevelObjectiveOutput struct {

	// A structure that contains information about the SLO that you just updated.
	//
	// This member is required.
	Slo *types.ServiceLevelObjective

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateServiceLevelObjectiveMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateServiceLevelObjective{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateServiceLevelObjective{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateServiceLevelObjective"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateServiceLevelObjectiveValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateServiceLevelObjective(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateServiceLevelObjective(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateServiceLevelObjective",
	}
}
