// Code generated by smithy-go-codegen DO NOT EDIT.

package arczonalshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arczonalshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Update the status of autoshift observer notification. Autoshift observer
// notification enables you to be notified, through Amazon EventBridge, when there
// is an autoshift event for zonal autoshift.
//
// If the status is ENABLED , ARC includes all autoshift events when you use the
// EventBridge pattern Autoshift In Progress . When the status is DISABLED , ARC
// includes only autoshift events for autoshifts when one or more of your resources
// is included in the autoshift.
//
// For more information, see [Notifications for practice runs and autoshifts] in the Amazon Route 53 Application Recovery
// Controller Developer Guide.
//
// [Notifications for practice runs and autoshifts]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification
func (c *Client) UpdateAutoshiftObserverNotificationStatus(ctx context.Context, params *UpdateAutoshiftObserverNotificationStatusInput, optFns ...func(*Options)) (*UpdateAutoshiftObserverNotificationStatusOutput, error) {
	if params == nil {
		params = &UpdateAutoshiftObserverNotificationStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAutoshiftObserverNotificationStatus", params, optFns, c.addOperationUpdateAutoshiftObserverNotificationStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAutoshiftObserverNotificationStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAutoshiftObserverNotificationStatusInput struct {

	// The status to set for autoshift observer notification. If the status is ENABLED
	// , ARC includes all autoshift events when you use the Amazon EventBridge pattern
	// Autoshift In Progress . When the status is DISABLED , ARC includes only
	// autoshift events for autoshifts when one or more of your resources is included
	// in the autoshift.
	//
	// This member is required.
	Status types.AutoshiftObserverNotificationStatus

	noSmithyDocumentSerde
}

type UpdateAutoshiftObserverNotificationStatusOutput struct {

	// The status for autoshift observer notification.
	//
	// This member is required.
	Status types.AutoshiftObserverNotificationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAutoshiftObserverNotificationStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAutoshiftObserverNotificationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAutoshiftObserverNotificationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAutoshiftObserverNotificationStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAutoshiftObserverNotificationStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAutoshiftObserverNotificationStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAutoshiftObserverNotificationStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAutoshiftObserverNotificationStatus",
	}
}
