// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an ID namespace association.
func (c *Client) CreateIdNamespaceAssociation(ctx context.Context, params *CreateIdNamespaceAssociationInput, optFns ...func(*Options)) (*CreateIdNamespaceAssociationOutput, error) {
	if params == nil {
		params = &CreateIdNamespaceAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateIdNamespaceAssociation", params, optFns, c.addOperationCreateIdNamespaceAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateIdNamespaceAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateIdNamespaceAssociationInput struct {

	// The input reference configuration needed to create the ID namespace association.
	//
	// This member is required.
	InputReferenceConfig *types.IdNamespaceAssociationInputReferenceConfig

	// The unique identifier of the membership that contains the ID namespace
	// association.
	//
	// This member is required.
	MembershipIdentifier *string

	// The name for the ID namespace association.
	//
	// This member is required.
	Name *string

	// The description of the ID namespace association.
	Description *string

	// The configuration settings for the ID mapping table.
	IdMappingConfig *types.IdMappingConfig

	// An optional label that you can assign to a resource when you create it. Each
	// tag consists of a key and an optional value, both of which you define. When you
	// use tagging, you can also use tag-based access control in IAM policies to
	// control access to this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateIdNamespaceAssociationOutput struct {

	// The ID namespace association that was created.
	//
	// This member is required.
	IdNamespaceAssociation *types.IdNamespaceAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateIdNamespaceAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateIdNamespaceAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateIdNamespaceAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateIdNamespaceAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateIdNamespaceAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateIdNamespaceAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateIdNamespaceAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateIdNamespaceAssociation",
	}
}
