// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes details of a resource scan.
func (c *Client) DescribeResourceScan(ctx context.Context, params *DescribeResourceScanInput, optFns ...func(*Options)) (*DescribeResourceScanOutput, error) {
	if params == nil {
		params = &DescribeResourceScanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeResourceScan", params, optFns, c.addOperationDescribeResourceScanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeResourceScanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeResourceScanInput struct {

	// The Amazon Resource Name (ARN) of the resource scan.
	//
	// This member is required.
	ResourceScanId *string

	noSmithyDocumentSerde
}

type DescribeResourceScanOutput struct {

	// The time that the resource scan was finished.
	EndTime *time.Time

	// The percentage of the resource scan that has been completed.
	PercentageCompleted *float64

	// The Amazon Resource Name (ARN) of the resource scan. The format is
	// arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id} . An
	// example is
	// arn:aws:cloudformation:us-east-1:123456789012:resourceScan/f5b490f7-7ed4-428a-aa06-31ff25db0772
	// .
	ResourceScanId *string

	// The list of resource types for the specified scan. Resource types are only
	// available for scans with a Status set to COMPLETE or FAILED .
	ResourceTypes []string

	// The number of resources that were read. This is only available for scans with a
	// Status set to COMPLETE , EXPIRED , or FAILED .
	//
	// This field may be 0 if the resource scan failed with a
	// ResourceScanLimitExceededException .
	ResourcesRead *int32

	// The number of resources that were listed. This is only available for scans with
	// a Status set to COMPLETE , EXPIRED , or FAILED .
	ResourcesScanned *int32

	// The scan filters that were used.
	ScanFilters []types.ScanFilter

	// The time that the resource scan was started.
	StartTime *time.Time

	// Status of the resource scan.
	//
	// IN_PROGRESS
	//
	// The resource scan is still in progress.
	//
	// COMPLETE
	//
	// The resource scan is complete.
	//
	// EXPIRED
	//
	// The resource scan has expired.
	//
	// FAILED
	//
	// The resource scan has failed.
	Status types.ResourceScanStatus

	// The reason for the resource scan status, providing more information if a
	// failure happened.
	StatusReason *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeResourceScanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeResourceScan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeResourceScan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeResourceScan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeResourceScanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeResourceScan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeResourceScan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeResourceScan",
	}
}
