// Code generated by smithy-go-codegen DO NOT EDIT.

package dataexchange

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/dataexchange/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This operation creates a data grant.
func (c *Client) CreateDataGrant(ctx context.Context, params *CreateDataGrantInput, optFns ...func(*Options)) (*CreateDataGrantOutput, error) {
	if params == nil {
		params = &CreateDataGrantInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataGrant", params, optFns, c.addOperationCreateDataGrantMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataGrantOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataGrantInput struct {

	// The distribution scope of the data grant.
	//
	// This member is required.
	GrantDistributionScope types.GrantDistributionScope

	// The name of the data grant.
	//
	// This member is required.
	Name *string

	// The Amazon Web Services account ID of the data grant receiver.
	//
	// This member is required.
	ReceiverPrincipal *string

	// The ID of the data set used to create the data grant.
	//
	// This member is required.
	SourceDataSetId *string

	// The description of the data grant.
	Description *string

	// The timestamp of when access to the associated data set ends.
	EndsAt *time.Time

	// The tags to add to the data grant. A tag is a key-value pair.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateDataGrantOutput struct {

	// The acceptance state of the data grant.
	//
	// This member is required.
	AcceptanceState types.DataGrantAcceptanceState

	// The Amazon Resource Name (ARN) of the data grant.
	//
	// This member is required.
	Arn *string

	// The timestamp of when the data grant was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the data set associated to the data grant.
	//
	// This member is required.
	DataSetId *string

	// The distribution scope for the data grant.
	//
	// This member is required.
	GrantDistributionScope types.GrantDistributionScope

	// The ID of the data grant.
	//
	// This member is required.
	Id *string

	// The name of the data grant.
	//
	// This member is required.
	Name *string

	// The Amazon Web Services account ID of the data grant receiver.
	//
	// This member is required.
	ReceiverPrincipal *string

	// The Amazon Web Services account ID of the data grant sender.
	//
	// This member is required.
	SenderPrincipal *string

	// The ID of the data set used to create the data grant.
	//
	// This member is required.
	SourceDataSetId *string

	// The timestamp of when the data grant was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The timestamp of when the data grant was accepted.
	AcceptedAt *time.Time

	// The description of the data grant.
	Description *string

	// The timestamp of when access to the associated data set ends.
	EndsAt *time.Time

	// The tags associated to the data grant. A tag is a key-value pair.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataGrantMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataGrant{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataGrant{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataGrant"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataGrantValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataGrant(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataGrant(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataGrant",
	}
}
