// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a data product revision.
func (c *Client) CreateDataProductRevision(ctx context.Context, params *CreateDataProductRevisionInput, optFns ...func(*Options)) (*CreateDataProductRevisionOutput, error) {
	if params == nil {
		params = &CreateDataProductRevisionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataProductRevision", params, optFns, c.addOperationCreateDataProductRevisionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataProductRevisionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataProductRevisionInput struct {

	// The ID of the domain where the data product revision is created.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the data product revision.
	//
	// This member is required.
	Identifier *string

	// The name of the data product revision.
	//
	// This member is required.
	Name *string

	// A unique, case-sensitive identifier that is provided to ensure the idempotency
	// of the request.
	ClientToken *string

	// The description of the data product revision.
	Description *string

	// The metadata forms of the data product revision.
	FormsInput []types.FormInput

	// The glossary terms of the data product revision.
	GlossaryTerms []string

	// The data assets of the data product revision.
	Items []types.DataProductItem

	noSmithyDocumentSerde
}

type CreateDataProductRevisionOutput struct {

	// The ID of the domain where data product revision is created.
	//
	// This member is required.
	DomainId *string

	// The ID of the data product revision.
	//
	// This member is required.
	Id *string

	// The name of the data product revision.
	//
	// This member is required.
	Name *string

	// The ID of the owning project of the data product revision.
	//
	// This member is required.
	OwningProjectId *string

	// The revision of the data product revision.
	//
	// This member is required.
	Revision *string

	// The status of the data product revision.
	//
	// This member is required.
	Status types.DataProductStatus

	// The timestamp at which the data product revision is created.
	CreatedAt *time.Time

	// The user who created the data product revision.
	CreatedBy *string

	// The description of the data product revision.
	Description *string

	// The timestamp at which the first revision of the data product is created.
	FirstRevisionCreatedAt *time.Time

	// The user who created the first revision of the data product.
	FirstRevisionCreatedBy *string

	// The metadata forms of the data product revision.
	FormsOutput []types.FormOutput

	// The glossary terms of the data product revision.
	GlossaryTerms []string

	// The data assets of the data product revision.
	Items []types.DataProductItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataProductRevisionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataProductRevision{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataProductRevision{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataProductRevision"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateDataProductRevisionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataProductRevisionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataProductRevision(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateDataProductRevision struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateDataProductRevision) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateDataProductRevision) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateDataProductRevisionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateDataProductRevisionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateDataProductRevisionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateDataProductRevision{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateDataProductRevision(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataProductRevision",
	}
}
