// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticache

import (
	"bytes"
	"context"
	"encoding/xml"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	awsxml "github.com/aws/aws-sdk-go-v2/aws/protocol/xml"
	"github.com/aws/aws-sdk-go-v2/service/elasticache/types"
	smithy "github.com/aws/smithy-go"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strconv"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type awsAwsquery_deserializeOpAddTagsToResource struct {
}

func (*awsAwsquery_deserializeOpAddTagsToResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAddTagsToResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAddTagsToResource(response, &metadata)
	}
	output := &AddTagsToResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AddTagsToResourceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAddTagsToResourceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAddTagsToResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidARN", errorCode):
		return awsAwsquery_deserializeErrorInvalidARNFault(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheSnapshotStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedCacheNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpAuthorizeCacheSecurityGroupIngress struct {
}

func (*awsAwsquery_deserializeOpAuthorizeCacheSecurityGroupIngress) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpAuthorizeCacheSecurityGroupIngress) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorAuthorizeCacheSecurityGroupIngress(response, &metadata)
	}
	output := &AuthorizeCacheSecurityGroupIngressOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("AuthorizeCacheSecurityGroupIngressResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentAuthorizeCacheSecurityGroupIngressOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorAuthorizeCacheSecurityGroupIngress(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpBatchApplyUpdateAction struct {
}

func (*awsAwsquery_deserializeOpBatchApplyUpdateAction) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpBatchApplyUpdateAction) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorBatchApplyUpdateAction(response, &metadata)
	}
	output := &BatchApplyUpdateActionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("BatchApplyUpdateActionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentBatchApplyUpdateActionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorBatchApplyUpdateAction(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServiceUpdateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceUpdateNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpBatchStopUpdateAction struct {
}

func (*awsAwsquery_deserializeOpBatchStopUpdateAction) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpBatchStopUpdateAction) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorBatchStopUpdateAction(response, &metadata)
	}
	output := &BatchStopUpdateActionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("BatchStopUpdateActionResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentBatchStopUpdateActionOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorBatchStopUpdateAction(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServiceUpdateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceUpdateNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCompleteMigration struct {
}

func (*awsAwsquery_deserializeOpCompleteMigration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCompleteMigration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCompleteMigration(response, &metadata)
	}
	output := &CompleteMigrationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CompleteMigrationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCompleteMigrationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCompleteMigration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotUnderMigrationFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotUnderMigrationFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCopyServerlessCacheSnapshot struct {
}

func (*awsAwsquery_deserializeOpCopyServerlessCacheSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCopyServerlessCacheSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCopyServerlessCacheSnapshot(response, &metadata)
	}
	output := &CopyServerlessCacheSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CopyServerlessCacheSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCopyServerlessCacheSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCopyServerlessCacheSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheSnapshotStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCopySnapshot struct {
}

func (*awsAwsquery_deserializeOpCopySnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCopySnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCopySnapshot(response, &metadata)
	}
	output := &CopySnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CopySnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCopySnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCopySnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidSnapshotStateFault(response, errorBody)

	case strings.EqualFold("SnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateCacheCluster struct {
}

func (*awsAwsquery_deserializeOpCreateCacheCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateCacheCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateCacheCluster(response, &metadata)
	}
	output := &CreateCacheClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateCacheClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateCacheClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateCacheCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForClusterExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForClusterExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateCacheParameterGroup struct {
}

func (*awsAwsquery_deserializeOpCreateCacheParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateCacheParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateCacheParameterGroup(response, &metadata)
	}
	output := &CreateCacheParameterGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateCacheParameterGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateCacheParameterGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateCacheParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheParameterGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidCacheParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheParameterGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateCacheSecurityGroup struct {
}

func (*awsAwsquery_deserializeOpCreateCacheSecurityGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateCacheSecurityGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateCacheSecurityGroup(response, &metadata)
	}
	output := &CreateCacheSecurityGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateCacheSecurityGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateCacheSecurityGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateCacheSecurityGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSecurityGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("QuotaExceeded.CacheSecurityGroup", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateCacheSubnetGroup struct {
}

func (*awsAwsquery_deserializeOpCreateCacheSubnetGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateCacheSubnetGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateCacheSubnetGroup(response, &metadata)
	}
	output := &CreateCacheSubnetGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateCacheSubnetGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateCacheSubnetGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateCacheSubnetGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSubnetGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("CacheSubnetQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidSubnet", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubnet(response, errorBody)

	case strings.EqualFold("SubnetNotAllowedFault", errorCode):
		return awsAwsquery_deserializeErrorSubnetNotAllowedFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpCreateGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateGlobalReplicationGroup(response, &metadata)
	}
	output := &CreateGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpCreateReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateReplicationGroup(response, &metadata)
	}
	output := &CreateReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ClusterQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidUserGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NodeGroupsPerReplicationGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeGroupsPerReplicationGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForClusterExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForClusterExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateServerlessCache struct {
}

func (*awsAwsquery_deserializeOpCreateServerlessCache) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateServerlessCache) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateServerlessCache(response, &metadata)
	}
	output := &CreateServerlessCacheOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateServerlessCacheResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateServerlessCacheOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateServerlessCache(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidCredentialsException", errorCode):
		return awsAwsquery_deserializeErrorInvalidCredentialsException(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("InvalidUserGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheQuotaForCustomerExceededFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateServerlessCacheSnapshot struct {
}

func (*awsAwsquery_deserializeOpCreateServerlessCacheSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateServerlessCacheSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateServerlessCacheSnapshot(response, &metadata)
	}
	output := &CreateServerlessCacheSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateServerlessCacheSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateServerlessCacheSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateServerlessCacheSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateSnapshot struct {
}

func (*awsAwsquery_deserializeOpCreateSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateSnapshot(response, &metadata)
	}
	output := &CreateSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotFeatureNotSupportedFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotFeatureNotSupportedFault(response, errorBody)

	case strings.EqualFold("SnapshotQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotQuotaExceededFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateUser struct {
}

func (*awsAwsquery_deserializeOpCreateUser) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateUser) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateUser(response, &metadata)
	}
	output := &CreateUserOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateUserResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateUserOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateUser(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DuplicateUserName", errorCode):
		return awsAwsquery_deserializeErrorDuplicateUserNameFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	case strings.EqualFold("UserAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorUserAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("UserQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorUserQuotaExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpCreateUserGroup struct {
}

func (*awsAwsquery_deserializeOpCreateUserGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpCreateUserGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorCreateUserGroup(response, &metadata)
	}
	output := &CreateUserGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("CreateUserGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentCreateUserGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorCreateUserGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DefaultUserRequired", errorCode):
		return awsAwsquery_deserializeErrorDefaultUserRequired(response, errorBody)

	case strings.EqualFold("DuplicateUserName", errorCode):
		return awsAwsquery_deserializeErrorDuplicateUserNameFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	case strings.EqualFold("UserGroupAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorUserGroupAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("UserGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorUserGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDecreaseNodeGroupsInGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpDecreaseNodeGroupsInGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDecreaseNodeGroupsInGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDecreaseNodeGroupsInGlobalReplicationGroup(response, &metadata)
	}
	output := &DecreaseNodeGroupsInGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DecreaseNodeGroupsInGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDecreaseNodeGroupsInGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDecreaseNodeGroupsInGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDecreaseReplicaCount struct {
}

func (*awsAwsquery_deserializeOpDecreaseReplicaCount) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDecreaseReplicaCount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDecreaseReplicaCount(response, &metadata)
	}
	output := &DecreaseReplicaCountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DecreaseReplicaCountResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDecreaseReplicaCountOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDecreaseReplicaCount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NoOperationFault", errorCode):
		return awsAwsquery_deserializeErrorNoOperationFault(response, errorBody)

	case strings.EqualFold("NodeGroupsPerReplicationGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeGroupsPerReplicationGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteCacheCluster struct {
}

func (*awsAwsquery_deserializeOpDeleteCacheCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteCacheCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteCacheCluster(response, &metadata)
	}
	output := &DeleteCacheClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteCacheClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteCacheClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteCacheCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("SnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotFeatureNotSupportedFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotFeatureNotSupportedFault(response, errorBody)

	case strings.EqualFold("SnapshotQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotQuotaExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteCacheParameterGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteCacheParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteCacheParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteCacheParameterGroup(response, &metadata)
	}
	output := &DeleteCacheParameterGroupOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteCacheParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheParameterGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteCacheSecurityGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteCacheSecurityGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteCacheSecurityGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteCacheSecurityGroup(response, &metadata)
	}
	output := &DeleteCacheSecurityGroupOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteCacheSecurityGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteCacheSubnetGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteCacheSubnetGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteCacheSubnetGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteCacheSubnetGroup(response, &metadata)
	}
	output := &DeleteCacheSubnetGroupOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteCacheSubnetGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSubnetGroupInUse", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupInUse(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteGlobalReplicationGroup(response, &metadata)
	}
	output := &DeleteGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteReplicationGroup(response, &metadata)
	}
	output := &DeleteReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("SnapshotFeatureNotSupportedFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotFeatureNotSupportedFault(response, errorBody)

	case strings.EqualFold("SnapshotQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotQuotaExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteServerlessCache struct {
}

func (*awsAwsquery_deserializeOpDeleteServerlessCache) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteServerlessCache) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteServerlessCache(response, &metadata)
	}
	output := &DeleteServerlessCacheOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteServerlessCacheResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteServerlessCacheOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteServerlessCache(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidCredentialsException", errorCode):
		return awsAwsquery_deserializeErrorInvalidCredentialsException(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotAlreadyExistsFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteServerlessCacheSnapshot struct {
}

func (*awsAwsquery_deserializeOpDeleteServerlessCacheSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteServerlessCacheSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteServerlessCacheSnapshot(response, &metadata)
	}
	output := &DeleteServerlessCacheSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteServerlessCacheSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteServerlessCacheSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteServerlessCacheSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheSnapshotStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteSnapshot struct {
}

func (*awsAwsquery_deserializeOpDeleteSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteSnapshot(response, &metadata)
	}
	output := &DeleteSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidSnapshotState", errorCode):
		return awsAwsquery_deserializeErrorInvalidSnapshotStateFault(response, errorBody)

	case strings.EqualFold("SnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteUser struct {
}

func (*awsAwsquery_deserializeOpDeleteUser) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteUser) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteUser(response, &metadata)
	}
	output := &DeleteUserOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteUserResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteUserOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteUser(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DefaultUserAssociatedToUserGroup", errorCode):
		return awsAwsquery_deserializeErrorDefaultUserAssociatedToUserGroupFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidUserState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserStateFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDeleteUserGroup struct {
}

func (*awsAwsquery_deserializeOpDeleteUserGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDeleteUserGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDeleteUserGroup(response, &metadata)
	}
	output := &DeleteUserGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DeleteUserGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDeleteUserGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDeleteUserGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidUserGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCacheClusters struct {
}

func (*awsAwsquery_deserializeOpDescribeCacheClusters) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCacheClusters) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCacheClusters(response, &metadata)
	}
	output := &DescribeCacheClustersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCacheClustersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCacheClustersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCacheClusters(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCacheEngineVersions struct {
}

func (*awsAwsquery_deserializeOpDescribeCacheEngineVersions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCacheEngineVersions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCacheEngineVersions(response, &metadata)
	}
	output := &DescribeCacheEngineVersionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCacheEngineVersionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCacheEngineVersionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCacheEngineVersions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCacheParameterGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeCacheParameterGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCacheParameterGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCacheParameterGroups(response, &metadata)
	}
	output := &DescribeCacheParameterGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCacheParameterGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCacheParameterGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCacheParameterGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCacheParameters struct {
}

func (*awsAwsquery_deserializeOpDescribeCacheParameters) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCacheParameters) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCacheParameters(response, &metadata)
	}
	output := &DescribeCacheParametersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCacheParametersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCacheParametersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCacheParameters(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCacheSecurityGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeCacheSecurityGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCacheSecurityGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCacheSecurityGroups(response, &metadata)
	}
	output := &DescribeCacheSecurityGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCacheSecurityGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCacheSecurityGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCacheSecurityGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeCacheSubnetGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeCacheSubnetGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeCacheSubnetGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeCacheSubnetGroups(response, &metadata)
	}
	output := &DescribeCacheSubnetGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeCacheSubnetGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeCacheSubnetGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeCacheSubnetGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEngineDefaultParameters struct {
}

func (*awsAwsquery_deserializeOpDescribeEngineDefaultParameters) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEngineDefaultParameters) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEngineDefaultParameters(response, &metadata)
	}
	output := &DescribeEngineDefaultParametersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEngineDefaultParametersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEngineDefaultParametersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEngineDefaultParameters(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeEvents struct {
}

func (*awsAwsquery_deserializeOpDescribeEvents) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeEvents) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeEvents(response, &metadata)
	}
	output := &DescribeEventsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeEventsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeEventsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeEvents(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeGlobalReplicationGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeGlobalReplicationGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeGlobalReplicationGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeGlobalReplicationGroups(response, &metadata)
	}
	output := &DescribeGlobalReplicationGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeGlobalReplicationGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeGlobalReplicationGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeGlobalReplicationGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeReplicationGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeReplicationGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeReplicationGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeReplicationGroups(response, &metadata)
	}
	output := &DescribeReplicationGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeReplicationGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeReplicationGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeReplicationGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeReservedCacheNodes struct {
}

func (*awsAwsquery_deserializeOpDescribeReservedCacheNodes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeReservedCacheNodes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeReservedCacheNodes(response, &metadata)
	}
	output := &DescribeReservedCacheNodesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeReservedCacheNodesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeReservedCacheNodesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeReservedCacheNodes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ReservedCacheNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodeNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeReservedCacheNodesOfferings struct {
}

func (*awsAwsquery_deserializeOpDescribeReservedCacheNodesOfferings) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeReservedCacheNodesOfferings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeReservedCacheNodesOfferings(response, &metadata)
	}
	output := &DescribeReservedCacheNodesOfferingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeReservedCacheNodesOfferingsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeReservedCacheNodesOfferingsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeReservedCacheNodesOfferings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ReservedCacheNodesOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodesOfferingNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeServerlessCaches struct {
}

func (*awsAwsquery_deserializeOpDescribeServerlessCaches) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeServerlessCaches) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeServerlessCaches(response, &metadata)
	}
	output := &DescribeServerlessCachesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeServerlessCachesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeServerlessCachesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeServerlessCaches(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeServerlessCacheSnapshots struct {
}

func (*awsAwsquery_deserializeOpDescribeServerlessCacheSnapshots) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeServerlessCacheSnapshots) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeServerlessCacheSnapshots(response, &metadata)
	}
	output := &DescribeServerlessCacheSnapshotsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeServerlessCacheSnapshotsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeServerlessCacheSnapshotsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeServerlessCacheSnapshots(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeServiceUpdates struct {
}

func (*awsAwsquery_deserializeOpDescribeServiceUpdates) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeServiceUpdates) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeServiceUpdates(response, &metadata)
	}
	output := &DescribeServiceUpdatesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeServiceUpdatesResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeServiceUpdatesOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeServiceUpdates(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ServiceUpdateNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceUpdateNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeSnapshots struct {
}

func (*awsAwsquery_deserializeOpDescribeSnapshots) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeSnapshots) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeSnapshots(response, &metadata)
	}
	output := &DescribeSnapshotsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeSnapshotsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeSnapshotsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeSnapshots(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("SnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeUpdateActions struct {
}

func (*awsAwsquery_deserializeOpDescribeUpdateActions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeUpdateActions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeUpdateActions(response, &metadata)
	}
	output := &DescribeUpdateActionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeUpdateActionsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeUpdateActionsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeUpdateActions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeUserGroups struct {
}

func (*awsAwsquery_deserializeOpDescribeUserGroups) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeUserGroups) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeUserGroups(response, &metadata)
	}
	output := &DescribeUserGroupsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeUserGroupsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeUserGroupsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeUserGroups(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDescribeUsers struct {
}

func (*awsAwsquery_deserializeOpDescribeUsers) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDescribeUsers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDescribeUsers(response, &metadata)
	}
	output := &DescribeUsersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DescribeUsersResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDescribeUsersOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDescribeUsers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpDisassociateGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpDisassociateGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpDisassociateGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorDisassociateGlobalReplicationGroup(response, &metadata)
	}
	output := &DisassociateGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("DisassociateGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentDisassociateGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorDisassociateGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpExportServerlessCacheSnapshot struct {
}

func (*awsAwsquery_deserializeOpExportServerlessCacheSnapshot) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpExportServerlessCacheSnapshot) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorExportServerlessCacheSnapshot(response, &metadata)
	}
	output := &ExportServerlessCacheSnapshotOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ExportServerlessCacheSnapshotResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentExportServerlessCacheSnapshotOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorExportServerlessCacheSnapshot(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheSnapshotStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpFailoverGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpFailoverGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpFailoverGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorFailoverGlobalReplicationGroup(response, &metadata)
	}
	output := &FailoverGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("FailoverGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentFailoverGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorFailoverGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpIncreaseNodeGroupsInGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpIncreaseNodeGroupsInGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpIncreaseNodeGroupsInGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorIncreaseNodeGroupsInGlobalReplicationGroup(response, &metadata)
	}
	output := &IncreaseNodeGroupsInGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("IncreaseNodeGroupsInGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentIncreaseNodeGroupsInGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorIncreaseNodeGroupsInGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpIncreaseReplicaCount struct {
}

func (*awsAwsquery_deserializeOpIncreaseReplicaCount) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpIncreaseReplicaCount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorIncreaseReplicaCount(response, &metadata)
	}
	output := &IncreaseReplicaCountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("IncreaseReplicaCountResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentIncreaseReplicaCountOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorIncreaseReplicaCount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("ClusterQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorClusterQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidKMSKeyFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidKMSKeyFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NoOperationFault", errorCode):
		return awsAwsquery_deserializeErrorNoOperationFault(response, errorBody)

	case strings.EqualFold("NodeGroupsPerReplicationGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeGroupsPerReplicationGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListAllowedNodeTypeModifications struct {
}

func (*awsAwsquery_deserializeOpListAllowedNodeTypeModifications) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListAllowedNodeTypeModifications) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListAllowedNodeTypeModifications(response, &metadata)
	}
	output := &ListAllowedNodeTypeModificationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListAllowedNodeTypeModificationsResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListAllowedNodeTypeModificationsOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListAllowedNodeTypeModifications(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpListTagsForResource struct {
}

func (*awsAwsquery_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ListTagsForResourceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentListTagsForResourceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidARN", errorCode):
		return awsAwsquery_deserializeErrorInvalidARNFault(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheSnapshotStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedCacheNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyCacheCluster struct {
}

func (*awsAwsquery_deserializeOpModifyCacheCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyCacheCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyCacheCluster(response, &metadata)
	}
	output := &ModifyCacheClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyCacheClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyCacheClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyCacheCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidCacheSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForClusterExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForClusterExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyCacheParameterGroup struct {
}

func (*awsAwsquery_deserializeOpModifyCacheParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyCacheParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyCacheParameterGroup(response, &metadata)
	}
	output := &ModifyCacheParameterGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyCacheParameterGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyCacheParameterGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyCacheParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheParameterGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyCacheSubnetGroup struct {
}

func (*awsAwsquery_deserializeOpModifyCacheSubnetGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyCacheSubnetGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyCacheSubnetGroup(response, &metadata)
	}
	output := &ModifyCacheSubnetGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyCacheSubnetGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyCacheSubnetGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyCacheSubnetGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSubnetQuotaExceededFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetQuotaExceededFault(response, errorBody)

	case strings.EqualFold("InvalidSubnet", errorCode):
		return awsAwsquery_deserializeErrorInvalidSubnet(response, errorBody)

	case strings.EqualFold("SubnetInUse", errorCode):
		return awsAwsquery_deserializeErrorSubnetInUse(response, errorBody)

	case strings.EqualFold("SubnetNotAllowedFault", errorCode):
		return awsAwsquery_deserializeErrorSubnetNotAllowedFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpModifyGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyGlobalReplicationGroup(response, &metadata)
	}
	output := &ModifyGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpModifyReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyReplicationGroup(response, &metadata)
	}
	output := &ModifyReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidCacheSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidKMSKeyFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidKMSKeyFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidUserGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForClusterExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForClusterExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyReplicationGroupShardConfiguration struct {
}

func (*awsAwsquery_deserializeOpModifyReplicationGroupShardConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyReplicationGroupShardConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyReplicationGroupShardConfiguration(response, &metadata)
	}
	output := &ModifyReplicationGroupShardConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyReplicationGroupShardConfigurationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyReplicationGroupShardConfigurationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyReplicationGroupShardConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InsufficientCacheClusterCapacity", errorCode):
		return awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidKMSKeyFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidKMSKeyFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidVPCNetworkStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response, errorBody)

	case strings.EqualFold("NodeGroupsPerReplicationGroupQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeGroupsPerReplicationGroupQuotaExceededFault(response, errorBody)

	case strings.EqualFold("NodeQuotaForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyServerlessCache struct {
}

func (*awsAwsquery_deserializeOpModifyServerlessCache) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyServerlessCache) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyServerlessCache(response, &metadata)
	}
	output := &ModifyServerlessCacheOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyServerlessCacheResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyServerlessCacheOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyServerlessCache(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidCredentialsException", errorCode):
		return awsAwsquery_deserializeErrorInvalidCredentialsException(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("InvalidUserGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyUser struct {
}

func (*awsAwsquery_deserializeOpModifyUser) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyUser) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyUser(response, &metadata)
	}
	output := &ModifyUserOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyUserResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyUserOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyUser(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidUserState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserStateFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpModifyUserGroup struct {
}

func (*awsAwsquery_deserializeOpModifyUserGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpModifyUserGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorModifyUserGroup(response, &metadata)
	}
	output := &ModifyUserGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ModifyUserGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentModifyUserGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorModifyUserGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("DefaultUserRequired", errorCode):
		return awsAwsquery_deserializeErrorDefaultUserRequired(response, errorBody)

	case strings.EqualFold("DuplicateUserName", errorCode):
		return awsAwsquery_deserializeErrorDuplicateUserNameFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidUserGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response, errorBody)

	case strings.EqualFold("ServiceLinkedRoleNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpPurchaseReservedCacheNodesOffering struct {
}

func (*awsAwsquery_deserializeOpPurchaseReservedCacheNodesOffering) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpPurchaseReservedCacheNodesOffering) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorPurchaseReservedCacheNodesOffering(response, &metadata)
	}
	output := &PurchaseReservedCacheNodesOfferingOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("PurchaseReservedCacheNodesOfferingResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentPurchaseReservedCacheNodesOfferingOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorPurchaseReservedCacheNodesOffering(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("ReservedCacheNodeAlreadyExists", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("ReservedCacheNodeQuotaExceeded", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodeQuotaExceededFault(response, errorBody)

	case strings.EqualFold("ReservedCacheNodesOfferingNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodesOfferingNotFoundFault(response, errorBody)

	case strings.EqualFold("TagQuotaPerResourceExceeded", errorCode):
		return awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRebalanceSlotsInGlobalReplicationGroup struct {
}

func (*awsAwsquery_deserializeOpRebalanceSlotsInGlobalReplicationGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRebalanceSlotsInGlobalReplicationGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRebalanceSlotsInGlobalReplicationGroup(response, &metadata)
	}
	output := &RebalanceSlotsInGlobalReplicationGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RebalanceSlotsInGlobalReplicationGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRebalanceSlotsInGlobalReplicationGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRebalanceSlotsInGlobalReplicationGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("GlobalReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRebootCacheCluster struct {
}

func (*awsAwsquery_deserializeOpRebootCacheCluster) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRebootCacheCluster) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRebootCacheCluster(response, &metadata)
	}
	output := &RebootCacheClusterOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RebootCacheClusterResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRebootCacheClusterOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRebootCacheCluster(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRemoveTagsFromResource struct {
}

func (*awsAwsquery_deserializeOpRemoveTagsFromResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRemoveTagsFromResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRemoveTagsFromResource(response, &metadata)
	}
	output := &RemoveTagsFromResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RemoveTagsFromResourceResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRemoveTagsFromResourceOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRemoveTagsFromResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheClusterNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSubnetGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidARN", errorCode):
		return awsAwsquery_deserializeErrorInvalidARNFault(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheSnapshotStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response, errorBody)

	case strings.EqualFold("InvalidServerlessCacheStateFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ReservedCacheNodeNotFound", errorCode):
		return awsAwsquery_deserializeErrorReservedCacheNodeNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response, errorBody)

	case strings.EqualFold("ServerlessCacheSnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("SnapshotNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorSnapshotNotFoundFault(response, errorBody)

	case strings.EqualFold("TagNotFound", errorCode):
		return awsAwsquery_deserializeErrorTagNotFoundFault(response, errorBody)

	case strings.EqualFold("UserGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("UserNotFound", errorCode):
		return awsAwsquery_deserializeErrorUserNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpResetCacheParameterGroup struct {
}

func (*awsAwsquery_deserializeOpResetCacheParameterGroup) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpResetCacheParameterGroup) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorResetCacheParameterGroup(response, &metadata)
	}
	output := &ResetCacheParameterGroupOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("ResetCacheParameterGroupResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentResetCacheParameterGroupOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorResetCacheParameterGroup(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("CacheParameterGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheParameterGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheParameterGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidGlobalReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpRevokeCacheSecurityGroupIngress struct {
}

func (*awsAwsquery_deserializeOpRevokeCacheSecurityGroupIngress) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpRevokeCacheSecurityGroupIngress) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorRevokeCacheSecurityGroupIngress(response, &metadata)
	}
	output := &RevokeCacheSecurityGroupIngressOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("RevokeCacheSecurityGroupIngressResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentRevokeCacheSecurityGroupIngressOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorRevokeCacheSecurityGroupIngress(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("AuthorizationNotFound", errorCode):
		return awsAwsquery_deserializeErrorAuthorizationNotFoundFault(response, errorBody)

	case strings.EqualFold("CacheSecurityGroupNotFound", errorCode):
		return awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("InvalidCacheSecurityGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheSecurityGroupStateFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpStartMigration struct {
}

func (*awsAwsquery_deserializeOpStartMigration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpStartMigration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorStartMigration(response, &metadata)
	}
	output := &StartMigrationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("StartMigrationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentStartMigrationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorStartMigration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupAlreadyUnderMigrationFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupAlreadyUnderMigrationFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpTestFailover struct {
}

func (*awsAwsquery_deserializeOpTestFailover) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpTestFailover) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorTestFailover(response, &metadata)
	}
	output := &TestFailoverOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("TestFailoverResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentTestFailoverOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorTestFailover(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("APICallRateForCustomerExceeded", errorCode):
		return awsAwsquery_deserializeErrorAPICallRateForCustomerExceededFault(response, errorBody)

	case strings.EqualFold("InvalidCacheClusterState", errorCode):
		return awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response, errorBody)

	case strings.EqualFold("InvalidKMSKeyFault", errorCode):
		return awsAwsquery_deserializeErrorInvalidKMSKeyFault(response, errorBody)

	case strings.EqualFold("InvalidParameterCombination", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterCombinationException(response, errorBody)

	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("NodeGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorNodeGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	case strings.EqualFold("TestFailoverNotAvailableFault", errorCode):
		return awsAwsquery_deserializeErrorTestFailoverNotAvailableFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsquery_deserializeOpTestMigration struct {
}

func (*awsAwsquery_deserializeOpTestMigration) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsquery_deserializeOpTestMigration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsquery_deserializeOpErrorTestMigration(response, &metadata)
	}
	output := &TestMigrationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(response.Body, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return out, metadata, nil
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("TestMigrationResult")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeOpDocumentTestMigrationOutput(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsquery_deserializeOpErrorTestMigration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	errorComponents, err := awsxml.GetErrorResponseComponents(errorBody, false)
	if err != nil {
		return err
	}
	if reqID := errorComponents.RequestID; len(reqID) != 0 {
		awsmiddleware.SetRequestIDMetadata(metadata, reqID)
	}
	if len(errorComponents.Code) != 0 {
		errorCode = errorComponents.Code
	}
	if len(errorComponents.Message) != 0 {
		errorMessage = errorComponents.Message
	}
	errorBody.Seek(0, io.SeekStart)
	switch {
	case strings.EqualFold("InvalidParameterValue", errorCode):
		return awsAwsquery_deserializeErrorInvalidParameterValueException(response, errorBody)

	case strings.EqualFold("InvalidReplicationGroupState", errorCode):
		return awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupAlreadyUnderMigrationFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupAlreadyUnderMigrationFault(response, errorBody)

	case strings.EqualFold("ReplicationGroupNotFoundFault", errorCode):
		return awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsAwsquery_deserializeErrorAPICallRateForCustomerExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.APICallRateForCustomerExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAPICallRateForCustomerExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthorizationAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthorizationAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthorizationAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorAuthorizationNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AuthorizationNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentAuthorizationNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheClusterAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheClusterAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheClusterAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheClusterNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheClusterNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheClusterNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheParameterGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheParameterGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheParameterGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheParameterGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheParameterGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheParameterGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheParameterGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheParameterGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheParameterGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSecurityGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSecurityGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSecurityGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSecurityGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSecurityGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSecurityGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSecurityGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSecurityGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSecurityGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSubnetGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSubnetGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSubnetGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSubnetGroupInUse(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSubnetGroupInUse{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSubnetGroupInUse(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSubnetGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSubnetGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSubnetGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSubnetGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSubnetGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSubnetGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorCacheSubnetQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.CacheSubnetQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentCacheSubnetQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorClusterQuotaForCustomerExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ClusterQuotaForCustomerExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentClusterQuotaForCustomerExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorDefaultUserAssociatedToUserGroupFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.DefaultUserAssociatedToUserGroupFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentDefaultUserAssociatedToUserGroupFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorDefaultUserRequired(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.DefaultUserRequired{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentDefaultUserRequired(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorDuplicateUserNameFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.DuplicateUserNameFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentDuplicateUserNameFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorGlobalReplicationGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.GlobalReplicationGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentGlobalReplicationGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorGlobalReplicationGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.GlobalReplicationGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentGlobalReplicationGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInsufficientCacheClusterCapacityFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InsufficientCacheClusterCapacityFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInsufficientCacheClusterCapacityFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidARNFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidARNFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidARNFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidCacheClusterStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidCacheClusterStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidCacheClusterStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidCacheParameterGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidCacheParameterGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidCacheParameterGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidCacheSecurityGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidCacheSecurityGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidCacheSecurityGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidCredentialsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidCredentialsException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidCredentialsException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidGlobalReplicationGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidGlobalReplicationGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidGlobalReplicationGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidKMSKeyFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidKMSKeyFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidKMSKeyFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidParameterCombinationException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidParameterCombinationException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidParameterCombinationException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidParameterValueException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidParameterValueException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidParameterValueException(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidReplicationGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidReplicationGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidReplicationGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidServerlessCacheSnapshotStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidServerlessCacheSnapshotStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidServerlessCacheSnapshotStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidServerlessCacheStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidServerlessCacheStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidServerlessCacheStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidSnapshotStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidSnapshotStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidSnapshotStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidSubnet(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidSubnet{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidSubnet(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidUserGroupStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidUserGroupStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidUserGroupStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidUserStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidUserStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidUserStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorInvalidVPCNetworkStateFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidVPCNetworkStateFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentInvalidVPCNetworkStateFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNodeGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NodeGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNodeGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNodeGroupsPerReplicationGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NodeGroupsPerReplicationGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNodeGroupsPerReplicationGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNodeQuotaForClusterExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NodeQuotaForClusterExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNodeQuotaForClusterExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNodeQuotaForCustomerExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NodeQuotaForCustomerExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNodeQuotaForCustomerExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorNoOperationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.NoOperationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentNoOperationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReplicationGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReplicationGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReplicationGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReplicationGroupAlreadyUnderMigrationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReplicationGroupAlreadyUnderMigrationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReplicationGroupAlreadyUnderMigrationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReplicationGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReplicationGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReplicationGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReplicationGroupNotUnderMigrationFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReplicationGroupNotUnderMigrationFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReplicationGroupNotUnderMigrationFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedCacheNodeAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedCacheNodeAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedCacheNodeAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedCacheNodeNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedCacheNodeNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedCacheNodeNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedCacheNodeQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedCacheNodeQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedCacheNodeQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorReservedCacheNodesOfferingNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ReservedCacheNodesOfferingNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentReservedCacheNodesOfferingNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServerlessCacheAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServerlessCacheAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServerlessCacheAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServerlessCacheNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServerlessCacheNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServerlessCacheNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServerlessCacheQuotaForCustomerExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServerlessCacheQuotaForCustomerExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServerlessCacheQuotaForCustomerExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServerlessCacheSnapshotAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServerlessCacheSnapshotAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServerlessCacheSnapshotAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServerlessCacheSnapshotNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServerlessCacheSnapshotNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServerlessCacheSnapshotNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServerlessCacheSnapshotQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServerlessCacheSnapshotQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServerlessCacheSnapshotQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServiceLinkedRoleNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServiceLinkedRoleNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServiceLinkedRoleNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorServiceUpdateNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ServiceUpdateNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentServiceUpdateNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotFeatureNotSupportedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotFeatureNotSupportedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotFeatureNotSupportedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSnapshotQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SnapshotQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSnapshotQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubnetInUse(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubnetInUse{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubnetInUse(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorSubnetNotAllowedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.SubnetNotAllowedFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentSubnetNotAllowedFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTagNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TagNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTagNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTagQuotaPerResourceExceeded(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TagQuotaPerResourceExceeded{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTagQuotaPerResourceExceeded(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorTestFailoverNotAvailableFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.TestFailoverNotAvailableFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentTestFailoverNotAvailableFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserGroupAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserGroupAlreadyExistsFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserGroupAlreadyExistsFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserGroupNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserGroupNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserGroupNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserGroupQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserGroupQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserGroupQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserNotFoundFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserNotFoundFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserNotFoundFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeErrorUserQuotaExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.UserQuotaExceededFault{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])
	body := io.TeeReader(errorBody, ringBuffer)
	rootDecoder := xml.NewDecoder(body)
	t, err := smithyxml.FetchRootElement(rootDecoder)
	if err == io.EOF {
		return output
	}
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder := smithyxml.WrapNodeDecoder(rootDecoder, t)
	t, err = decoder.GetElement("Error")
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	decoder = smithyxml.WrapNodeDecoder(decoder.Decoder, t)
	err = awsAwsquery_deserializeDocumentUserQuotaExceededFault(&output, decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return output
}

func awsAwsquery_deserializeDocumentAPICallRateForCustomerExceededFault(v **types.APICallRateForCustomerExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.APICallRateForCustomerExceededFault
	if *v == nil {
		sv = &types.APICallRateForCustomerExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthentication(v **types.Authentication, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Authentication
	if *v == nil {
		sv = &types.Authentication{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("PasswordCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.PasswordCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Type", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Type = types.AuthenticationType(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizationAlreadyExistsFault(v **types.AuthorizationAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizationAlreadyExistsFault
	if *v == nil {
		sv = &types.AuthorizationAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAuthorizationNotFoundFault(v **types.AuthorizationNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AuthorizationNotFoundFault
	if *v == nil {
		sv = &types.AuthorizationNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAvailabilityZone(v **types.AvailabilityZone, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.AvailabilityZone
	if *v == nil {
		sv = &types.AvailabilityZone{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Name", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Name = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAvailabilityZonesList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("AvailabilityZone", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentAvailabilityZonesListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheCluster(v **types.CacheCluster, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheCluster
	if *v == nil {
		sv = &types.CacheCluster{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("AtRestEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AtRestEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("AuthTokenEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AuthTokenEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("AuthTokenLastModifiedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.AuthTokenLastModifiedDate = ptr.Time(t)
			}

		case strings.EqualFold("AutoMinorVersionUpgrade", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AutoMinorVersionUpgrade = ptr.Bool(xtv)
			}

		case strings.EqualFold("CacheClusterCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CacheClusterCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheClusterStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterStatus = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeList(&sv.CacheNodes, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("CacheParameterGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheParameterGroupStatus(&sv.CacheParameterGroup, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CacheSecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroupMembershipList(&sv.CacheSecurityGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CacheSubnetGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSubnetGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("ClientDownloadLandingPage", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClientDownloadLandingPage = ptr.String(xtv)
			}

		case strings.EqualFold("ConfigurationEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.ConfigurationEndpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("EngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("IpDiscovery", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IpDiscovery = types.IpDiscovery(xtv)
			}

		case strings.EqualFold("LogDeliveryConfigurations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentLogDeliveryConfigurationList(&sv.LogDeliveryConfigurations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NetworkType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NetworkType = types.NetworkType(xtv)
			}

		case strings.EqualFold("NotificationConfiguration", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNotificationConfiguration(&sv.NotificationConfiguration, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NumCacheNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumCacheNodes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("PendingModifiedValues", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPendingModifiedValues(&sv.PendingModifiedValues, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PreferredAvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredAvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("PreferredMaintenanceWindow", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredMaintenanceWindow = ptr.String(xtv)
			}

		case strings.EqualFold("PreferredOutpostArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredOutpostArn = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupLogDeliveryEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.ReplicationGroupLogDeliveryEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("SecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSecurityGroupMembershipList(&sv.SecurityGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SnapshotRetentionLimit", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SnapshotRetentionLimit = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("SnapshotWindow", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotWindow = ptr.String(xtv)
			}

		case strings.EqualFold("TransitEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.TransitEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("TransitEncryptionMode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TransitEncryptionMode = types.TransitEncryptionMode(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheClusterAlreadyExistsFault(v **types.CacheClusterAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheClusterAlreadyExistsFault
	if *v == nil {
		sv = &types.CacheClusterAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheClusterList(v *[]types.CacheCluster, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheCluster
	if *v == nil {
		sv = make([]types.CacheCluster, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheCluster", t.Name.Local):
			var col types.CacheCluster
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheCluster(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheClusterListUnwrapped(v *[]types.CacheCluster, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheCluster
	if *v == nil {
		sv = make([]types.CacheCluster, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheCluster
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheCluster(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheClusterNotFoundFault(v **types.CacheClusterNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheClusterNotFoundFault
	if *v == nil {
		sv = &types.CacheClusterNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheEngineVersion(v **types.CacheEngineVersion, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheEngineVersion
	if *v == nil {
		sv = &types.CacheEngineVersion{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheEngineDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheEngineDescription = ptr.String(xtv)
			}

		case strings.EqualFold("CacheEngineVersionDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheEngineVersionDescription = ptr.String(xtv)
			}

		case strings.EqualFold("CacheParameterGroupFamily", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupFamily = ptr.String(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("EngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EngineVersion = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheEngineVersionList(v *[]types.CacheEngineVersion, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheEngineVersion
	if *v == nil {
		sv = make([]types.CacheEngineVersion, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheEngineVersion", t.Name.Local):
			var col types.CacheEngineVersion
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheEngineVersion(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheEngineVersionListUnwrapped(v *[]types.CacheEngineVersion, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheEngineVersion
	if *v == nil {
		sv = make([]types.CacheEngineVersion, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheEngineVersion
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheEngineVersion(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheNode(v **types.CacheNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheNode
	if *v == nil {
		sv = &types.CacheNode{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CacheNodeCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("CacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeStatus = ptr.String(xtv)
			}

		case strings.EqualFold("CustomerAvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomerAvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("CustomerOutpostArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CustomerOutpostArn = ptr.String(xtv)
			}

		case strings.EqualFold("Endpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.Endpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ParameterGroupStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterGroupStatus = ptr.String(xtv)
			}

		case strings.EqualFold("SourceCacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceCacheNodeId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeIdsList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("CacheNodeId", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeIdsListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheNodeList(v *[]types.CacheNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheNode
	if *v == nil {
		sv = make([]types.CacheNode, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheNode", t.Name.Local):
			var col types.CacheNode
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheNode(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeListUnwrapped(v *[]types.CacheNode, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheNode
	if *v == nil {
		sv = make([]types.CacheNode, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheNode
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheNode(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParameter(v **types.CacheNodeTypeSpecificParameter, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheNodeTypeSpecificParameter
	if *v == nil {
		sv = &types.CacheNodeTypeSpecificParameter{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowedValues", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AllowedValues = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeTypeSpecificValues", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificValueList(&sv.CacheNodeTypeSpecificValues, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ChangeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ChangeType = types.ChangeType(xtv)
			}

		case strings.EqualFold("DataType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataType = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("IsModifiable", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.IsModifiable = ptr.Bool(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterName = ptr.String(xtv)
			}

		case strings.EqualFold("Source", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Source = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParametersList(v *[]types.CacheNodeTypeSpecificParameter, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheNodeTypeSpecificParameter
	if *v == nil {
		sv = make([]types.CacheNodeTypeSpecificParameter, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheNodeTypeSpecificParameter", t.Name.Local):
			var col types.CacheNodeTypeSpecificParameter
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParameter(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParametersListUnwrapped(v *[]types.CacheNodeTypeSpecificParameter, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheNodeTypeSpecificParameter
	if *v == nil {
		sv = make([]types.CacheNodeTypeSpecificParameter, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheNodeTypeSpecificParameter
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParameter(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheNodeTypeSpecificValue(v **types.CacheNodeTypeSpecificValue, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheNodeTypeSpecificValue
	if *v == nil {
		sv = &types.CacheNodeTypeSpecificValue{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("Value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Value = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeTypeSpecificValueList(v *[]types.CacheNodeTypeSpecificValue, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheNodeTypeSpecificValue
	if *v == nil {
		sv = make([]types.CacheNodeTypeSpecificValue, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheNodeTypeSpecificValue", t.Name.Local):
			var col types.CacheNodeTypeSpecificValue
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificValue(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeTypeSpecificValueListUnwrapped(v *[]types.CacheNodeTypeSpecificValue, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheNodeTypeSpecificValue
	if *v == nil {
		sv = make([]types.CacheNodeTypeSpecificValue, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheNodeTypeSpecificValue
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificValue(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheNodeUpdateStatus(v **types.CacheNodeUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheNodeUpdateStatus
	if *v == nil {
		sv = &types.CacheNodeUpdateStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("NodeDeletionDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeDeletionDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateEndDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateEndDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateInitiatedBy", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeUpdateInitiatedBy = types.NodeUpdateInitiatedBy(xtv)
			}

		case strings.EqualFold("NodeUpdateInitiatedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateInitiatedDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateStartDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateStartDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeUpdateStatus = types.NodeUpdateStatus(xtv)
			}

		case strings.EqualFold("NodeUpdateStatusModifiedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateStatusModifiedDate = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeUpdateStatusList(v *[]types.CacheNodeUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheNodeUpdateStatus
	if *v == nil {
		sv = make([]types.CacheNodeUpdateStatus, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheNodeUpdateStatus", t.Name.Local):
			var col types.CacheNodeUpdateStatus
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheNodeUpdateStatus(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheNodeUpdateStatusListUnwrapped(v *[]types.CacheNodeUpdateStatus, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheNodeUpdateStatus
	if *v == nil {
		sv = make([]types.CacheNodeUpdateStatus, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheNodeUpdateStatus
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheNodeUpdateStatus(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheParameterGroup(v **types.CacheParameterGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheParameterGroup
	if *v == nil {
		sv = &types.CacheParameterGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("CacheParameterGroupFamily", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupFamily = ptr.String(xtv)
			}

		case strings.EqualFold("CacheParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("IsGlobal", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.IsGlobal = ptr.Bool(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheParameterGroupAlreadyExistsFault(v **types.CacheParameterGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheParameterGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.CacheParameterGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheParameterGroupList(v *[]types.CacheParameterGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheParameterGroup
	if *v == nil {
		sv = make([]types.CacheParameterGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheParameterGroup", t.Name.Local):
			var col types.CacheParameterGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheParameterGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheParameterGroupListUnwrapped(v *[]types.CacheParameterGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheParameterGroup
	if *v == nil {
		sv = make([]types.CacheParameterGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheParameterGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheParameterGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheParameterGroupNotFoundFault(v **types.CacheParameterGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheParameterGroupNotFoundFault
	if *v == nil {
		sv = &types.CacheParameterGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheParameterGroupQuotaExceededFault(v **types.CacheParameterGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheParameterGroupQuotaExceededFault
	if *v == nil {
		sv = &types.CacheParameterGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheParameterGroupStatus(v **types.CacheParameterGroupStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheParameterGroupStatus
	if *v == nil {
		sv = &types.CacheParameterGroupStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeIdsToReboot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeIdsList(&sv.CacheNodeIdsToReboot, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CacheParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterApplyStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterApplyStatus = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroup(v **types.CacheSecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSecurityGroup
	if *v == nil {
		sv = &types.CacheSecurityGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("CacheSecurityGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSecurityGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("EC2SecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEC2SecurityGroupList(&sv.EC2SecurityGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("OwnerId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.OwnerId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroupAlreadyExistsFault(v **types.CacheSecurityGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSecurityGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.CacheSecurityGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroupMembership(v **types.CacheSecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSecurityGroupMembership
	if *v == nil {
		sv = &types.CacheSecurityGroupMembership{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSecurityGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSecurityGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroupMembershipList(v *[]types.CacheSecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheSecurityGroupMembership
	if *v == nil {
		sv = make([]types.CacheSecurityGroupMembership, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheSecurityGroup", t.Name.Local):
			var col types.CacheSecurityGroupMembership
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroupMembership(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroupMembershipListUnwrapped(v *[]types.CacheSecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheSecurityGroupMembership
	if *v == nil {
		sv = make([]types.CacheSecurityGroupMembership, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheSecurityGroupMembership
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheSecurityGroupMembership(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheSecurityGroupNotFoundFault(v **types.CacheSecurityGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSecurityGroupNotFoundFault
	if *v == nil {
		sv = &types.CacheSecurityGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroupQuotaExceededFault(v **types.CacheSecurityGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSecurityGroupQuotaExceededFault
	if *v == nil {
		sv = &types.CacheSecurityGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroups(v *[]types.CacheSecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheSecurityGroup
	if *v == nil {
		sv = make([]types.CacheSecurityGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheSecurityGroup", t.Name.Local):
			var col types.CacheSecurityGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSecurityGroupsUnwrapped(v *[]types.CacheSecurityGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheSecurityGroup
	if *v == nil {
		sv = make([]types.CacheSecurityGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheSecurityGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheSecurityGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheSubnetGroup(v **types.CacheSubnetGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSubnetGroup
	if *v == nil {
		sv = &types.CacheSubnetGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("CacheSubnetGroupDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSubnetGroupDescription = ptr.String(xtv)
			}

		case strings.EqualFold("CacheSubnetGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSubnetGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("Subnets", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubnetList(&sv.Subnets, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SupportedNetworkTypes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNetworkTypeList(&sv.SupportedNetworkTypes, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("VpcId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.VpcId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSubnetGroupAlreadyExistsFault(v **types.CacheSubnetGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSubnetGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.CacheSubnetGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSubnetGroupInUse(v **types.CacheSubnetGroupInUse, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSubnetGroupInUse
	if *v == nil {
		sv = &types.CacheSubnetGroupInUse{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSubnetGroupNotFoundFault(v **types.CacheSubnetGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSubnetGroupNotFoundFault
	if *v == nil {
		sv = &types.CacheSubnetGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSubnetGroupQuotaExceededFault(v **types.CacheSubnetGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSubnetGroupQuotaExceededFault
	if *v == nil {
		sv = &types.CacheSubnetGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSubnetGroups(v *[]types.CacheSubnetGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.CacheSubnetGroup
	if *v == nil {
		sv = make([]types.CacheSubnetGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("CacheSubnetGroup", t.Name.Local):
			var col types.CacheSubnetGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentCacheSubnetGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheSubnetGroupsUnwrapped(v *[]types.CacheSubnetGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.CacheSubnetGroup
	if *v == nil {
		sv = make([]types.CacheSubnetGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.CacheSubnetGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentCacheSubnetGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentCacheSubnetQuotaExceededFault(v **types.CacheSubnetQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheSubnetQuotaExceededFault
	if *v == nil {
		sv = &types.CacheSubnetQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCacheUsageLimits(v **types.CacheUsageLimits, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CacheUsageLimits
	if *v == nil {
		sv = &types.CacheUsageLimits{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DataStorage", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentDataStorage(&sv.DataStorage, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ECPUPerSecond", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentECPUPerSecond(&sv.ECPUPerSecond, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentCloudWatchLogsDestinationDetails(v **types.CloudWatchLogsDestinationDetails, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.CloudWatchLogsDestinationDetails
	if *v == nil {
		sv = &types.CloudWatchLogsDestinationDetails{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("LogGroup", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.LogGroup = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterIdList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("ClusterId", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentClusterIdListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentClusterQuotaForCustomerExceededFault(v **types.ClusterQuotaForCustomerExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ClusterQuotaForCustomerExceededFault
	if *v == nil {
		sv = &types.ClusterQuotaForCustomerExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDataStorage(v **types.DataStorage, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DataStorage
	if *v == nil {
		sv = &types.DataStorage{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Maximum", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Maximum = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Minimum", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Minimum = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Unit", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Unit = types.DataStorageUnit(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDefaultUserAssociatedToUserGroupFault(v **types.DefaultUserAssociatedToUserGroupFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DefaultUserAssociatedToUserGroupFault
	if *v == nil {
		sv = &types.DefaultUserAssociatedToUserGroupFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDefaultUserRequired(v **types.DefaultUserRequired, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DefaultUserRequired
	if *v == nil {
		sv = &types.DefaultUserRequired{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDestinationDetails(v **types.DestinationDetails, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DestinationDetails
	if *v == nil {
		sv = &types.DestinationDetails{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CloudWatchLogsDetails", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCloudWatchLogsDestinationDetails(&sv.CloudWatchLogsDetails, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("KinesisFirehoseDetails", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentKinesisFirehoseDestinationDetails(&sv.KinesisFirehoseDetails, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentDuplicateUserNameFault(v **types.DuplicateUserNameFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.DuplicateUserNameFault
	if *v == nil {
		sv = &types.DuplicateUserNameFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEC2SecurityGroup(v **types.EC2SecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EC2SecurityGroup
	if *v == nil {
		sv = &types.EC2SecurityGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EC2SecurityGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EC2SecurityGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("EC2SecurityGroupOwnerId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EC2SecurityGroupOwnerId = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEC2SecurityGroupList(v *[]types.EC2SecurityGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.EC2SecurityGroup
	if *v == nil {
		sv = make([]types.EC2SecurityGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("EC2SecurityGroup", t.Name.Local):
			var col types.EC2SecurityGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEC2SecurityGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEC2SecurityGroupListUnwrapped(v *[]types.EC2SecurityGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.EC2SecurityGroup
	if *v == nil {
		sv = make([]types.EC2SecurityGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.EC2SecurityGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEC2SecurityGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentECPUPerSecond(v **types.ECPUPerSecond, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ECPUPerSecond
	if *v == nil {
		sv = &types.ECPUPerSecond{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Maximum", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Maximum = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Minimum", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Minimum = ptr.Int32(int32(i64))
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEndpoint(v **types.Endpoint, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Endpoint
	if *v == nil {
		sv = &types.Endpoint{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Address", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Address = ptr.String(xtv)
			}

		case strings.EqualFold("Port", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEngineDefaults(v **types.EngineDefaults, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.EngineDefaults
	if *v == nil {
		sv = &types.EngineDefaults{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeTypeSpecificParameters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParametersList(&sv.CacheNodeTypeSpecificParameters, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CacheParameterGroupFamily", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupFamily = ptr.String(xtv)
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("Parameters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentParametersList(&sv.Parameters, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEvent(v **types.Event, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Event
	if *v == nil {
		sv = &types.Event{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Date", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.Date = ptr.Time(t)
			}

		case strings.EqualFold("Message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		case strings.EqualFold("SourceIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("SourceType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SourceType = types.SourceType(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventList(v *[]types.Event, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Event
	if *v == nil {
		sv = make([]types.Event, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Event", t.Name.Local):
			var col types.Event
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentEvent(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentEventListUnwrapped(v *[]types.Event, decoder smithyxml.NodeDecoder) error {
	var sv []types.Event
	if *v == nil {
		sv = make([]types.Event, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Event
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentEvent(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentGlobalNodeGroup(v **types.GlobalNodeGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.GlobalNodeGroup
	if *v == nil {
		sv = &types.GlobalNodeGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalNodeGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.GlobalNodeGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("Slots", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Slots = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalNodeGroupList(v *[]types.GlobalNodeGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.GlobalNodeGroup
	if *v == nil {
		sv = make([]types.GlobalNodeGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("GlobalNodeGroup", t.Name.Local):
			var col types.GlobalNodeGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentGlobalNodeGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalNodeGroupListUnwrapped(v *[]types.GlobalNodeGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.GlobalNodeGroup
	if *v == nil {
		sv = make([]types.GlobalNodeGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.GlobalNodeGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentGlobalNodeGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentGlobalReplicationGroup(v **types.GlobalReplicationGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.GlobalReplicationGroup
	if *v == nil {
		sv = &types.GlobalReplicationGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("AtRestEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AtRestEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("AuthTokenEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AuthTokenEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.ClusterEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("EngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("GlobalNodeGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalNodeGroupList(&sv.GlobalNodeGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("GlobalReplicationGroupDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.GlobalReplicationGroupDescription = ptr.String(xtv)
			}

		case strings.EqualFold("GlobalReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.GlobalReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("Members", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroupMemberList(&sv.Members, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("TransitEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.TransitEncryptionEnabled = ptr.Bool(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalReplicationGroupAlreadyExistsFault(v **types.GlobalReplicationGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.GlobalReplicationGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.GlobalReplicationGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalReplicationGroupInfo(v **types.GlobalReplicationGroupInfo, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.GlobalReplicationGroupInfo
	if *v == nil {
		sv = &types.GlobalReplicationGroupInfo{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.GlobalReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("GlobalReplicationGroupMemberRole", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.GlobalReplicationGroupMemberRole = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalReplicationGroupList(v *[]types.GlobalReplicationGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.GlobalReplicationGroup
	if *v == nil {
		sv = make([]types.GlobalReplicationGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			var col types.GlobalReplicationGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalReplicationGroupListUnwrapped(v *[]types.GlobalReplicationGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.GlobalReplicationGroup
	if *v == nil {
		sv = make([]types.GlobalReplicationGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.GlobalReplicationGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentGlobalReplicationGroupMember(v **types.GlobalReplicationGroupMember, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.GlobalReplicationGroupMember
	if *v == nil {
		sv = &types.GlobalReplicationGroupMember{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AutomaticFailover", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AutomaticFailover = types.AutomaticFailoverStatus(xtv)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupRegion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupRegion = ptr.String(xtv)
			}

		case strings.EqualFold("Role", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Role = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalReplicationGroupMemberList(v *[]types.GlobalReplicationGroupMember, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.GlobalReplicationGroupMember
	if *v == nil {
		sv = make([]types.GlobalReplicationGroupMember, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("GlobalReplicationGroupMember", t.Name.Local):
			var col types.GlobalReplicationGroupMember
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroupMember(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentGlobalReplicationGroupMemberListUnwrapped(v *[]types.GlobalReplicationGroupMember, decoder smithyxml.NodeDecoder) error {
	var sv []types.GlobalReplicationGroupMember
	if *v == nil {
		sv = make([]types.GlobalReplicationGroupMember, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.GlobalReplicationGroupMember
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentGlobalReplicationGroupMember(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentGlobalReplicationGroupNotFoundFault(v **types.GlobalReplicationGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.GlobalReplicationGroupNotFoundFault
	if *v == nil {
		sv = &types.GlobalReplicationGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInsufficientCacheClusterCapacityFault(v **types.InsufficientCacheClusterCapacityFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InsufficientCacheClusterCapacityFault
	if *v == nil {
		sv = &types.InsufficientCacheClusterCapacityFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidARNFault(v **types.InvalidARNFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidARNFault
	if *v == nil {
		sv = &types.InvalidARNFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidCacheClusterStateFault(v **types.InvalidCacheClusterStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidCacheClusterStateFault
	if *v == nil {
		sv = &types.InvalidCacheClusterStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidCacheParameterGroupStateFault(v **types.InvalidCacheParameterGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidCacheParameterGroupStateFault
	if *v == nil {
		sv = &types.InvalidCacheParameterGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidCacheSecurityGroupStateFault(v **types.InvalidCacheSecurityGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidCacheSecurityGroupStateFault
	if *v == nil {
		sv = &types.InvalidCacheSecurityGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidCredentialsException(v **types.InvalidCredentialsException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidCredentialsException
	if *v == nil {
		sv = &types.InvalidCredentialsException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidGlobalReplicationGroupStateFault(v **types.InvalidGlobalReplicationGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidGlobalReplicationGroupStateFault
	if *v == nil {
		sv = &types.InvalidGlobalReplicationGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidKMSKeyFault(v **types.InvalidKMSKeyFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidKMSKeyFault
	if *v == nil {
		sv = &types.InvalidKMSKeyFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidParameterCombinationException(v **types.InvalidParameterCombinationException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidParameterCombinationException
	if *v == nil {
		sv = &types.InvalidParameterCombinationException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidParameterValueException(v **types.InvalidParameterValueException, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidParameterValueException
	if *v == nil {
		sv = &types.InvalidParameterValueException{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidReplicationGroupStateFault(v **types.InvalidReplicationGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidReplicationGroupStateFault
	if *v == nil {
		sv = &types.InvalidReplicationGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidServerlessCacheSnapshotStateFault(v **types.InvalidServerlessCacheSnapshotStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidServerlessCacheSnapshotStateFault
	if *v == nil {
		sv = &types.InvalidServerlessCacheSnapshotStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidServerlessCacheStateFault(v **types.InvalidServerlessCacheStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidServerlessCacheStateFault
	if *v == nil {
		sv = &types.InvalidServerlessCacheStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidSnapshotStateFault(v **types.InvalidSnapshotStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidSnapshotStateFault
	if *v == nil {
		sv = &types.InvalidSnapshotStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidSubnet(v **types.InvalidSubnet, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidSubnet
	if *v == nil {
		sv = &types.InvalidSubnet{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidUserGroupStateFault(v **types.InvalidUserGroupStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidUserGroupStateFault
	if *v == nil {
		sv = &types.InvalidUserGroupStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidUserStateFault(v **types.InvalidUserStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidUserStateFault
	if *v == nil {
		sv = &types.InvalidUserStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentInvalidVPCNetworkStateFault(v **types.InvalidVPCNetworkStateFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.InvalidVPCNetworkStateFault
	if *v == nil {
		sv = &types.InvalidVPCNetworkStateFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentKinesisFirehoseDestinationDetails(v **types.KinesisFirehoseDestinationDetails, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.KinesisFirehoseDestinationDetails
	if *v == nil {
		sv = &types.KinesisFirehoseDestinationDetails{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DeliveryStream", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DeliveryStream = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLogDeliveryConfiguration(v **types.LogDeliveryConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.LogDeliveryConfiguration
	if *v == nil {
		sv = &types.LogDeliveryConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DestinationDetails", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentDestinationDetails(&sv.DestinationDetails, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("DestinationType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DestinationType = types.DestinationType(xtv)
			}

		case strings.EqualFold("LogFormat", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.LogFormat = types.LogFormat(xtv)
			}

		case strings.EqualFold("LogType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.LogType = types.LogType(xtv)
			}

		case strings.EqualFold("Message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = types.LogDeliveryConfigurationStatus(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLogDeliveryConfigurationList(v *[]types.LogDeliveryConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.LogDeliveryConfiguration
	if *v == nil {
		sv = make([]types.LogDeliveryConfiguration, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("LogDeliveryConfiguration", t.Name.Local):
			var col types.LogDeliveryConfiguration
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentLogDeliveryConfiguration(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentLogDeliveryConfigurationListUnwrapped(v *[]types.LogDeliveryConfiguration, decoder smithyxml.NodeDecoder) error {
	var sv []types.LogDeliveryConfiguration
	if *v == nil {
		sv = make([]types.LogDeliveryConfiguration, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.LogDeliveryConfiguration
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentLogDeliveryConfiguration(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNetworkTypeList(v *[]types.NetworkType, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NetworkType
	if *v == nil {
		sv = make([]types.NetworkType, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.NetworkType
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = types.NetworkType(xtv)
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNetworkTypeListUnwrapped(v *[]types.NetworkType, decoder smithyxml.NodeDecoder) error {
	var sv []types.NetworkType
	if *v == nil {
		sv = make([]types.NetworkType, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NetworkType
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = types.NetworkType(xtv)
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeGroup(v **types.NodeGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroup
	if *v == nil {
		sv = &types.NodeGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NodeGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("NodeGroupMembers", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeGroupMemberList(&sv.NodeGroupMembers, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PrimaryEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.PrimaryEndpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReaderEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.ReaderEndpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Slots", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Slots = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupConfiguration(v **types.NodeGroupConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroupConfiguration
	if *v == nil {
		sv = &types.NodeGroupConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NodeGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("PrimaryAvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PrimaryAvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("PrimaryOutpostArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PrimaryOutpostArn = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicaAvailabilityZones", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAvailabilityZonesList(&sv.ReplicaAvailabilityZones, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReplicaCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ReplicaCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("ReplicaOutpostArns", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentOutpostArnsList(&sv.ReplicaOutpostArns, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Slots", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Slots = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupList(v *[]types.NodeGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NodeGroup
	if *v == nil {
		sv = make([]types.NodeGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NodeGroup", t.Name.Local):
			var col types.NodeGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNodeGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupListUnwrapped(v *[]types.NodeGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.NodeGroup
	if *v == nil {
		sv = make([]types.NodeGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NodeGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNodeGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeGroupMember(v **types.NodeGroupMember, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroupMember
	if *v == nil {
		sv = &types.NodeGroupMember{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("CurrentRole", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CurrentRole = ptr.String(xtv)
			}

		case strings.EqualFold("PreferredAvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredAvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("PreferredOutpostArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredOutpostArn = ptr.String(xtv)
			}

		case strings.EqualFold("ReadEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.ReadEndpoint, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupMemberList(v *[]types.NodeGroupMember, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NodeGroupMember
	if *v == nil {
		sv = make([]types.NodeGroupMember, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NodeGroupMember", t.Name.Local):
			var col types.NodeGroupMember
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNodeGroupMember(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupMemberListUnwrapped(v *[]types.NodeGroupMember, decoder smithyxml.NodeDecoder) error {
	var sv []types.NodeGroupMember
	if *v == nil {
		sv = make([]types.NodeGroupMember, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NodeGroupMember
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNodeGroupMember(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeGroupMemberUpdateStatus(v **types.NodeGroupMemberUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroupMemberUpdateStatus
	if *v == nil {
		sv = &types.NodeGroupMemberUpdateStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("NodeDeletionDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeDeletionDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateEndDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateEndDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateInitiatedBy", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeUpdateInitiatedBy = types.NodeUpdateInitiatedBy(xtv)
			}

		case strings.EqualFold("NodeUpdateInitiatedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateInitiatedDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateStartDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateStartDate = ptr.Time(t)
			}

		case strings.EqualFold("NodeUpdateStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeUpdateStatus = types.NodeUpdateStatus(xtv)
			}

		case strings.EqualFold("NodeUpdateStatusModifiedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.NodeUpdateStatusModifiedDate = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupMemberUpdateStatusList(v *[]types.NodeGroupMemberUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NodeGroupMemberUpdateStatus
	if *v == nil {
		sv = make([]types.NodeGroupMemberUpdateStatus, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NodeGroupMemberUpdateStatus", t.Name.Local):
			var col types.NodeGroupMemberUpdateStatus
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNodeGroupMemberUpdateStatus(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupMemberUpdateStatusListUnwrapped(v *[]types.NodeGroupMemberUpdateStatus, decoder smithyxml.NodeDecoder) error {
	var sv []types.NodeGroupMemberUpdateStatus
	if *v == nil {
		sv = make([]types.NodeGroupMemberUpdateStatus, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NodeGroupMemberUpdateStatus
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNodeGroupMemberUpdateStatus(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeGroupNotFoundFault(v **types.NodeGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroupNotFoundFault
	if *v == nil {
		sv = &types.NodeGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupsPerReplicationGroupQuotaExceededFault(v **types.NodeGroupsPerReplicationGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroupsPerReplicationGroupQuotaExceededFault
	if *v == nil {
		sv = &types.NodeGroupsPerReplicationGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupUpdateStatus(v **types.NodeGroupUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeGroupUpdateStatus
	if *v == nil {
		sv = &types.NodeGroupUpdateStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NodeGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("NodeGroupMemberUpdateStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeGroupMemberUpdateStatusList(&sv.NodeGroupMemberUpdateStatus, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupUpdateStatusList(v *[]types.NodeGroupUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NodeGroupUpdateStatus
	if *v == nil {
		sv = make([]types.NodeGroupUpdateStatus, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NodeGroupUpdateStatus", t.Name.Local):
			var col types.NodeGroupUpdateStatus
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNodeGroupUpdateStatus(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeGroupUpdateStatusListUnwrapped(v *[]types.NodeGroupUpdateStatus, decoder smithyxml.NodeDecoder) error {
	var sv []types.NodeGroupUpdateStatus
	if *v == nil {
		sv = make([]types.NodeGroupUpdateStatus, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NodeGroupUpdateStatus
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNodeGroupUpdateStatus(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeQuotaForClusterExceededFault(v **types.NodeQuotaForClusterExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeQuotaForClusterExceededFault
	if *v == nil {
		sv = &types.NodeQuotaForClusterExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeQuotaForCustomerExceededFault(v **types.NodeQuotaForCustomerExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeQuotaForCustomerExceededFault
	if *v == nil {
		sv = &types.NodeQuotaForCustomerExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeSnapshot(v **types.NodeSnapshot, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NodeSnapshot
	if *v == nil {
		sv = &types.NodeSnapshot{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CacheNodeCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("CacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheSize", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSize = ptr.String(xtv)
			}

		case strings.EqualFold("NodeGroupConfiguration", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeGroupConfiguration(&sv.NodeGroupConfiguration, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NodeGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodeGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.SnapshotCreateTime = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeSnapshotList(v *[]types.NodeSnapshot, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.NodeSnapshot
	if *v == nil {
		sv = make([]types.NodeSnapshot, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("NodeSnapshot", t.Name.Local):
			var col types.NodeSnapshot
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentNodeSnapshot(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeSnapshotListUnwrapped(v *[]types.NodeSnapshot, decoder smithyxml.NodeDecoder) error {
	var sv []types.NodeSnapshot
	if *v == nil {
		sv = make([]types.NodeSnapshot, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.NodeSnapshot
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentNodeSnapshot(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNodeTypeList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNodeTypeListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentNoOperationFault(v **types.NoOperationFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NoOperationFault
	if *v == nil {
		sv = &types.NoOperationFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentNotificationConfiguration(v **types.NotificationConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.NotificationConfiguration
	if *v == nil {
		sv = &types.NotificationConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("TopicArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TopicArn = ptr.String(xtv)
			}

		case strings.EqualFold("TopicStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TopicStatus = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentOutpostArnsList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("OutpostArn", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentOutpostArnsListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentParameter(v **types.Parameter, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Parameter
	if *v == nil {
		sv = &types.Parameter{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AllowedValues", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AllowedValues = ptr.String(xtv)
			}

		case strings.EqualFold("ChangeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ChangeType = types.ChangeType(xtv)
			}

		case strings.EqualFold("DataType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataType = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("IsModifiable", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.IsModifiable = ptr.Bool(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterName = ptr.String(xtv)
			}

		case strings.EqualFold("ParameterValue", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ParameterValue = ptr.String(xtv)
			}

		case strings.EqualFold("Source", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Source = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentParametersList(v *[]types.Parameter, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Parameter
	if *v == nil {
		sv = make([]types.Parameter, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Parameter", t.Name.Local):
			var col types.Parameter
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentParameter(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentParametersListUnwrapped(v *[]types.Parameter, decoder smithyxml.NodeDecoder) error {
	var sv []types.Parameter
	if *v == nil {
		sv = make([]types.Parameter, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Parameter
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentParameter(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPendingLogDeliveryConfiguration(v **types.PendingLogDeliveryConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PendingLogDeliveryConfiguration
	if *v == nil {
		sv = &types.PendingLogDeliveryConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("DestinationDetails", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentDestinationDetails(&sv.DestinationDetails, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("DestinationType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DestinationType = types.DestinationType(xtv)
			}

		case strings.EqualFold("LogFormat", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.LogFormat = types.LogFormat(xtv)
			}

		case strings.EqualFold("LogType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.LogType = types.LogType(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPendingLogDeliveryConfigurationList(v *[]types.PendingLogDeliveryConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.PendingLogDeliveryConfiguration
	if *v == nil {
		sv = make([]types.PendingLogDeliveryConfiguration, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.PendingLogDeliveryConfiguration
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentPendingLogDeliveryConfiguration(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentPendingLogDeliveryConfigurationListUnwrapped(v *[]types.PendingLogDeliveryConfiguration, decoder smithyxml.NodeDecoder) error {
	var sv []types.PendingLogDeliveryConfiguration
	if *v == nil {
		sv = make([]types.PendingLogDeliveryConfiguration, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.PendingLogDeliveryConfiguration
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentPendingLogDeliveryConfiguration(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentPendingModifiedValues(v **types.PendingModifiedValues, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.PendingModifiedValues
	if *v == nil {
		sv = &types.PendingModifiedValues{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AuthTokenStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AuthTokenStatus = types.AuthTokenUpdateStatus(xtv)
			}

		case strings.EqualFold("CacheNodeIdsToRemove", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeIdsList(&sv.CacheNodeIdsToRemove, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("EngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("LogDeliveryConfigurations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPendingLogDeliveryConfigurationList(&sv.LogDeliveryConfigurations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NumCacheNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumCacheNodes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("ScaleConfig", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentScaleConfig(&sv.ScaleConfig, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("TransitEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.TransitEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("TransitEncryptionMode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TransitEncryptionMode = types.TransitEncryptionMode(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentProcessedUpdateAction(v **types.ProcessedUpdateAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ProcessedUpdateAction
	if *v == nil {
		sv = &types.ProcessedUpdateAction{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateName = ptr.String(xtv)
			}

		case strings.EqualFold("UpdateActionStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UpdateActionStatus = types.UpdateActionStatus(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentProcessedUpdateActionList(v *[]types.ProcessedUpdateAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ProcessedUpdateAction
	if *v == nil {
		sv = make([]types.ProcessedUpdateAction, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ProcessedUpdateAction", t.Name.Local):
			var col types.ProcessedUpdateAction
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentProcessedUpdateAction(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentProcessedUpdateActionListUnwrapped(v *[]types.ProcessedUpdateAction, decoder smithyxml.NodeDecoder) error {
	var sv []types.ProcessedUpdateAction
	if *v == nil {
		sv = make([]types.ProcessedUpdateAction, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ProcessedUpdateAction
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentProcessedUpdateAction(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentRecurringCharge(v **types.RecurringCharge, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.RecurringCharge
	if *v == nil {
		sv = &types.RecurringCharge{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("RecurringChargeAmount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.RecurringChargeAmount = ptr.Float64(f64)
			}

		case strings.EqualFold("RecurringChargeFrequency", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.RecurringChargeFrequency = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRecurringChargeList(v *[]types.RecurringCharge, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.RecurringCharge
	if *v == nil {
		sv = make([]types.RecurringCharge, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("RecurringCharge", t.Name.Local):
			var col types.RecurringCharge
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentRecurringCharge(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentRecurringChargeListUnwrapped(v *[]types.RecurringCharge, decoder smithyxml.NodeDecoder) error {
	var sv []types.RecurringCharge
	if *v == nil {
		sv = make([]types.RecurringCharge, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.RecurringCharge
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentRecurringCharge(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReplicationGroup(v **types.ReplicationGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplicationGroup
	if *v == nil {
		sv = &types.ReplicationGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("AtRestEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AtRestEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("AuthTokenEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AuthTokenEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("AuthTokenLastModifiedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.AuthTokenLastModifiedDate = ptr.Time(t)
			}

		case strings.EqualFold("AutomaticFailover", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AutomaticFailover = types.AutomaticFailoverStatus(xtv)
			}

		case strings.EqualFold("AutoMinorVersionUpgrade", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AutoMinorVersionUpgrade = ptr.Bool(xtv)
			}

		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("ClusterEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.ClusterEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("ClusterMode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterMode = types.ClusterMode(xtv)
			}

		case strings.EqualFold("ConfigurationEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.ConfigurationEndpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("DataTiering", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataTiering = types.DataTieringStatus(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("GlobalReplicationGroupInfo", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroupInfo(&sv.GlobalReplicationGroupInfo, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("IpDiscovery", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.IpDiscovery = types.IpDiscovery(xtv)
			}

		case strings.EqualFold("KmsKeyId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.KmsKeyId = ptr.String(xtv)
			}

		case strings.EqualFold("LogDeliveryConfigurations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentLogDeliveryConfigurationList(&sv.LogDeliveryConfigurations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("MemberClusters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentClusterIdList(&sv.MemberClusters, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("MemberClustersOutpostArns", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroupOutpostArnList(&sv.MemberClustersOutpostArns, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("MultiAZ", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MultiAZ = types.MultiAZStatus(xtv)
			}

		case strings.EqualFold("NetworkType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NetworkType = types.NetworkType(xtv)
			}

		case strings.EqualFold("NodeGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeGroupList(&sv.NodeGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PendingModifiedValues", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroupPendingModifiedValues(&sv.PendingModifiedValues, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReplicationGroupCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ReplicationGroupCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotRetentionLimit", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SnapshotRetentionLimit = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("SnapshottingClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshottingClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotWindow", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotWindow = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("TransitEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.TransitEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("TransitEncryptionMode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TransitEncryptionMode = types.TransitEncryptionMode(xtv)
			}

		case strings.EqualFold("UserGroupIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIds, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupAlreadyExistsFault(v **types.ReplicationGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplicationGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.ReplicationGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupAlreadyUnderMigrationFault(v **types.ReplicationGroupAlreadyUnderMigrationFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplicationGroupAlreadyUnderMigrationFault
	if *v == nil {
		sv = &types.ReplicationGroupAlreadyUnderMigrationFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupList(v *[]types.ReplicationGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReplicationGroup
	if *v == nil {
		sv = make([]types.ReplicationGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			var col types.ReplicationGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupListUnwrapped(v *[]types.ReplicationGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReplicationGroup
	if *v == nil {
		sv = make([]types.ReplicationGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReplicationGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReplicationGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReplicationGroupNotFoundFault(v **types.ReplicationGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplicationGroupNotFoundFault
	if *v == nil {
		sv = &types.ReplicationGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupNotUnderMigrationFault(v **types.ReplicationGroupNotUnderMigrationFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplicationGroupNotUnderMigrationFault
	if *v == nil {
		sv = &types.ReplicationGroupNotUnderMigrationFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupOutpostArnList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("ReplicationGroupOutpostArn", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReplicationGroupOutpostArnListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReplicationGroupPendingModifiedValues(v **types.ReplicationGroupPendingModifiedValues, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReplicationGroupPendingModifiedValues
	if *v == nil {
		sv = &types.ReplicationGroupPendingModifiedValues{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AuthTokenStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AuthTokenStatus = types.AuthTokenUpdateStatus(xtv)
			}

		case strings.EqualFold("AutomaticFailoverStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AutomaticFailoverStatus = types.PendingAutomaticFailoverStatus(xtv)
			}

		case strings.EqualFold("ClusterMode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ClusterMode = types.ClusterMode(xtv)
			}

		case strings.EqualFold("LogDeliveryConfigurations", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentPendingLogDeliveryConfigurationList(&sv.LogDeliveryConfigurations, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("PrimaryClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PrimaryClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("Resharding", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReshardingStatus(&sv.Resharding, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("TransitEncryptionEnabled", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.TransitEncryptionEnabled = ptr.Bool(xtv)
			}

		case strings.EqualFold("TransitEncryptionMode", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TransitEncryptionMode = types.TransitEncryptionMode(xtv)
			}

		case strings.EqualFold("UserGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupsUpdateStatus(&sv.UserGroups, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNode(v **types.ReservedCacheNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedCacheNode
	if *v == nil {
		sv = &types.ReservedCacheNode{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeCount", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.CacheNodeCount = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("Duration", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Duration = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("FixedPrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.FixedPrice = ptr.Float64(f64)
			}

		case strings.EqualFold("OfferingType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.OfferingType = ptr.String(xtv)
			}

		case strings.EqualFold("ProductDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ProductDescription = ptr.String(xtv)
			}

		case strings.EqualFold("RecurringCharges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentRecurringChargeList(&sv.RecurringCharges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReservationARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservationARN = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedCacheNodeId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedCacheNodeId = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedCacheNodesOfferingId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedCacheNodesOfferingId = ptr.String(xtv)
			}

		case strings.EqualFold("StartTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.StartTime = ptr.Time(t)
			}

		case strings.EqualFold("State", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.State = ptr.String(xtv)
			}

		case strings.EqualFold("UsagePrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.UsagePrice = ptr.Float64(f64)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodeAlreadyExistsFault(v **types.ReservedCacheNodeAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedCacheNodeAlreadyExistsFault
	if *v == nil {
		sv = &types.ReservedCacheNodeAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodeList(v *[]types.ReservedCacheNode, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReservedCacheNode
	if *v == nil {
		sv = make([]types.ReservedCacheNode, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReservedCacheNode", t.Name.Local):
			var col types.ReservedCacheNode
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReservedCacheNode(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodeListUnwrapped(v *[]types.ReservedCacheNode, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReservedCacheNode
	if *v == nil {
		sv = make([]types.ReservedCacheNode, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReservedCacheNode
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReservedCacheNode(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReservedCacheNodeNotFoundFault(v **types.ReservedCacheNodeNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedCacheNodeNotFoundFault
	if *v == nil {
		sv = &types.ReservedCacheNodeNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodeQuotaExceededFault(v **types.ReservedCacheNodeQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedCacheNodeQuotaExceededFault
	if *v == nil {
		sv = &types.ReservedCacheNodeQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodesOffering(v **types.ReservedCacheNodesOffering, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedCacheNodesOffering
	if *v == nil {
		sv = &types.ReservedCacheNodesOffering{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("Duration", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Duration = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("FixedPrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.FixedPrice = ptr.Float64(f64)
			}

		case strings.EqualFold("OfferingType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.OfferingType = ptr.String(xtv)
			}

		case strings.EqualFold("ProductDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ProductDescription = ptr.String(xtv)
			}

		case strings.EqualFold("RecurringCharges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentRecurringChargeList(&sv.RecurringCharges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReservedCacheNodesOfferingId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReservedCacheNodesOfferingId = ptr.String(xtv)
			}

		case strings.EqualFold("UsagePrice", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.UsagePrice = ptr.Float64(f64)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodesOfferingList(v *[]types.ReservedCacheNodesOffering, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ReservedCacheNodesOffering
	if *v == nil {
		sv = make([]types.ReservedCacheNodesOffering, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ReservedCacheNodesOffering", t.Name.Local):
			var col types.ReservedCacheNodesOffering
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentReservedCacheNodesOffering(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReservedCacheNodesOfferingListUnwrapped(v *[]types.ReservedCacheNodesOffering, decoder smithyxml.NodeDecoder) error {
	var sv []types.ReservedCacheNodesOffering
	if *v == nil {
		sv = make([]types.ReservedCacheNodesOffering, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ReservedCacheNodesOffering
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentReservedCacheNodesOffering(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentReservedCacheNodesOfferingNotFoundFault(v **types.ReservedCacheNodesOfferingNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReservedCacheNodesOfferingNotFoundFault
	if *v == nil {
		sv = &types.ReservedCacheNodesOfferingNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentReshardingStatus(v **types.ReshardingStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ReshardingStatus
	if *v == nil {
		sv = &types.ReshardingStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SlotMigration", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSlotMigration(&sv.SlotMigration, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentScaleConfig(v **types.ScaleConfig, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ScaleConfig
	if *v == nil {
		sv = &types.ScaleConfig{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ScaleIntervalMinutes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ScaleIntervalMinutes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("ScalePercentage", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.ScalePercentage = ptr.Int32(int32(i64))
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSecurityGroupIdsList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("SecurityGroupId", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSecurityGroupIdsListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentSecurityGroupMembership(v **types.SecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SecurityGroupMembership
	if *v == nil {
		sv = &types.SecurityGroupMembership{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SecurityGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SecurityGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSecurityGroupMembershipList(v *[]types.SecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.SecurityGroupMembership
	if *v == nil {
		sv = make([]types.SecurityGroupMembership, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.SecurityGroupMembership
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSecurityGroupMembership(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSecurityGroupMembershipListUnwrapped(v *[]types.SecurityGroupMembership, decoder smithyxml.NodeDecoder) error {
	var sv []types.SecurityGroupMembership
	if *v == nil {
		sv = make([]types.SecurityGroupMembership, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.SecurityGroupMembership
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSecurityGroupMembership(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentServerlessCache(v **types.ServerlessCache, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCache
	if *v == nil {
		sv = &types.ServerlessCache{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("CacheUsageLimits", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheUsageLimits(&sv.CacheUsageLimits, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("CreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CreateTime = ptr.Time(t)
			}

		case strings.EqualFold("DailySnapshotTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DailySnapshotTime = ptr.String(xtv)
			}

		case strings.EqualFold("Description", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Description = ptr.String(xtv)
			}

		case strings.EqualFold("Endpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.Endpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("FullEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.FullEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("KmsKeyId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.KmsKeyId = ptr.String(xtv)
			}

		case strings.EqualFold("MajorEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MajorEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("ReaderEndpoint", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEndpoint(&sv.ReaderEndpoint, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SecurityGroupIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSecurityGroupIdsList(&sv.SecurityGroupIds, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ServerlessCacheName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServerlessCacheName = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotRetentionLimit", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SnapshotRetentionLimit = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("SubnetIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubnetIdsList(&sv.SubnetIds, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserGroupId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheAlreadyExistsFault(v **types.ServerlessCacheAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheAlreadyExistsFault
	if *v == nil {
		sv = &types.ServerlessCacheAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheConfiguration(v **types.ServerlessCacheConfiguration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheConfiguration
	if *v == nil {
		sv = &types.ServerlessCacheConfiguration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MajorEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MajorEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("ServerlessCacheName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServerlessCacheName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheList(v *[]types.ServerlessCache, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ServerlessCache
	if *v == nil {
		sv = make([]types.ServerlessCache, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.ServerlessCache
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentServerlessCache(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheListUnwrapped(v *[]types.ServerlessCache, decoder smithyxml.NodeDecoder) error {
	var sv []types.ServerlessCache
	if *v == nil {
		sv = make([]types.ServerlessCache, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ServerlessCache
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentServerlessCache(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentServerlessCacheNotFoundFault(v **types.ServerlessCacheNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheNotFoundFault
	if *v == nil {
		sv = &types.ServerlessCacheNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheQuotaForCustomerExceededFault(v **types.ServerlessCacheQuotaForCustomerExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheQuotaForCustomerExceededFault
	if *v == nil {
		sv = &types.ServerlessCacheQuotaForCustomerExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheSnapshot(v **types.ServerlessCacheSnapshot, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheSnapshot
	if *v == nil {
		sv = &types.ServerlessCacheSnapshot{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("BytesUsedForCache", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.BytesUsedForCache = ptr.String(xtv)
			}

		case strings.EqualFold("CreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CreateTime = ptr.Time(t)
			}

		case strings.EqualFold("ExpiryTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ExpiryTime = ptr.Time(t)
			}

		case strings.EqualFold("KmsKeyId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.KmsKeyId = ptr.String(xtv)
			}

		case strings.EqualFold("ServerlessCacheConfiguration", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheConfiguration(&sv.ServerlessCacheConfiguration, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ServerlessCacheSnapshotName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServerlessCacheSnapshotName = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotType = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheSnapshotAlreadyExistsFault(v **types.ServerlessCacheSnapshotAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheSnapshotAlreadyExistsFault
	if *v == nil {
		sv = &types.ServerlessCacheSnapshotAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheSnapshotList(v *[]types.ServerlessCacheSnapshot, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ServerlessCacheSnapshot
	if *v == nil {
		sv = make([]types.ServerlessCacheSnapshot, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ServerlessCacheSnapshot", t.Name.Local):
			var col types.ServerlessCacheSnapshot
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshot(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheSnapshotListUnwrapped(v *[]types.ServerlessCacheSnapshot, decoder smithyxml.NodeDecoder) error {
	var sv []types.ServerlessCacheSnapshot
	if *v == nil {
		sv = make([]types.ServerlessCacheSnapshot, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ServerlessCacheSnapshot
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshot(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentServerlessCacheSnapshotNotFoundFault(v **types.ServerlessCacheSnapshotNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheSnapshotNotFoundFault
	if *v == nil {
		sv = &types.ServerlessCacheSnapshotNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServerlessCacheSnapshotQuotaExceededFault(v **types.ServerlessCacheSnapshotQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServerlessCacheSnapshotQuotaExceededFault
	if *v == nil {
		sv = &types.ServerlessCacheSnapshotQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServiceLinkedRoleNotFoundFault(v **types.ServiceLinkedRoleNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServiceLinkedRoleNotFoundFault
	if *v == nil {
		sv = &types.ServiceLinkedRoleNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServiceUpdate(v **types.ServiceUpdate, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServiceUpdate
	if *v == nil {
		sv = &types.ServiceUpdate{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AutoUpdateAfterRecommendedApplyByDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected BooleanOptional to be of type *bool, got %T instead", val)
				}
				sv.AutoUpdateAfterRecommendedApplyByDate = ptr.Bool(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("EngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("EstimatedUpdateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EstimatedUpdateTime = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateDescription = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateEndDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ServiceUpdateEndDate = ptr.Time(t)
			}

		case strings.EqualFold("ServiceUpdateName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateName = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateRecommendedApplyByDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ServiceUpdateRecommendedApplyByDate = ptr.Time(t)
			}

		case strings.EqualFold("ServiceUpdateReleaseDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ServiceUpdateReleaseDate = ptr.Time(t)
			}

		case strings.EqualFold("ServiceUpdateSeverity", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateSeverity = types.ServiceUpdateSeverity(xtv)
			}

		case strings.EqualFold("ServiceUpdateStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateStatus = types.ServiceUpdateStatus(xtv)
			}

		case strings.EqualFold("ServiceUpdateType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateType = types.ServiceUpdateType(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServiceUpdateList(v *[]types.ServiceUpdate, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.ServiceUpdate
	if *v == nil {
		sv = make([]types.ServiceUpdate, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("ServiceUpdate", t.Name.Local):
			var col types.ServiceUpdate
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentServiceUpdate(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentServiceUpdateListUnwrapped(v *[]types.ServiceUpdate, decoder smithyxml.NodeDecoder) error {
	var sv []types.ServiceUpdate
	if *v == nil {
		sv = make([]types.ServiceUpdate, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.ServiceUpdate
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentServiceUpdate(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentServiceUpdateNotFoundFault(v **types.ServiceUpdateNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.ServiceUpdateNotFoundFault
	if *v == nil {
		sv = &types.ServiceUpdateNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSlotMigration(v **types.SlotMigration, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SlotMigration
	if *v == nil {
		sv = &types.SlotMigration{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ProgressPercentage", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				f64, err := strconv.ParseFloat(xtv, 64)
				if err != nil {
					return err
				}
				sv.ProgressPercentage = ptr.Float64(f64)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSnapshot(v **types.Snapshot, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Snapshot
	if *v == nil {
		sv = &types.Snapshot{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("AutomaticFailover", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AutomaticFailover = types.AutomaticFailoverStatus(xtv)
			}

		case strings.EqualFold("AutoMinorVersionUpgrade", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv, err := strconv.ParseBool(string(val))
				if err != nil {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", val)
				}
				sv.AutoMinorVersionUpgrade = ptr.Bool(xtv)
			}

		case strings.EqualFold("CacheClusterCreateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.CacheClusterCreateTime = ptr.Time(t)
			}

		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheNodeType = ptr.String(xtv)
			}

		case strings.EqualFold("CacheParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("CacheSubnetGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheSubnetGroupName = ptr.String(xtv)
			}

		case strings.EqualFold("DataTiering", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.DataTiering = types.DataTieringStatus(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("EngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("KmsKeyId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.KmsKeyId = ptr.String(xtv)
			}

		case strings.EqualFold("NodeSnapshots", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeSnapshotList(&sv.NodeSnapshots, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NumCacheNodes", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumCacheNodes = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("NumNodeGroups", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.NumNodeGroups = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("Port", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.Port = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("PreferredAvailabilityZone", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredAvailabilityZone = ptr.String(xtv)
			}

		case strings.EqualFold("PreferredMaintenanceWindow", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredMaintenanceWindow = ptr.String(xtv)
			}

		case strings.EqualFold("PreferredOutpostArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.PreferredOutpostArn = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupDescription", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupDescription = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotName = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotRetentionLimit", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				i64, err := strconv.ParseInt(xtv, 10, 64)
				if err != nil {
					return err
				}
				sv.SnapshotRetentionLimit = ptr.Int32(int32(i64))
			}

		case strings.EqualFold("SnapshotSource", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotSource = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotStatus = ptr.String(xtv)
			}

		case strings.EqualFold("SnapshotWindow", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SnapshotWindow = ptr.String(xtv)
			}

		case strings.EqualFold("TopicArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.TopicArn = ptr.String(xtv)
			}

		case strings.EqualFold("VpcId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.VpcId = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSnapshotAlreadyExistsFault(v **types.SnapshotAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SnapshotAlreadyExistsFault
	if *v == nil {
		sv = &types.SnapshotAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSnapshotFeatureNotSupportedFault(v **types.SnapshotFeatureNotSupportedFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SnapshotFeatureNotSupportedFault
	if *v == nil {
		sv = &types.SnapshotFeatureNotSupportedFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSnapshotList(v *[]types.Snapshot, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Snapshot
	if *v == nil {
		sv = make([]types.Snapshot, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Snapshot", t.Name.Local):
			var col types.Snapshot
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSnapshot(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSnapshotListUnwrapped(v *[]types.Snapshot, decoder smithyxml.NodeDecoder) error {
	var sv []types.Snapshot
	if *v == nil {
		sv = make([]types.Snapshot, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Snapshot
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSnapshot(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentSnapshotNotFoundFault(v **types.SnapshotNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SnapshotNotFoundFault
	if *v == nil {
		sv = &types.SnapshotNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSnapshotQuotaExceededFault(v **types.SnapshotQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SnapshotQuotaExceededFault
	if *v == nil {
		sv = &types.SnapshotQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubnet(v **types.Subnet, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Subnet
	if *v == nil {
		sv = &types.Subnet{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SubnetAvailabilityZone", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAvailabilityZone(&sv.SubnetAvailabilityZone, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SubnetIdentifier", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubnetIdentifier = ptr.String(xtv)
			}

		case strings.EqualFold("SubnetOutpost", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSubnetOutpost(&sv.SubnetOutpost, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("SupportedNetworkTypes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNetworkTypeList(&sv.SupportedNetworkTypes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubnetIdsList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("SubnetId", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubnetIdsListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentSubnetInUse(v **types.SubnetInUse, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SubnetInUse
	if *v == nil {
		sv = &types.SubnetInUse{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubnetList(v *[]types.Subnet, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Subnet
	if *v == nil {
		sv = make([]types.Subnet, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Subnet", t.Name.Local):
			var col types.Subnet
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentSubnet(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubnetListUnwrapped(v *[]types.Subnet, decoder smithyxml.NodeDecoder) error {
	var sv []types.Subnet
	if *v == nil {
		sv = make([]types.Subnet, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Subnet
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentSubnet(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentSubnetNotAllowedFault(v **types.SubnetNotAllowedFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SubnetNotAllowedFault
	if *v == nil {
		sv = &types.SubnetNotAllowedFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentSubnetOutpost(v **types.SubnetOutpost, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.SubnetOutpost
	if *v == nil {
		sv = &types.SubnetOutpost{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("SubnetOutpostArn", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SubnetOutpostArn = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTag(v **types.Tag, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.Tag
	if *v == nil {
		sv = &types.Tag{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Key", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Key = ptr.String(xtv)
			}

		case strings.EqualFold("Value", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Value = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTagList(v *[]types.Tag, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.Tag
	if *v == nil {
		sv = make([]types.Tag, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("Tag", t.Name.Local):
			var col types.Tag
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentTag(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTagListUnwrapped(v *[]types.Tag, decoder smithyxml.NodeDecoder) error {
	var sv []types.Tag
	if *v == nil {
		sv = make([]types.Tag, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.Tag
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentTag(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentTagNotFoundFault(v **types.TagNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TagNotFoundFault
	if *v == nil {
		sv = &types.TagNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTagQuotaPerResourceExceeded(v **types.TagQuotaPerResourceExceeded, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TagQuotaPerResourceExceeded
	if *v == nil {
		sv = &types.TagQuotaPerResourceExceeded{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentTestFailoverNotAvailableFault(v **types.TestFailoverNotAvailableFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.TestFailoverNotAvailableFault
	if *v == nil {
		sv = &types.TestFailoverNotAvailableFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUGReplicationGroupIdList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUGReplicationGroupIdListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUGServerlessCacheIdList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUGServerlessCacheIdListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUnprocessedUpdateAction(v **types.UnprocessedUpdateAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UnprocessedUpdateAction
	if *v == nil {
		sv = &types.UnprocessedUpdateAction{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("ErrorMessage", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ErrorMessage = ptr.String(xtv)
			}

		case strings.EqualFold("ErrorType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ErrorType = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUnprocessedUpdateActionList(v *[]types.UnprocessedUpdateAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.UnprocessedUpdateAction
	if *v == nil {
		sv = make([]types.UnprocessedUpdateAction, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("UnprocessedUpdateAction", t.Name.Local):
			var col types.UnprocessedUpdateAction
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentUnprocessedUpdateAction(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUnprocessedUpdateActionListUnwrapped(v *[]types.UnprocessedUpdateAction, decoder smithyxml.NodeDecoder) error {
	var sv []types.UnprocessedUpdateAction
	if *v == nil {
		sv = make([]types.UnprocessedUpdateAction, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.UnprocessedUpdateAction
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentUnprocessedUpdateAction(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUpdateAction(v **types.UpdateAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UpdateAction
	if *v == nil {
		sv = &types.UpdateAction{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusterId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheClusterId = ptr.String(xtv)
			}

		case strings.EqualFold("CacheNodeUpdateStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeUpdateStatusList(&sv.CacheNodeUpdateStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("EstimatedUpdateTime", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.EstimatedUpdateTime = ptr.String(xtv)
			}

		case strings.EqualFold("NodeGroupUpdateStatus", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeGroupUpdateStatusList(&sv.NodeGroupUpdateStatus, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("NodesUpdated", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NodesUpdated = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ReplicationGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateName = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdateRecommendedApplyByDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ServiceUpdateRecommendedApplyByDate = ptr.Time(t)
			}

		case strings.EqualFold("ServiceUpdateReleaseDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.ServiceUpdateReleaseDate = ptr.Time(t)
			}

		case strings.EqualFold("ServiceUpdateSeverity", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateSeverity = types.ServiceUpdateSeverity(xtv)
			}

		case strings.EqualFold("ServiceUpdateStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateStatus = types.ServiceUpdateStatus(xtv)
			}

		case strings.EqualFold("ServiceUpdateType", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ServiceUpdateType = types.ServiceUpdateType(xtv)
			}

		case strings.EqualFold("SlaMet", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.SlaMet = types.SlaMet(xtv)
			}

		case strings.EqualFold("UpdateActionAvailableDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.UpdateActionAvailableDate = ptr.Time(t)
			}

		case strings.EqualFold("UpdateActionStatus", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UpdateActionStatus = types.UpdateActionStatus(xtv)
			}

		case strings.EqualFold("UpdateActionStatusModifiedDate", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				t, err := smithytime.ParseDateTime(xtv)
				if err != nil {
					return err
				}
				sv.UpdateActionStatusModifiedDate = ptr.Time(t)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUpdateActionList(v *[]types.UpdateAction, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.UpdateAction
	if *v == nil {
		sv = make([]types.UpdateAction, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("UpdateAction", t.Name.Local):
			var col types.UpdateAction
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentUpdateAction(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUpdateActionListUnwrapped(v *[]types.UpdateAction, decoder smithyxml.NodeDecoder) error {
	var sv []types.UpdateAction
	if *v == nil {
		sv = make([]types.UpdateAction, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.UpdateAction
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentUpdateAction(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUser(v **types.User, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.User
	if *v == nil {
		sv = &types.User{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AccessString", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AccessString = ptr.String(xtv)
			}

		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Authentication", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAuthentication(&sv.Authentication, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIds, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserId = ptr.String(xtv)
			}

		case strings.EqualFold("UserName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserAlreadyExistsFault(v **types.UserAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserAlreadyExistsFault
	if *v == nil {
		sv = &types.UserAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroup(v **types.UserGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserGroup
	if *v == nil {
		sv = &types.UserGroup{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("PendingChanges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupPendingChanges(&sv.PendingChanges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReplicationGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGReplicationGroupIdList(&sv.ReplicationGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ServerlessCaches", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGServerlessCacheIdList(&sv.ServerlessCaches, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("UserIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserIdList(&sv.UserIds, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupAlreadyExistsFault(v **types.UserGroupAlreadyExistsFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserGroupAlreadyExistsFault
	if *v == nil {
		sv = &types.UserGroupAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupIdList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupIdListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUserGroupList(v *[]types.UserGroup, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.UserGroup
	if *v == nil {
		sv = make([]types.UserGroup, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.UserGroup
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentUserGroup(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupListUnwrapped(v *[]types.UserGroup, decoder smithyxml.NodeDecoder) error {
	var sv []types.UserGroup
	if *v == nil {
		sv = make([]types.UserGroup, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.UserGroup
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentUserGroup(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUserGroupNotFoundFault(v **types.UserGroupNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserGroupNotFoundFault
	if *v == nil {
		sv = &types.UserGroupNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupPendingChanges(v **types.UserGroupPendingChanges, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserGroupPendingChanges
	if *v == nil {
		sv = &types.UserGroupPendingChanges{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("UserIdsToAdd", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserIdList(&sv.UserIdsToAdd, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserIdsToRemove", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserIdList(&sv.UserIdsToRemove, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupQuotaExceededFault(v **types.UserGroupQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserGroupQuotaExceededFault
	if *v == nil {
		sv = &types.UserGroupQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserGroupsUpdateStatus(v **types.UserGroupsUpdateStatus, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserGroupsUpdateStatus
	if *v == nil {
		sv = &types.UserGroupsUpdateStatus{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("UserGroupIdsToAdd", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIdsToAdd, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserGroupIdsToRemove", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIdsToRemove, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserIdList(v *[]string, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		memberDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		decoder = memberDecoder
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col string
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				col = xtv
			}
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserIdListUnwrapped(v *[]string, decoder smithyxml.NodeDecoder) error {
	var sv []string
	if *v == nil {
		sv = make([]string, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv string
		t := decoder.StartEl
		_ = t
		val, err := decoder.Value()
		if err != nil {
			return err
		}
		if val == nil {
			break
		}
		{
			xtv := string(val)
			mv = xtv
		}
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUserList(v *[]types.User, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv []types.User
	if *v == nil {
		sv = make([]types.User, 0)
	} else {
		sv = *v
	}

	originalDecoder := decoder
	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		switch {
		case strings.EqualFold("member", t.Name.Local):
			var col types.User
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			destAddr := &col
			if err := awsAwsquery_deserializeDocumentUser(&destAddr, nodeDecoder); err != nil {
				return err
			}
			col = *destAddr
			sv = append(sv, col)

		default:
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserListUnwrapped(v *[]types.User, decoder smithyxml.NodeDecoder) error {
	var sv []types.User
	if *v == nil {
		sv = make([]types.User, 0)
	} else {
		sv = *v
	}

	switch {
	default:
		var mv types.User
		t := decoder.StartEl
		_ = t
		nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
		destAddr := &mv
		if err := awsAwsquery_deserializeDocumentUser(&destAddr, nodeDecoder); err != nil {
			return err
		}
		mv = *destAddr
		sv = append(sv, mv)
	}
	*v = sv
	return nil
}
func awsAwsquery_deserializeDocumentUserNotFoundFault(v **types.UserNotFoundFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserNotFoundFault
	if *v == nil {
		sv = &types.UserNotFoundFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeDocumentUserQuotaExceededFault(v **types.UserQuotaExceededFault, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *types.UserQuotaExceededFault
	if *v == nil {
		sv = &types.UserQuotaExceededFault{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("message", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Message = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentAddTagsToResourceOutput(v **AddTagsToResourceOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *AddTagsToResourceOutput
	if *v == nil {
		sv = &AddTagsToResourceOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("TagList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.TagList, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentAuthorizeCacheSecurityGroupIngressOutput(v **AuthorizeCacheSecurityGroupIngressOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *AuthorizeCacheSecurityGroupIngressOutput
	if *v == nil {
		sv = &AuthorizeCacheSecurityGroupIngressOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSecurityGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroup(&sv.CacheSecurityGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentBatchApplyUpdateActionOutput(v **BatchApplyUpdateActionOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *BatchApplyUpdateActionOutput
	if *v == nil {
		sv = &BatchApplyUpdateActionOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ProcessedUpdateActions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentProcessedUpdateActionList(&sv.ProcessedUpdateActions, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UnprocessedUpdateActions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUnprocessedUpdateActionList(&sv.UnprocessedUpdateActions, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentBatchStopUpdateActionOutput(v **BatchStopUpdateActionOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *BatchStopUpdateActionOutput
	if *v == nil {
		sv = &BatchStopUpdateActionOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ProcessedUpdateActions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentProcessedUpdateActionList(&sv.ProcessedUpdateActions, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UnprocessedUpdateActions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUnprocessedUpdateActionList(&sv.UnprocessedUpdateActions, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCompleteMigrationOutput(v **CompleteMigrationOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CompleteMigrationOutput
	if *v == nil {
		sv = &CompleteMigrationOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCopyServerlessCacheSnapshotOutput(v **CopyServerlessCacheSnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CopyServerlessCacheSnapshotOutput
	if *v == nil {
		sv = &CopyServerlessCacheSnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCacheSnapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshot(&sv.ServerlessCacheSnapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCopySnapshotOutput(v **CopySnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CopySnapshotOutput
	if *v == nil {
		sv = &CopySnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Snapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSnapshot(&sv.Snapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateCacheClusterOutput(v **CreateCacheClusterOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateCacheClusterOutput
	if *v == nil {
		sv = &CreateCacheClusterOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheCluster", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheCluster(&sv.CacheCluster, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateCacheParameterGroupOutput(v **CreateCacheParameterGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateCacheParameterGroupOutput
	if *v == nil {
		sv = &CreateCacheParameterGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheParameterGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheParameterGroup(&sv.CacheParameterGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateCacheSecurityGroupOutput(v **CreateCacheSecurityGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateCacheSecurityGroupOutput
	if *v == nil {
		sv = &CreateCacheSecurityGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSecurityGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroup(&sv.CacheSecurityGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateCacheSubnetGroupOutput(v **CreateCacheSubnetGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateCacheSubnetGroupOutput
	if *v == nil {
		sv = &CreateCacheSubnetGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSubnetGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSubnetGroup(&sv.CacheSubnetGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateGlobalReplicationGroupOutput(v **CreateGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateGlobalReplicationGroupOutput
	if *v == nil {
		sv = &CreateGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateReplicationGroupOutput(v **CreateReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateReplicationGroupOutput
	if *v == nil {
		sv = &CreateReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateServerlessCacheOutput(v **CreateServerlessCacheOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateServerlessCacheOutput
	if *v == nil {
		sv = &CreateServerlessCacheOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCache", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCache(&sv.ServerlessCache, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateServerlessCacheSnapshotOutput(v **CreateServerlessCacheSnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateServerlessCacheSnapshotOutput
	if *v == nil {
		sv = &CreateServerlessCacheSnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCacheSnapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshot(&sv.ServerlessCacheSnapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateSnapshotOutput(v **CreateSnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateSnapshotOutput
	if *v == nil {
		sv = &CreateSnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Snapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSnapshot(&sv.Snapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateUserGroupOutput(v **CreateUserGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateUserGroupOutput
	if *v == nil {
		sv = &CreateUserGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("PendingChanges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupPendingChanges(&sv.PendingChanges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReplicationGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGReplicationGroupIdList(&sv.ReplicationGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ServerlessCaches", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGServerlessCacheIdList(&sv.ServerlessCaches, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("UserIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserIdList(&sv.UserIds, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentCreateUserOutput(v **CreateUserOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *CreateUserOutput
	if *v == nil {
		sv = &CreateUserOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AccessString", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AccessString = ptr.String(xtv)
			}

		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Authentication", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAuthentication(&sv.Authentication, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIds, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserId = ptr.String(xtv)
			}

		case strings.EqualFold("UserName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDecreaseNodeGroupsInGlobalReplicationGroupOutput(v **DecreaseNodeGroupsInGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DecreaseNodeGroupsInGlobalReplicationGroupOutput
	if *v == nil {
		sv = &DecreaseNodeGroupsInGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDecreaseReplicaCountOutput(v **DecreaseReplicaCountOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DecreaseReplicaCountOutput
	if *v == nil {
		sv = &DecreaseReplicaCountOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteCacheClusterOutput(v **DeleteCacheClusterOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteCacheClusterOutput
	if *v == nil {
		sv = &DeleteCacheClusterOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheCluster", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheCluster(&sv.CacheCluster, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteGlobalReplicationGroupOutput(v **DeleteGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteGlobalReplicationGroupOutput
	if *v == nil {
		sv = &DeleteGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteReplicationGroupOutput(v **DeleteReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteReplicationGroupOutput
	if *v == nil {
		sv = &DeleteReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteServerlessCacheOutput(v **DeleteServerlessCacheOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteServerlessCacheOutput
	if *v == nil {
		sv = &DeleteServerlessCacheOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCache", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCache(&sv.ServerlessCache, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteServerlessCacheSnapshotOutput(v **DeleteServerlessCacheSnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteServerlessCacheSnapshotOutput
	if *v == nil {
		sv = &DeleteServerlessCacheSnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCacheSnapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshot(&sv.ServerlessCacheSnapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteSnapshotOutput(v **DeleteSnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteSnapshotOutput
	if *v == nil {
		sv = &DeleteSnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Snapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSnapshot(&sv.Snapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteUserGroupOutput(v **DeleteUserGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteUserGroupOutput
	if *v == nil {
		sv = &DeleteUserGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("PendingChanges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupPendingChanges(&sv.PendingChanges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReplicationGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGReplicationGroupIdList(&sv.ReplicationGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ServerlessCaches", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGServerlessCacheIdList(&sv.ServerlessCaches, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("UserIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserIdList(&sv.UserIds, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDeleteUserOutput(v **DeleteUserOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DeleteUserOutput
	if *v == nil {
		sv = &DeleteUserOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AccessString", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AccessString = ptr.String(xtv)
			}

		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Authentication", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAuthentication(&sv.Authentication, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIds, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserId = ptr.String(xtv)
			}

		case strings.EqualFold("UserName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeCacheClustersOutput(v **DescribeCacheClustersOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeCacheClustersOutput
	if *v == nil {
		sv = &DescribeCacheClustersOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheClusters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheClusterList(&sv.CacheClusters, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeCacheEngineVersionsOutput(v **DescribeCacheEngineVersionsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeCacheEngineVersionsOutput
	if *v == nil {
		sv = &DescribeCacheEngineVersionsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheEngineVersions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheEngineVersionList(&sv.CacheEngineVersions, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeCacheParameterGroupsOutput(v **DescribeCacheParameterGroupsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeCacheParameterGroupsOutput
	if *v == nil {
		sv = &DescribeCacheParameterGroupsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheParameterGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheParameterGroupList(&sv.CacheParameterGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeCacheParametersOutput(v **DescribeCacheParametersOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeCacheParametersOutput
	if *v == nil {
		sv = &DescribeCacheParametersOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheNodeTypeSpecificParameters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheNodeTypeSpecificParametersList(&sv.CacheNodeTypeSpecificParameters, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("Parameters", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentParametersList(&sv.Parameters, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeCacheSecurityGroupsOutput(v **DescribeCacheSecurityGroupsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeCacheSecurityGroupsOutput
	if *v == nil {
		sv = &DescribeCacheSecurityGroupsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSecurityGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroups(&sv.CacheSecurityGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeCacheSubnetGroupsOutput(v **DescribeCacheSubnetGroupsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeCacheSubnetGroupsOutput
	if *v == nil {
		sv = &DescribeCacheSubnetGroupsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSubnetGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSubnetGroups(&sv.CacheSubnetGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeEngineDefaultParametersOutput(v **DescribeEngineDefaultParametersOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeEngineDefaultParametersOutput
	if *v == nil {
		sv = &DescribeEngineDefaultParametersOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("EngineDefaults", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEngineDefaults(&sv.EngineDefaults, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeEventsOutput(v **DescribeEventsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeEventsOutput
	if *v == nil {
		sv = &DescribeEventsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Events", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentEventList(&sv.Events, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeGlobalReplicationGroupsOutput(v **DescribeGlobalReplicationGroupsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeGlobalReplicationGroupsOutput
	if *v == nil {
		sv = &DescribeGlobalReplicationGroupsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroupList(&sv.GlobalReplicationGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeReplicationGroupsOutput(v **DescribeReplicationGroupsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeReplicationGroupsOutput
	if *v == nil {
		sv = &DescribeReplicationGroupsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("ReplicationGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroupList(&sv.ReplicationGroups, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeReservedCacheNodesOfferingsOutput(v **DescribeReservedCacheNodesOfferingsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeReservedCacheNodesOfferingsOutput
	if *v == nil {
		sv = &DescribeReservedCacheNodesOfferingsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedCacheNodesOfferings", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReservedCacheNodesOfferingList(&sv.ReservedCacheNodesOfferings, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeReservedCacheNodesOutput(v **DescribeReservedCacheNodesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeReservedCacheNodesOutput
	if *v == nil {
		sv = &DescribeReservedCacheNodesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("ReservedCacheNodes", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReservedCacheNodeList(&sv.ReservedCacheNodes, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeServerlessCacheSnapshotsOutput(v **DescribeServerlessCacheSnapshotsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeServerlessCacheSnapshotsOutput
	if *v == nil {
		sv = &DescribeServerlessCacheSnapshotsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("ServerlessCacheSnapshots", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshotList(&sv.ServerlessCacheSnapshots, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeServerlessCachesOutput(v **DescribeServerlessCachesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeServerlessCachesOutput
	if *v == nil {
		sv = &DescribeServerlessCachesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("NextToken", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.NextToken = ptr.String(xtv)
			}

		case strings.EqualFold("ServerlessCaches", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheList(&sv.ServerlessCaches, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeServiceUpdatesOutput(v **DescribeServiceUpdatesOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeServiceUpdatesOutput
	if *v == nil {
		sv = &DescribeServiceUpdatesOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("ServiceUpdates", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServiceUpdateList(&sv.ServiceUpdates, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeSnapshotsOutput(v **DescribeSnapshotsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeSnapshotsOutput
	if *v == nil {
		sv = &DescribeSnapshotsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("Snapshots", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentSnapshotList(&sv.Snapshots, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeUpdateActionsOutput(v **DescribeUpdateActionsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeUpdateActionsOutput
	if *v == nil {
		sv = &DescribeUpdateActionsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("UpdateActions", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUpdateActionList(&sv.UpdateActions, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeUserGroupsOutput(v **DescribeUserGroupsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeUserGroupsOutput
	if *v == nil {
		sv = &DescribeUserGroupsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupList(&sv.UserGroups, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDescribeUsersOutput(v **DescribeUsersOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DescribeUsersOutput
	if *v == nil {
		sv = &DescribeUsersOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("Marker", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Marker = ptr.String(xtv)
			}

		case strings.EqualFold("Users", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserList(&sv.Users, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentDisassociateGlobalReplicationGroupOutput(v **DisassociateGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *DisassociateGlobalReplicationGroupOutput
	if *v == nil {
		sv = &DisassociateGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentExportServerlessCacheSnapshotOutput(v **ExportServerlessCacheSnapshotOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ExportServerlessCacheSnapshotOutput
	if *v == nil {
		sv = &ExportServerlessCacheSnapshotOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCacheSnapshot", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCacheSnapshot(&sv.ServerlessCacheSnapshot, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentFailoverGlobalReplicationGroupOutput(v **FailoverGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *FailoverGlobalReplicationGroupOutput
	if *v == nil {
		sv = &FailoverGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentIncreaseNodeGroupsInGlobalReplicationGroupOutput(v **IncreaseNodeGroupsInGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *IncreaseNodeGroupsInGlobalReplicationGroupOutput
	if *v == nil {
		sv = &IncreaseNodeGroupsInGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentIncreaseReplicaCountOutput(v **IncreaseReplicaCountOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *IncreaseReplicaCountOutput
	if *v == nil {
		sv = &IncreaseReplicaCountOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListAllowedNodeTypeModificationsOutput(v **ListAllowedNodeTypeModificationsOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListAllowedNodeTypeModificationsOutput
	if *v == nil {
		sv = &ListAllowedNodeTypeModificationsOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ScaleDownModifications", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeTypeList(&sv.ScaleDownModifications, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ScaleUpModifications", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentNodeTypeList(&sv.ScaleUpModifications, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("TagList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.TagList, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyCacheClusterOutput(v **ModifyCacheClusterOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyCacheClusterOutput
	if *v == nil {
		sv = &ModifyCacheClusterOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheCluster", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheCluster(&sv.CacheCluster, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyCacheParameterGroupOutput(v **ModifyCacheParameterGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyCacheParameterGroupOutput
	if *v == nil {
		sv = &ModifyCacheParameterGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyCacheSubnetGroupOutput(v **ModifyCacheSubnetGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyCacheSubnetGroupOutput
	if *v == nil {
		sv = &ModifyCacheSubnetGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSubnetGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSubnetGroup(&sv.CacheSubnetGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyGlobalReplicationGroupOutput(v **ModifyGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyGlobalReplicationGroupOutput
	if *v == nil {
		sv = &ModifyGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyReplicationGroupOutput(v **ModifyReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyReplicationGroupOutput
	if *v == nil {
		sv = &ModifyReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyReplicationGroupShardConfigurationOutput(v **ModifyReplicationGroupShardConfigurationOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyReplicationGroupShardConfigurationOutput
	if *v == nil {
		sv = &ModifyReplicationGroupShardConfigurationOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyServerlessCacheOutput(v **ModifyServerlessCacheOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyServerlessCacheOutput
	if *v == nil {
		sv = &ModifyServerlessCacheOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ServerlessCache", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentServerlessCache(&sv.ServerlessCache, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyUserGroupOutput(v **ModifyUserGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyUserGroupOutput
	if *v == nil {
		sv = &ModifyUserGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("PendingChanges", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupPendingChanges(&sv.PendingChanges, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ReplicationGroups", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGReplicationGroupIdList(&sv.ReplicationGroups, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("ServerlessCaches", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUGServerlessCacheIdList(&sv.ServerlessCaches, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserGroupId = ptr.String(xtv)
			}

		case strings.EqualFold("UserIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserIdList(&sv.UserIds, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentModifyUserOutput(v **ModifyUserOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ModifyUserOutput
	if *v == nil {
		sv = &ModifyUserOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("AccessString", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.AccessString = ptr.String(xtv)
			}

		case strings.EqualFold("ARN", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.ARN = ptr.String(xtv)
			}

		case strings.EqualFold("Authentication", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentAuthentication(&sv.Authentication, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("Engine", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Engine = ptr.String(xtv)
			}

		case strings.EqualFold("MinimumEngineVersion", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.MinimumEngineVersion = ptr.String(xtv)
			}

		case strings.EqualFold("Status", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.Status = ptr.String(xtv)
			}

		case strings.EqualFold("UserGroupIds", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentUserGroupIdList(&sv.UserGroupIds, nodeDecoder); err != nil {
				return err
			}

		case strings.EqualFold("UserId", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserId = ptr.String(xtv)
			}

		case strings.EqualFold("UserName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.UserName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentPurchaseReservedCacheNodesOfferingOutput(v **PurchaseReservedCacheNodesOfferingOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *PurchaseReservedCacheNodesOfferingOutput
	if *v == nil {
		sv = &PurchaseReservedCacheNodesOfferingOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReservedCacheNode", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReservedCacheNode(&sv.ReservedCacheNode, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentRebalanceSlotsInGlobalReplicationGroupOutput(v **RebalanceSlotsInGlobalReplicationGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *RebalanceSlotsInGlobalReplicationGroupOutput
	if *v == nil {
		sv = &RebalanceSlotsInGlobalReplicationGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("GlobalReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentGlobalReplicationGroup(&sv.GlobalReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentRebootCacheClusterOutput(v **RebootCacheClusterOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *RebootCacheClusterOutput
	if *v == nil {
		sv = &RebootCacheClusterOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheCluster", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheCluster(&sv.CacheCluster, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentRemoveTagsFromResourceOutput(v **RemoveTagsFromResourceOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *RemoveTagsFromResourceOutput
	if *v == nil {
		sv = &RemoveTagsFromResourceOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("TagList", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentTagList(&sv.TagList, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentResetCacheParameterGroupOutput(v **ResetCacheParameterGroupOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *ResetCacheParameterGroupOutput
	if *v == nil {
		sv = &ResetCacheParameterGroupOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheParameterGroupName", t.Name.Local):
			val, err := decoder.Value()
			if err != nil {
				return err
			}
			if val == nil {
				break
			}
			{
				xtv := string(val)
				sv.CacheParameterGroupName = ptr.String(xtv)
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentRevokeCacheSecurityGroupIngressOutput(v **RevokeCacheSecurityGroupIngressOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *RevokeCacheSecurityGroupIngressOutput
	if *v == nil {
		sv = &RevokeCacheSecurityGroupIngressOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("CacheSecurityGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentCacheSecurityGroup(&sv.CacheSecurityGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentStartMigrationOutput(v **StartMigrationOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *StartMigrationOutput
	if *v == nil {
		sv = &StartMigrationOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentTestFailoverOutput(v **TestFailoverOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *TestFailoverOutput
	if *v == nil {
		sv = &TestFailoverOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}

func awsAwsquery_deserializeOpDocumentTestMigrationOutput(v **TestMigrationOutput, decoder smithyxml.NodeDecoder) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	var sv *TestMigrationOutput
	if *v == nil {
		sv = &TestMigrationOutput{}
	} else {
		sv = *v
	}

	for {
		t, done, err := decoder.Token()
		if err != nil {
			return err
		}
		if done {
			break
		}
		originalDecoder := decoder
		decoder = smithyxml.WrapNodeDecoder(originalDecoder.Decoder, t)
		switch {
		case strings.EqualFold("ReplicationGroup", t.Name.Local):
			nodeDecoder := smithyxml.WrapNodeDecoder(decoder.Decoder, t)
			if err := awsAwsquery_deserializeDocumentReplicationGroup(&sv.ReplicationGroup, nodeDecoder); err != nil {
				return err
			}

		default:
			// Do nothing and ignore the unexpected tag element
			err = decoder.Decoder.Skip()
			if err != nil {
				return err
			}

		}
		decoder = originalDecoder
	}
	*v = sv
	return nil
}
