// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a set of one or more game sessions in a specific fleet location. You
// can optionally filter the results by current game session status.
//
// This operation can be used in the following ways:
//
//   - To retrieve all game sessions that are currently running on all locations
//     in a fleet, provide a fleet or alias ID, with an optional status filter. This
//     approach returns all game sessions in the fleet's home Region and all remote
//     locations.
//
//   - To retrieve all game sessions that are currently running on a specific
//     fleet location, provide a fleet or alias ID and a location name, with optional
//     status filter. The location can be the fleet's home Region or any remote
//     location.
//
//   - To retrieve a specific game session, provide the game session ID. This
//     approach looks for the game session ID in all fleets that reside in the Amazon
//     Web Services Region defined in the request.
//
// Use the pagination parameters to retrieve results as a set of sequential pages.
//
// If successful, a GameSession object is returned for each game session that
// matches the request.
//
// This operation is not designed to be continually called to track game session
// status. This practice can cause you to exceed your API limit, which results in
// errors. Instead, you must configure an Amazon Simple Notification Service (SNS)
// topic to receive notifications from FlexMatch or queues. Continuously polling
// with DescribeGameSessions should only be used for games in development with low
// game session usage.
//
// Available in Amazon GameLift Local.
//
// # Learn more
//
// [Find a game session]
//
// [All APIs by task]
//
// [Find a game session]: https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find
// [All APIs by task]: https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets
func (c *Client) DescribeGameSessions(ctx context.Context, params *DescribeGameSessionsInput, optFns ...func(*Options)) (*DescribeGameSessionsOutput, error) {
	if params == nil {
		params = &DescribeGameSessionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeGameSessions", params, optFns, c.addOperationDescribeGameSessionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeGameSessionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeGameSessionsInput struct {

	// A unique identifier for the alias associated with the fleet to retrieve game
	// sessions for. You can use either the alias ID or ARN value.
	AliasId *string

	// A unique identifier for the fleet to retrieve game sessions for. You can use
	// either the fleet ID or ARN value.
	FleetId *string

	// A unique identifier for the game session to retrieve.
	GameSessionId *string

	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int32

	// A fleet location to get game sessions for. You can specify a fleet's home
	// Region or a remote location. Use the Amazon Web Services Region code format,
	// such as us-west-2 .
	Location *string

	// A token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this operation. To start at
	// the beginning of the result set, do not specify a value.
	NextToken *string

	// Game session status to filter results on. You can filter on the following
	// states: ACTIVE , TERMINATED , ACTIVATING , and TERMINATING . The last two are
	// transitory and used for only very brief periods of time.
	StatusFilter *string

	noSmithyDocumentSerde
}

type DescribeGameSessionsOutput struct {

	// A collection of properties for each game session that matches the request.
	GameSessions []types.GameSession

	// A token that indicates where to resume retrieving results on the next call to
	// this operation. If no token is returned, these results represent the end of the
	// list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeGameSessionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeGameSessions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeGameSessions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeGameSessions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeGameSessions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeGameSessionsPaginatorOptions is the paginator options for
// DescribeGameSessions
type DescribeGameSessionsPaginatorOptions struct {
	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeGameSessionsPaginator is a paginator for DescribeGameSessions
type DescribeGameSessionsPaginator struct {
	options   DescribeGameSessionsPaginatorOptions
	client    DescribeGameSessionsAPIClient
	params    *DescribeGameSessionsInput
	nextToken *string
	firstPage bool
}

// NewDescribeGameSessionsPaginator returns a new DescribeGameSessionsPaginator
func NewDescribeGameSessionsPaginator(client DescribeGameSessionsAPIClient, params *DescribeGameSessionsInput, optFns ...func(*DescribeGameSessionsPaginatorOptions)) *DescribeGameSessionsPaginator {
	if params == nil {
		params = &DescribeGameSessionsInput{}
	}

	options := DescribeGameSessionsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeGameSessionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeGameSessionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeGameSessions page.
func (p *DescribeGameSessionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeGameSessionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeGameSessions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeGameSessionsAPIClient is a client that implements the
// DescribeGameSessions operation.
type DescribeGameSessionsAPIClient interface {
	DescribeGameSessions(context.Context, *DescribeGameSessionsInput, ...func(*Options)) (*DescribeGameSessionsOutput, error)
}

var _ DescribeGameSessionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeGameSessions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeGameSessions",
	}
}
