// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Manage how Amazon GameLift Streams streams your applications by using a stream
//
// group. A stream group is a collection of resources that Amazon GameLift Streams
// uses to stream your application to end-users. When you create a stream group,
// you specify an application to stream by default and the type of hardware to use,
// such as the graphical processing unit (GPU). You can also link additional
// applications, which allows you to stream those applications using this stream
// group. Depending on your expected users, you also scale the number of concurrent
// streams you want to support at one time, and in what locations.
//
// Stream capacity represents the number of concurrent streams that can be active
// at a time. You set stream capacity per location, per stream group. There are two
// types of capacity, always-on and on-demand:
//
//   - Always-on: The streaming capacity that is allocated and ready to handle
//     stream requests without delay. You pay for this capacity whether it's in use or
//     not. Best for quickest time from streaming request to streaming session.
//
//   - On-demand: The streaming capacity that Amazon GameLift Streams can allocate
//     in response to stream requests, and then de-allocate when the session has
//     terminated. This offers a cost control measure at the expense of a greater
//     startup time (typically under 5 minutes).
//
// To adjust the capacity of any ACTIVE stream group, call [UpdateStreamGroup].
//
// If the request is successful, Amazon GameLift Streams begins creating the
// stream group. Amazon GameLift Streams assigns a unique ID to the stream group
// resource and sets the status to ACTIVATING . When the stream group reaches
// ACTIVE status, you can start stream sessions by using [StartStreamSession]. To check the stream
// group's status, call [GetStreamGroup].
//
// [GetStreamGroup]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamGroup.html
// [UpdateStreamGroup]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UpdateStreamGroup.html
// [StartStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_StartStreamSession.html
func (c *Client) CreateStreamGroup(ctx context.Context, params *CreateStreamGroupInput, optFns ...func(*Options)) (*CreateStreamGroupOutput, error) {
	if params == nil {
		params = &CreateStreamGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateStreamGroup", params, optFns, c.addOperationCreateStreamGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateStreamGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateStreamGroupInput struct {

	// A descriptive label for the stream group.
	//
	// This member is required.
	Description *string

	// The target stream quality for sessions that are hosted in this stream group.
	// Set a stream class that is appropriate to the type of content that you're
	// streaming. Stream class determines the type of computing resources Amazon
	// GameLift Streams uses and impacts the cost of streaming. The following options
	// are available:
	//
	// A stream class can be one of the following:
	//
	//   - gen5n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen5n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen5n_ultra (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen4n_ultra (NVIDIA, ultra) Supports applications with high 3D scene
	//   complexity. Uses dedicated NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	// This member is required.
	StreamClass types.StreamClass

	//  A unique identifier that represents a client request. The request is
	// idempotent, which ensures that an API request completes only once. When users
	// send a request, Amazon GameLift Streams automatically populates this field.
	ClientToken *string

	// The unique identifier of the Amazon GameLift Streams application that you want
	// to associate to a stream group as the default application. The application must
	// be in READY status. By setting the default application identifier, you will
	// optimize startup performance of this application in your stream group. Once set,
	// this application cannot be disassociated from the stream group, unlike
	// applications that are associated using AssociateApplications. If not set when
	// creating a stream group, you will need to call AssociateApplications later,
	// before you can start streaming.
	//
	// This value is an [Amazon Resource Name (ARN)] or ID that uniquely identifies the application resource.
	// Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 . Example
	// ID: a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	DefaultApplicationIdentifier *string

	//  A set of one or more locations and the streaming capacity for each location.
	LocationConfigurations []types.LocationConfiguration

	// A list of labels to assign to the new stream group resource. Tags are
	// developer-defined key-value pairs. Tagging Amazon Web Services resources is
	// useful for resource management, access management and cost allocation. See [Tagging Amazon Web Services Resources]in
	// the Amazon Web Services General Reference. You can use [TagResource]to add tags, [UntagResource] to remove
	// tags, and [ListTagsForResource]to view tags on existing resources.
	//
	// [Tagging Amazon Web Services Resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	// [TagResource]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_TagResource.html
	// [UntagResource]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_UntagResource.html
	// [ListTagsForResource]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_ListTagsForResource.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateStreamGroupOutput struct {

	// The [Amazon Resource Name (ARN)] that is assigned to the stream group resource and that uniquely identifies
	// the group across all Amazon Web Services Regions. Format is
	// arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID] .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	//  A set of applications that this stream group is associated to. You can stream
	// any of these applications by using this stream group.
	//
	// This value is a set of [Amazon Resource Names (ARNs)] that uniquely identify application resources. Example
	// ARN: arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	AssociatedApplications []string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// The default Amazon GameLift Streams application that is associated with this
	// stream group.
	DefaultApplication *types.DefaultApplication

	// A descriptive label for the stream group.
	Description *string

	// A unique ID value that is assigned to the resource when it's created. Format
	// example: sg-1AB2C3De4 .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// This value is the set of locations, including their name, current status, and
	// capacities.
	//
	// A location can be in one of the following states:
	//
	//   - ACTIVATING: Amazon GameLift Streams is preparing the location. You cannot
	//   stream from, scale the capacity of, or remove this location yet.
	//
	//   - ACTIVE: The location is provisioned with initial capacity. You can now
	//   stream from, scale the capacity of, or remove this location.
	//
	//   - ERROR: Amazon GameLift Streams failed to set up this location. The
	//   StatusReason field describes the error. You can remove this location and try to
	//   add it again.
	//
	//   - REMOVING: Amazon GameLift Streams is working to remove this location. It
	//   releases all provisioned capacity for this location in this stream group.
	LocationStates []types.LocationState

	// The current status of the stream group resource. Possible statuses include the
	// following:
	//
	//   - ACTIVATING : The stream group is deploying and isn't ready to host streams.
	//
	//   - ACTIVE : The stream group is ready to host streams.
	//
	//   - ACTIVE_WITH_ERRORS : One or more locations in the stream group are in an
	//   error state. Verify the details of individual locations and remove any locations
	//   which are in error.
	//
	//   - ERROR : An error occurred when the stream group deployed. See StatusReason
	//   for more information.
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the stream
	//   group.
	//
	//   - UPDATING_LOCATIONS : One or more locations in the stream group are in the
	//   process of updating (either activating or deleting).
	Status types.StreamGroupStatus

	//  A short description of the reason that the stream group is in ERROR status.
	// The possible reasons can be one of the following:
	//
	//   - internalError : The request can't process right now bcause of an issue with
	//   the server. Try again later. Reach out to the Amazon GameLift Streams team for
	//   more help.
	//
	//   - noAvailableInstances : Amazon GameLift Streams does not currently have
	//   enough available On-Demand capacity to fulfill your request. Wait a few minutes
	//   and retry the request as capacity can shift frequently. You can also try to make
	//   the request using a different stream class or in another region.
	StatusReason types.StreamGroupStatusReason

	// The target stream quality for the stream group.
	//
	// A stream class can be one of the following:
	//
	//   - gen5n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen5n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen5n_ultra (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen4n_ultra (NVIDIA, ultra) Supports applications with high 3D scene
	//   complexity. Uses dedicated NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	StreamClass types.StreamClass

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateStreamGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateStreamGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateStreamGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateStreamGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateStreamGroupMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateStreamGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateStreamGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateStreamGroup struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateStreamGroup) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateStreamGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateStreamGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateStreamGroupInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateStreamGroupMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateStreamGroup{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateStreamGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateStreamGroup",
	}
}
