// Code generated by smithy-go-codegen DO NOT EDIT.

package mailmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mailmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists jobs for an address list.
func (c *Client) ListAddressListImportJobs(ctx context.Context, params *ListAddressListImportJobsInput, optFns ...func(*Options)) (*ListAddressListImportJobsOutput, error) {
	if params == nil {
		params = &ListAddressListImportJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAddressListImportJobs", params, optFns, c.addOperationListAddressListImportJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAddressListImportJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAddressListImportJobsInput struct {

	// The unique identifier of the address list for listing import jobs.
	//
	// This member is required.
	AddressListId *string

	// If you received a pagination token from a previous call to this API, you can
	// provide it here to continue paginating through the next page of results.
	NextToken *string

	// The maximum number of import jobs that are returned per call. You can use
	// NextToken to retrieve the next page of jobs.
	PageSize *int32

	noSmithyDocumentSerde
}

type ListAddressListImportJobsOutput struct {

	// The list of import jobs.
	//
	// This member is required.
	ImportJobs []types.ImportJob

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAddressListImportJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListAddressListImportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListAddressListImportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAddressListImportJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAddressListImportJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAddressListImportJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAddressListImportJobsPaginatorOptions is the paginator options for
// ListAddressListImportJobs
type ListAddressListImportJobsPaginatorOptions struct {
	// The maximum number of import jobs that are returned per call. You can use
	// NextToken to retrieve the next page of jobs.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAddressListImportJobsPaginator is a paginator for ListAddressListImportJobs
type ListAddressListImportJobsPaginator struct {
	options   ListAddressListImportJobsPaginatorOptions
	client    ListAddressListImportJobsAPIClient
	params    *ListAddressListImportJobsInput
	nextToken *string
	firstPage bool
}

// NewListAddressListImportJobsPaginator returns a new
// ListAddressListImportJobsPaginator
func NewListAddressListImportJobsPaginator(client ListAddressListImportJobsAPIClient, params *ListAddressListImportJobsInput, optFns ...func(*ListAddressListImportJobsPaginatorOptions)) *ListAddressListImportJobsPaginator {
	if params == nil {
		params = &ListAddressListImportJobsInput{}
	}

	options := ListAddressListImportJobsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAddressListImportJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAddressListImportJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAddressListImportJobs page.
func (p *ListAddressListImportJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAddressListImportJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAddressListImportJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAddressListImportJobsAPIClient is a client that implements the
// ListAddressListImportJobs operation.
type ListAddressListImportJobsAPIClient interface {
	ListAddressListImportJobs(context.Context, *ListAddressListImportJobsInput, ...func(*Options)) (*ListAddressListImportJobsOutput, error)
}

var _ ListAddressListImportJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAddressListImportJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAddressListImportJobs",
	}
}
