// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Get details about a ChannelPlacementGroup.
func (c *Client) DescribeChannelPlacementGroup(ctx context.Context, params *DescribeChannelPlacementGroupInput, optFns ...func(*Options)) (*DescribeChannelPlacementGroupOutput, error) {
	if params == nil {
		params = &DescribeChannelPlacementGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeChannelPlacementGroup", params, optFns, c.addOperationDescribeChannelPlacementGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeChannelPlacementGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for DescribeChannelPlacementGroupRequest
type DescribeChannelPlacementGroupInput struct {

	// The ID of the channel placement group.
	//
	// This member is required.
	ChannelPlacementGroupId *string

	// The ID of the cluster.
	//
	// This member is required.
	ClusterId *string

	noSmithyDocumentSerde
}

// Placeholder documentation for DescribeChannelPlacementGroupResponse
type DescribeChannelPlacementGroupOutput struct {

	// The ARN of this ChannelPlacementGroup. It is automatically assigned when the
	// ChannelPlacementGroup is created.
	Arn *string

	// Used in ListChannelPlacementGroupsResult
	Channels []string

	// The ID of the Cluster that the Node belongs to.
	ClusterId *string

	// The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the
	// resource-id portion of the ARN.
	Id *string

	// The name that you specified for the ChannelPlacementGroup.
	Name *string

	// An array with one item, which is the single Node that is associated with the
	// ChannelPlacementGroup.
	Nodes []string

	// The current state of the ChannelPlacementGroup.
	State types.ChannelPlacementGroupState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeChannelPlacementGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeChannelPlacementGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeChannelPlacementGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeChannelPlacementGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeChannelPlacementGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ChannelPlacementGroupAssignedWaiterOptions are waiter options for
// ChannelPlacementGroupAssignedWaiter
type ChannelPlacementGroupAssignedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ChannelPlacementGroupAssignedWaiter will use default minimum delay of 3 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ChannelPlacementGroupAssignedWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeChannelPlacementGroupInput, *DescribeChannelPlacementGroupOutput, error) (bool, error)
}

// ChannelPlacementGroupAssignedWaiter defines the waiters for
// ChannelPlacementGroupAssigned
type ChannelPlacementGroupAssignedWaiter struct {
	client DescribeChannelPlacementGroupAPIClient

	options ChannelPlacementGroupAssignedWaiterOptions
}

// NewChannelPlacementGroupAssignedWaiter constructs a
// ChannelPlacementGroupAssignedWaiter.
func NewChannelPlacementGroupAssignedWaiter(client DescribeChannelPlacementGroupAPIClient, optFns ...func(*ChannelPlacementGroupAssignedWaiterOptions)) *ChannelPlacementGroupAssignedWaiter {
	options := ChannelPlacementGroupAssignedWaiterOptions{}
	options.MinDelay = 3 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = channelPlacementGroupAssignedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ChannelPlacementGroupAssignedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ChannelPlacementGroupAssigned waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *ChannelPlacementGroupAssignedWaiter) Wait(ctx context.Context, params *DescribeChannelPlacementGroupInput, maxWaitDur time.Duration, optFns ...func(*ChannelPlacementGroupAssignedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ChannelPlacementGroupAssigned
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *ChannelPlacementGroupAssignedWaiter) WaitForOutput(ctx context.Context, params *DescribeChannelPlacementGroupInput, maxWaitDur time.Duration, optFns ...func(*ChannelPlacementGroupAssignedWaiterOptions)) (*DescribeChannelPlacementGroupOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeChannelPlacementGroup(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ChannelPlacementGroupAssigned waiter")
}

func channelPlacementGroupAssignedStateRetryable(ctx context.Context, input *DescribeChannelPlacementGroupInput, output *DescribeChannelPlacementGroupOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.State
		expectedValue := "ASSIGNED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.State
		expectedValue := "ASSIGNING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// ChannelPlacementGroupDeletedWaiterOptions are waiter options for
// ChannelPlacementGroupDeletedWaiter
type ChannelPlacementGroupDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ChannelPlacementGroupDeletedWaiter will use default minimum delay of 5 seconds.
	// Note that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ChannelPlacementGroupDeletedWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeChannelPlacementGroupInput, *DescribeChannelPlacementGroupOutput, error) (bool, error)
}

// ChannelPlacementGroupDeletedWaiter defines the waiters for
// ChannelPlacementGroupDeleted
type ChannelPlacementGroupDeletedWaiter struct {
	client DescribeChannelPlacementGroupAPIClient

	options ChannelPlacementGroupDeletedWaiterOptions
}

// NewChannelPlacementGroupDeletedWaiter constructs a
// ChannelPlacementGroupDeletedWaiter.
func NewChannelPlacementGroupDeletedWaiter(client DescribeChannelPlacementGroupAPIClient, optFns ...func(*ChannelPlacementGroupDeletedWaiterOptions)) *ChannelPlacementGroupDeletedWaiter {
	options := ChannelPlacementGroupDeletedWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = channelPlacementGroupDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ChannelPlacementGroupDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ChannelPlacementGroupDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *ChannelPlacementGroupDeletedWaiter) Wait(ctx context.Context, params *DescribeChannelPlacementGroupInput, maxWaitDur time.Duration, optFns ...func(*ChannelPlacementGroupDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ChannelPlacementGroupDeleted waiter
// and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *ChannelPlacementGroupDeletedWaiter) WaitForOutput(ctx context.Context, params *DescribeChannelPlacementGroupInput, maxWaitDur time.Duration, optFns ...func(*ChannelPlacementGroupDeletedWaiterOptions)) (*DescribeChannelPlacementGroupOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeChannelPlacementGroup(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ChannelPlacementGroupDeleted waiter")
}

func channelPlacementGroupDeletedStateRetryable(ctx context.Context, input *DescribeChannelPlacementGroupInput, output *DescribeChannelPlacementGroupOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.State
		expectedValue := "DELETED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.State
		expectedValue := "DELETING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// ChannelPlacementGroupUnassignedWaiterOptions are waiter options for
// ChannelPlacementGroupUnassignedWaiter
type ChannelPlacementGroupUnassignedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// ChannelPlacementGroupUnassignedWaiter will use default minimum delay of 5
	// seconds. Note that MinDelay must resolve to a value lesser than or equal to the
	// MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, ChannelPlacementGroupUnassignedWaiter will use default max delay of
	// 120 seconds. Note that MaxDelay must resolve to value greater than or equal to
	// the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeChannelPlacementGroupInput, *DescribeChannelPlacementGroupOutput, error) (bool, error)
}

// ChannelPlacementGroupUnassignedWaiter defines the waiters for
// ChannelPlacementGroupUnassigned
type ChannelPlacementGroupUnassignedWaiter struct {
	client DescribeChannelPlacementGroupAPIClient

	options ChannelPlacementGroupUnassignedWaiterOptions
}

// NewChannelPlacementGroupUnassignedWaiter constructs a
// ChannelPlacementGroupUnassignedWaiter.
func NewChannelPlacementGroupUnassignedWaiter(client DescribeChannelPlacementGroupAPIClient, optFns ...func(*ChannelPlacementGroupUnassignedWaiterOptions)) *ChannelPlacementGroupUnassignedWaiter {
	options := ChannelPlacementGroupUnassignedWaiterOptions{}
	options.MinDelay = 5 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = channelPlacementGroupUnassignedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &ChannelPlacementGroupUnassignedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for ChannelPlacementGroupUnassigned waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *ChannelPlacementGroupUnassignedWaiter) Wait(ctx context.Context, params *DescribeChannelPlacementGroupInput, maxWaitDur time.Duration, optFns ...func(*ChannelPlacementGroupUnassignedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for ChannelPlacementGroupUnassigned
// waiter and returns the output of the successful operation. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *ChannelPlacementGroupUnassignedWaiter) WaitForOutput(ctx context.Context, params *DescribeChannelPlacementGroupInput, maxWaitDur time.Duration, optFns ...func(*ChannelPlacementGroupUnassignedWaiterOptions)) (*DescribeChannelPlacementGroupOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeChannelPlacementGroup(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for ChannelPlacementGroupUnassigned waiter")
}

func channelPlacementGroupUnassignedStateRetryable(ctx context.Context, input *DescribeChannelPlacementGroupInput, output *DescribeChannelPlacementGroupOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.State
		expectedValue := "UNASSIGNED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.State
		expectedValue := "UNASSIGNING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		var errorType *types.InternalServerErrorException
		if errors.As(err, &errorType) {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// DescribeChannelPlacementGroupAPIClient is a client that implements the
// DescribeChannelPlacementGroup operation.
type DescribeChannelPlacementGroupAPIClient interface {
	DescribeChannelPlacementGroup(context.Context, *DescribeChannelPlacementGroupInput, ...func(*Options)) (*DescribeChannelPlacementGroupOutput, error)
}

var _ DescribeChannelPlacementGroupAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeChannelPlacementGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeChannelPlacementGroup",
	}
}
