// Code generated by smithy-go-codegen DO NOT EDIT.

package migrationhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/migrationhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the source resource that are associated with the specified
// MigrationTaskName and ProgressUpdateStream .
func (c *Client) ListSourceResources(ctx context.Context, params *ListSourceResourcesInput, optFns ...func(*Options)) (*ListSourceResourcesOutput, error) {
	if params == nil {
		params = &ListSourceResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSourceResources", params, optFns, c.addOperationListSourceResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSourceResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSourceResourcesInput struct {

	// A unique identifier that references the migration task. Do not store
	// confidential data in this field.
	//
	// This member is required.
	MigrationTaskName *string

	// The name of the progress-update stream, which is used for access control as
	// well as a namespace for migration-task names that is implicitly linked to your
	// AWS account. The progress-update stream must uniquely identify the migration
	// tool as it is used for all updates made by the tool; however, it does not need
	// to be unique for each AWS account because it is scoped to the AWS account.
	//
	// This member is required.
	ProgressUpdateStream *string

	// The maximum number of results to include in the response. If more results exist
	// than the value that you specify here for MaxResults , the response will include
	// a token that you can use to retrieve the next set of results.
	MaxResults *int32

	// If NextToken was returned by a previous call, there are more results available.
	// The value of NextToken is a unique pagination token for each page. To retrieve
	// the next page of results, specify the NextToken value that the previous call
	// returned. Keep all other arguments unchanged. Each pagination token expires
	// after 24 hours. Using an expired pagination token will return an HTTP 400
	// InvalidToken error.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSourceResourcesOutput struct {

	// If the response includes a NextToken value, that means that there are more
	// results available. The value of NextToken is a unique pagination token for each
	// page. To retrieve the next page of results, call this API again and specify this
	// NextToken value in the request. Keep all other arguments unchanged. Each
	// pagination token expires after 24 hours. Using an expired pagination token will
	// return an HTTP 400 InvalidToken error.
	NextToken *string

	// The list of source resources.
	SourceResourceList []types.SourceResource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSourceResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListSourceResources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListSourceResources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSourceResources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListSourceResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSourceResources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSourceResourcesPaginatorOptions is the paginator options for
// ListSourceResources
type ListSourceResourcesPaginatorOptions struct {
	// The maximum number of results to include in the response. If more results exist
	// than the value that you specify here for MaxResults , the response will include
	// a token that you can use to retrieve the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSourceResourcesPaginator is a paginator for ListSourceResources
type ListSourceResourcesPaginator struct {
	options   ListSourceResourcesPaginatorOptions
	client    ListSourceResourcesAPIClient
	params    *ListSourceResourcesInput
	nextToken *string
	firstPage bool
}

// NewListSourceResourcesPaginator returns a new ListSourceResourcesPaginator
func NewListSourceResourcesPaginator(client ListSourceResourcesAPIClient, params *ListSourceResourcesInput, optFns ...func(*ListSourceResourcesPaginatorOptions)) *ListSourceResourcesPaginator {
	if params == nil {
		params = &ListSourceResourcesInput{}
	}

	options := ListSourceResourcesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSourceResourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSourceResourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSourceResources page.
func (p *ListSourceResourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSourceResourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSourceResources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSourceResourcesAPIClient is a client that implements the
// ListSourceResources operation.
type ListSourceResourcesAPIClient interface {
	ListSourceResources(context.Context, *ListSourceResourcesInput, ...func(*Options)) (*ListSourceResourcesOutput, error)
}

var _ ListSourceResourcesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSourceResources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSourceResources",
	}
}
