// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Update one or more parameters for the sequence store.
func (c *Client) UpdateSequenceStore(ctx context.Context, params *UpdateSequenceStoreInput, optFns ...func(*Options)) (*UpdateSequenceStoreOutput, error) {
	if params == nil {
		params = &UpdateSequenceStoreInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSequenceStore", params, optFns, c.addOperationUpdateSequenceStoreMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSequenceStoreOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSequenceStoreInput struct {

	// The ID of the sequence store.
	//
	// This member is required.
	Id *string

	// To ensure that requests don't run multiple times, specify a unique token for
	// each request.
	ClientToken *string

	// A description for the sequence store.
	Description *string

	// The S3 URI of a bucket and folder to store Read Sets that fail to upload.
	FallbackLocation *string

	// A name for the sequence store.
	Name *string

	// The tags keys to propagate to the S3 objects associated with read sets in the
	// sequence store.
	PropagatedSetLevelTags []string

	// S3 access configuration parameters.
	S3AccessConfig *types.S3AccessConfig

	noSmithyDocumentSerde
}

type UpdateSequenceStoreOutput struct {

	// The ARN of the sequence store.
	//
	// This member is required.
	Arn *string

	// The time when the store was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The ID of the sequence store.
	//
	// This member is required.
	Id *string

	// Description of the sequence store.
	Description *string

	// The ETag algorithm family to use on ingested read sets.
	ETagAlgorithmFamily types.ETagAlgorithmFamily

	// The S3 URI of a bucket and folder to store Read Sets that fail to upload.
	FallbackLocation *string

	// The name of the sequence store.
	Name *string

	// The tags keys to propagate to the S3 objects associated with read sets in the
	// sequence store.
	PropagatedSetLevelTags []string

	// The S3 access metadata of the sequence store.
	S3Access *types.SequenceStoreS3Access

	// Server-side encryption (SSE) settings for a store.
	SseConfig *types.SseConfig

	// The status of the sequence store.
	Status types.SequenceStoreStatus

	// The status message of the sequence store.
	StatusMessage *string

	// The last-updated time of the Sequence Store.
	UpdateTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSequenceStoreMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSequenceStore{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSequenceStore{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSequenceStore"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opUpdateSequenceStoreMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateSequenceStoreMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateSequenceStoreValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSequenceStore(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opUpdateSequenceStoreMiddleware struct {
}

func (*endpointPrefix_opUpdateSequenceStoreMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opUpdateSequenceStoreMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "control-storage-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opUpdateSequenceStoreMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opUpdateSequenceStoreMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpUpdateSequenceStore struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateSequenceStore) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateSequenceStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateSequenceStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateSequenceStoreInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateSequenceStoreMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateSequenceStore{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateSequenceStore(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSequenceStore",
	}
}
