// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables you to reassign an existing Opportunity to another user within your
// Partner Central account. The specified user receives the opportunity, and it
// appears on their Partner Central dashboard, allowing them to take necessary
// actions or proceed with the opportunity.
//
// This is useful for distributing opportunities to the appropriate team members
// or departments within your organization, ensuring that each opportunity is
// handled by the right person. By default, the opportunity owner is the one who
// creates it. Currently, there's no API to enumerate the list of available users.
func (c *Client) AssignOpportunity(ctx context.Context, params *AssignOpportunityInput, optFns ...func(*Options)) (*AssignOpportunityOutput, error) {
	if params == nil {
		params = &AssignOpportunityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssignOpportunity", params, optFns, c.addOperationAssignOpportunityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssignOpportunityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssignOpportunityInput struct {

	// Specifies the user or team member responsible for managing the assigned
	// opportunity. This field identifies the Assignee based on the partner's internal
	// team structure. Ensure that the email address is associated with a registered
	// user in your Partner Central account.
	//
	// This member is required.
	Assignee *types.AssigneeContact

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the opportunity is assigned in. Use AWS to assign real
	// opportunities in the Amazon Web Services catalog, and Sandbox for testing in
	// secure, isolated environments.
	//
	// This member is required.
	Catalog *string

	// Requires the Opportunity 's unique identifier when you want to assign it to
	// another user. Provide the correct identifier so the intended opportunity is
	// reassigned.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type AssignOpportunityOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssignOpportunityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpAssignOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpAssignOpportunity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssignOpportunity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpAssignOpportunityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssignOpportunity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAssignOpportunity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssignOpportunity",
	}
}
