// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a list of the model groups in your Amazon Web Services account.
func (c *Client) ListModelPackageGroups(ctx context.Context, params *ListModelPackageGroupsInput, optFns ...func(*Options)) (*ListModelPackageGroupsOutput, error) {
	if params == nil {
		params = &ListModelPackageGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListModelPackageGroups", params, optFns, c.addOperationListModelPackageGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListModelPackageGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListModelPackageGroupsInput struct {

	// A filter that returns only model groups created after the specified time.
	CreationTimeAfter *time.Time

	// A filter that returns only model groups created before the specified time.
	CreationTimeBefore *time.Time

	// A filter that returns either model groups shared with you or model groups in
	// your own account. When the value is CrossAccount , the results show the
	// resources made discoverable to you from other accounts. When the value is
	// SameAccount or null , the results show resources from your account. The default
	// is SameAccount .
	CrossAccountFilterOption types.CrossAccountFilterOption

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A string in the model group name. This filter returns only model groups whose
	// name contains the specified string.
	NameContains *string

	// If the result of the previous ListModelPackageGroups request was truncated, the
	// response includes a NextToken . To retrieve the next set of model groups, use
	// the token in the next request.
	NextToken *string

	// The field to sort results by. The default is CreationTime .
	SortBy types.ModelPackageGroupSortBy

	// The sort order for results. The default is Ascending .
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListModelPackageGroupsOutput struct {

	// A list of summaries of the model groups in your Amazon Web Services account.
	//
	// This member is required.
	ModelPackageGroupSummaryList []types.ModelPackageGroupSummary

	// If the response is truncated, SageMaker returns this token. To retrieve the
	// next set of model groups, use it in the subsequent request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListModelPackageGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListModelPackageGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListModelPackageGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListModelPackageGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListModelPackageGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListModelPackageGroupsPaginatorOptions is the paginator options for
// ListModelPackageGroups
type ListModelPackageGroupsPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListModelPackageGroupsPaginator is a paginator for ListModelPackageGroups
type ListModelPackageGroupsPaginator struct {
	options   ListModelPackageGroupsPaginatorOptions
	client    ListModelPackageGroupsAPIClient
	params    *ListModelPackageGroupsInput
	nextToken *string
	firstPage bool
}

// NewListModelPackageGroupsPaginator returns a new ListModelPackageGroupsPaginator
func NewListModelPackageGroupsPaginator(client ListModelPackageGroupsAPIClient, params *ListModelPackageGroupsInput, optFns ...func(*ListModelPackageGroupsPaginatorOptions)) *ListModelPackageGroupsPaginator {
	if params == nil {
		params = &ListModelPackageGroupsInput{}
	}

	options := ListModelPackageGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListModelPackageGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListModelPackageGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListModelPackageGroups page.
func (p *ListModelPackageGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListModelPackageGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListModelPackageGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListModelPackageGroupsAPIClient is a client that implements the
// ListModelPackageGroups operation.
type ListModelPackageGroupsAPIClient interface {
	ListModelPackageGroups(context.Context, *ListModelPackageGroupsInput, ...func(*Options)) (*ListModelPackageGroupsOutput, error)
}

var _ ListModelPackageGroupsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListModelPackageGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListModelPackageGroups",
	}
}
