// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this operation to get raster data collections.
func (c *Client) ListRasterDataCollections(ctx context.Context, params *ListRasterDataCollectionsInput, optFns ...func(*Options)) (*ListRasterDataCollectionsOutput, error) {
	if params == nil {
		params = &ListRasterDataCollectionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRasterDataCollections", params, optFns, c.addOperationListRasterDataCollectionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRasterDataCollectionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRasterDataCollectionsInput struct {

	// The total number of items to return.
	MaxResults *int32

	// If the previous response was truncated, you receive this token. Use it in your
	// next request to receive the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRasterDataCollectionsOutput struct {

	// Contains summary information about the raster data collection.
	//
	// This member is required.
	RasterDataCollectionSummaries []types.RasterDataCollectionMetadata

	// If the previous response was truncated, you receive this token. Use it in your
	// next request to receive the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRasterDataCollectionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRasterDataCollections{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRasterDataCollections{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRasterDataCollections"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRasterDataCollections(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListRasterDataCollectionsPaginatorOptions is the paginator options for
// ListRasterDataCollections
type ListRasterDataCollectionsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRasterDataCollectionsPaginator is a paginator for ListRasterDataCollections
type ListRasterDataCollectionsPaginator struct {
	options   ListRasterDataCollectionsPaginatorOptions
	client    ListRasterDataCollectionsAPIClient
	params    *ListRasterDataCollectionsInput
	nextToken *string
	firstPage bool
}

// NewListRasterDataCollectionsPaginator returns a new
// ListRasterDataCollectionsPaginator
func NewListRasterDataCollectionsPaginator(client ListRasterDataCollectionsAPIClient, params *ListRasterDataCollectionsInput, optFns ...func(*ListRasterDataCollectionsPaginatorOptions)) *ListRasterDataCollectionsPaginator {
	if params == nil {
		params = &ListRasterDataCollectionsInput{}
	}

	options := ListRasterDataCollectionsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRasterDataCollectionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRasterDataCollectionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRasterDataCollections page.
func (p *ListRasterDataCollectionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRasterDataCollectionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRasterDataCollections(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRasterDataCollectionsAPIClient is a client that implements the
// ListRasterDataCollections operation.
type ListRasterDataCollectionsAPIClient interface {
	ListRasterDataCollections(context.Context, *ListRasterDataCollectionsInput, ...func(*Options)) (*ListRasterDataCollectionsOutput, error)
}

var _ ListRasterDataCollectionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRasterDataCollections(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRasterDataCollections",
	}
}
