// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all subscribers for the specific Amazon Security Lake account ID. You can
// retrieve a list of subscriptions associated with a specific organization or
// Amazon Web Services account.
func (c *Client) ListSubscribers(ctx context.Context, params *ListSubscribersInput, optFns ...func(*Options)) (*ListSubscribersOutput, error) {
	if params == nil {
		params = &ListSubscribersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSubscribers", params, optFns, c.addOperationListSubscribersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSubscribersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSubscribersInput struct {

	// The maximum number of accounts for which the configuration is displayed.
	MaxResults *int32

	// If nextToken is returned, there are more results available. You can repeat the
	// call using the returned token to retrieve the next page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSubscribersOutput struct {

	// If nextToken is returned, there are more results available. You can repeat the
	// call using the returned token to retrieve the next page.
	NextToken *string

	// The subscribers available for the specified Security Lake account ID.
	Subscribers []types.SubscriberResource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSubscribersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSubscribers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSubscribers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSubscribers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSubscribers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListSubscribersPaginatorOptions is the paginator options for ListSubscribers
type ListSubscribersPaginatorOptions struct {
	// The maximum number of accounts for which the configuration is displayed.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSubscribersPaginator is a paginator for ListSubscribers
type ListSubscribersPaginator struct {
	options   ListSubscribersPaginatorOptions
	client    ListSubscribersAPIClient
	params    *ListSubscribersInput
	nextToken *string
	firstPage bool
}

// NewListSubscribersPaginator returns a new ListSubscribersPaginator
func NewListSubscribersPaginator(client ListSubscribersAPIClient, params *ListSubscribersInput, optFns ...func(*ListSubscribersPaginatorOptions)) *ListSubscribersPaginator {
	if params == nil {
		params = &ListSubscribersInput{}
	}

	options := ListSubscribersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSubscribersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSubscribersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSubscribers page.
func (p *ListSubscribersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSubscribersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSubscribers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSubscribersAPIClient is a client that implements the ListSubscribers
// operation.
type ListSubscribersAPIClient interface {
	ListSubscribers(context.Context, *ListSubscribersInput, ...func(*Options)) (*ListSubscribersOutput, error)
}

var _ ListSubscribersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSubscribers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSubscribers",
	}
}
