// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The browser settings resource that can be associated with a web portal. Once
// associated with a web portal, browser settings control how the browser will
// behave once a user starts a streaming session for the web portal.
type BrowserSettings struct {

	// The ARN of the browser settings.
	//
	// This member is required.
	BrowserSettingsArn *string

	// The additional encryption context of the browser settings.
	AdditionalEncryptionContext map[string]string

	// A list of web portal ARNs that this browser settings is associated with.
	AssociatedPortalArns []string

	// A JSON string containing Chrome Enterprise policies that will be applied to all
	// streaming sessions.
	BrowserPolicy *string

	// The customer managed key used to encrypt sensitive information in the browser
	// settings.
	CustomerManagedKey *string

	noSmithyDocumentSerde
}

// The summary for browser settings.
type BrowserSettingsSummary struct {

	// The ARN of the browser settings.
	//
	// This member is required.
	BrowserSettingsArn *string

	noSmithyDocumentSerde
}

// The certificate.
type Certificate struct {

	// The body of the certificate.
	Body []byte

	// The entity that issued the certificate.
	Issuer *string

	// The certificate is not valid after this date.
	NotValidAfter *time.Time

	// The certificate is not valid before this date.
	NotValidBefore *time.Time

	// The entity the certificate belongs to.
	Subject *string

	// A hexadecimal identifier for the certificate.
	Thumbprint *string

	noSmithyDocumentSerde
}

// The summary of the certificate.
type CertificateSummary struct {

	// The entity that issued the certificate.
	Issuer *string

	// The certificate is not valid after this date.
	NotValidAfter *time.Time

	// The certificate is not valid before this date.
	NotValidBefore *time.Time

	// The entity the certificate belongs to.
	Subject *string

	// A hexadecimal identifier for the certificate.
	Thumbprint *string

	noSmithyDocumentSerde
}

// Specifies a single cookie or set of cookies in an end user's browser.
type CookieSpecification struct {

	// The domain of the cookie.
	//
	// This member is required.
	Domain *string

	// The name of the cookie.
	Name *string

	// The path of the cookie.
	Path *string

	noSmithyDocumentSerde
}

// The configuration that specifies which cookies should be synchronized from the
// end user's local browser to the remote browser.
type CookieSynchronizationConfiguration struct {

	// The list of cookie specifications that are allowed to be synchronized to the
	// remote browser.
	//
	// This member is required.
	Allowlist []CookieSpecification

	// The list of cookie specifications that are blocked from being synchronized to
	// the remote browser.
	Blocklist []CookieSpecification

	noSmithyDocumentSerde
}

// The pattern configuration for redacting custom data types in session.
type CustomPattern struct {

	// The pattern name for the custom pattern.
	//
	// This member is required.
	PatternName *string

	// The pattern regex for the customer pattern. The format must follow JavaScript
	// regex format. The pattern must be enclosed between slashes, and can have flags
	// behind the second slash. For example: “/ab+c/gi”.
	//
	// This member is required.
	PatternRegex *string

	// The keyword regex for the customer pattern. After there is a match to the
	// pattern regex, the keyword regex is used to search within the proximity of the
	// match. If there is a keyword match, then the match is confirmed. If no keyword
	// regex is provided, the pattern regex match will automatically be confirmed. The
	// format must follow JavaScript regex format. The pattern must be enclosed between
	// slashes, and can have flags behind the second slash. For example, “/ab+c/gi”
	KeywordRegex *string

	// The pattern description for the customer pattern.
	PatternDescription *string

	noSmithyDocumentSerde
}

// The data protection settings resource that can be associated with a web portal.
type DataProtectionSettings struct {

	// The ARN of the data protection settings resource.
	//
	// This member is required.
	DataProtectionSettingsArn *string

	// The additional encryption context of the data protection settings.
	AdditionalEncryptionContext map[string]string

	// A list of web portal ARNs that this data protection settings resource is
	// associated with.
	AssociatedPortalArns []string

	// The creation date timestamp of the data protection settings.
	CreationDate *time.Time

	// The customer managed key used to encrypt sensitive information in the data
	// protection settings.
	CustomerManagedKey *string

	// The description of the data protection settings.
	Description *string

	// The display name of the data protection settings.
	DisplayName *string

	// The inline redaction configuration for the data protection settings.
	InlineRedactionConfiguration *InlineRedactionConfiguration

	noSmithyDocumentSerde
}

// The summary of the data protection settings.
type DataProtectionSettingsSummary struct {

	// The ARN of the data protection settings.
	//
	// This member is required.
	DataProtectionSettingsArn *string

	// The creation date timestamp of the data protection settings.
	CreationDate *time.Time

	// The description of the data protection settings.
	Description *string

	// The display name of the data protection settings.
	DisplayName *string

	noSmithyDocumentSerde
}

// The identity provider.
type IdentityProvider struct {

	// The ARN of the identity provider.
	//
	// This member is required.
	IdentityProviderArn *string

	// The identity provider details. The following list describes the provider detail
	// keys for each identity provider type.
	//
	//   - For Google and Login with Amazon:
	//
	//   - client_id
	//
	//   - client_secret
	//
	//   - authorize_scopes
	//
	//   - For Facebook:
	//
	//   - client_id
	//
	//   - client_secret
	//
	//   - authorize_scopes
	//
	//   - api_version
	//
	//   - For Sign in with Apple:
	//
	//   - client_id
	//
	//   - team_id
	//
	//   - key_id
	//
	//   - private_key
	//
	//   - authorize_scopes
	//
	//   - For OIDC providers:
	//
	//   - client_id
	//
	//   - client_secret
	//
	//   - attributes_request_method
	//
	//   - oidc_issuer
	//
	//   - authorize_scopes
	//
	//   - authorize_url if not available from discovery URL specified by oidc_issuer
	//   key
	//
	//   - token_url if not available from discovery URL specified by oidc_issuer key
	//
	//   - attributes_url if not available from discovery URL specified by oidc_issuer
	//   key
	//
	//   - jwks_uri if not available from discovery URL specified by oidc_issuer key
	//
	//   - For SAML providers:
	//
	//   - MetadataFile OR MetadataURL
	//
	//   - IDPSignout (boolean) optional
	//
	//   - IDPInit (boolean) optional
	//
	//   - RequestSigningAlgorithm (string) optional - Only accepts rsa-sha256
	//
	//   - EncryptedResponses (boolean) optional
	IdentityProviderDetails map[string]string

	// The identity provider name.
	IdentityProviderName *string

	// The identity provider type.
	IdentityProviderType IdentityProviderType

	noSmithyDocumentSerde
}

// The summary of the identity provider.
type IdentityProviderSummary struct {

	// The ARN of the identity provider.
	//
	// This member is required.
	IdentityProviderArn *string

	// The identity provider name.
	IdentityProviderName *string

	// The identity provider type.
	IdentityProviderType IdentityProviderType

	noSmithyDocumentSerde
}

// The configuration for in-session inline redaction.
type InlineRedactionConfiguration struct {

	// The inline redaction patterns to be enabled for the inline redaction
	// configuration.
	//
	// This member is required.
	InlineRedactionPatterns []InlineRedactionPattern

	// The global confidence level for the inline redaction configuration. This
	// indicates the certainty of data type matches in the redaction process.
	// Confidence level 3 means high confidence, and requires a formatted text pattern
	// match in order for content to be redacted. Confidence level 2 means medium
	// confidence, and redaction considers both formatted and unformatted text, and
	// adds keyword associate to the logic. Confidence level 1 means low confidence,
	// and redaction is enforced for both formatted pattern + unformatted pattern
	// without keyword. This is applied to patterns that do not have a pattern-level
	// confidence level. Defaults to confidence level 2.
	GlobalConfidenceLevel *int32

	// The global enforced URL configuration for the inline redaction configuration.
	// This is applied to patterns that do not have a pattern-level enforced URL list.
	GlobalEnforcedUrls []string

	// The global exempt URL configuration for the inline redaction configuration.
	// This is applied to patterns that do not have a pattern-level exempt URL list.
	GlobalExemptUrls []string

	noSmithyDocumentSerde
}

// The set of patterns that determine the data types redacted in session.
type InlineRedactionPattern struct {

	// The redaction placeholder that will replace the redacted text in session for
	// the inline redaction pattern.
	//
	// This member is required.
	RedactionPlaceHolder *RedactionPlaceHolder

	// The built-in pattern from the list of preconfigured patterns. Either a
	// customPattern or builtInPatternId is required.
	BuiltInPatternId *string

	// The confidence level for inline redaction pattern. This indicates the certainty
	// of data type matches in the redaction process. Confidence level 3 means high
	// confidence, and requires a formatted text pattern match in order for content to
	// be redacted. Confidence level 2 means medium confidence, and redaction considers
	// both formatted and unformatted text, and adds keyword associate to the logic.
	// Confidence level 1 means low confidence, and redaction is enforced for both
	// formatted pattern + unformatted pattern without keyword. This overrides the
	// global confidence level.
	ConfidenceLevel *int32

	// >The configuration for a custom pattern. Either a customPattern or
	// builtInPatternId is required.
	CustomPattern *CustomPattern

	// The enforced URL configuration for the inline redaction pattern. This will
	// override the global enforced URL configuration.
	EnforcedUrls []string

	// The exempt URL configuration for the inline redaction pattern. This will
	// override the global exempt URL configuration for the inline redaction pattern.
	ExemptUrls []string

	noSmithyDocumentSerde
}

// The IP access settings resource that can be associated with a web portal.
type IpAccessSettings struct {

	// The ARN of the IP access settings resource.
	//
	// This member is required.
	IpAccessSettingsArn *string

	// The additional encryption context of the IP access settings.
	AdditionalEncryptionContext map[string]string

	// A list of web portal ARNs that this IP access settings resource is associated
	// with.
	AssociatedPortalArns []string

	// The creation date timestamp of the IP access settings.
	CreationDate *time.Time

	// The customer managed key used to encrypt sensitive information in the IP access
	// settings.
	CustomerManagedKey *string

	// The description of the IP access settings.
	Description *string

	//  The display name of the IP access settings.
	DisplayName *string

	// The IP rules of the IP access settings.
	IpRules []IpRule

	noSmithyDocumentSerde
}

// The summary of IP access settings.
type IpAccessSettingsSummary struct {

	// The ARN of IP access settings.
	//
	// This member is required.
	IpAccessSettingsArn *string

	// The creation date timestamp of the IP access settings.
	CreationDate *time.Time

	// The description of the IP access settings.
	Description *string

	// The display name of the IP access settings.
	DisplayName *string

	noSmithyDocumentSerde
}

// The IP rules of the IP access settings.
type IpRule struct {

	// The IP range of the IP rule.
	//
	// This member is required.
	IpRange *string

	// The description of the IP rule.
	Description *string

	noSmithyDocumentSerde
}

// A network settings resource that can be associated with a web portal. Once
// associated with a web portal, network settings define how streaming instances
// will connect with your specified VPC.
type NetworkSettings struct {

	// The ARN of the network settings.
	//
	// This member is required.
	NetworkSettingsArn *string

	// A list of web portal ARNs that this network settings is associated with.
	AssociatedPortalArns []string

	// One or more security groups used to control access from streaming instances to
	// your VPC.
	SecurityGroupIds []string

	// The subnets in which network interfaces are created to connect streaming
	// instances to your VPC. At least two of these subnets must be in different
	// availability zones.
	SubnetIds []string

	// The VPC that streaming instances will connect to.
	VpcId *string

	noSmithyDocumentSerde
}

// The summary of network settings.
type NetworkSettingsSummary struct {

	// The ARN of the network settings.
	//
	// This member is required.
	NetworkSettingsArn *string

	// The VPC ID of the network settings.
	VpcId *string

	noSmithyDocumentSerde
}

// The web portal.
type Portal struct {

	// The ARN of the web portal.
	//
	// This member is required.
	PortalArn *string

	// The additional encryption context of the portal.
	AdditionalEncryptionContext map[string]string

	// The type of authentication integration points used when signing into the web
	// portal. Defaults to Standard .
	//
	// Standard web portals are authenticated directly through your identity provider.
	// You need to call CreateIdentityProvider to integrate your identity provider
	// with your web portal. User and group access to your web portal is controlled
	// through your identity provider.
	//
	// IAM Identity Center web portals are authenticated through IAM Identity Center.
	// Identity sources (including external identity provider integration), plus user
	// and group access to your web portal, can be configured in the IAM Identity
	// Center.
	AuthenticationType AuthenticationType

	// The ARN of the browser settings that is associated with this web portal.
	BrowserSettingsArn *string

	// The browser that users see when using a streaming session.
	BrowserType BrowserType

	// The creation date of the web portal.
	CreationDate *time.Time

	// The customer managed key used to encrypt sensitive information in the portal.
	CustomerManagedKey *string

	// The ARN of the data protection settings.
	DataProtectionSettingsArn *string

	// The name of the web portal.
	DisplayName *string

	// The type and resources of the underlying instance.
	InstanceType InstanceType

	// The ARN of the IP access settings.
	IpAccessSettingsArn *string

	// The maximum number of concurrent sessions for the portal.
	MaxConcurrentSessions *int32

	// The ARN of the network settings that is associated with the web portal.
	NetworkSettingsArn *string

	// The endpoint URL of the web portal that users access in order to start
	// streaming sessions.
	PortalEndpoint *string

	// The status of the web portal.
	PortalStatus PortalStatus

	// The renderer that is used in streaming sessions.
	RendererType RendererType

	// A message that explains why the web portal is in its current status.
	StatusReason *string

	// The ARN of the trust store that is associated with the web portal.
	TrustStoreArn *string

	// The ARN of the user access logging settings that is associated with the web
	// portal.
	UserAccessLoggingSettingsArn *string

	// The ARN of the user settings that is associated with the web portal.
	UserSettingsArn *string

	noSmithyDocumentSerde
}

// The summary of the portal.
type PortalSummary struct {

	// The ARN of the web portal.
	//
	// This member is required.
	PortalArn *string

	// The type of authentication integration points used when signing into the web
	// portal. Defaults to Standard .
	//
	// Standard web portals are authenticated directly through your identity provider.
	// You need to call CreateIdentityProvider to integrate your identity provider
	// with your web portal. User and group access to your web portal is controlled
	// through your identity provider.
	//
	// IAM Identity Center web portals are authenticated through IAM Identity Center.
	// Identity sources (including external identity provider integration), plus user
	// and group access to your web portal, can be configured in the IAM Identity
	// Center.
	AuthenticationType AuthenticationType

	// The ARN of the browser settings that is associated with the web portal.
	BrowserSettingsArn *string

	// The browser type of the web portal.
	BrowserType BrowserType

	// The creation date of the web portal.
	CreationDate *time.Time

	// The ARN of the data protection settings.
	DataProtectionSettingsArn *string

	// The name of the web portal.
	DisplayName *string

	// The type and resources of the underlying instance.
	InstanceType InstanceType

	// The ARN of the IP access settings.
	IpAccessSettingsArn *string

	// The maximum number of concurrent sessions for the portal.
	MaxConcurrentSessions *int32

	// The ARN of the network settings that is associated with the web portal.
	NetworkSettingsArn *string

	// The endpoint URL of the web portal that users access in order to start
	// streaming sessions.
	PortalEndpoint *string

	// The status of the web portal.
	PortalStatus PortalStatus

	// The renderer that is used in streaming sessions.
	RendererType RendererType

	// The ARN of the trust that is associated with this web portal.
	TrustStoreArn *string

	// The ARN of the user access logging settings that is associated with the web
	// portal.
	UserAccessLoggingSettingsArn *string

	// The ARN of the user settings that is associated with the web portal.
	UserSettingsArn *string

	noSmithyDocumentSerde
}

// The redaction placeholder that will replace the redacted text in session.
type RedactionPlaceHolder struct {

	// The redaction placeholder type that will replace the redacted text in session.
	//
	// This member is required.
	RedactionPlaceHolderType RedactionPlaceHolderType

	// The redaction placeholder text that will replace the redacted text in session
	// for the custom text redaction placeholder type.
	RedactionPlaceHolderText *string

	noSmithyDocumentSerde
}

// Information about a secure browser session.
type Session struct {

	// The IP address of the client.
	ClientIpAddresses []string

	// The end time of the session.
	EndTime *time.Time

	// The ARN of the web portal.
	PortalArn *string

	// The ID of the session.
	SessionId *string

	// The start time of the session.
	StartTime *time.Time

	// The status of the session.
	Status SessionStatus

	// The username of the session.
	Username *string

	noSmithyDocumentSerde
}

// Summary information about a secure browser session.
type SessionSummary struct {

	// The end time of the session.
	EndTime *time.Time

	// The ARN of the web portal.
	PortalArn *string

	// The ID of the session.
	SessionId *string

	// The start time of the session.
	StartTime *time.Time

	// The status of the session.
	Status SessionStatus

	// The username of the session.
	Username *string

	noSmithyDocumentSerde
}

// The tag.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The configuration of the toolbar. This allows administrators to select the
// toolbar type and visual mode, set maximum display resolution for sessions, and
// choose which items are visible to end users during their sessions. If
// administrators do not modify these settings, end users retain control over their
// toolbar preferences.
type ToolbarConfiguration struct {

	// The list of toolbar items to be hidden.
	HiddenToolbarItems []ToolbarItem

	// The maximum display resolution that is allowed for the session.
	MaxDisplayResolution MaxDisplayResolution

	// The type of toolbar displayed during the session.
	ToolbarType ToolbarType

	// The visual mode of the toolbar.
	VisualMode VisualMode

	noSmithyDocumentSerde
}

// A trust store that can be associated with a web portal. A trust store contains
// certificate authority (CA) certificates. Once associated with a web portal, the
// browser in a streaming session will recognize certificates that have been issued
// using any of the CAs in the trust store. If your organization has internal
// websites that use certificates issued by private CAs, you should add the private
// CA certificate to the trust store.
type TrustStore struct {

	// The ARN of the trust store.
	//
	// This member is required.
	TrustStoreArn *string

	// A list of web portal ARNs that this trust store is associated with.
	AssociatedPortalArns []string

	noSmithyDocumentSerde
}

// The summary of the trust store.
type TrustStoreSummary struct {

	// The ARN of the trust store.
	TrustStoreArn *string

	noSmithyDocumentSerde
}

// A user access logging settings resource that can be associated with a web
// portal.
type UserAccessLoggingSettings struct {

	// The ARN of the user access logging settings.
	//
	// This member is required.
	UserAccessLoggingSettingsArn *string

	// A list of web portal ARNs that this user access logging settings is associated
	// with.
	AssociatedPortalArns []string

	// The ARN of the Kinesis stream.
	KinesisStreamArn *string

	noSmithyDocumentSerde
}

// The summary of user access logging settings.
type UserAccessLoggingSettingsSummary struct {

	// The ARN of the user access logging settings.
	//
	// This member is required.
	UserAccessLoggingSettingsArn *string

	// The ARN of the Kinesis stream.
	KinesisStreamArn *string

	noSmithyDocumentSerde
}

// A user settings resource that can be associated with a web portal. Once
// associated with a web portal, user settings control how users can transfer data
// between a streaming session and the their local devices.
type UserSettings struct {

	// The ARN of the user settings.
	//
	// This member is required.
	UserSettingsArn *string

	// The additional encryption context of the user settings.
	AdditionalEncryptionContext map[string]string

	// A list of web portal ARNs that this user settings is associated with.
	AssociatedPortalArns []string

	// The configuration that specifies which cookies should be synchronized from the
	// end user's local browser to the remote browser.
	CookieSynchronizationConfiguration *CookieSynchronizationConfiguration

	// Specifies whether the user can copy text from the streaming session to the
	// local device.
	CopyAllowed EnabledType

	// The customer managed key used to encrypt sensitive information in the user
	// settings.
	CustomerManagedKey *string

	// Specifies whether the user can use deep links that open automatically when
	// connecting to a session.
	DeepLinkAllowed EnabledType

	// The amount of time that a streaming session remains active after users
	// disconnect.
	DisconnectTimeoutInMinutes *int32

	// Specifies whether the user can download files from the streaming session to the
	// local device.
	DownloadAllowed EnabledType

	// The amount of time that users can be idle (inactive) before they are
	// disconnected from their streaming session and the disconnect timeout interval
	// begins.
	IdleDisconnectTimeoutInMinutes *int32

	// Specifies whether the user can paste text from the local device to the
	// streaming session.
	PasteAllowed EnabledType

	// Specifies whether the user can print to the local device.
	PrintAllowed EnabledType

	// The configuration of the toolbar. This allows administrators to select the
	// toolbar type and visual mode, set maximum display resolution for sessions, and
	// choose which items are visible to end users during their sessions. If
	// administrators do not modify these settings, end users retain control over their
	// toolbar preferences.
	ToolbarConfiguration *ToolbarConfiguration

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed EnabledType

	noSmithyDocumentSerde
}

// The summary of user settings.
type UserSettingsSummary struct {

	// The ARN of the user settings.
	//
	// This member is required.
	UserSettingsArn *string

	// The configuration that specifies which cookies should be synchronized from the
	// end user's local browser to the remote browser.
	CookieSynchronizationConfiguration *CookieSynchronizationConfiguration

	// Specifies whether the user can copy text from the streaming session to the
	// local device.
	CopyAllowed EnabledType

	// Specifies whether the user can use deep links that open automatically when
	// connecting to a session.
	DeepLinkAllowed EnabledType

	// The amount of time that a streaming session remains active after users
	// disconnect.
	DisconnectTimeoutInMinutes *int32

	// Specifies whether the user can download files from the streaming session to the
	// local device.
	DownloadAllowed EnabledType

	// The amount of time that users can be idle (inactive) before they are
	// disconnected from their streaming session and the disconnect timeout interval
	// begins.
	IdleDisconnectTimeoutInMinutes *int32

	// Specifies whether the user can paste text from the local device to the
	// streaming session.
	PasteAllowed EnabledType

	// Specifies whether the user can print to the local device.
	PrintAllowed EnabledType

	// The configuration of the toolbar. This allows administrators to select the
	// toolbar type and visual mode, set maximum display resolution for sessions, and
	// choose which items are visible to end users during their sessions. If
	// administrators do not modify these settings, end users retain control over their
	// toolbar preferences.
	ToolbarConfiguration *ToolbarConfiguration

	// Specifies whether the user can upload files from the local device to the
	// streaming session.
	UploadAllowed EnabledType

	noSmithyDocumentSerde
}

// Information about a field passed inside a request that resulted in an exception.
type ValidationExceptionField struct {

	// The message describing why the field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
