// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a flow. For more information, see [Manage a flow in Amazon Bedrock] in the Amazon
// Bedrock User Guide.
//
// [Manage a flow in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-manage.html
func (c *Client) GetFlow(ctx context.Context, params *GetFlowInput, optFns ...func(*Options)) (*GetFlowOutput, error) {
	if params == nil {
		params = &GetFlowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFlow", params, optFns, c.addOperationGetFlowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFlowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFlowInput struct {

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowIdentifier *string

	noSmithyDocumentSerde
}

type GetFlowOutput struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	Arn *string

	// The time at which the flow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service role with permissions to create a
	// flow. For more information, see [Create a service row for flows]in the Amazon Bedrock User Guide.
	//
	// [Create a service row for flows]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html
	//
	// This member is required.
	ExecutionRoleArn *string

	// The unique identifier of the flow.
	//
	// This member is required.
	Id *string

	// The name of the flow.
	//
	// This member is required.
	Name *string

	// The status of the flow. The following statuses are possible:
	//
	//   - NotPrepared – The flow has been created or updated, but hasn't been
	//   prepared. If you just created the flow, you can't test it. If you updated the
	//   flow, the DRAFT version won't contain the latest changes for testing. Send a [PrepareFlow]
	//   request to package the latest changes into the DRAFT version.
	//
	//   - Preparing – The flow is being prepared so that the DRAFT version contains
	//   the latest changes for testing.
	//
	//   - Prepared – The flow is prepared and the DRAFT version contains the latest
	//   changes for testing.
	//
	//   - Failed – The last API operation that you invoked on the flow failed. Send a [GetFlow]
	//   request and check the error message in the validations field.
	//
	// [PrepareFlow]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html
	// [GetFlow]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html
	//
	// This member is required.
	Status types.FlowStatus

	// The time at which the flow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the flow for which information was retrieved.
	//
	// This member is required.
	Version *string

	// The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
	CustomerEncryptionKeyArn *string

	// The definition of the nodes and connections between the nodes in the flow.
	Definition *types.FlowDefinition

	// The description of the flow.
	Description *string

	// A list of validation error messages related to the last failed operation on the
	// flow.
	Validations []types.FlowValidation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFlowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFlow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFlow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFlow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetFlowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFlow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFlow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFlow",
	}
}
