// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/location/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAssociateTrackerConsumer struct {
}

func (*awsRestjson1_serializeOpAssociateTrackerConsumer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateTrackerConsumer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateTrackerConsumerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/consumers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateTrackerConsumerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateTrackerConsumerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateTrackerConsumerInput(v *AssociateTrackerConsumerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateTrackerConsumerInput(v *AssociateTrackerConsumerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConsumerArn != nil {
		ok := object.Key("ConsumerArn")
		ok.String(*v.ConsumerArn)
	}

	return nil
}

type awsRestjson1_serializeOpBatchDeleteDevicePositionHistory struct {
}

func (*awsRestjson1_serializeOpBatchDeleteDevicePositionHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteDevicePositionHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteDevicePositionHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/delete-positions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteDevicePositionHistoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteDevicePositionHistoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteDevicePositionHistoryInput(v *BatchDeleteDevicePositionHistoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteDevicePositionHistoryInput(v *BatchDeleteDevicePositionHistoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceIds != nil {
		ok := object.Key("DeviceIds")
		if err := awsRestjson1_serializeDocumentDeviceIdsList(v.DeviceIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDeleteGeofence struct {
}

func (*awsRestjson1_serializeOpBatchDeleteGeofence) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteGeofence) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteGeofenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/delete-geofences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteGeofenceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteGeofenceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteGeofenceInput(v *BatchDeleteGeofenceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteGeofenceInput(v *BatchDeleteGeofenceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GeofenceIds != nil {
		ok := object.Key("GeofenceIds")
		if err := awsRestjson1_serializeDocumentIdList(v.GeofenceIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchEvaluateGeofences struct {
}

func (*awsRestjson1_serializeOpBatchEvaluateGeofences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchEvaluateGeofences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchEvaluateGeofencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/positions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchEvaluateGeofencesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchEvaluateGeofencesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchEvaluateGeofencesInput(v *BatchEvaluateGeofencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchEvaluateGeofencesInput(v *BatchEvaluateGeofencesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DevicePositionUpdates != nil {
		ok := object.Key("DevicePositionUpdates")
		if err := awsRestjson1_serializeDocumentDevicePositionUpdateList(v.DevicePositionUpdates, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchGetDevicePosition struct {
}

func (*awsRestjson1_serializeOpBatchGetDevicePosition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchGetDevicePosition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchGetDevicePositionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/get-positions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchGetDevicePositionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchGetDevicePositionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchGetDevicePositionInput(v *BatchGetDevicePositionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchGetDevicePositionInput(v *BatchGetDevicePositionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceIds != nil {
		ok := object.Key("DeviceIds")
		if err := awsRestjson1_serializeDocumentIdList(v.DeviceIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchPutGeofence struct {
}

func (*awsRestjson1_serializeOpBatchPutGeofence) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchPutGeofence) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutGeofenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/put-geofences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchPutGeofenceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchPutGeofenceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchPutGeofenceInput(v *BatchPutGeofenceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchPutGeofenceInput(v *BatchPutGeofenceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entries != nil {
		ok := object.Key("Entries")
		if err := awsRestjson1_serializeDocumentBatchPutGeofenceRequestEntryList(v.Entries, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpdateDevicePosition struct {
}

func (*awsRestjson1_serializeOpBatchUpdateDevicePosition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpdateDevicePosition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateDevicePositionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/positions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchUpdateDevicePositionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpdateDevicePositionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpdateDevicePositionInput(v *BatchUpdateDevicePositionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpdateDevicePositionInput(v *BatchUpdateDevicePositionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Updates != nil {
		ok := object.Key("Updates")
		if err := awsRestjson1_serializeDocumentDevicePositionUpdateList(v.Updates, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCalculateRoute struct {
}

func (*awsRestjson1_serializeOpCalculateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCalculateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CalculateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/calculators/{CalculatorName}/calculate/route")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCalculateRouteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCalculateRouteInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCalculateRouteInput(v *CalculateRouteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CalculatorName == nil || len(*v.CalculatorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CalculatorName must not be empty")}
	}
	if v.CalculatorName != nil {
		if err := encoder.SetURI("CalculatorName").String(*v.CalculatorName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCalculateRouteInput(v *CalculateRouteInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArrivalTime != nil {
		ok := object.Key("ArrivalTime")
		ok.String(smithytime.FormatDateTime(*v.ArrivalTime))
	}

	if v.CarModeOptions != nil {
		ok := object.Key("CarModeOptions")
		if err := awsRestjson1_serializeDocumentCalculateRouteCarModeOptions(v.CarModeOptions, ok); err != nil {
			return err
		}
	}

	if v.DepartNow != nil {
		ok := object.Key("DepartNow")
		ok.Boolean(*v.DepartNow)
	}

	if v.DeparturePosition != nil {
		ok := object.Key("DeparturePosition")
		if err := awsRestjson1_serializeDocumentPosition(v.DeparturePosition, ok); err != nil {
			return err
		}
	}

	if v.DepartureTime != nil {
		ok := object.Key("DepartureTime")
		ok.String(smithytime.FormatDateTime(*v.DepartureTime))
	}

	if v.DestinationPosition != nil {
		ok := object.Key("DestinationPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.DestinationPosition, ok); err != nil {
			return err
		}
	}

	if len(v.DistanceUnit) > 0 {
		ok := object.Key("DistanceUnit")
		ok.String(string(v.DistanceUnit))
	}

	if v.IncludeLegGeometry != nil {
		ok := object.Key("IncludeLegGeometry")
		ok.Boolean(*v.IncludeLegGeometry)
	}

	if len(v.OptimizeFor) > 0 {
		ok := object.Key("OptimizeFor")
		ok.String(string(v.OptimizeFor))
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TruckModeOptions != nil {
		ok := object.Key("TruckModeOptions")
		if err := awsRestjson1_serializeDocumentCalculateRouteTruckModeOptions(v.TruckModeOptions, ok); err != nil {
			return err
		}
	}

	if v.WaypointPositions != nil {
		ok := object.Key("WaypointPositions")
		if err := awsRestjson1_serializeDocumentWaypointPositionList(v.WaypointPositions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCalculateRouteMatrix struct {
}

func (*awsRestjson1_serializeOpCalculateRouteMatrix) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCalculateRouteMatrix) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CalculateRouteMatrixInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/calculators/{CalculatorName}/calculate/route-matrix")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCalculateRouteMatrixInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCalculateRouteMatrixInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCalculateRouteMatrixInput(v *CalculateRouteMatrixInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CalculatorName == nil || len(*v.CalculatorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CalculatorName must not be empty")}
	}
	if v.CalculatorName != nil {
		if err := encoder.SetURI("CalculatorName").String(*v.CalculatorName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCalculateRouteMatrixInput(v *CalculateRouteMatrixInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CarModeOptions != nil {
		ok := object.Key("CarModeOptions")
		if err := awsRestjson1_serializeDocumentCalculateRouteCarModeOptions(v.CarModeOptions, ok); err != nil {
			return err
		}
	}

	if v.DepartNow != nil {
		ok := object.Key("DepartNow")
		ok.Boolean(*v.DepartNow)
	}

	if v.DeparturePositions != nil {
		ok := object.Key("DeparturePositions")
		if err := awsRestjson1_serializeDocumentPositionList(v.DeparturePositions, ok); err != nil {
			return err
		}
	}

	if v.DepartureTime != nil {
		ok := object.Key("DepartureTime")
		ok.String(smithytime.FormatDateTime(*v.DepartureTime))
	}

	if v.DestinationPositions != nil {
		ok := object.Key("DestinationPositions")
		if err := awsRestjson1_serializeDocumentPositionList(v.DestinationPositions, ok); err != nil {
			return err
		}
	}

	if len(v.DistanceUnit) > 0 {
		ok := object.Key("DistanceUnit")
		ok.String(string(v.DistanceUnit))
	}

	if len(v.TravelMode) > 0 {
		ok := object.Key("TravelMode")
		ok.String(string(v.TravelMode))
	}

	if v.TruckModeOptions != nil {
		ok := object.Key("TruckModeOptions")
		if err := awsRestjson1_serializeDocumentCalculateRouteTruckModeOptions(v.TruckModeOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGeofenceCollection struct {
}

func (*awsRestjson1_serializeOpCreateGeofenceCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGeofenceCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGeofenceCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGeofenceCollectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGeofenceCollectionInput(v *CreateGeofenceCollectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGeofenceCollectionInput(v *CreateGeofenceCollectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollectionName != nil {
		ok := object.Key("CollectionName")
		ok.String(*v.CollectionName)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.PricingPlanDataSource != nil {
		ok := object.Key("PricingPlanDataSource")
		ok.String(*v.PricingPlanDataSource)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateKey struct {
}

func (*awsRestjson1_serializeOpCreateKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metadata/v0/keys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateKeyInput(v *CreateKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateKeyInput(v *CreateKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.ExpireTime != nil {
		ok := object.Key("ExpireTime")
		ok.String(smithytime.FormatDateTime(*v.ExpireTime))
	}

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.NoExpiry != nil {
		ok := object.Key("NoExpiry")
		ok.Boolean(*v.NoExpiry)
	}

	if v.Restrictions != nil {
		ok := object.Key("Restrictions")
		if err := awsRestjson1_serializeDocumentApiKeyRestrictions(v.Restrictions, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMap struct {
}

func (*awsRestjson1_serializeOpCreateMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMapInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMapInput(v *CreateMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMapInput(v *CreateMapInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("Configuration")
		if err := awsRestjson1_serializeDocumentMapConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.MapName != nil {
		ok := object.Key("MapName")
		ok.String(*v.MapName)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePlaceIndex struct {
}

func (*awsRestjson1_serializeOpCreatePlaceIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePlaceIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePlaceIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePlaceIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePlaceIndexInput(v *CreatePlaceIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePlaceIndexInput(v *CreatePlaceIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		ok.String(*v.DataSource)
	}

	if v.DataSourceConfiguration != nil {
		ok := object.Key("DataSourceConfiguration")
		if err := awsRestjson1_serializeDocumentDataSourceConfiguration(v.DataSourceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.IndexName != nil {
		ok := object.Key("IndexName")
		ok.String(*v.IndexName)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateRouteCalculator struct {
}

func (*awsRestjson1_serializeOpCreateRouteCalculator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRouteCalculator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteCalculatorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/calculators")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRouteCalculatorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRouteCalculatorInput(v *CreateRouteCalculatorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRouteCalculatorInput(v *CreateRouteCalculatorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CalculatorName != nil {
		ok := object.Key("CalculatorName")
		ok.String(*v.CalculatorName)
	}

	if v.DataSource != nil {
		ok := object.Key("DataSource")
		ok.String(*v.DataSource)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTracker struct {
}

func (*awsRestjson1_serializeOpCreateTracker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTracker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrackerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTrackerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTrackerInput(v *CreateTrackerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTrackerInput(v *CreateTrackerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EventBridgeEnabled != nil {
		ok := object.Key("EventBridgeEnabled")
		ok.Boolean(*v.EventBridgeEnabled)
	}

	if v.KmsKeyEnableGeospatialQueries != nil {
		ok := object.Key("KmsKeyEnableGeospatialQueries")
		ok.Boolean(*v.KmsKeyEnableGeospatialQueries)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if len(v.PositionFiltering) > 0 {
		ok := object.Key("PositionFiltering")
		ok.String(string(v.PositionFiltering))
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.PricingPlanDataSource != nil {
		ok := object.Key("PricingPlanDataSource")
		ok.String(*v.PricingPlanDataSource)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrackerName != nil {
		ok := object.Key("TrackerName")
		ok.String(*v.TrackerName)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGeofenceCollection struct {
}

func (*awsRestjson1_serializeOpDeleteGeofenceCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGeofenceCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGeofenceCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGeofenceCollectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGeofenceCollectionInput(v *DeleteGeofenceCollectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteKey struct {
}

func (*awsRestjson1_serializeOpDeleteKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metadata/v0/keys/{KeyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteKeyInput(v *DeleteKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ForceDelete != nil {
		encoder.SetQuery("forceDelete").Boolean(*v.ForceDelete)
	}

	if v.KeyName == nil || len(*v.KeyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KeyName must not be empty")}
	}
	if v.KeyName != nil {
		if err := encoder.SetURI("KeyName").String(*v.KeyName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMap struct {
}

func (*awsRestjson1_serializeOpDeleteMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMapInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMapInput(v *DeleteMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePlaceIndex struct {
}

func (*awsRestjson1_serializeOpDeletePlaceIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePlaceIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePlaceIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePlaceIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePlaceIndexInput(v *DeletePlaceIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRouteCalculator struct {
}

func (*awsRestjson1_serializeOpDeleteRouteCalculator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRouteCalculator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteCalculatorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/calculators/{CalculatorName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRouteCalculatorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRouteCalculatorInput(v *DeleteRouteCalculatorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CalculatorName == nil || len(*v.CalculatorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CalculatorName must not be empty")}
	}
	if v.CalculatorName != nil {
		if err := encoder.SetURI("CalculatorName").String(*v.CalculatorName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTracker struct {
}

func (*awsRestjson1_serializeOpDeleteTracker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTracker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrackerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTrackerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTrackerInput(v *DeleteTrackerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGeofenceCollection struct {
}

func (*awsRestjson1_serializeOpDescribeGeofenceCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGeofenceCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGeofenceCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeGeofenceCollectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGeofenceCollectionInput(v *DescribeGeofenceCollectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeKey struct {
}

func (*awsRestjson1_serializeOpDescribeKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metadata/v0/keys/{KeyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeKeyInput(v *DescribeKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.KeyName == nil || len(*v.KeyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KeyName must not be empty")}
	}
	if v.KeyName != nil {
		if err := encoder.SetURI("KeyName").String(*v.KeyName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeMap struct {
}

func (*awsRestjson1_serializeOpDescribeMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeMapInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeMapInput(v *DescribeMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribePlaceIndex struct {
}

func (*awsRestjson1_serializeOpDescribePlaceIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribePlaceIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePlaceIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribePlaceIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribePlaceIndexInput(v *DescribePlaceIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRouteCalculator struct {
}

func (*awsRestjson1_serializeOpDescribeRouteCalculator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRouteCalculator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRouteCalculatorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/calculators/{CalculatorName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRouteCalculatorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRouteCalculatorInput(v *DescribeRouteCalculatorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CalculatorName == nil || len(*v.CalculatorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CalculatorName must not be empty")}
	}
	if v.CalculatorName != nil {
		if err := encoder.SetURI("CalculatorName").String(*v.CalculatorName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTracker struct {
}

func (*awsRestjson1_serializeOpDescribeTracker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTracker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTrackerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTrackerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTrackerInput(v *DescribeTrackerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateTrackerConsumer struct {
}

func (*awsRestjson1_serializeOpDisassociateTrackerConsumer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateTrackerConsumer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateTrackerConsumerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/consumers/{ConsumerArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateTrackerConsumerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateTrackerConsumerInput(v *DisassociateTrackerConsumerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConsumerArn == nil || len(*v.ConsumerArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConsumerArn must not be empty")}
	}
	if v.ConsumerArn != nil {
		if err := encoder.SetURI("ConsumerArn").String(*v.ConsumerArn); err != nil {
			return err
		}
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpForecastGeofenceEvents struct {
}

func (*awsRestjson1_serializeOpForecastGeofenceEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpForecastGeofenceEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ForecastGeofenceEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/forecast-geofence-events")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsForecastGeofenceEventsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentForecastGeofenceEventsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsForecastGeofenceEventsInput(v *ForecastGeofenceEventsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentForecastGeofenceEventsInput(v *ForecastGeofenceEventsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceState != nil {
		ok := object.Key("DeviceState")
		if err := awsRestjson1_serializeDocumentForecastGeofenceEventsDeviceState(v.DeviceState, ok); err != nil {
			return err
		}
	}

	if len(v.DistanceUnit) > 0 {
		ok := object.Key("DistanceUnit")
		ok.String(string(v.DistanceUnit))
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.SpeedUnit) > 0 {
		ok := object.Key("SpeedUnit")
		ok.String(string(v.SpeedUnit))
	}

	if v.TimeHorizonMinutes != nil {
		ok := object.Key("TimeHorizonMinutes")
		switch {
		case math.IsNaN(*v.TimeHorizonMinutes):
			ok.String("NaN")

		case math.IsInf(*v.TimeHorizonMinutes, 1):
			ok.String("Infinity")

		case math.IsInf(*v.TimeHorizonMinutes, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.TimeHorizonMinutes)

		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDevicePosition struct {
}

func (*awsRestjson1_serializeOpGetDevicePosition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDevicePosition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDevicePositionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/positions/latest")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDevicePositionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDevicePositionInput(v *GetDevicePositionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeviceId == nil || len(*v.DeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeviceId must not be empty")}
	}
	if v.DeviceId != nil {
		if err := encoder.SetURI("DeviceId").String(*v.DeviceId); err != nil {
			return err
		}
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDevicePositionHistory struct {
}

func (*awsRestjson1_serializeOpGetDevicePositionHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDevicePositionHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDevicePositionHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/list-positions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDevicePositionHistoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetDevicePositionHistoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDevicePositionHistoryInput(v *GetDevicePositionHistoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DeviceId == nil || len(*v.DeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeviceId must not be empty")}
	}
	if v.DeviceId != nil {
		if err := encoder.SetURI("DeviceId").String(*v.DeviceId); err != nil {
			return err
		}
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetDevicePositionHistoryInput(v *GetDevicePositionHistoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTimeExclusive != nil {
		ok := object.Key("EndTimeExclusive")
		ok.String(smithytime.FormatDateTime(*v.EndTimeExclusive))
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StartTimeInclusive != nil {
		ok := object.Key("StartTimeInclusive")
		ok.String(smithytime.FormatDateTime(*v.StartTimeInclusive))
	}

	return nil
}

type awsRestjson1_serializeOpGetGeofence struct {
}

func (*awsRestjson1_serializeOpGetGeofence) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGeofence) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGeofenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGeofenceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGeofenceInput(v *GetGeofenceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	if v.GeofenceId == nil || len(*v.GeofenceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GeofenceId must not be empty")}
	}
	if v.GeofenceId != nil {
		if err := encoder.SetURI("GeofenceId").String(*v.GeofenceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMapGlyphs struct {
}

func (*awsRestjson1_serializeOpGetMapGlyphs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMapGlyphs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMapGlyphsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}/glyphs/{FontStack}/{FontUnicodeRange}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMapGlyphsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMapGlyphsInput(v *GetMapGlyphsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FontStack == nil || len(*v.FontStack) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FontStack must not be empty")}
	}
	if v.FontStack != nil {
		if err := encoder.SetURI("FontStack").String(*v.FontStack); err != nil {
			return err
		}
	}

	if v.FontUnicodeRange == nil || len(*v.FontUnicodeRange) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FontUnicodeRange must not be empty")}
	}
	if v.FontUnicodeRange != nil {
		if err := encoder.SetURI("FontUnicodeRange").String(*v.FontUnicodeRange); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMapSprites struct {
}

func (*awsRestjson1_serializeOpGetMapSprites) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMapSprites) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMapSpritesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}/sprites/{FileName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMapSpritesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMapSpritesInput(v *GetMapSpritesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FileName == nil || len(*v.FileName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FileName must not be empty")}
	}
	if v.FileName != nil {
		if err := encoder.SetURI("FileName").String(*v.FileName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMapStyleDescriptor struct {
}

func (*awsRestjson1_serializeOpGetMapStyleDescriptor) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMapStyleDescriptor) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMapStyleDescriptorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}/style-descriptor")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMapStyleDescriptorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMapStyleDescriptorInput(v *GetMapStyleDescriptorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMapTile struct {
}

func (*awsRestjson1_serializeOpGetMapTile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMapTile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMapTileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}/tiles/{Z}/{X}/{Y}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMapTileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMapTileInput(v *GetMapTileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	if v.X == nil || len(*v.X) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member X must not be empty")}
	}
	if v.X != nil {
		if err := encoder.SetURI("X").String(*v.X); err != nil {
			return err
		}
	}

	if v.Y == nil || len(*v.Y) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Y must not be empty")}
	}
	if v.Y != nil {
		if err := encoder.SetURI("Y").String(*v.Y); err != nil {
			return err
		}
	}

	if v.Z == nil || len(*v.Z) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Z must not be empty")}
	}
	if v.Z != nil {
		if err := encoder.SetURI("Z").String(*v.Z); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPlace struct {
}

func (*awsRestjson1_serializeOpGetPlace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPlace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPlaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}/places/{PlaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPlaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPlaceInput(v *GetPlaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	if v.Language != nil {
		encoder.SetQuery("language").String(*v.Language)
	}

	if v.PlaceId == nil || len(*v.PlaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member PlaceId must not be empty")}
	}
	if v.PlaceId != nil {
		if err := encoder.SetURI("PlaceId").String(*v.PlaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListDevicePositions struct {
}

func (*awsRestjson1_serializeOpListDevicePositions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDevicePositions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDevicePositionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/list-positions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDevicePositionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListDevicePositionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDevicePositionsInput(v *ListDevicePositionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListDevicePositionsInput(v *ListDevicePositionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilterGeometry != nil {
		ok := object.Key("FilterGeometry")
		if err := awsRestjson1_serializeDocumentTrackingFilterGeometry(v.FilterGeometry, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGeofenceCollections struct {
}

func (*awsRestjson1_serializeOpListGeofenceCollections) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGeofenceCollections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGeofenceCollectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/list-collections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListGeofenceCollectionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGeofenceCollectionsInput(v *ListGeofenceCollectionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListGeofenceCollectionsInput(v *ListGeofenceCollectionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGeofences struct {
}

func (*awsRestjson1_serializeOpListGeofences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGeofences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGeofencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/list-geofences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGeofencesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListGeofencesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGeofencesInput(v *ListGeofencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListGeofencesInput(v *ListGeofencesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListKeys struct {
}

func (*awsRestjson1_serializeOpListKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metadata/v0/list-keys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListKeysInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListKeysInput(v *ListKeysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListKeysInput(v *ListKeysInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filter != nil {
		ok := object.Key("Filter")
		if err := awsRestjson1_serializeDocumentApiKeyFilter(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMaps struct {
}

func (*awsRestjson1_serializeOpListMaps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMaps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMapsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/list-maps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListMapsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMapsInput(v *ListMapsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListMapsInput(v *ListMapsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListPlaceIndexes struct {
}

func (*awsRestjson1_serializeOpListPlaceIndexes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPlaceIndexes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPlaceIndexesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/list-indexes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListPlaceIndexesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPlaceIndexesInput(v *ListPlaceIndexesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListPlaceIndexesInput(v *ListPlaceIndexesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRouteCalculators struct {
}

func (*awsRestjson1_serializeOpListRouteCalculators) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRouteCalculators) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRouteCalculatorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/list-calculators")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListRouteCalculatorsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRouteCalculatorsInput(v *ListRouteCalculatorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListRouteCalculatorsInput(v *ListRouteCalculatorsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTrackerConsumers struct {
}

func (*awsRestjson1_serializeOpListTrackerConsumers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTrackerConsumers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTrackerConsumersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/list-consumers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTrackerConsumersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTrackerConsumersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTrackerConsumersInput(v *ListTrackerConsumersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTrackerConsumersInput(v *ListTrackerConsumersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTrackers struct {
}

func (*awsRestjson1_serializeOpListTrackers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTrackers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTrackersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/list-trackers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTrackersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTrackersInput(v *ListTrackersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTrackersInput(v *ListTrackersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutGeofence struct {
}

func (*awsRestjson1_serializeOpPutGeofence) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutGeofence) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutGeofenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutGeofenceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutGeofenceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutGeofenceInput(v *PutGeofenceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	if v.GeofenceId == nil || len(*v.GeofenceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member GeofenceId must not be empty")}
	}
	if v.GeofenceId != nil {
		if err := encoder.SetURI("GeofenceId").String(*v.GeofenceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutGeofenceInput(v *PutGeofenceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GeofenceProperties != nil {
		ok := object.Key("GeofenceProperties")
		if err := awsRestjson1_serializeDocumentPropertyMap(v.GeofenceProperties, ok); err != nil {
			return err
		}
	}

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentGeofenceGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchPlaceIndexForPosition struct {
}

func (*awsRestjson1_serializeOpSearchPlaceIndexForPosition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchPlaceIndexForPosition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchPlaceIndexForPositionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}/search/position")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchPlaceIndexForPositionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchPlaceIndexForPositionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchPlaceIndexForPositionInput(v *SearchPlaceIndexForPositionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchPlaceIndexForPositionInput(v *SearchPlaceIndexForPositionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSearchPlaceIndexForSuggestions struct {
}

func (*awsRestjson1_serializeOpSearchPlaceIndexForSuggestions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchPlaceIndexForSuggestions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchPlaceIndexForSuggestionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}/search/suggestions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchPlaceIndexForSuggestionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchPlaceIndexForSuggestionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchPlaceIndexForSuggestionsInput(v *SearchPlaceIndexForSuggestionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchPlaceIndexForSuggestionsInput(v *SearchPlaceIndexForSuggestionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BiasPosition != nil {
		ok := object.Key("BiasPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.BiasPosition, ok); err != nil {
			return err
		}
	}

	if v.FilterBBox != nil {
		ok := object.Key("FilterBBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.FilterBBox, ok); err != nil {
			return err
		}
	}

	if v.FilterCategories != nil {
		ok := object.Key("FilterCategories")
		if err := awsRestjson1_serializeDocumentFilterPlaceCategoryList(v.FilterCategories, ok); err != nil {
			return err
		}
	}

	if v.FilterCountries != nil {
		ok := object.Key("FilterCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.FilterCountries, ok); err != nil {
			return err
		}
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	return nil
}

type awsRestjson1_serializeOpSearchPlaceIndexForText struct {
}

func (*awsRestjson1_serializeOpSearchPlaceIndexForText) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchPlaceIndexForText) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchPlaceIndexForTextInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}/search/text")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchPlaceIndexForTextInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchPlaceIndexForTextInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchPlaceIndexForTextInput(v *SearchPlaceIndexForTextInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	if v.Key != nil {
		encoder.SetQuery("key").String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchPlaceIndexForTextInput(v *SearchPlaceIndexForTextInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BiasPosition != nil {
		ok := object.Key("BiasPosition")
		if err := awsRestjson1_serializeDocumentPosition(v.BiasPosition, ok); err != nil {
			return err
		}
	}

	if v.FilterBBox != nil {
		ok := object.Key("FilterBBox")
		if err := awsRestjson1_serializeDocumentBoundingBox(v.FilterBBox, ok); err != nil {
			return err
		}
	}

	if v.FilterCategories != nil {
		ok := object.Key("FilterCategories")
		if err := awsRestjson1_serializeDocumentFilterPlaceCategoryList(v.FilterCategories, ok); err != nil {
			return err
		}
	}

	if v.FilterCountries != nil {
		ok := object.Key("FilterCountries")
		if err := awsRestjson1_serializeDocumentCountryCodeList(v.FilterCountries, ok); err != nil {
			return err
		}
	}

	if v.Language != nil {
		ok := object.Key("Language")
		ok.String(*v.Language)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Text != nil {
		ok := object.Key("Text")
		ok.String(*v.Text)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGeofenceCollection struct {
}

func (*awsRestjson1_serializeOpUpdateGeofenceCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGeofenceCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGeofenceCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/geofencing/v0/collections/{CollectionName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGeofenceCollectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGeofenceCollectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGeofenceCollectionInput(v *UpdateGeofenceCollectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollectionName == nil || len(*v.CollectionName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CollectionName must not be empty")}
	}
	if v.CollectionName != nil {
		if err := encoder.SetURI("CollectionName").String(*v.CollectionName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGeofenceCollectionInput(v *UpdateGeofenceCollectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.PricingPlanDataSource != nil {
		ok := object.Key("PricingPlanDataSource")
		ok.String(*v.PricingPlanDataSource)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateKey struct {
}

func (*awsRestjson1_serializeOpUpdateKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/metadata/v0/keys/{KeyName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateKeyInput(v *UpdateKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.KeyName == nil || len(*v.KeyName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member KeyName must not be empty")}
	}
	if v.KeyName != nil {
		if err := encoder.SetURI("KeyName").String(*v.KeyName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateKeyInput(v *UpdateKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.ExpireTime != nil {
		ok := object.Key("ExpireTime")
		ok.String(smithytime.FormatDateTime(*v.ExpireTime))
	}

	if v.ForceUpdate != nil {
		ok := object.Key("ForceUpdate")
		ok.Boolean(*v.ForceUpdate)
	}

	if v.NoExpiry != nil {
		ok := object.Key("NoExpiry")
		ok.Boolean(*v.NoExpiry)
	}

	if v.Restrictions != nil {
		ok := object.Key("Restrictions")
		if err := awsRestjson1_serializeDocumentApiKeyRestrictions(v.Restrictions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMap struct {
}

func (*awsRestjson1_serializeOpUpdateMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/maps/v0/maps/{MapName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMapInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMapInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMapInput(v *UpdateMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MapName == nil || len(*v.MapName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member MapName must not be empty")}
	}
	if v.MapName != nil {
		if err := encoder.SetURI("MapName").String(*v.MapName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMapInput(v *UpdateMapInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationUpdate != nil {
		ok := object.Key("ConfigurationUpdate")
		if err := awsRestjson1_serializeDocumentMapConfigurationUpdate(v.ConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePlaceIndex struct {
}

func (*awsRestjson1_serializeOpUpdatePlaceIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePlaceIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePlaceIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/places/v0/indexes/{IndexName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePlaceIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePlaceIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePlaceIndexInput(v *UpdatePlaceIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IndexName == nil || len(*v.IndexName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IndexName must not be empty")}
	}
	if v.IndexName != nil {
		if err := encoder.SetURI("IndexName").String(*v.IndexName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePlaceIndexInput(v *UpdatePlaceIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceConfiguration != nil {
		ok := object.Key("DataSourceConfiguration")
		if err := awsRestjson1_serializeDocumentDataSourceConfiguration(v.DataSourceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRouteCalculator struct {
}

func (*awsRestjson1_serializeOpUpdateRouteCalculator) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRouteCalculator) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRouteCalculatorInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/routes/v0/calculators/{CalculatorName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRouteCalculatorInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRouteCalculatorInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRouteCalculatorInput(v *UpdateRouteCalculatorInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CalculatorName == nil || len(*v.CalculatorName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CalculatorName must not be empty")}
	}
	if v.CalculatorName != nil {
		if err := encoder.SetURI("CalculatorName").String(*v.CalculatorName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRouteCalculatorInput(v *UpdateRouteCalculatorInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTracker struct {
}

func (*awsRestjson1_serializeOpUpdateTracker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTracker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTrackerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTrackerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTrackerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTrackerInput(v *UpdateTrackerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTrackerInput(v *UpdateTrackerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EventBridgeEnabled != nil {
		ok := object.Key("EventBridgeEnabled")
		ok.Boolean(*v.EventBridgeEnabled)
	}

	if v.KmsKeyEnableGeospatialQueries != nil {
		ok := object.Key("KmsKeyEnableGeospatialQueries")
		ok.Boolean(*v.KmsKeyEnableGeospatialQueries)
	}

	if len(v.PositionFiltering) > 0 {
		ok := object.Key("PositionFiltering")
		ok.String(string(v.PositionFiltering))
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("PricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.PricingPlanDataSource != nil {
		ok := object.Key("PricingPlanDataSource")
		ok.String(*v.PricingPlanDataSource)
	}

	return nil
}

type awsRestjson1_serializeOpVerifyDevicePosition struct {
}

func (*awsRestjson1_serializeOpVerifyDevicePosition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpVerifyDevicePosition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*VerifyDevicePositionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tracking/v0/trackers/{TrackerName}/positions/verify")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsVerifyDevicePositionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentVerifyDevicePositionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsVerifyDevicePositionInput(v *VerifyDevicePositionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrackerName == nil || len(*v.TrackerName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TrackerName must not be empty")}
	}
	if v.TrackerName != nil {
		if err := encoder.SetURI("TrackerName").String(*v.TrackerName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentVerifyDevicePositionInput(v *VerifyDevicePositionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceState != nil {
		ok := object.Key("DeviceState")
		if err := awsRestjson1_serializeDocumentDeviceState(v.DeviceState, ok); err != nil {
			return err
		}
	}

	if len(v.DistanceUnit) > 0 {
		ok := object.Key("DistanceUnit")
		ok.String(string(v.DistanceUnit))
	}

	return nil
}

func awsRestjson1_serializeDocumentApiKeyActionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentApiKeyFilter(v *types.ApiKeyFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.KeyStatus) > 0 {
		ok := object.Key("KeyStatus")
		ok.String(string(v.KeyStatus))
	}

	return nil
}

func awsRestjson1_serializeDocumentApiKeyRestrictions(v *types.ApiKeyRestrictions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowActions != nil {
		ok := object.Key("AllowActions")
		if err := awsRestjson1_serializeDocumentApiKeyActionList(v.AllowActions, ok); err != nil {
			return err
		}
	}

	if v.AllowReferers != nil {
		ok := object.Key("AllowReferers")
		if err := awsRestjson1_serializeDocumentRefererPatternList(v.AllowReferers, ok); err != nil {
			return err
		}
	}

	if v.AllowResources != nil {
		ok := object.Key("AllowResources")
		if err := awsRestjson1_serializeDocumentGeoArnList(v.AllowResources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchPutGeofenceRequestEntry(v *types.BatchPutGeofenceRequestEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GeofenceId != nil {
		ok := object.Key("GeofenceId")
		ok.String(*v.GeofenceId)
	}

	if v.GeofenceProperties != nil {
		ok := object.Key("GeofenceProperties")
		if err := awsRestjson1_serializeDocumentPropertyMap(v.GeofenceProperties, ok); err != nil {
			return err
		}
	}

	if v.Geometry != nil {
		ok := object.Key("Geometry")
		if err := awsRestjson1_serializeDocumentGeofenceGeometry(v.Geometry, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatchPutGeofenceRequestEntryList(v []types.BatchPutGeofenceRequestEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatchPutGeofenceRequestEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBoundingBox(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCalculateRouteCarModeOptions(v *types.CalculateRouteCarModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidFerries != nil {
		ok := object.Key("AvoidFerries")
		ok.Boolean(*v.AvoidFerries)
	}

	if v.AvoidTolls != nil {
		ok := object.Key("AvoidTolls")
		ok.Boolean(*v.AvoidTolls)
	}

	return nil
}

func awsRestjson1_serializeDocumentCalculateRouteTruckModeOptions(v *types.CalculateRouteTruckModeOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvoidFerries != nil {
		ok := object.Key("AvoidFerries")
		ok.Boolean(*v.AvoidFerries)
	}

	if v.AvoidTolls != nil {
		ok := object.Key("AvoidTolls")
		ok.Boolean(*v.AvoidTolls)
	}

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsRestjson1_serializeDocumentTruckDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	if v.Weight != nil {
		ok := object.Key("Weight")
		if err := awsRestjson1_serializeDocumentTruckWeight(v.Weight, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCellSignals(v *types.CellSignals, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LteCellDetails != nil {
		ok := object.Key("LteCellDetails")
		if err := awsRestjson1_serializeDocumentLteCellDetailsList(v.LteCellDetails, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCircle(v *types.Circle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Center != nil {
		ok := object.Key("Center")
		if err := awsRestjson1_serializeDocumentPosition(v.Center, ok); err != nil {
			return err
		}
	}

	if v.Radius != nil {
		ok := object.Key("Radius")
		switch {
		case math.IsNaN(*v.Radius):
			ok.String("NaN")

		case math.IsInf(*v.Radius, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Radius, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Radius)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCountryCodeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomLayerList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSourceConfiguration(v *types.DataSourceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IntendedUse) > 0 {
		ok := object.Key("IntendedUse")
		ok.String(string(v.IntendedUse))
	}

	return nil
}

func awsRestjson1_serializeDocumentDeviceIdsList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDevicePositionUpdate(v *types.DevicePositionUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Accuracy != nil {
		ok := object.Key("Accuracy")
		if err := awsRestjson1_serializeDocumentPositionalAccuracy(v.Accuracy, ok); err != nil {
			return err
		}
	}

	if v.DeviceId != nil {
		ok := object.Key("DeviceId")
		ok.String(*v.DeviceId)
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.PositionProperties != nil {
		ok := object.Key("PositionProperties")
		if err := awsRestjson1_serializeDocumentPositionPropertyMap(v.PositionProperties, ok); err != nil {
			return err
		}
	}

	if v.SampleTime != nil {
		ok := object.Key("SampleTime")
		ok.String(smithytime.FormatDateTime(*v.SampleTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentDevicePositionUpdateList(v []types.DevicePositionUpdate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDevicePositionUpdate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDeviceState(v *types.DeviceState, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Accuracy != nil {
		ok := object.Key("Accuracy")
		if err := awsRestjson1_serializeDocumentPositionalAccuracy(v.Accuracy, ok); err != nil {
			return err
		}
	}

	if v.CellSignals != nil {
		ok := object.Key("CellSignals")
		if err := awsRestjson1_serializeDocumentCellSignals(v.CellSignals, ok); err != nil {
			return err
		}
	}

	if v.DeviceId != nil {
		ok := object.Key("DeviceId")
		ok.String(*v.DeviceId)
	}

	if v.Ipv4Address != nil {
		ok := object.Key("Ipv4Address")
		ok.String(*v.Ipv4Address)
	}

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.SampleTime != nil {
		ok := object.Key("SampleTime")
		ok.String(smithytime.FormatDateTime(*v.SampleTime))
	}

	if v.WiFiAccessPoints != nil {
		ok := object.Key("WiFiAccessPoints")
		if err := awsRestjson1_serializeDocumentWiFiAccessPointList(v.WiFiAccessPoints, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterPlaceCategoryList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentForecastGeofenceEventsDeviceState(v *types.ForecastGeofenceEventsDeviceState, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Position != nil {
		ok := object.Key("Position")
		if err := awsRestjson1_serializeDocumentPosition(v.Position, ok); err != nil {
			return err
		}
	}

	if v.Speed != nil {
		ok := object.Key("Speed")
		switch {
		case math.IsNaN(*v.Speed):
			ok.String("NaN")

		case math.IsInf(*v.Speed, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Speed, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Speed)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeoArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGeofenceGeometry(v *types.GeofenceGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Circle != nil {
		ok := object.Key("Circle")
		if err := awsRestjson1_serializeDocumentCircle(v.Circle, ok); err != nil {
			return err
		}
	}

	if v.Geobuf != nil {
		ok := object.Key("Geobuf")
		ok.Base64EncodeBytes(v.Geobuf)
	}

	if v.MultiPolygon != nil {
		ok := object.Key("MultiPolygon")
		if err := awsRestjson1_serializeDocumentMultiLinearRings(v.MultiPolygon, ok); err != nil {
			return err
		}
	}

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Polygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentLinearRing(v [][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPosition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLinearRings(v [][][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentLinearRing(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLteCellDetails(v *types.LteCellDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("CellId")
		ok.Integer(v.CellId)
	}

	if v.LocalId != nil {
		ok := object.Key("LocalId")
		if err := awsRestjson1_serializeDocumentLteLocalId(v.LocalId, ok); err != nil {
			return err
		}
	}

	if v.Mcc != nil {
		ok := object.Key("Mcc")
		ok.Integer(*v.Mcc)
	}

	if v.Mnc != nil {
		ok := object.Key("Mnc")
		ok.Integer(*v.Mnc)
	}

	if v.NetworkMeasurements != nil {
		ok := object.Key("NetworkMeasurements")
		if err := awsRestjson1_serializeDocumentLteNetworkMeasurementsList(v.NetworkMeasurements, ok); err != nil {
			return err
		}
	}

	if v.NrCapable != nil {
		ok := object.Key("NrCapable")
		ok.Boolean(*v.NrCapable)
	}

	if v.Rsrp != nil {
		ok := object.Key("Rsrp")
		ok.Integer(*v.Rsrp)
	}

	if v.Rsrq != nil {
		ok := object.Key("Rsrq")
		switch {
		case math.IsNaN(float64(*v.Rsrq)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Rsrq), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Rsrq), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Rsrq)

		}
	}

	if v.Tac != nil {
		ok := object.Key("Tac")
		ok.Integer(*v.Tac)
	}

	if v.TimingAdvance != nil {
		ok := object.Key("TimingAdvance")
		ok.Integer(*v.TimingAdvance)
	}

	return nil
}

func awsRestjson1_serializeDocumentLteCellDetailsList(v []types.LteCellDetails, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLteCellDetails(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLteLocalId(v *types.LteLocalId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("Earfcn")
		ok.Integer(v.Earfcn)
	}

	{
		ok := object.Key("Pci")
		ok.Integer(v.Pci)
	}

	return nil
}

func awsRestjson1_serializeDocumentLteNetworkMeasurements(v *types.LteNetworkMeasurements, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("CellId")
		ok.Integer(v.CellId)
	}

	{
		ok := object.Key("Earfcn")
		ok.Integer(v.Earfcn)
	}

	{
		ok := object.Key("Pci")
		ok.Integer(v.Pci)
	}

	if v.Rsrp != nil {
		ok := object.Key("Rsrp")
		ok.Integer(*v.Rsrp)
	}

	if v.Rsrq != nil {
		ok := object.Key("Rsrq")
		switch {
		case math.IsNaN(float64(*v.Rsrq)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Rsrq), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Rsrq), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Rsrq)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLteNetworkMeasurementsList(v []types.LteNetworkMeasurements, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLteNetworkMeasurements(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapConfiguration(v *types.MapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLayers != nil {
		ok := object.Key("CustomLayers")
		if err := awsRestjson1_serializeDocumentCustomLayerList(v.CustomLayers, ok); err != nil {
			return err
		}
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	if v.Style != nil {
		ok := object.Key("Style")
		ok.String(*v.Style)
	}

	return nil
}

func awsRestjson1_serializeDocumentMapConfigurationUpdate(v *types.MapConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLayers != nil {
		ok := object.Key("CustomLayers")
		if err := awsRestjson1_serializeDocumentCustomLayerList(v.CustomLayers, ok); err != nil {
			return err
		}
	}

	if v.PoliticalView != nil {
		ok := object.Key("PoliticalView")
		ok.String(*v.PoliticalView)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiLinearRings(v [][][][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentLinearRings(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPosition(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPositionalAccuracy(v *types.PositionalAccuracy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Horizontal != nil {
		ok := object.Key("Horizontal")
		switch {
		case math.IsNaN(*v.Horizontal):
			ok.String("NaN")

		case math.IsInf(*v.Horizontal, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Horizontal, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Horizontal)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPositionList(v [][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPosition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPositionPropertyMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentPropertyMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentRefererPatternList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTrackingFilterGeometry(v *types.TrackingFilterGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Polygon != nil {
		ok := object.Key("Polygon")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Polygon, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTruckDimensions(v *types.TruckDimensions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("Height")
		switch {
		case math.IsNaN(*v.Height):
			ok.String("NaN")

		case math.IsInf(*v.Height, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Height, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Height)

		}
	}

	if v.Length != nil {
		ok := object.Key("Length")
		switch {
		case math.IsNaN(*v.Length):
			ok.String("NaN")

		case math.IsInf(*v.Length, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Length, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Length)

		}
	}

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	if v.Width != nil {
		ok := object.Key("Width")
		switch {
		case math.IsNaN(*v.Width):
			ok.String("NaN")

		case math.IsInf(*v.Width, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Width, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Width)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTruckWeight(v *types.TruckWeight, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Total != nil {
		ok := object.Key("Total")
		switch {
		case math.IsNaN(*v.Total):
			ok.String("NaN")

		case math.IsInf(*v.Total, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Total, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Total)

		}
	}

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	return nil
}

func awsRestjson1_serializeDocumentWaypointPositionList(v [][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPosition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentWiFiAccessPoint(v *types.WiFiAccessPoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MacAddress != nil {
		ok := object.Key("MacAddress")
		ok.String(*v.MacAddress)
	}

	if v.Rss != nil {
		ok := object.Key("Rss")
		ok.Integer(*v.Rss)
	}

	return nil
}

func awsRestjson1_serializeDocumentWiFiAccessPointList(v []types.WiFiAccessPoint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentWiFiAccessPoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
