// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/transfer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// If the IdentityProviderType of a file transfer protocol-enabled server is
// AWS_DIRECTORY_SERVICE or API_Gateway , tests whether your identity provider is
// set up successfully. We highly recommend that you call this operation to test
// your authentication method as soon as you create your server. By doing so, you
// can troubleshoot issues with the identity provider integration to ensure that
// your users can successfully use the service.
//
// The ServerId and UserName parameters are required. The ServerProtocol , SourceIp
// , and UserPassword are all optional.
//
// Note the following:
//
//   - You cannot use TestIdentityProvider if the IdentityProviderType of your
//     server is SERVICE_MANAGED .
//
//   - TestIdentityProvider does not work with keys: it only accepts passwords.
//
//   - TestIdentityProvider can test the password operation for a custom Identity
//     Provider that handles keys and passwords.
//
//   - If you provide any incorrect values for any parameters, the Response field
//     is empty.
//
//   - If you provide a server ID for a server that uses service-managed users,
//     you get an error:
//
// An error occurred (InvalidRequestException) when calling the
//
//	TestIdentityProvider operation: s-server-ID not configured for external auth
//
//	- If you enter a Server ID for the --server-id parameter that does not
//	identify an actual Transfer server, you receive the following error:
//
// An error occurred (ResourceNotFoundException) when calling the
//
//	TestIdentityProvider operation: Unknown server .
//
// It is possible your sever is in a different region. You can specify a region by
//
//	adding the following: --region region-code , such as --region us-east-2 to
//	specify a server in US East (Ohio).
func (c *Client) TestIdentityProvider(ctx context.Context, params *TestIdentityProviderInput, optFns ...func(*Options)) (*TestIdentityProviderOutput, error) {
	if params == nil {
		params = &TestIdentityProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TestIdentityProvider", params, optFns, c.addOperationTestIdentityProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TestIdentityProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TestIdentityProviderInput struct {

	// A system-assigned identifier for a specific server. That server's user
	// authentication method is tested with a user name and password.
	//
	// This member is required.
	ServerId *string

	// The name of the account to be tested.
	//
	// This member is required.
	UserName *string

	// The type of file transfer protocol to be tested.
	//
	// The available protocols are:
	//
	//   - Secure Shell (SSH) File Transfer Protocol (SFTP)
	//
	//   - File Transfer Protocol Secure (FTPS)
	//
	//   - File Transfer Protocol (FTP)
	//
	//   - Applicability Statement 2 (AS2)
	ServerProtocol types.Protocol

	// The source IP address of the account to be tested.
	SourceIp *string

	// The password of the account to be tested.
	UserPassword *string

	noSmithyDocumentSerde
}

type TestIdentityProviderOutput struct {

	// The HTTP status code that is the response from your API Gateway or your Lambda
	// function.
	//
	// This member is required.
	StatusCode int32

	// The endpoint of the service used to authenticate a user.
	//
	// This member is required.
	Url *string

	// A message that indicates whether the test was successful or not.
	//
	// If an empty string is returned, the most likely cause is that the
	// authentication failed due to an incorrect username or password.
	Message *string

	// The response that is returned from your API Gateway or your Lambda function.
	Response *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTestIdentityProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpTestIdentityProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpTestIdentityProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TestIdentityProvider"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpTestIdentityProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTestIdentityProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTestIdentityProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TestIdentityProvider",
	}
}
