// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes a thin client device.
type Device struct {

	// The Amazon Resource Name (ARN) of the device.
	Arn *string

	// The timestamp of when the device was created.
	CreatedAt *time.Time

	// The ID of the software set currently installed on the device.
	CurrentSoftwareSetId *string

	// The version of the software set currently installed on the device.
	CurrentSoftwareSetVersion *string

	// The ID of the software set which the device has been set to.
	DesiredSoftwareSetId *string

	// The ID of the environment the device is associated with.
	EnvironmentId *string

	// The ID of the device.
	Id *string

	// The Amazon Resource Name (ARN) of the Key Management Service key used to
	// encrypt the device.
	KmsKeyArn *string

	// The timestamp of the most recent session on the device.
	LastConnectedAt *time.Time

	// The timestamp of the most recent check-in of the device.
	LastPostureAt *time.Time

	// The user ID of the most recent session on the device.
	LastUserId *string

	// The model number of the device.
	Model *string

	// The name of the device.
	Name *string

	// The ID of the software set that is pending to be installed on the device.
	PendingSoftwareSetId *string

	// The version of the software set that is pending to be installed on the device.
	PendingSoftwareSetVersion *string

	// The hardware serial number of the device.
	SerialNumber *string

	// Describes if the software currently installed on the device is a supported
	// version.
	SoftwareSetComplianceStatus DeviceSoftwareSetComplianceStatus

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule SoftwareSetUpdateSchedule

	// Describes if the device has a supported version of software installed.
	SoftwareSetUpdateStatus SoftwareSetUpdateStatus

	// The status of the device.
	Status DeviceStatus

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Describes a thin client device.
type DeviceSummary struct {

	// The Amazon Resource Name (ARN) of the device.
	Arn *string

	// The timestamp of when the device was created.
	CreatedAt *time.Time

	// The ID of the software set currently installed on the device.
	CurrentSoftwareSetId *string

	// The ID of the software set which the device has been set to.
	DesiredSoftwareSetId *string

	// The ID of the environment the device is associated with.
	EnvironmentId *string

	// The ID of the device.
	Id *string

	// The timestamp of the most recent session on the device.
	LastConnectedAt *time.Time

	// The timestamp of the most recent check-in of the device.
	LastPostureAt *time.Time

	// The user ID of the most recent session on the device.
	LastUserId *string

	// The model number of the device.
	Model *string

	// The name of the device.
	Name *string

	// The ID of the software set that is pending to be installed on the device.
	PendingSoftwareSetId *string

	// The hardware serial number of the device.
	SerialNumber *string

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule SoftwareSetUpdateSchedule

	// The status of the device.
	Status DeviceStatus

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Describes an environment.
type Environment struct {

	// The activation code to register a device to the environment.
	ActivationCode *string

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string

	// The timestamp of when the environment was created.
	CreatedAt *time.Time

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string

	// The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces,
	// WorkSpaces Secure Browser, or AppStream 2.0.
	DesktopArn *string

	// The URL for the identity provider login (only for environments that use
	// AppStream 2.0).
	DesktopEndpoint *string

	// The type of streaming desktop for the environment.
	DesktopType DesktopType

	// The tag keys and optional values for the newly created devices for this
	// environment.
	DeviceCreationTags map[string]string

	// The ID of the environment.
	Id *string

	// The Amazon Resource Name (ARN) of the Key Management Service key used to
	// encrypt the environment.
	KmsKeyArn *string

	// A specification for a time window to apply software updates.
	MaintenanceWindow *MaintenanceWindow

	// The name of the environment.
	Name *string

	// The ID of the software set that is pending to be installed.
	PendingSoftwareSetId *string

	// The version of the software set that is pending to be installed.
	PendingSoftwareSetVersion *string

	// The number of devices registered to the environment.
	RegisteredDevicesCount *int32

	// Describes if the software currently installed on all devices in the environment
	// is a supported version.
	SoftwareSetComplianceStatus EnvironmentSoftwareSetComplianceStatus

	// An option to define which software updates to apply.
	SoftwareSetUpdateMode SoftwareSetUpdateMode

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule SoftwareSetUpdateSchedule

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Describes an environment.
type EnvironmentSummary struct {

	// The activation code to register a device to the environment.
	ActivationCode *string

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string

	// The timestamp of when the environment was created.
	CreatedAt *time.Time

	// The ID of the software set to apply.
	DesiredSoftwareSetId *string

	// The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces,
	// WorkSpaces Secure Browser, or AppStream 2.0.
	DesktopArn *string

	// The URL for the identity provider login (only for environments that use
	// AppStream 2.0).
	DesktopEndpoint *string

	// The type of streaming desktop for the environment.
	DesktopType DesktopType

	// The ID of the environment.
	Id *string

	// A specification for a time window to apply software updates.
	MaintenanceWindow *MaintenanceWindow

	// The name of the environment.
	Name *string

	// The ID of the software set that is pending to be installed.
	PendingSoftwareSetId *string

	// An option to define which software updates to apply.
	SoftwareSetUpdateMode SoftwareSetUpdateMode

	// An option to define if software updates should be applied within a maintenance
	// window.
	SoftwareSetUpdateSchedule SoftwareSetUpdateSchedule

	// The timestamp of when the device was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Describes the maintenance window for a thin client device.
type MaintenanceWindow struct {

	// An option to select the default or custom maintenance window.
	//
	// This member is required.
	Type MaintenanceWindowType

	// The option to set the maintenance window during the device local time or
	// Universal Coordinated Time (UTC).
	ApplyTimeOf ApplyTimeOf

	// The days of the week during which the maintenance window is open.
	DaysOfTheWeek []DayOfWeek

	// The hour for the maintenance window end ( 00 - 23 ).
	EndTimeHour *int32

	// The minutes for the maintenance window end ( 00 - 59 ).
	EndTimeMinute *int32

	// The hour for the maintenance window start ( 00 - 23 ).
	StartTimeHour *int32

	// The minutes past the hour for the maintenance window start ( 00 - 59 ).
	StartTimeMinute *int32

	noSmithyDocumentSerde
}

// Describes software.
type Software struct {

	// The name of the software component.
	Name *string

	// The version of the software component.
	Version *string

	noSmithyDocumentSerde
}

// Describes a software set.
type SoftwareSet struct {

	// The Amazon Resource Name (ARN) of the software set.
	Arn *string

	// The ID of the software set.
	Id *string

	// The timestamp of when the software set was released.
	ReleasedAt *time.Time

	// A list of the software components in the software set.
	Software []Software

	// The timestamp of the end of support for the software set.
	SupportedUntil *time.Time

	// An option to define if the software set has been validated.
	ValidationStatus SoftwareSetValidationStatus

	// The version of the software set.
	Version *string

	noSmithyDocumentSerde
}

// Describes a software set.
type SoftwareSetSummary struct {

	// The Amazon Resource Name (ARN) of the software set.
	Arn *string

	// The ID of the software set.
	Id *string

	// The timestamp of when the software set was released.
	ReleasedAt *time.Time

	// The timestamp of the end of support for the software set.
	SupportedUntil *time.Time

	// An option to define if the software set has been validated.
	ValidationStatus SoftwareSetValidationStatus

	// The version of the software set.
	Version *string

	noSmithyDocumentSerde
}

// Describes a validation exception.
type ValidationExceptionField struct {

	// A message that describes the reason for the exception.
	//
	// This member is required.
	Message *string

	// The name of the exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
