package rust

import "github.com/carapace-sh/carapace"

// ActionErrorCodes completes error codes
//
//	E0023 (A pattern attempted to extract an incorrect number of fields from a variant.)
//	E0025 (Each field of a struct can only be bound once in a pattern.)
func ActionErrorCodes() carapace.Action {
	return carapace.ActionValuesDescribed(
		"E0001", "#### Note: this error code is no longer emitted by the compiler.",
		"E0002", "#### Note: this error code is no longer emitted by the compiler.",
		"E0004", "This error indicates that the compiler cannot guarantee a matching pattern for",
		"E0005", "Patterns used to bind names must be irrefutable, that is, they must guarantee",
		"E0007", "#### Note: this error code is no longer emitted by the compiler.",
		"E0009", "#### Note: this error code is no longer emitted by the compiler.",
		"E0010", "The value of statics and constants must be known at compile time, and they live",
		"E0013", "#### Note: this error code is no longer emitted by the compiler",
		"E0014", "#### Note: this error code is no longer emitted by the compiler.",
		"E0015", "A non-`const` function was called in a `const` context.",
		"E0023", "A pattern attempted to extract an incorrect number of fields from a variant.",
		"E0025", "Each field of a struct can only be bound once in a pattern.",
		"E0026", "A struct pattern attempted to extract a nonexistent field from a struct.",
		"E0027", "A pattern for a struct fails to specify a sub-pattern for every one of the",
		"E0029", "Something other than numbers and characters has been used for a range.",
		"E0030", "When matching against a range, the compiler verifies that the range is",
		"E0033", "A trait type has been dereferenced.",
		"E0034", "The compiler doesn't know what method to call because more than one method",
		"E0038", "For any given trait `Trait` there may be a related _type_ called the _trait",
		"E0040", "It is not allowed to manually call destructors in Rust.",
		"E0044", "You cannot use type or const parameters on foreign items.",
		"E0045", "Variadic parameters have been used on a non-C ABI function.",
		"E0046", "Items are missing in a trait implementation.",
		"E0049", "An attempted implementation of a trait method has the wrong number of type or",
		"E0050", "An attempted implementation of a trait method has the wrong number of function",
		"E0053", "The parameters of any trait method must match between a trait implementation",
		"E0054", "It is not allowed to cast to a bool.",
		"E0055", "During a method call, a value is automatically dereferenced as many times as",
		"E0057", "An invalid number of arguments was given when calling a closure.",
		"E0059", "The built-in function traits are generic over a tuple of the function arguments.",
		"E0060", "External C functions are allowed to be variadic. However, a variadic function",
		"E0061", "An invalid number of arguments was passed when calling a function.",
		"E0062", "A struct's or struct-like enum variant's field was specified more than once.",
		"E0063", "A struct's or struct-like enum variant's field was not provided.",
		"E0067", "An invalid left-hand side expression was used on an assignment operation.",
		"E0069", "The compiler found a function whose body contains a `return;` statement but",
		"E0070", "An assignment operator was used on a non-place expression.",
		"E0071", "A structure-literal syntax was used to create an item that is not a structure",
		"E0072", "A recursive type has infinite size because it doesn't have an indirection.",
		"E0073", "#### Note: this error code is no longer emitted by the compiler.",
		"E0074", "#### Note: this error code is no longer emitted by the compiler.",
		"E0075", "A `#[simd]` attribute was applied to an empty or multi-field struct.",
		"E0076", "The type of the field in a tuple struct isn't an array when using the `#[simd]`",
		"E0077", "A tuple struct's element isn't a machine type when using the `#[simd]`",
		"E0080", "A constant value failed to get evaluated.",
		"E0081", "A discriminant value is present more than once.",
		"E0084", "An unsupported representation was attempted on a zero-variant enum.",
		"E0087", "#### Note: this error code is no longer emitted by the compiler.",
		"E0088", "#### Note: this error code is no longer emitted by the compiler.",
		"E0089", "#### Note: this error code is no longer emitted by the compiler.",
		"E0090", "#### Note: this error code is no longer emitted by the compiler.",
		"E0091", "An unnecessary type parameter was given in a type alias.",
		"E0092", "#### Note: this error code is no longer emitted by the compiler.",
		"E0093", "An unknown intrinsic function was declared.",
		"E0094", "An invalid number of generic parameters was passed to an intrinsic function.",
		"E0106", "This error indicates that a lifetime is missing from a type. If it is an error",
		"E0107", "An incorrect number of generic arguments was provided.",
		"E0109", "You tried to provide a generic argument to a type which doesn't need it.",
		"E0110", "#### Note: this error code is no longer emitted by the compiler.",
		"E0116", "An inherent implementation was defined for a type outside the current crate.",
		"E0117", "Only traits defined in the current crate can be implemented for arbitrary types.",
		"E0118", "An inherent implementation was defined for something which isn't a struct,",
		"E0119", "There are conflicting trait implementations for the same type.",
		"E0120", "`Drop` was implemented on a trait object or reference, which is not allowed;",
		"E0121", "The type placeholder `_` was used within a type on an item's signature.",
		"E0124", "A struct was declared with two fields having the same name.",
		"E0128", "A type parameter with default value is using forward declared identifier.",
		"E0130", "A pattern was declared as an argument in a foreign function declaration.",
		"E0131", "The `main` function was defined with generic parameters.",
		"E0132", "#### Note: this error code is no longer emitted by the compiler.",
		"E0133", "Unsafe code was used outside of an unsafe block.",
		"E0136", "#### Note: this error code is no longer emitted by the compiler.",
		"E0137", "#### Note: this error code is no longer emitted by the compiler.",
		"E0138", "#### Note: this error code is no longer emitted by the compiler.",
		"E0139", "#### Note: this error code is no longer emitted by the compiler.",
		"E0152", "A lang item was redefined.",
		"E0154", "#### Note: this error code is no longer emitted by the compiler.",
		"E0158", "A generic parameter or `static` has been referenced in a pattern.",
		"E0161", "A value was moved whose size was not known at compile time.",
		"E0162", "#### Note: this error code is no longer emitted by the compiler.",
		"E0164", "Something which is neither a tuple struct nor a tuple variant was used as a",
		"E0165", "#### Note: this error code is no longer emitted by the compiler.",
		"E0170", "A pattern binding is using the same name as one of the variants of a type.",
		"E0178", "The `+` type operator was used in an ambiguous context.",
		"E0183", "Manual implementation of a `Fn*` trait.",
		"E0184", "The `Copy` trait was implemented on a type with a `Drop` implementation.",
		"E0185", "An associated function for a trait was defined to be static, but an",
		"E0186", "An associated function for a trait was defined to be a method (i.e., to take a",
		"E0191", "An associated type wasn't specified for a trait object.",
		"E0192", "#### Note: this error code is no longer emitted by the compiler.",
		"E0193", "#### Note: this error code is no longer emitted by the compiler.",
		"E0195", "The lifetime parameters of the method do not match the trait declaration.",
		"E0197", "An inherent implementation was marked unsafe.",
		"E0198", "A negative implementation was marked as unsafe.",
		"E0199", "A trait implementation was marked as unsafe while the trait is safe.",
		"E0200", "An unsafe trait was implemented without an unsafe implementation.",
		"E0201", "Two associated items (like methods, associated types, associated functions,",
		"E0203", "Having duplicate relaxed default bounds is unsupported.",
		"E0204", "The `Copy` trait was implemented on a type which contains a field that doesn't",
		"E0205", "#### Note: this error code is no longer emitted by the compiler.",
		"E0206", "The `Copy` trait was implemented on a type which is neither a struct, an",
		"E0207", "A type, const or lifetime parameter that is specified for `impl` is not",
		"E0208", "#### This error code is internal to the compiler and will not be emitted with normal Rust code.",
		"E0210", "This error indicates a violation of one of Rust's orphan rules for trait",
		"E0211", "#### Note: this error code is no longer emitted by the compiler.",
		"E0212", "Cannot use the associated type of",
		"E0214", "A generic type was described using parentheses rather than angle brackets.",
		"E0220", "The associated type used was not defined in the trait.",
		"E0221", "An attempt was made to retrieve an associated type, but the type was ambiguous.",
		"E0222", "An attempt was made to constrain an associated type.",
		"E0223", "An attempt was made to retrieve an associated type, but the type was ambiguous.",
		"E0224", "A trait object was declared with no traits.",
		"E0225", "Multiple types were used as bounds for a closure or trait object.",
		"E0226", "More than one explicit lifetime bound was used on a trait object.",
		"E0227", "This error indicates that the compiler is unable to determine whether there is",
		"E0228", "The lifetime bound for this object type cannot be deduced from context and must",
		"E0229", "An associated item constraint was written in an unexpected context.",
		"E0230", "The `#[rustc_on_unimplemented]` attribute lets you specify a custom error",
		"E0231", "The `#[rustc_on_unimplemented]` attribute lets you specify a custom error",
		"E0232", "The `#[rustc_on_unimplemented]` attribute lets you specify a custom error",
		"E0243", "#### Note: this error code is no longer emitted by the compiler.",
		"E0244", "#### Note: this error code is no longer emitted by the compiler.",
		"E0251", "#### Note: this error code is no longer emitted by the compiler.",
		"E0252", "Two items of the same name cannot be imported without rebinding one of the",
		"E0253", "#### Note: this error code is no longer emitted by the compiler.",
		"E0254", "Attempt was made to import an item whereas an extern crate with this name has",
		"E0255", "You can't import a value whose name is the same as another value defined in the",
		"E0256", "#### Note: this error code is no longer emitted by the compiler.",
		"E0259", "The name chosen for an external crate conflicts with another external crate",
		"E0260", "The name for an item declaration conflicts with an external crate's name.",
		"E0261", "An undeclared lifetime was used.",
		"E0262", "An invalid name was used for a lifetime parameter.",
		"E0263", "#### Note: this error code is no longer emitted by the compiler.",
		"E0264", "An unknown external lang item was used.",
		"E0267", "A loop keyword (`break` or `continue`) was used inside a closure but outside of",
		"E0268", "A loop keyword (`break` or `continue`) was used outside of a loop.",
		"E0271", "A type mismatched an associated type of a trait.",
		"E0275", "An evaluation of a trait requirement overflowed.",
		"E0276", "A trait implementation has stricter requirements than the trait definition.",
		"E0277", "You tried to use a type which doesn't implement some trait in a place which",
		"E0281", "#### Note: this error code is no longer emitted by the compiler.",
		"E0282", "The compiler could not infer a type and asked for a type annotation.",
		"E0283", "The compiler could not infer a type and asked for a type annotation.",
		"E0284", "This error occurs when the compiler is unable to unambiguously infer the",
		"E0297", "#### Note: this error code is no longer emitted by the compiler.",
		"E0301", "#### Note: this error code is no longer emitted by the compiler.",
		"E0302", "#### Note: this error code is no longer emitted by the compiler.",
		"E0303", "#### Note: this error code is no longer emitted by the compiler.",
		"E0307", "The `self` parameter in a method has an invalid \"receiver type\".",
		"E0308", "Expected type did not match the received type.",
		"E0309", "A parameter type is missing an explicit lifetime bound and may not live long",
		"E0310", "A parameter type is missing a lifetime constraint or has a lifetime that",
		"E0311", "This error occurs when there is an unsatisfied outlives bound involving an",
		"E0312", "#### Note: this error code is no longer emitted by the compiler.",
		"E0316", "A `where` clause contains a nested quantification over lifetimes.",
		"E0317", "An `if` expression is missing an `else` block.",
		"E0320", "Recursion limit reached while creating drop-check rules.",
		"E0321", "A cross-crate opt-out trait was implemented on something which wasn't a struct",
		"E0322", "A built-in trait was implemented explicitly. All implementations of the trait",
		"E0323", "An associated const was implemented when another trait item was expected.",
		"E0324", "A method was implemented when another trait item was expected.",
		"E0325", "An associated type was implemented when another trait item was expected.",
		"E0326", "An implementation of a trait doesn't match the type constraint.",
		"E0328", "The Unsize trait should not be implemented directly. All implementations of",
		"E0329", "#### Note: this error code is no longer emitted by the compiler.",
		"E0364", "Private items cannot be publicly re-exported. This error indicates that you",
		"E0365", "Private modules cannot be publicly re-exported. This error indicates that you",
		"E0366", "An attempt was made to implement `Drop` on a concrete specialization of a",
		"E0367", "An attempt was made to implement `Drop` on a specialization of a generic type.",
		"E0368", "A binary assignment operator like `+=` or `^=` was applied to a type that",
		"E0369", "A binary operation was attempted on a type which doesn't support it.",
		"E0370", "The maximum value of an enum was reached, so it cannot be automatically",
		"E0371", "A trait was implemented on another which already automatically implemented it.",
		"E0373", "A captured variable in a closure may not live long enough.",
		"E0374", "`CoerceUnsized` or `DispatchFromDyn` was implemented on a struct which does not",
		"E0375", "`CoerceUnsized` or `DispatchFromDyn` was implemented on a struct which contains",
		"E0376", "#### Note: this error code is no longer emitted by the compiler.",
		"E0377", "`CoerceUnsized` or `DispatchFromDyn` may only be implemented between structs",
		"E0378", "The `DispatchFromDyn` trait was implemented on something which is not a pointer",
		"E0379", "A trait method was declared const.",
		"E0380", "An auto trait was declared with a method or an associated item.",
		"E0381", "It is not allowed to use or capture an uninitialized variable.",
		"E0382", "A variable was used after its contents have been moved elsewhere.",
		"E0383", "#### Note: this error code is no longer emitted by the compiler.",
		"E0384", "An immutable variable was reassigned.",
		"E0386", "#### Note: this error code is no longer emitted by the compiler.",
		"E0387", "#### Note: this error code is no longer emitted by the compiler.",
		"E0388", "#### Note: this error code is no longer emitted by the compiler.",
		"E0389", "#### Note: this error code is no longer emitted by the compiler.",
		"E0390", "A method or constant was implemented on a primitive type.",
		"E0391", "A type dependency cycle has been encountered.",
		"E0392", "A type or lifetime parameter has been declared but is not actually used.",
		"E0393", "A type parameter which references `Self` in its default value was not specified.",
		"E0398", "#### Note: this error code is no longer emitted by the compiler.",
		"E0399", "#### Note: this error code is no longer emitted by the compiler",
		"E0401", "Inner items do not inherit the generic parameters from the items",
		"E0403", "Some type parameters have the same name.",
		"E0404", "A type that is not a trait was used in a trait position, such as a bound",
		"E0405", "The code refers to a trait that is not in scope.",
		"E0407", "A definition of a method not in the implemented trait was given in a trait",
		"E0408", "An \"or\" pattern was used where the variable bindings are not consistently bound",
		"E0409", "An \"or\" pattern was used where the variable bindings are not consistently bound",
		"E0411", "The `Self` keyword was used outside an impl, trait, or type definition.",
		"E0412", "A used type name is not in scope.",
		"E0415", "More than one function parameter have the same name.",
		"E0416", "An identifier is bound more than once in a pattern.",
		"E0422", "An identifier that is neither defined nor a struct was used.",
		"E0423", "An identifier was used like a function name or a value was expected and the",
		"E0424", "The `self` keyword was used inside of an associated function without a \"`self`",
		"E0425", "An unresolved name was used.",
		"E0426", "An undeclared label was used.",
		"E0428", "A type or module has been defined more than once.",
		"E0429", "The `self` keyword cannot appear alone as the last segment in a `use`",
		"E0430", "The `self` import appears more than once in the list.",
		"E0431", "An invalid `self` import was made.",
		"E0432", "An import was unresolved.",
		"E0433", "An undeclared crate, module, or type was used.",
		"E0434", "A variable used inside an inner function comes from a dynamic environment.",
		"E0435", "A non-constant value was used in a constant expression.",
		"E0436", "The functional record update syntax was used on something other than a struct.",
		"E0437", "An associated type whose name does not match any of the associated types",
		"E0438", "An associated constant whose name does not match any of the associated constants",
		"E0439", "#### Note: this error code is no longer emitted by the compiler.",
		"E0445", "#### Note: this error code is no longer emitted by the compiler.",
		"E0446", "A private type or trait was used in a public associated type signature.",
		"E0447", "#### Note: this error code is no longer emitted by the compiler.",
		"E0448", "#### Note: this error code is no longer emitted by the compiler.",
		"E0449", "A visibility qualifier was used where one is not permitted. Visibility",
		"E0451", "A struct constructor with private fields was invoked.",
		"E0452", "An invalid lint attribute has been given.",
		"E0453", "A lint check attribute was overruled by a `forbid` directive set as an",
		"E0454", "A link name was given with an empty name.",
		"E0455", "Some linking kinds are target-specific and not supported on all platforms.",
		"E0457", "#### Note: this error code is no longer emitted by the compiler",
		"E0458", "An unknown \"kind\" was specified for a link attribute.",
		"E0459", "A link was used without a name parameter.",
		"E0460", "Found possibly newer version of crate `..` which `..` depends on.",
		"E0461", "Couldn't find crate `..` with expected target triple `..`.",
		"E0462", "Found `staticlib` `..` instead of `rlib` or `dylib`.",
		"E0463", "A crate was declared but cannot be found.",
		"E0464", "The compiler found multiple library files with the requested crate name.",
		"E0466", "#### Note: this error code is no longer emitted by the compiler.",
		"E0468", "A non-root module tried to import macros from another crate.",
		"E0469", "A macro listed for import was not found.",
		"E0472", "Inline assembly (`asm!`) is not supported on this target.",
		"E0476", "The coerced type does not outlive the value being coerced to.",
		"E0477", "#### Note: this error code is no longer emitted by the compiler.",
		"E0478", "A lifetime bound was not satisfied.",
		"E0482", "#### Note: this error code is no longer emitted by the compiler.",
		"E0491", "A reference has a longer lifetime than the data it references.",
		"E0492", "A borrow of a constant containing interior mutability was attempted.",
		"E0493", "A value with a custom `Drop` implementation may be dropped during const-eval.",
		"E0495", "#### Note: this error code is no longer emitted by the compiler.",
		"E0496", "A lifetime name is shadowing another lifetime name.",
		"E0497", "#### Note: this error code is no longer emitted by the compiler.",
		"E0498", "#### Note: this error code is no longer emitted by the compiler.",
		"E0499", "A variable was borrowed as mutable more than once.",
		"E0500", "A borrowed variable was used by a closure.",
		"E0501", "A mutable variable is used but it is already captured by a closure.",
		"E0502", "A variable already borrowed with a certain mutability (either mutable or",
		"E0503", "A value was used after it was mutably borrowed.",
		"E0504", "#### Note: this error code is no longer emitted by the compiler.",
		"E0505", "A value was moved out while it was still borrowed.",
		"E0506", "An attempt was made to assign to a borrowed value.",
		"E0507", "A borrowed value was moved out.",
		"E0508", "A value was moved out of a non-copy fixed-size array.",
		"E0509", "This error occurs when an attempt is made to move out of a value whose type",
		"E0510", "The matched value was assigned in a match guard.",
		"E0511", "Invalid monomorphization of an intrinsic function was used.",
		"E0512", "Transmute with two differently sized types was attempted.",
		"E0514", "Dependency compiled with different version of `rustc`.",
		"E0515", "A reference to a local variable was returned.",
		"E0516", "The `typeof` keyword is currently reserved but unimplemented.",
		"E0517", "A `#[repr(..)]` attribute was placed on an unsupported item.",
		"E0518", "An `#[inline(..)]` attribute was incorrectly placed on something other than a",
		"E0519", "The current crate is indistinguishable from one of its dependencies, in terms",
		"E0520", "A non-default implementation was already made on this type so it cannot be",
		"E0521", "Borrowed data escapes outside of closure.",
		"E0522", "The lang attribute was used in an invalid context.",
		"E0523", "#### Note: this error code is no longer emitted by the compiler.",
		"E0524", "A variable which requires unique access is being used in more than one closure",
		"E0525", "A closure was used but didn't implement the expected trait.",
		"E0527", "The number of elements in an array or slice pattern differed from the number of",
		"E0528", "An array or slice pattern required more elements than were present in the",
		"E0529", "An array or slice pattern was matched against some other type.",
		"E0530", "A binding shadowed something it shouldn't.",
		"E0531", "An unknown tuple struct/variant has been used.",
		"E0532", "Pattern arm did not match expected kind.",
		"E0533", "An item which isn't a unit struct, a variant, nor a constant has been used as a",
		"E0534", "#### Note: this error code is no longer emitted by the compiler",
		"E0535", "#### Note: this error code is no longer emitted by the compiler",
		"E0536", "The `not` cfg-predicate was malformed.",
		"E0537", "An unknown predicate was used inside the `cfg` attribute.",
		"E0538", "Attribute contains same meta item more than once.",
		"E0539", "An invalid meta-item was used inside an attribute.",
		"E0541", "An unknown meta item was used.",
		"E0542", "The `since` value is missing in a stability attribute.",
		"E0543", "The `note` value is missing in a stability attribute.",
		"E0544", "Multiple stability attributes were declared on the same item.",
		"E0545", "The `issue` value is incorrect in a stability attribute.",
		"E0546", "The `feature` value is missing in a stability attribute.",
		"E0547", "The `issue` value is missing in a stability attribute.",
		"E0549", "A `deprecated` attribute wasn't paired with a `stable`/`unstable` attribute with",
		"E0550", "#### Note: this error code is no longer emitted by the compiler",
		"E0551", "#### Note: this error code is no longer emitted by the compiler",
		"E0552", "A unrecognized representation attribute was used.",
		"E0554", "Feature attributes are only allowed on the nightly release channel. Stable or",
		"E0556", "The `feature` attribute was badly formed.",
		"E0557", "A feature attribute named a feature that has been removed.",
		"E0559", "An unknown field was specified into an enum's structure variant.",
		"E0560", "An unknown field was specified into a structure.",
		"E0561", "A non-ident or non-wildcard pattern has been used as a parameter of a function",
		"E0562", "Abstract return types (written `impl Trait` for some trait `Trait`) are only",
		"E0565", "A literal was used in a built-in attribute that doesn't support literals.",
		"E0566", "Conflicting representation hints have been used on a same item.",
		"E0567", "Generics have been used on an auto trait.",
		"E0568", "A super trait has been added to an auto trait.",
		"E0569", "If an impl has a generic parameter with the `#[may_dangle]` attribute, then",
		"E0570", "The requested ABI is unsupported by the current target.",
		"E0571", "A `break` statement with an argument appeared in a non-`loop` loop.",
		"E0572", "A return statement was found outside of a function body.",
		"E0573", "Something other than a type has been used when one was expected.",
		"E0574", "Something other than a struct, variant or union has been used when one was",
		"E0575", "Something other than a type or an associated type was given.",
		"E0576", "An associated item wasn't found in the given type.",
		"E0577", "Something other than a module was found in visibility scope.",
		"E0578", "A module cannot be found and therefore, the visibility cannot be determined.",
		"E0579", "A lower range wasn't less than the upper range.",
		"E0580", "The `main` function was incorrectly declared.",
		"E0581", "In a `fn` type, a lifetime appears only in the return type",
		"E0582", "A lifetime is only present in an associated-type binding, and not in the input",
		"E0583", "A file wasn't found for an out-of-line module.",
		"E0584", "A doc comment that is not attached to anything has been encountered.",
		"E0585", "A documentation comment that doesn't document anything was found.",
		"E0586", "An inclusive range was used with no end.",
		"E0587", "A type has both `packed` and `align` representation hints.",
		"E0588", "A type with `packed` representation hint has a field with `align`",
		"E0589", "The value of `N` that was specified for `repr(align(N))` was not a power",
		"E0590", "`break` or `continue` keywords were used in a condition of a `while` loop",
		"E0591", "Per [RFC 401][rfc401], if you have a function declaration `foo`:",
		"E0592", "This error occurs when you defined methods or associated functions with same",
		"E0593", "You tried to supply an `Fn`-based type with an incorrect number of arguments",
		"E0594", "A non-mutable value was assigned a value.",
		"E0595", "#### Note: this error code is no longer emitted by the compiler.",
		"E0596", "This error occurs because you tried to mutably borrow a non-mutable variable.",
		"E0597", "This error occurs because a value was dropped while it was still borrowed.",
		"E0599", "This error occurs when a method is used on a type which doesn't implement it:",
		"E0600", "An unary operator was used on a type which doesn't implement it.",
		"E0601", "No `main` function was found in a binary crate.",
		"E0602", "An unknown or invalid lint was used on the command line.",
		"E0603", "A private item was used outside its scope.",
		"E0604", "A cast to `char` was attempted on a type other than `u8`.",
		"E0605", "An invalid cast was attempted.",
		"E0606", "An incompatible cast was attempted.",
		"E0607", "A cast between a thin and a wide pointer was attempted.",
		"E0608", "An attempt to use index on a type which doesn't implement the `std::ops::Index`",
		"E0609", "Attempted to access a nonexistent field in a struct.",
		"E0610", "Attempted to access a field on a primitive type.",
		"E0614", "Attempted to dereference a variable which cannot be dereferenced.",
		"E0615", "Attempted to access a method like a field.",
		"E0616", "Attempted to access a private field on a struct.",
		"E0617", "Attempted to pass an invalid type of variable into a variadic function.",
		"E0618", "Attempted to call something which isn't a function nor a method.",
		"E0619", "#### Note: this error code is no longer emitted by the compiler.",
		"E0620", "A cast to an unsized type was attempted.",
		"E0621", "This error code indicates a mismatch between the lifetimes appearing in the",
		"E0622", "#### Note: this error code is no longer emitted by the compiler.",
		"E0623", "A lifetime didn't match what was expected.",
		"E0624", "A private item was used outside of its scope.",
		"E0625", "A compile-time const variable is referring to a thread-local static variable.",
		"E0626", "This error occurs because a borrow in a movable coroutine persists across a",
		"E0627", "A yield expression was used outside of the coroutine literal.",
		"E0628", "More than one parameter was used for a coroutine.",
		"E0631", "This error indicates a type mismatch in closure arguments.",
		"E0632", "#### Note: this error code is no longer emitted by the compiler.",
		"E0633", "#### Note: this error code is no longer emitted by the compiler.",
		"E0634", "A type has conflicting `packed` representation hints.",
		"E0635", "The `#![feature]` attribute specified an unknown feature.",
		"E0636", "The same feature is enabled multiple times with `#![feature]` attributes",
		"E0637", "`'_` lifetime name or `&T` without an explicit lifetime name has been used",
		"E0638", "This error indicates that the struct, enum or enum variant must be matched",
		"E0639", "This error indicates that the struct, enum or enum variant cannot be",
		"E0640", "#### This error code is internal to the compiler and will not be emitted with normal Rust code.",
		"E0641", "Attempted to cast to/from a pointer with an unknown kind.",
		"E0642", "Trait methods currently cannot take patterns as arguments.",
		"E0643", "This error indicates that there is a mismatch between generic parameters and",
		"E0644", "A closure or generator was constructed that references its own type.",
		"E0646", "It is not possible to define `main` with a where clause.",
		"E0647", "#### Note: this error code is no longer emitted by the compiler.",
		"E0648", "An `export_name` attribute contains null characters (`\\0`).",
		"E0657", "An `impl Trait` captured a higher-ranked lifetime, which is not supported.",
		"E0658", "An unstable feature was used.",
		"E0659", "An item usage is ambiguous.",
		"E0660", "#### Note: this error code is no longer emitted by the compiler.",
		"E0661", "#### Note: this error code is no longer emitted by the compiler.",
		"E0662", "#### Note: this error code is no longer emitted by the compiler.",
		"E0663", "#### Note: this error code is no longer emitted by the compiler.",
		"E0664", "#### Note: this error code is no longer emitted by the compiler.",
		"E0665", "The `Default` trait was derived on an enum without specifying the default",
		"E0666", "`impl Trait` types cannot appear nested in the generic arguments of other",
		"E0667", "#### Note: this error code is no longer emitted by the compiler.",
		"E0668", "#### Note: this error code is no longer emitted by the compiler.",
		"E0669", "#### Note: this error code is no longer emitted by the compiler.",
		"E0670", "Rust 2015 does not permit the use of `async fn`.",
		"E0671", "#### Note: this error code is no longer emitted by the compiler.",
		"E0687", "#### Note: this error code is no longer emitted by the compiler.",
		"E0688", "#### Note: this error code is no longer emitted by the compiler.",
		"E0689", "A method was called on an ambiguous numeric type.",
		"E0690", "A struct with the representation hint `repr(transparent)` had two or more fields",
		"E0691", "#### Note: this error code is no longer emitted by the compiler.",
		"E0692", "A `repr(transparent)` type was also annotated with other, incompatible",
		"E0693", "`align` representation hint was incorrectly declared.",
		"E0695", "A `break` statement without a label appeared inside a labeled block.",
		"E0696", "A function is using `continue` keyword incorrectly.",
		"E0697", "A closure has been used as `static`.",
		"E0698", "#### Note: this error code is no longer emitted by the compiler.",
		"E0699", "#### Note: this error code is no longer emitted by the compiler.",
		"E0700", "The `impl Trait` return type captures lifetime parameters that do not",
		"E0701", "This error indicates that a `#[non_exhaustive]` attribute was incorrectly placed",
		"E0703", "Invalid ABI (Application Binary Interface) used in the code.",
		"E0704", "An incorrect visibility restriction was specified.",
		"E0705", "#### Note: this error code is no longer emitted by the compiler.",
		"E0706", "#### Note: this error code is no longer emitted by the compiler.",
		"E0708", "#### Note: this error code is no longer emitted by the compiler.",
		"E0710", "An unknown tool name was found in a scoped lint.",
		"E0712", "A borrow of a thread-local variable was made inside a function which outlived",
		"E0713", "This error occurs when an attempt is made to borrow state past the end of the",
		"E0714", "A `#[marker]` trait contained an associated item.",
		"E0715", "An `impl` for a `#[marker]` trait tried to override an associated item.",
		"E0716", "A temporary value is being dropped while a borrow is still in active use.",
		"E0711", "#### This error code is internal to the compiler and will not be emitted with normal Rust code.",
		"E0717", "#### This error code is internal to the compiler and will not be emitted with normal Rust code.",
		"E0718", "A `#[lang = \"..\"]` attribute was placed on the wrong item type.",
		"E0719", "An associated type value was specified more than once.",
		"E0720", "An `impl Trait` type expands to a recursive type.",
		"E0722", "#### Note: this error code is no longer emitted by the compiler",
		"E0724", "#### Note: this error code is no longer emitted by the compiler.",
		"E0725", "A feature attribute named a feature that was disallowed in the compiler",
		"E0726", "An argument lifetime was elided in an async function.",
		"E0727", "A `yield` clause was used in an `async` context.",
		"E0728", "[`await`] has been used outside [`async`] function or [`async`] block.",
		"E0729", "#### Note: this error code is no longer emitted by the compiler",
		"E0730", "An array without a fixed length was pattern-matched.",
		"E0731", "An enum with the representation hint `repr(transparent)` had zero or more than",
		"E0732", "An `enum` with a discriminant must specify a `#[repr(inttype)]`.",
		"E0733", "An [`async`] function used recursion without boxing.",
		"E0734", "A stability attribute has been used outside of the standard library.",
		"E0735", "Type parameter defaults cannot use `Self` on structs, enums, or unions.",
		"E0736", "Functions marked with the `#[naked]` attribute are restricted in what other",
		"E0737", "`#[track_caller]` requires functions to have the `\"Rust\"` ABI for implicitly",
		"E0739", "`#[track_caller]` must  be applied to a function",
		"E0740", "A `union` was declared with fields with destructors.",
		"E0741", "A non-structural-match type was used as the type of a const generic parameter.",
		"E0742", "Visibility is restricted to a module which isn't an ancestor of the current",
		"E0743", "The C-variadic type `...` has been nested inside another type.",
		"E0744", "#### Note: this error code is no longer emitted by the compiler.",
		"E0745", "The address of temporary value was taken.",
		"E0746", "An unboxed trait object was used as a return value.",
		"E0747", "Generic arguments were not provided in the same order as the corresponding",
		"E0748", "A raw string isn't correctly terminated because the trailing `#` count doesn't",
		"E0749", "An item was added on a negative impl.",
		"E0750", "A negative impl was made default impl.",
		"E0751", "There are both a positive and negative trait implementation for the same type.",
		"E0752", "The entry point of the program was marked as `async`.",
		"E0753", "An inner doc comment was used in an invalid context.",
		"E0754", "A non-ASCII identifier was used in an invalid context.",
		"E0755", "The `ffi_pure` attribute was used on a non-foreign function.",
		"E0756", "The `ffi_const` attribute was used on something other than a foreign function",
		"E0757", "A function was given both the `ffi_const` and `ffi_pure` attributes.",
		"E0758", "A multi-line (doc-)comment is unterminated.",
		"E0759", "#### Note: this error code is no longer emitted by the compiler.",
		"E0760", "#### Note: this error code is no longer emitted by the compiler.",
		"E0761", "Multiple candidate files were found for an out-of-line module.",
		"E0762", "A character literal wasn't ended with a quote.",
		"E0763", "A byte constant wasn't correctly ended.",
		"E0764", "A mutable reference was used in a constant.",
		"E0765", "A double quote string (`\"`) was not terminated.",
		"E0766", "A double quote byte string (`b\"`) was not terminated.",
		"E0767", "An unreachable label was used.",
		"E0768", "A number in a non-decimal base has no digits.",
		"E0769", "A tuple struct or tuple variant was used in a pattern as if it were a struct or",
		"E0770", "The type of a const parameter references other generic parameters.",
		"E0771", "#### Note: this error code is no longer emitted by the compiler",
		"E0772", "#### Note: this error code is no longer emitted by the compiler.",
		"E0773", "#### this error code is no longer emitted by the compiler.",
		"E0774", "`derive` was applied on something which is not a struct, a union or an enum.",
		"E0775", "#### Note: this error code is no longer emitted by the compiler.",
		"E0776", "#### Note: this error code is no longer emitted by the compiler.",
		"E0777", "A literal value was used inside `#[derive]`.",
		"E0778", "The `instruction_set` attribute was malformed.",
		"E0779", "An unknown argument was given to the `instruction_set` attribute.",
		"E0780", "Cannot use `doc(inline)` with anonymous imports",
		"E0781", "The `cmse-nonsecure-call` ABI can only be used with function pointers.",
		"E0782", "Trait objects must include the `dyn` keyword.",
		"E0783", "The range pattern `...` is no longer allowed.",
		"E0784", "A union expression does not have exactly one field.",
		"E0785", "An inherent `impl` was written on a dyn auto trait.",
		"E0786", "A metadata file was invalid.",
		"E0787", "An unsupported naked function definition.",
		"E0788", "A `#[coverage(off|on)]` attribute was found in a position where it is not",
		"E0789", "#### This error code is internal to the compiler and will not be emitted with normal Rust code.",
		"E0790", "You need to specify a specific implementation of the trait in order to call the",
		"E0791", "Static variables with the `#[linkage]` attribute within external blocks",
		"E0792", "A type alias impl trait can only have its hidden type assigned",
		"E0793", "An unaligned reference to a field of a [packed] struct got created.",
		"E0794", "A lifetime parameter of a function definition is called *late-bound* if it both:",
		"E0795", "Invalid argument for the `offset_of!` macro.",
		"E0796", "#### Note: this error code is no longer emitted by the compiler.",
		"E0797", "Struct update syntax was used without a base expression.",
		"E0798", "Functions marked as `cmse-nonsecure-call` place restrictions on their",
		"E0799", "Something other than a type or const parameter has been used when one was",
		"E0800", "A type or const parameter of the given name is not in scope.",
		"E0801", "The `self` parameter in a method has an invalid generic \"receiver type\".",
		"E0802", "The target of `derive(CoercePointee)` macro has inadmissible specification for",
		"E0803", "A trait implementation returns a reference without an",
		"E0804", "An auto trait cannot be added to the bounds of a `dyn Trait` type via",
		"E080", "An attribute was given an invalid number of arguments",
	).Tag("error codes").Uid("rust", "error-code")
}
