// Code generated by chezmoi.io/chezmoi/internal/cmds/generate-helps. DO NOT EDIT.

package cmd

import (
	"chezmoi.io/chezmoi/internal/chezmoiset"
)

type help struct {
	longHelp   string
	example    string
	longFlags  chezmoiset.Set[string]
	shortFlags chezmoiset.Set[string]
}

var helps = map[string]*help{
	"add": {
		longHelp: "" +
			"  Add targets to the source state. If any target is already in the source\n" +
			"  state, then its source state is replaced with its current state in the\n" +
			"  destination directory.",
		example: "" +
			"  chezmoi add ~/.bashrc\n" +
			"  chezmoi add ~/.gitconfig --template\n" +
			"  chezmoi add ~/.ssh/id_rsa --encrypt\n" +
			"  chezmoi add ~/.vim --recursive\n" +
			"  chezmoi add ~/.oh-my-zsh --exact --recursive",
		longFlags: chezmoiset.New(
			"autotemplate",
			"create",
			"encrypt",
			"exact",
			"exclude",
			"follow",
			"force",
			"include",
			"prompt",
			"quiet",
			"recursive",
			"secrets",
			"template",
			"template-symlinks",
		),
		shortFlags: chezmoiset.New(
			"T",
			"a",
			"f",
			"i",
			"p",
			"q",
			"r",
			"x",
		),
	},
	"age": {
		longHelp: "" +
			"  Interact with age's passphrase-based encryption.",
		example: "" +
			"  chezmoi age encrypt --passphrase plaintext.txt > ciphertext.txt\n" +
			"  chezmoi age decrypt --passphrase ciphertext.txt > decrypted-ciphertext.txt",
	},
	"age-keygen": {
		longHelp: "" +
			"  Generate an age identity or convert an age identity to an age recipient.",
		example: "" +
			"  chezmoi age-keygen\n" +
			"  chezmoi age-keygen -o identity.txt\n" +
			"  chezmoi age-keygen -y identity.txt",
		longFlags: chezmoiset.New(
			"convert",
		),
		shortFlags: chezmoiset.New(
			"y",
		),
	},
	"apply": {
		longHelp: "" +
			"  Ensure that target... are in the target state, updating them if necessary.\n" +
			"  If no targets are specified, the state of all targets are ensured. If a\n" +
			"  target has been modified since chezmoi last wrote it then the user will be\n" +
			"  prompted if they want to overwrite the file.",
		example: "" +
			"  chezmoi apply\n" +
			"  chezmoi apply --dry-run --verbose\n" +
			"  chezmoi apply ~/.bashrc",
		longFlags: chezmoiset.New(
			"exclude",
			"include",
			"init",
			"parent-dirs",
			"recursive",
			"source-path",
		),
		shortFlags: chezmoiset.New(
			"P",
			"i",
			"r",
			"x",
		),
	},
	"archive": {
		longHelp: "" +
			"  Generate an archive of the target state, or only the targets specified. This\n" +
			"  can be piped into tar to inspect the target state.",
		example: "" +
			"  chezmoi archive | tar tvf -\n" +
			"  chezmoi archive --output=dotfiles.tar.gz\n" +
			"  chezmoi archive --output=dotfiles.zip",
		longFlags: chezmoiset.New(
			"exclude",
			"format",
			"gzip",
			"include",
			"init",
			"parent-dirs",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"P",
			"f",
			"i",
			"r",
			"x",
			"z",
		),
	},
	"cat": {
		longHelp: "" +
			"  Write the target contents of targets to stdout. targets must be files,\n" +
			"  scripts, or symlinks. For files, the target file contents are written. For\n" +
			"  scripts, the script's contents are written. For symlinks, the target is\n" +
			"  written.",
		example: "" +
			"  chezmoi cat ~/.bashrc",
	},
	"cat-config": {
		longHelp: "" +
			"  Print the configuration file.",
		example: "" +
			"  chezmoi cat-config",
	},
	"cd": {
		longHelp: "" +
			"  Launch a shell in the working tree (typically the source directory). chezmoi\n" +
			"  will launch the command set by the cd.command configuration variable with\n" +
			"  any extra arguments specified by cd.args. If this is not set, chezmoi will\n" +
			"  attempt to detect your shell and finally fall back to an OS-specific default.\n" +
			"\n" +
			"  If the optional argument path is present, the shell will be launched in the\n" +
			"  source directory corresponding to path.\n" +
			"\n" +
			"  The shell will have various CHEZMOI* environment variables set, as for\n" +
			"  scripts.",
		example: "" +
			"  chezmoi cd\n" +
			"  chezmoi cd ~\n" +
			"  chezmoi cd ~/.config",
	},
	"chattr": {
		longHelp: "" +
			"  Change the attributes and/or type of targets. modifier specifies what to\n" +
			"  modify.\n" +
			"\n" +
			"  Add attributes by specifying them or their abbreviations directly,\n" +
			"  optionally prefixed with a plus sign (+). Remove attributes by prefixing\n" +
			"  them or their attributes with the string no or a minus sign (-). The\n" +
			"  available attribute modifiers and their abbreviations are:\n" +
			"\n" +
			"   Attribute modifier                  | Abbreviation\n" +
			"  -------------------------------------|------------------------------------\n" +
			"   after                               | a\n" +
			"   before                              | b\n" +
			"   empty                               | e\n" +
			"   encrypted                           | none\n" +
			"   exact                               | none\n" +
			"   executable                          | x\n" +
			"   external                            | none\n" +
			"   once                                | o\n" +
			"   private                             | p\n" +
			"   readonly                            | r\n" +
			"   remove                              | none\n" +
			"   template                            | t\n" +
			"\n" +
			"  The type of a target can be changed using a type modifier:\n" +
			"\n" +
			"   Type modifier\n" +
			"  --------------------------------------------------------------------------\n" +
			"   create\n" +
			"   modify\n" +
			"   script\n" +
			"   symlink\n" +
			"\n" +
			"  The negative form of type modifiers, e.g. nocreate, changes the target to be\n" +
			"  a regular file if it is of that type, otherwise the type is left unchanged.\n" +
			"\n" +
			"  Multiple modifications may be specified by separating them with a comma (,).\n" +
			"  If you use the -modifier form then you must put modifier after a -- to\n" +
			"  prevent\n" +
			"  chezmoi from interpreting -modifier as an option.",
		example: "" +
			"  chezmoi chattr template ~/.bashrc\n" +
			"  chezmoi chattr noempty ~/.profile\n" +
			"  chezmoi chattr private,template ~/.netrc\n" +
			"  chezmoi chattr -- -x ~/.zshrc\n" +
			"  chezmoi chattr +create,+private ~/.kube/config",
		longFlags: chezmoiset.New(
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"r",
		),
	},
	"completion": {
		longHelp: "" +
			"  Generate shell completion code for the specified shell (bash, fish,\n" +
			"  powershell, or zsh).",
		example: "" +
			"  chezmoi completion bash\n" +
			"  chezmoi completion fish --output=~/.config/fish/completions/chezmoi.fish",
	},
	"data": {
		longHelp: "" +
			"  Write the computed template data to stdout.",
		example: "" +
			"  chezmoi data\n" +
			"  chezmoi data --format=yaml",
		longFlags: chezmoiset.New(
			"format",
		),
		shortFlags: chezmoiset.New(
			"f",
		),
	},
	"decrypt": {
		longHelp: "" +
			"  Decrypt files using chezmoi's configured encryption. If no files are given,\n" +
			"  decrypt the standard input. The decrypted result is written to the standard\n" +
			"  output or a file if the --output flag is set.",
	},
	"destroy": {
		longHelp: "" +
			"  Remove target from the source state, the destination directory, and the\n" +
			"  state.",
		longFlags: chezmoiset.New(
			"force",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"r",
		),
	},
	"diff": {
		longHelp: "" +
			"  Print the difference between the target state and the destination state for\n" +
			"  targets. If no targets are specified, print the differences for all targets.\n" +
			"\n" +
			"  If a diff.pager command is set in the configuration file then the output\n" +
			"  will be piped into it.\n" +
			"\n" +
			"  If diff.command is set then it will be invoked to show individual file\n" +
			"  differences with diff.args passed as arguments. Each element of diff.args is\n" +
			"  interpreted as a template with the variables .Destination and .Target\n" +
			"  available corresponding to the path of the file in the source and target\n" +
			"  state respectively. The default value of diff.args is [\"{{ .Destination }}\",\n" +
			"  \"{{ .Target }}\"]. If diff.args does not contain any template arguments then\n" +
			"  {{ .Destination }} and {{ .Target }} will be appended automatically.",
		example: "" +
			"  chezmoi diff\n" +
			"  chezmoi diff ~/.bashrc",
		longFlags: chezmoiset.New(
			"exclude",
			"include",
			"init",
			"pager",
			"parent-dirs",
			"recursive",
			"reverse",
			"script-contents",
		),
		shortFlags: chezmoiset.New(
			"P",
			"i",
			"r",
			"x",
		),
	},
	"docker": {
		example: "" +
			"  chezmoi docker exec $CONTAINER_ID $GITHUB_USERNAME\n" +
			"  chezmoi docker run -p apk alpine:latest $GITHUB_USERNAME",
	},
	"doctor": {
		longHelp: "" +
			"  Check for potential problems.",
		example: "" +
			"  chezmoi doctor",
		longFlags: chezmoiset.New(
			"no-network",
		),
	},
	"dump": {
		longHelp: "" +
			"  Dump the target state of targets. If no targets are specified, then the\n" +
			"  entire target state.",
		example: "" +
			"  chezmoi dump ~/.bashrc\n" +
			"  chezmoi dump --format=yaml",
		longFlags: chezmoiset.New(
			"exclude",
			"format",
			"include",
			"init",
			"parent-dirs",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"P",
			"f",
			"i",
			"r",
			"x",
		),
	},
	"dump-config": {
		longHelp: "" +
			"  Dump the configuration.",
		example: "" +
			"  chezmoi dump-config",
		longFlags: chezmoiset.New(
			"format",
		),
		shortFlags: chezmoiset.New(
			"f",
		),
	},
	"edit": {
		longHelp: "" +
			"  Edit the source state of targets, which must be files or symlinks. If no\n" +
			"  targets are given then the working tree of the source directory is opened.\n" +
			"\n" +
			"  Encrypted files are decrypted to a private temporary directory and the\n" +
			"  editor is invoked with the decrypted file. When the editor exits the edited\n" +
			"  decrypted file is re-encrypted and replaces the original file in the source\n" +
			"  state.\n" +
			"\n" +
			"  If the operating system supports hard links, then the edit command invokes\n" +
			"  the editor with filenames which match the target filename, unless the\n" +
			"  edit.hardlink configuration variable is set to false or the --hardlink=false\n" +
			"  command line flag is set. Templates preserve their .tmpl extension so\n" +
			"  editors can highlight them as templates.",
		example: "" +
			"  chezmoi edit ~/.bashrc\n" +
			"  chezmoi edit ~/.bashrc --apply\n" +
			"  chezmoi edit",
		longFlags: chezmoiset.New(
			"apply",
			"exclude",
			"hardlink",
			"include",
			"init",
			"watch",
		),
		shortFlags: chezmoiset.New(
			"a",
			"i",
			"x",
		),
	},
	"edit-config": {
		longHelp: "" +
			"  Edit the configuration file.",
		example: "" +
			"  chezmoi edit-config",
	},
	"edit-config-template": {
		longHelp: "" +
			"  Edit the configuration file template. If no configuration file template\n" +
			"  exists, then a new one is created with the contents of the current config\n" +
			"  file.",
		example: "" +
			"  chezmoi edit-config-template",
	},
	"encrypt": {
		longHelp: "" +
			"  Encrypt files using chezmoi's configured encryption. If no files are given,\n" +
			"  encrypt the standard input. The encrypted result is written to the standard\n" +
			"  output or a file if the --output flag is set.",
	},
	"execute-template": {
		longHelp: "" +
			"  Execute templates. This is useful for testing templates or for calling\n" +
			"  chezmoi from other scripts. templates are interpreted as literal templates,\n" +
			"  with no whitespace added to the output between arguments. If no templates\n" +
			"  are specified, the template is read from stdin.",
		example: "" +
			"  chezmoi execute-template '{{ .chezmoi.sourceDir }}'\n" +
			"  chezmoi execute-template '{{ .chezmoi.os }}' / '{{ .chezmoi.arch }}'\n" +
			"  echo '{{ .chezmoi | toJson }}' | chezmoi execute-template\n" +
			"  chezmoi execute-template --init --promptString email=me@home.org < ~/.\n" +
			"local/share/chezmoi/.chezmoi.toml.tmpl",
		longFlags: chezmoiset.New(
			"file",
			"init",
			"left-delimiter",
			"promptBool",
			"promptChoice",
			"promptInt",
			"promptMultichoice",
			"promptString",
			"right-delimiter",
			"stdinisatty",
			"with-stdin",
		),
		shortFlags: chezmoiset.New(
			"f",
			"i",
			"p",
		),
	},
	"forget": {
		longHelp: "" +
			"  Remove targets from the source state, i.e. stop managing them. targets must\n" +
			"  have entries in the source state. They cannot be externals.",
		example: "" +
			"  chezmoi forget ~/.bashrc",
	},
	"generate": {
		longHelp: "" +
			"  Generates output for use with chezmoi. The currently supported outputs are:\n" +
			"\n" +
			"   Output                | Description\n" +
			"  -----------------------|--------------------------------------------------\n" +
			"   git-commit-message    | A git commit message, describing the changes to\n" +
			"                         | the source directory.\n" +
			"   install.sh            | An install script, suitable for use with GitHub\n" +
			"                         | Codespaces\n" +
			"   install-init-shell.sh | A script which installs chezmoi, runs chezmoi\n" +
			"                         | init, and executes your shell",
		example: "" +
			"  chezmoi generate install.sh > install.sh\n" +
			"  chezmoi git commit -m \"$(chezmoi generate git-commit-message)\"\n" +
			"  chezmoi generate install-init-shell.sh $GITHUB_USERNAME",
	},
	"git": {
		longHelp: "" +
			"  Run git args in the working tree (typically the source directory).",
		example: "" +
			"  chezmoi git add .\n" +
			"  chezmoi git add dot_gitconfig\n" +
			"  chezmoi git -- commit -m \"Add .gitconfig\"",
	},
	"help": {
		longHelp: "" +
			"  Print the help associated with command, or general help if no command is\n" +
			"  given.",
	},
	"ignored": {
		longHelp: "" +
			"  Print the list of entries ignored by chezmoi.",
		example: "" +
			"  chezmoi ignored",
		longFlags: chezmoiset.New(
			"nul-path-separator",
			"tree",
		),
		shortFlags: chezmoiset.New(
			"0",
			"t",
		),
	},
	"import": {
		longHelp: "" +
			"  Import the source state from an archive file in to a directory in the source\n" +
			"  state. This is primarily used to make subdirectories of your home directory\n" +
			"  exactly match the contents of a downloaded archive. You will generally\n" +
			"  always want to set the --destination, --exact, and --remove-destination\n" +
			"  flags.\n" +
			"\n" +
			"  The supported archive formats are rar, tar, tar.gz, tgz, tar.bz2, tbz2, txz,\n" +
			"  tar.zst, and zip.",
		example: "" +
			"  curl -s -L -o ${TMPDIR}/oh-my-zsh-master.tar.gz https://github.\n" +
			"com/ohmyzsh/ohmyzsh/archive/master.tar.gz\n" +
			"  mkdir -p $(chezmoi source-path)/dot_oh-my-zsh\n" +
			"  chezmoi import --strip-components 1 --destination ~/.oh-my-zsh ${TMPDIR}/oh-my-\n" +
			"zsh-master.tar.gz",
		longFlags: chezmoiset.New(
			"destination",
			"exact",
			"exclude",
			"include",
			"remove-destination",
			"strip-components",
		),
		shortFlags: chezmoiset.New(
			"d",
			"i",
			"r",
			"x",
		),
	},
	"init": {
		longHelp: "" +
			"  Setup the source directory, generate the config file, and optionally update\n" +
			"  the destination directory to match the target state. This is done in the\n" +
			"  following order:\n" +
			"\n" +
			"  1. The source directory is initialized. If chezmoi does not detect a Git\n" +
			"  repository in the source directory, chezmoi will clone the provided repo\n" +
			"  into the source directory. If no repo is provided, chezmoi will initialize\n" +
			"  a new Git repository.\n" +
			"  2. If the initialized source directory contains a .chezmoi.$FORMAT.tmpl file,\n" +
			"  a new configuration file will be created using that file as a template.\n" +
			"  3. If the --apply flag is provided, chezmoi apply is run.\n" +
			"  4. If the --purge flag is provided, chezmoi will remove the source, config,\n" +
			"  and cache directories.\n" +
			"  5. If the --purge-binary is passed, chezmoi will attempt to remove its own\n" +
			"  binary.\n" +
			"\n" +
			"  By default, if repo is given, chezmoi will guess the full git repo URL,\n" +
			"  using HTTPS by default, or SSH if the --ssh option is specified, according\n" +
			"  to\n" +
			"  the following patterns:\n" +
			"\n" +
			"   Pattern          | HTTPS Repo                | SSH repo\n" +
			"  ------------------|---------------------------|---------------------------\n" +
			"   user             | https://user@github.com/u | git@github.com:user/dotfi\n" +
			"                    | ser/dotfiles.git          | les.git\n" +
			"   user/repo        | https://user@github.com/u | git@github.com:user/repo.\n" +
			"                    | ser/repo.git              | git\n" +
			"   site/user/repo   | https://user@site/user/re | git@site:user/repo.git\n" +
			"                    | po.git                    |\n" +
			"   sr.ht/~user      | https://user@git.sr.ht/~u | git@git.sr.ht:~user/dotfi\n" +
			"                    | ser/dotfiles              | les.git\n" +
			"   sr.ht/~user/repo | https://user@git.sr.ht/~u | git@git.sr.ht:~user/repo.\n" +
			"                    | ser/repo                  | git\n" +
			"\n" +
			"  To disable git repo URL guessing, pass the --guess-repo-url=false option.",
		example: "" +
			"  chezmoi init user\n" +
			"  chezmoi init user --apply\n" +
			"  chezmoi init user --apply --purge\n" +
			"  chezmoi init user/dots\n" +
			"  chezmoi init codeberg.org/user\n" +
			"  chezmoi init gitlab.com/user",
		longFlags: chezmoiset.New(
			"apply",
			"branch",
			"config-path",
			"data",
			"depth",
			"exclude",
			"git-lfs",
			"guess-repo-url",
			"include",
			"one-shot",
			"prompt",
			"promptBool",
			"promptChoice",
			"promptDefaults",
			"promptInt",
			"promptMultichoice",
			"promptString",
			"purge",
			"purge-binary",
			"recurse-submodules",
			"ssh",
		),
		shortFlags: chezmoiset.New(
			"C",
			"P",
			"a",
			"d",
			"g",
			"i",
			"p",
			"x",
		),
	},
	"license": {
		longHelp: "" +
			"  Print chezmoi's license.",
		example: "" +
			"  chezmoi license",
	},
	"list": {
		longHelp: "" +
			"  list is an alias for managed.",
	},
	"manage": {
		longHelp: "" +
			"  manage is an alias for add for symmetry with unmanage.",
	},
	"managed": {
		longHelp: "" +
			"  List all managed entries in the destination directory under all paths in\n" +
			"  alphabetical order. When no paths are supplied, list all managed entries in\n" +
			"  the destination directory in alphabetical order.",
		example: "" +
			"  chezmoi managed\n" +
			"  chezmoi managed --include=files\n" +
			"  chezmoi managed --include=files,symlinks\n" +
			"  chezmoi managed -i dirs\n" +
			"  chezmoi managed -i dirs,files\n" +
			"  chezmoi managed -i files ~/.config\n" +
			"  chezmoi managed --exclude=encrypted --path-style=source-relative",
		longFlags: chezmoiset.New(
			"exclude",
			"format",
			"include",
			"nul-path-separator",
			"path-style",
			"tree",
		),
		shortFlags: chezmoiset.New(
			"0",
			"f",
			"i",
			"p",
			"t",
			"x",
		),
	},
	"merge": {
		longHelp: "" +
			"  Perform a three-way merge between the destination state, the target state,\n" +
			"  and the source state for each target. The merge tool is defined by the\n" +
			"  merge.command configuration variable, and defaults to vimdiff. If multiple\n" +
			"  targets are specified the merge tool is invoked separately and sequentially\n" +
			"  for each target. If the target state cannot be computed (for example if\n" +
			"  source is a template containing errors or an encrypted file that cannot be\n" +
			"  decrypted) a two-way merge is performed instead.\n" +
			"\n" +
			"  The order of arguments to merge.command is set by merge.args. Each argument\n" +
			"  is interpreted as a template with the variables .Destination, .Source, and\n" +
			"  .Target available corresponding to the path of the file in the destination\n" +
			"  state, the source state, and the target state respectively. The default\n" +
			"  value of merge.args is [\"{{ .Destination }}\", \"{{ .Source }}\", \"{{ .Target\n" +
			"  }}\"]. If merge.args does not contain any template arguments then {{\n" +
			"  .Destination }}, {{ .Source }}, and {{ .Target }} will be appended\n" +
			"  automatically.",
		example: "" +
			"  chezmoi merge ~/.bashrc",
	},
	"merge-all": {
		longHelp: "" +
			"  Perform a three-way merge for file whose actual state does not match its\n" +
			"  target state. The merge is performed with chezmoi merge.",
		example: "" +
			"  chezmoi merge-all",
		longFlags: chezmoiset.New(
			"init",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"r",
		),
	},
	"purge": {
		longHelp: "" +
			"  Remove chezmoi's configuration, state, and source directory, but leave the\n" +
			"  target state intact.",
		example: "" +
			"  chezmoi purge\n" +
			"  chezmoi purge --force",
		longFlags: chezmoiset.New(
			"binary",
			"force",
		),
		shortFlags: chezmoiset.New(
			"P",
		),
	},
	"re-add": {
		longHelp: "" +
			"  Re-add modified files in the target state, preserving any encrypted_\n" +
			"  attributes. chezmoi will not overwrite templates, and all entries that are\n" +
			"  not files are ignored. Directories are recursed into by default.\n" +
			"\n" +
			"  If no targets are specified then all modified files are re-added. If one or\n" +
			"  more targets are given then only those targets are re-added.",
		example: "" +
			"  chezmoi re-add\n" +
			"  chezmoi re-add ~/.bashrc\n" +
			"  chezmoi re-add --recursive=false ~/.config/git",
		longFlags: chezmoiset.New(
			"exclude",
			"include",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"i",
			"r",
			"x",
		),
	},
	"remove": {
		longHelp: "" +
			"  The remove command has been removed. Use the forget command or the destroy\n" +
			"  command instead.",
	},
	"rm": {
		longHelp: "" +
			"  The rm command has been removed. Use the forget command or the destroy\n" +
			"  command instead.",
	},
	"secret": {
		longHelp: "" +
			"  Run a secret manager's CLI, passing any extra arguments to the secret\n" +
			"  manager's CLI. This is primarily for verifying chezmoi's integration with a\n" +
			"  custom secret manager. Normally you would use chezmoi's existing template\n" +
			"  functions to retrieve secrets.",
		example: "" +
			"  chezmoi secret keyring set --service=service --user=user --value=password\n" +
			"  chezmoi secret keyring get --service=service --user=user\n" +
			"  chezmoi secret keyring delete --service=service --user=user",
	},
	"source-path": {
		longHelp: "" +
			"  Print the path to each target's source state. If no targets are specified\n" +
			"  then print the source directory.",
		example: "" +
			"  chezmoi source-path\n" +
			"  chezmoi source-path ~/.bashrc",
	},
	"ssh": {
		longHelp: "" +
			"  SSH to host, install chezmoi, run chezmoi init --apply *init-args*, and\n" +
			"  executes your shell.",
		example: "" +
			"  chezmoi ssh $HOSTNAME $GITHUB_USERNAME\n" +
			"  chezmoi ssh $HOSTNAME -- --one-shot $GITHUB_USERNAME",
		longFlags: chezmoiset.New(
			"package-manager",
			"shell",
		),
		shortFlags: chezmoiset.New(
			"p",
			"s",
		),
	},
	"state": {
		longHelp: "" +
			"  Manipulate the persistent state.",
		example: "" +
			"  chezmoi state data\n" +
			"  chezmoi state delete --bucket=$BUCKET --key=$KEY\n" +
			"  chezmoi state delete-bucket --bucket=$BUCKET\n" +
			"  chezmoi state dump\n" +
			"  chezmoi state get --bucket=$BUCKET --key=$KEY\n" +
			"  chezmoi state get-bucket --bucket=$BUCKET\n" +
			"  chezmoi state set --bucket=$BUCKET --key=$KEY --value=$VALUE\n" +
			"  chezmoi state reset",
	},
	"status": {
		longHelp: "" +
			"  Print the status of the files and scripts managed by chezmoi in a format\n" +
			"  similar to git status.\n" +
			"\n" +
			"  The first column of output indicates the difference between the last state\n" +
			"  written by chezmoi and the actual state. The second column indicates the\n" +
			"  difference between the actual state and the target state, and what effect\n" +
			"  running chezmoi apply will have.\n" +
			"\n" +
			"   Character    | Meaning     | First column       | Second column\n" +
			"  --------------|-------------|--------------------|------------------------\n" +
			"   Space        | No change   | No change          | No change\n" +
			"   A            | Added       | Entry was created  | Entry will be created\n" +
			"   D            | Deleted     | Entry was deleted  | Entry will be deleted\n" +
			"   M            | Modified    | Entry was modified | Entry will be modified\n" +
			"   R            | Run         | Not applicable     | Script will be run",
		example: "" +
			"  chezmoi status",
		longFlags: chezmoiset.New(
			"exclude",
			"include",
			"init",
			"parent-dirs",
			"path-style",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"P",
			"i",
			"p",
			"r",
			"x",
		),
	},
	"target-path": {
		longHelp: "" +
			"  Print the target path of each source path. If no source paths are specified\n" +
			"  then print the target directory.",
		example: "" +
			"  chezmoi target-path\n" +
			"  chezmoi target-path ~/.local/share/chezmoi/dot_zshrc",
	},
	"unmanage": {
		longHelp: "" +
			"  unmanage is an alias for forget for symmetry with manage.",
	},
	"unmanaged": {
		longHelp: "" +
			"  List all unmanaged files in paths. When no paths are supplied, list all\n" +
			"  unmanaged files in the destination directory.\n" +
			"\n" +
			"  It is an error to supply paths that are not found on the file system.",
		example: "" +
			"  chezmoi unmanaged\n" +
			"  chezmoi unmanaged ~/.config/chezmoi ~/.ssh",
		longFlags: chezmoiset.New(
			"nul-path-separator",
			"path-style",
			"tree",
		),
		shortFlags: chezmoiset.New(
			"0",
			"p",
			"t",
		),
	},
	"update": {
		longHelp: "" +
			"  Pull changes from the source repo and apply any changes.\n" +
			"\n" +
			"  If update.command is set then chezmoi will run update.command with\n" +
			"  update.args in the working tree. Otherwise, chezmoi will run git pull --\n" +
			"  autostash --rebase [--recurse-submodules] , using chezmoi's builtin git if\n" +
			"  useBuiltinGit is true or if git.command cannot be found in $PATH.",
		example: "" +
			"  chezmoi update",
		longFlags: chezmoiset.New(
			"apply",
			"exclude",
			"include",
			"init",
			"parent-dirs",
			"recurse-submodules",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"P",
			"a",
			"i",
			"r",
			"x",
		),
	},
	"upgrade": {
		longHelp: "" +
			"  Upgrade chezmoi by downloading and installing the latest released version.\n" +
			"  This will call the GitHub API to determine if there is a new version of\n" +
			"  chezmoi available, and if so, download and attempt to install it in the same\n" +
			"  way as chezmoi was previously installed.\n" +
			"\n" +
			"  If the any of the $CHEZMOI_GITHUB_ACCESS_TOKEN, $CHEZMOI_GITHUB_TOKEN,\n" +
			"  $GITHUB_ACCESS_TOKEN, or $GITHUB_TOKEN environment variables are set, then\n" +
			"  the first value found will be used to authenticate requests to the GitHub\n" +
			"  API, otherwise unauthenticated requests are used which are subject to\n" +
			"  stricter rate limiting. Unauthenticated requests should be sufficient for\n" +
			"  most cases.",
		longFlags: chezmoiset.New(
			"executable",
			"method",
		),
	},
	"verify": {
		longHelp: "" +
			"  Verify that all targets match their target state. chezmoi exits with code 0\n" +
			"  (success) if all targets match their target state, or 1 (failure) otherwise.\n" +
			"  If no targets are specified then all targets are checked.",
		example: "" +
			"  chezmoi verify\n" +
			"  chezmoi verify ~/.bashrc",
		longFlags: chezmoiset.New(
			"exclude",
			"include",
			"init",
			"parent-dirs",
			"recursive",
		),
		shortFlags: chezmoiset.New(
			"P",
			"i",
			"r",
			"x",
		),
	},
}
