# hcloud: Command-line interface for Hetzner Cloud

[![Release](https://img.shields.io/github/v/release/hetznercloud/cli)](https://github.com/hetznercloud/cli/releases/latest)
![Go Version](https://img.shields.io/github/go-mod/go-version/hetznercloud/cli/main?label=Go)
[![CI](https://github.com/hetznercloud/cli/actions/workflows/ci.yml/badge.svg)](https://github.com/hetznercloud/cli/actions/workflows/ci.yml)
[![Build](https://github.com/hetznercloud/cli/actions/workflows/build.yml/badge.svg)](https://github.com/hetznercloud/cli/actions/workflows/build.yml)
[![codecov](https://codecov.io/gh/hetznercloud/cli/graph/badge.svg?token=fFDgg6Ua6U)](https://codecov.io/gh/hetznercloud/cli)

`hcloud` is a command-line interface for interacting with Hetzner Cloud.

[![asciicast](https://asciinema.org/a/157991.png)](https://asciinema.org/a/157991)

## Docs

- See [setting up hcloud](docs/tutorials/setup-hcloud-cli.md) for instructions on how to install and configure the CLI.
- See the [manual](docs/reference/manual/hcloud.md) for a list of all available commands and their options.

For additional information, see the [documentation](docs).

## Experimental features

Experimental features are published as part of our regular releases (e.g. a product
public beta). During an experimental phase, breaking changes on those features may occur
within minor releases.

The stability of experimental features is not related to the stability of its upstream API.

Experimental features have different levels of maturity (e.g. experimental, alpha, beta)
based on the maturity of the upstream API.

While experimental features will be announced in the release notes, you can also find
whether a command is experimental in its help text. Using experimental commands will show a warning
when running them. You can suppress this warning by enabling the `no-experimental-warnings` option.

## License

MIT license

