package mappers

var TypeDefMap = map[string]typeDefMap{
	"file": {
		1:  {Name: "device"},
		2:  {Name: "settings"},
		3:  {Name: "sport"},
		4:  {Name: "activity"},
		5:  {Name: "workout"},
		6:  {Name: "course"},
		7:  {Name: "schedules"},
		9:  {Name: "weight"},
		10: {Name: "totals"},
		11: {Name: "goals"},
		14: {Name: "blood_pressure"},
		15: {Name: "monitoring_a"},
		20: {Name: "activity_summary"},
		28: {Name: "monitoring_daily"},
		32: {Name: "monitoring_b"},
		34: {Name: "segment"},
		35: {Name: "segment_list"},
		40: {Name: "exd_configuration"},
	},
	"mesg_num": {
		0:   {Name: "file_id"},
		1:   {Name: "capabilities"},
		2:   {Name: "device_settings"},
		3:   {Name: "user_profile"},
		4:   {Name: "hrm_profile"},
		5:   {Name: "sdm_profile"},
		6:   {Name: "bike_profile"},
		7:   {Name: "zones_target"},
		8:   {Name: "hr_zone"},
		9:   {Name: "power_zone"},
		10:  {Name: "met_zone"},
		12:  {Name: "sport"},
		15:  {Name: "goal"},
		18:  {Name: "session"},
		19:  {Name: "lap"},
		20:  {Name: "record"},
		21:  {Name: "event"},
		23:  {Name: "device_info"},
		26:  {Name: "workout"},
		27:  {Name: "workout_step"},
		28:  {Name: "schedule"},
		30:  {Name: "weight_scale"},
		31:  {Name: "course"},
		32:  {Name: "course_point"},
		33:  {Name: "totals"},
		34:  {Name: "activity"},
		35:  {Name: "software"},
		37:  {Name: "file_capabilities"},
		38:  {Name: "mesg_capabilities"},
		39:  {Name: "field_capabilities"},
		49:  {Name: "file_creator"},
		51:  {Name: "blood_pressure"},
		53:  {Name: "speed_zone"},
		55:  {Name: "monitoring"},
		72:  {Name: "training_file"},
		78:  {Name: "hrv"},
		80:  {Name: "ant_rx"},
		81:  {Name: "ant_tx"},
		82:  {Name: "ant_channel_id"},
		101: {Name: "length"},
		103: {Name: "monitoring_info"},
		105: {Name: "pad"},
		106: {Name: "slave_device"},
		127: {Name: "connectivity"},
		128: {Name: "weather_conditions"},
		129: {Name: "weather_alert"},
		131: {Name: "cadence_zone"},
		132: {Name: "hr"},
		142: {Name: "segment_lap"},
		145: {Name: "memo_glob"},
		148: {Name: "segment_id"},
		149: {Name: "segment_leaderboard_entry"},
		150: {Name: "segment_point"},
		151: {Name: "segment_file"},
		158: {Name: "workout_session"},
		159: {Name: "watchface_settings"},
		160: {Name: "gps_metadata"},
		161: {Name: "camera_event"},
		162: {Name: "timestamp_correlation"},
		164: {Name: "gyroscope_data"},
		165: {Name: "accelerometer_data"},
		167: {Name: "three_d_sensor_calibration"},
		169: {Name: "video_frame"},
		174: {Name: "obdii_data"},
		177: {Name: "nmea_sentence"},
		178: {Name: "aviation_attitude"},
		184: {Name: "video"},
		185: {Name: "video_title"},
		186: {Name: "video_description"},
		187: {Name: "video_clip"},
		188: {Name: "ohr_settings"},
		200: {Name: "exd_screen_configuration"},
		201: {Name: "exd_data_field_configuration"},
		202: {Name: "exd_data_concept_configuration"},
		206: {Name: "field_description"},
		207: {Name: "developer_data_id"},
		208: {Name: "magnetometer_data"},
		209: {Name: "barometer_data"},
		210: {Name: "one_d_sensor_calibration"},
		211: {Name: "monitoring_hr_data"},
		216: {Name: "time_in_zone"},
		225: {Name: "set"},
		227: {Name: "stress_level"},
		229: {Name: "max_met_data"},
		258: {Name: "dive_settings"},
		259: {Name: "dive_gas"},
		262: {Name: "dive_alarm"},
		264: {Name: "exercise_title"},
		268: {Name: "dive_summary"},
		269: {Name: "spo2_data"},
		275: {Name: "sleep_level"},
		285: {Name: "jump"},
		290: {Name: "beat_intervals"},
		297: {Name: "respiration_rate"},
		312: {Name: "split"},
		313: {Name: "split_summary"},
		317: {Name: "climb_pro"},
		319: {Name: "tank_update"},
		323: {Name: "tank_summary"},
		346: {Name: "sleep_assessment"},
		370: {Name: "hrv_status_summary"},
		371: {Name: "hrv_value"},
		375: {Name: "device_aux_battery_info"},
		393: {Name: "dive_apnea_alarm"},
	},
	"checksum": {
		0: {Name: "clear"},
		1: {Name: "ok"},
	},
	"file_flags": {},
	"mesg_count": {
		0: {Name: "num_per_file"},
		1: {Name: "max_per_file"},
		2: {Name: "max_per_file_type"},
	},
	"date_time":       {},
	"local_date_time": {},
	"message_index":   {},
	"device_index": {
		0: {Name: "creator"},
	},
	"gender": {
		0: {Name: "female"},
		1: {Name: "male"},
	},
	"language": {
		0:   {Name: "english"},
		1:   {Name: "french"},
		2:   {Name: "italian"},
		3:   {Name: "german"},
		4:   {Name: "spanish"},
		5:   {Name: "croatian"},
		6:   {Name: "czech"},
		7:   {Name: "danish"},
		8:   {Name: "dutch"},
		9:   {Name: "finnish"},
		10:  {Name: "greek"},
		11:  {Name: "hungarian"},
		12:  {Name: "norwegian"},
		13:  {Name: "polish"},
		14:  {Name: "portuguese"},
		15:  {Name: "slovakian"},
		16:  {Name: "slovenian"},
		17:  {Name: "swedish"},
		18:  {Name: "russian"},
		19:  {Name: "turkish"},
		20:  {Name: "latvian"},
		21:  {Name: "ukrainian"},
		22:  {Name: "arabic"},
		23:  {Name: "farsi"},
		24:  {Name: "bulgarian"},
		25:  {Name: "romanian"},
		26:  {Name: "chinese"},
		27:  {Name: "japanese"},
		28:  {Name: "korean"},
		29:  {Name: "taiwanese"},
		30:  {Name: "thai"},
		31:  {Name: "hebrew"},
		32:  {Name: "brazilian_portuguese"},
		33:  {Name: "indonesian"},
		34:  {Name: "malaysian"},
		35:  {Name: "vietnamese"},
		36:  {Name: "burmese"},
		37:  {Name: "mongolian"},
		254: {Name: "custom"},
	},
	"language_bits_0": {},
	"language_bits_1": {},
	"language_bits_2": {},
	"language_bits_3": {},
	"language_bits_4": {},
	"time_zone": {
		0:   {Name: "almaty"},
		1:   {Name: "bangkok"},
		2:   {Name: "bombay"},
		3:   {Name: "brasilia"},
		4:   {Name: "cairo"},
		5:   {Name: "cape_verde_is"},
		6:   {Name: "darwin"},
		7:   {Name: "eniwetok"},
		8:   {Name: "fiji"},
		9:   {Name: "hong_kong"},
		10:  {Name: "islamabad"},
		11:  {Name: "kabul"},
		12:  {Name: "magadan"},
		13:  {Name: "mid_atlantic"},
		14:  {Name: "moscow"},
		15:  {Name: "muscat"},
		16:  {Name: "newfoundland"},
		17:  {Name: "samoa"},
		18:  {Name: "sydney"},
		19:  {Name: "tehran"},
		20:  {Name: "tokyo"},
		21:  {Name: "us_alaska"},
		22:  {Name: "us_atlantic"},
		23:  {Name: "us_central"},
		24:  {Name: "us_eastern"},
		25:  {Name: "us_hawaii"},
		26:  {Name: "us_mountain"},
		27:  {Name: "us_pacific"},
		28:  {Name: "other"},
		29:  {Name: "auckland"},
		30:  {Name: "kathmandu"},
		31:  {Name: "europe_western_wet"},
		32:  {Name: "europe_central_cet"},
		33:  {Name: "europe_eastern_eet"},
		34:  {Name: "jakarta"},
		35:  {Name: "perth"},
		36:  {Name: "adelaide"},
		37:  {Name: "brisbane"},
		38:  {Name: "tasmania"},
		39:  {Name: "iceland"},
		40:  {Name: "amsterdam"},
		41:  {Name: "athens"},
		42:  {Name: "barcelona"},
		43:  {Name: "berlin"},
		44:  {Name: "brussels"},
		45:  {Name: "budapest"},
		46:  {Name: "copenhagen"},
		47:  {Name: "dublin"},
		48:  {Name: "helsinki"},
		49:  {Name: "lisbon"},
		50:  {Name: "london"},
		51:  {Name: "madrid"},
		52:  {Name: "munich"},
		53:  {Name: "oslo"},
		54:  {Name: "paris"},
		55:  {Name: "prague"},
		56:  {Name: "reykjavik"},
		57:  {Name: "rome"},
		58:  {Name: "stockholm"},
		59:  {Name: "vienna"},
		60:  {Name: "warsaw"},
		61:  {Name: "zurich"},
		62:  {Name: "quebec"},
		63:  {Name: "ontario"},
		64:  {Name: "manitoba"},
		65:  {Name: "saskatchewan"},
		66:  {Name: "alberta"},
		67:  {Name: "british_columbia"},
		68:  {Name: "boise"},
		69:  {Name: "boston"},
		70:  {Name: "chicago"},
		71:  {Name: "dallas"},
		72:  {Name: "denver"},
		73:  {Name: "kansas_city"},
		74:  {Name: "las_vegas"},
		75:  {Name: "los_angeles"},
		76:  {Name: "miami"},
		77:  {Name: "minneapolis"},
		78:  {Name: "new_york"},
		79:  {Name: "new_orleans"},
		80:  {Name: "phoenix"},
		81:  {Name: "santa_fe"},
		82:  {Name: "seattle"},
		83:  {Name: "washington_dc"},
		84:  {Name: "us_arizona"},
		85:  {Name: "chita"},
		86:  {Name: "ekaterinburg"},
		87:  {Name: "irkutsk"},
		88:  {Name: "kaliningrad"},
		89:  {Name: "krasnoyarsk"},
		90:  {Name: "novosibirsk"},
		91:  {Name: "petropavlovsk_kamchatskiy"},
		92:  {Name: "samara"},
		93:  {Name: "vladivostok"},
		94:  {Name: "mexico_central"},
		95:  {Name: "mexico_mountain"},
		96:  {Name: "mexico_pacific"},
		97:  {Name: "cape_town"},
		98:  {Name: "winkhoek"},
		99:  {Name: "lagos"},
		100: {Name: "riyahd"},
		101: {Name: "venezuela"},
		102: {Name: "australia_lh"},
		103: {Name: "santiago"},
		253: {Name: "manual"},
		254: {Name: "automatic"},
	},
	"display_measure": {
		0: {Name: "metric"},
		1: {Name: "statute"},
		2: {Name: "nautical"},
	},
	"display_heart": {
		0: {Name: "bpm"},
		1: {Name: "max"},
		2: {Name: "reserve"},
	},
	"display_power": {
		0: {Name: "watts"},
		1: {Name: "percent_ftp"},
	},
	"display_position": {
		0:  {Name: "degree"},
		1:  {Name: "degree_minute"},
		2:  {Name: "degree_minute_second"},
		3:  {Name: "austrian_grid"},
		4:  {Name: "british_grid"},
		5:  {Name: "dutch_grid"},
		6:  {Name: "hungarian_grid"},
		7:  {Name: "finnish_grid"},
		8:  {Name: "german_grid"},
		9:  {Name: "icelandic_grid"},
		10: {Name: "indonesian_equatorial"},
		11: {Name: "indonesian_irian"},
		12: {Name: "indonesian_southern"},
		13: {Name: "india_zone_0"},
		14: {Name: "india_zone_IA"},
		15: {Name: "india_zone_IB"},
		16: {Name: "india_zone_IIA"},
		17: {Name: "india_zone_IIB"},
		18: {Name: "india_zone_IIIA"},
		19: {Name: "india_zone_IIIB"},
		20: {Name: "india_zone_IVA"},
		21: {Name: "india_zone_IVB"},
		22: {Name: "irish_transverse"},
		23: {Name: "irish_grid"},
		24: {Name: "loran"},
		25: {Name: "maidenhead_grid"},
		26: {Name: "mgrs_grid"},
		27: {Name: "new_zealand_grid"},
		28: {Name: "new_zealand_transverse"},
		29: {Name: "qatar_grid"},
		30: {Name: "modified_swedish_grid"},
		31: {Name: "swedish_grid"},
		32: {Name: "south_african_grid"},
		33: {Name: "swiss_grid"},
		34: {Name: "taiwan_grid"},
		35: {Name: "united_states_grid"},
		36: {Name: "utm_ups_grid"},
		37: {Name: "west_malayan"},
		38: {Name: "borneo_rso"},
		39: {Name: "estonian_grid"},
		40: {Name: "latvian_grid"},
		41: {Name: "swedish_ref_99_grid"},
	},
	"switch": {
		0: {Name: "off"},
		1: {Name: "on"},
		2: {Name: "auto"},
	},
	"sport": {
		0:   {Name: "generic"},
		1:   {Name: "running"},
		2:   {Name: "cycling"},
		3:   {Name: "transition"},
		4:   {Name: "fitness_equipment"},
		5:   {Name: "swimming"},
		6:   {Name: "basketball"},
		7:   {Name: "soccer"},
		8:   {Name: "tennis"},
		9:   {Name: "american_football"},
		10:  {Name: "training"},
		11:  {Name: "walking"},
		12:  {Name: "cross_country_skiing"},
		13:  {Name: "alpine_skiing"},
		14:  {Name: "snowboarding"},
		15:  {Name: "rowing"},
		16:  {Name: "mountaineering"},
		17:  {Name: "hiking"},
		18:  {Name: "multisport"},
		19:  {Name: "paddling"},
		20:  {Name: "flying"},
		21:  {Name: "e_biking"},
		22:  {Name: "motorcycling"},
		23:  {Name: "boating"},
		24:  {Name: "driving"},
		25:  {Name: "golf"},
		26:  {Name: "hang_gliding"},
		27:  {Name: "horseback_riding"},
		28:  {Name: "hunting"},
		29:  {Name: "fishing"},
		30:  {Name: "inline_skating"},
		31:  {Name: "rock_climbing"},
		32:  {Name: "sailing"},
		33:  {Name: "ice_skating"},
		34:  {Name: "sky_diving"},
		35:  {Name: "snowshoeing"},
		36:  {Name: "snowmobiling"},
		37:  {Name: "stand_up_paddleboarding"},
		38:  {Name: "surfing"},
		39:  {Name: "wakeboarding"},
		40:  {Name: "water_skiing"},
		41:  {Name: "kayaking"},
		42:  {Name: "rafting"},
		43:  {Name: "windsurfing"},
		44:  {Name: "kitesurfing"},
		45:  {Name: "tactical"},
		46:  {Name: "jumpmaster"},
		47:  {Name: "boxing"},
		48:  {Name: "floor_climbing"},
		53:  {Name: "diving"},
		62:  {Name: "hiit"},
		64:  {Name: "racket"},
		65:  {Name: "wheelchair_push_walk"},
		66:  {Name: "wheelchair_push_run"},
		67:  {Name: "meditation"},
		76:  {Name: "water_tubing"},
		77:  {Name: "wakesurfing"},
		254: {Name: "all"},
	},
	"sport_bits_0": {},
	"sport_bits_1": {},
	"sport_bits_2": {},
	"sport_bits_3": {},
	"sport_bits_4": {},
	"sport_bits_5": {},
	"sport_bits_6": {},
	"sub_sport": {
		0:   {Name: "generic"},
		1:   {Name: "treadmill"},
		2:   {Name: "street"},
		3:   {Name: "trail"},
		4:   {Name: "track"},
		5:   {Name: "spin"},
		6:   {Name: "indoor_cycling"},
		7:   {Name: "road"},
		8:   {Name: "mountain"},
		9:   {Name: "downhill"},
		10:  {Name: "recumbent"},
		11:  {Name: "cyclocross"},
		12:  {Name: "hand_cycling"},
		13:  {Name: "track_cycling"},
		14:  {Name: "indoor_rowing"},
		15:  {Name: "elliptical"},
		16:  {Name: "stair_climbing"},
		17:  {Name: "lap_swimming"},
		18:  {Name: "open_water"},
		19:  {Name: "flexibility_training"},
		20:  {Name: "strength_training"},
		21:  {Name: "warm_up"},
		22:  {Name: "match"},
		23:  {Name: "exercise"},
		24:  {Name: "challenge"},
		25:  {Name: "indoor_skiing"},
		26:  {Name: "cardio_training"},
		27:  {Name: "indoor_walking"},
		28:  {Name: "e_bike_fitness"},
		29:  {Name: "bmx"},
		30:  {Name: "casual_walking"},
		31:  {Name: "speed_walking"},
		32:  {Name: "bike_to_run_transition"},
		33:  {Name: "run_to_bike_transition"},
		34:  {Name: "swim_to_bike_transition"},
		35:  {Name: "atv"},
		36:  {Name: "motocross"},
		37:  {Name: "backcountry"},
		38:  {Name: "resort"},
		39:  {Name: "rc_drone"},
		40:  {Name: "wingsuit"},
		41:  {Name: "whitewater"},
		42:  {Name: "skate_skiing"},
		43:  {Name: "yoga"},
		44:  {Name: "pilates"},
		45:  {Name: "indoor_running"},
		46:  {Name: "gravel_cycling"},
		47:  {Name: "e_bike_mountain"},
		48:  {Name: "commuting"},
		49:  {Name: "mixed_surface"},
		50:  {Name: "navigate"},
		51:  {Name: "track_me"},
		52:  {Name: "map"},
		53:  {Name: "single_gas_diving"},
		54:  {Name: "multi_gas_diving"},
		55:  {Name: "gauge_diving"},
		56:  {Name: "apnea_diving"},
		57:  {Name: "apnea_hunting"},
		58:  {Name: "virtual_activity"},
		59:  {Name: "obstacle"},
		62:  {Name: "breathing"},
		65:  {Name: "sail_race"},
		67:  {Name: "ultra"},
		68:  {Name: "indoor_climbing"},
		69:  {Name: "bouldering"},
		70:  {Name: "hiit"},
		73:  {Name: "amrap"},
		74:  {Name: "emom"},
		75:  {Name: "tabata"},
		84:  {Name: "pickleball"},
		85:  {Name: "padel"},
		86:  {Name: "indoor_wheelchair_walk"},
		87:  {Name: "indoor_wheelchair_run"},
		88:  {Name: "indoor_hand_cycling"},
		110: {Name: "fly_canopy"},
		111: {Name: "fly_paraglide"},
		112: {Name: "fly_paramotor"},
		113: {Name: "fly_pressurized"},
		114: {Name: "fly_navigate"},
		115: {Name: "fly_timer"},
		116: {Name: "fly_altimeter"},
		117: {Name: "fly_wx"},
		118: {Name: "fly_vfr"},
		119: {Name: "fly_ifr"},
		254: {Name: "all"},
	},
	"sport_event": {
		0: {Name: "uncategorized"},
		1: {Name: "geocaching"},
		2: {Name: "fitness"},
		3: {Name: "recreation"},
		4: {Name: "race"},
		5: {Name: "special_event"},
		6: {Name: "training"},
		7: {Name: "transportation"},
		8: {Name: "touring"},
	},
	"activity": {
		0: {Name: "manual"},
		1: {Name: "auto_multi_sport"},
	},
	"intensity": {
		0: {Name: "active"},
		1: {Name: "rest"},
		2: {Name: "warmup"},
		3: {Name: "cooldown"},
		4: {Name: "recovery"},
		5: {Name: "interval"},
		6: {Name: "other"},
	},
	"session_trigger": {
		0: {Name: "activity_end"},
		1: {Name: "manual"},
		2: {Name: "auto_multi_sport"},
		3: {Name: "fitness_equipment"},
	},
	"autolap_trigger": {
		0: {Name: "time"},
		1: {Name: "distance"},
		2: {Name: "position_start"},
		3: {Name: "position_lap"},
		4: {Name: "position_waypoint"},
		5: {Name: "position_marked"},
		6: {Name: "off"},
	},
	"lap_trigger": {
		0: {Name: "manual"},
		1: {Name: "time"},
		2: {Name: "distance"},
		3: {Name: "position_start"},
		4: {Name: "position_lap"},
		5: {Name: "position_waypoint"},
		6: {Name: "position_marked"},
		7: {Name: "session_end"},
		8: {Name: "fitness_equipment"},
	},
	"time_mode": {
		0: {Name: "hour12"},
		1: {Name: "hour24"},
		2: {Name: "military"},
		3: {Name: "hour_12_with_seconds"},
		4: {Name: "hour_24_with_seconds"},
		5: {Name: "utc"},
	},
	"backlight_mode": {
		0: {Name: "off"},
		1: {Name: "manual"},
		2: {Name: "key_and_messages"},
		3: {Name: "auto_brightness"},
		4: {Name: "smart_notifications"},
		5: {Name: "key_and_messages_night"},
		6: {Name: "key_and_messages_and_smart_notifications"},
	},
	"date_mode": {
		0: {Name: "day_month"},
		1: {Name: "month_day"},
	},
	"backlight_timeout": {
		0: {Name: "infinite"},
	},
	"event": {
		0:  {Name: "timer"},
		3:  {Name: "workout"},
		4:  {Name: "workout_step"},
		5:  {Name: "power_down"},
		6:  {Name: "power_up"},
		7:  {Name: "off_course"},
		8:  {Name: "session"},
		9:  {Name: "lap"},
		10: {Name: "course_point"},
		11: {Name: "battery"},
		12: {Name: "virtual_partner_pace"},
		13: {Name: "hr_high_alert"},
		14: {Name: "hr_low_alert"},
		15: {Name: "speed_high_alert"},
		16: {Name: "speed_low_alert"},
		17: {Name: "cad_high_alert"},
		18: {Name: "cad_low_alert"},
		19: {Name: "power_high_alert"},
		20: {Name: "power_low_alert"},
		21: {Name: "recovery_hr"},
		22: {Name: "battery_low"},
		23: {Name: "time_duration_alert"},
		24: {Name: "distance_duration_alert"},
		25: {Name: "calorie_duration_alert"},
		26: {Name: "activity"},
		27: {Name: "fitness_equipment"},
		28: {Name: "length"},
		32: {Name: "user_marker"},
		33: {Name: "sport_point"},
		36: {Name: "calibration"},
		42: {Name: "front_gear_change"},
		43: {Name: "rear_gear_change"},
		44: {Name: "rider_position_change"},
		45: {Name: "elev_high_alert"},
		46: {Name: "elev_low_alert"},
		47: {Name: "comm_timeout"},
		54: {Name: "auto_activity_detect"},
		56: {Name: "dive_alert"},
		57: {Name: "dive_gas_switched"},
		71: {Name: "tank_pressure_reserve"},
		72: {Name: "tank_pressure_critical"},
		73: {Name: "tank_lost"},
		75: {Name: "radar_threat_alert"},
		76: {Name: "tank_battery_low"},
		81: {Name: "tank_pod_connected"},
		82: {Name: "tank_pod_disconnected"},
	},
	"event_type": {
		0: {Name: "start"},
		1: {Name: "stop"},
		2: {Name: "consecutive_depreciated"},
		3: {Name: "marker"},
		4: {Name: "stop_all"},
		5: {Name: "begin_depreciated"},
		6: {Name: "end_depreciated"},
		7: {Name: "end_all_depreciated"},
		8: {Name: "stop_disable"},
		9: {Name: "stop_disable_all"},
	},
	"timer_trigger": {
		0: {Name: "manual"},
		1: {Name: "auto"},
		2: {Name: "fitness_equipment"},
	},
	"fitness_equipment_state": {
		0: {Name: "ready"},
		1: {Name: "in_use"},
		2: {Name: "paused"},
		3: {Name: "unknown"},
	},
	"tone": {
		0: {Name: "off"},
		1: {Name: "tone"},
		2: {Name: "vibrate"},
		3: {Name: "tone_and_vibrate"},
	},
	"autoscroll": {
		0: {Name: "none"},
		1: {Name: "slow"},
		2: {Name: "medium"},
		3: {Name: "fast"},
	},
	"activity_class": {
		100: {Name: "level_max"},
	},
	"hr_zone_calc": {
		0: {Name: "custom"},
		1: {Name: "percent_max_hr"},
		2: {Name: "percent_hrr"},
		3: {Name: "percent_lthr"},
	},
	"pwr_zone_calc": {
		0: {Name: "custom"},
		1: {Name: "percent_ftp"},
	},
	"wkt_step_duration": {
		0:  {Name: "time"},
		1:  {Name: "distance"},
		2:  {Name: "hr_less_than"},
		3:  {Name: "hr_greater_than"},
		4:  {Name: "calories"},
		5:  {Name: "open"},
		6:  {Name: "repeat_until_steps_cmplt"},
		7:  {Name: "repeat_until_time"},
		8:  {Name: "repeat_until_distance"},
		9:  {Name: "repeat_until_calories"},
		10: {Name: "repeat_until_hr_less_than"},
		11: {Name: "repeat_until_hr_greater_than"},
		12: {Name: "repeat_until_power_less_than"},
		13: {Name: "repeat_until_power_greater_than"},
		14: {Name: "power_less_than"},
		15: {Name: "power_greater_than"},
		16: {Name: "training_peaks_tss"},
		17: {Name: "repeat_until_power_last_lap_less_than"},
		18: {Name: "repeat_until_max_power_last_lap_less_than"},
		19: {Name: "power_3s_less_than"},
		20: {Name: "power_10s_less_than"},
		21: {Name: "power_30s_less_than"},
		22: {Name: "power_3s_greater_than"},
		23: {Name: "power_10s_greater_than"},
		24: {Name: "power_30s_greater_than"},
		25: {Name: "power_lap_less_than"},
		26: {Name: "power_lap_greater_than"},
		27: {Name: "repeat_until_training_peaks_tss"},
		28: {Name: "repetition_time"},
		29: {Name: "reps"},
		31: {Name: "time_only"},
	},
	"wkt_step_target": {
		0:  {Name: "speed"},
		1:  {Name: "heart_rate"},
		2:  {Name: "open"},
		3:  {Name: "cadence"},
		4:  {Name: "power"},
		5:  {Name: "grade"},
		6:  {Name: "resistance"},
		7:  {Name: "power_3s"},
		8:  {Name: "power_10s"},
		9:  {Name: "power_30s"},
		10: {Name: "power_lap"},
		11: {Name: "swim_stroke"},
		12: {Name: "speed_lap"},
		13: {Name: "heart_rate_lap"},
	},
	"goal": {
		0: {Name: "time"},
		1: {Name: "distance"},
		2: {Name: "calories"},
		3: {Name: "frequency"},
		4: {Name: "steps"},
		5: {Name: "ascent"},
		6: {Name: "active_minutes"},
	},
	"goal_recurrence": {
		0: {Name: "off"},
		1: {Name: "daily"},
		2: {Name: "weekly"},
		3: {Name: "monthly"},
		4: {Name: "yearly"},
		5: {Name: "custom"},
	},
	"goal_source": {
		0: {Name: "auto"},
		1: {Name: "community"},
		2: {Name: "user"},
	},
	"schedule": {
		0: {Name: "workout"},
		1: {Name: "course"},
	},
	"course_point": {
		0:  {Name: "generic"},
		1:  {Name: "summit"},
		2:  {Name: "valley"},
		3:  {Name: "water"},
		4:  {Name: "food"},
		5:  {Name: "danger"},
		6:  {Name: "left"},
		7:  {Name: "right"},
		8:  {Name: "straight"},
		9:  {Name: "first_aid"},
		10: {Name: "fourth_category"},
		11: {Name: "third_category"},
		12: {Name: "second_category"},
		13: {Name: "first_category"},
		14: {Name: "hors_category"},
		15: {Name: "sprint"},
		16: {Name: "left_fork"},
		17: {Name: "right_fork"},
		18: {Name: "middle_fork"},
		19: {Name: "slight_left"},
		20: {Name: "sharp_left"},
		21: {Name: "slight_right"},
		22: {Name: "sharp_right"},
		23: {Name: "u_turn"},
		24: {Name: "segment_start"},
		25: {Name: "segment_end"},
		27: {Name: "campsite"},
		28: {Name: "aid_station"},
		29: {Name: "rest_area"},
		30: {Name: "general_distance"},
		31: {Name: "service"},
		32: {Name: "energy_gel"},
		33: {Name: "sports_drink"},
		34: {Name: "mile_marker"},
		35: {Name: "checkpoint"},
		36: {Name: "shelter"},
		37: {Name: "meeting_spot"},
		38: {Name: "overlook"},
		39: {Name: "toilet"},
		40: {Name: "shower"},
		41: {Name: "gear"},
		42: {Name: "sharp_curve"},
		43: {Name: "steep_incline"},
		44: {Name: "tunnel"},
		45: {Name: "bridge"},
		46: {Name: "obstacle"},
		47: {Name: "crossing"},
		48: {Name: "store"},
		49: {Name: "transition"},
		50: {Name: "navaid"},
		51: {Name: "transport"},
		52: {Name: "alert"},
		53: {Name: "info"},
	},
	"manufacturer": {
		1:    {Name: "garmin"},
		2:    {Name: "garmin_fr405_antfs"},
		3:    {Name: "zephyr"},
		4:    {Name: "dayton"},
		5:    {Name: "idt"},
		6:    {Name: "srm"},
		7:    {Name: "quarq"},
		8:    {Name: "ibike"},
		9:    {Name: "saris"},
		10:   {Name: "spark_hk"},
		11:   {Name: "tanita"},
		12:   {Name: "echowell"},
		13:   {Name: "dynastream_oem"},
		14:   {Name: "nautilus"},
		15:   {Name: "dynastream"},
		16:   {Name: "timex"},
		17:   {Name: "metrigear"},
		18:   {Name: "xelic"},
		19:   {Name: "beurer"},
		20:   {Name: "cardiosport"},
		21:   {Name: "a_and_d"},
		22:   {Name: "hmm"},
		23:   {Name: "suunto"},
		24:   {Name: "thita_elektronik"},
		25:   {Name: "gpulse"},
		26:   {Name: "clean_mobile"},
		27:   {Name: "pedal_brain"},
		28:   {Name: "peaksware"},
		29:   {Name: "saxonar"},
		30:   {Name: "lemond_fitness"},
		31:   {Name: "dexcom"},
		32:   {Name: "wahoo_fitness"},
		33:   {Name: "octane_fitness"},
		34:   {Name: "archinoetics"},
		35:   {Name: "the_hurt_box"},
		36:   {Name: "citizen_systems"},
		37:   {Name: "magellan"},
		38:   {Name: "osynce"},
		39:   {Name: "holux"},
		40:   {Name: "concept2"},
		41:   {Name: "shimano"},
		42:   {Name: "one_giant_leap"},
		43:   {Name: "ace_sensor"},
		44:   {Name: "brim_brothers"},
		45:   {Name: "xplova"},
		46:   {Name: "perception_digital"},
		47:   {Name: "bf1systems"},
		48:   {Name: "pioneer"},
		49:   {Name: "spantec"},
		50:   {Name: "metalogics"},
		51:   {Name: "4iiiis"},
		52:   {Name: "seiko_epson"},
		53:   {Name: "seiko_epson_oem"},
		54:   {Name: "ifor_powell"},
		55:   {Name: "maxwell_guider"},
		56:   {Name: "star_trac"},
		57:   {Name: "breakaway"},
		58:   {Name: "alatech_technology_ltd"},
		59:   {Name: "mio_technology_europe"},
		60:   {Name: "rotor"},
		61:   {Name: "geonaute"},
		62:   {Name: "id_bike"},
		63:   {Name: "specialized"},
		64:   {Name: "wtek"},
		65:   {Name: "physical_enterprises"},
		66:   {Name: "north_pole_engineering"},
		67:   {Name: "bkool"},
		68:   {Name: "cateye"},
		69:   {Name: "stages_cycling"},
		70:   {Name: "sigmasport"},
		71:   {Name: "tomtom"},
		72:   {Name: "peripedal"},
		73:   {Name: "wattbike"},
		76:   {Name: "moxy"},
		77:   {Name: "ciclosport"},
		78:   {Name: "powerbahn"},
		79:   {Name: "acorn_projects_aps"},
		80:   {Name: "lifebeam"},
		81:   {Name: "bontrager"},
		82:   {Name: "wellgo"},
		83:   {Name: "scosche"},
		84:   {Name: "magura"},
		85:   {Name: "woodway"},
		86:   {Name: "elite"},
		87:   {Name: "nielsen_kellerman"},
		88:   {Name: "dk_city"},
		89:   {Name: "tacx"},
		90:   {Name: "direction_technology"},
		91:   {Name: "magtonic"},
		92:   {Name: "1partcarbon"},
		93:   {Name: "inside_ride_technologies"},
		94:   {Name: "sound_of_motion"},
		95:   {Name: "stryd"},
		96:   {Name: "icg"},
		97:   {Name: "MiPulse"},
		98:   {Name: "bsx_athletics"},
		99:   {Name: "look"},
		100:  {Name: "campagnolo_srl"},
		101:  {Name: "body_bike_smart"},
		102:  {Name: "praxisworks"},
		103:  {Name: "limits_technology"},
		104:  {Name: "topaction_technology"},
		105:  {Name: "cosinuss"},
		106:  {Name: "fitcare"},
		107:  {Name: "magene"},
		108:  {Name: "giant_manufacturing_co"},
		109:  {Name: "tigrasport"},
		110:  {Name: "salutron"},
		111:  {Name: "technogym"},
		112:  {Name: "bryton_sensors"},
		113:  {Name: "latitude_limited"},
		114:  {Name: "soaring_technology"},
		115:  {Name: "igpsport"},
		116:  {Name: "thinkrider"},
		117:  {Name: "gopher_sport"},
		118:  {Name: "waterrower"},
		119:  {Name: "orangetheory"},
		120:  {Name: "inpeak"},
		121:  {Name: "kinetic"},
		122:  {Name: "johnson_health_tech"},
		123:  {Name: "polar_electro"},
		124:  {Name: "seesense"},
		125:  {Name: "nci_technology"},
		126:  {Name: "iqsquare"},
		127:  {Name: "leomo"},
		128:  {Name: "ifit_com"},
		129:  {Name: "coros_byte"},
		130:  {Name: "versa_design"},
		131:  {Name: "chileaf"},
		132:  {Name: "cycplus"},
		133:  {Name: "gravaa_byte"},
		134:  {Name: "sigeyi"},
		135:  {Name: "coospo"},
		136:  {Name: "geoid"},
		137:  {Name: "bosch"},
		138:  {Name: "kyto"},
		139:  {Name: "kinetic_sports"},
		140:  {Name: "decathlon_byte"},
		141:  {Name: "tq_systems"},
		142:  {Name: "tag_heuer"},
		143:  {Name: "keiser_fitness"},
		144:  {Name: "zwift_byte"},
		145:  {Name: "porsche_ep"},
		146:  {Name: "blackbird"},
		147:  {Name: "meilan_byte"},
		148:  {Name: "ezon"},
		149:  {Name: "laisi"},
		150:  {Name: "myzone"},
		255:  {Name: "development"},
		257:  {Name: "healthandlife"},
		258:  {Name: "lezyne"},
		259:  {Name: "scribe_labs"},
		260:  {Name: "zwift"},
		261:  {Name: "watteam"},
		262:  {Name: "recon"},
		263:  {Name: "favero_electronics"},
		264:  {Name: "dynovelo"},
		265:  {Name: "strava"},
		266:  {Name: "precor"},
		267:  {Name: "bryton"},
		268:  {Name: "sram"},
		269:  {Name: "navman"},
		270:  {Name: "cobi"},
		271:  {Name: "spivi"},
		272:  {Name: "mio_magellan"},
		273:  {Name: "evesports"},
		274:  {Name: "sensitivus_gauge"},
		275:  {Name: "podoon"},
		276:  {Name: "life_time_fitness"},
		277:  {Name: "falco_e_motors"},
		278:  {Name: "minoura"},
		279:  {Name: "cycliq"},
		280:  {Name: "luxottica"},
		281:  {Name: "trainer_road"},
		282:  {Name: "the_sufferfest"},
		283:  {Name: "fullspeedahead"},
		284:  {Name: "virtualtraining"},
		285:  {Name: "feedbacksports"},
		286:  {Name: "omata"},
		287:  {Name: "vdo"},
		288:  {Name: "magneticdays"},
		289:  {Name: "hammerhead"},
		290:  {Name: "kinetic_by_kurt"},
		291:  {Name: "shapelog"},
		292:  {Name: "dabuziduo"},
		293:  {Name: "jetblack"},
		294:  {Name: "coros"},
		295:  {Name: "virtugo"},
		296:  {Name: "velosense"},
		297:  {Name: "cycligentinc"},
		298:  {Name: "trailforks"},
		299:  {Name: "mahle_ebikemotion"},
		300:  {Name: "nurvv"},
		301:  {Name: "microprogram"},
		302:  {Name: "zone5cloud"},
		303:  {Name: "greenteg"},
		304:  {Name: "yamaha_motors"},
		305:  {Name: "whoop"},
		306:  {Name: "gravaa"},
		307:  {Name: "onelap"},
		308:  {Name: "monark_exercise"},
		309:  {Name: "form"},
		310:  {Name: "decathlon"},
		311:  {Name: "syncros"},
		312:  {Name: "heatup"},
		313:  {Name: "cannondale"},
		314:  {Name: "true_fitness"},
		315:  {Name: "RGT_cycling"},
		316:  {Name: "vasa"},
		317:  {Name: "race_republic"},
		318:  {Name: "fazua"},
		319:  {Name: "oreka_training"},
		320:  {Name: "lsec"},
		321:  {Name: "lululemon_studio"},
		322:  {Name: "shanyue"},
		323:  {Name: "spinning_mda"},
		324:  {Name: "hilldating"},
		325:  {Name: "aero_sensor"},
		326:  {Name: "nike"},
		327:  {Name: "magicshine"},
		5759: {Name: "actigraphcorp"},
	},
	"garmin_product": {
		1:     {Name: "hrm1"},
		2:     {Name: "axh01"},
		3:     {Name: "axb01"},
		4:     {Name: "axb02"},
		5:     {Name: "hrm2ss"},
		6:     {Name: "dsi_alf02"},
		7:     {Name: "hrm3ss"},
		8:     {Name: "hrm_run_single_byte_product_id"},
		9:     {Name: "bsm"},
		10:    {Name: "bcm"},
		11:    {Name: "axs01"},
		12:    {Name: "hrm_tri_single_byte_product_id"},
		13:    {Name: "hrm4_run_single_byte_product_id"},
		14:    {Name: "fr225_single_byte_product_id"},
		15:    {Name: "gen3_bsm_single_byte_product_id"},
		16:    {Name: "gen3_bcm_single_byte_product_id"},
		255:   {Name: "OHR"},
		473:   {Name: "fr301_china"},
		474:   {Name: "fr301_japan"},
		475:   {Name: "fr301_korea"},
		494:   {Name: "fr301_taiwan"},
		717:   {Name: "fr405"},
		782:   {Name: "fr50"},
		987:   {Name: "fr405_japan"},
		988:   {Name: "fr60"},
		1011:  {Name: "dsi_alf01"},
		1018:  {Name: "fr310xt"},
		1036:  {Name: "edge500"},
		1124:  {Name: "fr110"},
		1169:  {Name: "edge800"},
		1199:  {Name: "edge500_taiwan"},
		1213:  {Name: "edge500_japan"},
		1253:  {Name: "chirp"},
		1274:  {Name: "fr110_japan"},
		1325:  {Name: "edge200"},
		1328:  {Name: "fr910xt"},
		1333:  {Name: "edge800_taiwan"},
		1334:  {Name: "edge800_japan"},
		1341:  {Name: "alf04"},
		1345:  {Name: "fr610"},
		1360:  {Name: "fr210_japan"},
		1380:  {Name: "vector_ss"},
		1381:  {Name: "vector_cp"},
		1386:  {Name: "edge800_china"},
		1387:  {Name: "edge500_china"},
		1405:  {Name: "approach_g10"},
		1410:  {Name: "fr610_japan"},
		1422:  {Name: "edge500_korea"},
		1436:  {Name: "fr70"},
		1446:  {Name: "fr310xt_4t"},
		1461:  {Name: "amx"},
		1482:  {Name: "fr10"},
		1497:  {Name: "edge800_korea"},
		1499:  {Name: "swim"},
		1537:  {Name: "fr910xt_china"},
		1551:  {Name: "fenix"},
		1555:  {Name: "edge200_taiwan"},
		1561:  {Name: "edge510"},
		1567:  {Name: "edge810"},
		1570:  {Name: "tempe"},
		1600:  {Name: "fr910xt_japan"},
		1623:  {Name: "fr620"},
		1632:  {Name: "fr220"},
		1664:  {Name: "fr910xt_korea"},
		1688:  {Name: "fr10_japan"},
		1721:  {Name: "edge810_japan"},
		1735:  {Name: "virb_elite"},
		1736:  {Name: "edge_touring"},
		1742:  {Name: "edge510_japan"},
		1743:  {Name: "hrm_tri"},
		1752:  {Name: "hrm_run"},
		1765:  {Name: "fr920xt"},
		1821:  {Name: "edge510_asia"},
		1822:  {Name: "edge810_china"},
		1823:  {Name: "edge810_taiwan"},
		1836:  {Name: "edge1000"},
		1837:  {Name: "vivo_fit"},
		1853:  {Name: "virb_remote"},
		1885:  {Name: "vivo_ki"},
		1903:  {Name: "fr15"},
		1907:  {Name: "vivo_active"},
		1918:  {Name: "edge510_korea"},
		1928:  {Name: "fr620_japan"},
		1929:  {Name: "fr620_china"},
		1930:  {Name: "fr220_japan"},
		1931:  {Name: "fr220_china"},
		1936:  {Name: "approach_s6"},
		1956:  {Name: "vivo_smart"},
		1967:  {Name: "fenix2"},
		1988:  {Name: "epix"},
		2050:  {Name: "fenix3"},
		2052:  {Name: "edge1000_taiwan"},
		2053:  {Name: "edge1000_japan"},
		2061:  {Name: "fr15_japan"},
		2067:  {Name: "edge520"},
		2070:  {Name: "edge1000_china"},
		2072:  {Name: "fr620_russia"},
		2073:  {Name: "fr220_russia"},
		2079:  {Name: "vector_s"},
		2100:  {Name: "edge1000_korea"},
		2130:  {Name: "fr920xt_taiwan"},
		2131:  {Name: "fr920xt_china"},
		2132:  {Name: "fr920xt_japan"},
		2134:  {Name: "virbx"},
		2135:  {Name: "vivo_smart_apac"},
		2140:  {Name: "etrex_touch"},
		2147:  {Name: "edge25"},
		2148:  {Name: "fr25"},
		2150:  {Name: "vivo_fit2"},
		2153:  {Name: "fr225"},
		2156:  {Name: "fr630"},
		2157:  {Name: "fr230"},
		2158:  {Name: "fr735xt"},
		2160:  {Name: "vivo_active_apac"},
		2161:  {Name: "vector_2"},
		2162:  {Name: "vector_2s"},
		2172:  {Name: "virbxe"},
		2173:  {Name: "fr620_taiwan"},
		2174:  {Name: "fr220_taiwan"},
		2175:  {Name: "truswing"},
		2187:  {Name: "d2airvenu"},
		2188:  {Name: "fenix3_china"},
		2189:  {Name: "fenix3_twn"},
		2192:  {Name: "varia_headlight"},
		2193:  {Name: "varia_taillight_old"},
		2204:  {Name: "edge_explore_1000"},
		2219:  {Name: "fr225_asia"},
		2225:  {Name: "varia_radar_taillight"},
		2226:  {Name: "varia_radar_display"},
		2238:  {Name: "edge20"},
		2260:  {Name: "edge520_asia"},
		2261:  {Name: "edge520_japan"},
		2262:  {Name: "d2_bravo"},
		2266:  {Name: "approach_s20"},
		2271:  {Name: "vivo_smart2"},
		2274:  {Name: "edge1000_thai"},
		2276:  {Name: "varia_remote"},
		2288:  {Name: "edge25_asia"},
		2289:  {Name: "edge25_jpn"},
		2290:  {Name: "edge20_asia"},
		2292:  {Name: "approach_x40"},
		2293:  {Name: "fenix3_japan"},
		2294:  {Name: "vivo_smart_emea"},
		2310:  {Name: "fr630_asia"},
		2311:  {Name: "fr630_jpn"},
		2313:  {Name: "fr230_jpn"},
		2327:  {Name: "hrm4_run"},
		2332:  {Name: "epix_japan"},
		2337:  {Name: "vivo_active_hr"},
		2347:  {Name: "vivo_smart_gps_hr"},
		2348:  {Name: "vivo_smart_hr"},
		2361:  {Name: "vivo_smart_hr_asia"},
		2362:  {Name: "vivo_smart_gps_hr_asia"},
		2368:  {Name: "vivo_move"},
		2379:  {Name: "varia_taillight"},
		2396:  {Name: "fr235_asia"},
		2397:  {Name: "fr235_japan"},
		2398:  {Name: "varia_vision"},
		2406:  {Name: "vivo_fit3"},
		2407:  {Name: "fenix3_korea"},
		2408:  {Name: "fenix3_sea"},
		2413:  {Name: "fenix3_hr"},
		2417:  {Name: "virb_ultra_30"},
		2429:  {Name: "index_smart_scale"},
		2431:  {Name: "fr235"},
		2432:  {Name: "fenix3_chronos"},
		2441:  {Name: "oregon7xx"},
		2444:  {Name: "rino7xx"},
		2457:  {Name: "epix_korea"},
		2473:  {Name: "fenix3_hr_chn"},
		2474:  {Name: "fenix3_hr_twn"},
		2475:  {Name: "fenix3_hr_jpn"},
		2476:  {Name: "fenix3_hr_sea"},
		2477:  {Name: "fenix3_hr_kor"},
		2496:  {Name: "nautix"},
		2497:  {Name: "vivo_active_hr_apac"},
		2503:  {Name: "fr35"},
		2512:  {Name: "oregon7xx_ww"},
		2530:  {Name: "edge_820"},
		2531:  {Name: "edge_explore_820"},
		2533:  {Name: "fr735xt_apac"},
		2534:  {Name: "fr735xt_japan"},
		2544:  {Name: "fenix5s"},
		2547:  {Name: "d2_bravo_titanium"},
		2567:  {Name: "varia_ut800"},
		2593:  {Name: "running_dynamics_pod"},
		2599:  {Name: "edge_820_china"},
		2600:  {Name: "edge_820_japan"},
		2604:  {Name: "fenix5x"},
		2606:  {Name: "vivo_fit_jr"},
		2622:  {Name: "vivo_smart3"},
		2623:  {Name: "vivo_sport"},
		2628:  {Name: "edge_820_taiwan"},
		2629:  {Name: "edge_820_korea"},
		2630:  {Name: "edge_820_sea"},
		2650:  {Name: "fr35_hebrew"},
		2656:  {Name: "approach_s60"},
		2667:  {Name: "fr35_apac"},
		2668:  {Name: "fr35_japan"},
		2675:  {Name: "fenix3_chronos_asia"},
		2687:  {Name: "virb_360"},
		2691:  {Name: "fr935"},
		2697:  {Name: "fenix5"},
		2700:  {Name: "vivoactive3"},
		2713:  {Name: "edge_1030"},
		2727:  {Name: "fr35_sea"},
		2733:  {Name: "fr235_china_nfc"},
		2769:  {Name: "foretrex_601_701"},
		2772:  {Name: "vivo_move_hr"},
		2787:  {Name: "vector_3"},
		2796:  {Name: "fenix5_asia"},
		2797:  {Name: "fenix5s_asia"},
		2798:  {Name: "fenix5x_asia"},
		2806:  {Name: "approach_z80"},
		2814:  {Name: "fr35_korea"},
		2819:  {Name: "d2charlie"},
		2831:  {Name: "vivo_smart3_apac"},
		2832:  {Name: "vivo_sport_apac"},
		2833:  {Name: "fr935_asia"},
		2859:  {Name: "descent"},
		2878:  {Name: "vivo_fit4"},
		2886:  {Name: "fr645"},
		2888:  {Name: "fr645m"},
		2891:  {Name: "fr30"},
		2900:  {Name: "fenix5s_plus"},
		2909:  {Name: "Edge_130"},
		2924:  {Name: "edge_1030_asia"},
		2927:  {Name: "vivosmart_4"},
		2945:  {Name: "vivo_move_hr_asia"},
		2962:  {Name: "approach_x10"},
		2977:  {Name: "fr30_asia"},
		2988:  {Name: "vivoactive3m_w"},
		3003:  {Name: "fr645_asia"},
		3004:  {Name: "fr645m_asia"},
		3011:  {Name: "edge_explore"},
		3028:  {Name: "gpsmap66"},
		3049:  {Name: "approach_s10"},
		3066:  {Name: "vivoactive3m_l"},
		3085:  {Name: "approach_g80"},
		3092:  {Name: "edge_130_asia"},
		3095:  {Name: "edge_1030_bontrager"},
		3110:  {Name: "fenix5_plus"},
		3111:  {Name: "fenix5x_plus"},
		3112:  {Name: "edge_520_plus"},
		3113:  {Name: "fr945"},
		3121:  {Name: "edge_530"},
		3122:  {Name: "edge_830"},
		3126:  {Name: "instinct_esports"},
		3134:  {Name: "fenix5s_plus_apac"},
		3135:  {Name: "fenix5x_plus_apac"},
		3142:  {Name: "edge_520_plus_apac"},
		3143:  {Name: "descent_t1"},
		3144:  {Name: "fr235l_asia"},
		3145:  {Name: "fr245_asia"},
		3163:  {Name: "vivo_active3m_apac"},
		3192:  {Name: "gen3_bsm"},
		3193:  {Name: "gen3_bcm"},
		3218:  {Name: "vivo_smart4_asia"},
		3224:  {Name: "vivoactive4_small"},
		3225:  {Name: "vivoactive4_large"},
		3226:  {Name: "venu"},
		3246:  {Name: "marq_driver"},
		3247:  {Name: "marq_aviator"},
		3248:  {Name: "marq_captain"},
		3249:  {Name: "marq_commander"},
		3250:  {Name: "marq_expedition"},
		3251:  {Name: "marq_athlete"},
		3258:  {Name: "descent_mk2"},
		3284:  {Name: "gpsmap66i"},
		3287:  {Name: "fenix6S_sport"},
		3288:  {Name: "fenix6S"},
		3289:  {Name: "fenix6_sport"},
		3290:  {Name: "fenix6"},
		3291:  {Name: "fenix6x"},
		3299:  {Name: "hrm_dual"},
		3300:  {Name: "hrm_pro"},
		3308:  {Name: "vivo_move3_premium"},
		3314:  {Name: "approach_s40"},
		3321:  {Name: "fr245m_asia"},
		3349:  {Name: "edge_530_apac"},
		3350:  {Name: "edge_830_apac"},
		3378:  {Name: "vivo_move3"},
		3387:  {Name: "vivo_active4_small_asia"},
		3388:  {Name: "vivo_active4_large_asia"},
		3389:  {Name: "vivo_active4_oled_asia"},
		3405:  {Name: "swim2"},
		3420:  {Name: "marq_driver_asia"},
		3421:  {Name: "marq_aviator_asia"},
		3422:  {Name: "vivo_move3_asia"},
		3441:  {Name: "fr945_asia"},
		3446:  {Name: "vivo_active3t_chn"},
		3448:  {Name: "marq_captain_asia"},
		3449:  {Name: "marq_commander_asia"},
		3450:  {Name: "marq_expedition_asia"},
		3451:  {Name: "marq_athlete_asia"},
		3466:  {Name: "instinct_solar"},
		3469:  {Name: "fr45_asia"},
		3473:  {Name: "vivoactive3_daimler"},
		3498:  {Name: "legacy_rey"},
		3499:  {Name: "legacy_darth_vader"},
		3500:  {Name: "legacy_captain_marvel"},
		3501:  {Name: "legacy_first_avenger"},
		3512:  {Name: "fenix6s_sport_asia"},
		3513:  {Name: "fenix6s_asia"},
		3514:  {Name: "fenix6_sport_asia"},
		3515:  {Name: "fenix6_asia"},
		3516:  {Name: "fenix6x_asia"},
		3535:  {Name: "legacy_captain_marvel_asia"},
		3536:  {Name: "legacy_first_avenger_asia"},
		3537:  {Name: "legacy_rey_asia"},
		3538:  {Name: "legacy_darth_vader_asia"},
		3542:  {Name: "descent_mk2s"},
		3558:  {Name: "edge_130_plus"},
		3570:  {Name: "edge_1030_plus"},
		3578:  {Name: "rally_200"},
		3589:  {Name: "fr745"},
		3600:  {Name: "venusq"},
		3615:  {Name: "lily"},
		3624:  {Name: "marq_adventurer"},
		3638:  {Name: "enduro"},
		3639:  {Name: "swim2_apac"},
		3648:  {Name: "marq_adventurer_asia"},
		3652:  {Name: "fr945_lte"},
		3702:  {Name: "descent_mk2_asia"},
		3703:  {Name: "venu2"},
		3704:  {Name: "venu2s"},
		3737:  {Name: "venu_daimler_asia"},
		3739:  {Name: "marq_golfer"},
		3740:  {Name: "venu_daimler"},
		3794:  {Name: "fr745_asia"},
		3808:  {Name: "varia_rct715"},
		3809:  {Name: "lily_asia"},
		3812:  {Name: "edge_1030_plus_asia"},
		3813:  {Name: "edge_130_plus_asia"},
		3823:  {Name: "approach_s12"},
		3837:  {Name: "venusq_asia"},
		3843:  {Name: "edge_1040"},
		3850:  {Name: "marq_golfer_asia"},
		3851:  {Name: "venu2_plus"},
		3865:  {Name: "gnss"},
		3869:  {Name: "fr55"},
		3872:  {Name: "enduro_asia"},
		3888:  {Name: "instinct_2"},
		3905:  {Name: "fenix7s"},
		3906:  {Name: "fenix7"},
		3907:  {Name: "fenix7x"},
		3908:  {Name: "fenix7s_apac"},
		3909:  {Name: "fenix7_apac"},
		3910:  {Name: "fenix7x_apac"},
		3930:  {Name: "descent_mk2s_asia"},
		3934:  {Name: "approach_s42"},
		3943:  {Name: "epix_gen2"},
		3944:  {Name: "epix_gen2_apac"},
		3949:  {Name: "venu2s_asia"},
		3950:  {Name: "venu2_asia"},
		3978:  {Name: "fr945_lte_asia"},
		3982:  {Name: "vivo_move_sport"},
		3983:  {Name: "vivomove_trend"},
		3986:  {Name: "approach_S12_asia"},
		3990:  {Name: "fr255_music"},
		3991:  {Name: "fr255_small_music"},
		3992:  {Name: "fr255"},
		3993:  {Name: "fr255_small"},
		4002:  {Name: "approach_s42_asia"},
		4005:  {Name: "descent_g1"},
		4017:  {Name: "venu2_plus_asia"},
		4024:  {Name: "fr955"},
		4033:  {Name: "fr55_asia"},
		4061:  {Name: "edge_540"},
		4062:  {Name: "edge_840"},
		4063:  {Name: "vivosmart_5"},
		4071:  {Name: "instinct_2_asia"},
		4105:  {Name: "marq_gen2"},
		4115:  {Name: "venusq2"},
		4116:  {Name: "venusq2music"},
		4124:  {Name: "marq_gen2_aviator"},
		4125:  {Name: "d2_air_x10"},
		4130:  {Name: "hrm_pro_plus"},
		4132:  {Name: "descent_g1_asia"},
		4135:  {Name: "tactix7"},
		4155:  {Name: "instinct_crossover"},
		4169:  {Name: "edge_explore2"},
		4233:  {Name: "approach_s70"},
		4257:  {Name: "fr265_large"},
		4258:  {Name: "fr265_small"},
		4260:  {Name: "venu3"},
		4261:  {Name: "venu3s"},
		4265:  {Name: "tacx_neo_smart"},
		4266:  {Name: "tacx_neo2_smart"},
		4267:  {Name: "tacx_neo2_t_smart"},
		4268:  {Name: "tacx_neo_smart_bike"},
		4269:  {Name: "tacx_satori_smart"},
		4270:  {Name: "tacx_flow_smart"},
		4271:  {Name: "tacx_vortex_smart"},
		4272:  {Name: "tacx_bushido_smart"},
		4273:  {Name: "tacx_genius_smart"},
		4274:  {Name: "tacx_flux_flux_s_smart"},
		4275:  {Name: "tacx_flux2_smart"},
		4276:  {Name: "tacx_magnum"},
		4305:  {Name: "edge_1040_asia"},
		4312:  {Name: "epix_gen2_pro_42"},
		4313:  {Name: "epix_gen2_pro_47"},
		4314:  {Name: "epix_gen2_pro_51"},
		4315:  {Name: "fr965"},
		4341:  {Name: "enduro2"},
		4374:  {Name: "fenix7s_pro_solar"},
		4375:  {Name: "fenix7_pro_solar"},
		4376:  {Name: "fenix7x_pro_solar"},
		4394:  {Name: "instinct_2x"},
		4426:  {Name: "vivoactive5"},
		4442:  {Name: "descent_t2"},
		4472:  {Name: "marq_gen2_commander"},
		4556:  {Name: "d2_mach1_pro"},
		10007: {Name: "sdm4"},
		10014: {Name: "edge_remote"},
		20119: {Name: "training_center"},
		20533: {Name: "tacx_training_app_win"},
		20534: {Name: "tacx_training_app_mac"},
		20565: {Name: "tacx_training_app_mac_catalyst"},
		30045: {Name: "tacx_training_app_android"},
		30046: {Name: "tacx_training_app_ios"},
		30047: {Name: "tacx_training_app_legacy"},
		65531: {Name: "connectiq_simulator"},
		65532: {Name: "android_antplus_plugin"},
		65534: {Name: "connect"},
	},
	"antplus_device_type": {
		1:   {Name: "antfs"},
		11:  {Name: "bike_power"},
		12:  {Name: "environment_sensor_legacy"},
		15:  {Name: "multi_sport_speed_distance"},
		16:  {Name: "control"},
		17:  {Name: "fitness_equipment"},
		18:  {Name: "blood_pressure"},
		19:  {Name: "geocache_node"},
		20:  {Name: "light_electric_vehicle"},
		25:  {Name: "env_sensor"},
		26:  {Name: "racquet"},
		27:  {Name: "control_hub"},
		31:  {Name: "muscle_oxygen"},
		34:  {Name: "shifting"},
		35:  {Name: "bike_light_main"},
		36:  {Name: "bike_light_shared"},
		38:  {Name: "exd"},
		40:  {Name: "bike_radar"},
		46:  {Name: "bike_aero"},
		119: {Name: "weight_scale"},
		120: {Name: "heart_rate"},
		121: {Name: "bike_speed_cadence"},
		122: {Name: "bike_cadence"},
		123: {Name: "bike_speed"},
		124: {Name: "stride_speed_distance"},
	},
	"ant_network": {
		0: {Name: "public"},
		1: {Name: "antplus"},
		2: {Name: "antfs"},
		3: {Name: "private"},
	},
	"workout_capabilities": {},
	"battery_status": {
		1: {Name: "new"},
		2: {Name: "good"},
		3: {Name: "ok"},
		4: {Name: "low"},
		5: {Name: "critical"},
		6: {Name: "charging"},
		7: {Name: "unknown"},
	},
	"hr_type": {
		0: {Name: "normal"},
		1: {Name: "irregular"},
	},
	"course_capabilities": {},
	"weight":              {},
	"workout_hr": {
		100: {Name: "bpm_offset"},
	},
	"workout_power": {
		1000: {Name: "watts_offset"},
	},
	"bp_status": {
		0: {Name: "no_error"},
		1: {Name: "error_incomplete_data"},
		2: {Name: "error_no_measurement"},
		3: {Name: "error_data_out_of_range"},
		4: {Name: "error_irregular_heart_rate"},
	},
	"user_local_id": {},
	"swim_stroke": {
		0: {Name: "freestyle"},
		1: {Name: "backstroke"},
		2: {Name: "breaststroke"},
		3: {Name: "butterfly"},
		4: {Name: "drill"},
		5: {Name: "mixed"},
		6: {Name: "im"},
	},
	"activity_type": {
		0:   {Name: "generic"},
		1:   {Name: "running"},
		2:   {Name: "cycling"},
		3:   {Name: "transition"},
		4:   {Name: "fitness_equipment"},
		5:   {Name: "swimming"},
		6:   {Name: "walking"},
		8:   {Name: "sedentary"},
		254: {Name: "all"},
	},
	"activity_subtype": {
		0:   {Name: "generic"},
		1:   {Name: "treadmill"},
		2:   {Name: "street"},
		3:   {Name: "trail"},
		4:   {Name: "track"},
		5:   {Name: "spin"},
		6:   {Name: "indoor_cycling"},
		7:   {Name: "road"},
		8:   {Name: "mountain"},
		9:   {Name: "downhill"},
		10:  {Name: "recumbent"},
		11:  {Name: "cyclocross"},
		12:  {Name: "hand_cycling"},
		13:  {Name: "track_cycling"},
		14:  {Name: "indoor_rowing"},
		15:  {Name: "elliptical"},
		16:  {Name: "stair_climbing"},
		17:  {Name: "lap_swimming"},
		18:  {Name: "open_water"},
		254: {Name: "all"},
	},
	"activity_level": {
		0: {Name: "low"},
		1: {Name: "medium"},
		2: {Name: "high"},
	},
	"side": {
		0: {Name: "right"},
		1: {Name: "left"},
	},
	"left_right_balance":     {},
	"left_right_balance_100": {},
	"length_type": {
		0: {Name: "idle"},
		1: {Name: "active"},
	},
	"day_of_week": {
		0: {Name: "sunday"},
		1: {Name: "monday"},
		2: {Name: "tuesday"},
		3: {Name: "wednesday"},
		4: {Name: "thursday"},
		5: {Name: "friday"},
		6: {Name: "saturday"},
	},
	"connectivity_capabilities": {},
	"weather_report": {
		0: {Name: "current"},
		1: {Name: "hourly_forecast"},
		2: {Name: "daily_forecast"},
	},
	"weather_status": {
		0:  {Name: "clear"},
		1:  {Name: "partly_cloudy"},
		2:  {Name: "mostly_cloudy"},
		3:  {Name: "rain"},
		4:  {Name: "snow"},
		5:  {Name: "windy"},
		6:  {Name: "thunderstorms"},
		7:  {Name: "wintry_mix"},
		8:  {Name: "fog"},
		11: {Name: "hazy"},
		12: {Name: "hail"},
		13: {Name: "scattered_showers"},
		14: {Name: "scattered_thunderstorms"},
		15: {Name: "unknown_precipitation"},
		16: {Name: "light_rain"},
		17: {Name: "heavy_rain"},
		18: {Name: "light_snow"},
		19: {Name: "heavy_snow"},
		20: {Name: "light_rain_snow"},
		21: {Name: "heavy_rain_snow"},
		22: {Name: "cloudy"},
	},
	"weather_severity": {
		0: {Name: "unknown"},
		1: {Name: "warning"},
		2: {Name: "watch"},
		3: {Name: "advisory"},
		4: {Name: "statement"},
	},
	"weather_severe_type": {
		0:  {Name: "unspecified"},
		1:  {Name: "tornado"},
		2:  {Name: "tsunami"},
		3:  {Name: "hurricane"},
		4:  {Name: "extreme_wind"},
		5:  {Name: "typhoon"},
		6:  {Name: "inland_hurricane"},
		7:  {Name: "hurricane_force_wind"},
		8:  {Name: "waterspout"},
		9:  {Name: "severe_thunderstorm"},
		10: {Name: "wreckhouse_winds"},
		11: {Name: "les_suetes_wind"},
		12: {Name: "avalanche"},
		13: {Name: "flash_flood"},
		14: {Name: "tropical_storm"},
		15: {Name: "inland_tropical_storm"},
		16: {Name: "blizzard"},
		17: {Name: "ice_storm"},
		18: {Name: "freezing_rain"},
		19: {Name: "debris_flow"},
		20: {Name: "flash_freeze"},
		21: {Name: "dust_storm"},
		22: {Name: "high_wind"},
		23: {Name: "winter_storm"},
		24: {Name: "heavy_freezing_spray"},
		25: {Name: "extreme_cold"},
		26: {Name: "wind_chill"},
		27: {Name: "cold_wave"},
		28: {Name: "heavy_snow_alert"},
		29: {Name: "lake_effect_blowing_snow"},
		30: {Name: "snow_squall"},
		31: {Name: "lake_effect_snow"},
		32: {Name: "winter_weather"},
		33: {Name: "sleet"},
		34: {Name: "snowfall"},
		35: {Name: "snow_and_blowing_snow"},
		36: {Name: "blowing_snow"},
		37: {Name: "snow_alert"},
		38: {Name: "arctic_outflow"},
		39: {Name: "freezing_drizzle"},
		40: {Name: "storm"},
		41: {Name: "storm_surge"},
		42: {Name: "rainfall"},
		43: {Name: "areal_flood"},
		44: {Name: "coastal_flood"},
		45: {Name: "lakeshore_flood"},
		46: {Name: "excessive_heat"},
		47: {Name: "heat"},
		48: {Name: "weather"},
		49: {Name: "high_heat_and_humidity"},
		50: {Name: "humidex_and_health"},
		51: {Name: "humidex"},
		52: {Name: "gale"},
		53: {Name: "freezing_spray"},
		54: {Name: "special_marine"},
		55: {Name: "squall"},
		56: {Name: "strong_wind"},
		57: {Name: "lake_wind"},
		58: {Name: "marine_weather"},
		59: {Name: "wind"},
		60: {Name: "small_craft_hazardous_seas"},
		61: {Name: "hazardous_seas"},
		62: {Name: "small_craft"},
		63: {Name: "small_craft_winds"},
		64: {Name: "small_craft_rough_bar"},
		65: {Name: "high_water_level"},
		66: {Name: "ashfall"},
		67: {Name: "freezing_fog"},
		68: {Name: "dense_fog"},
		69: {Name: "dense_smoke"},
		70: {Name: "blowing_dust"},
		71: {Name: "hard_freeze"},
		72: {Name: "freeze"},
		73: {Name: "frost"},
		74: {Name: "fire_weather"},
		75: {Name: "flood"},
		76: {Name: "rip_tide"},
		77: {Name: "high_surf"},
		78: {Name: "smog"},
		79: {Name: "air_quality"},
		80: {Name: "brisk_wind"},
		81: {Name: "air_stagnation"},
		82: {Name: "low_water"},
		83: {Name: "hydrological"},
		84: {Name: "special_weather"},
	},
	"time_into_day":      {},
	"localtime_into_day": {},
	"stroke_type": {
		0: {Name: "no_event"},
		1: {Name: "other"},
		2: {Name: "serve"},
		3: {Name: "forehand"},
		4: {Name: "backhand"},
		5: {Name: "smash"},
	},
	"body_location": {
		0:  {Name: "left_leg"},
		1:  {Name: "left_calf"},
		2:  {Name: "left_shin"},
		3:  {Name: "left_hamstring"},
		4:  {Name: "left_quad"},
		5:  {Name: "left_glute"},
		6:  {Name: "right_leg"},
		7:  {Name: "right_calf"},
		8:  {Name: "right_shin"},
		9:  {Name: "right_hamstring"},
		10: {Name: "right_quad"},
		11: {Name: "right_glute"},
		12: {Name: "torso_back"},
		13: {Name: "left_lower_back"},
		14: {Name: "left_upper_back"},
		15: {Name: "right_lower_back"},
		16: {Name: "right_upper_back"},
		17: {Name: "torso_front"},
		18: {Name: "left_abdomen"},
		19: {Name: "left_chest"},
		20: {Name: "right_abdomen"},
		21: {Name: "right_chest"},
		22: {Name: "left_arm"},
		23: {Name: "left_shoulder"},
		24: {Name: "left_bicep"},
		25: {Name: "left_tricep"},
		26: {Name: "left_brachioradialis"},
		27: {Name: "left_forearm_extensors"},
		28: {Name: "right_arm"},
		29: {Name: "right_shoulder"},
		30: {Name: "right_bicep"},
		31: {Name: "right_tricep"},
		32: {Name: "right_brachioradialis"},
		33: {Name: "right_forearm_extensors"},
		34: {Name: "neck"},
		35: {Name: "throat"},
		36: {Name: "waist_mid_back"},
		37: {Name: "waist_front"},
		38: {Name: "waist_left"},
		39: {Name: "waist_right"},
	},
	"segment_lap_status": {
		0: {Name: "end"},
		1: {Name: "fail"},
	},
	"segment_leaderboard_type": {
		0:  {Name: "overall"},
		1:  {Name: "personal_best"},
		2:  {Name: "connections"},
		3:  {Name: "group"},
		4:  {Name: "challenger"},
		5:  {Name: "kom"},
		6:  {Name: "qom"},
		7:  {Name: "pr"},
		8:  {Name: "goal"},
		9:  {Name: "rival"},
		10: {Name: "club_leader"},
	},
	"segment_delete_status": {
		0: {Name: "do_not_delete"},
		1: {Name: "delete_one"},
		2: {Name: "delete_all"},
	},
	"segment_selection_type": {
		0: {Name: "starred"},
		1: {Name: "suggested"},
	},
	"source_type": {
		0: {Name: "ant"},
		1: {Name: "antplus"},
		2: {Name: "bluetooth"},
		3: {Name: "bluetooth_low_energy"},
		4: {Name: "wifi"},
		5: {Name: "local"},
	},
	"local_device_type": {
		0:  {Name: "gps"},
		1:  {Name: "glonass"},
		2:  {Name: "gps_glonass"},
		3:  {Name: "accelerometer"},
		4:  {Name: "barometer"},
		5:  {Name: "temperature"},
		10: {Name: "whr"},
		12: {Name: "sensor_hub"},
	},
	"ble_device_type": {
		0: {Name: "connected_gps"},
		1: {Name: "heart_rate"},
		2: {Name: "bike_power"},
		3: {Name: "bike_speed_cadence"},
		4: {Name: "bike_speed"},
		5: {Name: "bike_cadence"},
		6: {Name: "footpod"},
		7: {Name: "bike_trainer"},
	},
	"ant_channel_id": {},
	"display_orientation": {
		0: {Name: "auto"},
		1: {Name: "portrait"},
		2: {Name: "landscape"},
		3: {Name: "portrait_flipped"},
		4: {Name: "landscape_flipped"},
	},
	"workout_equipment": {
		0: {Name: "none"},
		1: {Name: "swim_fins"},
		2: {Name: "swim_kickboard"},
		3: {Name: "swim_paddles"},
		4: {Name: "swim_pull_buoy"},
		5: {Name: "swim_snorkel"},
	},
	"watchface_mode": {
		0: {Name: "digital"},
		1: {Name: "analog"},
		2: {Name: "connect_iq"},
		3: {Name: "disabled"},
	},
	"digital_watchface_layout": {
		0: {Name: "traditional"},
		1: {Name: "modern"},
		2: {Name: "bold"},
	},
	"analog_watchface_layout": {
		0: {Name: "minimal"},
		1: {Name: "traditional"},
		2: {Name: "modern"},
	},
	"rider_position_type": {
		0: {Name: "seated"},
		1: {Name: "standing"},
		2: {Name: "transition_to_seated"},
		3: {Name: "transition_to_standing"},
	},
	"power_phase_type": {
		0: {Name: "power_phase_start_angle"},
		1: {Name: "power_phase_end_angle"},
		2: {Name: "power_phase_arc_length"},
		3: {Name: "power_phase_center"},
	},
	"camera_event_type": {
		0:  {Name: "video_start"},
		1:  {Name: "video_split"},
		2:  {Name: "video_end"},
		3:  {Name: "photo_taken"},
		4:  {Name: "video_second_stream_start"},
		5:  {Name: "video_second_stream_split"},
		6:  {Name: "video_second_stream_end"},
		7:  {Name: "video_split_start"},
		8:  {Name: "video_second_stream_split_start"},
		11: {Name: "video_pause"},
		12: {Name: "video_second_stream_pause"},
		13: {Name: "video_resume"},
		14: {Name: "video_second_stream_resume"},
	},
	"sensor_type": {
		0: {Name: "accelerometer"},
		1: {Name: "gyroscope"},
		2: {Name: "compass"},
		3: {Name: "barometer"},
	},
	"bike_light_network_config_type": {
		0: {Name: "auto"},
		4: {Name: "individual"},
		5: {Name: "high_visibility"},
		6: {Name: "trail"},
	},
	"comm_timeout_type": {
		0: {Name: "wildcard_pairing_timeout"},
		1: {Name: "pairing_timeout"},
		2: {Name: "connection_lost"},
		3: {Name: "connection_timeout"},
	},
	"camera_orientation_type": {
		0: {Name: "camera_orientation_0"},
		1: {Name: "camera_orientation_90"},
		2: {Name: "camera_orientation_180"},
		3: {Name: "camera_orientation_270"},
	},
	"attitude_stage": {
		0: {Name: "failed"},
		1: {Name: "aligning"},
		2: {Name: "degraded"},
		3: {Name: "valid"},
	},
	"attitude_validity": {},
	"auto_sync_frequency": {
		0: {Name: "never"},
		1: {Name: "occasionally"},
		2: {Name: "frequent"},
		3: {Name: "once_a_day"},
		4: {Name: "remote"},
	},
	"exd_layout": {
		0: {Name: "full_screen"},
		1: {Name: "half_vertical"},
		2: {Name: "half_horizontal"},
		3: {Name: "half_vertical_right_split"},
		4: {Name: "half_horizontal_bottom_split"},
		5: {Name: "full_quarter_split"},
		6: {Name: "half_vertical_left_split"},
		7: {Name: "half_horizontal_top_split"},
		8: {Name: "dynamic"},
	},
	"exd_display_type": {
		0:  {Name: "numerical"},
		1:  {Name: "simple"},
		2:  {Name: "graph"},
		3:  {Name: "bar"},
		4:  {Name: "circle_graph"},
		5:  {Name: "virtual_partner"},
		6:  {Name: "balance"},
		7:  {Name: "string_list"},
		8:  {Name: "string"},
		9:  {Name: "simple_dynamic_icon"},
		10: {Name: "gauge"},
	},
	"exd_data_units": {
		0:  {Name: "no_units"},
		1:  {Name: "laps"},
		2:  {Name: "miles_per_hour"},
		3:  {Name: "kilometers_per_hour"},
		4:  {Name: "feet_per_hour"},
		5:  {Name: "meters_per_hour"},
		6:  {Name: "degrees_celsius"},
		7:  {Name: "degrees_fahrenheit"},
		8:  {Name: "zone"},
		9:  {Name: "gear"},
		10: {Name: "rpm"},
		11: {Name: "bpm"},
		12: {Name: "degrees"},
		13: {Name: "millimeters"},
		14: {Name: "meters"},
		15: {Name: "kilometers"},
		16: {Name: "feet"},
		17: {Name: "yards"},
		18: {Name: "kilofeet"},
		19: {Name: "miles"},
		20: {Name: "time"},
		21: {Name: "enum_turn_type"},
		22: {Name: "percent"},
		23: {Name: "watts"},
		24: {Name: "watts_per_kilogram"},
		25: {Name: "enum_battery_status"},
		26: {Name: "enum_bike_light_beam_angle_mode"},
		27: {Name: "enum_bike_light_battery_status"},
		28: {Name: "enum_bike_light_network_config_type"},
		29: {Name: "lights"},
		30: {Name: "seconds"},
		31: {Name: "minutes"},
		32: {Name: "hours"},
		33: {Name: "calories"},
		34: {Name: "kilojoules"},
		35: {Name: "milliseconds"},
		36: {Name: "second_per_mile"},
		37: {Name: "second_per_kilometer"},
		38: {Name: "centimeter"},
		39: {Name: "enum_course_point"},
		40: {Name: "bradians"},
		41: {Name: "enum_sport"},
		42: {Name: "inches_hg"},
		43: {Name: "mm_hg"},
		44: {Name: "mbars"},
		45: {Name: "hecto_pascals"},
		46: {Name: "feet_per_min"},
		47: {Name: "meters_per_min"},
		48: {Name: "meters_per_sec"},
		49: {Name: "eight_cardinal"},
	},
	"exd_qualifiers": {
		0:   {Name: "no_qualifier"},
		1:   {Name: "instantaneous"},
		2:   {Name: "average"},
		3:   {Name: "lap"},
		4:   {Name: "maximum"},
		5:   {Name: "maximum_average"},
		6:   {Name: "maximum_lap"},
		7:   {Name: "last_lap"},
		8:   {Name: "average_lap"},
		9:   {Name: "to_destination"},
		10:  {Name: "to_go"},
		11:  {Name: "to_next"},
		12:  {Name: "next_course_point"},
		13:  {Name: "total"},
		14:  {Name: "three_second_average"},
		15:  {Name: "ten_second_average"},
		16:  {Name: "thirty_second_average"},
		17:  {Name: "percent_maximum"},
		18:  {Name: "percent_maximum_average"},
		19:  {Name: "lap_percent_maximum"},
		20:  {Name: "elapsed"},
		21:  {Name: "sunrise"},
		22:  {Name: "sunset"},
		23:  {Name: "compared_to_virtual_partner"},
		24:  {Name: "maximum_24h"},
		25:  {Name: "minimum_24h"},
		26:  {Name: "minimum"},
		27:  {Name: "first"},
		28:  {Name: "second"},
		29:  {Name: "third"},
		30:  {Name: "shifter"},
		31:  {Name: "last_sport"},
		32:  {Name: "moving"},
		33:  {Name: "stopped"},
		34:  {Name: "estimated_total"},
		242: {Name: "zone_9"},
		243: {Name: "zone_8"},
		244: {Name: "zone_7"},
		245: {Name: "zone_6"},
		246: {Name: "zone_5"},
		247: {Name: "zone_4"},
		248: {Name: "zone_3"},
		249: {Name: "zone_2"},
		250: {Name: "zone_1"},
	},
	"exd_descriptors": {
		0:  {Name: "bike_light_battery_status"},
		1:  {Name: "beam_angle_status"},
		2:  {Name: "batery_level"},
		3:  {Name: "light_network_mode"},
		4:  {Name: "number_lights_connected"},
		5:  {Name: "cadence"},
		6:  {Name: "distance"},
		7:  {Name: "estimated_time_of_arrival"},
		8:  {Name: "heading"},
		9:  {Name: "time"},
		10: {Name: "battery_level"},
		11: {Name: "trainer_resistance"},
		12: {Name: "trainer_target_power"},
		13: {Name: "time_seated"},
		14: {Name: "time_standing"},
		15: {Name: "elevation"},
		16: {Name: "grade"},
		17: {Name: "ascent"},
		18: {Name: "descent"},
		19: {Name: "vertical_speed"},
		20: {Name: "di2_battery_level"},
		21: {Name: "front_gear"},
		22: {Name: "rear_gear"},
		23: {Name: "gear_ratio"},
		24: {Name: "heart_rate"},
		25: {Name: "heart_rate_zone"},
		26: {Name: "time_in_heart_rate_zone"},
		27: {Name: "heart_rate_reserve"},
		28: {Name: "calories"},
		29: {Name: "gps_accuracy"},
		30: {Name: "gps_signal_strength"},
		31: {Name: "temperature"},
		32: {Name: "time_of_day"},
		33: {Name: "balance"},
		34: {Name: "pedal_smoothness"},
		35: {Name: "power"},
		36: {Name: "functional_threshold_power"},
		37: {Name: "intensity_factor"},
		38: {Name: "work"},
		39: {Name: "power_ratio"},
		40: {Name: "normalized_power"},
		41: {Name: "training_stress_Score"},
		42: {Name: "time_on_zone"},
		43: {Name: "speed"},
		44: {Name: "laps"},
		45: {Name: "reps"},
		46: {Name: "workout_step"},
		47: {Name: "course_distance"},
		48: {Name: "navigation_distance"},
		49: {Name: "course_estimated_time_of_arrival"},
		50: {Name: "navigation_estimated_time_of_arrival"},
		51: {Name: "course_time"},
		52: {Name: "navigation_time"},
		53: {Name: "course_heading"},
		54: {Name: "navigation_heading"},
		55: {Name: "power_zone"},
		56: {Name: "torque_effectiveness"},
		57: {Name: "timer_time"},
		58: {Name: "power_weight_ratio"},
		59: {Name: "left_platform_center_offset"},
		60: {Name: "right_platform_center_offset"},
		61: {Name: "left_power_phase_start_angle"},
		62: {Name: "right_power_phase_start_angle"},
		63: {Name: "left_power_phase_finish_angle"},
		64: {Name: "right_power_phase_finish_angle"},
		65: {Name: "gears"},
		66: {Name: "pace"},
		67: {Name: "training_effect"},
		68: {Name: "vertical_oscillation"},
		69: {Name: "vertical_ratio"},
		70: {Name: "ground_contact_time"},
		71: {Name: "left_ground_contact_time_balance"},
		72: {Name: "right_ground_contact_time_balance"},
		73: {Name: "stride_length"},
		74: {Name: "running_cadence"},
		75: {Name: "performance_condition"},
		76: {Name: "course_type"},
		77: {Name: "time_in_power_zone"},
		78: {Name: "navigation_turn"},
		79: {Name: "course_location"},
		80: {Name: "navigation_location"},
		81: {Name: "compass"},
		82: {Name: "gear_combo"},
		83: {Name: "muscle_oxygen"},
		84: {Name: "icon"},
		85: {Name: "compass_heading"},
		86: {Name: "gps_heading"},
		87: {Name: "gps_elevation"},
		88: {Name: "anaerobic_training_effect"},
		89: {Name: "course"},
		90: {Name: "off_course"},
		91: {Name: "glide_ratio"},
		92: {Name: "vertical_distance"},
		93: {Name: "vmg"},
		94: {Name: "ambient_pressure"},
		95: {Name: "pressure"},
		96: {Name: "vam"},
	},
	"auto_activity_detect":         {},
	"supported_exd_screen_layouts": {},
	"fit_base_type": {
		0:   {Name: "enum"},
		1:   {Name: "sint8"},
		2:   {Name: "uint8"},
		7:   {Name: "string"},
		10:  {Name: "uint8z"},
		13:  {Name: "byte"},
		131: {Name: "sint16"},
		132: {Name: "uint16"},
		133: {Name: "sint32"},
		134: {Name: "uint32"},
		136: {Name: "float32"},
		137: {Name: "float64"},
		139: {Name: "uint16z"},
		140: {Name: "uint32z"},
		142: {Name: "sint64"},
		143: {Name: "uint64"},
		144: {Name: "uint64z"},
	},
	"turn_type": {
		0:  {Name: "arriving_idx"},
		1:  {Name: "arriving_left_idx"},
		2:  {Name: "arriving_right_idx"},
		3:  {Name: "arriving_via_idx"},
		4:  {Name: "arriving_via_left_idx"},
		5:  {Name: "arriving_via_right_idx"},
		6:  {Name: "bear_keep_left_idx"},
		7:  {Name: "bear_keep_right_idx"},
		8:  {Name: "continue_idx"},
		9:  {Name: "exit_left_idx"},
		10: {Name: "exit_right_idx"},
		11: {Name: "ferry_idx"},
		12: {Name: "roundabout_45_idx"},
		13: {Name: "roundabout_90_idx"},
		14: {Name: "roundabout_135_idx"},
		15: {Name: "roundabout_180_idx"},
		16: {Name: "roundabout_225_idx"},
		17: {Name: "roundabout_270_idx"},
		18: {Name: "roundabout_315_idx"},
		19: {Name: "roundabout_360_idx"},
		20: {Name: "roundabout_neg_45_idx"},
		21: {Name: "roundabout_neg_90_idx"},
		22: {Name: "roundabout_neg_135_idx"},
		23: {Name: "roundabout_neg_180_idx"},
		24: {Name: "roundabout_neg_225_idx"},
		25: {Name: "roundabout_neg_270_idx"},
		26: {Name: "roundabout_neg_315_idx"},
		27: {Name: "roundabout_neg_360_idx"},
		28: {Name: "roundabout_generic_idx"},
		29: {Name: "roundabout_neg_generic_idx"},
		30: {Name: "sharp_turn_left_idx"},
		31: {Name: "sharp_turn_right_idx"},
		32: {Name: "turn_left_idx"},
		33: {Name: "turn_right_idx"},
		34: {Name: "uturn_left_idx"},
		35: {Name: "uturn_right_idx"},
		36: {Name: "icon_inv_idx"},
		37: {Name: "icon_idx_cnt"},
	},
	"bike_light_beam_angle_mode": {
		0: {Name: "manual"},
		1: {Name: "auto"},
	},
	"fit_base_unit": {
		0: {Name: "other"},
		1: {Name: "kilogram"},
		2: {Name: "pound"},
	},
	"set_type": {
		0: {Name: "rest"},
		1: {Name: "active"},
	},
	"max_met_category": {
		0: {Name: "generic"},
		1: {Name: "cycling"},
	},
	"exercise_category": {
		0:     {Name: "bench_press"},
		1:     {Name: "calf_raise"},
		2:     {Name: "cardio"},
		3:     {Name: "carry"},
		4:     {Name: "chop"},
		5:     {Name: "core"},
		6:     {Name: "crunch"},
		7:     {Name: "curl"},
		8:     {Name: "deadlift"},
		9:     {Name: "flye"},
		10:    {Name: "hip_raise"},
		11:    {Name: "hip_stability"},
		12:    {Name: "hip_swing"},
		13:    {Name: "hyperextension"},
		14:    {Name: "lateral_raise"},
		15:    {Name: "leg_curl"},
		16:    {Name: "leg_raise"},
		17:    {Name: "lunge"},
		18:    {Name: "olympic_lift"},
		19:    {Name: "plank"},
		20:    {Name: "plyo"},
		21:    {Name: "pull_up"},
		22:    {Name: "push_up"},
		23:    {Name: "row"},
		24:    {Name: "shoulder_press"},
		25:    {Name: "shoulder_stability"},
		26:    {Name: "shrug"},
		27:    {Name: "sit_up"},
		28:    {Name: "squat"},
		29:    {Name: "total_body"},
		30:    {Name: "triceps_extension"},
		31:    {Name: "warm_up"},
		32:    {Name: "run"},
		65534: {Name: "unknown"},
	},
	"bench_press_exercise_name": {
		0:  {Name: "alternating_dumbbell_chest_press_on_swiss_ball"},
		1:  {Name: "barbell_bench_press"},
		2:  {Name: "barbell_board_bench_press"},
		3:  {Name: "barbell_floor_press"},
		4:  {Name: "close_grip_barbell_bench_press"},
		5:  {Name: "decline_dumbbell_bench_press"},
		6:  {Name: "dumbbell_bench_press"},
		7:  {Name: "dumbbell_floor_press"},
		8:  {Name: "incline_barbell_bench_press"},
		9:  {Name: "incline_dumbbell_bench_press"},
		10: {Name: "incline_smith_machine_bench_press"},
		11: {Name: "isometric_barbell_bench_press"},
		12: {Name: "kettlebell_chest_press"},
		13: {Name: "neutral_grip_dumbbell_bench_press"},
		14: {Name: "neutral_grip_dumbbell_incline_bench_press"},
		15: {Name: "one_arm_floor_press"},
		16: {Name: "weighted_one_arm_floor_press"},
		17: {Name: "partial_lockout"},
		18: {Name: "reverse_grip_barbell_bench_press"},
		19: {Name: "reverse_grip_incline_bench_press"},
		20: {Name: "single_arm_cable_chest_press"},
		21: {Name: "single_arm_dumbbell_bench_press"},
		22: {Name: "smith_machine_bench_press"},
		23: {Name: "swiss_ball_dumbbell_chest_press"},
		24: {Name: "triple_stop_barbell_bench_press"},
		25: {Name: "wide_grip_barbell_bench_press"},
		26: {Name: "alternating_dumbbell_chest_press"},
	},
	"calf_raise_exercise_name": {
		0:  {Name: "3_way_calf_raise"},
		1:  {Name: "3_way_weighted_calf_raise"},
		2:  {Name: "3_way_single_leg_calf_raise"},
		3:  {Name: "3_way_weighted_single_leg_calf_raise"},
		4:  {Name: "donkey_calf_raise"},
		5:  {Name: "weighted_donkey_calf_raise"},
		6:  {Name: "seated_calf_raise"},
		7:  {Name: "weighted_seated_calf_raise"},
		8:  {Name: "seated_dumbbell_toe_raise"},
		9:  {Name: "single_leg_bent_knee_calf_raise"},
		10: {Name: "weighted_single_leg_bent_knee_calf_raise"},
		11: {Name: "single_leg_decline_push_up"},
		12: {Name: "single_leg_donkey_calf_raise"},
		13: {Name: "weighted_single_leg_donkey_calf_raise"},
		14: {Name: "single_leg_hip_raise_with_knee_hold"},
		15: {Name: "single_leg_standing_calf_raise"},
		16: {Name: "single_leg_standing_dumbbell_calf_raise"},
		17: {Name: "standing_barbell_calf_raise"},
		18: {Name: "standing_calf_raise"},
		19: {Name: "weighted_standing_calf_raise"},
		20: {Name: "standing_dumbbell_calf_raise"},
	},
	"cardio_exercise_name": {
		0:  {Name: "bob_and_weave_circle"},
		1:  {Name: "weighted_bob_and_weave_circle"},
		2:  {Name: "cardio_core_crawl"},
		3:  {Name: "weighted_cardio_core_crawl"},
		4:  {Name: "double_under"},
		5:  {Name: "weighted_double_under"},
		6:  {Name: "jump_rope"},
		7:  {Name: "weighted_jump_rope"},
		8:  {Name: "jump_rope_crossover"},
		9:  {Name: "weighted_jump_rope_crossover"},
		10: {Name: "jump_rope_jog"},
		11: {Name: "weighted_jump_rope_jog"},
		12: {Name: "jumping_jacks"},
		13: {Name: "weighted_jumping_jacks"},
		14: {Name: "ski_moguls"},
		15: {Name: "weighted_ski_moguls"},
		16: {Name: "split_jacks"},
		17: {Name: "weighted_split_jacks"},
		18: {Name: "squat_jacks"},
		19: {Name: "weighted_squat_jacks"},
		20: {Name: "triple_under"},
		21: {Name: "weighted_triple_under"},
	},
	"carry_exercise_name": {
		0: {Name: "bar_holds"},
		1: {Name: "farmers_walk"},
		2: {Name: "farmers_walk_on_toes"},
		3: {Name: "hex_dumbbell_hold"},
		4: {Name: "overhead_carry"},
	},
	"chop_exercise_name": {
		0:  {Name: "cable_pull_through"},
		1:  {Name: "cable_rotational_lift"},
		2:  {Name: "cable_woodchop"},
		3:  {Name: "cross_chop_to_knee"},
		4:  {Name: "weighted_cross_chop_to_knee"},
		5:  {Name: "dumbbell_chop"},
		6:  {Name: "half_kneeling_rotation"},
		7:  {Name: "weighted_half_kneeling_rotation"},
		8:  {Name: "half_kneeling_rotational_chop"},
		9:  {Name: "half_kneeling_rotational_reverse_chop"},
		10: {Name: "half_kneeling_stability_chop"},
		11: {Name: "half_kneeling_stability_reverse_chop"},
		12: {Name: "kneeling_rotational_chop"},
		13: {Name: "kneeling_rotational_reverse_chop"},
		14: {Name: "kneeling_stability_chop"},
		15: {Name: "kneeling_woodchopper"},
		16: {Name: "medicine_ball_wood_chops"},
		17: {Name: "power_squat_chops"},
		18: {Name: "weighted_power_squat_chops"},
		19: {Name: "standing_rotational_chop"},
		20: {Name: "standing_split_rotational_chop"},
		21: {Name: "standing_split_rotational_reverse_chop"},
		22: {Name: "standing_stability_reverse_chop"},
	},
	"core_exercise_name": {
		0:  {Name: "abs_jabs"},
		1:  {Name: "weighted_abs_jabs"},
		2:  {Name: "alternating_plate_reach"},
		3:  {Name: "barbell_rollout"},
		4:  {Name: "weighted_barbell_rollout"},
		5:  {Name: "body_bar_oblique_twist"},
		6:  {Name: "cable_core_press"},
		7:  {Name: "cable_side_bend"},
		8:  {Name: "side_bend"},
		9:  {Name: "weighted_side_bend"},
		10: {Name: "crescent_circle"},
		11: {Name: "weighted_crescent_circle"},
		12: {Name: "cycling_russian_twist"},
		13: {Name: "weighted_cycling_russian_twist"},
		14: {Name: "elevated_feet_russian_twist"},
		15: {Name: "weighted_elevated_feet_russian_twist"},
		16: {Name: "half_turkish_get_up"},
		17: {Name: "kettlebell_windmill"},
		18: {Name: "kneeling_ab_wheel"},
		19: {Name: "weighted_kneeling_ab_wheel"},
		20: {Name: "modified_front_lever"},
		21: {Name: "open_knee_tucks"},
		22: {Name: "weighted_open_knee_tucks"},
		23: {Name: "side_abs_leg_lift"},
		24: {Name: "weighted_side_abs_leg_lift"},
		25: {Name: "swiss_ball_jackknife"},
		26: {Name: "weighted_swiss_ball_jackknife"},
		27: {Name: "swiss_ball_pike"},
		28: {Name: "weighted_swiss_ball_pike"},
		29: {Name: "swiss_ball_rollout"},
		30: {Name: "weighted_swiss_ball_rollout"},
		31: {Name: "triangle_hip_press"},
		32: {Name: "weighted_triangle_hip_press"},
		33: {Name: "trx_suspended_jackknife"},
		34: {Name: "weighted_trx_suspended_jackknife"},
		35: {Name: "u_boat"},
		36: {Name: "weighted_u_boat"},
		37: {Name: "windmill_switches"},
		38: {Name: "weighted_windmill_switches"},
		39: {Name: "alternating_slide_out"},
		40: {Name: "weighted_alternating_slide_out"},
		41: {Name: "ghd_back_extensions"},
		42: {Name: "weighted_ghd_back_extensions"},
		43: {Name: "overhead_walk"},
		44: {Name: "inchworm"},
		45: {Name: "weighted_modified_front_lever"},
		46: {Name: "russian_twist"},
		48: {Name: "arm_and_leg_extension_on_knees"},
		49: {Name: "bicycle"},
		50: {Name: "bicep_curl_with_leg_extension"},
		51: {Name: "cat_cow"},
		52: {Name: "corkscrew"},
		53: {Name: "criss_cross"},
		55: {Name: "double_leg_stretch"},
		56: {Name: "knee_folds"},
		57: {Name: "lower_lift"},
		58: {Name: "neck_pull"},
		59: {Name: "pelvic_clocks"},
		60: {Name: "roll_over"},
		61: {Name: "roll_up"},
		62: {Name: "rolling"},
		63: {Name: "rowing_1"},
		64: {Name: "rowing_2"},
		65: {Name: "scissors"},
		66: {Name: "single_leg_circles"},
		67: {Name: "single_leg_stretch"},
		69: {Name: "swan"},
		70: {Name: "swimming"},
		71: {Name: "teaser"},
		72: {Name: "the_hundred"},
	},
	"crunch_exercise_name": {
		0:  {Name: "bicycle_crunch"},
		1:  {Name: "cable_crunch"},
		2:  {Name: "circular_arm_crunch"},
		3:  {Name: "crossed_arms_crunch"},
		4:  {Name: "weighted_crossed_arms_crunch"},
		5:  {Name: "cross_leg_reverse_crunch"},
		6:  {Name: "weighted_cross_leg_reverse_crunch"},
		7:  {Name: "crunch_chop"},
		8:  {Name: "weighted_crunch_chop"},
		9:  {Name: "double_crunch"},
		10: {Name: "weighted_double_crunch"},
		11: {Name: "elbow_to_knee_crunch"},
		12: {Name: "weighted_elbow_to_knee_crunch"},
		13: {Name: "flutter_kicks"},
		14: {Name: "weighted_flutter_kicks"},
		15: {Name: "foam_roller_reverse_crunch_on_bench"},
		16: {Name: "weighted_foam_roller_reverse_crunch_on_bench"},
		17: {Name: "foam_roller_reverse_crunch_with_dumbbell"},
		18: {Name: "foam_roller_reverse_crunch_with_medicine_ball"},
		19: {Name: "frog_press"},
		20: {Name: "hanging_knee_raise_oblique_crunch"},
		21: {Name: "weighted_hanging_knee_raise_oblique_crunch"},
		22: {Name: "hip_crossover"},
		23: {Name: "weighted_hip_crossover"},
		24: {Name: "hollow_rock"},
		25: {Name: "weighted_hollow_rock"},
		26: {Name: "incline_reverse_crunch"},
		27: {Name: "weighted_incline_reverse_crunch"},
		28: {Name: "kneeling_cable_crunch"},
		29: {Name: "kneeling_cross_crunch"},
		30: {Name: "weighted_kneeling_cross_crunch"},
		31: {Name: "kneeling_oblique_cable_crunch"},
		32: {Name: "knees_to_elbow"},
		33: {Name: "leg_extensions"},
		34: {Name: "weighted_leg_extensions"},
		35: {Name: "leg_levers"},
		36: {Name: "mcgill_curl_up"},
		37: {Name: "weighted_mcgill_curl_up"},
		38: {Name: "modified_pilates_roll_up_with_ball"},
		39: {Name: "weighted_modified_pilates_roll_up_with_ball"},
		40: {Name: "pilates_crunch"},
		41: {Name: "weighted_pilates_crunch"},
		42: {Name: "pilates_roll_up_with_ball"},
		43: {Name: "weighted_pilates_roll_up_with_ball"},
		44: {Name: "raised_legs_crunch"},
		45: {Name: "weighted_raised_legs_crunch"},
		46: {Name: "reverse_crunch"},
		47: {Name: "weighted_reverse_crunch"},
		48: {Name: "reverse_crunch_on_a_bench"},
		49: {Name: "weighted_reverse_crunch_on_a_bench"},
		50: {Name: "reverse_curl_and_lift"},
		51: {Name: "weighted_reverse_curl_and_lift"},
		52: {Name: "rotational_lift"},
		53: {Name: "weighted_rotational_lift"},
		54: {Name: "seated_alternating_reverse_crunch"},
		55: {Name: "weighted_seated_alternating_reverse_crunch"},
		56: {Name: "seated_leg_u"},
		57: {Name: "weighted_seated_leg_u"},
		58: {Name: "side_to_side_crunch_and_weave"},
		59: {Name: "weighted_side_to_side_crunch_and_weave"},
		60: {Name: "single_leg_reverse_crunch"},
		61: {Name: "weighted_single_leg_reverse_crunch"},
		62: {Name: "skater_crunch_cross"},
		63: {Name: "weighted_skater_crunch_cross"},
		64: {Name: "standing_cable_crunch"},
		65: {Name: "standing_side_crunch"},
		66: {Name: "step_climb"},
		67: {Name: "weighted_step_climb"},
		68: {Name: "swiss_ball_crunch"},
		69: {Name: "swiss_ball_reverse_crunch"},
		70: {Name: "weighted_swiss_ball_reverse_crunch"},
		71: {Name: "swiss_ball_russian_twist"},
		72: {Name: "weighted_swiss_ball_russian_twist"},
		73: {Name: "swiss_ball_side_crunch"},
		74: {Name: "weighted_swiss_ball_side_crunch"},
		75: {Name: "thoracic_crunches_on_foam_roller"},
		76: {Name: "weighted_thoracic_crunches_on_foam_roller"},
		77: {Name: "triceps_crunch"},
		78: {Name: "weighted_bicycle_crunch"},
		79: {Name: "weighted_crunch"},
		80: {Name: "weighted_swiss_ball_crunch"},
		81: {Name: "toes_to_bar"},
		82: {Name: "weighted_toes_to_bar"},
		83: {Name: "crunch"},
		84: {Name: "straight_leg_crunch_with_ball"},
	},
	"curl_exercise_name": {
		0:  {Name: "alternating_dumbbell_biceps_curl"},
		1:  {Name: "alternating_dumbbell_biceps_curl_on_swiss_ball"},
		2:  {Name: "alternating_incline_dumbbell_biceps_curl"},
		3:  {Name: "barbell_biceps_curl"},
		4:  {Name: "barbell_reverse_wrist_curl"},
		5:  {Name: "barbell_wrist_curl"},
		6:  {Name: "behind_the_back_barbell_reverse_wrist_curl"},
		7:  {Name: "behind_the_back_one_arm_cable_curl"},
		8:  {Name: "cable_biceps_curl"},
		9:  {Name: "cable_hammer_curl"},
		10: {Name: "cheating_barbell_biceps_curl"},
		11: {Name: "close_grip_ez_bar_biceps_curl"},
		12: {Name: "cross_body_dumbbell_hammer_curl"},
		13: {Name: "dead_hang_biceps_curl"},
		14: {Name: "decline_hammer_curl"},
		15: {Name: "dumbbell_biceps_curl_with_static_hold"},
		16: {Name: "dumbbell_hammer_curl"},
		17: {Name: "dumbbell_reverse_wrist_curl"},
		18: {Name: "dumbbell_wrist_curl"},
		19: {Name: "ez_bar_preacher_curl"},
		20: {Name: "forward_bend_biceps_curl"},
		21: {Name: "hammer_curl_to_press"},
		22: {Name: "incline_dumbbell_biceps_curl"},
		23: {Name: "incline_offset_thumb_dumbbell_curl"},
		24: {Name: "kettlebell_biceps_curl"},
		25: {Name: "lying_concentration_cable_curl"},
		26: {Name: "one_arm_preacher_curl"},
		27: {Name: "plate_pinch_curl"},
		28: {Name: "preacher_curl_with_cable"},
		29: {Name: "reverse_ez_bar_curl"},
		30: {Name: "reverse_grip_wrist_curl"},
		31: {Name: "reverse_grip_barbell_biceps_curl"},
		32: {Name: "seated_alternating_dumbbell_biceps_curl"},
		33: {Name: "seated_dumbbell_biceps_curl"},
		34: {Name: "seated_reverse_dumbbell_curl"},
		35: {Name: "split_stance_offset_pinky_dumbbell_curl"},
		36: {Name: "standing_alternating_dumbbell_curls"},
		37: {Name: "standing_dumbbell_biceps_curl"},
		38: {Name: "standing_ez_bar_biceps_curl"},
		39: {Name: "static_curl"},
		40: {Name: "swiss_ball_dumbbell_overhead_triceps_extension"},
		41: {Name: "swiss_ball_ez_bar_preacher_curl"},
		42: {Name: "twisting_standing_dumbbell_biceps_curl"},
		43: {Name: "wide_grip_ez_bar_biceps_curl"},
	},
	"deadlift_exercise_name": {
		0:  {Name: "barbell_deadlift"},
		1:  {Name: "barbell_straight_leg_deadlift"},
		2:  {Name: "dumbbell_deadlift"},
		3:  {Name: "dumbbell_single_leg_deadlift_to_row"},
		4:  {Name: "dumbbell_straight_leg_deadlift"},
		5:  {Name: "kettlebell_floor_to_shelf"},
		6:  {Name: "one_arm_one_leg_deadlift"},
		7:  {Name: "rack_pull"},
		8:  {Name: "rotational_dumbbell_straight_leg_deadlift"},
		9:  {Name: "single_arm_deadlift"},
		10: {Name: "single_leg_barbell_deadlift"},
		11: {Name: "single_leg_barbell_straight_leg_deadlift"},
		12: {Name: "single_leg_deadlift_with_barbell"},
		13: {Name: "single_leg_rdl_circuit"},
		14: {Name: "single_leg_romanian_deadlift_with_dumbbell"},
		15: {Name: "sumo_deadlift"},
		16: {Name: "sumo_deadlift_high_pull"},
		17: {Name: "trap_bar_deadlift"},
		18: {Name: "wide_grip_barbell_deadlift"},
	},
	"flye_exercise_name": {
		0: {Name: "cable_crossover"},
		1: {Name: "decline_dumbbell_flye"},
		2: {Name: "dumbbell_flye"},
		3: {Name: "incline_dumbbell_flye"},
		4: {Name: "kettlebell_flye"},
		5: {Name: "kneeling_rear_flye"},
		6: {Name: "single_arm_standing_cable_reverse_flye"},
		7: {Name: "swiss_ball_dumbbell_flye"},
		8: {Name: "arm_rotations"},
		9: {Name: "hug_a_tree"},
	},
	"hip_raise_exercise_name": {
		0:  {Name: "barbell_hip_thrust_on_floor"},
		1:  {Name: "barbell_hip_thrust_with_bench"},
		2:  {Name: "bent_knee_swiss_ball_reverse_hip_raise"},
		3:  {Name: "weighted_bent_knee_swiss_ball_reverse_hip_raise"},
		4:  {Name: "bridge_with_leg_extension"},
		5:  {Name: "weighted_bridge_with_leg_extension"},
		6:  {Name: "clam_bridge"},
		7:  {Name: "front_kick_tabletop"},
		8:  {Name: "weighted_front_kick_tabletop"},
		9:  {Name: "hip_extension_and_cross"},
		10: {Name: "weighted_hip_extension_and_cross"},
		11: {Name: "hip_raise"},
		12: {Name: "weighted_hip_raise"},
		13: {Name: "hip_raise_with_feet_on_swiss_ball"},
		14: {Name: "weighted_hip_raise_with_feet_on_swiss_ball"},
		15: {Name: "hip_raise_with_head_on_bosu_ball"},
		16: {Name: "weighted_hip_raise_with_head_on_bosu_ball"},
		17: {Name: "hip_raise_with_head_on_swiss_ball"},
		18: {Name: "weighted_hip_raise_with_head_on_swiss_ball"},
		19: {Name: "hip_raise_with_knee_squeeze"},
		20: {Name: "weighted_hip_raise_with_knee_squeeze"},
		21: {Name: "incline_rear_leg_extension"},
		22: {Name: "weighted_incline_rear_leg_extension"},
		23: {Name: "kettlebell_swing"},
		24: {Name: "marching_hip_raise"},
		25: {Name: "weighted_marching_hip_raise"},
		26: {Name: "marching_hip_raise_with_feet_on_a_swiss_ball"},
		27: {Name: "weighted_marching_hip_raise_with_feet_on_a_swiss_ball"},
		28: {Name: "reverse_hip_raise"},
		29: {Name: "weighted_reverse_hip_raise"},
		30: {Name: "single_leg_hip_raise"},
		31: {Name: "weighted_single_leg_hip_raise"},
		32: {Name: "single_leg_hip_raise_with_foot_on_bench"},
		33: {Name: "weighted_single_leg_hip_raise_with_foot_on_bench"},
		34: {Name: "single_leg_hip_raise_with_foot_on_bosu_ball"},
		35: {Name: "weighted_single_leg_hip_raise_with_foot_on_bosu_ball"},
		36: {Name: "single_leg_hip_raise_with_foot_on_foam_roller"},
		37: {Name: "weighted_single_leg_hip_raise_with_foot_on_foam_roller"},
		38: {Name: "single_leg_hip_raise_with_foot_on_medicine_ball"},
		39: {Name: "weighted_single_leg_hip_raise_with_foot_on_medicine_ball"},
		40: {Name: "single_leg_hip_raise_with_head_on_bosu_ball"},
		41: {Name: "weighted_single_leg_hip_raise_with_head_on_bosu_ball"},
		42: {Name: "weighted_clam_bridge"},
		43: {Name: "single_leg_swiss_ball_hip_raise_and_leg_curl"},
		44: {Name: "clams"},
		47: {Name: "leg_circles"},
		48: {Name: "leg_lift"},
		49: {Name: "leg_lift_in_external_rotation"},
	},
	"hip_stability_exercise_name": {
		0:  {Name: "band_side_lying_leg_raise"},
		1:  {Name: "dead_bug"},
		2:  {Name: "weighted_dead_bug"},
		3:  {Name: "external_hip_raise"},
		4:  {Name: "weighted_external_hip_raise"},
		5:  {Name: "fire_hydrant_kicks"},
		6:  {Name: "weighted_fire_hydrant_kicks"},
		7:  {Name: "hip_circles"},
		8:  {Name: "weighted_hip_circles"},
		9:  {Name: "inner_thigh_lift"},
		10: {Name: "weighted_inner_thigh_lift"},
		11: {Name: "lateral_walks_with_band_at_ankles"},
		12: {Name: "pretzel_side_kick"},
		13: {Name: "weighted_pretzel_side_kick"},
		14: {Name: "prone_hip_internal_rotation"},
		15: {Name: "weighted_prone_hip_internal_rotation"},
		16: {Name: "quadruped"},
		17: {Name: "quadruped_hip_extension"},
		18: {Name: "weighted_quadruped_hip_extension"},
		19: {Name: "quadruped_with_leg_lift"},
		20: {Name: "weighted_quadruped_with_leg_lift"},
		21: {Name: "side_lying_leg_raise"},
		22: {Name: "weighted_side_lying_leg_raise"},
		23: {Name: "sliding_hip_adduction"},
		24: {Name: "weighted_sliding_hip_adduction"},
		25: {Name: "standing_adduction"},
		26: {Name: "weighted_standing_adduction"},
		27: {Name: "standing_cable_hip_abduction"},
		28: {Name: "standing_hip_abduction"},
		29: {Name: "weighted_standing_hip_abduction"},
		30: {Name: "standing_rear_leg_raise"},
		31: {Name: "weighted_standing_rear_leg_raise"},
		32: {Name: "supine_hip_internal_rotation"},
		33: {Name: "weighted_supine_hip_internal_rotation"},
	},
	"hip_swing_exercise_name": {
		0: {Name: "single_arm_kettlebell_swing"},
		1: {Name: "single_arm_dumbbell_swing"},
		2: {Name: "step_out_swing"},
	},
	"hyperextension_exercise_name": {
		0:  {Name: "back_extension_with_opposite_arm_and_leg_reach"},
		1:  {Name: "weighted_back_extension_with_opposite_arm_and_leg_reach"},
		2:  {Name: "base_rotations"},
		3:  {Name: "weighted_base_rotations"},
		4:  {Name: "bent_knee_reverse_hyperextension"},
		5:  {Name: "weighted_bent_knee_reverse_hyperextension"},
		6:  {Name: "hollow_hold_and_roll"},
		7:  {Name: "weighted_hollow_hold_and_roll"},
		8:  {Name: "kicks"},
		9:  {Name: "weighted_kicks"},
		10: {Name: "knee_raises"},
		11: {Name: "weighted_knee_raises"},
		12: {Name: "kneeling_superman"},
		13: {Name: "weighted_kneeling_superman"},
		14: {Name: "lat_pull_down_with_row"},
		15: {Name: "medicine_ball_deadlift_to_reach"},
		16: {Name: "one_arm_one_leg_row"},
		17: {Name: "one_arm_row_with_band"},
		18: {Name: "overhead_lunge_with_medicine_ball"},
		19: {Name: "plank_knee_tucks"},
		20: {Name: "weighted_plank_knee_tucks"},
		21: {Name: "side_step"},
		22: {Name: "weighted_side_step"},
		23: {Name: "single_leg_back_extension"},
		24: {Name: "weighted_single_leg_back_extension"},
		25: {Name: "spine_extension"},
		26: {Name: "weighted_spine_extension"},
		27: {Name: "static_back_extension"},
		28: {Name: "weighted_static_back_extension"},
		29: {Name: "superman_from_floor"},
		30: {Name: "weighted_superman_from_floor"},
		31: {Name: "swiss_ball_back_extension"},
		32: {Name: "weighted_swiss_ball_back_extension"},
		33: {Name: "swiss_ball_hyperextension"},
		34: {Name: "weighted_swiss_ball_hyperextension"},
		35: {Name: "swiss_ball_opposite_arm_and_leg_lift"},
		36: {Name: "weighted_swiss_ball_opposite_arm_and_leg_lift"},
		37: {Name: "superman_on_swiss_ball"},
		38: {Name: "cobra"},
	},
	"lateral_raise_exercise_name": {
		0:  {Name: "45_degree_cable_external_rotation"},
		1:  {Name: "alternating_lateral_raise_with_static_hold"},
		2:  {Name: "bar_muscle_up"},
		3:  {Name: "bent_over_lateral_raise"},
		4:  {Name: "cable_diagonal_raise"},
		5:  {Name: "cable_front_raise"},
		6:  {Name: "calorie_row"},
		7:  {Name: "combo_shoulder_raise"},
		8:  {Name: "dumbbell_diagonal_raise"},
		9:  {Name: "dumbbell_v_raise"},
		10: {Name: "front_raise"},
		11: {Name: "leaning_dumbbell_lateral_raise"},
		12: {Name: "lying_dumbbell_raise"},
		13: {Name: "muscle_up"},
		14: {Name: "one_arm_cable_lateral_raise"},
		15: {Name: "overhand_grip_rear_lateral_raise"},
		16: {Name: "plate_raises"},
		17: {Name: "ring_dip"},
		18: {Name: "weighted_ring_dip"},
		19: {Name: "ring_muscle_up"},
		20: {Name: "weighted_ring_muscle_up"},
		21: {Name: "rope_climb"},
		22: {Name: "weighted_rope_climb"},
		23: {Name: "scaption"},
		24: {Name: "seated_lateral_raise"},
		25: {Name: "seated_rear_lateral_raise"},
		26: {Name: "side_lying_lateral_raise"},
		27: {Name: "standing_lift"},
		28: {Name: "suspended_row"},
		29: {Name: "underhand_grip_rear_lateral_raise"},
		30: {Name: "wall_slide"},
		31: {Name: "weighted_wall_slide"},
		32: {Name: "arm_circles"},
		33: {Name: "shaving_the_head"},
	},
	"leg_curl_exercise_name": {
		0:  {Name: "leg_curl"},
		1:  {Name: "weighted_leg_curl"},
		2:  {Name: "good_morning"},
		3:  {Name: "seated_barbell_good_morning"},
		4:  {Name: "single_leg_barbell_good_morning"},
		5:  {Name: "single_leg_sliding_leg_curl"},
		6:  {Name: "sliding_leg_curl"},
		7:  {Name: "split_barbell_good_morning"},
		8:  {Name: "split_stance_extension"},
		9:  {Name: "staggered_stance_good_morning"},
		10: {Name: "swiss_ball_hip_raise_and_leg_curl"},
		11: {Name: "zercher_good_morning"},
	},
	"leg_raise_exercise_name": {
		0:  {Name: "hanging_knee_raise"},
		1:  {Name: "hanging_leg_raise"},
		2:  {Name: "weighted_hanging_leg_raise"},
		3:  {Name: "hanging_single_leg_raise"},
		4:  {Name: "weighted_hanging_single_leg_raise"},
		5:  {Name: "kettlebell_leg_raises"},
		6:  {Name: "leg_lowering_drill"},
		7:  {Name: "weighted_leg_lowering_drill"},
		8:  {Name: "lying_straight_leg_raise"},
		9:  {Name: "weighted_lying_straight_leg_raise"},
		10: {Name: "medicine_ball_leg_drops"},
		11: {Name: "quadruped_leg_raise"},
		12: {Name: "weighted_quadruped_leg_raise"},
		13: {Name: "reverse_leg_raise"},
		14: {Name: "weighted_reverse_leg_raise"},
		15: {Name: "reverse_leg_raise_on_swiss_ball"},
		16: {Name: "weighted_reverse_leg_raise_on_swiss_ball"},
		17: {Name: "single_leg_lowering_drill"},
		18: {Name: "weighted_single_leg_lowering_drill"},
		19: {Name: "weighted_hanging_knee_raise"},
		20: {Name: "lateral_stepover"},
		21: {Name: "weighted_lateral_stepover"},
	},
	"lunge_exercise_name": {
		0:  {Name: "overhead_lunge"},
		1:  {Name: "lunge_matrix"},
		2:  {Name: "weighted_lunge_matrix"},
		3:  {Name: "alternating_barbell_forward_lunge"},
		4:  {Name: "alternating_dumbbell_lunge_with_reach"},
		5:  {Name: "back_foot_elevated_dumbbell_split_squat"},
		6:  {Name: "barbell_box_lunge"},
		7:  {Name: "barbell_bulgarian_split_squat"},
		8:  {Name: "barbell_crossover_lunge"},
		9:  {Name: "barbell_front_split_squat"},
		10: {Name: "barbell_lunge"},
		11: {Name: "barbell_reverse_lunge"},
		12: {Name: "barbell_side_lunge"},
		13: {Name: "barbell_split_squat"},
		14: {Name: "core_control_rear_lunge"},
		15: {Name: "diagonal_lunge"},
		16: {Name: "drop_lunge"},
		17: {Name: "dumbbell_box_lunge"},
		18: {Name: "dumbbell_bulgarian_split_squat"},
		19: {Name: "dumbbell_crossover_lunge"},
		20: {Name: "dumbbell_diagonal_lunge"},
		21: {Name: "dumbbell_lunge"},
		22: {Name: "dumbbell_lunge_and_rotation"},
		23: {Name: "dumbbell_overhead_bulgarian_split_squat"},
		24: {Name: "dumbbell_reverse_lunge_to_high_knee_and_press"},
		25: {Name: "dumbbell_side_lunge"},
		26: {Name: "elevated_front_foot_barbell_split_squat"},
		27: {Name: "front_foot_elevated_dumbbell_split_squat"},
		28: {Name: "gunslinger_lunge"},
		29: {Name: "lawnmower_lunge"},
		30: {Name: "low_lunge_with_isometric_adduction"},
		31: {Name: "low_side_to_side_lunge"},
		32: {Name: "lunge"},
		33: {Name: "weighted_lunge"},
		34: {Name: "lunge_with_arm_reach"},
		35: {Name: "lunge_with_diagonal_reach"},
		36: {Name: "lunge_with_side_bend"},
		37: {Name: "offset_dumbbell_lunge"},
		38: {Name: "offset_dumbbell_reverse_lunge"},
		39: {Name: "overhead_bulgarian_split_squat"},
		40: {Name: "overhead_dumbbell_reverse_lunge"},
		41: {Name: "overhead_dumbbell_split_squat"},
		42: {Name: "overhead_lunge_with_rotation"},
		43: {Name: "reverse_barbell_box_lunge"},
		44: {Name: "reverse_box_lunge"},
		45: {Name: "reverse_dumbbell_box_lunge"},
		46: {Name: "reverse_dumbbell_crossover_lunge"},
		47: {Name: "reverse_dumbbell_diagonal_lunge"},
		48: {Name: "reverse_lunge_with_reach_back"},
		49: {Name: "weighted_reverse_lunge_with_reach_back"},
		50: {Name: "reverse_lunge_with_twist_and_overhead_reach"},
		51: {Name: "weighted_reverse_lunge_with_twist_and_overhead_reach"},
		52: {Name: "reverse_sliding_box_lunge"},
		53: {Name: "weighted_reverse_sliding_box_lunge"},
		54: {Name: "reverse_sliding_lunge"},
		55: {Name: "weighted_reverse_sliding_lunge"},
		56: {Name: "runners_lunge_to_balance"},
		57: {Name: "weighted_runners_lunge_to_balance"},
		58: {Name: "shifting_side_lunge"},
		59: {Name: "side_and_crossover_lunge"},
		60: {Name: "weighted_side_and_crossover_lunge"},
		61: {Name: "side_lunge"},
		62: {Name: "weighted_side_lunge"},
		63: {Name: "side_lunge_and_press"},
		64: {Name: "side_lunge_jump_off"},
		65: {Name: "side_lunge_sweep"},
		66: {Name: "weighted_side_lunge_sweep"},
		67: {Name: "side_lunge_to_crossover_tap"},
		68: {Name: "weighted_side_lunge_to_crossover_tap"},
		69: {Name: "side_to_side_lunge_chops"},
		70: {Name: "weighted_side_to_side_lunge_chops"},
		71: {Name: "siff_jump_lunge"},
		72: {Name: "weighted_siff_jump_lunge"},
		73: {Name: "single_arm_reverse_lunge_and_press"},
		74: {Name: "sliding_lateral_lunge"},
		75: {Name: "weighted_sliding_lateral_lunge"},
		76: {Name: "walking_barbell_lunge"},
		77: {Name: "walking_dumbbell_lunge"},
		78: {Name: "walking_lunge"},
		79: {Name: "weighted_walking_lunge"},
		80: {Name: "wide_grip_overhead_barbell_split_squat"},
	},
	"olympic_lift_exercise_name": {
		0:  {Name: "barbell_hang_power_clean"},
		1:  {Name: "barbell_hang_squat_clean"},
		2:  {Name: "barbell_power_clean"},
		3:  {Name: "barbell_power_snatch"},
		4:  {Name: "barbell_squat_clean"},
		5:  {Name: "clean_and_jerk"},
		6:  {Name: "barbell_hang_power_snatch"},
		7:  {Name: "barbell_hang_pull"},
		8:  {Name: "barbell_high_pull"},
		9:  {Name: "barbell_snatch"},
		10: {Name: "barbell_split_jerk"},
		11: {Name: "clean"},
		12: {Name: "dumbbell_clean"},
		13: {Name: "dumbbell_hang_pull"},
		14: {Name: "one_hand_dumbbell_split_snatch"},
		15: {Name: "push_jerk"},
		16: {Name: "single_arm_dumbbell_snatch"},
		17: {Name: "single_arm_hang_snatch"},
		18: {Name: "single_arm_kettlebell_snatch"},
		19: {Name: "split_jerk"},
		20: {Name: "squat_clean_and_jerk"},
	},
	"plank_exercise_name": {
		0:   {Name: "45_degree_plank"},
		1:   {Name: "weighted_45_degree_plank"},
		2:   {Name: "90_degree_static_hold"},
		3:   {Name: "weighted_90_degree_static_hold"},
		4:   {Name: "bear_crawl"},
		5:   {Name: "weighted_bear_crawl"},
		6:   {Name: "cross_body_mountain_climber"},
		7:   {Name: "weighted_cross_body_mountain_climber"},
		8:   {Name: "elbow_plank_pike_jacks"},
		9:   {Name: "weighted_elbow_plank_pike_jacks"},
		10:  {Name: "elevated_feet_plank"},
		11:  {Name: "weighted_elevated_feet_plank"},
		12:  {Name: "elevator_abs"},
		13:  {Name: "weighted_elevator_abs"},
		14:  {Name: "extended_plank"},
		15:  {Name: "weighted_extended_plank"},
		16:  {Name: "full_plank_passe_twist"},
		17:  {Name: "weighted_full_plank_passe_twist"},
		18:  {Name: "inching_elbow_plank"},
		19:  {Name: "weighted_inching_elbow_plank"},
		20:  {Name: "inchworm_to_side_plank"},
		21:  {Name: "weighted_inchworm_to_side_plank"},
		22:  {Name: "kneeling_plank"},
		23:  {Name: "weighted_kneeling_plank"},
		24:  {Name: "kneeling_side_plank_with_leg_lift"},
		25:  {Name: "weighted_kneeling_side_plank_with_leg_lift"},
		26:  {Name: "lateral_roll"},
		27:  {Name: "weighted_lateral_roll"},
		28:  {Name: "lying_reverse_plank"},
		29:  {Name: "weighted_lying_reverse_plank"},
		30:  {Name: "medicine_ball_mountain_climber"},
		31:  {Name: "weighted_medicine_ball_mountain_climber"},
		32:  {Name: "modified_mountain_climber_and_extension"},
		33:  {Name: "weighted_modified_mountain_climber_and_extension"},
		34:  {Name: "mountain_climber"},
		35:  {Name: "weighted_mountain_climber"},
		36:  {Name: "mountain_climber_on_sliding_discs"},
		37:  {Name: "weighted_mountain_climber_on_sliding_discs"},
		38:  {Name: "mountain_climber_with_feet_on_bosu_ball"},
		39:  {Name: "weighted_mountain_climber_with_feet_on_bosu_ball"},
		40:  {Name: "mountain_climber_with_hands_on_bench"},
		41:  {Name: "mountain_climber_with_hands_on_swiss_ball"},
		42:  {Name: "weighted_mountain_climber_with_hands_on_swiss_ball"},
		43:  {Name: "plank"},
		44:  {Name: "plank_jacks_with_feet_on_sliding_discs"},
		45:  {Name: "weighted_plank_jacks_with_feet_on_sliding_discs"},
		46:  {Name: "plank_knee_twist"},
		47:  {Name: "weighted_plank_knee_twist"},
		48:  {Name: "plank_pike_jumps"},
		49:  {Name: "weighted_plank_pike_jumps"},
		50:  {Name: "plank_pikes"},
		51:  {Name: "weighted_plank_pikes"},
		52:  {Name: "plank_to_stand_up"},
		53:  {Name: "weighted_plank_to_stand_up"},
		54:  {Name: "plank_with_arm_raise"},
		55:  {Name: "weighted_plank_with_arm_raise"},
		56:  {Name: "plank_with_knee_to_elbow"},
		57:  {Name: "weighted_plank_with_knee_to_elbow"},
		58:  {Name: "plank_with_oblique_crunch"},
		59:  {Name: "weighted_plank_with_oblique_crunch"},
		60:  {Name: "plyometric_side_plank"},
		61:  {Name: "weighted_plyometric_side_plank"},
		62:  {Name: "rolling_side_plank"},
		63:  {Name: "weighted_rolling_side_plank"},
		64:  {Name: "side_kick_plank"},
		65:  {Name: "weighted_side_kick_plank"},
		66:  {Name: "side_plank"},
		67:  {Name: "weighted_side_plank"},
		68:  {Name: "side_plank_and_row"},
		69:  {Name: "weighted_side_plank_and_row"},
		70:  {Name: "side_plank_lift"},
		71:  {Name: "weighted_side_plank_lift"},
		72:  {Name: "side_plank_with_elbow_on_bosu_ball"},
		73:  {Name: "weighted_side_plank_with_elbow_on_bosu_ball"},
		74:  {Name: "side_plank_with_feet_on_bench"},
		75:  {Name: "weighted_side_plank_with_feet_on_bench"},
		76:  {Name: "side_plank_with_knee_circle"},
		77:  {Name: "weighted_side_plank_with_knee_circle"},
		78:  {Name: "side_plank_with_knee_tuck"},
		79:  {Name: "weighted_side_plank_with_knee_tuck"},
		80:  {Name: "side_plank_with_leg_lift"},
		81:  {Name: "weighted_side_plank_with_leg_lift"},
		82:  {Name: "side_plank_with_reach_under"},
		83:  {Name: "weighted_side_plank_with_reach_under"},
		84:  {Name: "single_leg_elevated_feet_plank"},
		85:  {Name: "weighted_single_leg_elevated_feet_plank"},
		86:  {Name: "single_leg_flex_and_extend"},
		87:  {Name: "weighted_single_leg_flex_and_extend"},
		88:  {Name: "single_leg_side_plank"},
		89:  {Name: "weighted_single_leg_side_plank"},
		90:  {Name: "spiderman_plank"},
		91:  {Name: "weighted_spiderman_plank"},
		92:  {Name: "straight_arm_plank"},
		93:  {Name: "weighted_straight_arm_plank"},
		94:  {Name: "straight_arm_plank_with_shoulder_touch"},
		95:  {Name: "weighted_straight_arm_plank_with_shoulder_touch"},
		96:  {Name: "swiss_ball_plank"},
		97:  {Name: "weighted_swiss_ball_plank"},
		98:  {Name: "swiss_ball_plank_leg_lift"},
		99:  {Name: "weighted_swiss_ball_plank_leg_lift"},
		100: {Name: "swiss_ball_plank_leg_lift_and_hold"},
		101: {Name: "swiss_ball_plank_with_feet_on_bench"},
		102: {Name: "weighted_swiss_ball_plank_with_feet_on_bench"},
		103: {Name: "swiss_ball_prone_jackknife"},
		104: {Name: "weighted_swiss_ball_prone_jackknife"},
		105: {Name: "swiss_ball_side_plank"},
		106: {Name: "weighted_swiss_ball_side_plank"},
		107: {Name: "three_way_plank"},
		108: {Name: "weighted_three_way_plank"},
		109: {Name: "towel_plank_and_knee_in"},
		110: {Name: "weighted_towel_plank_and_knee_in"},
		111: {Name: "t_stabilization"},
		112: {Name: "weighted_t_stabilization"},
		113: {Name: "turkish_get_up_to_side_plank"},
		114: {Name: "weighted_turkish_get_up_to_side_plank"},
		115: {Name: "two_point_plank"},
		116: {Name: "weighted_two_point_plank"},
		117: {Name: "weighted_plank"},
		118: {Name: "wide_stance_plank_with_diagonal_arm_lift"},
		119: {Name: "weighted_wide_stance_plank_with_diagonal_arm_lift"},
		120: {Name: "wide_stance_plank_with_diagonal_leg_lift"},
		121: {Name: "weighted_wide_stance_plank_with_diagonal_leg_lift"},
		122: {Name: "wide_stance_plank_with_leg_lift"},
		123: {Name: "weighted_wide_stance_plank_with_leg_lift"},
		124: {Name: "wide_stance_plank_with_opposite_arm_and_leg_lift"},
		125: {Name: "weighted_mountain_climber_with_hands_on_bench"},
		126: {Name: "weighted_swiss_ball_plank_leg_lift_and_hold"},
		127: {Name: "weighted_wide_stance_plank_with_opposite_arm_and_leg_lift"},
		128: {Name: "plank_with_feet_on_swiss_ball"},
		129: {Name: "side_plank_to_plank_with_reach_under"},
		130: {Name: "bridge_with_glute_lower_lift"},
		131: {Name: "bridge_one_leg_bridge"},
		132: {Name: "plank_with_arm_variations"},
		133: {Name: "plank_with_leg_lift"},
		134: {Name: "reverse_plank_with_leg_pull"},
	},
	"plyo_exercise_name": {
		0:  {Name: "alternating_jump_lunge"},
		1:  {Name: "weighted_alternating_jump_lunge"},
		2:  {Name: "barbell_jump_squat"},
		3:  {Name: "body_weight_jump_squat"},
		4:  {Name: "weighted_jump_squat"},
		5:  {Name: "cross_knee_strike"},
		6:  {Name: "weighted_cross_knee_strike"},
		7:  {Name: "depth_jump"},
		8:  {Name: "weighted_depth_jump"},
		9:  {Name: "dumbbell_jump_squat"},
		10: {Name: "dumbbell_split_jump"},
		11: {Name: "front_knee_strike"},
		12: {Name: "weighted_front_knee_strike"},
		13: {Name: "high_box_jump"},
		14: {Name: "weighted_high_box_jump"},
		15: {Name: "isometric_explosive_body_weight_jump_squat"},
		16: {Name: "weighted_isometric_explosive_jump_squat"},
		17: {Name: "lateral_leap_and_hop"},
		18: {Name: "weighted_lateral_leap_and_hop"},
		19: {Name: "lateral_plyo_squats"},
		20: {Name: "weighted_lateral_plyo_squats"},
		21: {Name: "lateral_slide"},
		22: {Name: "weighted_lateral_slide"},
		23: {Name: "medicine_ball_overhead_throws"},
		24: {Name: "medicine_ball_side_throw"},
		25: {Name: "medicine_ball_slam"},
		26: {Name: "side_to_side_medicine_ball_throws"},
		27: {Name: "side_to_side_shuffle_jump"},
		28: {Name: "weighted_side_to_side_shuffle_jump"},
		29: {Name: "squat_jump_onto_box"},
		30: {Name: "weighted_squat_jump_onto_box"},
		31: {Name: "squat_jumps_in_and_out"},
		32: {Name: "weighted_squat_jumps_in_and_out"},
	},
	"pull_up_exercise_name": {
		0:  {Name: "banded_pull_ups"},
		1:  {Name: "30_degree_lat_pulldown"},
		2:  {Name: "band_assisted_chin_up"},
		3:  {Name: "close_grip_chin_up"},
		4:  {Name: "weighted_close_grip_chin_up"},
		5:  {Name: "close_grip_lat_pulldown"},
		6:  {Name: "crossover_chin_up"},
		7:  {Name: "weighted_crossover_chin_up"},
		8:  {Name: "ez_bar_pullover"},
		9:  {Name: "hanging_hurdle"},
		10: {Name: "weighted_hanging_hurdle"},
		11: {Name: "kneeling_lat_pulldown"},
		12: {Name: "kneeling_underhand_grip_lat_pulldown"},
		13: {Name: "lat_pulldown"},
		14: {Name: "mixed_grip_chin_up"},
		15: {Name: "weighted_mixed_grip_chin_up"},
		16: {Name: "mixed_grip_pull_up"},
		17: {Name: "weighted_mixed_grip_pull_up"},
		18: {Name: "reverse_grip_pulldown"},
		19: {Name: "standing_cable_pullover"},
		20: {Name: "straight_arm_pulldown"},
		21: {Name: "swiss_ball_ez_bar_pullover"},
		22: {Name: "towel_pull_up"},
		23: {Name: "weighted_towel_pull_up"},
		24: {Name: "weighted_pull_up"},
		25: {Name: "wide_grip_lat_pulldown"},
		26: {Name: "wide_grip_pull_up"},
		27: {Name: "weighted_wide_grip_pull_up"},
		28: {Name: "burpee_pull_up"},
		29: {Name: "weighted_burpee_pull_up"},
		30: {Name: "jumping_pull_ups"},
		31: {Name: "weighted_jumping_pull_ups"},
		32: {Name: "kipping_pull_up"},
		33: {Name: "weighted_kipping_pull_up"},
		34: {Name: "l_pull_up"},
		35: {Name: "weighted_l_pull_up"},
		36: {Name: "suspended_chin_up"},
		37: {Name: "weighted_suspended_chin_up"},
		38: {Name: "pull_up"},
	},
	"push_up_exercise_name": {
		0:  {Name: "chest_press_with_band"},
		1:  {Name: "alternating_staggered_push_up"},
		2:  {Name: "weighted_alternating_staggered_push_up"},
		3:  {Name: "alternating_hands_medicine_ball_push_up"},
		4:  {Name: "weighted_alternating_hands_medicine_ball_push_up"},
		5:  {Name: "bosu_ball_push_up"},
		6:  {Name: "weighted_bosu_ball_push_up"},
		7:  {Name: "clapping_push_up"},
		8:  {Name: "weighted_clapping_push_up"},
		9:  {Name: "close_grip_medicine_ball_push_up"},
		10: {Name: "weighted_close_grip_medicine_ball_push_up"},
		11: {Name: "close_hands_push_up"},
		12: {Name: "weighted_close_hands_push_up"},
		13: {Name: "decline_push_up"},
		14: {Name: "weighted_decline_push_up"},
		15: {Name: "diamond_push_up"},
		16: {Name: "weighted_diamond_push_up"},
		17: {Name: "explosive_crossover_push_up"},
		18: {Name: "weighted_explosive_crossover_push_up"},
		19: {Name: "explosive_push_up"},
		20: {Name: "weighted_explosive_push_up"},
		21: {Name: "feet_elevated_side_to_side_push_up"},
		22: {Name: "weighted_feet_elevated_side_to_side_push_up"},
		23: {Name: "hand_release_push_up"},
		24: {Name: "weighted_hand_release_push_up"},
		25: {Name: "handstand_push_up"},
		26: {Name: "weighted_handstand_push_up"},
		27: {Name: "incline_push_up"},
		28: {Name: "weighted_incline_push_up"},
		29: {Name: "isometric_explosive_push_up"},
		30: {Name: "weighted_isometric_explosive_push_up"},
		31: {Name: "judo_push_up"},
		32: {Name: "weighted_judo_push_up"},
		33: {Name: "kneeling_push_up"},
		34: {Name: "weighted_kneeling_push_up"},
		35: {Name: "medicine_ball_chest_pass"},
		36: {Name: "medicine_ball_push_up"},
		37: {Name: "weighted_medicine_ball_push_up"},
		38: {Name: "one_arm_push_up"},
		39: {Name: "weighted_one_arm_push_up"},
		40: {Name: "weighted_push_up"},
		41: {Name: "push_up_and_row"},
		42: {Name: "weighted_push_up_and_row"},
		43: {Name: "push_up_plus"},
		44: {Name: "weighted_push_up_plus"},
		45: {Name: "push_up_with_feet_on_swiss_ball"},
		46: {Name: "weighted_push_up_with_feet_on_swiss_ball"},
		47: {Name: "push_up_with_one_hand_on_medicine_ball"},
		48: {Name: "weighted_push_up_with_one_hand_on_medicine_ball"},
		49: {Name: "shoulder_push_up"},
		50: {Name: "weighted_shoulder_push_up"},
		51: {Name: "single_arm_medicine_ball_push_up"},
		52: {Name: "weighted_single_arm_medicine_ball_push_up"},
		53: {Name: "spiderman_push_up"},
		54: {Name: "weighted_spiderman_push_up"},
		55: {Name: "stacked_feet_push_up"},
		56: {Name: "weighted_stacked_feet_push_up"},
		57: {Name: "staggered_hands_push_up"},
		58: {Name: "weighted_staggered_hands_push_up"},
		59: {Name: "suspended_push_up"},
		60: {Name: "weighted_suspended_push_up"},
		61: {Name: "swiss_ball_push_up"},
		62: {Name: "weighted_swiss_ball_push_up"},
		63: {Name: "swiss_ball_push_up_plus"},
		64: {Name: "weighted_swiss_ball_push_up_plus"},
		65: {Name: "t_push_up"},
		66: {Name: "weighted_t_push_up"},
		67: {Name: "triple_stop_push_up"},
		68: {Name: "weighted_triple_stop_push_up"},
		69: {Name: "wide_hands_push_up"},
		70: {Name: "weighted_wide_hands_push_up"},
		71: {Name: "parallette_handstand_push_up"},
		72: {Name: "weighted_parallette_handstand_push_up"},
		73: {Name: "ring_handstand_push_up"},
		74: {Name: "weighted_ring_handstand_push_up"},
		75: {Name: "ring_push_up"},
		76: {Name: "weighted_ring_push_up"},
		77: {Name: "push_up"},
		78: {Name: "pilates_pushup"},
	},
	"row_exercise_name": {
		0:  {Name: "barbell_straight_leg_deadlift_to_row"},
		1:  {Name: "cable_row_standing"},
		2:  {Name: "dumbbell_row"},
		3:  {Name: "elevated_feet_inverted_row"},
		4:  {Name: "weighted_elevated_feet_inverted_row"},
		5:  {Name: "face_pull"},
		6:  {Name: "face_pull_with_external_rotation"},
		7:  {Name: "inverted_row_with_feet_on_swiss_ball"},
		8:  {Name: "weighted_inverted_row_with_feet_on_swiss_ball"},
		9:  {Name: "kettlebell_row"},
		10: {Name: "modified_inverted_row"},
		11: {Name: "weighted_modified_inverted_row"},
		12: {Name: "neutral_grip_alternating_dumbbell_row"},
		13: {Name: "one_arm_bent_over_row"},
		14: {Name: "one_legged_dumbbell_row"},
		15: {Name: "renegade_row"},
		16: {Name: "reverse_grip_barbell_row"},
		17: {Name: "rope_handle_cable_row"},
		18: {Name: "seated_cable_row"},
		19: {Name: "seated_dumbbell_row"},
		20: {Name: "single_arm_cable_row"},
		21: {Name: "single_arm_cable_row_and_rotation"},
		22: {Name: "single_arm_inverted_row"},
		23: {Name: "weighted_single_arm_inverted_row"},
		24: {Name: "single_arm_neutral_grip_dumbbell_row"},
		25: {Name: "single_arm_neutral_grip_dumbbell_row_and_rotation"},
		26: {Name: "suspended_inverted_row"},
		27: {Name: "weighted_suspended_inverted_row"},
		28: {Name: "t_bar_row"},
		29: {Name: "towel_grip_inverted_row"},
		30: {Name: "weighted_towel_grip_inverted_row"},
		31: {Name: "underhand_grip_cable_row"},
		32: {Name: "v_grip_cable_row"},
		33: {Name: "wide_grip_seated_cable_row"},
	},
	"shoulder_press_exercise_name": {
		0:  {Name: "alternating_dumbbell_shoulder_press"},
		1:  {Name: "arnold_press"},
		2:  {Name: "barbell_front_squat_to_push_press"},
		3:  {Name: "barbell_push_press"},
		4:  {Name: "barbell_shoulder_press"},
		5:  {Name: "dead_curl_press"},
		6:  {Name: "dumbbell_alternating_shoulder_press_and_twist"},
		7:  {Name: "dumbbell_hammer_curl_to_lunge_to_press"},
		8:  {Name: "dumbbell_push_press"},
		9:  {Name: "floor_inverted_shoulder_press"},
		10: {Name: "weighted_floor_inverted_shoulder_press"},
		11: {Name: "inverted_shoulder_press"},
		12: {Name: "weighted_inverted_shoulder_press"},
		13: {Name: "one_arm_push_press"},
		14: {Name: "overhead_barbell_press"},
		15: {Name: "overhead_dumbbell_press"},
		16: {Name: "seated_barbell_shoulder_press"},
		17: {Name: "seated_dumbbell_shoulder_press"},
		18: {Name: "single_arm_dumbbell_shoulder_press"},
		19: {Name: "single_arm_step_up_and_press"},
		20: {Name: "smith_machine_overhead_press"},
		21: {Name: "split_stance_hammer_curl_to_press"},
		22: {Name: "swiss_ball_dumbbell_shoulder_press"},
		23: {Name: "weight_plate_front_raise"},
	},
	"shoulder_stability_exercise_name": {
		0:  {Name: "90_degree_cable_external_rotation"},
		1:  {Name: "band_external_rotation"},
		2:  {Name: "band_internal_rotation"},
		3:  {Name: "bent_arm_lateral_raise_and_external_rotation"},
		4:  {Name: "cable_external_rotation"},
		5:  {Name: "dumbbell_face_pull_with_external_rotation"},
		6:  {Name: "floor_i_raise"},
		7:  {Name: "weighted_floor_i_raise"},
		8:  {Name: "floor_t_raise"},
		9:  {Name: "weighted_floor_t_raise"},
		10: {Name: "floor_y_raise"},
		11: {Name: "weighted_floor_y_raise"},
		12: {Name: "incline_i_raise"},
		13: {Name: "weighted_incline_i_raise"},
		14: {Name: "incline_l_raise"},
		15: {Name: "weighted_incline_l_raise"},
		16: {Name: "incline_t_raise"},
		17: {Name: "weighted_incline_t_raise"},
		18: {Name: "incline_w_raise"},
		19: {Name: "weighted_incline_w_raise"},
		20: {Name: "incline_y_raise"},
		21: {Name: "weighted_incline_y_raise"},
		22: {Name: "lying_external_rotation"},
		23: {Name: "seated_dumbbell_external_rotation"},
		24: {Name: "standing_l_raise"},
		25: {Name: "swiss_ball_i_raise"},
		26: {Name: "weighted_swiss_ball_i_raise"},
		27: {Name: "swiss_ball_t_raise"},
		28: {Name: "weighted_swiss_ball_t_raise"},
		29: {Name: "swiss_ball_w_raise"},
		30: {Name: "weighted_swiss_ball_w_raise"},
		31: {Name: "swiss_ball_y_raise"},
		32: {Name: "weighted_swiss_ball_y_raise"},
	},
	"shrug_exercise_name": {
		0:  {Name: "barbell_jump_shrug"},
		1:  {Name: "barbell_shrug"},
		2:  {Name: "barbell_upright_row"},
		3:  {Name: "behind_the_back_smith_machine_shrug"},
		4:  {Name: "dumbbell_jump_shrug"},
		5:  {Name: "dumbbell_shrug"},
		6:  {Name: "dumbbell_upright_row"},
		7:  {Name: "incline_dumbbell_shrug"},
		8:  {Name: "overhead_barbell_shrug"},
		9:  {Name: "overhead_dumbbell_shrug"},
		10: {Name: "scaption_and_shrug"},
		11: {Name: "scapular_retraction"},
		12: {Name: "serratus_chair_shrug"},
		13: {Name: "weighted_serratus_chair_shrug"},
		14: {Name: "serratus_shrug"},
		15: {Name: "weighted_serratus_shrug"},
		16: {Name: "wide_grip_jump_shrug"},
	},
	"sit_up_exercise_name": {
		0:  {Name: "alternating_sit_up"},
		1:  {Name: "weighted_alternating_sit_up"},
		2:  {Name: "bent_knee_v_up"},
		3:  {Name: "weighted_bent_knee_v_up"},
		4:  {Name: "butterfly_sit_up"},
		5:  {Name: "weighted_butterfly_situp"},
		6:  {Name: "cross_punch_roll_up"},
		7:  {Name: "weighted_cross_punch_roll_up"},
		8:  {Name: "crossed_arms_sit_up"},
		9:  {Name: "weighted_crossed_arms_sit_up"},
		10: {Name: "get_up_sit_up"},
		11: {Name: "weighted_get_up_sit_up"},
		12: {Name: "hovering_sit_up"},
		13: {Name: "weighted_hovering_sit_up"},
		14: {Name: "kettlebell_sit_up"},
		15: {Name: "medicine_ball_alternating_v_up"},
		16: {Name: "medicine_ball_sit_up"},
		17: {Name: "medicine_ball_v_up"},
		18: {Name: "modified_sit_up"},
		19: {Name: "negative_sit_up"},
		20: {Name: "one_arm_full_sit_up"},
		21: {Name: "reclining_circle"},
		22: {Name: "weighted_reclining_circle"},
		23: {Name: "reverse_curl_up"},
		24: {Name: "weighted_reverse_curl_up"},
		25: {Name: "single_leg_swiss_ball_jackknife"},
		26: {Name: "weighted_single_leg_swiss_ball_jackknife"},
		27: {Name: "the_teaser"},
		28: {Name: "the_teaser_weighted"},
		29: {Name: "three_part_roll_down"},
		30: {Name: "weighted_three_part_roll_down"},
		31: {Name: "v_up"},
		32: {Name: "weighted_v_up"},
		33: {Name: "weighted_russian_twist_on_swiss_ball"},
		34: {Name: "weighted_sit_up"},
		35: {Name: "x_abs"},
		36: {Name: "weighted_x_abs"},
		37: {Name: "sit_up"},
	},
	"squat_exercise_name": {
		0:  {Name: "leg_press"},
		1:  {Name: "back_squat_with_body_bar"},
		2:  {Name: "back_squats"},
		3:  {Name: "weighted_back_squats"},
		4:  {Name: "balancing_squat"},
		5:  {Name: "weighted_balancing_squat"},
		6:  {Name: "barbell_back_squat"},
		7:  {Name: "barbell_box_squat"},
		8:  {Name: "barbell_front_squat"},
		9:  {Name: "barbell_hack_squat"},
		10: {Name: "barbell_hang_squat_snatch"},
		11: {Name: "barbell_lateral_step_up"},
		12: {Name: "barbell_quarter_squat"},
		13: {Name: "barbell_siff_squat"},
		14: {Name: "barbell_squat_snatch"},
		15: {Name: "barbell_squat_with_heels_raised"},
		16: {Name: "barbell_stepover"},
		17: {Name: "barbell_step_up"},
		18: {Name: "bench_squat_with_rotational_chop"},
		19: {Name: "weighted_bench_squat_with_rotational_chop"},
		20: {Name: "body_weight_wall_squat"},
		21: {Name: "weighted_wall_squat"},
		22: {Name: "box_step_squat"},
		23: {Name: "weighted_box_step_squat"},
		24: {Name: "braced_squat"},
		25: {Name: "crossed_arm_barbell_front_squat"},
		26: {Name: "crossover_dumbbell_step_up"},
		27: {Name: "dumbbell_front_squat"},
		28: {Name: "dumbbell_split_squat"},
		29: {Name: "dumbbell_squat"},
		30: {Name: "dumbbell_squat_clean"},
		31: {Name: "dumbbell_stepover"},
		32: {Name: "dumbbell_step_up"},
		33: {Name: "elevated_single_leg_squat"},
		34: {Name: "weighted_elevated_single_leg_squat"},
		35: {Name: "figure_four_squats"},
		36: {Name: "weighted_figure_four_squats"},
		37: {Name: "goblet_squat"},
		38: {Name: "kettlebell_squat"},
		39: {Name: "kettlebell_swing_overhead"},
		40: {Name: "kettlebell_swing_with_flip_to_squat"},
		41: {Name: "lateral_dumbbell_step_up"},
		42: {Name: "one_legged_squat"},
		43: {Name: "overhead_dumbbell_squat"},
		44: {Name: "overhead_squat"},
		45: {Name: "partial_single_leg_squat"},
		46: {Name: "weighted_partial_single_leg_squat"},
		47: {Name: "pistol_squat"},
		48: {Name: "weighted_pistol_squat"},
		49: {Name: "plie_slides"},
		50: {Name: "weighted_plie_slides"},
		51: {Name: "plie_squat"},
		52: {Name: "weighted_plie_squat"},
		53: {Name: "prisoner_squat"},
		54: {Name: "weighted_prisoner_squat"},
		55: {Name: "single_leg_bench_get_up"},
		56: {Name: "weighted_single_leg_bench_get_up"},
		57: {Name: "single_leg_bench_squat"},
		58: {Name: "weighted_single_leg_bench_squat"},
		59: {Name: "single_leg_squat_on_swiss_ball"},
		60: {Name: "weighted_single_leg_squat_on_swiss_ball"},
		61: {Name: "squat"},
		62: {Name: "weighted_squat"},
		63: {Name: "squats_with_band"},
		64: {Name: "staggered_squat"},
		65: {Name: "weighted_staggered_squat"},
		66: {Name: "step_up"},
		67: {Name: "weighted_step_up"},
		68: {Name: "suitcase_squats"},
		69: {Name: "sumo_squat"},
		70: {Name: "sumo_squat_slide_in"},
		71: {Name: "weighted_sumo_squat_slide_in"},
		72: {Name: "sumo_squat_to_high_pull"},
		73: {Name: "sumo_squat_to_stand"},
		74: {Name: "weighted_sumo_squat_to_stand"},
		75: {Name: "sumo_squat_with_rotation"},
		76: {Name: "weighted_sumo_squat_with_rotation"},
		77: {Name: "swiss_ball_body_weight_wall_squat"},
		78: {Name: "weighted_swiss_ball_wall_squat"},
		79: {Name: "thrusters"},
		80: {Name: "uneven_squat"},
		81: {Name: "weighted_uneven_squat"},
		82: {Name: "waist_slimming_squat"},
		83: {Name: "wall_ball"},
		84: {Name: "wide_stance_barbell_squat"},
		85: {Name: "wide_stance_goblet_squat"},
		86: {Name: "zercher_squat"},
		88: {Name: "squat_and_side_kick"},
		89: {Name: "squat_jumps_in_n_out"},
		90: {Name: "pilates_plie_squats_parallel_turned_out_flat_and_heels"},
		91: {Name: "releve_straight_leg_and_knee_bent_with_one_leg_variation"},
	},
	"total_body_exercise_name": {
		0:  {Name: "burpee"},
		1:  {Name: "weighted_burpee"},
		2:  {Name: "burpee_box_jump"},
		3:  {Name: "weighted_burpee_box_jump"},
		4:  {Name: "high_pull_burpee"},
		5:  {Name: "man_makers"},
		6:  {Name: "one_arm_burpee"},
		7:  {Name: "squat_thrusts"},
		8:  {Name: "weighted_squat_thrusts"},
		9:  {Name: "squat_plank_push_up"},
		10: {Name: "weighted_squat_plank_push_up"},
		11: {Name: "standing_t_rotation_balance"},
		12: {Name: "weighted_standing_t_rotation_balance"},
	},
	"triceps_extension_exercise_name": {
		0:  {Name: "bench_dip"},
		1:  {Name: "weighted_bench_dip"},
		2:  {Name: "body_weight_dip"},
		3:  {Name: "cable_kickback"},
		4:  {Name: "cable_lying_triceps_extension"},
		5:  {Name: "cable_overhead_triceps_extension"},
		6:  {Name: "dumbbell_kickback"},
		7:  {Name: "dumbbell_lying_triceps_extension"},
		8:  {Name: "ez_bar_overhead_triceps_extension"},
		9:  {Name: "incline_dip"},
		10: {Name: "weighted_incline_dip"},
		11: {Name: "incline_ez_bar_lying_triceps_extension"},
		12: {Name: "lying_dumbbell_pullover_to_extension"},
		13: {Name: "lying_ez_bar_triceps_extension"},
		14: {Name: "lying_triceps_extension_to_close_grip_bench_press"},
		15: {Name: "overhead_dumbbell_triceps_extension"},
		16: {Name: "reclining_triceps_press"},
		17: {Name: "reverse_grip_pressdown"},
		18: {Name: "reverse_grip_triceps_pressdown"},
		19: {Name: "rope_pressdown"},
		20: {Name: "seated_barbell_overhead_triceps_extension"},
		21: {Name: "seated_dumbbell_overhead_triceps_extension"},
		22: {Name: "seated_ez_bar_overhead_triceps_extension"},
		23: {Name: "seated_single_arm_overhead_dumbbell_extension"},
		24: {Name: "single_arm_dumbbell_overhead_triceps_extension"},
		25: {Name: "single_dumbbell_seated_overhead_triceps_extension"},
		26: {Name: "single_leg_bench_dip_and_kick"},
		27: {Name: "weighted_single_leg_bench_dip_and_kick"},
		28: {Name: "single_leg_dip"},
		29: {Name: "weighted_single_leg_dip"},
		30: {Name: "static_lying_triceps_extension"},
		31: {Name: "suspended_dip"},
		32: {Name: "weighted_suspended_dip"},
		33: {Name: "swiss_ball_dumbbell_lying_triceps_extension"},
		34: {Name: "swiss_ball_ez_bar_lying_triceps_extension"},
		35: {Name: "swiss_ball_ez_bar_overhead_triceps_extension"},
		36: {Name: "tabletop_dip"},
		37: {Name: "weighted_tabletop_dip"},
		38: {Name: "triceps_extension_on_floor"},
		39: {Name: "triceps_pressdown"},
		40: {Name: "weighted_dip"},
	},
	"warm_up_exercise_name": {
		0:  {Name: "quadruped_rocking"},
		1:  {Name: "neck_tilts"},
		2:  {Name: "ankle_circles"},
		3:  {Name: "ankle_dorsiflexion_with_band"},
		4:  {Name: "ankle_internal_rotation"},
		5:  {Name: "arm_circles"},
		6:  {Name: "bent_over_reach_to_sky"},
		7:  {Name: "cat_camel"},
		8:  {Name: "elbow_to_foot_lunge"},
		9:  {Name: "forward_and_backward_leg_swings"},
		10: {Name: "groiners"},
		11: {Name: "inverted_hamstring_stretch"},
		12: {Name: "lateral_duck_under"},
		13: {Name: "neck_rotations"},
		14: {Name: "opposite_arm_and_leg_balance"},
		15: {Name: "reach_roll_and_lift"},
		17: {Name: "shoulder_circles"},
		18: {Name: "side_to_side_leg_swings"},
		19: {Name: "sleeper_stretch"},
		20: {Name: "slide_out"},
		21: {Name: "swiss_ball_hip_crossover"},
		22: {Name: "swiss_ball_reach_roll_and_lift"},
		23: {Name: "swiss_ball_windshield_wipers"},
		24: {Name: "thoracic_rotation"},
		25: {Name: "walking_high_kicks"},
		26: {Name: "walking_high_knees"},
		27: {Name: "walking_knee_hugs"},
		28: {Name: "walking_leg_cradles"},
		29: {Name: "walkout"},
		30: {Name: "walkout_from_push_up_position"},
	},
	"run_exercise_name": {
		0: {Name: "run"},
		1: {Name: "walk"},
		2: {Name: "jog"},
		3: {Name: "sprint"},
	},
	"water_type": {
		0: {Name: "fresh"},
		1: {Name: "salt"},
		2: {Name: "en13319"},
		3: {Name: "custom"},
	},
	"tissue_model_type": {
		0: {Name: "zhl_16c"},
	},
	"dive_gas_status": {
		0: {Name: "disabled"},
		1: {Name: "enabled"},
		2: {Name: "backup_only"},
	},
	"dive_alert": {
		0:  {Name: "ndl_reached"},
		1:  {Name: "gas_switch_prompted"},
		2:  {Name: "near_surface"},
		3:  {Name: "approaching_ndl"},
		4:  {Name: "po2_warn"},
		5:  {Name: "po2_crit_high"},
		6:  {Name: "po2_crit_low"},
		7:  {Name: "time_alert"},
		8:  {Name: "depth_alert"},
		9:  {Name: "deco_ceiling_broken"},
		10: {Name: "deco_complete"},
		11: {Name: "safety_stop_broken"},
		12: {Name: "safety_stop_complete"},
		13: {Name: "cns_warning"},
		14: {Name: "cns_critical"},
		15: {Name: "otu_warning"},
		16: {Name: "otu_critical"},
		17: {Name: "ascent_critical"},
		18: {Name: "alert_dismissed_by_key"},
		19: {Name: "alert_dismissed_by_timeout"},
		20: {Name: "battery_low"},
		21: {Name: "battery_critical"},
		22: {Name: "safety_stop_started"},
		23: {Name: "approaching_first_deco_stop"},
		24: {Name: "setpoint_switch_auto_low"},
		25: {Name: "setpoint_switch_auto_high"},
		26: {Name: "setpoint_switch_manual_low"},
		27: {Name: "setpoint_switch_manual_high"},
		28: {Name: "auto_setpoint_switch_ignored"},
		29: {Name: "switched_to_open_circuit"},
		30: {Name: "switched_to_closed_circuit"},
		32: {Name: "tank_battery_low"},
		33: {Name: "po2_ccr_dil_low"},
		34: {Name: "deco_stop_cleared"},
		35: {Name: "apnea_neutral_buoyancy"},
		36: {Name: "apnea_target_depth"},
		37: {Name: "apnea_surface"},
		38: {Name: "apnea_high_speed"},
		39: {Name: "apnea_low_speed"},
	},
	"dive_alarm_type": {
		0: {Name: "depth"},
		1: {Name: "time"},
		2: {Name: "speed"},
	},
	"dive_backlight_mode": {
		0: {Name: "at_depth"},
		1: {Name: "always_on"},
	},
	"sleep_level": {
		0: {Name: "unmeasurable"},
		1: {Name: "awake"},
		2: {Name: "light"},
		3: {Name: "deep"},
		4: {Name: "rem"},
	},
	"spo2_measurement_type": {
		0: {Name: "off_wrist"},
		1: {Name: "spot_check"},
		2: {Name: "continuous_check"},
		3: {Name: "periodic"},
	},
	"ccr_setpoint_switch_mode": {
		0: {Name: "manual"},
		1: {Name: "automatic"},
	},
	"dive_gas_mode": {
		0: {Name: "open_circuit"},
		1: {Name: "closed_circuit_diluent"},
	},
	"favero_product": {
		10: {Name: "assioma_uno"},
		12: {Name: "assioma_duo"},
	},
	"split_type": {
		1:  {Name: "ascent_split"},
		2:  {Name: "descent_split"},
		3:  {Name: "interval_active"},
		4:  {Name: "interval_rest"},
		5:  {Name: "interval_warmup"},
		6:  {Name: "interval_cooldown"},
		7:  {Name: "interval_recovery"},
		8:  {Name: "interval_other"},
		9:  {Name: "climb_active"},
		10: {Name: "climb_rest"},
		11: {Name: "surf_active"},
		12: {Name: "run_active"},
		13: {Name: "run_rest"},
		14: {Name: "workout_round"},
		17: {Name: "rwd_run"},
		18: {Name: "rwd_walk"},
		21: {Name: "windsurf_active"},
		22: {Name: "rwd_stand"},
		23: {Name: "transition"},
		28: {Name: "ski_lift_split"},
		29: {Name: "ski_run_split"},
	},
	"climb_pro_event": {
		0: {Name: "approach"},
		1: {Name: "start"},
		2: {Name: "complete"},
	},
	"gas_consumption_rate_type": {
		0: {Name: "pressure_sac"},
		1: {Name: "volume_sac"},
		2: {Name: "rmv"},
	},
	"tap_sensitivity": {
		0: {Name: "high"},
		1: {Name: "medium"},
		2: {Name: "low"},
	},
	"radar_threat_level_type": {
		0: {Name: "threat_unknown"},
		1: {Name: "threat_none"},
		2: {Name: "threat_approaching"},
		3: {Name: "threat_approaching_fast"},
	},
	"max_met_speed_source": {
		0: {Name: "onboard_gps"},
		1: {Name: "connected_gps"},
		2: {Name: "cadence"},
	},
	"max_met_heart_rate_source": {
		0: {Name: "whr"},
		1: {Name: "hrm"},
	},
	"hrv_status": {
		0: {Name: "none"},
		1: {Name: "poor"},
		2: {Name: "low"},
		3: {Name: "unbalanced"},
		4: {Name: "balanced"},
	},
	"no_fly_time_mode": {
		0: {Name: "standard"},
		1: {Name: "flat_24_hours"},
	},
}
