# git town swap

```command-summary
git town swap [--dry-run] [-v | --verbose]
```

The _swap_ command switches the position of the current branch with the branch
ahead of it in the current stack, i.e. moves the current branch one position
forward in the stack.

Consider this stack:

```
main
 \
  branch-1
   \
*   branch-2
     \
      branch-3
```

After running `git town swap` on the `branch-2` branch, you end up with this
stack:

```
main
 \
  branch-2
   \
*   branch-1
     \
      branch-3
```

Moving branches up and down the stack allows you to organize related branches
together, for example to review and ship them as a series, or to
[merge](merge.md) them.

Please ensure that all affected branches are in sync and don't contain merge
commits before running this command, by running [git town sync](sync.md) and
optionally [git town compress](compress.md) before. All affected branches must
be owned by you, i.e. you cannot swap
[contribution](../branch-types.md#contribution-branches),
[observed](../branch-types.md#observed-branches), or
[perennial](../branch-types.md#perennial-branches) branches.

## Options

#### `--dry-run`

Use the `--dry-run` flag to test-drive this command. It prints the Git commands
that would be run but doesn't execute them.

#### `-v`<br>`--verbose`

The `--verbose` aka `-v` flag prints all Git commands run under the hood to
determine the repository state.
