// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/ai/generativelanguage/v1beta/retriever_service.proto

package generativelanguagepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request to create a `Corpus`.
type CreateCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Corpus` to create.
	Corpus *Corpus `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
}

func (x *CreateCorpusRequest) Reset() {
	*x = CreateCorpusRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCorpusRequest) ProtoMessage() {}

func (x *CreateCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCorpusRequest.ProtoReflect.Descriptor instead.
func (*CreateCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateCorpusRequest) GetCorpus() *Corpus {
	if x != nil {
		return x.Corpus
	}
	return nil
}

// Request for getting information about a specific `Corpus`.
type GetCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Corpus`.
	// Example: `corpora/my-corpus-123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCorpusRequest) Reset() {
	*x = GetCorpusRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCorpusRequest) ProtoMessage() {}

func (x *GetCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCorpusRequest.ProtoReflect.Descriptor instead.
func (*GetCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update a `Corpus`.
type UpdateCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Corpus` to update.
	Corpus *Corpus `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
	// Required. The list of fields to update.
	// Currently, this only supports updating `display_name`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCorpusRequest) Reset() {
	*x = UpdateCorpusRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCorpusRequest) ProtoMessage() {}

func (x *UpdateCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCorpusRequest.ProtoReflect.Descriptor instead.
func (*UpdateCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateCorpusRequest) GetCorpus() *Corpus {
	if x != nil {
		return x.Corpus
	}
	return nil
}

func (x *UpdateCorpusRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to delete a `Corpus`.
type DeleteCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the `Corpus`.
	// Example: `corpora/my-corpus-123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, any `Document`s and objects related to this
	// `Corpus` will also be deleted.
	//
	// If false (the default), a `FAILED_PRECONDITION` error will be returned if
	// `Corpus` contains any `Document`s.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteCorpusRequest) Reset() {
	*x = DeleteCorpusRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCorpusRequest) ProtoMessage() {}

func (x *DeleteCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCorpusRequest.ProtoReflect.Descriptor instead.
func (*DeleteCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCorpusRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request for listing `Corpora`.
type ListCorporaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of `Corpora` to return (per page).
	// The service may return fewer `Corpora`.
	//
	// If unspecified, at most 10 `Corpora` will be returned.
	// The maximum size limit is 20 `Corpora` per page.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListCorpora` call.
	//
	// Provide the `next_page_token` returned in the response as an argument to
	// the next request to retrieve the next page.
	//
	// When paginating, all other parameters provided to `ListCorpora`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCorporaRequest) Reset() {
	*x = ListCorporaRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCorporaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorporaRequest) ProtoMessage() {}

func (x *ListCorporaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorporaRequest.ProtoReflect.Descriptor instead.
func (*ListCorporaRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListCorporaRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCorporaRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response from `ListCorpora` containing a paginated list of `Corpora`.
// The results are sorted by ascending `corpus.create_time`.
type ListCorporaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned corpora.
	Corpora []*Corpus `protobuf:"bytes,1,rep,name=corpora,proto3" json:"corpora,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no more pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCorporaResponse) Reset() {
	*x = ListCorporaResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCorporaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorporaResponse) ProtoMessage() {}

func (x *ListCorporaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorporaResponse.ProtoReflect.Descriptor instead.
func (*ListCorporaResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListCorporaResponse) GetCorpora() []*Corpus {
	if x != nil {
		return x.Corpora
	}
	return nil
}

func (x *ListCorporaResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for querying a `Corpus`.
type QueryCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Corpus` to query.
	// Example: `corpora/my-corpus-123`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Query string to perform semantic search.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. Filter for `Chunk` and `Document` metadata. Each `MetadataFilter`
	// object should correspond to a unique key. Multiple `MetadataFilter` objects
	// are joined by logical "AND"s.
	//
	// Example query at document level:
	// (year >= 2020 OR year < 2010) AND (genre = drama OR genre = action)
	//
	// `MetadataFilter` object list:
	//
	//	metadata_filters = [
	//	{key = "document.custom_metadata.year"
	//	 conditions = [{int_value = 2020, operation = GREATER_EQUAL},
	//	               {int_value = 2010, operation = LESS}]},
	//	{key = "document.custom_metadata.year"
	//	 conditions = [{int_value = 2020, operation = GREATER_EQUAL},
	//	               {int_value = 2010, operation = LESS}]},
	//	{key = "document.custom_metadata.genre"
	//	 conditions = [{string_value = "drama", operation = EQUAL},
	//	               {string_value = "action", operation = EQUAL}]}]
	//
	// Example query at chunk level for a numeric range of values:
	// (year > 2015 AND year <= 2020)
	//
	// `MetadataFilter` object list:
	//
	//	metadata_filters = [
	//	{key = "chunk.custom_metadata.year"
	//	 conditions = [{int_value = 2015, operation = GREATER}]},
	//	{key = "chunk.custom_metadata.year"
	//	 conditions = [{int_value = 2020, operation = LESS_EQUAL}]}]
	//
	// Note: "AND"s for the same key are only supported for numeric values. String
	// values only support "OR"s for the same key.
	MetadataFilters []*MetadataFilter `protobuf:"bytes,3,rep,name=metadata_filters,json=metadataFilters,proto3" json:"metadata_filters,omitempty"`
	// Optional. The maximum number of `Chunk`s to return.
	// The service may return fewer `Chunk`s.
	//
	// If unspecified, at most 10 `Chunk`s will be returned.
	// The maximum specified result count is 100.
	ResultsCount int32 `protobuf:"varint,4,opt,name=results_count,json=resultsCount,proto3" json:"results_count,omitempty"`
}

func (x *QueryCorpusRequest) Reset() {
	*x = QueryCorpusRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryCorpusRequest) ProtoMessage() {}

func (x *QueryCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryCorpusRequest.ProtoReflect.Descriptor instead.
func (*QueryCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{6}
}

func (x *QueryCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryCorpusRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *QueryCorpusRequest) GetMetadataFilters() []*MetadataFilter {
	if x != nil {
		return x.MetadataFilters
	}
	return nil
}

func (x *QueryCorpusRequest) GetResultsCount() int32 {
	if x != nil {
		return x.ResultsCount
	}
	return 0
}

// Response from `QueryCorpus` containing a list of relevant chunks.
type QueryCorpusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The relevant chunks.
	RelevantChunks []*RelevantChunk `protobuf:"bytes,1,rep,name=relevant_chunks,json=relevantChunks,proto3" json:"relevant_chunks,omitempty"`
}

func (x *QueryCorpusResponse) Reset() {
	*x = QueryCorpusResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryCorpusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryCorpusResponse) ProtoMessage() {}

func (x *QueryCorpusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryCorpusResponse.ProtoReflect.Descriptor instead.
func (*QueryCorpusResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{7}
}

func (x *QueryCorpusResponse) GetRelevantChunks() []*RelevantChunk {
	if x != nil {
		return x.RelevantChunks
	}
	return nil
}

// The information for a chunk relevant to a query.
type RelevantChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `Chunk` relevance to the query.
	ChunkRelevanceScore float32 `protobuf:"fixed32,1,opt,name=chunk_relevance_score,json=chunkRelevanceScore,proto3" json:"chunk_relevance_score,omitempty"`
	// `Chunk` associated with the query.
	Chunk *Chunk `protobuf:"bytes,2,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (x *RelevantChunk) Reset() {
	*x = RelevantChunk{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RelevantChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RelevantChunk) ProtoMessage() {}

func (x *RelevantChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RelevantChunk.ProtoReflect.Descriptor instead.
func (*RelevantChunk) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{8}
}

func (x *RelevantChunk) GetChunkRelevanceScore() float32 {
	if x != nil {
		return x.ChunkRelevanceScore
	}
	return 0
}

func (x *RelevantChunk) GetChunk() *Chunk {
	if x != nil {
		return x.Chunk
	}
	return nil
}

// Request to create a `Document`.
type CreateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Corpus` where this `Document` will be created.
	// Example: `corpora/my-corpus-123`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The `Document` to create.
	Document *Document `protobuf:"bytes,2,opt,name=document,proto3" json:"document,omitempty"`
}

func (x *CreateDocumentRequest) Reset() {
	*x = CreateDocumentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDocumentRequest) ProtoMessage() {}

func (x *CreateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDocumentRequest.ProtoReflect.Descriptor instead.
func (*CreateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{9}
}

func (x *CreateDocumentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

// Request for getting information about a specific `Document`.
type GetDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Document` to retrieve.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDocumentRequest) Reset() {
	*x = GetDocumentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDocumentRequest) ProtoMessage() {}

func (x *GetDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDocumentRequest.ProtoReflect.Descriptor instead.
func (*GetDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update a `Document`.
type UpdateDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Document` to update.
	Document *Document `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Required. The list of fields to update.
	// Currently, this only supports updating `display_name` and
	// `custom_metadata`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDocumentRequest) Reset() {
	*x = UpdateDocumentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDocumentRequest) ProtoMessage() {}

func (x *UpdateDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDocumentRequest.ProtoReflect.Descriptor instead.
func (*UpdateDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateDocumentRequest) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *UpdateDocumentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to delete a `Document`.
type DeleteDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the `Document` to delete.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set to true, any `Chunk`s and objects related to this
	// `Document` will also be deleted.
	//
	// If false (the default), a `FAILED_PRECONDITION` error will be returned if
	// `Document` contains any `Chunk`s.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteDocumentRequest) Reset() {
	*x = DeleteDocumentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentRequest) ProtoMessage() {}

func (x *DeleteDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDocumentRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request for listing `Document`s.
type ListDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Corpus` containing `Document`s.
	// Example: `corpora/my-corpus-123`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Document`s to return (per page).
	// The service may return fewer `Document`s.
	//
	// If unspecified, at most 10 `Document`s will be returned.
	// The maximum size limit is 20 `Document`s per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListDocuments` call.
	//
	// Provide the `next_page_token` returned in the response as an argument to
	// the next request to retrieve the next page.
	//
	// When paginating, all other parameters provided to `ListDocuments`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDocumentsRequest) Reset() {
	*x = ListDocumentsRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsRequest) ProtoMessage() {}

func (x *ListDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ListDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{13}
}

func (x *ListDocumentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDocumentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDocumentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response from `ListDocuments` containing a paginated list of `Document`s.
// The `Document`s are sorted by ascending `document.create_time`.
type ListDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned `Document`s.
	Documents []*Document `protobuf:"bytes,1,rep,name=documents,proto3" json:"documents,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no more pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDocumentsResponse) Reset() {
	*x = ListDocumentsResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentsResponse) ProtoMessage() {}

func (x *ListDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ListDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListDocumentsResponse) GetDocuments() []*Document {
	if x != nil {
		return x.Documents
	}
	return nil
}

func (x *ListDocumentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for querying a `Document`.
type QueryDocumentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Document` to query.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Query string to perform semantic search.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The maximum number of `Chunk`s to return.
	// The service may return fewer `Chunk`s.
	//
	// If unspecified, at most 10 `Chunk`s will be returned.
	// The maximum specified result count is 100.
	ResultsCount int32 `protobuf:"varint,3,opt,name=results_count,json=resultsCount,proto3" json:"results_count,omitempty"`
	// Optional. Filter for `Chunk` metadata. Each `MetadataFilter` object should
	// correspond to a unique key. Multiple `MetadataFilter` objects are joined by
	// logical "AND"s.
	//
	// Note: `Document`-level filtering is not supported for this request because
	// a `Document` name is already specified.
	//
	// Example query:
	// (year >= 2020 OR year < 2010) AND (genre = drama OR genre = action)
	//
	// `MetadataFilter` object list:
	//
	//	metadata_filters = [
	//	{key = "chunk.custom_metadata.year"
	//	 conditions = [{int_value = 2020, operation = GREATER_EQUAL},
	//	               {int_value = 2010, operation = LESS}},
	//	{key = "chunk.custom_metadata.genre"
	//	 conditions = [{string_value = "drama", operation = EQUAL},
	//	               {string_value = "action", operation = EQUAL}}]
	//
	// Example query for a numeric range of values:
	// (year > 2015 AND year <= 2020)
	//
	// `MetadataFilter` object list:
	//
	//	metadata_filters = [
	//	{key = "chunk.custom_metadata.year"
	//	 conditions = [{int_value = 2015, operation = GREATER}]},
	//	{key = "chunk.custom_metadata.year"
	//	 conditions = [{int_value = 2020, operation = LESS_EQUAL}]}]
	//
	// Note: "AND"s for the same key are only supported for numeric values. String
	// values only support "OR"s for the same key.
	MetadataFilters []*MetadataFilter `protobuf:"bytes,4,rep,name=metadata_filters,json=metadataFilters,proto3" json:"metadata_filters,omitempty"`
}

func (x *QueryDocumentRequest) Reset() {
	*x = QueryDocumentRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryDocumentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDocumentRequest) ProtoMessage() {}

func (x *QueryDocumentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDocumentRequest.ProtoReflect.Descriptor instead.
func (*QueryDocumentRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{15}
}

func (x *QueryDocumentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QueryDocumentRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *QueryDocumentRequest) GetResultsCount() int32 {
	if x != nil {
		return x.ResultsCount
	}
	return 0
}

func (x *QueryDocumentRequest) GetMetadataFilters() []*MetadataFilter {
	if x != nil {
		return x.MetadataFilters
	}
	return nil
}

// Response from `QueryDocument` containing a list of relevant chunks.
type QueryDocumentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned relevant chunks.
	RelevantChunks []*RelevantChunk `protobuf:"bytes,1,rep,name=relevant_chunks,json=relevantChunks,proto3" json:"relevant_chunks,omitempty"`
}

func (x *QueryDocumentResponse) Reset() {
	*x = QueryDocumentResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryDocumentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryDocumentResponse) ProtoMessage() {}

func (x *QueryDocumentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryDocumentResponse.ProtoReflect.Descriptor instead.
func (*QueryDocumentResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{16}
}

func (x *QueryDocumentResponse) GetRelevantChunks() []*RelevantChunk {
	if x != nil {
		return x.RelevantChunks
	}
	return nil
}

// Request to create a `Chunk`.
type CreateChunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Document` where this `Chunk` will be created.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The `Chunk` to create.
	Chunk *Chunk `protobuf:"bytes,2,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (x *CreateChunkRequest) Reset() {
	*x = CreateChunkRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateChunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChunkRequest) ProtoMessage() {}

func (x *CreateChunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChunkRequest.ProtoReflect.Descriptor instead.
func (*CreateChunkRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{17}
}

func (x *CreateChunkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChunkRequest) GetChunk() *Chunk {
	if x != nil {
		return x.Chunk
	}
	return nil
}

// Request to batch create `Chunk`s.
type BatchCreateChunksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the `Document` where this batch of `Chunk`s will be
	// created. The parent field in every `CreateChunkRequest` must match this
	// value. Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request messages specifying the `Chunk`s to create.
	// A maximum of 100 `Chunk`s can be created in a batch.
	Requests []*CreateChunkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateChunksRequest) Reset() {
	*x = BatchCreateChunksRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCreateChunksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateChunksRequest) ProtoMessage() {}

func (x *BatchCreateChunksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateChunksRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateChunksRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{18}
}

func (x *BatchCreateChunksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateChunksRequest) GetRequests() []*CreateChunkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response from `BatchCreateChunks` containing a list of created `Chunk`s.
type BatchCreateChunksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `Chunk`s created.
	Chunks []*Chunk `protobuf:"bytes,1,rep,name=chunks,proto3" json:"chunks,omitempty"`
}

func (x *BatchCreateChunksResponse) Reset() {
	*x = BatchCreateChunksResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCreateChunksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateChunksResponse) ProtoMessage() {}

func (x *BatchCreateChunksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateChunksResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateChunksResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{19}
}

func (x *BatchCreateChunksResponse) GetChunks() []*Chunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

// Request for getting information about a specific `Chunk`.
type GetChunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Chunk` to retrieve.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc/chunks/some-chunk`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetChunkRequest) Reset() {
	*x = GetChunkRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetChunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetChunkRequest) ProtoMessage() {}

func (x *GetChunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetChunkRequest.ProtoReflect.Descriptor instead.
func (*GetChunkRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{20}
}

func (x *GetChunkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update a `Chunk`.
type UpdateChunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Chunk` to update.
	Chunk *Chunk `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
	// Required. The list of fields to update.
	// Currently, this only supports updating `custom_metadata` and `data`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateChunkRequest) Reset() {
	*x = UpdateChunkRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateChunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateChunkRequest) ProtoMessage() {}

func (x *UpdateChunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateChunkRequest.ProtoReflect.Descriptor instead.
func (*UpdateChunkRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateChunkRequest) GetChunk() *Chunk {
	if x != nil {
		return x.Chunk
	}
	return nil
}

func (x *UpdateChunkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to batch update `Chunk`s.
type BatchUpdateChunksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the `Document` containing the `Chunk`s to update.
	// The parent field in every `UpdateChunkRequest` must match this value.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request messages specifying the `Chunk`s to update.
	// A maximum of 100 `Chunk`s can be updated in a batch.
	Requests []*UpdateChunkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchUpdateChunksRequest) Reset() {
	*x = BatchUpdateChunksRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchUpdateChunksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateChunksRequest) ProtoMessage() {}

func (x *BatchUpdateChunksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateChunksRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateChunksRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{22}
}

func (x *BatchUpdateChunksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchUpdateChunksRequest) GetRequests() []*UpdateChunkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response from `BatchUpdateChunks` containing a list of updated `Chunk`s.
type BatchUpdateChunksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `Chunk`s updated.
	Chunks []*Chunk `protobuf:"bytes,1,rep,name=chunks,proto3" json:"chunks,omitempty"`
}

func (x *BatchUpdateChunksResponse) Reset() {
	*x = BatchUpdateChunksResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchUpdateChunksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateChunksResponse) ProtoMessage() {}

func (x *BatchUpdateChunksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateChunksResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateChunksResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{23}
}

func (x *BatchUpdateChunksResponse) GetChunks() []*Chunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

// Request to delete a `Chunk`.
type DeleteChunkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the `Chunk` to delete.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc/chunks/some-chunk`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteChunkRequest) Reset() {
	*x = DeleteChunkRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteChunkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteChunkRequest) ProtoMessage() {}

func (x *DeleteChunkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteChunkRequest.ProtoReflect.Descriptor instead.
func (*DeleteChunkRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{24}
}

func (x *DeleteChunkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to batch delete `Chunk`s.
type BatchDeleteChunksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the `Document` containing the `Chunk`s to delete.
	// The parent field in every `DeleteChunkRequest` must match this value.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request messages specifying the `Chunk`s to delete.
	Requests []*DeleteChunkRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchDeleteChunksRequest) Reset() {
	*x = BatchDeleteChunksRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchDeleteChunksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteChunksRequest) ProtoMessage() {}

func (x *BatchDeleteChunksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteChunksRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteChunksRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{25}
}

func (x *BatchDeleteChunksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteChunksRequest) GetRequests() []*DeleteChunkRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Request for listing `Chunk`s.
type ListChunksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Document` containing `Chunk`s.
	// Example: `corpora/my-corpus-123/documents/the-doc-abc`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `Chunk`s to return (per page).
	// The service may return fewer `Chunk`s.
	//
	// If unspecified, at most 10 `Chunk`s will be returned.
	// The maximum size limit is 100 `Chunk`s per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListChunks` call.
	//
	// Provide the `next_page_token` returned in the response as an argument to
	// the next request to retrieve the next page.
	//
	// When paginating, all other parameters provided to `ListChunks`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListChunksRequest) Reset() {
	*x = ListChunksRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListChunksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChunksRequest) ProtoMessage() {}

func (x *ListChunksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChunksRequest.ProtoReflect.Descriptor instead.
func (*ListChunksRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{26}
}

func (x *ListChunksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListChunksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListChunksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response from `ListChunks` containing a paginated list of `Chunk`s.
// The `Chunk`s are sorted by ascending `chunk.create_time`.
type ListChunksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The returned `Chunk`s.
	Chunks []*Chunk `protobuf:"bytes,1,rep,name=chunks,proto3" json:"chunks,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no more pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListChunksResponse) Reset() {
	*x = ListChunksResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListChunksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChunksResponse) ProtoMessage() {}

func (x *ListChunksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChunksResponse.ProtoReflect.Descriptor instead.
func (*ListChunksResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListChunksResponse) GetChunks() []*Chunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

func (x *ListChunksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_ai_generativelanguage_v1beta_retriever_service_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5f, 0x0a, 0x13, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x58, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa1, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x76, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x22, 0x5a, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x84, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x52, 0x07, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x84, 0x02, 0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x10, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x72, 0x0a, 0x13, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5b, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x0e,
	0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x22, 0x85,
	0x01, 0x0a, 0x0d, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x12, 0x32, 0x0a, 0x15, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x13, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52,
	0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0xb3, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x5c, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x15, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x7a, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x12, 0x2a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88, 0x02, 0x0a,
	0x14, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x63, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0x74, 0x0a, 0x15, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5b, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x0e, 0x72,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x22, 0xa4, 0x01,
	0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a,
	0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x22, 0xbd, 0x01, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x22, 0x5f, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x06, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x73, 0x22, 0x56, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01,
	0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xbd, 0x01,
	0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x29, 0x12, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x5f, 0x0a,
	0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x22, 0x59,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbd, 0x01, 0x0a, 0x18, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x29, 0x12, 0x27,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x58, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0xa2, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x80,
	0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x52, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x32, 0xf4, 0x1c, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x9f, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x28,
	0xda, 0x41, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x19, 0x3a,
	0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x0f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x98, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x27, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1a, 0x12, 0x18, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x44, 0xda, 0x41, 0x12,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x3a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x32, 0x1f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a,
	0x7d, 0x12, 0x89, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x27, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1a, 0x2a, 0x18, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x12, 0x99, 0x01,
	0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x17, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x11, 0x12, 0x0f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x12, 0xab, 0x01, 0x0a, 0x0b, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x23, 0x3a, 0x01, 0x2a, 0x22, 0x1e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a,
	0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0xc5, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x48, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a,
	0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0xaa, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x33, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x56, 0xda, 0x41, 0x14, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x32, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x99, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x33, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x2a, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f,
	0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbd,
	0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xbd,
	0x01, 0x0a, 0x0d, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a,
	0x01, 0x2a, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0xbf,
	0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x22, 0x4b, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x05, 0x63, 0x68, 0x75, 0x6e,
	0x6b, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x12, 0xd8, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a,
	0x22, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x3a,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0xaa, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xca, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0x56, 0xda,
	0x41, 0x11, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x32, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x75, 0x6e,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd8, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x12, 0x9c, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f,
	0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xb0, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x44, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x68, 0x75, 0x6e,
	0x6b, 0x73, 0x1a, 0x24, 0xca, 0x41, 0x21, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xa1, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x42, 0x15, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescData = file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDesc
)

func file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDescData
}

var file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_google_ai_generativelanguage_v1beta_retriever_service_proto_goTypes = []any{
	(*CreateCorpusRequest)(nil),       // 0: google.ai.generativelanguage.v1beta.CreateCorpusRequest
	(*GetCorpusRequest)(nil),          // 1: google.ai.generativelanguage.v1beta.GetCorpusRequest
	(*UpdateCorpusRequest)(nil),       // 2: google.ai.generativelanguage.v1beta.UpdateCorpusRequest
	(*DeleteCorpusRequest)(nil),       // 3: google.ai.generativelanguage.v1beta.DeleteCorpusRequest
	(*ListCorporaRequest)(nil),        // 4: google.ai.generativelanguage.v1beta.ListCorporaRequest
	(*ListCorporaResponse)(nil),       // 5: google.ai.generativelanguage.v1beta.ListCorporaResponse
	(*QueryCorpusRequest)(nil),        // 6: google.ai.generativelanguage.v1beta.QueryCorpusRequest
	(*QueryCorpusResponse)(nil),       // 7: google.ai.generativelanguage.v1beta.QueryCorpusResponse
	(*RelevantChunk)(nil),             // 8: google.ai.generativelanguage.v1beta.RelevantChunk
	(*CreateDocumentRequest)(nil),     // 9: google.ai.generativelanguage.v1beta.CreateDocumentRequest
	(*GetDocumentRequest)(nil),        // 10: google.ai.generativelanguage.v1beta.GetDocumentRequest
	(*UpdateDocumentRequest)(nil),     // 11: google.ai.generativelanguage.v1beta.UpdateDocumentRequest
	(*DeleteDocumentRequest)(nil),     // 12: google.ai.generativelanguage.v1beta.DeleteDocumentRequest
	(*ListDocumentsRequest)(nil),      // 13: google.ai.generativelanguage.v1beta.ListDocumentsRequest
	(*ListDocumentsResponse)(nil),     // 14: google.ai.generativelanguage.v1beta.ListDocumentsResponse
	(*QueryDocumentRequest)(nil),      // 15: google.ai.generativelanguage.v1beta.QueryDocumentRequest
	(*QueryDocumentResponse)(nil),     // 16: google.ai.generativelanguage.v1beta.QueryDocumentResponse
	(*CreateChunkRequest)(nil),        // 17: google.ai.generativelanguage.v1beta.CreateChunkRequest
	(*BatchCreateChunksRequest)(nil),  // 18: google.ai.generativelanguage.v1beta.BatchCreateChunksRequest
	(*BatchCreateChunksResponse)(nil), // 19: google.ai.generativelanguage.v1beta.BatchCreateChunksResponse
	(*GetChunkRequest)(nil),           // 20: google.ai.generativelanguage.v1beta.GetChunkRequest
	(*UpdateChunkRequest)(nil),        // 21: google.ai.generativelanguage.v1beta.UpdateChunkRequest
	(*BatchUpdateChunksRequest)(nil),  // 22: google.ai.generativelanguage.v1beta.BatchUpdateChunksRequest
	(*BatchUpdateChunksResponse)(nil), // 23: google.ai.generativelanguage.v1beta.BatchUpdateChunksResponse
	(*DeleteChunkRequest)(nil),        // 24: google.ai.generativelanguage.v1beta.DeleteChunkRequest
	(*BatchDeleteChunksRequest)(nil),  // 25: google.ai.generativelanguage.v1beta.BatchDeleteChunksRequest
	(*ListChunksRequest)(nil),         // 26: google.ai.generativelanguage.v1beta.ListChunksRequest
	(*ListChunksResponse)(nil),        // 27: google.ai.generativelanguage.v1beta.ListChunksResponse
	(*Corpus)(nil),                    // 28: google.ai.generativelanguage.v1beta.Corpus
	(*fieldmaskpb.FieldMask)(nil),     // 29: google.protobuf.FieldMask
	(*MetadataFilter)(nil),            // 30: google.ai.generativelanguage.v1beta.MetadataFilter
	(*Chunk)(nil),                     // 31: google.ai.generativelanguage.v1beta.Chunk
	(*Document)(nil),                  // 32: google.ai.generativelanguage.v1beta.Document
	(*emptypb.Empty)(nil),             // 33: google.protobuf.Empty
}
var file_google_ai_generativelanguage_v1beta_retriever_service_proto_depIdxs = []int32{
	28, // 0: google.ai.generativelanguage.v1beta.CreateCorpusRequest.corpus:type_name -> google.ai.generativelanguage.v1beta.Corpus
	28, // 1: google.ai.generativelanguage.v1beta.UpdateCorpusRequest.corpus:type_name -> google.ai.generativelanguage.v1beta.Corpus
	29, // 2: google.ai.generativelanguage.v1beta.UpdateCorpusRequest.update_mask:type_name -> google.protobuf.FieldMask
	28, // 3: google.ai.generativelanguage.v1beta.ListCorporaResponse.corpora:type_name -> google.ai.generativelanguage.v1beta.Corpus
	30, // 4: google.ai.generativelanguage.v1beta.QueryCorpusRequest.metadata_filters:type_name -> google.ai.generativelanguage.v1beta.MetadataFilter
	8,  // 5: google.ai.generativelanguage.v1beta.QueryCorpusResponse.relevant_chunks:type_name -> google.ai.generativelanguage.v1beta.RelevantChunk
	31, // 6: google.ai.generativelanguage.v1beta.RelevantChunk.chunk:type_name -> google.ai.generativelanguage.v1beta.Chunk
	32, // 7: google.ai.generativelanguage.v1beta.CreateDocumentRequest.document:type_name -> google.ai.generativelanguage.v1beta.Document
	32, // 8: google.ai.generativelanguage.v1beta.UpdateDocumentRequest.document:type_name -> google.ai.generativelanguage.v1beta.Document
	29, // 9: google.ai.generativelanguage.v1beta.UpdateDocumentRequest.update_mask:type_name -> google.protobuf.FieldMask
	32, // 10: google.ai.generativelanguage.v1beta.ListDocumentsResponse.documents:type_name -> google.ai.generativelanguage.v1beta.Document
	30, // 11: google.ai.generativelanguage.v1beta.QueryDocumentRequest.metadata_filters:type_name -> google.ai.generativelanguage.v1beta.MetadataFilter
	8,  // 12: google.ai.generativelanguage.v1beta.QueryDocumentResponse.relevant_chunks:type_name -> google.ai.generativelanguage.v1beta.RelevantChunk
	31, // 13: google.ai.generativelanguage.v1beta.CreateChunkRequest.chunk:type_name -> google.ai.generativelanguage.v1beta.Chunk
	17, // 14: google.ai.generativelanguage.v1beta.BatchCreateChunksRequest.requests:type_name -> google.ai.generativelanguage.v1beta.CreateChunkRequest
	31, // 15: google.ai.generativelanguage.v1beta.BatchCreateChunksResponse.chunks:type_name -> google.ai.generativelanguage.v1beta.Chunk
	31, // 16: google.ai.generativelanguage.v1beta.UpdateChunkRequest.chunk:type_name -> google.ai.generativelanguage.v1beta.Chunk
	29, // 17: google.ai.generativelanguage.v1beta.UpdateChunkRequest.update_mask:type_name -> google.protobuf.FieldMask
	21, // 18: google.ai.generativelanguage.v1beta.BatchUpdateChunksRequest.requests:type_name -> google.ai.generativelanguage.v1beta.UpdateChunkRequest
	31, // 19: google.ai.generativelanguage.v1beta.BatchUpdateChunksResponse.chunks:type_name -> google.ai.generativelanguage.v1beta.Chunk
	24, // 20: google.ai.generativelanguage.v1beta.BatchDeleteChunksRequest.requests:type_name -> google.ai.generativelanguage.v1beta.DeleteChunkRequest
	31, // 21: google.ai.generativelanguage.v1beta.ListChunksResponse.chunks:type_name -> google.ai.generativelanguage.v1beta.Chunk
	0,  // 22: google.ai.generativelanguage.v1beta.RetrieverService.CreateCorpus:input_type -> google.ai.generativelanguage.v1beta.CreateCorpusRequest
	1,  // 23: google.ai.generativelanguage.v1beta.RetrieverService.GetCorpus:input_type -> google.ai.generativelanguage.v1beta.GetCorpusRequest
	2,  // 24: google.ai.generativelanguage.v1beta.RetrieverService.UpdateCorpus:input_type -> google.ai.generativelanguage.v1beta.UpdateCorpusRequest
	3,  // 25: google.ai.generativelanguage.v1beta.RetrieverService.DeleteCorpus:input_type -> google.ai.generativelanguage.v1beta.DeleteCorpusRequest
	4,  // 26: google.ai.generativelanguage.v1beta.RetrieverService.ListCorpora:input_type -> google.ai.generativelanguage.v1beta.ListCorporaRequest
	6,  // 27: google.ai.generativelanguage.v1beta.RetrieverService.QueryCorpus:input_type -> google.ai.generativelanguage.v1beta.QueryCorpusRequest
	9,  // 28: google.ai.generativelanguage.v1beta.RetrieverService.CreateDocument:input_type -> google.ai.generativelanguage.v1beta.CreateDocumentRequest
	10, // 29: google.ai.generativelanguage.v1beta.RetrieverService.GetDocument:input_type -> google.ai.generativelanguage.v1beta.GetDocumentRequest
	11, // 30: google.ai.generativelanguage.v1beta.RetrieverService.UpdateDocument:input_type -> google.ai.generativelanguage.v1beta.UpdateDocumentRequest
	12, // 31: google.ai.generativelanguage.v1beta.RetrieverService.DeleteDocument:input_type -> google.ai.generativelanguage.v1beta.DeleteDocumentRequest
	13, // 32: google.ai.generativelanguage.v1beta.RetrieverService.ListDocuments:input_type -> google.ai.generativelanguage.v1beta.ListDocumentsRequest
	15, // 33: google.ai.generativelanguage.v1beta.RetrieverService.QueryDocument:input_type -> google.ai.generativelanguage.v1beta.QueryDocumentRequest
	17, // 34: google.ai.generativelanguage.v1beta.RetrieverService.CreateChunk:input_type -> google.ai.generativelanguage.v1beta.CreateChunkRequest
	18, // 35: google.ai.generativelanguage.v1beta.RetrieverService.BatchCreateChunks:input_type -> google.ai.generativelanguage.v1beta.BatchCreateChunksRequest
	20, // 36: google.ai.generativelanguage.v1beta.RetrieverService.GetChunk:input_type -> google.ai.generativelanguage.v1beta.GetChunkRequest
	21, // 37: google.ai.generativelanguage.v1beta.RetrieverService.UpdateChunk:input_type -> google.ai.generativelanguage.v1beta.UpdateChunkRequest
	22, // 38: google.ai.generativelanguage.v1beta.RetrieverService.BatchUpdateChunks:input_type -> google.ai.generativelanguage.v1beta.BatchUpdateChunksRequest
	24, // 39: google.ai.generativelanguage.v1beta.RetrieverService.DeleteChunk:input_type -> google.ai.generativelanguage.v1beta.DeleteChunkRequest
	25, // 40: google.ai.generativelanguage.v1beta.RetrieverService.BatchDeleteChunks:input_type -> google.ai.generativelanguage.v1beta.BatchDeleteChunksRequest
	26, // 41: google.ai.generativelanguage.v1beta.RetrieverService.ListChunks:input_type -> google.ai.generativelanguage.v1beta.ListChunksRequest
	28, // 42: google.ai.generativelanguage.v1beta.RetrieverService.CreateCorpus:output_type -> google.ai.generativelanguage.v1beta.Corpus
	28, // 43: google.ai.generativelanguage.v1beta.RetrieverService.GetCorpus:output_type -> google.ai.generativelanguage.v1beta.Corpus
	28, // 44: google.ai.generativelanguage.v1beta.RetrieverService.UpdateCorpus:output_type -> google.ai.generativelanguage.v1beta.Corpus
	33, // 45: google.ai.generativelanguage.v1beta.RetrieverService.DeleteCorpus:output_type -> google.protobuf.Empty
	5,  // 46: google.ai.generativelanguage.v1beta.RetrieverService.ListCorpora:output_type -> google.ai.generativelanguage.v1beta.ListCorporaResponse
	7,  // 47: google.ai.generativelanguage.v1beta.RetrieverService.QueryCorpus:output_type -> google.ai.generativelanguage.v1beta.QueryCorpusResponse
	32, // 48: google.ai.generativelanguage.v1beta.RetrieverService.CreateDocument:output_type -> google.ai.generativelanguage.v1beta.Document
	32, // 49: google.ai.generativelanguage.v1beta.RetrieverService.GetDocument:output_type -> google.ai.generativelanguage.v1beta.Document
	32, // 50: google.ai.generativelanguage.v1beta.RetrieverService.UpdateDocument:output_type -> google.ai.generativelanguage.v1beta.Document
	33, // 51: google.ai.generativelanguage.v1beta.RetrieverService.DeleteDocument:output_type -> google.protobuf.Empty
	14, // 52: google.ai.generativelanguage.v1beta.RetrieverService.ListDocuments:output_type -> google.ai.generativelanguage.v1beta.ListDocumentsResponse
	16, // 53: google.ai.generativelanguage.v1beta.RetrieverService.QueryDocument:output_type -> google.ai.generativelanguage.v1beta.QueryDocumentResponse
	31, // 54: google.ai.generativelanguage.v1beta.RetrieverService.CreateChunk:output_type -> google.ai.generativelanguage.v1beta.Chunk
	19, // 55: google.ai.generativelanguage.v1beta.RetrieverService.BatchCreateChunks:output_type -> google.ai.generativelanguage.v1beta.BatchCreateChunksResponse
	31, // 56: google.ai.generativelanguage.v1beta.RetrieverService.GetChunk:output_type -> google.ai.generativelanguage.v1beta.Chunk
	31, // 57: google.ai.generativelanguage.v1beta.RetrieverService.UpdateChunk:output_type -> google.ai.generativelanguage.v1beta.Chunk
	23, // 58: google.ai.generativelanguage.v1beta.RetrieverService.BatchUpdateChunks:output_type -> google.ai.generativelanguage.v1beta.BatchUpdateChunksResponse
	33, // 59: google.ai.generativelanguage.v1beta.RetrieverService.DeleteChunk:output_type -> google.protobuf.Empty
	33, // 60: google.ai.generativelanguage.v1beta.RetrieverService.BatchDeleteChunks:output_type -> google.protobuf.Empty
	27, // 61: google.ai.generativelanguage.v1beta.RetrieverService.ListChunks:output_type -> google.ai.generativelanguage.v1beta.ListChunksResponse
	42, // [42:62] is the sub-list for method output_type
	22, // [22:42] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1beta_retriever_service_proto_init() }
func file_google_ai_generativelanguage_v1beta_retriever_service_proto_init() {
	if File_google_ai_generativelanguage_v1beta_retriever_service_proto != nil {
		return
	}
	file_google_ai_generativelanguage_v1beta_retriever_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ai_generativelanguage_v1beta_retriever_service_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1beta_retriever_service_proto_depIdxs,
		MessageInfos:      file_google_ai_generativelanguage_v1beta_retriever_service_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1beta_retriever_service_proto = out.File
	file_google_ai_generativelanguage_v1beta_retriever_service_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1beta_retriever_service_proto_goTypes = nil
	file_google_ai_generativelanguage_v1beta_retriever_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RetrieverServiceClient is the client API for RetrieverService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RetrieverServiceClient interface {
	// Creates an empty `Corpus`.
	CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Gets information about a specific `Corpus`.
	GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Updates a `Corpus`.
	UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Deletes a `Corpus`.
	DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all `Corpora` owned by the user.
	ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error)
	// Performs semantic search over a `Corpus`.
	QueryCorpus(ctx context.Context, in *QueryCorpusRequest, opts ...grpc.CallOption) (*QueryCorpusResponse, error)
	// Creates an empty `Document`.
	CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Gets information about a specific `Document`.
	GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Updates a `Document`.
	UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error)
	// Deletes a `Document`.
	DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all `Document`s in a `Corpus`.
	ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error)
	// Performs semantic search over a `Document`.
	QueryDocument(ctx context.Context, in *QueryDocumentRequest, opts ...grpc.CallOption) (*QueryDocumentResponse, error)
	// Creates a `Chunk`.
	CreateChunk(ctx context.Context, in *CreateChunkRequest, opts ...grpc.CallOption) (*Chunk, error)
	// Batch create `Chunk`s.
	BatchCreateChunks(ctx context.Context, in *BatchCreateChunksRequest, opts ...grpc.CallOption) (*BatchCreateChunksResponse, error)
	// Gets information about a specific `Chunk`.
	GetChunk(ctx context.Context, in *GetChunkRequest, opts ...grpc.CallOption) (*Chunk, error)
	// Updates a `Chunk`.
	UpdateChunk(ctx context.Context, in *UpdateChunkRequest, opts ...grpc.CallOption) (*Chunk, error)
	// Batch update `Chunk`s.
	BatchUpdateChunks(ctx context.Context, in *BatchUpdateChunksRequest, opts ...grpc.CallOption) (*BatchUpdateChunksResponse, error)
	// Deletes a `Chunk`.
	DeleteChunk(ctx context.Context, in *DeleteChunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Batch delete `Chunk`s.
	BatchDeleteChunks(ctx context.Context, in *BatchDeleteChunksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all `Chunk`s in a `Document`.
	ListChunks(ctx context.Context, in *ListChunksRequest, opts ...grpc.CallOption) (*ListChunksResponse, error)
}

type retrieverServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRetrieverServiceClient(cc grpc.ClientConnInterface) RetrieverServiceClient {
	return &retrieverServiceClient{cc}
}

func (c *retrieverServiceClient) CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/CreateCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/GetCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/UpdateCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/DeleteCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error) {
	out := new(ListCorporaResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/ListCorpora", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) QueryCorpus(ctx context.Context, in *QueryCorpusRequest, opts ...grpc.CallOption) (*QueryCorpusResponse, error) {
	out := new(QueryCorpusResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/QueryCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) CreateDocument(ctx context.Context, in *CreateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/CreateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) GetDocument(ctx context.Context, in *GetDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/GetDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) UpdateDocument(ctx context.Context, in *UpdateDocumentRequest, opts ...grpc.CallOption) (*Document, error) {
	out := new(Document)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/UpdateDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) DeleteDocument(ctx context.Context, in *DeleteDocumentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/DeleteDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) ListDocuments(ctx context.Context, in *ListDocumentsRequest, opts ...grpc.CallOption) (*ListDocumentsResponse, error) {
	out := new(ListDocumentsResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/ListDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) QueryDocument(ctx context.Context, in *QueryDocumentRequest, opts ...grpc.CallOption) (*QueryDocumentResponse, error) {
	out := new(QueryDocumentResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/QueryDocument", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) CreateChunk(ctx context.Context, in *CreateChunkRequest, opts ...grpc.CallOption) (*Chunk, error) {
	out := new(Chunk)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/CreateChunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) BatchCreateChunks(ctx context.Context, in *BatchCreateChunksRequest, opts ...grpc.CallOption) (*BatchCreateChunksResponse, error) {
	out := new(BatchCreateChunksResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/BatchCreateChunks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) GetChunk(ctx context.Context, in *GetChunkRequest, opts ...grpc.CallOption) (*Chunk, error) {
	out := new(Chunk)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/GetChunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) UpdateChunk(ctx context.Context, in *UpdateChunkRequest, opts ...grpc.CallOption) (*Chunk, error) {
	out := new(Chunk)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/UpdateChunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) BatchUpdateChunks(ctx context.Context, in *BatchUpdateChunksRequest, opts ...grpc.CallOption) (*BatchUpdateChunksResponse, error) {
	out := new(BatchUpdateChunksResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/BatchUpdateChunks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) DeleteChunk(ctx context.Context, in *DeleteChunkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/DeleteChunk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) BatchDeleteChunks(ctx context.Context, in *BatchDeleteChunksRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/BatchDeleteChunks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *retrieverServiceClient) ListChunks(ctx context.Context, in *ListChunksRequest, opts ...grpc.CallOption) (*ListChunksResponse, error) {
	out := new(ListChunksResponse)
	err := c.cc.Invoke(ctx, "/google.ai.generativelanguage.v1beta.RetrieverService/ListChunks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RetrieverServiceServer is the server API for RetrieverService service.
type RetrieverServiceServer interface {
	// Creates an empty `Corpus`.
	CreateCorpus(context.Context, *CreateCorpusRequest) (*Corpus, error)
	// Gets information about a specific `Corpus`.
	GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error)
	// Updates a `Corpus`.
	UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error)
	// Deletes a `Corpus`.
	DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error)
	// Lists all `Corpora` owned by the user.
	ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error)
	// Performs semantic search over a `Corpus`.
	QueryCorpus(context.Context, *QueryCorpusRequest) (*QueryCorpusResponse, error)
	// Creates an empty `Document`.
	CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error)
	// Gets information about a specific `Document`.
	GetDocument(context.Context, *GetDocumentRequest) (*Document, error)
	// Updates a `Document`.
	UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error)
	// Deletes a `Document`.
	DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error)
	// Lists all `Document`s in a `Corpus`.
	ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error)
	// Performs semantic search over a `Document`.
	QueryDocument(context.Context, *QueryDocumentRequest) (*QueryDocumentResponse, error)
	// Creates a `Chunk`.
	CreateChunk(context.Context, *CreateChunkRequest) (*Chunk, error)
	// Batch create `Chunk`s.
	BatchCreateChunks(context.Context, *BatchCreateChunksRequest) (*BatchCreateChunksResponse, error)
	// Gets information about a specific `Chunk`.
	GetChunk(context.Context, *GetChunkRequest) (*Chunk, error)
	// Updates a `Chunk`.
	UpdateChunk(context.Context, *UpdateChunkRequest) (*Chunk, error)
	// Batch update `Chunk`s.
	BatchUpdateChunks(context.Context, *BatchUpdateChunksRequest) (*BatchUpdateChunksResponse, error)
	// Deletes a `Chunk`.
	DeleteChunk(context.Context, *DeleteChunkRequest) (*emptypb.Empty, error)
	// Batch delete `Chunk`s.
	BatchDeleteChunks(context.Context, *BatchDeleteChunksRequest) (*emptypb.Empty, error)
	// Lists all `Chunk`s in a `Document`.
	ListChunks(context.Context, *ListChunksRequest) (*ListChunksResponse, error)
}

// UnimplementedRetrieverServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRetrieverServiceServer struct {
}

func (*UnimplementedRetrieverServiceServer) CreateCorpus(context.Context, *CreateCorpusRequest) (*Corpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCorpus not implemented")
}
func (*UnimplementedRetrieverServiceServer) GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCorpus not implemented")
}
func (*UnimplementedRetrieverServiceServer) UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCorpus not implemented")
}
func (*UnimplementedRetrieverServiceServer) DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCorpus not implemented")
}
func (*UnimplementedRetrieverServiceServer) ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCorpora not implemented")
}
func (*UnimplementedRetrieverServiceServer) QueryCorpus(context.Context, *QueryCorpusRequest) (*QueryCorpusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryCorpus not implemented")
}
func (*UnimplementedRetrieverServiceServer) CreateDocument(context.Context, *CreateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocument not implemented")
}
func (*UnimplementedRetrieverServiceServer) GetDocument(context.Context, *GetDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocument not implemented")
}
func (*UnimplementedRetrieverServiceServer) UpdateDocument(context.Context, *UpdateDocumentRequest) (*Document, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocument not implemented")
}
func (*UnimplementedRetrieverServiceServer) DeleteDocument(context.Context, *DeleteDocumentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocument not implemented")
}
func (*UnimplementedRetrieverServiceServer) ListDocuments(context.Context, *ListDocumentsRequest) (*ListDocumentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocuments not implemented")
}
func (*UnimplementedRetrieverServiceServer) QueryDocument(context.Context, *QueryDocumentRequest) (*QueryDocumentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryDocument not implemented")
}
func (*UnimplementedRetrieverServiceServer) CreateChunk(context.Context, *CreateChunkRequest) (*Chunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChunk not implemented")
}
func (*UnimplementedRetrieverServiceServer) BatchCreateChunks(context.Context, *BatchCreateChunksRequest) (*BatchCreateChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateChunks not implemented")
}
func (*UnimplementedRetrieverServiceServer) GetChunk(context.Context, *GetChunkRequest) (*Chunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChunk not implemented")
}
func (*UnimplementedRetrieverServiceServer) UpdateChunk(context.Context, *UpdateChunkRequest) (*Chunk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChunk not implemented")
}
func (*UnimplementedRetrieverServiceServer) BatchUpdateChunks(context.Context, *BatchUpdateChunksRequest) (*BatchUpdateChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateChunks not implemented")
}
func (*UnimplementedRetrieverServiceServer) DeleteChunk(context.Context, *DeleteChunkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChunk not implemented")
}
func (*UnimplementedRetrieverServiceServer) BatchDeleteChunks(context.Context, *BatchDeleteChunksRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteChunks not implemented")
}
func (*UnimplementedRetrieverServiceServer) ListChunks(context.Context, *ListChunksRequest) (*ListChunksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChunks not implemented")
}

func RegisterRetrieverServiceServer(s *grpc.Server, srv RetrieverServiceServer) {
	s.RegisterService(&_RetrieverService_serviceDesc, srv)
}

func _RetrieverService_CreateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).CreateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/CreateCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).CreateCorpus(ctx, req.(*CreateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_GetCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).GetCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/GetCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).GetCorpus(ctx, req.(*GetCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_UpdateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).UpdateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/UpdateCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).UpdateCorpus(ctx, req.(*UpdateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_DeleteCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).DeleteCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/DeleteCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).DeleteCorpus(ctx, req.(*DeleteCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_ListCorpora_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCorporaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).ListCorpora(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/ListCorpora",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).ListCorpora(ctx, req.(*ListCorporaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_QueryCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).QueryCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/QueryCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).QueryCorpus(ctx, req.(*QueryCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_CreateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).CreateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/CreateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).CreateDocument(ctx, req.(*CreateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_GetDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).GetDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/GetDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).GetDocument(ctx, req.(*GetDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_UpdateDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).UpdateDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/UpdateDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).UpdateDocument(ctx, req.(*UpdateDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_DeleteDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).DeleteDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/DeleteDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).DeleteDocument(ctx, req.(*DeleteDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_ListDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).ListDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/ListDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).ListDocuments(ctx, req.(*ListDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_QueryDocument_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryDocumentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).QueryDocument(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/QueryDocument",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).QueryDocument(ctx, req.(*QueryDocumentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_CreateChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).CreateChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/CreateChunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).CreateChunk(ctx, req.(*CreateChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_BatchCreateChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).BatchCreateChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/BatchCreateChunks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).BatchCreateChunks(ctx, req.(*BatchCreateChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_GetChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).GetChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/GetChunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).GetChunk(ctx, req.(*GetChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_UpdateChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).UpdateChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/UpdateChunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).UpdateChunk(ctx, req.(*UpdateChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_BatchUpdateChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).BatchUpdateChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/BatchUpdateChunks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).BatchUpdateChunks(ctx, req.(*BatchUpdateChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_DeleteChunk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChunkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).DeleteChunk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/DeleteChunk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).DeleteChunk(ctx, req.(*DeleteChunkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_BatchDeleteChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).BatchDeleteChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/BatchDeleteChunks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).BatchDeleteChunks(ctx, req.(*BatchDeleteChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RetrieverService_ListChunks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChunksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RetrieverServiceServer).ListChunks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ai.generativelanguage.v1beta.RetrieverService/ListChunks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RetrieverServiceServer).ListChunks(ctx, req.(*ListChunksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RetrieverService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1beta.RetrieverService",
	HandlerType: (*RetrieverServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCorpus",
			Handler:    _RetrieverService_CreateCorpus_Handler,
		},
		{
			MethodName: "GetCorpus",
			Handler:    _RetrieverService_GetCorpus_Handler,
		},
		{
			MethodName: "UpdateCorpus",
			Handler:    _RetrieverService_UpdateCorpus_Handler,
		},
		{
			MethodName: "DeleteCorpus",
			Handler:    _RetrieverService_DeleteCorpus_Handler,
		},
		{
			MethodName: "ListCorpora",
			Handler:    _RetrieverService_ListCorpora_Handler,
		},
		{
			MethodName: "QueryCorpus",
			Handler:    _RetrieverService_QueryCorpus_Handler,
		},
		{
			MethodName: "CreateDocument",
			Handler:    _RetrieverService_CreateDocument_Handler,
		},
		{
			MethodName: "GetDocument",
			Handler:    _RetrieverService_GetDocument_Handler,
		},
		{
			MethodName: "UpdateDocument",
			Handler:    _RetrieverService_UpdateDocument_Handler,
		},
		{
			MethodName: "DeleteDocument",
			Handler:    _RetrieverService_DeleteDocument_Handler,
		},
		{
			MethodName: "ListDocuments",
			Handler:    _RetrieverService_ListDocuments_Handler,
		},
		{
			MethodName: "QueryDocument",
			Handler:    _RetrieverService_QueryDocument_Handler,
		},
		{
			MethodName: "CreateChunk",
			Handler:    _RetrieverService_CreateChunk_Handler,
		},
		{
			MethodName: "BatchCreateChunks",
			Handler:    _RetrieverService_BatchCreateChunks_Handler,
		},
		{
			MethodName: "GetChunk",
			Handler:    _RetrieverService_GetChunk_Handler,
		},
		{
			MethodName: "UpdateChunk",
			Handler:    _RetrieverService_UpdateChunk_Handler,
		},
		{
			MethodName: "BatchUpdateChunks",
			Handler:    _RetrieverService_BatchUpdateChunks_Handler,
		},
		{
			MethodName: "DeleteChunk",
			Handler:    _RetrieverService_DeleteChunk_Handler,
		},
		{
			MethodName: "BatchDeleteChunks",
			Handler:    _RetrieverService_BatchDeleteChunks_Handler,
		},
		{
			MethodName: "ListChunks",
			Handler:    _RetrieverService_ListChunks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ai/generativelanguage/v1beta/retriever_service.proto",
}
