// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1/model_evaluation_slice.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A collection of metrics calculated by comparing Model's predictions on a
// slice of the test data against ground truth annotations.
type ModelEvaluationSlice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the ModelEvaluationSlice.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The slice of the test data that is used to evaluate the Model.
	Slice *ModelEvaluationSlice_Slice `protobuf:"bytes,2,opt,name=slice,proto3" json:"slice,omitempty"`
	// Output only. Points to a YAML file stored on Google Cloud Storage
	// describing the
	// [metrics][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics] of this
	// ModelEvaluationSlice. The schema is defined as an OpenAPI 3.0.2 [Schema
	// Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	MetricsSchemaUri string `protobuf:"bytes,3,opt,name=metrics_schema_uri,json=metricsSchemaUri,proto3" json:"metrics_schema_uri,omitempty"`
	// Output only. Sliced evaluation metrics of the Model. The schema of the
	// metrics is stored in
	// [metrics_schema_uri][google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics_schema_uri]
	Metrics *structpb.Value `protobuf:"bytes,4,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// Output only. Timestamp when this ModelEvaluationSlice was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Aggregated explanation metrics for the Model's prediction
	// output over the data this ModelEvaluation uses. This field is populated
	// only if the Model is evaluated with explanations, and only for tabular
	// Models.
	ModelExplanation *ModelExplanation `protobuf:"bytes,6,opt,name=model_explanation,json=modelExplanation,proto3" json:"model_explanation,omitempty"`
}

func (x *ModelEvaluationSlice) Reset() {
	*x = ModelEvaluationSlice{}
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelEvaluationSlice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelEvaluationSlice) ProtoMessage() {}

func (x *ModelEvaluationSlice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelEvaluationSlice.ProtoReflect.Descriptor instead.
func (*ModelEvaluationSlice) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP(), []int{0}
}

func (x *ModelEvaluationSlice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModelEvaluationSlice) GetSlice() *ModelEvaluationSlice_Slice {
	if x != nil {
		return x.Slice
	}
	return nil
}

func (x *ModelEvaluationSlice) GetMetricsSchemaUri() string {
	if x != nil {
		return x.MetricsSchemaUri
	}
	return ""
}

func (x *ModelEvaluationSlice) GetMetrics() *structpb.Value {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *ModelEvaluationSlice) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ModelEvaluationSlice) GetModelExplanation() *ModelExplanation {
	if x != nil {
		return x.ModelExplanation
	}
	return nil
}

// Definition of a slice.
type ModelEvaluationSlice_Slice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The dimension of the slice.
	// Well-known dimensions are:
	//   - `annotationSpec`: This slice is on the test data that has either
	//     ground truth or prediction with
	//     [AnnotationSpec.display_name][google.cloud.aiplatform.v1.AnnotationSpec.display_name]
	//     equals to
	//     [value][google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.value].
	//   - `slice`: This slice is a user customized slice defined by its
	//     SliceSpec.
	Dimension string `protobuf:"bytes,1,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// Output only. The value of the dimension in this slice.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Output only. Specification for how the data was sliced.
	SliceSpec *ModelEvaluationSlice_Slice_SliceSpec `protobuf:"bytes,3,opt,name=slice_spec,json=sliceSpec,proto3" json:"slice_spec,omitempty"`
}

func (x *ModelEvaluationSlice_Slice) Reset() {
	*x = ModelEvaluationSlice_Slice{}
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelEvaluationSlice_Slice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelEvaluationSlice_Slice) ProtoMessage() {}

func (x *ModelEvaluationSlice_Slice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelEvaluationSlice_Slice.ProtoReflect.Descriptor instead.
func (*ModelEvaluationSlice_Slice) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ModelEvaluationSlice_Slice) GetDimension() string {
	if x != nil {
		return x.Dimension
	}
	return ""
}

func (x *ModelEvaluationSlice_Slice) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *ModelEvaluationSlice_Slice) GetSliceSpec() *ModelEvaluationSlice_Slice_SliceSpec {
	if x != nil {
		return x.SliceSpec
	}
	return nil
}

// Specification for how the data should be sliced.
type ModelEvaluationSlice_Slice_SliceSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mapping configuration for this SliceSpec.
	// The key is the name of the feature.
	// By default, the key will be prefixed by "instance" as a dictionary
	// prefix for Vertex Batch Predictions output format.
	Configs map[string]*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ModelEvaluationSlice_Slice_SliceSpec) Reset() {
	*x = ModelEvaluationSlice_Slice_SliceSpec{}
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelEvaluationSlice_Slice_SliceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelEvaluationSlice_Slice_SliceSpec) ProtoMessage() {}

func (x *ModelEvaluationSlice_Slice_SliceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelEvaluationSlice_Slice_SliceSpec.ProtoReflect.Descriptor instead.
func (*ModelEvaluationSlice_Slice_SliceSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *ModelEvaluationSlice_Slice_SliceSpec) GetConfigs() map[string]*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig {
	if x != nil {
		return x.Configs
	}
	return nil
}

// Specification message containing the config for this SliceSpec.
// When `kind` is selected as `value` and/or `range`, only a single slice
// will be computed.
// When `all_values` is present, a separate slice will be computed for
// each possible label/value for the corresponding key in `config`.
// Examples, with feature zip_code with values 12345, 23334, 88888 and
// feature country with values "US", "Canada", "Mexico" in the dataset:
//
// Example 1:
//
//	{
//	  "zip_code": { "value": { "float_value": 12345.0 } }
//	}
//
// A single slice for any data with zip_code 12345 in the dataset.
//
// Example 2:
//
//	{
//	  "zip_code": { "range": { "low": 12345, "high": 20000 } }
//	}
//
// A single slice containing data where the zip_codes between 12345 and
// 20000 For this example, data with the zip_code of 12345 will be in this
// slice.
//
// Example 3:
//
//	{
//	  "zip_code": { "range": { "low": 10000, "high": 20000 } },
//	  "country": { "value": { "string_value": "US" } }
//	}
//
// A single slice containing data where the zip_codes between 10000 and
// 20000 has the country "US". For this example, data with the zip_code of
// 12345 and country "US" will be in this slice.
//
// Example 4:
//
//	{ "country": {"all_values": { "value": true } } }
//
// Three slices are computed, one for each unique country in the dataset.
//
// Example 5:
//
//	{
//	  "country": { "all_values": { "value": true } },
//	  "zip_code": { "value": { "float_value": 12345.0 } }
//	}
//
// Three slices are computed, one for each unique country in the dataset
// where the zip_code is also 12345. For this example, data with zip_code
// 12345 and country "US" will be in one slice, zip_code 12345 and country
// "Canada" in another slice, and zip_code 12345 and country "Mexico" in
// another slice, totaling 3 slices.
type ModelEvaluationSlice_Slice_SliceSpec_SliceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Value
	//	*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Range
	//	*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_AllValues
	Kind isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind `protobuf_oneof:"kind"`
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) Reset() {
	*x = ModelEvaluationSlice_Slice_SliceSpec_SliceConfig{}
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) ProtoMessage() {}

func (x *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelEvaluationSlice_Slice_SliceSpec_SliceConfig.ProtoReflect.Descriptor instead.
func (*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP(), []int{0, 0, 0, 0}
}

func (m *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) GetKind() isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) GetValue() *ModelEvaluationSlice_Slice_SliceSpec_Value {
	if x, ok := x.GetKind().(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Value); ok {
		return x.Value
	}
	return nil
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) GetRange() *ModelEvaluationSlice_Slice_SliceSpec_Range {
	if x, ok := x.GetKind().(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Range); ok {
		return x.Range
	}
	return nil
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_SliceConfig) GetAllValues() *wrapperspb.BoolValue {
	if x, ok := x.GetKind().(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_AllValues); ok {
		return x.AllValues
	}
	return nil
}

type isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind interface {
	isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind()
}

type ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Value struct {
	// A unique specific value for a given feature.
	// Example: `{ "value": { "string_value": "12345" } }`
	Value *ModelEvaluationSlice_Slice_SliceSpec_Value `protobuf:"bytes,1,opt,name=value,proto3,oneof"`
}

type ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Range struct {
	// A range of values for a numerical feature.
	// Example: `{"range":{"low":10000.0,"high":50000.0}}`
	// will capture 12345 and 23334 in the slice.
	Range *ModelEvaluationSlice_Slice_SliceSpec_Range `protobuf:"bytes,2,opt,name=range,proto3,oneof"`
}

type ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_AllValues struct {
	// If all_values is set to true, then all possible labels of the keyed
	// feature will have another slice computed.
	// Example: `{"all_values":{"value":true}}`
	AllValues *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=all_values,json=allValues,proto3,oneof"`
}

func (*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Value) isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind() {
}

func (*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Range) isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind() {
}

func (*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_AllValues) isModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Kind() {
}

// A range of values for slice(s).
// `low` is inclusive, `high` is exclusive.
type ModelEvaluationSlice_Slice_SliceSpec_Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Inclusive low value for the range.
	Low float32 `protobuf:"fixed32,1,opt,name=low,proto3" json:"low,omitempty"`
	// Exclusive high value for the range.
	High float32 `protobuf:"fixed32,2,opt,name=high,proto3" json:"high,omitempty"`
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Range) Reset() {
	*x = ModelEvaluationSlice_Slice_SliceSpec_Range{}
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelEvaluationSlice_Slice_SliceSpec_Range) ProtoMessage() {}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelEvaluationSlice_Slice_SliceSpec_Range.ProtoReflect.Descriptor instead.
func (*ModelEvaluationSlice_Slice_SliceSpec_Range) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP(), []int{0, 0, 0, 1}
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Range) GetLow() float32 {
	if x != nil {
		return x.Low
	}
	return 0
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Range) GetHigh() float32 {
	if x != nil {
		return x.High
	}
	return 0
}

// Single value that supports strings and floats.
type ModelEvaluationSlice_Slice_SliceSpec_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*ModelEvaluationSlice_Slice_SliceSpec_Value_StringValue
	//	*ModelEvaluationSlice_Slice_SliceSpec_Value_FloatValue
	Kind isModelEvaluationSlice_Slice_SliceSpec_Value_Kind `protobuf_oneof:"kind"`
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Value) Reset() {
	*x = ModelEvaluationSlice_Slice_SliceSpec_Value{}
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelEvaluationSlice_Slice_SliceSpec_Value) ProtoMessage() {}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelEvaluationSlice_Slice_SliceSpec_Value.ProtoReflect.Descriptor instead.
func (*ModelEvaluationSlice_Slice_SliceSpec_Value) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP(), []int{0, 0, 0, 2}
}

func (m *ModelEvaluationSlice_Slice_SliceSpec_Value) GetKind() isModelEvaluationSlice_Slice_SliceSpec_Value_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Value) GetStringValue() string {
	if x, ok := x.GetKind().(*ModelEvaluationSlice_Slice_SliceSpec_Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *ModelEvaluationSlice_Slice_SliceSpec_Value) GetFloatValue() float32 {
	if x, ok := x.GetKind().(*ModelEvaluationSlice_Slice_SliceSpec_Value_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

type isModelEvaluationSlice_Slice_SliceSpec_Value_Kind interface {
	isModelEvaluationSlice_Slice_SliceSpec_Value_Kind()
}

type ModelEvaluationSlice_Slice_SliceSpec_Value_StringValue struct {
	// String type.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type ModelEvaluationSlice_Slice_SliceSpec_Value_FloatValue struct {
	// Float type.
	FloatValue float32 `protobuf:"fixed32,2,opt,name=float_value,json=floatValue,proto3,oneof"`
}

func (*ModelEvaluationSlice_Slice_SliceSpec_Value_StringValue) isModelEvaluationSlice_Slice_SliceSpec_Value_Kind() {
}

func (*ModelEvaluationSlice_Slice_SliceSpec_Value_FloatValue) isModelEvaluationSlice_Slice_SliceSpec_Value_Kind() {
}

var File_google_cloud_aiplatform_v1_model_evaluation_slice_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6c,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf2,
	0x0a, 0x0a, 0x14, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x51, 0x0a, 0x05, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6c, 0x69, 0x63,
	0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x6c,
	0x69, 0x63, 0x65, 0x12, 0x31, 0x0a, 0x12, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x12, 0x35, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x5e, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xca, 0x06, 0x0a, 0x05, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x64, 0x0a, 0x0a, 0x73, 0x6c, 0x69, 0x63, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c,
	0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x1a, 0x9c, 0x05,
	0x0a, 0x09, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x67, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53,
	0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x1a, 0x92, 0x02, 0x0a, 0x0b, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x5e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x5e, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x2d, 0x0a, 0x05, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x03, 0x6c, 0x6f, 0x77, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x69, 0x67, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68, 0x1a, 0x57, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x66,
	0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x1a, 0x88, 0x01, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x62, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x6c, 0x69, 0x63,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x94, 0x01, 0xea,
	0x41, 0x90, 0x01, 0x0a, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6c,
	0x69, 0x63, 0x65, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6c, 0x69,
	0x63, 0x65, 0x7d, 0x42, 0xd7, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x19, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescData = file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_goTypes = []any{
	(*ModelEvaluationSlice)(nil),                             // 0: google.cloud.aiplatform.v1.ModelEvaluationSlice
	(*ModelEvaluationSlice_Slice)(nil),                       // 1: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice
	(*ModelEvaluationSlice_Slice_SliceSpec)(nil),             // 2: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
	(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig)(nil), // 3: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
	(*ModelEvaluationSlice_Slice_SliceSpec_Range)(nil),       // 4: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
	(*ModelEvaluationSlice_Slice_SliceSpec_Value)(nil),       // 5: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
	nil,                           // 6: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ConfigsEntry
	(*structpb.Value)(nil),        // 7: google.protobuf.Value
	(*timestamppb.Timestamp)(nil), // 8: google.protobuf.Timestamp
	(*ModelExplanation)(nil),      // 9: google.cloud.aiplatform.v1.ModelExplanation
	(*wrapperspb.BoolValue)(nil),  // 10: google.protobuf.BoolValue
}
var file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_depIdxs = []int32{
	1,  // 0: google.cloud.aiplatform.v1.ModelEvaluationSlice.slice:type_name -> google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice
	7,  // 1: google.cloud.aiplatform.v1.ModelEvaluationSlice.metrics:type_name -> google.protobuf.Value
	8,  // 2: google.cloud.aiplatform.v1.ModelEvaluationSlice.create_time:type_name -> google.protobuf.Timestamp
	9,  // 3: google.cloud.aiplatform.v1.ModelEvaluationSlice.model_explanation:type_name -> google.cloud.aiplatform.v1.ModelExplanation
	2,  // 4: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.slice_spec:type_name -> google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec
	6,  // 5: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.configs:type_name -> google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ConfigsEntry
	5,  // 6: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig.value:type_name -> google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Value
	4,  // 7: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig.range:type_name -> google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.Range
	10, // 8: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig.all_values:type_name -> google.protobuf.BoolValue
	3,  // 9: google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.ConfigsEntry.value:type_name -> google.cloud.aiplatform.v1.ModelEvaluationSlice.Slice.SliceSpec.SliceConfig
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_init() }
func file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_init() {
	if File_google_cloud_aiplatform_v1_model_evaluation_slice_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_explanation_proto_init()
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[3].OneofWrappers = []any{
		(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Value)(nil),
		(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_Range)(nil),
		(*ModelEvaluationSlice_Slice_SliceSpec_SliceConfig_AllValues)(nil),
	}
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes[5].OneofWrappers = []any{
		(*ModelEvaluationSlice_Slice_SliceSpec_Value_StringValue)(nil),
		(*ModelEvaluationSlice_Slice_SliceSpec_Value_FloatValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_model_evaluation_slice_proto = out.File
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_model_evaluation_slice_proto_depIdxs = nil
}
