// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/alloydb/v1beta/data_model.proto

package alloydbpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// SqlResult represents the result for the execution of a sql statement.
type SqlResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of columns included in the result. This also includes the data type
	// of the column.
	Columns []*SqlResultColumn `protobuf:"bytes,1,rep,name=columns,proto3" json:"columns,omitempty"`
	// Rows returned by the SQL statement.
	Rows []*SqlResultRow `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
}

func (x *SqlResult) Reset() {
	*x = SqlResult{}
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SqlResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlResult) ProtoMessage() {}

func (x *SqlResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlResult.ProtoReflect.Descriptor instead.
func (*SqlResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1beta_data_model_proto_rawDescGZIP(), []int{0}
}

func (x *SqlResult) GetColumns() []*SqlResultColumn {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *SqlResult) GetRows() []*SqlResultRow {
	if x != nil {
		return x.Rows
	}
	return nil
}

// Contains the name and datatype of a column in a SQL Result.
type SqlResultColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the column.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Datatype of the column as reported by the postgres driver.
	// Common type names are "VARCHAR", "TEXT", "NVARCHAR", "DECIMAL", "BOOL",
	// "INT", and "BIGINT".
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *SqlResultColumn) Reset() {
	*x = SqlResultColumn{}
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SqlResultColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlResultColumn) ProtoMessage() {}

func (x *SqlResultColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlResultColumn.ProtoReflect.Descriptor instead.
func (*SqlResultColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1beta_data_model_proto_rawDescGZIP(), []int{1}
}

func (x *SqlResultColumn) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SqlResultColumn) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// A single row from a sql result.
type SqlResultRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of values in a row of sql result.
	Values []*SqlResultValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SqlResultRow) Reset() {
	*x = SqlResultRow{}
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SqlResultRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlResultRow) ProtoMessage() {}

func (x *SqlResultRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlResultRow.ProtoReflect.Descriptor instead.
func (*SqlResultRow) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1beta_data_model_proto_rawDescGZIP(), []int{2}
}

func (x *SqlResultRow) GetValues() []*SqlResultValue {
	if x != nil {
		return x.Values
	}
	return nil
}

// A single value in a row from a sql result.
type SqlResultValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The cell value represented in string format.
	// Timestamps are converted to string using RFC3339Nano format.
	Value *string `protobuf:"bytes,1,opt,name=value,proto3,oneof" json:"value,omitempty"`
	// Set to true if cell value is null.
	NullValue *bool `protobuf:"varint,2,opt,name=null_value,json=nullValue,proto3,oneof" json:"null_value,omitempty"`
}

func (x *SqlResultValue) Reset() {
	*x = SqlResultValue{}
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SqlResultValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlResultValue) ProtoMessage() {}

func (x *SqlResultValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlResultValue.ProtoReflect.Descriptor instead.
func (*SqlResultValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_alloydb_v1beta_data_model_proto_rawDescGZIP(), []int{3}
}

func (x *SqlResultValue) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

func (x *SqlResultValue) GetNullValue() bool {
	if x != nil && x.NullValue != nil {
		return *x.NullValue
	}
	return false
}

var File_google_cloud_alloydb_v1beta_data_model_proto protoreflect.FileDescriptor

var file_google_cloud_alloydb_v1beta_data_model_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c,
	0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x22, 0x92, 0x01, 0x0a, 0x09,
	0x53, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64,
	0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x12, 0x3d, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x71,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73,
	0x22, 0x39, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x53, 0x0a, 0x0c, 0x53,
	0x71, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x6f, 0x77, 0x12, 0x43, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x6c, 0x6c, 0x6f, 0x79,
	0x64, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x22, 0x68, 0x0a, 0x0e, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a,
	0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x01, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0xcb, 0x01, 0x0a, 0x1f, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0e,
	0x44, 0x61, 0x74, 0x61, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x39, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x70,
	0x62, 0x3b, 0x61, 0x6c, 0x6c, 0x6f, 0x79, 0x64, 0x62, 0x70, 0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x79,
	0x44, 0x62, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x62,
	0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x6c, 0x6c, 0x6f, 0x79, 0x44, 0x42,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_alloydb_v1beta_data_model_proto_rawDescOnce sync.Once
	file_google_cloud_alloydb_v1beta_data_model_proto_rawDescData = file_google_cloud_alloydb_v1beta_data_model_proto_rawDesc
)

func file_google_cloud_alloydb_v1beta_data_model_proto_rawDescGZIP() []byte {
	file_google_cloud_alloydb_v1beta_data_model_proto_rawDescOnce.Do(func() {
		file_google_cloud_alloydb_v1beta_data_model_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_alloydb_v1beta_data_model_proto_rawDescData)
	})
	return file_google_cloud_alloydb_v1beta_data_model_proto_rawDescData
}

var file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_alloydb_v1beta_data_model_proto_goTypes = []any{
	(*SqlResult)(nil),       // 0: google.cloud.alloydb.v1beta.SqlResult
	(*SqlResultColumn)(nil), // 1: google.cloud.alloydb.v1beta.SqlResultColumn
	(*SqlResultRow)(nil),    // 2: google.cloud.alloydb.v1beta.SqlResultRow
	(*SqlResultValue)(nil),  // 3: google.cloud.alloydb.v1beta.SqlResultValue
}
var file_google_cloud_alloydb_v1beta_data_model_proto_depIdxs = []int32{
	1, // 0: google.cloud.alloydb.v1beta.SqlResult.columns:type_name -> google.cloud.alloydb.v1beta.SqlResultColumn
	2, // 1: google.cloud.alloydb.v1beta.SqlResult.rows:type_name -> google.cloud.alloydb.v1beta.SqlResultRow
	3, // 2: google.cloud.alloydb.v1beta.SqlResultRow.values:type_name -> google.cloud.alloydb.v1beta.SqlResultValue
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_alloydb_v1beta_data_model_proto_init() }
func file_google_cloud_alloydb_v1beta_data_model_proto_init() {
	if File_google_cloud_alloydb_v1beta_data_model_proto != nil {
		return
	}
	file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes[3].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_alloydb_v1beta_data_model_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_alloydb_v1beta_data_model_proto_goTypes,
		DependencyIndexes: file_google_cloud_alloydb_v1beta_data_model_proto_depIdxs,
		MessageInfos:      file_google_cloud_alloydb_v1beta_data_model_proto_msgTypes,
	}.Build()
	File_google_cloud_alloydb_v1beta_data_model_proto = out.File
	file_google_cloud_alloydb_v1beta_data_model_proto_rawDesc = nil
	file_google_cloud_alloydb_v1beta_data_model_proto_goTypes = nil
	file_google_cloud_alloydb_v1beta_data_model_proto_depIdxs = nil
}
