// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/apps/meet/v2beta/service.proto

package meetpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request to create a space.
type CreateSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Space to be created. As of May 2023, the input space can be empty. Later on
	// the input space can be non-empty when space configuration is introduced.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
}

func (x *CreateSpaceRequest) Reset() {
	*x = CreateSpaceRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpaceRequest) ProtoMessage() {}

func (x *CreateSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpaceRequest.ProtoReflect.Descriptor instead.
func (*CreateSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

// Request to get a space.
type GetSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space.
	//
	// Format: `spaces/{space}` or `spaces/{meetingCode}`.
	//
	// `{space}` is the resource identifier for the space. It's a unique,
	// server-generated ID and is case sensitive. For example, `jQCFfuBOdN5z`.
	//
	// `{meetingCode}` is an alias for the space. It's a typeable, unique
	// character string and is non-case sensitive. For example, `abc-mnop-xyz`.
	// The maximum length is 128 characters.
	//
	// A `meetingCode` shouldn't be stored long term as it can become
	// dissociated from a meeting space and can be reused for different meeting
	// spaces in the future. Generally, a `meetingCode` expires 365 days after
	// last use. For more information, see [Learn about meeting codes in Google
	// Meet](https://support.google.com/meet/answer/10710509).
	//
	// For more information, see [How Meet identifies a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#identify-meeting-space).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpaceRequest) Reset() {
	*x = GetSpaceRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpaceRequest) ProtoMessage() {}

func (x *GetSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpaceRequest.ProtoReflect.Descriptor instead.
func (*GetSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update a space.
type UpdateSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Space to be updated.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// Optional. Field mask used to specify the fields to be updated in the space.
	// If update_mask isn't provided(not set, set with empty paths, or only has ""
	// as paths), it defaults to update all fields provided with values in the
	// request.
	// Using "*" as update_mask will update all fields, including deleting fields
	// not set in the request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSpaceRequest) Reset() {
	*x = UpdateSpaceRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpaceRequest) ProtoMessage() {}

func (x *UpdateSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpaceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *UpdateSpaceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to establish a WebRTC connection to the active conference
// of a space.
type ConnectActiveConferenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space.
	// Format: spaces/{spaceId}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. WebRTC SDP (Session Description Protocol) offer from the client.
	//
	// The format is defined by [RFC
	// 8866](https://www.rfc-editor.org/rfc/rfc8866) with mandatory keys defined
	// by [RFC 8829](https://www.rfc-editor.org/rfc/rfc8829). This is the standard
	// SDP format generated by a peer connection's createOffer() and
	// createAnswer() methods.
	Offer string `protobuf:"bytes,2,opt,name=offer,proto3" json:"offer,omitempty"`
}

func (x *ConnectActiveConferenceRequest) Reset() {
	*x = ConnectActiveConferenceRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectActiveConferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectActiveConferenceRequest) ProtoMessage() {}

func (x *ConnectActiveConferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectActiveConferenceRequest.ProtoReflect.Descriptor instead.
func (*ConnectActiveConferenceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{3}
}

func (x *ConnectActiveConferenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectActiveConferenceRequest) GetOffer() string {
	if x != nil {
		return x.Offer
	}
	return ""
}

// Response of ConnectActiveConference method.
//
// A success response does not indicate the meeting is fully joined; further
// communication must occur across WebRTC.
//
// See [Meet Media API
// overview](https://developers.google.com/meet/media-api/guides/overview) for
// more details about this connection.
type ConnectActiveConferenceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// WebRTC SDP answer to the offer.
	Answer string `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// Trace ID for debugging purposes. Please include this value when filing
	// bugs.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
}

func (x *ConnectActiveConferenceResponse) Reset() {
	*x = ConnectActiveConferenceResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectActiveConferenceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectActiveConferenceResponse) ProtoMessage() {}

func (x *ConnectActiveConferenceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectActiveConferenceResponse.ProtoReflect.Descriptor instead.
func (*ConnectActiveConferenceResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{4}
}

func (x *ConnectActiveConferenceResponse) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *ConnectActiveConferenceResponse) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

// Request to end an ongoing conference of a space.
type EndActiveConferenceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space.
	//
	// Format: `spaces/{space}`.
	//
	// `{space}` is the resource identifier for the space. It's a unique,
	// server-generated ID and is case sensitive. For example, `jQCFfuBOdN5z`.
	//
	// For more information, see [How Meet identifies a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#identify-meeting-space).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EndActiveConferenceRequest) Reset() {
	*x = EndActiveConferenceRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EndActiveConferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndActiveConferenceRequest) ProtoMessage() {}

func (x *EndActiveConferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndActiveConferenceRequest.ProtoReflect.Descriptor instead.
func (*EndActiveConferenceRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{5}
}

func (x *EndActiveConferenceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to create a member for a space.
type CreateMemberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: spaces/{space}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The member to be created.
	Member *Member `protobuf:"bytes,2,opt,name=member,proto3" json:"member,omitempty"`
}

func (x *CreateMemberRequest) Reset() {
	*x = CreateMemberRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMemberRequest) ProtoMessage() {}

func (x *CreateMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMemberRequest.ProtoReflect.Descriptor instead.
func (*CreateMemberRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateMemberRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMemberRequest) GetMember() *Member {
	if x != nil {
		return x.Member
	}
	return nil
}

// Request to get a member from a space.
type GetMemberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: “spaces/{space}/members/{member}”
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMemberRequest) Reset() {
	*x = GetMemberRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMemberRequest) ProtoMessage() {}

func (x *GetMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMemberRequest.ProtoReflect.Descriptor instead.
func (*GetMemberRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetMemberRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list all members of a space.
type ListMembersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: spaces/{space}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of members to return. The service might return
	// fewer than this value. If unspecified, at most 25 members are returned. The
	// maximum value is 100; values above 100 are coerced to 100. Maximum might
	// change in the future.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMembersRequest) Reset() {
	*x = ListMembersRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMembersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMembersRequest) ProtoMessage() {}

func (x *ListMembersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMembersRequest.ProtoReflect.Descriptor instead.
func (*ListMembersRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListMembersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMembersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMembersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of list members.
type ListMembersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of members for the current page.
	Members []*Member `protobuf:"bytes,1,rep,name=members,proto3" json:"members,omitempty"`
	// Token to be circulated back for further list call if current list doesn't
	// include all the members. Unset if all members are returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMembersResponse) Reset() {
	*x = ListMembersResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMembersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMembersResponse) ProtoMessage() {}

func (x *ListMembersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMembersResponse.ProtoReflect.Descriptor instead.
func (*ListMembersResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListMembersResponse) GetMembers() []*Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *ListMembersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to delete a member from a space.
type DeleteMemberRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: “spaces/{space}/members/{member}”
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMemberRequest) Reset() {
	*x = DeleteMemberRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMemberRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMemberRequest) ProtoMessage() {}

func (x *DeleteMemberRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMemberRequest.ProtoReflect.Descriptor instead.
func (*DeleteMemberRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteMemberRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to get a conference record.
type GetConferenceRecordRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the conference.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConferenceRecordRequest) Reset() {
	*x = GetConferenceRecordRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetConferenceRecordRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConferenceRecordRequest) ProtoMessage() {}

func (x *GetConferenceRecordRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConferenceRecordRequest.ProtoReflect.Descriptor instead.
func (*GetConferenceRecordRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{11}
}

func (x *GetConferenceRecordRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to fetch list of conference records per user.
type ListConferenceRecordsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Maximum number of conference records to return. The service might
	// return fewer than this value. If unspecified, at most 25 conference records
	// are returned. The maximum value is 100; values above 100 are coerced to
	// 100. Maximum might change in the future.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. User specified filtering condition in [EBNF
	// format](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form).
	// The following are the filterable fields:
	//
	// * `space.meeting_code`
	// * `space.name`
	// * `start_time`
	// * `end_time`
	//
	// For example, consider the following filters:
	//
	// * `space.name = "spaces/NAME"`
	// * `space.meeting_code = "abc-mnop-xyz"`
	// * `start_time>="2024-01-01T00:00:00.000Z" AND
	// start_time<="2024-01-02T00:00:00.000Z"`
	// * `end_time IS NULL`
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListConferenceRecordsRequest) Reset() {
	*x = ListConferenceRecordsRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConferenceRecordsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConferenceRecordsRequest) ProtoMessage() {}

func (x *ListConferenceRecordsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConferenceRecordsRequest.ProtoReflect.Descriptor instead.
func (*ListConferenceRecordsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListConferenceRecordsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConferenceRecordsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConferenceRecordsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response of ListConferenceRecords method.
type ListConferenceRecordsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of conferences in one page.
	ConferenceRecords []*ConferenceRecord `protobuf:"bytes,1,rep,name=conference_records,json=conferenceRecords,proto3" json:"conference_records,omitempty"`
	// Token to be circulated back for further List call if current List does NOT
	// include all the Conferences. Unset if all conferences have been returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConferenceRecordsResponse) Reset() {
	*x = ListConferenceRecordsResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListConferenceRecordsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConferenceRecordsResponse) ProtoMessage() {}

func (x *ListConferenceRecordsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConferenceRecordsResponse.ProtoReflect.Descriptor instead.
func (*ListConferenceRecordsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{13}
}

func (x *ListConferenceRecordsResponse) GetConferenceRecords() []*ConferenceRecord {
	if x != nil {
		return x.ConferenceRecords
	}
	return nil
}

func (x *ListConferenceRecordsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to get a participant.
type GetParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the participant.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetParticipantRequest) Reset() {
	*x = GetParticipantRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetParticipantRequest) ProtoMessage() {}

func (x *GetParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetParticipantRequest.ProtoReflect.Descriptor instead.
func (*GetParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetParticipantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to fetch list of participants per conference.
type ListParticipantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `conferenceRecords/{conference_record}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of participants to return. The service might return fewer
	// than this value.
	// If unspecified, at most 100 participants are returned.
	// The maximum value is 250; values above 250 are coerced to 250.
	// Maximum might change in the future.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. User specified filtering condition in [EBNF
	// format](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form).
	// The following are the filterable fields:
	//
	// * `earliest_start_time`
	// * `latest_end_time`
	//
	// For example, `latest_end_time IS NULL` returns active participants in
	// the conference.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListParticipantsRequest) Reset() {
	*x = ListParticipantsRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListParticipantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsRequest) ProtoMessage() {}

func (x *ListParticipantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsRequest.ProtoReflect.Descriptor instead.
func (*ListParticipantsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListParticipantsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListParticipantsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListParticipantsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListParticipantsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response of ListParticipants method.
type ListParticipantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of participants in one page.
	Participants []*Participant `protobuf:"bytes,1,rep,name=participants,proto3" json:"participants,omitempty"`
	// Token to be circulated back for further List call if current List doesn't
	// include all the participants. Unset if all participants are returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total, exact number of `participants`. By default, this field isn't
	// included in the response. Set the field mask in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters)
	// to receive this field in the response.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListParticipantsResponse) Reset() {
	*x = ListParticipantsResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListParticipantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsResponse) ProtoMessage() {}

func (x *ListParticipantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsResponse.ProtoReflect.Descriptor instead.
func (*ListParticipantsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListParticipantsResponse) GetParticipants() []*Participant {
	if x != nil {
		return x.Participants
	}
	return nil
}

func (x *ListParticipantsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListParticipantsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request to get a participant session.
type GetParticipantSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the participant.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetParticipantSessionRequest) Reset() {
	*x = GetParticipantSessionRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetParticipantSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetParticipantSessionRequest) ProtoMessage() {}

func (x *GetParticipantSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetParticipantSessionRequest.ProtoReflect.Descriptor instead.
func (*GetParticipantSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetParticipantSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to fetch list of participant sessions per conference record, per
// participant.
type ListParticipantSessionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `conferenceRecords/{conference_record}/participants/{participant}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of participant sessions to return. The service
	// might return fewer than this value. If unspecified, at most 100
	// participants are returned. The maximum value is 250; values above 250 are
	// coerced to 250. Maximum might change in the future.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. User specified filtering condition in [EBNF
	// format](https://en.wikipedia.org/wiki/Extended_Backus%E2%80%93Naur_form).
	// The following are the filterable fields:
	//
	// * `start_time`
	// * `end_time`
	//
	// For example, `end_time IS NULL` returns active participant sessions in
	// the conference record.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListParticipantSessionsRequest) Reset() {
	*x = ListParticipantSessionsRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListParticipantSessionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantSessionsRequest) ProtoMessage() {}

func (x *ListParticipantSessionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantSessionsRequest.ProtoReflect.Descriptor instead.
func (*ListParticipantSessionsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListParticipantSessionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListParticipantSessionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListParticipantSessionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListParticipantSessionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response of ListParticipants method.
type ListParticipantSessionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of participants in one page.
	ParticipantSessions []*ParticipantSession `protobuf:"bytes,1,rep,name=participant_sessions,json=participantSessions,proto3" json:"participant_sessions,omitempty"`
	// Token to be circulated back for further List call if current List doesn't
	// include all the participants. Unset if all participants are returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListParticipantSessionsResponse) Reset() {
	*x = ListParticipantSessionsResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListParticipantSessionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantSessionsResponse) ProtoMessage() {}

func (x *ListParticipantSessionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantSessionsResponse.ProtoReflect.Descriptor instead.
func (*ListParticipantSessionsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListParticipantSessionsResponse) GetParticipantSessions() []*ParticipantSession {
	if x != nil {
		return x.ParticipantSessions
	}
	return nil
}

func (x *ListParticipantSessionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetRecording method.
type GetRecordingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the recording.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRecordingRequest) Reset() {
	*x = GetRecordingRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRecordingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRecordingRequest) ProtoMessage() {}

func (x *GetRecordingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRecordingRequest.ProtoReflect.Descriptor instead.
func (*GetRecordingRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{20}
}

func (x *GetRecordingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for ListRecordings method.
type ListRecordingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `conferenceRecords/{conference_record}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of recordings to return. The service might return fewer
	// than this value.
	// If unspecified, at most 10 recordings are returned.
	// The maximum value is 100; values above 100 are coerced to 100.
	// Maximum might change in the future.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListRecordingsRequest) Reset() {
	*x = ListRecordingsRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRecordingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRecordingsRequest) ProtoMessage() {}

func (x *ListRecordingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRecordingsRequest.ProtoReflect.Descriptor instead.
func (*ListRecordingsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{21}
}

func (x *ListRecordingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRecordingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRecordingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListRecordings method.
type ListRecordingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of recordings in one page.
	Recordings []*Recording `protobuf:"bytes,1,rep,name=recordings,proto3" json:"recordings,omitempty"`
	// Token to be circulated back for further List call if current List doesn't
	// include all the recordings. Unset if all recordings are returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRecordingsResponse) Reset() {
	*x = ListRecordingsResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRecordingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRecordingsResponse) ProtoMessage() {}

func (x *ListRecordingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRecordingsResponse.ProtoReflect.Descriptor instead.
func (*ListRecordingsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{22}
}

func (x *ListRecordingsResponse) GetRecordings() []*Recording {
	if x != nil {
		return x.Recordings
	}
	return nil
}

func (x *ListRecordingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for GetTranscript method.
type GetTranscriptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the transcript.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTranscriptRequest) Reset() {
	*x = GetTranscriptRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTranscriptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTranscriptRequest) ProtoMessage() {}

func (x *GetTranscriptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTranscriptRequest.ProtoReflect.Descriptor instead.
func (*GetTranscriptRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{23}
}

func (x *GetTranscriptRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for ListTranscripts method.
type ListTranscriptsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `conferenceRecords/{conference_record}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of transcripts to return. The service might return fewer
	// than this value.
	// If unspecified, at most 10 transcripts are returned.
	// The maximum value is 100; values above 100 are coerced to 100.
	// Maximum might change in the future.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTranscriptsRequest) Reset() {
	*x = ListTranscriptsRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTranscriptsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTranscriptsRequest) ProtoMessage() {}

func (x *ListTranscriptsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTranscriptsRequest.ProtoReflect.Descriptor instead.
func (*ListTranscriptsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{24}
}

func (x *ListTranscriptsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTranscriptsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTranscriptsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListTranscripts method.
type ListTranscriptsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of transcripts in one page.
	Transcripts []*Transcript `protobuf:"bytes,1,rep,name=transcripts,proto3" json:"transcripts,omitempty"`
	// Token to be circulated back for further List call if current List doesn't
	// include all the transcripts. Unset if all transcripts are returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTranscriptsResponse) Reset() {
	*x = ListTranscriptsResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTranscriptsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTranscriptsResponse) ProtoMessage() {}

func (x *ListTranscriptsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTranscriptsResponse.ProtoReflect.Descriptor instead.
func (*ListTranscriptsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{25}
}

func (x *ListTranscriptsResponse) GetTranscripts() []*Transcript {
	if x != nil {
		return x.Transcripts
	}
	return nil
}

func (x *ListTranscriptsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for GetTranscriptEntry method.
type GetTranscriptEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the `TranscriptEntry`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTranscriptEntryRequest) Reset() {
	*x = GetTranscriptEntryRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTranscriptEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTranscriptEntryRequest) ProtoMessage() {}

func (x *GetTranscriptEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTranscriptEntryRequest.ProtoReflect.Descriptor instead.
func (*GetTranscriptEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{26}
}

func (x *GetTranscriptEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for ListTranscriptEntries method.
type ListTranscriptEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format:
	// `conferenceRecords/{conference_record}/transcripts/{transcript}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of entries to return. The service might return fewer than
	// this value.
	// If unspecified, at most 10 entries are returned.
	// The maximum value is 100; values above 100 are coerced to 100.
	// Maximum might change in the future.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token returned from previous List Call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTranscriptEntriesRequest) Reset() {
	*x = ListTranscriptEntriesRequest{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTranscriptEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTranscriptEntriesRequest) ProtoMessage() {}

func (x *ListTranscriptEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTranscriptEntriesRequest.ProtoReflect.Descriptor instead.
func (*ListTranscriptEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListTranscriptEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTranscriptEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTranscriptEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListTranscriptEntries method.
type ListTranscriptEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TranscriptEntries in one page.
	TranscriptEntries []*TranscriptEntry `protobuf:"bytes,1,rep,name=transcript_entries,json=transcriptEntries,proto3" json:"transcript_entries,omitempty"`
	// Token to be circulated back for further List call if current List doesn't
	// include all the transcript entries. Unset if all entries are returned.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTranscriptEntriesResponse) Reset() {
	*x = ListTranscriptEntriesResponse{}
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTranscriptEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTranscriptEntriesResponse) ProtoMessage() {}

func (x *ListTranscriptEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_meet_v2beta_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTranscriptEntriesResponse.ProtoReflect.Descriptor instead.
func (*ListTranscriptEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_meet_v2beta_service_proto_rawDescGZIP(), []int{28}
}

func (x *ListTranscriptEntriesResponse) GetTranscriptEntries() []*TranscriptEntry {
	if x != nil {
		return x.TranscriptEntries
	}
	return nil
}

func (x *ListTranscriptEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_apps_meet_v2beta_service_proto protoreflect.FileDescriptor

var file_google_apps_meet_v2beta_service_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x6d, 0x65,
	0x65, 0x74, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73,
	0x2f, 0x6d, 0x65, 0x65, 0x74, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4a, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x34, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x48, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a,
	0x19, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x91, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x72, 0x0a, 0x1e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x22, 0x54, 0x0a, 0x1f, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0x53,
	0x0a, 0x1a, 0x45, 0x6e, 0x64, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1b, 0x0a, 0x19, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x8f, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1c, 0x12, 0x1a, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x4a, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a,
	0x1a, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c,
	0x12, 0x1a, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x78, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x39, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4d, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1c, 0x0a, 0x1a, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x5e, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x81, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa1, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x12, 0x63, 0x6f, 0x6e,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x52, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x54, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6d, 0x65, 0x65, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xb3, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xab, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x62, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6d, 0x65, 0x65,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x1e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa9, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x14, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x50, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x92, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x84, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x72,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x52, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5c, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6d, 0x65, 0x65, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23,
	0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa0, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x95, 0x0e, 0x0a, 0x0d, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x81, 0x01, 0x0a,
	0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x22, 0x25, 0xda, 0x41, 0x05, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x3a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x22, 0x0e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x12, 0x7c, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x22, 0x26, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x19, 0x12, 0x17, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c,
	0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65,
	0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x22, 0x40, 0xda, 0x41, 0x11,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x3a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x32, 0x1d,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf, 0x01,
	0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x3a, 0x01, 0x2a, 0x22, 0x2f,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0xa1, 0x01, 0x0a, 0x13, 0x45, 0x6e, 0x64, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x45, 0x6e, 0x64, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x65, 0x6e, 0x64, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0xa0, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x22, 0x41, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x3a, 0x06, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x22, 0x21, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x89, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12,
	0x21, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x9c, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x12, 0x86, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x95, 0x03, 0xca, 0x41, 0x13,
	0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xfb, 0x02, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61,
	0x2e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e,
	0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6d, 0x65, 0x65, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x32, 0xf3, 0x12, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xa8, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0x31, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9, 0x01, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x12, 0xa8, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22,
	0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f,
	0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xbb, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f,
	0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12,
	0xd3, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d,
	0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x56, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa0,
	0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x12, 0x2f, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xb3, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xa4, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x3f, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65,
	0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x49, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x63, 0x6f, 0x6e, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd3, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x63, 0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0x87,
	0x01, 0xca, 0x41, 0x13, 0x6d, 0x65, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x6e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e,
	0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0xb5, 0x01, 0x0a, 0x1b, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x6d, 0x65, 0x65,
	0x74, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x70,
	0x70, 0x73, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x6d, 0x65, 0x65, 0x74, 0x70, 0x62, 0x3b, 0x6d, 0x65, 0x65, 0x74, 0x70, 0x62, 0xaa,
	0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x4d, 0x65,
	0x65, 0x74, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x4d, 0x65, 0x65, 0x74, 0x5c, 0x56, 0x32, 0x62,
	0x65, 0x74, 0x61, 0xea, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70,
	0x70, 0x73, 0x3a, 0x3a, 0x4d, 0x65, 0x65, 0x74, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_meet_v2beta_service_proto_rawDescOnce sync.Once
	file_google_apps_meet_v2beta_service_proto_rawDescData = file_google_apps_meet_v2beta_service_proto_rawDesc
)

func file_google_apps_meet_v2beta_service_proto_rawDescGZIP() []byte {
	file_google_apps_meet_v2beta_service_proto_rawDescOnce.Do(func() {
		file_google_apps_meet_v2beta_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_meet_v2beta_service_proto_rawDescData)
	})
	return file_google_apps_meet_v2beta_service_proto_rawDescData
}

var file_google_apps_meet_v2beta_service_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_google_apps_meet_v2beta_service_proto_goTypes = []any{
	(*CreateSpaceRequest)(nil),              // 0: google.apps.meet.v2beta.CreateSpaceRequest
	(*GetSpaceRequest)(nil),                 // 1: google.apps.meet.v2beta.GetSpaceRequest
	(*UpdateSpaceRequest)(nil),              // 2: google.apps.meet.v2beta.UpdateSpaceRequest
	(*ConnectActiveConferenceRequest)(nil),  // 3: google.apps.meet.v2beta.ConnectActiveConferenceRequest
	(*ConnectActiveConferenceResponse)(nil), // 4: google.apps.meet.v2beta.ConnectActiveConferenceResponse
	(*EndActiveConferenceRequest)(nil),      // 5: google.apps.meet.v2beta.EndActiveConferenceRequest
	(*CreateMemberRequest)(nil),             // 6: google.apps.meet.v2beta.CreateMemberRequest
	(*GetMemberRequest)(nil),                // 7: google.apps.meet.v2beta.GetMemberRequest
	(*ListMembersRequest)(nil),              // 8: google.apps.meet.v2beta.ListMembersRequest
	(*ListMembersResponse)(nil),             // 9: google.apps.meet.v2beta.ListMembersResponse
	(*DeleteMemberRequest)(nil),             // 10: google.apps.meet.v2beta.DeleteMemberRequest
	(*GetConferenceRecordRequest)(nil),      // 11: google.apps.meet.v2beta.GetConferenceRecordRequest
	(*ListConferenceRecordsRequest)(nil),    // 12: google.apps.meet.v2beta.ListConferenceRecordsRequest
	(*ListConferenceRecordsResponse)(nil),   // 13: google.apps.meet.v2beta.ListConferenceRecordsResponse
	(*GetParticipantRequest)(nil),           // 14: google.apps.meet.v2beta.GetParticipantRequest
	(*ListParticipantsRequest)(nil),         // 15: google.apps.meet.v2beta.ListParticipantsRequest
	(*ListParticipantsResponse)(nil),        // 16: google.apps.meet.v2beta.ListParticipantsResponse
	(*GetParticipantSessionRequest)(nil),    // 17: google.apps.meet.v2beta.GetParticipantSessionRequest
	(*ListParticipantSessionsRequest)(nil),  // 18: google.apps.meet.v2beta.ListParticipantSessionsRequest
	(*ListParticipantSessionsResponse)(nil), // 19: google.apps.meet.v2beta.ListParticipantSessionsResponse
	(*GetRecordingRequest)(nil),             // 20: google.apps.meet.v2beta.GetRecordingRequest
	(*ListRecordingsRequest)(nil),           // 21: google.apps.meet.v2beta.ListRecordingsRequest
	(*ListRecordingsResponse)(nil),          // 22: google.apps.meet.v2beta.ListRecordingsResponse
	(*GetTranscriptRequest)(nil),            // 23: google.apps.meet.v2beta.GetTranscriptRequest
	(*ListTranscriptsRequest)(nil),          // 24: google.apps.meet.v2beta.ListTranscriptsRequest
	(*ListTranscriptsResponse)(nil),         // 25: google.apps.meet.v2beta.ListTranscriptsResponse
	(*GetTranscriptEntryRequest)(nil),       // 26: google.apps.meet.v2beta.GetTranscriptEntryRequest
	(*ListTranscriptEntriesRequest)(nil),    // 27: google.apps.meet.v2beta.ListTranscriptEntriesRequest
	(*ListTranscriptEntriesResponse)(nil),   // 28: google.apps.meet.v2beta.ListTranscriptEntriesResponse
	(*Space)(nil),                           // 29: google.apps.meet.v2beta.Space
	(*fieldmaskpb.FieldMask)(nil),           // 30: google.protobuf.FieldMask
	(*Member)(nil),                          // 31: google.apps.meet.v2beta.Member
	(*ConferenceRecord)(nil),                // 32: google.apps.meet.v2beta.ConferenceRecord
	(*Participant)(nil),                     // 33: google.apps.meet.v2beta.Participant
	(*ParticipantSession)(nil),              // 34: google.apps.meet.v2beta.ParticipantSession
	(*Recording)(nil),                       // 35: google.apps.meet.v2beta.Recording
	(*Transcript)(nil),                      // 36: google.apps.meet.v2beta.Transcript
	(*TranscriptEntry)(nil),                 // 37: google.apps.meet.v2beta.TranscriptEntry
	(*emptypb.Empty)(nil),                   // 38: google.protobuf.Empty
}
var file_google_apps_meet_v2beta_service_proto_depIdxs = []int32{
	29, // 0: google.apps.meet.v2beta.CreateSpaceRequest.space:type_name -> google.apps.meet.v2beta.Space
	29, // 1: google.apps.meet.v2beta.UpdateSpaceRequest.space:type_name -> google.apps.meet.v2beta.Space
	30, // 2: google.apps.meet.v2beta.UpdateSpaceRequest.update_mask:type_name -> google.protobuf.FieldMask
	31, // 3: google.apps.meet.v2beta.CreateMemberRequest.member:type_name -> google.apps.meet.v2beta.Member
	31, // 4: google.apps.meet.v2beta.ListMembersResponse.members:type_name -> google.apps.meet.v2beta.Member
	32, // 5: google.apps.meet.v2beta.ListConferenceRecordsResponse.conference_records:type_name -> google.apps.meet.v2beta.ConferenceRecord
	33, // 6: google.apps.meet.v2beta.ListParticipantsResponse.participants:type_name -> google.apps.meet.v2beta.Participant
	34, // 7: google.apps.meet.v2beta.ListParticipantSessionsResponse.participant_sessions:type_name -> google.apps.meet.v2beta.ParticipantSession
	35, // 8: google.apps.meet.v2beta.ListRecordingsResponse.recordings:type_name -> google.apps.meet.v2beta.Recording
	36, // 9: google.apps.meet.v2beta.ListTranscriptsResponse.transcripts:type_name -> google.apps.meet.v2beta.Transcript
	37, // 10: google.apps.meet.v2beta.ListTranscriptEntriesResponse.transcript_entries:type_name -> google.apps.meet.v2beta.TranscriptEntry
	0,  // 11: google.apps.meet.v2beta.SpacesService.CreateSpace:input_type -> google.apps.meet.v2beta.CreateSpaceRequest
	1,  // 12: google.apps.meet.v2beta.SpacesService.GetSpace:input_type -> google.apps.meet.v2beta.GetSpaceRequest
	2,  // 13: google.apps.meet.v2beta.SpacesService.UpdateSpace:input_type -> google.apps.meet.v2beta.UpdateSpaceRequest
	3,  // 14: google.apps.meet.v2beta.SpacesService.ConnectActiveConference:input_type -> google.apps.meet.v2beta.ConnectActiveConferenceRequest
	5,  // 15: google.apps.meet.v2beta.SpacesService.EndActiveConference:input_type -> google.apps.meet.v2beta.EndActiveConferenceRequest
	6,  // 16: google.apps.meet.v2beta.SpacesService.CreateMember:input_type -> google.apps.meet.v2beta.CreateMemberRequest
	7,  // 17: google.apps.meet.v2beta.SpacesService.GetMember:input_type -> google.apps.meet.v2beta.GetMemberRequest
	8,  // 18: google.apps.meet.v2beta.SpacesService.ListMembers:input_type -> google.apps.meet.v2beta.ListMembersRequest
	10, // 19: google.apps.meet.v2beta.SpacesService.DeleteMember:input_type -> google.apps.meet.v2beta.DeleteMemberRequest
	11, // 20: google.apps.meet.v2beta.ConferenceRecordsService.GetConferenceRecord:input_type -> google.apps.meet.v2beta.GetConferenceRecordRequest
	12, // 21: google.apps.meet.v2beta.ConferenceRecordsService.ListConferenceRecords:input_type -> google.apps.meet.v2beta.ListConferenceRecordsRequest
	14, // 22: google.apps.meet.v2beta.ConferenceRecordsService.GetParticipant:input_type -> google.apps.meet.v2beta.GetParticipantRequest
	15, // 23: google.apps.meet.v2beta.ConferenceRecordsService.ListParticipants:input_type -> google.apps.meet.v2beta.ListParticipantsRequest
	17, // 24: google.apps.meet.v2beta.ConferenceRecordsService.GetParticipantSession:input_type -> google.apps.meet.v2beta.GetParticipantSessionRequest
	18, // 25: google.apps.meet.v2beta.ConferenceRecordsService.ListParticipantSessions:input_type -> google.apps.meet.v2beta.ListParticipantSessionsRequest
	20, // 26: google.apps.meet.v2beta.ConferenceRecordsService.GetRecording:input_type -> google.apps.meet.v2beta.GetRecordingRequest
	21, // 27: google.apps.meet.v2beta.ConferenceRecordsService.ListRecordings:input_type -> google.apps.meet.v2beta.ListRecordingsRequest
	23, // 28: google.apps.meet.v2beta.ConferenceRecordsService.GetTranscript:input_type -> google.apps.meet.v2beta.GetTranscriptRequest
	24, // 29: google.apps.meet.v2beta.ConferenceRecordsService.ListTranscripts:input_type -> google.apps.meet.v2beta.ListTranscriptsRequest
	26, // 30: google.apps.meet.v2beta.ConferenceRecordsService.GetTranscriptEntry:input_type -> google.apps.meet.v2beta.GetTranscriptEntryRequest
	27, // 31: google.apps.meet.v2beta.ConferenceRecordsService.ListTranscriptEntries:input_type -> google.apps.meet.v2beta.ListTranscriptEntriesRequest
	29, // 32: google.apps.meet.v2beta.SpacesService.CreateSpace:output_type -> google.apps.meet.v2beta.Space
	29, // 33: google.apps.meet.v2beta.SpacesService.GetSpace:output_type -> google.apps.meet.v2beta.Space
	29, // 34: google.apps.meet.v2beta.SpacesService.UpdateSpace:output_type -> google.apps.meet.v2beta.Space
	4,  // 35: google.apps.meet.v2beta.SpacesService.ConnectActiveConference:output_type -> google.apps.meet.v2beta.ConnectActiveConferenceResponse
	38, // 36: google.apps.meet.v2beta.SpacesService.EndActiveConference:output_type -> google.protobuf.Empty
	31, // 37: google.apps.meet.v2beta.SpacesService.CreateMember:output_type -> google.apps.meet.v2beta.Member
	31, // 38: google.apps.meet.v2beta.SpacesService.GetMember:output_type -> google.apps.meet.v2beta.Member
	9,  // 39: google.apps.meet.v2beta.SpacesService.ListMembers:output_type -> google.apps.meet.v2beta.ListMembersResponse
	38, // 40: google.apps.meet.v2beta.SpacesService.DeleteMember:output_type -> google.protobuf.Empty
	32, // 41: google.apps.meet.v2beta.ConferenceRecordsService.GetConferenceRecord:output_type -> google.apps.meet.v2beta.ConferenceRecord
	13, // 42: google.apps.meet.v2beta.ConferenceRecordsService.ListConferenceRecords:output_type -> google.apps.meet.v2beta.ListConferenceRecordsResponse
	33, // 43: google.apps.meet.v2beta.ConferenceRecordsService.GetParticipant:output_type -> google.apps.meet.v2beta.Participant
	16, // 44: google.apps.meet.v2beta.ConferenceRecordsService.ListParticipants:output_type -> google.apps.meet.v2beta.ListParticipantsResponse
	34, // 45: google.apps.meet.v2beta.ConferenceRecordsService.GetParticipantSession:output_type -> google.apps.meet.v2beta.ParticipantSession
	19, // 46: google.apps.meet.v2beta.ConferenceRecordsService.ListParticipantSessions:output_type -> google.apps.meet.v2beta.ListParticipantSessionsResponse
	35, // 47: google.apps.meet.v2beta.ConferenceRecordsService.GetRecording:output_type -> google.apps.meet.v2beta.Recording
	22, // 48: google.apps.meet.v2beta.ConferenceRecordsService.ListRecordings:output_type -> google.apps.meet.v2beta.ListRecordingsResponse
	36, // 49: google.apps.meet.v2beta.ConferenceRecordsService.GetTranscript:output_type -> google.apps.meet.v2beta.Transcript
	25, // 50: google.apps.meet.v2beta.ConferenceRecordsService.ListTranscripts:output_type -> google.apps.meet.v2beta.ListTranscriptsResponse
	37, // 51: google.apps.meet.v2beta.ConferenceRecordsService.GetTranscriptEntry:output_type -> google.apps.meet.v2beta.TranscriptEntry
	28, // 52: google.apps.meet.v2beta.ConferenceRecordsService.ListTranscriptEntries:output_type -> google.apps.meet.v2beta.ListTranscriptEntriesResponse
	32, // [32:53] is the sub-list for method output_type
	11, // [11:32] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_apps_meet_v2beta_service_proto_init() }
func file_google_apps_meet_v2beta_service_proto_init() {
	if File_google_apps_meet_v2beta_service_proto != nil {
		return
	}
	file_google_apps_meet_v2beta_resource_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_meet_v2beta_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_apps_meet_v2beta_service_proto_goTypes,
		DependencyIndexes: file_google_apps_meet_v2beta_service_proto_depIdxs,
		MessageInfos:      file_google_apps_meet_v2beta_service_proto_msgTypes,
	}.Build()
	File_google_apps_meet_v2beta_service_proto = out.File
	file_google_apps_meet_v2beta_service_proto_rawDesc = nil
	file_google_apps_meet_v2beta_service_proto_goTypes = nil
	file_google_apps_meet_v2beta_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SpacesServiceClient is the client API for SpacesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpacesServiceClient interface {
	// Creates a space.
	CreateSpace(ctx context.Context, in *CreateSpaceRequest, opts ...grpc.CallOption) (*Space, error)
	// Gets details about a meeting space.
	//
	// For an example, see [Get a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#get-meeting-space).
	GetSpace(ctx context.Context, in *GetSpaceRequest, opts ...grpc.CallOption) (*Space, error)
	// Updates details about a meeting space.
	//
	// For an example, see [Update a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#update-meeting-space).
	UpdateSpace(ctx context.Context, in *UpdateSpaceRequest, opts ...grpc.CallOption) (*Space, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Broker a WebRTC connection to the active conference of a space.
	//
	// On success, clients must use the resulting SDP (Session Description
	// Protocol) answer to establish a WebRTC connection. Once connected,
	// additional functionality is available across WebRTC data channels.
	//
	// See [Meet Media API
	// overview](https://developers.google.com/meet/media-api/guides/overview) for
	// more details about this connection.
	ConnectActiveConference(ctx context.Context, in *ConnectActiveConferenceRequest, opts ...grpc.CallOption) (*ConnectActiveConferenceResponse, error)
	// Ends an active conference (if there's one).
	//
	// For an example, see [End active
	// conference](https://developers.google.com/meet/api/guides/meeting-spaces#end-active-conference).
	EndActiveConference(ctx context.Context, in *EndActiveConferenceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Create a member.
	//
	// This API supports the `fields` parameter in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters).
	// When the `fields` parameter is omitted, this API response will default to
	// "name,email,role,user".
	CreateMember(ctx context.Context, in *CreateMemberRequest, opts ...grpc.CallOption) (*Member, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Get a member.
	//
	// This API supports the `fields` parameter in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters).
	// When the `fields` parameter is omitted, this API response will default to
	// "name,email,role,user".
	GetMember(ctx context.Context, in *GetMemberRequest, opts ...grpc.CallOption) (*Member, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// List members.
	//
	// This API supports the `fields` parameter in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters).
	// When the `fields` parameter is omitted this API response will default to
	// "name,email,role,user".
	ListMembers(ctx context.Context, in *ListMembersRequest, opts ...grpc.CallOption) (*ListMembersResponse, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Delete the member who was previously assigned roles in the space.
	DeleteMember(ctx context.Context, in *DeleteMemberRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type spacesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSpacesServiceClient(cc grpc.ClientConnInterface) SpacesServiceClient {
	return &spacesServiceClient{cc}
}

func (c *spacesServiceClient) CreateSpace(ctx context.Context, in *CreateSpaceRequest, opts ...grpc.CallOption) (*Space, error) {
	out := new(Space)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/CreateSpace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) GetSpace(ctx context.Context, in *GetSpaceRequest, opts ...grpc.CallOption) (*Space, error) {
	out := new(Space)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/GetSpace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) UpdateSpace(ctx context.Context, in *UpdateSpaceRequest, opts ...grpc.CallOption) (*Space, error) {
	out := new(Space)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/UpdateSpace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) ConnectActiveConference(ctx context.Context, in *ConnectActiveConferenceRequest, opts ...grpc.CallOption) (*ConnectActiveConferenceResponse, error) {
	out := new(ConnectActiveConferenceResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/ConnectActiveConference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) EndActiveConference(ctx context.Context, in *EndActiveConferenceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/EndActiveConference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) CreateMember(ctx context.Context, in *CreateMemberRequest, opts ...grpc.CallOption) (*Member, error) {
	out := new(Member)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/CreateMember", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) GetMember(ctx context.Context, in *GetMemberRequest, opts ...grpc.CallOption) (*Member, error) {
	out := new(Member)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/GetMember", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) ListMembers(ctx context.Context, in *ListMembersRequest, opts ...grpc.CallOption) (*ListMembersResponse, error) {
	out := new(ListMembersResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/ListMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *spacesServiceClient) DeleteMember(ctx context.Context, in *DeleteMemberRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.SpacesService/DeleteMember", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpacesServiceServer is the server API for SpacesService service.
type SpacesServiceServer interface {
	// Creates a space.
	CreateSpace(context.Context, *CreateSpaceRequest) (*Space, error)
	// Gets details about a meeting space.
	//
	// For an example, see [Get a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#get-meeting-space).
	GetSpace(context.Context, *GetSpaceRequest) (*Space, error)
	// Updates details about a meeting space.
	//
	// For an example, see [Update a meeting
	// space](https://developers.google.com/meet/api/guides/meeting-spaces#update-meeting-space).
	UpdateSpace(context.Context, *UpdateSpaceRequest) (*Space, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Broker a WebRTC connection to the active conference of a space.
	//
	// On success, clients must use the resulting SDP (Session Description
	// Protocol) answer to establish a WebRTC connection. Once connected,
	// additional functionality is available across WebRTC data channels.
	//
	// See [Meet Media API
	// overview](https://developers.google.com/meet/media-api/guides/overview) for
	// more details about this connection.
	ConnectActiveConference(context.Context, *ConnectActiveConferenceRequest) (*ConnectActiveConferenceResponse, error)
	// Ends an active conference (if there's one).
	//
	// For an example, see [End active
	// conference](https://developers.google.com/meet/api/guides/meeting-spaces#end-active-conference).
	EndActiveConference(context.Context, *EndActiveConferenceRequest) (*emptypb.Empty, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Create a member.
	//
	// This API supports the `fields` parameter in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters).
	// When the `fields` parameter is omitted, this API response will default to
	// "name,email,role,user".
	CreateMember(context.Context, *CreateMemberRequest) (*Member, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Get a member.
	//
	// This API supports the `fields` parameter in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters).
	// When the `fields` parameter is omitted, this API response will default to
	// "name,email,role,user".
	GetMember(context.Context, *GetMemberRequest) (*Member, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// List members.
	//
	// This API supports the `fields` parameter in
	// [SystemParameterContext](https://cloud.google.com/apis/docs/system-parameters).
	// When the `fields` parameter is omitted this API response will default to
	// "name,email,role,user".
	ListMembers(context.Context, *ListMembersRequest) (*ListMembersResponse, error)
	// [Developer Preview](https://developers.google.com/workspace/preview):
	// Delete the member who was previously assigned roles in the space.
	DeleteMember(context.Context, *DeleteMemberRequest) (*emptypb.Empty, error)
}

// UnimplementedSpacesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSpacesServiceServer struct {
}

func (*UnimplementedSpacesServiceServer) CreateSpace(context.Context, *CreateSpaceRequest) (*Space, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpace not implemented")
}
func (*UnimplementedSpacesServiceServer) GetSpace(context.Context, *GetSpaceRequest) (*Space, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpace not implemented")
}
func (*UnimplementedSpacesServiceServer) UpdateSpace(context.Context, *UpdateSpaceRequest) (*Space, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpace not implemented")
}
func (*UnimplementedSpacesServiceServer) ConnectActiveConference(context.Context, *ConnectActiveConferenceRequest) (*ConnectActiveConferenceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConnectActiveConference not implemented")
}
func (*UnimplementedSpacesServiceServer) EndActiveConference(context.Context, *EndActiveConferenceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EndActiveConference not implemented")
}
func (*UnimplementedSpacesServiceServer) CreateMember(context.Context, *CreateMemberRequest) (*Member, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMember not implemented")
}
func (*UnimplementedSpacesServiceServer) GetMember(context.Context, *GetMemberRequest) (*Member, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMember not implemented")
}
func (*UnimplementedSpacesServiceServer) ListMembers(context.Context, *ListMembersRequest) (*ListMembersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMembers not implemented")
}
func (*UnimplementedSpacesServiceServer) DeleteMember(context.Context, *DeleteMemberRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMember not implemented")
}

func RegisterSpacesServiceServer(s *grpc.Server, srv SpacesServiceServer) {
	s.RegisterService(&_SpacesService_serviceDesc, srv)
}

func _SpacesService_CreateSpace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).CreateSpace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/CreateSpace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).CreateSpace(ctx, req.(*CreateSpaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_GetSpace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).GetSpace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/GetSpace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).GetSpace(ctx, req.(*GetSpaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_UpdateSpace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).UpdateSpace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/UpdateSpace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).UpdateSpace(ctx, req.(*UpdateSpaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_ConnectActiveConference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConnectActiveConferenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).ConnectActiveConference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/ConnectActiveConference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).ConnectActiveConference(ctx, req.(*ConnectActiveConferenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_EndActiveConference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndActiveConferenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).EndActiveConference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/EndActiveConference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).EndActiveConference(ctx, req.(*EndActiveConferenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_CreateMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMemberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).CreateMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/CreateMember",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).CreateMember(ctx, req.(*CreateMemberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_GetMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMemberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).GetMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/GetMember",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).GetMember(ctx, req.(*GetMemberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_ListMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).ListMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/ListMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).ListMembers(ctx, req.(*ListMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SpacesService_DeleteMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMemberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpacesServiceServer).DeleteMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.SpacesService/DeleteMember",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpacesServiceServer).DeleteMember(ctx, req.(*DeleteMemberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SpacesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.apps.meet.v2beta.SpacesService",
	HandlerType: (*SpacesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSpace",
			Handler:    _SpacesService_CreateSpace_Handler,
		},
		{
			MethodName: "GetSpace",
			Handler:    _SpacesService_GetSpace_Handler,
		},
		{
			MethodName: "UpdateSpace",
			Handler:    _SpacesService_UpdateSpace_Handler,
		},
		{
			MethodName: "ConnectActiveConference",
			Handler:    _SpacesService_ConnectActiveConference_Handler,
		},
		{
			MethodName: "EndActiveConference",
			Handler:    _SpacesService_EndActiveConference_Handler,
		},
		{
			MethodName: "CreateMember",
			Handler:    _SpacesService_CreateMember_Handler,
		},
		{
			MethodName: "GetMember",
			Handler:    _SpacesService_GetMember_Handler,
		},
		{
			MethodName: "ListMembers",
			Handler:    _SpacesService_ListMembers_Handler,
		},
		{
			MethodName: "DeleteMember",
			Handler:    _SpacesService_DeleteMember_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/apps/meet/v2beta/service.proto",
}

// ConferenceRecordsServiceClient is the client API for ConferenceRecordsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConferenceRecordsServiceClient interface {
	// Gets a conference record by conference ID.
	GetConferenceRecord(ctx context.Context, in *GetConferenceRecordRequest, opts ...grpc.CallOption) (*ConferenceRecord, error)
	// Lists the conference records. By default, ordered by start time and in
	// descending order.
	ListConferenceRecords(ctx context.Context, in *ListConferenceRecordsRequest, opts ...grpc.CallOption) (*ListConferenceRecordsResponse, error)
	// Gets a participant by participant ID.
	GetParticipant(ctx context.Context, in *GetParticipantRequest, opts ...grpc.CallOption) (*Participant, error)
	// Lists the participants in a conference record. By default, ordered by join
	// time and in descending order. This API supports `fields` as standard
	// parameters like every other API. However, when the `fields` request
	// parameter is omitted, this API defaults to `'participants/*,
	// next_page_token'`.
	ListParticipants(ctx context.Context, in *ListParticipantsRequest, opts ...grpc.CallOption) (*ListParticipantsResponse, error)
	// Gets a participant session by participant session ID.
	GetParticipantSession(ctx context.Context, in *GetParticipantSessionRequest, opts ...grpc.CallOption) (*ParticipantSession, error)
	// Lists the participant sessions of a participant in a conference record. By
	// default, ordered by join time and in descending order. This API supports
	// `fields` as standard parameters like every other API. However, when the
	// `fields` request parameter is omitted this API defaults to
	// `'participantsessions/*, next_page_token'`.
	ListParticipantSessions(ctx context.Context, in *ListParticipantSessionsRequest, opts ...grpc.CallOption) (*ListParticipantSessionsResponse, error)
	// Gets a recording by recording ID.
	GetRecording(ctx context.Context, in *GetRecordingRequest, opts ...grpc.CallOption) (*Recording, error)
	// Lists the recording resources from the conference record. By default,
	// ordered by start time and in ascending order.
	ListRecordings(ctx context.Context, in *ListRecordingsRequest, opts ...grpc.CallOption) (*ListRecordingsResponse, error)
	// Gets a transcript by transcript ID.
	GetTranscript(ctx context.Context, in *GetTranscriptRequest, opts ...grpc.CallOption) (*Transcript, error)
	// Lists the set of transcripts from the conference record. By default,
	// ordered by start time and in ascending order.
	ListTranscripts(ctx context.Context, in *ListTranscriptsRequest, opts ...grpc.CallOption) (*ListTranscriptsResponse, error)
	// Gets a `TranscriptEntry` resource by entry ID.
	//
	// Note: The transcript entries returned by the Google Meet API might not
	// match the transcription found in the Google Docs transcript file. This can
	// occur when the Google Docs transcript file is modified after generation.
	GetTranscriptEntry(ctx context.Context, in *GetTranscriptEntryRequest, opts ...grpc.CallOption) (*TranscriptEntry, error)
	// Lists the structured transcript entries per transcript. By default, ordered
	// by start time and in ascending order.
	//
	// Note: The transcript entries returned by the Google Meet API might not
	// match the transcription found in the Google Docs transcript file. This can
	// occur when the Google Docs transcript file is modified after generation.
	ListTranscriptEntries(ctx context.Context, in *ListTranscriptEntriesRequest, opts ...grpc.CallOption) (*ListTranscriptEntriesResponse, error)
}

type conferenceRecordsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConferenceRecordsServiceClient(cc grpc.ClientConnInterface) ConferenceRecordsServiceClient {
	return &conferenceRecordsServiceClient{cc}
}

func (c *conferenceRecordsServiceClient) GetConferenceRecord(ctx context.Context, in *GetConferenceRecordRequest, opts ...grpc.CallOption) (*ConferenceRecord, error) {
	out := new(ConferenceRecord)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/GetConferenceRecord", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) ListConferenceRecords(ctx context.Context, in *ListConferenceRecordsRequest, opts ...grpc.CallOption) (*ListConferenceRecordsResponse, error) {
	out := new(ListConferenceRecordsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/ListConferenceRecords", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) GetParticipant(ctx context.Context, in *GetParticipantRequest, opts ...grpc.CallOption) (*Participant, error) {
	out := new(Participant)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/GetParticipant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) ListParticipants(ctx context.Context, in *ListParticipantsRequest, opts ...grpc.CallOption) (*ListParticipantsResponse, error) {
	out := new(ListParticipantsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/ListParticipants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) GetParticipantSession(ctx context.Context, in *GetParticipantSessionRequest, opts ...grpc.CallOption) (*ParticipantSession, error) {
	out := new(ParticipantSession)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/GetParticipantSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) ListParticipantSessions(ctx context.Context, in *ListParticipantSessionsRequest, opts ...grpc.CallOption) (*ListParticipantSessionsResponse, error) {
	out := new(ListParticipantSessionsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/ListParticipantSessions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) GetRecording(ctx context.Context, in *GetRecordingRequest, opts ...grpc.CallOption) (*Recording, error) {
	out := new(Recording)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/GetRecording", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) ListRecordings(ctx context.Context, in *ListRecordingsRequest, opts ...grpc.CallOption) (*ListRecordingsResponse, error) {
	out := new(ListRecordingsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/ListRecordings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) GetTranscript(ctx context.Context, in *GetTranscriptRequest, opts ...grpc.CallOption) (*Transcript, error) {
	out := new(Transcript)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/GetTranscript", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) ListTranscripts(ctx context.Context, in *ListTranscriptsRequest, opts ...grpc.CallOption) (*ListTranscriptsResponse, error) {
	out := new(ListTranscriptsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/ListTranscripts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) GetTranscriptEntry(ctx context.Context, in *GetTranscriptEntryRequest, opts ...grpc.CallOption) (*TranscriptEntry, error) {
	out := new(TranscriptEntry)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/GetTranscriptEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conferenceRecordsServiceClient) ListTranscriptEntries(ctx context.Context, in *ListTranscriptEntriesRequest, opts ...grpc.CallOption) (*ListTranscriptEntriesResponse, error) {
	out := new(ListTranscriptEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.apps.meet.v2beta.ConferenceRecordsService/ListTranscriptEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConferenceRecordsServiceServer is the server API for ConferenceRecordsService service.
type ConferenceRecordsServiceServer interface {
	// Gets a conference record by conference ID.
	GetConferenceRecord(context.Context, *GetConferenceRecordRequest) (*ConferenceRecord, error)
	// Lists the conference records. By default, ordered by start time and in
	// descending order.
	ListConferenceRecords(context.Context, *ListConferenceRecordsRequest) (*ListConferenceRecordsResponse, error)
	// Gets a participant by participant ID.
	GetParticipant(context.Context, *GetParticipantRequest) (*Participant, error)
	// Lists the participants in a conference record. By default, ordered by join
	// time and in descending order. This API supports `fields` as standard
	// parameters like every other API. However, when the `fields` request
	// parameter is omitted, this API defaults to `'participants/*,
	// next_page_token'`.
	ListParticipants(context.Context, *ListParticipantsRequest) (*ListParticipantsResponse, error)
	// Gets a participant session by participant session ID.
	GetParticipantSession(context.Context, *GetParticipantSessionRequest) (*ParticipantSession, error)
	// Lists the participant sessions of a participant in a conference record. By
	// default, ordered by join time and in descending order. This API supports
	// `fields` as standard parameters like every other API. However, when the
	// `fields` request parameter is omitted this API defaults to
	// `'participantsessions/*, next_page_token'`.
	ListParticipantSessions(context.Context, *ListParticipantSessionsRequest) (*ListParticipantSessionsResponse, error)
	// Gets a recording by recording ID.
	GetRecording(context.Context, *GetRecordingRequest) (*Recording, error)
	// Lists the recording resources from the conference record. By default,
	// ordered by start time and in ascending order.
	ListRecordings(context.Context, *ListRecordingsRequest) (*ListRecordingsResponse, error)
	// Gets a transcript by transcript ID.
	GetTranscript(context.Context, *GetTranscriptRequest) (*Transcript, error)
	// Lists the set of transcripts from the conference record. By default,
	// ordered by start time and in ascending order.
	ListTranscripts(context.Context, *ListTranscriptsRequest) (*ListTranscriptsResponse, error)
	// Gets a `TranscriptEntry` resource by entry ID.
	//
	// Note: The transcript entries returned by the Google Meet API might not
	// match the transcription found in the Google Docs transcript file. This can
	// occur when the Google Docs transcript file is modified after generation.
	GetTranscriptEntry(context.Context, *GetTranscriptEntryRequest) (*TranscriptEntry, error)
	// Lists the structured transcript entries per transcript. By default, ordered
	// by start time and in ascending order.
	//
	// Note: The transcript entries returned by the Google Meet API might not
	// match the transcription found in the Google Docs transcript file. This can
	// occur when the Google Docs transcript file is modified after generation.
	ListTranscriptEntries(context.Context, *ListTranscriptEntriesRequest) (*ListTranscriptEntriesResponse, error)
}

// UnimplementedConferenceRecordsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConferenceRecordsServiceServer struct {
}

func (*UnimplementedConferenceRecordsServiceServer) GetConferenceRecord(context.Context, *GetConferenceRecordRequest) (*ConferenceRecord, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConferenceRecord not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) ListConferenceRecords(context.Context, *ListConferenceRecordsRequest) (*ListConferenceRecordsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConferenceRecords not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) GetParticipant(context.Context, *GetParticipantRequest) (*Participant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetParticipant not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) ListParticipants(context.Context, *ListParticipantsRequest) (*ListParticipantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListParticipants not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) GetParticipantSession(context.Context, *GetParticipantSessionRequest) (*ParticipantSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetParticipantSession not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) ListParticipantSessions(context.Context, *ListParticipantSessionsRequest) (*ListParticipantSessionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListParticipantSessions not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) GetRecording(context.Context, *GetRecordingRequest) (*Recording, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecording not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) ListRecordings(context.Context, *ListRecordingsRequest) (*ListRecordingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecordings not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) GetTranscript(context.Context, *GetTranscriptRequest) (*Transcript, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTranscript not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) ListTranscripts(context.Context, *ListTranscriptsRequest) (*ListTranscriptsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTranscripts not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) GetTranscriptEntry(context.Context, *GetTranscriptEntryRequest) (*TranscriptEntry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTranscriptEntry not implemented")
}
func (*UnimplementedConferenceRecordsServiceServer) ListTranscriptEntries(context.Context, *ListTranscriptEntriesRequest) (*ListTranscriptEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTranscriptEntries not implemented")
}

func RegisterConferenceRecordsServiceServer(s *grpc.Server, srv ConferenceRecordsServiceServer) {
	s.RegisterService(&_ConferenceRecordsService_serviceDesc, srv)
}

func _ConferenceRecordsService_GetConferenceRecord_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConferenceRecordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).GetConferenceRecord(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/GetConferenceRecord",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).GetConferenceRecord(ctx, req.(*GetConferenceRecordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_ListConferenceRecords_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConferenceRecordsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).ListConferenceRecords(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/ListConferenceRecords",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).ListConferenceRecords(ctx, req.(*ListConferenceRecordsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_GetParticipant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetParticipantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).GetParticipant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/GetParticipant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).GetParticipant(ctx, req.(*GetParticipantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_ListParticipants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListParticipantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).ListParticipants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/ListParticipants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).ListParticipants(ctx, req.(*ListParticipantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_GetParticipantSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetParticipantSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).GetParticipantSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/GetParticipantSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).GetParticipantSession(ctx, req.(*GetParticipantSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_ListParticipantSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListParticipantSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).ListParticipantSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/ListParticipantSessions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).ListParticipantSessions(ctx, req.(*ListParticipantSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_GetRecording_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecordingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).GetRecording(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/GetRecording",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).GetRecording(ctx, req.(*GetRecordingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_ListRecordings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecordingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).ListRecordings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/ListRecordings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).ListRecordings(ctx, req.(*ListRecordingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_GetTranscript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTranscriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).GetTranscript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/GetTranscript",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).GetTranscript(ctx, req.(*GetTranscriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_ListTranscripts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTranscriptsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).ListTranscripts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/ListTranscripts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).ListTranscripts(ctx, req.(*ListTranscriptsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_GetTranscriptEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTranscriptEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).GetTranscriptEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/GetTranscriptEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).GetTranscriptEntry(ctx, req.(*GetTranscriptEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConferenceRecordsService_ListTranscriptEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTranscriptEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConferenceRecordsServiceServer).ListTranscriptEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.meet.v2beta.ConferenceRecordsService/ListTranscriptEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConferenceRecordsServiceServer).ListTranscriptEntries(ctx, req.(*ListTranscriptEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConferenceRecordsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.apps.meet.v2beta.ConferenceRecordsService",
	HandlerType: (*ConferenceRecordsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetConferenceRecord",
			Handler:    _ConferenceRecordsService_GetConferenceRecord_Handler,
		},
		{
			MethodName: "ListConferenceRecords",
			Handler:    _ConferenceRecordsService_ListConferenceRecords_Handler,
		},
		{
			MethodName: "GetParticipant",
			Handler:    _ConferenceRecordsService_GetParticipant_Handler,
		},
		{
			MethodName: "ListParticipants",
			Handler:    _ConferenceRecordsService_ListParticipants_Handler,
		},
		{
			MethodName: "GetParticipantSession",
			Handler:    _ConferenceRecordsService_GetParticipantSession_Handler,
		},
		{
			MethodName: "ListParticipantSessions",
			Handler:    _ConferenceRecordsService_ListParticipantSessions_Handler,
		},
		{
			MethodName: "GetRecording",
			Handler:    _ConferenceRecordsService_GetRecording_Handler,
		},
		{
			MethodName: "ListRecordings",
			Handler:    _ConferenceRecordsService_ListRecordings_Handler,
		},
		{
			MethodName: "GetTranscript",
			Handler:    _ConferenceRecordsService_GetTranscript_Handler,
		},
		{
			MethodName: "ListTranscripts",
			Handler:    _ConferenceRecordsService_ListTranscripts_Handler,
		},
		{
			MethodName: "GetTranscriptEntry",
			Handler:    _ConferenceRecordsService_GetTranscriptEntry_Handler,
		},
		{
			MethodName: "ListTranscriptEntries",
			Handler:    _ConferenceRecordsService_ListTranscriptEntries_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/apps/meet/v2beta/service.proto",
}
