// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/space.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Deprecated: Use `SpaceType` instead.
type Space_Type int32

const (
	// Reserved.
	Space_TYPE_UNSPECIFIED Space_Type = 0
	// Conversations between two or more humans.
	Space_ROOM Space_Type = 1
	// 1:1 Direct Message between a human and a Chat app, where all messages are
	// flat. Note that this doesn't include direct messages between two humans.
	Space_DM Space_Type = 2
)

// Enum value maps for Space_Type.
var (
	Space_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ROOM",
		2: "DM",
	}
	Space_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ROOM":             1,
		"DM":               2,
	}
)

func (x Space_Type) Enum() *Space_Type {
	p := new(Space_Type)
	*p = x
	return p
}

func (x Space_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[0].Descriptor()
}

func (Space_Type) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[0]
}

func (x Space_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_Type.Descriptor instead.
func (Space_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 0}
}

// The type of space. Required when creating or updating a space. Output only
// for other usage.
type Space_SpaceType int32

const (
	// Reserved.
	Space_SPACE_TYPE_UNSPECIFIED Space_SpaceType = 0
	// A place where people send messages, share files, and collaborate.
	// A `SPACE` can include Chat apps.
	Space_SPACE Space_SpaceType = 1
	// Group conversations between 3 or more people.
	// A `GROUP_CHAT` can include Chat apps.
	Space_GROUP_CHAT Space_SpaceType = 2
	// 1:1 messages between two humans or a human and a Chat app.
	Space_DIRECT_MESSAGE Space_SpaceType = 3
)

// Enum value maps for Space_SpaceType.
var (
	Space_SpaceType_name = map[int32]string{
		0: "SPACE_TYPE_UNSPECIFIED",
		1: "SPACE",
		2: "GROUP_CHAT",
		3: "DIRECT_MESSAGE",
	}
	Space_SpaceType_value = map[string]int32{
		"SPACE_TYPE_UNSPECIFIED": 0,
		"SPACE":                  1,
		"GROUP_CHAT":             2,
		"DIRECT_MESSAGE":         3,
	}
)

func (x Space_SpaceType) Enum() *Space_SpaceType {
	p := new(Space_SpaceType)
	*p = x
	return p
}

func (x Space_SpaceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_SpaceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[1].Descriptor()
}

func (Space_SpaceType) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[1]
}

func (x Space_SpaceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_SpaceType.Descriptor instead.
func (Space_SpaceType) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 1}
}

// Specifies the type of threading state in the Chat space.
type Space_SpaceThreadingState int32

const (
	// Reserved.
	Space_SPACE_THREADING_STATE_UNSPECIFIED Space_SpaceThreadingState = 0
	// Named spaces that support message threads. When users respond to a
	// message, they can reply in-thread, which keeps their response in the
	// context of the original message.
	Space_THREADED_MESSAGES Space_SpaceThreadingState = 2
	// Named spaces where the conversation is organized by topic. Topics and
	// their replies are grouped together.
	Space_GROUPED_MESSAGES Space_SpaceThreadingState = 3
	// Direct messages (DMs) between two people and group conversations between
	// 3 or more people.
	Space_UNTHREADED_MESSAGES Space_SpaceThreadingState = 4
)

// Enum value maps for Space_SpaceThreadingState.
var (
	Space_SpaceThreadingState_name = map[int32]string{
		0: "SPACE_THREADING_STATE_UNSPECIFIED",
		2: "THREADED_MESSAGES",
		3: "GROUPED_MESSAGES",
		4: "UNTHREADED_MESSAGES",
	}
	Space_SpaceThreadingState_value = map[string]int32{
		"SPACE_THREADING_STATE_UNSPECIFIED": 0,
		"THREADED_MESSAGES":                 2,
		"GROUPED_MESSAGES":                  3,
		"UNTHREADED_MESSAGES":               4,
	}
)

func (x Space_SpaceThreadingState) Enum() *Space_SpaceThreadingState {
	p := new(Space_SpaceThreadingState)
	*p = x
	return p
}

func (x Space_SpaceThreadingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_SpaceThreadingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[2].Descriptor()
}

func (Space_SpaceThreadingState) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[2]
}

func (x Space_SpaceThreadingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_SpaceThreadingState.Descriptor instead.
func (Space_SpaceThreadingState) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 2}
}

// Predefined permission settings that you can only specify when creating a
// named space. More settings might be added in the future.
// For details about permission settings for named spaces, see [Learn about
// spaces](https://support.google.com/chat/answer/7659784).
type Space_PredefinedPermissionSettings int32

const (
	// Unspecified. Don't use.
	Space_PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED Space_PredefinedPermissionSettings = 0
	// Setting to make the space a collaboration space where all members can
	// post messages.
	Space_COLLABORATION_SPACE Space_PredefinedPermissionSettings = 1
	// Setting to make the space an announcement space where only space managers
	// can post messages.
	Space_ANNOUNCEMENT_SPACE Space_PredefinedPermissionSettings = 2
)

// Enum value maps for Space_PredefinedPermissionSettings.
var (
	Space_PredefinedPermissionSettings_name = map[int32]string{
		0: "PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED",
		1: "COLLABORATION_SPACE",
		2: "ANNOUNCEMENT_SPACE",
	}
	Space_PredefinedPermissionSettings_value = map[string]int32{
		"PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED": 0,
		"COLLABORATION_SPACE":                        1,
		"ANNOUNCEMENT_SPACE":                         2,
	}
)

func (x Space_PredefinedPermissionSettings) Enum() *Space_PredefinedPermissionSettings {
	p := new(Space_PredefinedPermissionSettings)
	*p = x
	return p
}

func (x Space_PredefinedPermissionSettings) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_PredefinedPermissionSettings) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[3].Descriptor()
}

func (Space_PredefinedPermissionSettings) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[3]
}

func (x Space_PredefinedPermissionSettings) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_PredefinedPermissionSettings.Descriptor instead.
func (Space_PredefinedPermissionSettings) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 3}
}

// Represents the access state of the space.
type Space_AccessSettings_AccessState int32

const (
	// Access state is unknown or not supported in this API.
	Space_AccessSettings_ACCESS_STATE_UNSPECIFIED Space_AccessSettings_AccessState = 0
	// Only users or Google Groups that have been individually added or
	// invited by other users or Google Workspace administrators can discover
	// and access the space.
	Space_AccessSettings_PRIVATE Space_AccessSettings_AccessState = 1
	// A space manager has granted a target audience access to
	// the space. Users or Google Groups that have been individually added or
	// invited to the space can also discover and access the space. To learn
	// more, see [Make a space discoverable to specific
	// users](https://developers.google.com/workspace/chat/space-target-audience).
	//
	// Creating discoverable spaces requires [user
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
	Space_AccessSettings_DISCOVERABLE Space_AccessSettings_AccessState = 2
)

// Enum value maps for Space_AccessSettings_AccessState.
var (
	Space_AccessSettings_AccessState_name = map[int32]string{
		0: "ACCESS_STATE_UNSPECIFIED",
		1: "PRIVATE",
		2: "DISCOVERABLE",
	}
	Space_AccessSettings_AccessState_value = map[string]int32{
		"ACCESS_STATE_UNSPECIFIED": 0,
		"PRIVATE":                  1,
		"DISCOVERABLE":             2,
	}
)

func (x Space_AccessSettings_AccessState) Enum() *Space_AccessSettings_AccessState {
	p := new(Space_AccessSettings_AccessState)
	*p = x
	return p
}

func (x Space_AccessSettings_AccessState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Space_AccessSettings_AccessState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_proto_enumTypes[4].Descriptor()
}

func (Space_AccessSettings_AccessState) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_proto_enumTypes[4]
}

func (x Space_AccessSettings_AccessState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Space_AccessSettings_AccessState.Descriptor instead.
func (Space_AccessSettings_AccessState) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 2, 0}
}

// A space in Google Chat. Spaces are conversations between two or more users
// or 1:1 messages between a user and a Chat app.
type Space struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Resource name of the space.
	//
	// Format: `spaces/{space}`
	//
	// Where `{space}` represents the system-assigned ID for the space. You can
	// obtain the space ID by calling the
	// [`spaces.list()`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/list)
	// method or from the space URL. For example, if the space URL
	// is `https://mail.google.com/mail/u/0/#chat/space/AAAAAAAAA`, the space ID
	// is `AAAAAAAAA`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Deprecated: Use `space_type` instead.
	// The type of a space.
	//
	// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
	Type Space_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.chat.v1.Space_Type" json:"type,omitempty"`
	// Optional. The type of space. Required when creating a space or updating the
	// space type of a space. Output only for other usage.
	SpaceType Space_SpaceType `protobuf:"varint,10,opt,name=space_type,json=spaceType,proto3,enum=google.chat.v1.Space_SpaceType" json:"space_type,omitempty"`
	// Optional. Whether the space is a DM between a Chat app and a single
	// human.
	SingleUserBotDm bool `protobuf:"varint,4,opt,name=single_user_bot_dm,json=singleUserBotDm,proto3" json:"single_user_bot_dm,omitempty"`
	// Output only. Deprecated: Use `spaceThreadingState` instead.
	// Whether messages are threaded in this space.
	//
	// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
	Threaded bool `protobuf:"varint,5,opt,name=threaded,proto3" json:"threaded,omitempty"`
	// Optional. The space's display name. Required when [creating a
	// space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces/create)
	// with a `spaceType` of `SPACE`. If you receive the error message
	// `ALREADY_EXISTS` when creating a space or updating the `displayName`, try a
	// different `displayName`. An existing space within the Google Workspace
	// organization might already use this display name.
	//
	// For direct messages, this field might be empty.
	//
	// Supports up to 128 characters.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Immutable. Whether this space permits any Google Chat user as a
	// member. Input when creating a space in a Google Workspace organization.
	// Omit this field when creating spaces in the following conditions:
	//
	//   - The authenticated user uses a consumer account (unmanaged user
	//     account). By default, a space created by a consumer account permits any
	//     Google Chat user.
	//
	// For existing spaces, this field is output only.
	ExternalUserAllowed bool `protobuf:"varint,8,opt,name=external_user_allowed,json=externalUserAllowed,proto3" json:"external_user_allowed,omitempty"`
	// Output only. The threading state in the Chat space.
	SpaceThreadingState Space_SpaceThreadingState `protobuf:"varint,9,opt,name=space_threading_state,json=spaceThreadingState,proto3,enum=google.chat.v1.Space_SpaceThreadingState" json:"space_threading_state,omitempty"`
	// Optional. Details about the space including description and rules.
	SpaceDetails *Space_SpaceDetails `protobuf:"bytes,11,opt,name=space_details,json=spaceDetails,proto3" json:"space_details,omitempty"`
	// Optional. The message history state for messages and threads in this space.
	SpaceHistoryState HistoryState `protobuf:"varint,13,opt,name=space_history_state,json=spaceHistoryState,proto3,enum=google.chat.v1.HistoryState" json:"space_history_state,omitempty"`
	// Optional. Whether this space is created in `Import Mode` as part of a data
	// migration into Google Workspace. While spaces are being imported, they
	// aren't visible to users until the import is complete.
	//
	// Creating a space in `Import Mode`requires [user
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
	ImportMode bool `protobuf:"varint,16,opt,name=import_mode,json=importMode,proto3" json:"import_mode,omitempty"`
	// Optional. Immutable. For spaces created in Chat, the time the space was
	// created. This field is output only, except when used in import mode spaces.
	//
	// For import mode spaces, set this field to the historical timestamp at which
	// the space was created in the source in order to preserve the original
	// creation time.
	//
	// Only populated in the output when `spaceType` is `GROUP_CHAT` or `SPACE`.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp of the last message in the space.
	LastActiveTime *timestamppb.Timestamp `protobuf:"bytes,18,opt,name=last_active_time,json=lastActiveTime,proto3" json:"last_active_time,omitempty"`
	// Output only. For direct message (DM) spaces with a Chat app, whether the
	// space was created by a Google Workspace administrator. Administrators can
	// install and set up a direct message with a Chat app on behalf of users in
	// their organization.
	//
	// To support admin install, your Chat app must feature direct messaging.
	AdminInstalled bool `protobuf:"varint,19,opt,name=admin_installed,json=adminInstalled,proto3" json:"admin_installed,omitempty"`
	// Output only. The count of joined memberships grouped by member type.
	// Populated when the `space_type` is `SPACE`, `DIRECT_MESSAGE` or
	// `GROUP_CHAT`.
	MembershipCount *Space_MembershipCount `protobuf:"bytes,20,opt,name=membership_count,json=membershipCount,proto3" json:"membership_count,omitempty"`
	// Optional. Specifies the [access
	// setting](https://support.google.com/chat/answer/11971020) of the space.
	// Only populated when the `space_type` is `SPACE`.
	AccessSettings *Space_AccessSettings `protobuf:"bytes,23,opt,name=access_settings,json=accessSettings,proto3" json:"access_settings,omitempty"`
	// Output only. The URI for a user to access the space.
	SpaceUri string `protobuf:"bytes,25,opt,name=space_uri,json=spaceUri,proto3" json:"space_uri,omitempty"`
	// Represents the [permission settings]
	// (https://support.google.com/chat/answer/13340792) of a space. Only
	// populated when the `space_type` is `SPACE`.
	//
	// Requires [user
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
	//
	// Types that are assignable to SpacePermissionSettings:
	//
	//	*Space_PredefinedPermissionSettings_
	//	*Space_PermissionSettings_
	SpacePermissionSettings isSpace_SpacePermissionSettings `protobuf_oneof:"space_permission_settings"`
	// Output only. The time when the space will be automatically deleted by the
	// system if it remains in import mode.
	//
	// Each space created in import mode must exit this mode before this expire
	// time using `spaces.completeImport`.
	//
	// This field is only populated for spaces that were created with import mode.
	ImportModeExpireTime *timestamppb.Timestamp `protobuf:"bytes,28,opt,name=import_mode_expire_time,json=importModeExpireTime,proto3" json:"import_mode_expire_time,omitempty"`
}

func (x *Space) Reset() {
	*x = Space{}
	mi := &file_google_chat_v1_space_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space) ProtoMessage() {}

func (x *Space) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space.ProtoReflect.Descriptor instead.
func (*Space) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0}
}

func (x *Space) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
func (x *Space) GetType() Space_Type {
	if x != nil {
		return x.Type
	}
	return Space_TYPE_UNSPECIFIED
}

func (x *Space) GetSpaceType() Space_SpaceType {
	if x != nil {
		return x.SpaceType
	}
	return Space_SPACE_TYPE_UNSPECIFIED
}

func (x *Space) GetSingleUserBotDm() bool {
	if x != nil {
		return x.SingleUserBotDm
	}
	return false
}

// Deprecated: Marked as deprecated in google/chat/v1/space.proto.
func (x *Space) GetThreaded() bool {
	if x != nil {
		return x.Threaded
	}
	return false
}

func (x *Space) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Space) GetExternalUserAllowed() bool {
	if x != nil {
		return x.ExternalUserAllowed
	}
	return false
}

func (x *Space) GetSpaceThreadingState() Space_SpaceThreadingState {
	if x != nil {
		return x.SpaceThreadingState
	}
	return Space_SPACE_THREADING_STATE_UNSPECIFIED
}

func (x *Space) GetSpaceDetails() *Space_SpaceDetails {
	if x != nil {
		return x.SpaceDetails
	}
	return nil
}

func (x *Space) GetSpaceHistoryState() HistoryState {
	if x != nil {
		return x.SpaceHistoryState
	}
	return HistoryState_HISTORY_STATE_UNSPECIFIED
}

func (x *Space) GetImportMode() bool {
	if x != nil {
		return x.ImportMode
	}
	return false
}

func (x *Space) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Space) GetLastActiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastActiveTime
	}
	return nil
}

func (x *Space) GetAdminInstalled() bool {
	if x != nil {
		return x.AdminInstalled
	}
	return false
}

func (x *Space) GetMembershipCount() *Space_MembershipCount {
	if x != nil {
		return x.MembershipCount
	}
	return nil
}

func (x *Space) GetAccessSettings() *Space_AccessSettings {
	if x != nil {
		return x.AccessSettings
	}
	return nil
}

func (x *Space) GetSpaceUri() string {
	if x != nil {
		return x.SpaceUri
	}
	return ""
}

func (m *Space) GetSpacePermissionSettings() isSpace_SpacePermissionSettings {
	if m != nil {
		return m.SpacePermissionSettings
	}
	return nil
}

func (x *Space) GetPredefinedPermissionSettings() Space_PredefinedPermissionSettings {
	if x, ok := x.GetSpacePermissionSettings().(*Space_PredefinedPermissionSettings_); ok {
		return x.PredefinedPermissionSettings
	}
	return Space_PREDEFINED_PERMISSION_SETTINGS_UNSPECIFIED
}

func (x *Space) GetPermissionSettings() *Space_PermissionSettings {
	if x, ok := x.GetSpacePermissionSettings().(*Space_PermissionSettings_); ok {
		return x.PermissionSettings
	}
	return nil
}

func (x *Space) GetImportModeExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ImportModeExpireTime
	}
	return nil
}

type isSpace_SpacePermissionSettings interface {
	isSpace_SpacePermissionSettings()
}

type Space_PredefinedPermissionSettings_ struct {
	// Optional. Input only. Predefined space permission settings, input only
	// when creating a space. If the field is not set, a collaboration space is
	// created. After you create the space, settings are populated in the
	// `PermissionSettings` field.
	PredefinedPermissionSettings Space_PredefinedPermissionSettings `protobuf:"varint,26,opt,name=predefined_permission_settings,json=predefinedPermissionSettings,proto3,enum=google.chat.v1.Space_PredefinedPermissionSettings,oneof"`
}

type Space_PermissionSettings_ struct {
	// Optional. Space permission settings for existing spaces. Input for
	// updating exact space permission settings, where existing permission
	// settings are replaced. Output lists current permission settings.
	PermissionSettings *Space_PermissionSettings `protobuf:"bytes,27,opt,name=permission_settings,json=permissionSettings,proto3,oneof"`
}

func (*Space_PredefinedPermissionSettings_) isSpace_SpacePermissionSettings() {}

func (*Space_PermissionSettings_) isSpace_SpacePermissionSettings() {}

// A request to create a named space with no members.
type CreateSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `displayName` and `spaceType` fields must be populated.  Only
	// `SpaceType.SPACE`  and `SpaceType.GROUP_CHAT` are supported.
	// `SpaceType.GROUP_CHAT` can only be used if `importMode` is set to true.
	//
	// If you receive the error message `ALREADY_EXISTS`,
	// try a different `displayName`. An existing space within the Google
	// Workspace organization might already use this display name.
	//
	// The space `name` is assigned on the server so anything specified in this
	// field will be ignored.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// Optional. A unique identifier for this request.
	// A random UUID is recommended.
	// Specifying an existing request ID returns the space created with that ID
	// instead of creating a new space.
	// Specifying an existing request ID from the same Chat app with a different
	// authenticated user returns an error.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSpaceRequest) Reset() {
	*x = CreateSpaceRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSpaceRequest) ProtoMessage() {}

func (x *CreateSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSpaceRequest.ProtoReflect.Descriptor instead.
func (*CreateSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{1}
}

func (x *CreateSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *CreateSpaceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to list the spaces the caller is a member of.
type ListSpacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The maximum number of spaces to return. The service might return
	// fewer than this value.
	//
	// If unspecified, at most 100 spaces are returned.
	//
	// The maximum value is 1000. If you use a value more than 1000, it's
	// automatically changed to 1000.
	//
	// Negative values return an `INVALID_ARGUMENT` error.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous list spaces call.
	// Provide this parameter to retrieve the subsequent page.
	//
	// When paginating, the filter value should match the call that provided the
	// page token. Passing a different value may lead to unexpected results.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A query filter.
	//
	// You can filter spaces by the space type
	// ([`space_type`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#spacetype)).
	//
	// To filter by space type, you must specify valid enum value, such as
	// `SPACE` or `GROUP_CHAT` (the `space_type` can't be
	// `SPACE_TYPE_UNSPECIFIED`). To query for multiple space types, use the `OR`
	// operator.
	//
	// For example, the following queries are valid:
	//
	// ```
	// space_type = "SPACE"
	// spaceType = "GROUP_CHAT" OR spaceType = "DIRECT_MESSAGE"
	// ```
	//
	// Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
	// error.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSpacesRequest) Reset() {
	*x = ListSpacesRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpacesRequest) ProtoMessage() {}

func (x *ListSpacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpacesRequest.ProtoReflect.Descriptor instead.
func (*ListSpacesRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{2}
}

func (x *ListSpacesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpacesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpacesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for a list spaces request.
type ListSpacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of spaces in the requested (or first) page.
	// Note: The `permissionSettings` field is not returned in the Space
	// object for list requests.
	Spaces []*Space `protobuf:"bytes,1,rep,name=spaces,proto3" json:"spaces,omitempty"`
	// You can send a token as `pageToken` to retrieve the next page of
	// results. If empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSpacesResponse) Reset() {
	*x = ListSpacesResponse{}
	mi := &file_google_chat_v1_space_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpacesResponse) ProtoMessage() {}

func (x *ListSpacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpacesResponse.ProtoReflect.Descriptor instead.
func (*ListSpacesResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{3}
}

func (x *ListSpacesResponse) GetSpaces() []*Space {
	if x != nil {
		return x.Spaces
	}
	return nil
}

func (x *ListSpacesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request to return a single space.
type GetSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space, in the form `spaces/{space}`.
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. When `true`, the method runs using the user's Google Workspace
	// administrator privileges.
	//
	// The calling user must be a Google Workspace administrator with the
	// [manage chat and spaces conversations
	// privilege](https://support.google.com/a/answer/13369245).
	//
	// Requires the `chat.admin.spaces` or `chat.admin.spaces.readonly` [OAuth 2.0
	// scopes](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *GetSpaceRequest) Reset() {
	*x = GetSpaceRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpaceRequest) ProtoMessage() {}

func (x *GetSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpaceRequest.ProtoReflect.Descriptor instead.
func (*GetSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{4}
}

func (x *GetSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetSpaceRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// A request to get direct message space based on the user resource.
type FindDirectMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the user to find direct message with.
	//
	// Format: `users/{user}`, where `{user}` is either the `id` for the
	// [person](https://developers.google.com/people/api/rest/v1/people) from the
	// People API, or the `id` for the
	// [user](https://developers.google.com/admin-sdk/directory/reference/rest/v1/users)
	// in the Directory API. For example, if the People API profile ID is
	// `123456789`, you can find a direct message with that person by using
	// `users/123456789` as the `name`. When [authenticated as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// you can use the email as an alias for `{user}`. For example,
	// `users/example@gmail.com` where `example@gmail.com` is the email of the
	// Google Chat user.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FindDirectMessageRequest) Reset() {
	*x = FindDirectMessageRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FindDirectMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FindDirectMessageRequest) ProtoMessage() {}

func (x *FindDirectMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FindDirectMessageRequest.ProtoReflect.Descriptor instead.
func (*FindDirectMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{5}
}

func (x *FindDirectMessageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to update a single space.
type UpdateSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Space with fields to be updated. `Space.name` must be
	// populated in the form of `spaces/{space}`. Only fields
	// specified by `update_mask` are updated.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// Required. The updated field paths, comma separated if there are
	// multiple.
	//
	// You can update the following fields for a space:
	//
	// `space_details`: Updates the space's description. Supports up to 150
	// characters.
	//
	// `display_name`: Only supports updating the display name for spaces where
	// `spaceType` field is `SPACE`.
	//
	//	If you receive the error message `ALREADY_EXISTS`, try a different
	//	value. An existing space within the
	//
	// Google Workspace organization might already use this display name.
	//
	// `space_type`: Only supports changing a `GROUP_CHAT` space type to
	// `SPACE`. Include `display_name` together
	// with `space_type` in the update mask and ensure that the specified space
	// has a non-empty display name and the `SPACE` space type. Including the
	// `space_type` mask and the `SPACE` type in the specified space when updating
	// the display name is optional if the existing space already has the `SPACE`
	// type. Trying to update the space type in other ways results in an invalid
	// argument error.
	// `space_type` is not supported with `useAdminAccess`.
	//
	// `space_history_state`: Updates [space history
	// settings](https://support.google.com/chat/answer/7664687) by turning
	// history on or off for the space. Only supported if history settings are
	// enabled for the Google Workspace organization. To update the
	// space history state, you must omit all other field masks in your request.
	// `space_history_state` is not supported with `useAdminAccess`.
	//
	// `access_settings.audience`: Updates the [access
	// setting](https://support.google.com/chat/answer/11971020) of who can
	// discover the space, join the space, and preview the messages in named space
	// where `spaceType` field is `SPACE`. If the existing space has a
	// target audience, you can remove the audience and restrict space access by
	// omitting a value for this field mask. To update access settings for a
	// space, the authenticating user must be a space manager and omit all other
	// field masks in your request. You can't update this field if the space is in
	// [import
	// mode](https://developers.google.com/workspace/chat/import-data-overview).
	// To learn more, see [Make a space discoverable to specific
	// users](https://developers.google.com/workspace/chat/space-target-audience).
	// `access_settings.audience` is not supported with `useAdminAccess`.
	//
	// `permission_settings`: Supports changing the
	// [permission settings](https://support.google.com/chat/answer/13340792)
	// of a space.
	// When updating permission settings, you can only specify
	// `permissionSettings` field masks; you cannot update other field masks
	// at the same time. `permissionSettings` is not supported with
	// `useAdminAccess`.
	// The supported field masks include:
	//
	// - `permission_settings.manageMembersAndGroups`
	// - `permission_settings.modifySpaceDetails`
	// - `permission_settings.toggleHistory`
	// - `permission_settings.useAtMentionAll`
	// - `permission_settings.manageApps`
	// - `permission_settings.manageWebhooks`
	// - `permission_settings.replyMessages`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. When `true`, the method runs using the user's Google Workspace
	// administrator privileges.
	//
	// The calling user must be a Google Workspace administrator with the
	// [manage chat and spaces conversations
	// privilege](https://support.google.com/a/answer/13369245).
	//
	// Requires the `chat.admin.spaces` [OAuth 2.0
	// scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
	//
	// Some `FieldMask` values are not supported using admin access. For details,
	// see the description of `update_mask`.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *UpdateSpaceRequest) Reset() {
	*x = UpdateSpaceRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpaceRequest) ProtoMessage() {}

func (x *UpdateSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpaceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateSpaceRequest) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *UpdateSpaceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSpaceRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// Request to search for a list of spaces based on a query.
type SearchSpacesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When `true`, the method runs using the user's Google Workspace
	// administrator privileges.
	//
	// The calling user must be a Google Workspace administrator with the
	// [manage chat and spaces conversations
	// privilege](https://support.google.com/a/answer/13369245).
	//
	// Requires either the `chat.admin.spaces.readonly` or `chat.admin.spaces`
	// [OAuth 2.0
	// scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
	//
	// This method currently only supports admin access, thus only `true` is
	// accepted for this field.
	UseAdminAccess bool `protobuf:"varint,1,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// The maximum number of spaces to return. The service may return fewer than
	// this value.
	//
	// If unspecified, at most 100 spaces are returned.
	//
	// The maximum value is 1000. If you use a value more than 1000, it's
	// automatically changed to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token, received from the previous search spaces call. Provide this
	// parameter to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided should match the call that
	// provided the page token. Passing different values to the other parameters
	// might lead to unexpected results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. A search query.
	//
	// You can search by using the following parameters:
	//
	// - `create_time`
	// - `customer`
	// - `display_name`
	// - `external_user_allowed`
	// - `last_active_time`
	// - `space_history_state`
	// - `space_type`
	//
	// `create_time` and `last_active_time` accept a timestamp in
	// [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339) format and the supported
	// comparison operators are: `=`, `<`, `>`, `<=`, `>=`.
	//
	// `customer` is required and is used to indicate which customer
	// to fetch spaces from. `customers/my_customer` is the only supported value.
	//
	// `display_name` only accepts the `HAS` (`:`) operator. The text to
	// match is first tokenized into tokens and each token is prefix-matched
	// case-insensitively and independently as a substring anywhere in the space's
	// `display_name`. For example, `Fun Eve` matches `Fun event` or `The
	// evening was fun`, but not `notFun event` or `even`.
	//
	// `external_user_allowed` accepts either `true` or `false`.
	//
	// `space_history_state` only accepts values from the [`historyState`]
	// (https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces#Space.HistoryState)
	// field of a `space` resource.
	//
	// `space_type` is required and the only valid value is `SPACE`.
	//
	// Across different fields, only `AND` operators are supported. A valid
	// example is `space_type = "SPACE" AND display_name:"Hello"` and an invalid
	// example is `space_type = "SPACE" OR display_name:"Hello"`.
	//
	// Among the same field,
	// `space_type` doesn't support `AND` or `OR` operators.
	// `display_name`, 'space_history_state', and 'external_user_allowed' only
	// support `OR` operators.
	// `last_active_time` and `create_time` support both `AND` and `OR` operators.
	// `AND` can only be used to represent an interval, such as `last_active_time
	// < "2022-01-01T00:00:00+00:00" AND last_active_time >
	// "2023-01-01T00:00:00+00:00"`.
	//
	// The following example queries are valid:
	//
	// ```
	// customer = "customers/my_customer" AND space_type = "SPACE"
	//
	// customer = "customers/my_customer" AND space_type = "SPACE" AND
	// display_name:"Hello World"
	//
	// customer = "customers/my_customer" AND space_type = "SPACE" AND
	// (last_active_time < "2020-01-01T00:00:00+00:00" OR last_active_time >
	// "2022-01-01T00:00:00+00:00")
	//
	// customer = "customers/my_customer" AND space_type = "SPACE" AND
	// (display_name:"Hello World" OR display_name:"Fun event") AND
	// (last_active_time > "2020-01-01T00:00:00+00:00" AND last_active_time <
	// "2022-01-01T00:00:00+00:00")
	//
	// customer = "customers/my_customer" AND space_type = "SPACE" AND
	// (create_time > "2019-01-01T00:00:00+00:00" AND create_time <
	// "2020-01-01T00:00:00+00:00") AND (external_user_allowed = "true") AND
	// (space_history_state = "HISTORY_ON" OR space_history_state = "HISTORY_OFF")
	// ```
	Query string `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. How the list of spaces is ordered.
	//
	// Supported attributes to order by are:
	//
	// - `membership_count.joined_direct_human_user_count` — Denotes the count of
	// human users that have directly joined a space.
	// - `last_active_time` — Denotes the time when last eligible item is added to
	// any topic of this space.
	// - `create_time` — Denotes the time of the space creation.
	//
	// Valid ordering operation values are:
	//
	// - `ASC` for ascending. Default value.
	//
	// - `DESC` for descending.
	//
	// The supported syntax are:
	//
	// - `membership_count.joined_direct_human_user_count DESC`
	// - `membership_count.joined_direct_human_user_count ASC`
	// - `last_active_time DESC`
	// - `last_active_time ASC`
	// - `create_time DESC`
	// - `create_time ASC`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchSpacesRequest) Reset() {
	*x = SearchSpacesRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchSpacesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSpacesRequest) ProtoMessage() {}

func (x *SearchSpacesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSpacesRequest.ProtoReflect.Descriptor instead.
func (*SearchSpacesRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{7}
}

func (x *SearchSpacesRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *SearchSpacesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchSpacesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchSpacesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchSpacesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response with a list of spaces corresponding to the search spaces request.
type SearchSpacesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A page of the requested spaces.
	Spaces []*Space `protobuf:"bytes,1,rep,name=spaces,proto3" json:"spaces,omitempty"`
	// A token that can be used to retrieve the next page. If this field is empty,
	// there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of spaces that match the query, across all pages. If the
	// result is over 10,000 spaces, this value is an estimate.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *SearchSpacesResponse) Reset() {
	*x = SearchSpacesResponse{}
	mi := &file_google_chat_v1_space_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchSpacesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchSpacesResponse) ProtoMessage() {}

func (x *SearchSpacesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchSpacesResponse.ProtoReflect.Descriptor instead.
func (*SearchSpacesResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{8}
}

func (x *SearchSpacesResponse) GetSpaces() []*Space {
	if x != nil {
		return x.Spaces
	}
	return nil
}

func (x *SearchSpacesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchSpacesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request for deleting a space.
type DeleteSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the space to delete.
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. When `true`, the method runs using the user's Google Workspace
	// administrator privileges.
	//
	// The calling user must be a Google Workspace administrator with the
	// [manage chat and spaces conversations
	// privilege](https://support.google.com/a/answer/13369245).
	//
	// Requires the `chat.admin.delete` [OAuth 2.0
	// scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
}

func (x *DeleteSpaceRequest) Reset() {
	*x = DeleteSpaceRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSpaceRequest) ProtoMessage() {}

func (x *DeleteSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSpaceRequest.ProtoReflect.Descriptor instead.
func (*DeleteSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSpaceRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

// Request message for completing the import process for a space.
type CompleteImportSpaceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the import mode space.
	//
	// Format: `spaces/{space}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CompleteImportSpaceRequest) Reset() {
	*x = CompleteImportSpaceRequest{}
	mi := &file_google_chat_v1_space_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteImportSpaceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteImportSpaceRequest) ProtoMessage() {}

func (x *CompleteImportSpaceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteImportSpaceRequest.ProtoReflect.Descriptor instead.
func (*CompleteImportSpaceRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{10}
}

func (x *CompleteImportSpaceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for completing the import process for a space.
type CompleteImportSpaceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The import mode space.
	Space *Space `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
}

func (x *CompleteImportSpaceResponse) Reset() {
	*x = CompleteImportSpaceResponse{}
	mi := &file_google_chat_v1_space_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteImportSpaceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteImportSpaceResponse) ProtoMessage() {}

func (x *CompleteImportSpaceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteImportSpaceResponse.ProtoReflect.Descriptor instead.
func (*CompleteImportSpaceResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{11}
}

func (x *CompleteImportSpaceResponse) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

// Details about the space including description and rules.
type Space_SpaceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A description of the space. For example, describe the space's
	// discussion topic, functional purpose, or participants.
	//
	// Supports up to 150 characters.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The space's rules, expectations, and etiquette.
	//
	// Supports up to 5,000 characters.
	Guidelines string `protobuf:"bytes,2,opt,name=guidelines,proto3" json:"guidelines,omitempty"`
}

func (x *Space_SpaceDetails) Reset() {
	*x = Space_SpaceDetails{}
	mi := &file_google_chat_v1_space_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space_SpaceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space_SpaceDetails) ProtoMessage() {}

func (x *Space_SpaceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space_SpaceDetails.ProtoReflect.Descriptor instead.
func (*Space_SpaceDetails) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Space_SpaceDetails) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Space_SpaceDetails) GetGuidelines() string {
	if x != nil {
		return x.Guidelines
	}
	return ""
}

// Represents the count of memberships of a space, grouped into categories.
type Space_MembershipCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Count of human users that have directly joined the space,
	// not counting users joined by having membership in a joined group.
	JoinedDirectHumanUserCount int32 `protobuf:"varint,4,opt,name=joined_direct_human_user_count,json=joinedDirectHumanUserCount,proto3" json:"joined_direct_human_user_count,omitempty"`
	// Output only. Count of all groups that have directly joined the space.
	JoinedGroupCount int32 `protobuf:"varint,5,opt,name=joined_group_count,json=joinedGroupCount,proto3" json:"joined_group_count,omitempty"`
}

func (x *Space_MembershipCount) Reset() {
	*x = Space_MembershipCount{}
	mi := &file_google_chat_v1_space_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space_MembershipCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space_MembershipCount) ProtoMessage() {}

func (x *Space_MembershipCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space_MembershipCount.ProtoReflect.Descriptor instead.
func (*Space_MembershipCount) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Space_MembershipCount) GetJoinedDirectHumanUserCount() int32 {
	if x != nil {
		return x.JoinedDirectHumanUserCount
	}
	return 0
}

func (x *Space_MembershipCount) GetJoinedGroupCount() int32 {
	if x != nil {
		return x.JoinedGroupCount
	}
	return 0
}

// Represents the [access
// setting](https://support.google.com/chat/answer/11971020) of the space.
type Space_AccessSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Indicates the access state of the space.
	AccessState Space_AccessSettings_AccessState `protobuf:"varint,1,opt,name=access_state,json=accessState,proto3,enum=google.chat.v1.Space_AccessSettings_AccessState" json:"access_state,omitempty"`
	// Optional. The resource name of the [target
	// audience](https://support.google.com/a/answer/9934697) who can discover
	// the space, join the space, and preview the messages in the space. If
	// unset, only users or Google Groups who have been individually invited or
	// added to the space can access it. For details, see [Make a space
	// discoverable to a target
	// audience](https://developers.google.com/workspace/chat/space-target-audience).
	//
	// Format: `audiences/{audience}`
	//
	// To use the default target audience for the Google Workspace organization,
	// set to `audiences/default`.
	//
	// Reading the target audience supports:
	//
	// - [User
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
	//
	// - [App
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app)
	// with [administrator
	// approval](https://support.google.com/a?p=chat-app-auth)
	// with the `chat.app.spaces` scope in [Developer
	// Preview](https://developers.google.com/workspace/preview).
	//
	// This field is not populated when using the `chat.bot` scope with [app
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
	//
	// Setting the target audience requires [user
	// authentication](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
	Audience string `protobuf:"bytes,3,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *Space_AccessSettings) Reset() {
	*x = Space_AccessSettings{}
	mi := &file_google_chat_v1_space_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space_AccessSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space_AccessSettings) ProtoMessage() {}

func (x *Space_AccessSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space_AccessSettings.ProtoReflect.Descriptor instead.
func (*Space_AccessSettings) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Space_AccessSettings) GetAccessState() Space_AccessSettings_AccessState {
	if x != nil {
		return x.AccessState
	}
	return Space_AccessSettings_ACCESS_STATE_UNSPECIFIED
}

func (x *Space_AccessSettings) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

// [Permission settings](https://support.google.com/chat/answer/13340792)
// that you can specify when updating an existing named space.
//
// To set permission settings when creating a space, specify the
// `PredefinedPermissionSettings` field in your request.
type Space_PermissionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Setting for managing members and groups in a space.
	ManageMembersAndGroups *Space_PermissionSetting `protobuf:"bytes,1,opt,name=manage_members_and_groups,json=manageMembersAndGroups,proto3,oneof" json:"manage_members_and_groups,omitempty"`
	// Optional. Setting for updating space name, avatar, description and
	// guidelines.
	ModifySpaceDetails *Space_PermissionSetting `protobuf:"bytes,2,opt,name=modify_space_details,json=modifySpaceDetails,proto3,oneof" json:"modify_space_details,omitempty"`
	// Optional. Setting for toggling space history on and off.
	ToggleHistory *Space_PermissionSetting `protobuf:"bytes,3,opt,name=toggle_history,json=toggleHistory,proto3,oneof" json:"toggle_history,omitempty"`
	// Optional. Setting for using @all in a space.
	UseAtMentionAll *Space_PermissionSetting `protobuf:"bytes,4,opt,name=use_at_mention_all,json=useAtMentionAll,proto3,oneof" json:"use_at_mention_all,omitempty"`
	// Optional. Setting for managing apps in a space.
	ManageApps *Space_PermissionSetting `protobuf:"bytes,5,opt,name=manage_apps,json=manageApps,proto3,oneof" json:"manage_apps,omitempty"`
	// Optional. Setting for managing webhooks in a space.
	ManageWebhooks *Space_PermissionSetting `protobuf:"bytes,6,opt,name=manage_webhooks,json=manageWebhooks,proto3,oneof" json:"manage_webhooks,omitempty"`
	// Output only. Setting for posting messages in a space.
	PostMessages *Space_PermissionSetting `protobuf:"bytes,7,opt,name=post_messages,json=postMessages,proto3,oneof" json:"post_messages,omitempty"`
	// Optional. Setting for replying to messages in a space.
	ReplyMessages *Space_PermissionSetting `protobuf:"bytes,8,opt,name=reply_messages,json=replyMessages,proto3,oneof" json:"reply_messages,omitempty"`
}

func (x *Space_PermissionSettings) Reset() {
	*x = Space_PermissionSettings{}
	mi := &file_google_chat_v1_space_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space_PermissionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space_PermissionSettings) ProtoMessage() {}

func (x *Space_PermissionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space_PermissionSettings.ProtoReflect.Descriptor instead.
func (*Space_PermissionSettings) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Space_PermissionSettings) GetManageMembersAndGroups() *Space_PermissionSetting {
	if x != nil {
		return x.ManageMembersAndGroups
	}
	return nil
}

func (x *Space_PermissionSettings) GetModifySpaceDetails() *Space_PermissionSetting {
	if x != nil {
		return x.ModifySpaceDetails
	}
	return nil
}

func (x *Space_PermissionSettings) GetToggleHistory() *Space_PermissionSetting {
	if x != nil {
		return x.ToggleHistory
	}
	return nil
}

func (x *Space_PermissionSettings) GetUseAtMentionAll() *Space_PermissionSetting {
	if x != nil {
		return x.UseAtMentionAll
	}
	return nil
}

func (x *Space_PermissionSettings) GetManageApps() *Space_PermissionSetting {
	if x != nil {
		return x.ManageApps
	}
	return nil
}

func (x *Space_PermissionSettings) GetManageWebhooks() *Space_PermissionSetting {
	if x != nil {
		return x.ManageWebhooks
	}
	return nil
}

func (x *Space_PermissionSettings) GetPostMessages() *Space_PermissionSetting {
	if x != nil {
		return x.PostMessages
	}
	return nil
}

func (x *Space_PermissionSettings) GetReplyMessages() *Space_PermissionSetting {
	if x != nil {
		return x.ReplyMessages
	}
	return nil
}

// Represents a space permission setting.
type Space_PermissionSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether spaces managers have this permission.
	ManagersAllowed bool `protobuf:"varint,1,opt,name=managers_allowed,json=managersAllowed,proto3" json:"managers_allowed,omitempty"`
	// Optional. Whether non-manager members have this permission.
	MembersAllowed bool `protobuf:"varint,2,opt,name=members_allowed,json=membersAllowed,proto3" json:"members_allowed,omitempty"`
}

func (x *Space_PermissionSetting) Reset() {
	*x = Space_PermissionSetting{}
	mi := &file_google_chat_v1_space_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Space_PermissionSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Space_PermissionSetting) ProtoMessage() {}

func (x *Space_PermissionSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Space_PermissionSetting.ProtoReflect.Descriptor instead.
func (*Space_PermissionSetting) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Space_PermissionSetting) GetManagersAllowed() bool {
	if x != nil {
		return x.ManagersAllowed
	}
	return false
}

func (x *Space_PermissionSetting) GetMembersAllowed() bool {
	if x != nil {
		return x.MembersAllowed
	}
	return false
}

var File_google_chat_v1_space_proto protoreflect.FileDescriptor

var file_google_chat_v1_space_proto_rawDesc = []byte{
	0x0a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x8e, 0x1a, 0x0a, 0x05, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x05, 0xe0, 0x41,
	0x03, 0x18, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x0a, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x70, 0x61, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30,
	0x0a, 0x12, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x62, 0x6f,
	0x74, 0x5f, 0x64, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x73, 0x65, 0x72, 0x42, 0x6f, 0x74, 0x44, 0x6d,
	0x12, 0x21, 0x0a, 0x08, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x03, 0x18, 0x01, 0x52, 0x08, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x64, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x15, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0,
	0x41, 0x01, 0x52, 0x13, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x62, 0x0a, 0x15, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x73, 0x70, 0x61, 0x63, 0x65, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x51, 0x0a, 0x13, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x0b,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64,
	0x12, 0x55, 0x0a, 0x10, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x70, 0x61, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x82, 0x01,
	0x0a, 0x1e, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x1c, 0x70, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x60, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x12, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x56, 0x0a, 0x17, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x5a, 0x0a, 0x0c,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0a, 0x67, 0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x75,
	0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x1a, 0x8d, 0x01, 0x0a, 0x0f, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x1e,
	0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x68, 0x75,
	0x6d, 0x61, 0x6e, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x6a, 0x6f, 0x69, 0x6e, 0x65,
	0x64, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x55, 0x73, 0x65, 0x72,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xd7, 0x01, 0x0a, 0x0e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x61, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x4a, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x02, 0x1a, 0xad, 0x07, 0x0a, 0x12, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6c, 0x0a, 0x19, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x16, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x41, 0x6e, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x14, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x79, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x12, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x0e,
	0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x02, 0x52, 0x0d, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x74,
	0x5f, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x03, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x41, 0x74, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x6c, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x5f, 0x61, 0x70, 0x70, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x0a, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x41, 0x70, 0x70, 0x73, 0x88, 0x01, 0x01, 0x12, 0x5a, 0x0a, 0x0f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x0d, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x06, 0x52, 0x0c, 0x70,
	0x6f, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x58,
	0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x73, 0x88, 0x01, 0x01, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x79, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x74, 0x5f, 0x6d, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6c, 0x6c, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x42,
	0x11, 0x0a, 0x0f, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x73, 0x1a, 0x71, 0x0a, 0x11, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x73,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x22, 0x2e, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x4f, 0x4f, 0x4d, 0x10, 0x01, 0x12, 0x06, 0x0a,
	0x02, 0x44, 0x4d, 0x10, 0x02, 0x22, 0x56, 0x0a, 0x09, 0x53, 0x70, 0x61, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x50, 0x41, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x5f, 0x43, 0x48, 0x41, 0x54, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x49, 0x52,
	0x45, 0x43, 0x54, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x10, 0x03, 0x22, 0x82, 0x01,
	0x0a, 0x13, 0x53, 0x70, 0x61, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x50, 0x41, 0x43, 0x45, 0x5f, 0x54,
	0x48, 0x52, 0x45, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11,
	0x54, 0x48, 0x52, 0x45, 0x41, 0x44, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45,
	0x53, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x45, 0x44, 0x5f, 0x4d,
	0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x53, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x4e, 0x54,
	0x48, 0x52, 0x45, 0x41, 0x44, 0x45, 0x44, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x53,
	0x10, 0x04, 0x22, 0x7f, 0x0a, 0x1c, 0x50, 0x72, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x2e, 0x0a, 0x2a, 0x50, 0x52, 0x45, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44,
	0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x45, 0x54, 0x54,
	0x49, 0x4e, 0x47, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4c, 0x4c, 0x41, 0x42, 0x4f, 0x52, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x4e, 0x4e, 0x4f, 0x55, 0x4e, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x10, 0x02, 0x3a, 0x2e, 0xea, 0x41, 0x2b, 0x0a, 0x19, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x0e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x7d, 0x42, 0x1b, 0x0a, 0x19, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x6a, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x76, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0x6b, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x52, 0x06, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x77, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x10, 0x75,
	0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0x33, 0x0a, 0x18, 0x46, 0x69,
	0x6e, 0x64, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb7, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2d, 0x0a, 0x10, 0x75, 0x73,
	0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x13, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x75, 0x73, 0x65,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0x8c, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61,
	0x63, 0x65, 0x52, 0x06, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a,
	0x65, 0x22, 0x7a, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1b, 0x0a, 0x19, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d,
	0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x75,
	0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0x53, 0x0a,
	0x1a, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1b, 0x0a, 0x19, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x4a, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2b, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x42, 0xa3,
	0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x53, 0x70, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70,
	0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa,
	0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68,
	0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41,
	0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_space_proto_rawDescOnce sync.Once
	file_google_chat_v1_space_proto_rawDescData = file_google_chat_v1_space_proto_rawDesc
)

func file_google_chat_v1_space_proto_rawDescGZIP() []byte {
	file_google_chat_v1_space_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_space_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_space_proto_rawDescData)
	})
	return file_google_chat_v1_space_proto_rawDescData
}

var file_google_chat_v1_space_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_chat_v1_space_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_chat_v1_space_proto_goTypes = []any{
	(Space_Type)(0),                         // 0: google.chat.v1.Space.Type
	(Space_SpaceType)(0),                    // 1: google.chat.v1.Space.SpaceType
	(Space_SpaceThreadingState)(0),          // 2: google.chat.v1.Space.SpaceThreadingState
	(Space_PredefinedPermissionSettings)(0), // 3: google.chat.v1.Space.PredefinedPermissionSettings
	(Space_AccessSettings_AccessState)(0),   // 4: google.chat.v1.Space.AccessSettings.AccessState
	(*Space)(nil),                           // 5: google.chat.v1.Space
	(*CreateSpaceRequest)(nil),              // 6: google.chat.v1.CreateSpaceRequest
	(*ListSpacesRequest)(nil),               // 7: google.chat.v1.ListSpacesRequest
	(*ListSpacesResponse)(nil),              // 8: google.chat.v1.ListSpacesResponse
	(*GetSpaceRequest)(nil),                 // 9: google.chat.v1.GetSpaceRequest
	(*FindDirectMessageRequest)(nil),        // 10: google.chat.v1.FindDirectMessageRequest
	(*UpdateSpaceRequest)(nil),              // 11: google.chat.v1.UpdateSpaceRequest
	(*SearchSpacesRequest)(nil),             // 12: google.chat.v1.SearchSpacesRequest
	(*SearchSpacesResponse)(nil),            // 13: google.chat.v1.SearchSpacesResponse
	(*DeleteSpaceRequest)(nil),              // 14: google.chat.v1.DeleteSpaceRequest
	(*CompleteImportSpaceRequest)(nil),      // 15: google.chat.v1.CompleteImportSpaceRequest
	(*CompleteImportSpaceResponse)(nil),     // 16: google.chat.v1.CompleteImportSpaceResponse
	(*Space_SpaceDetails)(nil),              // 17: google.chat.v1.Space.SpaceDetails
	(*Space_MembershipCount)(nil),           // 18: google.chat.v1.Space.MembershipCount
	(*Space_AccessSettings)(nil),            // 19: google.chat.v1.Space.AccessSettings
	(*Space_PermissionSettings)(nil),        // 20: google.chat.v1.Space.PermissionSettings
	(*Space_PermissionSetting)(nil),         // 21: google.chat.v1.Space.PermissionSetting
	(HistoryState)(0),                       // 22: google.chat.v1.HistoryState
	(*timestamppb.Timestamp)(nil),           // 23: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),           // 24: google.protobuf.FieldMask
}
var file_google_chat_v1_space_proto_depIdxs = []int32{
	0,  // 0: google.chat.v1.Space.type:type_name -> google.chat.v1.Space.Type
	1,  // 1: google.chat.v1.Space.space_type:type_name -> google.chat.v1.Space.SpaceType
	2,  // 2: google.chat.v1.Space.space_threading_state:type_name -> google.chat.v1.Space.SpaceThreadingState
	17, // 3: google.chat.v1.Space.space_details:type_name -> google.chat.v1.Space.SpaceDetails
	22, // 4: google.chat.v1.Space.space_history_state:type_name -> google.chat.v1.HistoryState
	23, // 5: google.chat.v1.Space.create_time:type_name -> google.protobuf.Timestamp
	23, // 6: google.chat.v1.Space.last_active_time:type_name -> google.protobuf.Timestamp
	18, // 7: google.chat.v1.Space.membership_count:type_name -> google.chat.v1.Space.MembershipCount
	19, // 8: google.chat.v1.Space.access_settings:type_name -> google.chat.v1.Space.AccessSettings
	3,  // 9: google.chat.v1.Space.predefined_permission_settings:type_name -> google.chat.v1.Space.PredefinedPermissionSettings
	20, // 10: google.chat.v1.Space.permission_settings:type_name -> google.chat.v1.Space.PermissionSettings
	23, // 11: google.chat.v1.Space.import_mode_expire_time:type_name -> google.protobuf.Timestamp
	5,  // 12: google.chat.v1.CreateSpaceRequest.space:type_name -> google.chat.v1.Space
	5,  // 13: google.chat.v1.ListSpacesResponse.spaces:type_name -> google.chat.v1.Space
	5,  // 14: google.chat.v1.UpdateSpaceRequest.space:type_name -> google.chat.v1.Space
	24, // 15: google.chat.v1.UpdateSpaceRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 16: google.chat.v1.SearchSpacesResponse.spaces:type_name -> google.chat.v1.Space
	5,  // 17: google.chat.v1.CompleteImportSpaceResponse.space:type_name -> google.chat.v1.Space
	4,  // 18: google.chat.v1.Space.AccessSettings.access_state:type_name -> google.chat.v1.Space.AccessSettings.AccessState
	21, // 19: google.chat.v1.Space.PermissionSettings.manage_members_and_groups:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 20: google.chat.v1.Space.PermissionSettings.modify_space_details:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 21: google.chat.v1.Space.PermissionSettings.toggle_history:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 22: google.chat.v1.Space.PermissionSettings.use_at_mention_all:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 23: google.chat.v1.Space.PermissionSettings.manage_apps:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 24: google.chat.v1.Space.PermissionSettings.manage_webhooks:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 25: google.chat.v1.Space.PermissionSettings.post_messages:type_name -> google.chat.v1.Space.PermissionSetting
	21, // 26: google.chat.v1.Space.PermissionSettings.reply_messages:type_name -> google.chat.v1.Space.PermissionSetting
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_chat_v1_space_proto_init() }
func file_google_chat_v1_space_proto_init() {
	if File_google_chat_v1_space_proto != nil {
		return
	}
	file_google_chat_v1_history_state_proto_init()
	file_google_chat_v1_space_proto_msgTypes[0].OneofWrappers = []any{
		(*Space_PredefinedPermissionSettings_)(nil),
		(*Space_PermissionSettings_)(nil),
	}
	file_google_chat_v1_space_proto_msgTypes[15].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_space_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_space_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_space_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_space_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_space_proto_msgTypes,
	}.Build()
	File_google_chat_v1_space_proto = out.File
	file_google_chat_v1_space_proto_rawDesc = nil
	file_google_chat_v1_space_proto_goTypes = nil
	file_google_chat_v1_space_proto_depIdxs = nil
}
