// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/api/cloudquotas/v1beta/resources.proto

package cloudquotaspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumerations of quota safety checks.
type QuotaSafetyCheck int32

const (
	// Unspecified quota safety check.
	QuotaSafetyCheck_QUOTA_SAFETY_CHECK_UNSPECIFIED QuotaSafetyCheck = 0
	// Validates that a quota mutation would not cause the consumer's effective
	// limit to be lower than the consumer's quota usage.
	QuotaSafetyCheck_QUOTA_DECREASE_BELOW_USAGE QuotaSafetyCheck = 1
	// Validates that a quota mutation would not cause the consumer's effective
	// limit to decrease by more than 10 percent.
	QuotaSafetyCheck_QUOTA_DECREASE_PERCENTAGE_TOO_HIGH QuotaSafetyCheck = 2
)

// Enum value maps for QuotaSafetyCheck.
var (
	QuotaSafetyCheck_name = map[int32]string{
		0: "QUOTA_SAFETY_CHECK_UNSPECIFIED",
		1: "QUOTA_DECREASE_BELOW_USAGE",
		2: "QUOTA_DECREASE_PERCENTAGE_TOO_HIGH",
	}
	QuotaSafetyCheck_value = map[string]int32{
		"QUOTA_SAFETY_CHECK_UNSPECIFIED":     0,
		"QUOTA_DECREASE_BELOW_USAGE":         1,
		"QUOTA_DECREASE_PERCENTAGE_TOO_HIGH": 2,
	}
)

func (x QuotaSafetyCheck) Enum() *QuotaSafetyCheck {
	p := new(QuotaSafetyCheck)
	*p = x
	return p
}

func (x QuotaSafetyCheck) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaSafetyCheck) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[0].Descriptor()
}

func (QuotaSafetyCheck) Type() protoreflect.EnumType {
	return &file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[0]
}

func (x QuotaSafetyCheck) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaSafetyCheck.Descriptor instead.
func (QuotaSafetyCheck) EnumDescriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{0}
}

// The enumeration of the types of a cloud resource container.
type QuotaInfo_ContainerType int32

const (
	// Unspecified container type.
	QuotaInfo_CONTAINER_TYPE_UNSPECIFIED QuotaInfo_ContainerType = 0
	// consumer project
	QuotaInfo_PROJECT QuotaInfo_ContainerType = 1
	// folder
	QuotaInfo_FOLDER QuotaInfo_ContainerType = 2
	// organization
	QuotaInfo_ORGANIZATION QuotaInfo_ContainerType = 3
)

// Enum value maps for QuotaInfo_ContainerType.
var (
	QuotaInfo_ContainerType_name = map[int32]string{
		0: "CONTAINER_TYPE_UNSPECIFIED",
		1: "PROJECT",
		2: "FOLDER",
		3: "ORGANIZATION",
	}
	QuotaInfo_ContainerType_value = map[string]int32{
		"CONTAINER_TYPE_UNSPECIFIED": 0,
		"PROJECT":                    1,
		"FOLDER":                     2,
		"ORGANIZATION":               3,
	}
)

func (x QuotaInfo_ContainerType) Enum() *QuotaInfo_ContainerType {
	p := new(QuotaInfo_ContainerType)
	*p = x
	return p
}

func (x QuotaInfo_ContainerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaInfo_ContainerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[1].Descriptor()
}

func (QuotaInfo_ContainerType) Type() protoreflect.EnumType {
	return &file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[1]
}

func (x QuotaInfo_ContainerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaInfo_ContainerType.Descriptor instead.
func (QuotaInfo_ContainerType) EnumDescriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The enumeration of reasons when it is ineligible to request increase
// adjustment.
type QuotaIncreaseEligibility_IneligibilityReason int32

const (
	// Default value when is_eligible is true.
	QuotaIncreaseEligibility_INELIGIBILITY_REASON_UNSPECIFIED QuotaIncreaseEligibility_IneligibilityReason = 0
	// The container is not linked with a valid billing account.
	QuotaIncreaseEligibility_NO_VALID_BILLING_ACCOUNT QuotaIncreaseEligibility_IneligibilityReason = 1
	// Quota increase is not supported for the quota.
	QuotaIncreaseEligibility_NOT_SUPPORTED QuotaIncreaseEligibility_IneligibilityReason = 3
	// There is not enough usage history to determine the eligibility.
	QuotaIncreaseEligibility_NOT_ENOUGH_USAGE_HISTORY QuotaIncreaseEligibility_IneligibilityReason = 4
	// Other reasons.
	QuotaIncreaseEligibility_OTHER QuotaIncreaseEligibility_IneligibilityReason = 2
)

// Enum value maps for QuotaIncreaseEligibility_IneligibilityReason.
var (
	QuotaIncreaseEligibility_IneligibilityReason_name = map[int32]string{
		0: "INELIGIBILITY_REASON_UNSPECIFIED",
		1: "NO_VALID_BILLING_ACCOUNT",
		3: "NOT_SUPPORTED",
		4: "NOT_ENOUGH_USAGE_HISTORY",
		2: "OTHER",
	}
	QuotaIncreaseEligibility_IneligibilityReason_value = map[string]int32{
		"INELIGIBILITY_REASON_UNSPECIFIED": 0,
		"NO_VALID_BILLING_ACCOUNT":         1,
		"NOT_SUPPORTED":                    3,
		"NOT_ENOUGH_USAGE_HISTORY":         4,
		"OTHER":                            2,
	}
)

func (x QuotaIncreaseEligibility_IneligibilityReason) Enum() *QuotaIncreaseEligibility_IneligibilityReason {
	p := new(QuotaIncreaseEligibility_IneligibilityReason)
	*p = x
	return p
}

func (x QuotaIncreaseEligibility_IneligibilityReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaIncreaseEligibility_IneligibilityReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[2].Descriptor()
}

func (QuotaIncreaseEligibility_IneligibilityReason) Type() protoreflect.EnumType {
	return &file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[2]
}

func (x QuotaIncreaseEligibility_IneligibilityReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaIncreaseEligibility_IneligibilityReason.Descriptor instead.
func (QuotaIncreaseEligibility_IneligibilityReason) EnumDescriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The enumeration of the origins of quota preference requests.
type QuotaConfig_Origin int32

const (
	// The unspecified value.
	QuotaConfig_ORIGIN_UNSPECIFIED QuotaConfig_Origin = 0
	// Created through Cloud Console.
	QuotaConfig_CLOUD_CONSOLE QuotaConfig_Origin = 1
	// Generated by automatic quota adjustment.
	QuotaConfig_AUTO_ADJUSTER QuotaConfig_Origin = 2
)

// Enum value maps for QuotaConfig_Origin.
var (
	QuotaConfig_Origin_name = map[int32]string{
		0: "ORIGIN_UNSPECIFIED",
		1: "CLOUD_CONSOLE",
		2: "AUTO_ADJUSTER",
	}
	QuotaConfig_Origin_value = map[string]int32{
		"ORIGIN_UNSPECIFIED": 0,
		"CLOUD_CONSOLE":      1,
		"AUTO_ADJUSTER":      2,
	}
)

func (x QuotaConfig_Origin) Enum() *QuotaConfig_Origin {
	p := new(QuotaConfig_Origin)
	*p = x
	return p
}

func (x QuotaConfig_Origin) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaConfig_Origin) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[3].Descriptor()
}

func (QuotaConfig_Origin) Type() protoreflect.EnumType {
	return &file_google_api_cloudquotas_v1beta_resources_proto_enumTypes[3]
}

func (x QuotaConfig_Origin) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaConfig_Origin.Descriptor instead.
func (QuotaConfig_Origin) EnumDescriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{3, 0}
}

// QuotaInfo represents information about a particular quota for a given
// project, folder or organization.
type QuotaInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of this QuotaInfo.
	// The ID component following "locations/" must be "global".
	// Example:
	// `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the quota, which is unquie within the service.
	// Example: `CpusPerProjectPerRegion`
	QuotaId string `protobuf:"bytes,2,opt,name=quota_id,json=quotaId,proto3" json:"quota_id,omitempty"`
	// The metric of the quota. It specifies the resources consumption the quota
	// is defined for.
	// Example: `compute.googleapis.com/cpus`
	Metric string `protobuf:"bytes,3,opt,name=metric,proto3" json:"metric,omitempty"`
	// The name of the service in which the quota is defined.
	// Example: `compute.googleapis.com`
	Service string `protobuf:"bytes,4,opt,name=service,proto3" json:"service,omitempty"`
	// Whether this is a precise quota. A precise quota is tracked with absolute
	// precision. In contrast, an imprecise quota is not tracked with precision.
	IsPrecise bool `protobuf:"varint,5,opt,name=is_precise,json=isPrecise,proto3" json:"is_precise,omitempty"`
	// The reset time interval for the quota. Refresh interval applies to rate
	// quota only.
	// Example: "minute" for per minute, "day" for per day, or "10 seconds" for
	// every 10 seconds.
	RefreshInterval string `protobuf:"bytes,6,opt,name=refresh_interval,json=refreshInterval,proto3" json:"refresh_interval,omitempty"`
	// The container type of the QuotaInfo.
	ContainerType QuotaInfo_ContainerType `protobuf:"varint,7,opt,name=container_type,json=containerType,proto3,enum=google.api.cloudquotas.v1beta.QuotaInfo_ContainerType" json:"container_type,omitempty"`
	// The dimensions the quota is defined on.
	Dimensions []string `protobuf:"bytes,8,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	// The display name of the quota metric
	MetricDisplayName string `protobuf:"bytes,9,opt,name=metric_display_name,json=metricDisplayName,proto3" json:"metric_display_name,omitempty"`
	// The display name of the quota.
	QuotaDisplayName string `protobuf:"bytes,10,opt,name=quota_display_name,json=quotaDisplayName,proto3" json:"quota_display_name,omitempty"`
	// The unit in which the metric value is reported, e.g., "MByte".
	MetricUnit string `protobuf:"bytes,11,opt,name=metric_unit,json=metricUnit,proto3" json:"metric_unit,omitempty"`
	// Whether it is eligible to request a higher quota value for this quota.
	QuotaIncreaseEligibility *QuotaIncreaseEligibility `protobuf:"bytes,12,opt,name=quota_increase_eligibility,json=quotaIncreaseEligibility,proto3" json:"quota_increase_eligibility,omitempty"`
	// Whether the quota value is fixed or adjustable
	IsFixed bool `protobuf:"varint,13,opt,name=is_fixed,json=isFixed,proto3" json:"is_fixed,omitempty"`
	// The collection of dimensions info ordered by their dimensions from more
	// specific ones to less specific ones.
	DimensionsInfos []*DimensionsInfo `protobuf:"bytes,14,rep,name=dimensions_infos,json=dimensionsInfos,proto3" json:"dimensions_infos,omitempty"`
	// Whether the quota is a concurrent quota. Concurrent quotas are enforced
	// on the total number of concurrent operations in flight at any given time.
	IsConcurrent bool `protobuf:"varint,15,opt,name=is_concurrent,json=isConcurrent,proto3" json:"is_concurrent,omitempty"`
	// URI to the page where users can request more quota for the cloud
	// service—for example,
	// https://console.cloud.google.com/iam-admin/quotas.
	ServiceRequestQuotaUri string `protobuf:"bytes,17,opt,name=service_request_quota_uri,json=serviceRequestQuotaUri,proto3" json:"service_request_quota_uri,omitempty"`
}

func (x *QuotaInfo) Reset() {
	*x = QuotaInfo{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaInfo) ProtoMessage() {}

func (x *QuotaInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaInfo.ProtoReflect.Descriptor instead.
func (*QuotaInfo) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{0}
}

func (x *QuotaInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QuotaInfo) GetQuotaId() string {
	if x != nil {
		return x.QuotaId
	}
	return ""
}

func (x *QuotaInfo) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *QuotaInfo) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *QuotaInfo) GetIsPrecise() bool {
	if x != nil {
		return x.IsPrecise
	}
	return false
}

func (x *QuotaInfo) GetRefreshInterval() string {
	if x != nil {
		return x.RefreshInterval
	}
	return ""
}

func (x *QuotaInfo) GetContainerType() QuotaInfo_ContainerType {
	if x != nil {
		return x.ContainerType
	}
	return QuotaInfo_CONTAINER_TYPE_UNSPECIFIED
}

func (x *QuotaInfo) GetDimensions() []string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *QuotaInfo) GetMetricDisplayName() string {
	if x != nil {
		return x.MetricDisplayName
	}
	return ""
}

func (x *QuotaInfo) GetQuotaDisplayName() string {
	if x != nil {
		return x.QuotaDisplayName
	}
	return ""
}

func (x *QuotaInfo) GetMetricUnit() string {
	if x != nil {
		return x.MetricUnit
	}
	return ""
}

func (x *QuotaInfo) GetQuotaIncreaseEligibility() *QuotaIncreaseEligibility {
	if x != nil {
		return x.QuotaIncreaseEligibility
	}
	return nil
}

func (x *QuotaInfo) GetIsFixed() bool {
	if x != nil {
		return x.IsFixed
	}
	return false
}

func (x *QuotaInfo) GetDimensionsInfos() []*DimensionsInfo {
	if x != nil {
		return x.DimensionsInfos
	}
	return nil
}

func (x *QuotaInfo) GetIsConcurrent() bool {
	if x != nil {
		return x.IsConcurrent
	}
	return false
}

func (x *QuotaInfo) GetServiceRequestQuotaUri() string {
	if x != nil {
		return x.ServiceRequestQuotaUri
	}
	return ""
}

// Eligibility information regarding requesting increase adjustment of a quota.
type QuotaIncreaseEligibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether a higher quota value can be requested for the quota.
	IsEligible bool `protobuf:"varint,1,opt,name=is_eligible,json=isEligible,proto3" json:"is_eligible,omitempty"`
	// The reason of why it is ineligible to request increased value of the quota.
	// If the is_eligible field is true, it defaults to
	// INELIGIBILITY_REASON_UNSPECIFIED.
	IneligibilityReason QuotaIncreaseEligibility_IneligibilityReason `protobuf:"varint,2,opt,name=ineligibility_reason,json=ineligibilityReason,proto3,enum=google.api.cloudquotas.v1beta.QuotaIncreaseEligibility_IneligibilityReason" json:"ineligibility_reason,omitempty"`
}

func (x *QuotaIncreaseEligibility) Reset() {
	*x = QuotaIncreaseEligibility{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaIncreaseEligibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaIncreaseEligibility) ProtoMessage() {}

func (x *QuotaIncreaseEligibility) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaIncreaseEligibility.ProtoReflect.Descriptor instead.
func (*QuotaIncreaseEligibility) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{1}
}

func (x *QuotaIncreaseEligibility) GetIsEligible() bool {
	if x != nil {
		return x.IsEligible
	}
	return false
}

func (x *QuotaIncreaseEligibility) GetIneligibilityReason() QuotaIncreaseEligibility_IneligibilityReason {
	if x != nil {
		return x.IneligibilityReason
	}
	return QuotaIncreaseEligibility_INELIGIBILITY_REASON_UNSPECIFIED
}

// QuotaPreference represents the preferred quota configuration specified for
// a project, folder or organization. There is only one QuotaPreference
// resource for a quota value targeting a unique set of dimensions.
type QuotaPreference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required except in the CREATE requests.
	// The resource name of the quota preference.
	// The ID component following "locations/" must be "global".
	// Example:
	// `projects/123/locations/global/quotaPreferences/my-config-for-us-east1`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The dimensions that this quota preference applies to. The key of
	// the map entry is the name of a dimension, such as "region", "zone",
	// "network_id", and the value of the map entry is the dimension value.
	//
	// If a dimension is missing from the map of dimensions, the quota preference
	// applies to all the dimension values except for those that have other quota
	// preferences configured for the specific value.
	//
	// NOTE: QuotaPreferences can only be applied across all values of "user" and
	// "resource" dimension. Do not set values for "user" or "resource" in the
	// dimension map.
	//
	// Example: {"provider", "Foo Inc"} where "provider" is a service specific
	// dimension.
	Dimensions map[string]string `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Preferred quota configuration.
	QuotaConfig *QuotaConfig `protobuf:"bytes,3,opt,name=quota_config,json=quotaConfig,proto3" json:"quota_config,omitempty"`
	// Optional. The current etag of the quota preference. If an etag is provided
	// on update and does not match the current server's etag of the quota
	// preference, the request will be blocked and an ABORTED error will be
	// returned. See https://google.aip.dev/134#etags for more details on etags.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Create time stamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The name of the service to which the quota preference is applied.
	Service string `protobuf:"bytes,7,opt,name=service,proto3" json:"service,omitempty"`
	// Required. The id of the quota to which the quota preference is applied. A
	// quota name is unique in the service. Example: `CpusPerProjectPerRegion`
	QuotaId string `protobuf:"bytes,8,opt,name=quota_id,json=quotaId,proto3" json:"quota_id,omitempty"`
	// Output only. Is the quota preference pending Google Cloud approval and
	// fulfillment.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// The reason / justification for this quota preference.
	Justification string `protobuf:"bytes,11,opt,name=justification,proto3" json:"justification,omitempty"`
	// Input only. An email address that can be used to contact the the user, in
	// case Google Cloud needs more information to make a decision before
	// additional quota can be granted.
	//
	// When requesting a quota increase, the email address is required.
	// When requesting a quota decrease, the email address is optional.
	// For example, the email address is optional when the
	// `QuotaConfig.preferred_value` is smaller than the
	// `QuotaDetails.reset_value`.
	ContactEmail string `protobuf:"bytes,12,opt,name=contact_email,json=contactEmail,proto3" json:"contact_email,omitempty"`
}

func (x *QuotaPreference) Reset() {
	*x = QuotaPreference{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaPreference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaPreference) ProtoMessage() {}

func (x *QuotaPreference) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaPreference.ProtoReflect.Descriptor instead.
func (*QuotaPreference) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{2}
}

func (x *QuotaPreference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QuotaPreference) GetDimensions() map[string]string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *QuotaPreference) GetQuotaConfig() *QuotaConfig {
	if x != nil {
		return x.QuotaConfig
	}
	return nil
}

func (x *QuotaPreference) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *QuotaPreference) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *QuotaPreference) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *QuotaPreference) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *QuotaPreference) GetQuotaId() string {
	if x != nil {
		return x.QuotaId
	}
	return ""
}

func (x *QuotaPreference) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *QuotaPreference) GetJustification() string {
	if x != nil {
		return x.Justification
	}
	return ""
}

func (x *QuotaPreference) GetContactEmail() string {
	if x != nil {
		return x.ContactEmail
	}
	return ""
}

// The preferred quota configuration.
type QuotaConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The preferred value. Must be greater than or equal to -1. If set
	// to -1, it means the value is "unlimited".
	PreferredValue int64 `protobuf:"varint,1,opt,name=preferred_value,json=preferredValue,proto3" json:"preferred_value,omitempty"`
	// Output only. Optional details about the state of this quota preference.
	StateDetail string `protobuf:"bytes,2,opt,name=state_detail,json=stateDetail,proto3" json:"state_detail,omitempty"`
	// Output only. Granted quota value.
	GrantedValue *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=granted_value,json=grantedValue,proto3" json:"granted_value,omitempty"`
	// Output only. The trace id that the Google Cloud uses to provision the
	// requested quota. This trace id may be used by the client to contact Cloud
	// support to track the state of a quota preference request. The trace id is
	// only produced for increase requests and is unique for each request. The
	// quota decrease requests do not have a trace id.
	TraceId string `protobuf:"bytes,4,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Optional. The annotations map for clients to store small amounts of
	// arbitrary data. Do not put PII or other sensitive information here. See
	// https://google.aip.dev/128#annotations
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The origin of the quota preference request.
	RequestOrigin QuotaConfig_Origin `protobuf:"varint,6,opt,name=request_origin,json=requestOrigin,proto3,enum=google.api.cloudquotas.v1beta.QuotaConfig_Origin" json:"request_origin,omitempty"`
}

func (x *QuotaConfig) Reset() {
	*x = QuotaConfig{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaConfig) ProtoMessage() {}

func (x *QuotaConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaConfig.ProtoReflect.Descriptor instead.
func (*QuotaConfig) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{3}
}

func (x *QuotaConfig) GetPreferredValue() int64 {
	if x != nil {
		return x.PreferredValue
	}
	return 0
}

func (x *QuotaConfig) GetStateDetail() string {
	if x != nil {
		return x.StateDetail
	}
	return ""
}

func (x *QuotaConfig) GetGrantedValue() *wrapperspb.Int64Value {
	if x != nil {
		return x.GrantedValue
	}
	return nil
}

func (x *QuotaConfig) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

func (x *QuotaConfig) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *QuotaConfig) GetRequestOrigin() QuotaConfig_Origin {
	if x != nil {
		return x.RequestOrigin
	}
	return QuotaConfig_ORIGIN_UNSPECIFIED
}

// The detailed quota information such as effective quota value for a
// combination of dimensions.
type DimensionsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The map of dimensions for this dimensions info. The key of a map entry
	// is "region", "zone" or the name of a service specific dimension, and the
	// value of a map entry is the value of the dimension.  If a dimension does
	// not appear in the map of dimensions, the dimensions info applies to all
	// the dimension values except for those that have another DimenisonInfo
	// instance configured for the specific value.
	// Example: {"provider" : "Foo Inc"} where "provider" is a service specific
	// dimension of a quota.
	Dimensions map[string]string `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Quota details for the specified dimensions.
	Details *QuotaDetails `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
	// The applicable regions or zones of this dimensions info. The field will be
	// set to ['global'] for quotas that are not per region or per zone.
	// Otherwise, it will be set to the list of locations this dimension info is
	// applicable to.
	ApplicableLocations []string `protobuf:"bytes,3,rep,name=applicable_locations,json=applicableLocations,proto3" json:"applicable_locations,omitempty"`
}

func (x *DimensionsInfo) Reset() {
	*x = DimensionsInfo{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DimensionsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DimensionsInfo) ProtoMessage() {}

func (x *DimensionsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DimensionsInfo.ProtoReflect.Descriptor instead.
func (*DimensionsInfo) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{4}
}

func (x *DimensionsInfo) GetDimensions() map[string]string {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *DimensionsInfo) GetDetails() *QuotaDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *DimensionsInfo) GetApplicableLocations() []string {
	if x != nil {
		return x.ApplicableLocations
	}
	return nil
}

// The quota details for a map of dimensions.
type QuotaDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value currently in effect and being enforced.
	Value int64 `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	// Rollout information of this quota.
	// This field is present only if the effective limit will change due to the
	// ongoing rollout of the service config.
	RolloutInfo *RolloutInfo `protobuf:"bytes,3,opt,name=rollout_info,json=rolloutInfo,proto3" json:"rollout_info,omitempty"`
}

func (x *QuotaDetails) Reset() {
	*x = QuotaDetails{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuotaDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotaDetails) ProtoMessage() {}

func (x *QuotaDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotaDetails.ProtoReflect.Descriptor instead.
func (*QuotaDetails) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{5}
}

func (x *QuotaDetails) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *QuotaDetails) GetRolloutInfo() *RolloutInfo {
	if x != nil {
		return x.RolloutInfo
	}
	return nil
}

// [Output only] Rollout information of a quota.
type RolloutInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether there is an ongoing rollout for a quota or not.
	OngoingRollout bool `protobuf:"varint,1,opt,name=ongoing_rollout,json=ongoingRollout,proto3" json:"ongoing_rollout,omitempty"`
}

func (x *RolloutInfo) Reset() {
	*x = RolloutInfo{}
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RolloutInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RolloutInfo) ProtoMessage() {}

func (x *RolloutInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_cloudquotas_v1beta_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RolloutInfo.ProtoReflect.Descriptor instead.
func (*RolloutInfo) Descriptor() ([]byte, []int) {
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP(), []int{6}
}

func (x *RolloutInfo) GetOngoingRollout() bool {
	if x != nil {
		return x.OngoingRollout
	}
	return false
}

var File_google_api_cloudquotas_v1beta_resources_proto protoreflect.FileDescriptor

var file_google_api_cloudquotas_v1beta_resources_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61,
	0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x09, 0x0a, 0x09,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a,
	0x08, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x12, 0x18, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73,
	0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x69, 0x73, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x66,
	0x72, 0x65, 0x73, 0x68, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x12, 0x5d, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x75, 0x6e, 0x69, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x55, 0x6e,
	0x69, 0x74, 0x12, 0x75, 0x0a, 0x1a, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x63, 0x72,
	0x65, 0x61, 0x73, 0x65, 0x5f, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x63, 0x72,
	0x65, 0x61, 0x73, 0x65, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52,
	0x18, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x45, 0x6c,
	0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f,
	0x66, 0x69, 0x78, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x46,
	0x69, 0x78, 0x65, 0x64, 0x12, 0x58, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x55, 0x72, 0x69, 0x22, 0x5a,
	0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x52, 0x47, 0x41,
	0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x3a, 0xae, 0x02, 0xea, 0x41, 0xaa,
	0x02, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x2f, 0x7b,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x7d, 0x12, 0x50, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73,
	0x2f, 0x7b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x7d, 0x12, 0x5c, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x73, 0x2f, 0x7b,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x7d, 0x22, 0xd3, 0x02, 0x0a, 0x18,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x45, 0x6c, 0x69,
	0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x65,
	0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69,
	0x73, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x7e, 0x0a, 0x14, 0x69, 0x6e, 0x65,
	0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x6e, 0x63,
	0x72, 0x65, 0x61, 0x73, 0x65, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x2e, 0x49, 0x6e, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x52, 0x13, 0x69, 0x6e, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x95, 0x01, 0x0a, 0x13, 0x49, 0x6e,
	0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x24, 0x0a, 0x20, 0x49, 0x4e, 0x45, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x59, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x4e, 0x4f, 0x5f, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x5f, 0x42, 0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x43, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1c, 0x0a, 0x18, 0x4e, 0x4f, 0x54, 0x5f,
	0x45, 0x4e, 0x4f, 0x55, 0x47, 0x48, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x48, 0x49, 0x53,
	0x54, 0x4f, 0x52, 0x59, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10,
	0x02, 0x22, 0x92, 0x07, 0x0a, 0x0f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0a, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52,
	0x0a, 0x0c, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1e,
	0x0a, 0x08, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x49, 0x64, 0x12, 0x25,
	0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x24, 0x0a, 0x0d, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6a, 0x75,
	0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x45, 0x6d, 0x61, 0x69, 0x6c, 0x1a, 0x3d, 0x0a, 0x0f, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x9f, 0x02, 0xea, 0x41, 0x9b, 0x02, 0x0a, 0x2a, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x7d, 0x12, 0x49, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x7d, 0x12,
	0x55, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x7d, 0x22, 0x95, 0x04, 0x0a, 0x0b, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x72, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x45, 0x0a, 0x0d,
	0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x62, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x46, 0x0a, 0x06, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x12, 0x16, 0x0a, 0x12, 0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4c, 0x4f, 0x55,
	0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x4f, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x41,
	0x55, 0x54, 0x4f, 0x5f, 0x41, 0x44, 0x4a, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10, 0x02, 0x22, 0xa8,
	0x02, 0x0a, 0x0e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x5d, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x45, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x73, 0x0a, 0x0c, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x4d, 0x0a, 0x0c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0b, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x36,
	0x0a, 0x0b, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a,
	0x0f, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2a, 0x7e, 0x0a, 0x10, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x22, 0x0a, 0x1e, 0x51, 0x55,
	0x4f, 0x54, 0x41, 0x5f, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e,
	0x0a, 0x1a, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x45, 0x41, 0x53, 0x45,
	0x5f, 0x42, 0x45, 0x4c, 0x4f, 0x57, 0x5f, 0x55, 0x53, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x26,
	0x0a, 0x22, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x44, 0x45, 0x43, 0x52, 0x45, 0x41, 0x53, 0x45,
	0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x4f, 0x4f, 0x5f,
	0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x42, 0xe5, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71,
	0x75, 0x6f, 0x74, 0x61, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x71, 0x75, 0x6f,
	0x74, 0x61, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x51, 0x75, 0x6f, 0x74,
	0x61, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_cloudquotas_v1beta_resources_proto_rawDescOnce sync.Once
	file_google_api_cloudquotas_v1beta_resources_proto_rawDescData = file_google_api_cloudquotas_v1beta_resources_proto_rawDesc
)

func file_google_api_cloudquotas_v1beta_resources_proto_rawDescGZIP() []byte {
	file_google_api_cloudquotas_v1beta_resources_proto_rawDescOnce.Do(func() {
		file_google_api_cloudquotas_v1beta_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_cloudquotas_v1beta_resources_proto_rawDescData)
	})
	return file_google_api_cloudquotas_v1beta_resources_proto_rawDescData
}

var file_google_api_cloudquotas_v1beta_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_api_cloudquotas_v1beta_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_api_cloudquotas_v1beta_resources_proto_goTypes = []any{
	(QuotaSafetyCheck)(0),                             // 0: google.api.cloudquotas.v1beta.QuotaSafetyCheck
	(QuotaInfo_ContainerType)(0),                      // 1: google.api.cloudquotas.v1beta.QuotaInfo.ContainerType
	(QuotaIncreaseEligibility_IneligibilityReason)(0), // 2: google.api.cloudquotas.v1beta.QuotaIncreaseEligibility.IneligibilityReason
	(QuotaConfig_Origin)(0),                           // 3: google.api.cloudquotas.v1beta.QuotaConfig.Origin
	(*QuotaInfo)(nil),                                 // 4: google.api.cloudquotas.v1beta.QuotaInfo
	(*QuotaIncreaseEligibility)(nil),                  // 5: google.api.cloudquotas.v1beta.QuotaIncreaseEligibility
	(*QuotaPreference)(nil),                           // 6: google.api.cloudquotas.v1beta.QuotaPreference
	(*QuotaConfig)(nil),                               // 7: google.api.cloudquotas.v1beta.QuotaConfig
	(*DimensionsInfo)(nil),                            // 8: google.api.cloudquotas.v1beta.DimensionsInfo
	(*QuotaDetails)(nil),                              // 9: google.api.cloudquotas.v1beta.QuotaDetails
	(*RolloutInfo)(nil),                               // 10: google.api.cloudquotas.v1beta.RolloutInfo
	nil,                                               // 11: google.api.cloudquotas.v1beta.QuotaPreference.DimensionsEntry
	nil,                                               // 12: google.api.cloudquotas.v1beta.QuotaConfig.AnnotationsEntry
	nil,                                               // 13: google.api.cloudquotas.v1beta.DimensionsInfo.DimensionsEntry
	(*timestamppb.Timestamp)(nil),                     // 14: google.protobuf.Timestamp
	(*wrapperspb.Int64Value)(nil),                     // 15: google.protobuf.Int64Value
}
var file_google_api_cloudquotas_v1beta_resources_proto_depIdxs = []int32{
	1,  // 0: google.api.cloudquotas.v1beta.QuotaInfo.container_type:type_name -> google.api.cloudquotas.v1beta.QuotaInfo.ContainerType
	5,  // 1: google.api.cloudquotas.v1beta.QuotaInfo.quota_increase_eligibility:type_name -> google.api.cloudquotas.v1beta.QuotaIncreaseEligibility
	8,  // 2: google.api.cloudquotas.v1beta.QuotaInfo.dimensions_infos:type_name -> google.api.cloudquotas.v1beta.DimensionsInfo
	2,  // 3: google.api.cloudquotas.v1beta.QuotaIncreaseEligibility.ineligibility_reason:type_name -> google.api.cloudquotas.v1beta.QuotaIncreaseEligibility.IneligibilityReason
	11, // 4: google.api.cloudquotas.v1beta.QuotaPreference.dimensions:type_name -> google.api.cloudquotas.v1beta.QuotaPreference.DimensionsEntry
	7,  // 5: google.api.cloudquotas.v1beta.QuotaPreference.quota_config:type_name -> google.api.cloudquotas.v1beta.QuotaConfig
	14, // 6: google.api.cloudquotas.v1beta.QuotaPreference.create_time:type_name -> google.protobuf.Timestamp
	14, // 7: google.api.cloudquotas.v1beta.QuotaPreference.update_time:type_name -> google.protobuf.Timestamp
	15, // 8: google.api.cloudquotas.v1beta.QuotaConfig.granted_value:type_name -> google.protobuf.Int64Value
	12, // 9: google.api.cloudquotas.v1beta.QuotaConfig.annotations:type_name -> google.api.cloudquotas.v1beta.QuotaConfig.AnnotationsEntry
	3,  // 10: google.api.cloudquotas.v1beta.QuotaConfig.request_origin:type_name -> google.api.cloudquotas.v1beta.QuotaConfig.Origin
	13, // 11: google.api.cloudquotas.v1beta.DimensionsInfo.dimensions:type_name -> google.api.cloudquotas.v1beta.DimensionsInfo.DimensionsEntry
	9,  // 12: google.api.cloudquotas.v1beta.DimensionsInfo.details:type_name -> google.api.cloudquotas.v1beta.QuotaDetails
	10, // 13: google.api.cloudquotas.v1beta.QuotaDetails.rollout_info:type_name -> google.api.cloudquotas.v1beta.RolloutInfo
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_api_cloudquotas_v1beta_resources_proto_init() }
func file_google_api_cloudquotas_v1beta_resources_proto_init() {
	if File_google_api_cloudquotas_v1beta_resources_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_cloudquotas_v1beta_resources_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_api_cloudquotas_v1beta_resources_proto_goTypes,
		DependencyIndexes: file_google_api_cloudquotas_v1beta_resources_proto_depIdxs,
		EnumInfos:         file_google_api_cloudquotas_v1beta_resources_proto_enumTypes,
		MessageInfos:      file_google_api_cloudquotas_v1beta_resources_proto_msgTypes,
	}.Build()
	File_google_api_cloudquotas_v1beta_resources_proto = out.File
	file_google_api_cloudquotas_v1beta_resources_proto_rawDesc = nil
	file_google_api_cloudquotas_v1beta_resources_proto_goTypes = nil
	file_google_api_cloudquotas_v1beta_resources_proto_depIdxs = nil
}
