// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1/common.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The industry vertical associated with the
// [DataStore][google.cloud.discoveryengine.v1.DataStore].
type IndustryVertical int32

const (
	// Value used when unset.
	IndustryVertical_INDUSTRY_VERTICAL_UNSPECIFIED IndustryVertical = 0
	// The generic vertical for documents that are not specific to any industry
	// vertical.
	IndustryVertical_GENERIC IndustryVertical = 1
	// The media industry vertical.
	IndustryVertical_MEDIA IndustryVertical = 2
	// The healthcare FHIR vertical.
	IndustryVertical_HEALTHCARE_FHIR IndustryVertical = 7
)

// Enum value maps for IndustryVertical.
var (
	IndustryVertical_name = map[int32]string{
		0: "INDUSTRY_VERTICAL_UNSPECIFIED",
		1: "GENERIC",
		2: "MEDIA",
		7: "HEALTHCARE_FHIR",
	}
	IndustryVertical_value = map[string]int32{
		"INDUSTRY_VERTICAL_UNSPECIFIED": 0,
		"GENERIC":                       1,
		"MEDIA":                         2,
		"HEALTHCARE_FHIR":               7,
	}
)

func (x IndustryVertical) Enum() *IndustryVertical {
	p := new(IndustryVertical)
	*p = x
	return p
}

func (x IndustryVertical) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndustryVertical) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_common_proto_enumTypes[0].Descriptor()
}

func (IndustryVertical) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_common_proto_enumTypes[0]
}

func (x IndustryVertical) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndustryVertical.Descriptor instead.
func (IndustryVertical) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{0}
}

// The type of solution.
type SolutionType int32

const (
	// Default value.
	SolutionType_SOLUTION_TYPE_UNSPECIFIED SolutionType = 0
	// Used for Recommendations AI.
	SolutionType_SOLUTION_TYPE_RECOMMENDATION SolutionType = 1
	// Used for Discovery Search.
	SolutionType_SOLUTION_TYPE_SEARCH SolutionType = 2
	// Used for use cases related to the Generative AI agent.
	SolutionType_SOLUTION_TYPE_CHAT SolutionType = 3
	// Used for use cases related to the Generative Chat agent.
	// It's used for Generative chat engine only, the associated data stores
	// must enrolled with `SOLUTION_TYPE_CHAT` solution.
	SolutionType_SOLUTION_TYPE_GENERATIVE_CHAT SolutionType = 4
)

// Enum value maps for SolutionType.
var (
	SolutionType_name = map[int32]string{
		0: "SOLUTION_TYPE_UNSPECIFIED",
		1: "SOLUTION_TYPE_RECOMMENDATION",
		2: "SOLUTION_TYPE_SEARCH",
		3: "SOLUTION_TYPE_CHAT",
		4: "SOLUTION_TYPE_GENERATIVE_CHAT",
	}
	SolutionType_value = map[string]int32{
		"SOLUTION_TYPE_UNSPECIFIED":     0,
		"SOLUTION_TYPE_RECOMMENDATION":  1,
		"SOLUTION_TYPE_SEARCH":          2,
		"SOLUTION_TYPE_CHAT":            3,
		"SOLUTION_TYPE_GENERATIVE_CHAT": 4,
	}
)

func (x SolutionType) Enum() *SolutionType {
	p := new(SolutionType)
	*p = x
	return p
}

func (x SolutionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SolutionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_common_proto_enumTypes[1].Descriptor()
}

func (SolutionType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_common_proto_enumTypes[1]
}

func (x SolutionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SolutionType.Descriptor instead.
func (SolutionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{1}
}

// Defines a further subdivision of `SolutionType`.
// Specifically applies to
// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
type SearchUseCase int32

const (
	// Value used when unset. Will not occur in CSS.
	SearchUseCase_SEARCH_USE_CASE_UNSPECIFIED SearchUseCase = 0
	// Search use case. Expects the traffic has a non-empty
	// [query][google.cloud.discoveryengine.v1.SearchRequest.query].
	SearchUseCase_SEARCH_USE_CASE_SEARCH SearchUseCase = 1
	// Browse use case. Expects the traffic has an empty
	// [query][google.cloud.discoveryengine.v1.SearchRequest.query].
	SearchUseCase_SEARCH_USE_CASE_BROWSE SearchUseCase = 2
)

// Enum value maps for SearchUseCase.
var (
	SearchUseCase_name = map[int32]string{
		0: "SEARCH_USE_CASE_UNSPECIFIED",
		1: "SEARCH_USE_CASE_SEARCH",
		2: "SEARCH_USE_CASE_BROWSE",
	}
	SearchUseCase_value = map[string]int32{
		"SEARCH_USE_CASE_UNSPECIFIED": 0,
		"SEARCH_USE_CASE_SEARCH":      1,
		"SEARCH_USE_CASE_BROWSE":      2,
	}
)

func (x SearchUseCase) Enum() *SearchUseCase {
	p := new(SearchUseCase)
	*p = x
	return p
}

func (x SearchUseCase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchUseCase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_common_proto_enumTypes[2].Descriptor()
}

func (SearchUseCase) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_common_proto_enumTypes[2]
}

func (x SearchUseCase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchUseCase.Descriptor instead.
func (SearchUseCase) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{2}
}

// Tiers of search features. Different tiers might have different
// pricing. To learn more, check the pricing documentation.
type SearchTier int32

const (
	// Default value when the enum is unspecified. This is invalid to use.
	SearchTier_SEARCH_TIER_UNSPECIFIED SearchTier = 0
	// Standard tier.
	SearchTier_SEARCH_TIER_STANDARD SearchTier = 1
	// Enterprise tier.
	SearchTier_SEARCH_TIER_ENTERPRISE SearchTier = 2
)

// Enum value maps for SearchTier.
var (
	SearchTier_name = map[int32]string{
		0: "SEARCH_TIER_UNSPECIFIED",
		1: "SEARCH_TIER_STANDARD",
		2: "SEARCH_TIER_ENTERPRISE",
	}
	SearchTier_value = map[string]int32{
		"SEARCH_TIER_UNSPECIFIED": 0,
		"SEARCH_TIER_STANDARD":    1,
		"SEARCH_TIER_ENTERPRISE":  2,
	}
)

func (x SearchTier) Enum() *SearchTier {
	p := new(SearchTier)
	*p = x
	return p
}

func (x SearchTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_common_proto_enumTypes[3].Descriptor()
}

func (SearchTier) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_common_proto_enumTypes[3]
}

func (x SearchTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchTier.Descriptor instead.
func (SearchTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{3}
}

// Add-on that provides additional functionality for search.
type SearchAddOn int32

const (
	// Default value when the enum is unspecified. This is invalid to use.
	SearchAddOn_SEARCH_ADD_ON_UNSPECIFIED SearchAddOn = 0
	// Large language model add-on.
	SearchAddOn_SEARCH_ADD_ON_LLM SearchAddOn = 1
)

// Enum value maps for SearchAddOn.
var (
	SearchAddOn_name = map[int32]string{
		0: "SEARCH_ADD_ON_UNSPECIFIED",
		1: "SEARCH_ADD_ON_LLM",
	}
	SearchAddOn_value = map[string]int32{
		"SEARCH_ADD_ON_UNSPECIFIED": 0,
		"SEARCH_ADD_ON_LLM":         1,
	}
)

func (x SearchAddOn) Enum() *SearchAddOn {
	p := new(SearchAddOn)
	*p = x
	return p
}

func (x SearchAddOn) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchAddOn) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1_common_proto_enumTypes[4].Descriptor()
}

func (SearchAddOn) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1_common_proto_enumTypes[4]
}

func (x SearchAddOn) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchAddOn.Descriptor instead.
func (SearchAddOn) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{4}
}

// A floating point interval.
type Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The lower bound of the interval. If neither of the min fields are
	// set, then the lower bound is negative infinity.
	//
	// This field must be not larger than max.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// Types that are assignable to Min:
	//
	//	*Interval_Minimum
	//	*Interval_ExclusiveMinimum
	Min isInterval_Min `protobuf_oneof:"min"`
	// The upper bound of the interval. If neither of the max fields are
	// set, then the upper bound is positive infinity.
	//
	// This field must be not smaller than min.
	// Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// Types that are assignable to Max:
	//
	//	*Interval_Maximum
	//	*Interval_ExclusiveMaximum
	Max isInterval_Max `protobuf_oneof:"max"`
}

func (x *Interval) Reset() {
	*x = Interval{}
	mi := &file_google_cloud_discoveryengine_v1_common_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interval) ProtoMessage() {}

func (x *Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_common_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interval.ProtoReflect.Descriptor instead.
func (*Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{0}
}

func (m *Interval) GetMin() isInterval_Min {
	if m != nil {
		return m.Min
	}
	return nil
}

func (x *Interval) GetMinimum() float64 {
	if x, ok := x.GetMin().(*Interval_Minimum); ok {
		return x.Minimum
	}
	return 0
}

func (x *Interval) GetExclusiveMinimum() float64 {
	if x, ok := x.GetMin().(*Interval_ExclusiveMinimum); ok {
		return x.ExclusiveMinimum
	}
	return 0
}

func (m *Interval) GetMax() isInterval_Max {
	if m != nil {
		return m.Max
	}
	return nil
}

func (x *Interval) GetMaximum() float64 {
	if x, ok := x.GetMax().(*Interval_Maximum); ok {
		return x.Maximum
	}
	return 0
}

func (x *Interval) GetExclusiveMaximum() float64 {
	if x, ok := x.GetMax().(*Interval_ExclusiveMaximum); ok {
		return x.ExclusiveMaximum
	}
	return 0
}

type isInterval_Min interface {
	isInterval_Min()
}

type Interval_Minimum struct {
	// Inclusive lower bound.
	Minimum float64 `protobuf:"fixed64,1,opt,name=minimum,proto3,oneof"`
}

type Interval_ExclusiveMinimum struct {
	// Exclusive lower bound.
	ExclusiveMinimum float64 `protobuf:"fixed64,2,opt,name=exclusive_minimum,json=exclusiveMinimum,proto3,oneof"`
}

func (*Interval_Minimum) isInterval_Min() {}

func (*Interval_ExclusiveMinimum) isInterval_Min() {}

type isInterval_Max interface {
	isInterval_Max()
}

type Interval_Maximum struct {
	// Inclusive upper bound.
	Maximum float64 `protobuf:"fixed64,3,opt,name=maximum,proto3,oneof"`
}

type Interval_ExclusiveMaximum struct {
	// Exclusive upper bound.
	ExclusiveMaximum float64 `protobuf:"fixed64,4,opt,name=exclusive_maximum,json=exclusiveMaximum,proto3,oneof"`
}

func (*Interval_Maximum) isInterval_Max() {}

func (*Interval_ExclusiveMaximum) isInterval_Max() {}

// A custom attribute that is not explicitly modeled in a resource, e.g.
// [UserEvent][google.cloud.discoveryengine.v1.UserEvent].
type CustomAttribute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The textual values of this custom attribute. For example, `["yellow",
	// "green"]` when the key is "color".
	//
	// Empty string is not allowed. Otherwise, an `INVALID_ARGUMENT` error is
	// returned.
	//
	// Exactly one of
	// [CustomAttribute.text][google.cloud.discoveryengine.v1.CustomAttribute.text]
	// or
	// [CustomAttribute.numbers][google.cloud.discoveryengine.v1.CustomAttribute.numbers]
	// should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Text []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
	// The numerical values of this custom attribute. For example, `[2.3, 15.4]`
	// when the key is "lengths_cm".
	//
	// Exactly one of
	// [CustomAttribute.text][google.cloud.discoveryengine.v1.CustomAttribute.text]
	// or
	// [CustomAttribute.numbers][google.cloud.discoveryengine.v1.CustomAttribute.numbers]
	// should be set. Otherwise, an `INVALID_ARGUMENT` error is returned.
	Numbers []float64 `protobuf:"fixed64,2,rep,packed,name=numbers,proto3" json:"numbers,omitempty"`
}

func (x *CustomAttribute) Reset() {
	*x = CustomAttribute{}
	mi := &file_google_cloud_discoveryengine_v1_common_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomAttribute) ProtoMessage() {}

func (x *CustomAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_common_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomAttribute.ProtoReflect.Descriptor instead.
func (*CustomAttribute) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *CustomAttribute) GetText() []string {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *CustomAttribute) GetNumbers() []float64 {
	if x != nil {
		return x.Numbers
	}
	return nil
}

// Information of an end user.
type UserInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Highly recommended for logged-in users. Unique identifier for logged-in
	// user, such as a user name. Don't set for anonymous users.
	//
	// Always use a hashed value for this ID.
	//
	// Don't set the field to the same fixed ID for different users. This mixes
	// the event history of those users together, which results in degraded
	// model quality.
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// User agent as included in the HTTP header.
	//
	// The field must be a UTF-8 encoded string with a length limit of 1,000
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	//
	// This should not be set when using the client side event reporting with
	// GTM or JavaScript tag in
	// [UserEventService.CollectUserEvent][google.cloud.discoveryengine.v1.UserEventService.CollectUserEvent]
	// or if
	// [UserEvent.direct_user_request][google.cloud.discoveryengine.v1.UserEvent.direct_user_request]
	// is set.
	UserAgent string `protobuf:"bytes,2,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
}

func (x *UserInfo) Reset() {
	*x = UserInfo{}
	mi := &file_google_cloud_discoveryengine_v1_common_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserInfo) ProtoMessage() {}

func (x *UserInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1_common_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserInfo.ProtoReflect.Descriptor instead.
func (*UserInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *UserInfo) GetUserId() string {
	if x != nil {
		return x.UserId
	}
	return ""
}

func (x *UserInfo) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

var File_google_cloud_discoveryengine_v1_common_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1_common_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xae, 0x01, 0x0a, 0x08, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x1a, 0x0a, 0x07, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x12, 0x2d, 0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65,
	0x5f, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00,
	0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x69, 0x6e, 0x69, 0x6d,
	0x75, 0x6d, 0x12, 0x1a, 0x0a, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x12, 0x2d,
	0x0a, 0x11, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x10, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x42, 0x05, 0x0a,
	0x03, 0x6d, 0x69, 0x6e, 0x42, 0x05, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x22, 0x3f, 0x0a, 0x0f, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x01, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x42, 0x0a, 0x08,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x2a, 0x62, 0x0a, 0x10, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x56, 0x65, 0x72, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x44, 0x55, 0x53, 0x54, 0x52, 0x59,
	0x5f, 0x56, 0x45, 0x52, 0x54, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x45, 0x4e, 0x45, 0x52,
	0x49, 0x43, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x41, 0x52, 0x45, 0x5f, 0x46, 0x48,
	0x49, 0x52, 0x10, 0x07, 0x2a, 0xa4, 0x01, 0x0a, 0x0c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x45, 0x4e, 0x44, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x02,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x43, 0x48, 0x41, 0x54, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x4f, 0x4c, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x54, 0x10, 0x04, 0x2a, 0x68, 0x0a, 0x0d, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x55, 0x73, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x1b,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a,
	0x16, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x41, 0x53, 0x45,
	0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x45, 0x41,
	0x52, 0x43, 0x48, 0x5f, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x42, 0x52, 0x4f,
	0x57, 0x53, 0x45, 0x10, 0x02, 0x2a, 0x5f, 0x0a, 0x0a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54,
	0x69, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x54, 0x49,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f,
	0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x45,
	0x41, 0x52, 0x43, 0x48, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x50,
	0x52, 0x49, 0x53, 0x45, 0x10, 0x02, 0x2a, 0x43, 0x0a, 0x0b, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x64, 0x64, 0x4f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f,
	0x41, 0x44, 0x44, 0x5f, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f, 0x41,
	0x44, 0x44, 0x5f, 0x4f, 0x4e, 0x5f, 0x4c, 0x4c, 0x4d, 0x10, 0x01, 0x42, 0xcb, 0x0c, 0xea, 0x41,
	0xe6, 0x01, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63,
	0x68, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x7d, 0x12, 0x6a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x2f,
	0x7b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x7d, 0xea, 0x41, 0x6d, 0x0a, 0x29, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x52, 0x0a, 0x27, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0xfc,
	0x02, 0x0a, 0x2c, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d,
	0x12, 0x78, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x12, 0x71, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0xea, 0x41, 0x7d,
	0x0a, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0xea, 0x41, 0x77,
	0x0a, 0x2c, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x47,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0xea, 0x41, 0x79, 0x0a, 0x23, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x68, 0x69, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x66, 0x68, 0x69, 0x72,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x7d, 0xea, 0x41, 0xa4, 0x01, 0x0a, 0x26, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63,
	0x61, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x68, 0x69, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x66, 0x68, 0x69, 0x72,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x7d, 0x2f, 0x66, 0x68, 0x69, 0x72, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x2f, 0x7b, 0x66, 0x68, 0x69, 0x72, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x0a, 0x23, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02,
	0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_discoveryengine_v1_common_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1_common_proto_rawDescData = file_google_cloud_discoveryengine_v1_common_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1_common_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1_common_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1_common_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_discoveryengine_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_discoveryengine_v1_common_proto_goTypes = []any{
	(IndustryVertical)(0),   // 0: google.cloud.discoveryengine.v1.IndustryVertical
	(SolutionType)(0),       // 1: google.cloud.discoveryengine.v1.SolutionType
	(SearchUseCase)(0),      // 2: google.cloud.discoveryengine.v1.SearchUseCase
	(SearchTier)(0),         // 3: google.cloud.discoveryengine.v1.SearchTier
	(SearchAddOn)(0),        // 4: google.cloud.discoveryengine.v1.SearchAddOn
	(*Interval)(nil),        // 5: google.cloud.discoveryengine.v1.Interval
	(*CustomAttribute)(nil), // 6: google.cloud.discoveryengine.v1.CustomAttribute
	(*UserInfo)(nil),        // 7: google.cloud.discoveryengine.v1.UserInfo
}
var file_google_cloud_discoveryengine_v1_common_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1_common_proto_init() }
func file_google_cloud_discoveryengine_v1_common_proto_init() {
	if File_google_cloud_discoveryengine_v1_common_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1_common_proto_msgTypes[0].OneofWrappers = []any{
		(*Interval_Minimum)(nil),
		(*Interval_ExclusiveMinimum)(nil),
		(*Interval_Maximum)(nil),
		(*Interval_ExclusiveMaximum)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1_common_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1_common_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1_common_proto = out.File
	file_google_cloud_discoveryengine_v1_common_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1_common_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1_common_proto_depIdxs = nil
}
