// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/css/v1/accounts_labels.proto

package csspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The label type.
type AccountLabel_LabelType int32

const (
	// Unknown label type.
	AccountLabel_LABEL_TYPE_UNSPECIFIED AccountLabel_LabelType = 0
	// Indicates that the label was created manually.
	AccountLabel_MANUAL AccountLabel_LabelType = 1
	// Indicates that the label was created automatically by CSS Center.
	AccountLabel_AUTOMATIC AccountLabel_LabelType = 2
)

// Enum value maps for AccountLabel_LabelType.
var (
	AccountLabel_LabelType_name = map[int32]string{
		0: "LABEL_TYPE_UNSPECIFIED",
		1: "MANUAL",
		2: "AUTOMATIC",
	}
	AccountLabel_LabelType_value = map[string]int32{
		"LABEL_TYPE_UNSPECIFIED": 0,
		"MANUAL":                 1,
		"AUTOMATIC":              2,
	}
)

func (x AccountLabel_LabelType) Enum() *AccountLabel_LabelType {
	p := new(AccountLabel_LabelType)
	*p = x
	return p
}

func (x AccountLabel_LabelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccountLabel_LabelType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_css_v1_accounts_labels_proto_enumTypes[0].Descriptor()
}

func (AccountLabel_LabelType) Type() protoreflect.EnumType {
	return &file_google_shopping_css_v1_accounts_labels_proto_enumTypes[0]
}

func (x AccountLabel_LabelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccountLabel_LabelType.Descriptor instead.
func (AccountLabel_LabelType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{0, 0}
}

// Label assigned by CSS domain or CSS group to one of its sub-accounts.
type AccountLabel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the label.
	// Format: accounts/{account}/labels/{label}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The ID of the label.
	LabelId int64 `protobuf:"varint,2,opt,name=label_id,json=labelId,proto3" json:"label_id,omitempty"`
	// Output only. The ID of account this label belongs to.
	AccountId int64 `protobuf:"varint,3,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
	// The display name of this label.
	DisplayName *string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3,oneof" json:"display_name,omitempty"`
	// The description of this label.
	Description *string `protobuf:"bytes,5,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Output only. The type of this label.
	LabelType AccountLabel_LabelType `protobuf:"varint,6,opt,name=label_type,json=labelType,proto3,enum=google.shopping.css.v1.AccountLabel_LabelType" json:"label_type,omitempty"`
}

func (x *AccountLabel) Reset() {
	*x = AccountLabel{}
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccountLabel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountLabel) ProtoMessage() {}

func (x *AccountLabel) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountLabel.ProtoReflect.Descriptor instead.
func (*AccountLabel) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{0}
}

func (x *AccountLabel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccountLabel) GetLabelId() int64 {
	if x != nil {
		return x.LabelId
	}
	return 0
}

func (x *AccountLabel) GetAccountId() int64 {
	if x != nil {
		return x.AccountId
	}
	return 0
}

func (x *AccountLabel) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

func (x *AccountLabel) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *AccountLabel) GetLabelType() AccountLabel_LabelType {
	if x != nil {
		return x.LabelType
	}
	return AccountLabel_LABEL_TYPE_UNSPECIFIED
}

// Request message for the `ListAccountLabels` method.
type ListAccountLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent account.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of labels to return. The service may return fewer than
	// this value.
	// If unspecified, at most 50 labels will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAccountLabels` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAccountLabels` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccountLabelsRequest) Reset() {
	*x = ListAccountLabelsRequest{}
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAccountLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountLabelsRequest) ProtoMessage() {}

func (x *ListAccountLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountLabelsRequest.ProtoReflect.Descriptor instead.
func (*ListAccountLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{1}
}

func (x *ListAccountLabelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAccountLabelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListAccountLabels` method.
type ListAccountLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The labels from the specified account.
	AccountLabels []*AccountLabel `protobuf:"bytes,1,rep,name=account_labels,json=accountLabels,proto3" json:"account_labels,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountLabelsResponse) Reset() {
	*x = ListAccountLabelsResponse{}
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAccountLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountLabelsResponse) ProtoMessage() {}

func (x *ListAccountLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountLabelsResponse.ProtoReflect.Descriptor instead.
func (*ListAccountLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{2}
}

func (x *ListAccountLabelsResponse) GetAccountLabels() []*AccountLabel {
	if x != nil {
		return x.AccountLabels
	}
	return nil
}

func (x *ListAccountLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the 'CreateAccountLanel' method.
type CreateAccountLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent account.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The label to create.
	AccountLabel *AccountLabel `protobuf:"bytes,2,opt,name=account_label,json=accountLabel,proto3" json:"account_label,omitempty"`
}

func (x *CreateAccountLabelRequest) Reset() {
	*x = CreateAccountLabelRequest{}
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAccountLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAccountLabelRequest) ProtoMessage() {}

func (x *CreateAccountLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAccountLabelRequest.ProtoReflect.Descriptor instead.
func (*CreateAccountLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{3}
}

func (x *CreateAccountLabelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAccountLabelRequest) GetAccountLabel() *AccountLabel {
	if x != nil {
		return x.AccountLabel
	}
	return nil
}

// Request message for the `UpdateAccountLabel` method.
type UpdateAccountLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated label. All fields must be provided.
	AccountLabel *AccountLabel `protobuf:"bytes,1,opt,name=account_label,json=accountLabel,proto3" json:"account_label,omitempty"`
}

func (x *UpdateAccountLabelRequest) Reset() {
	*x = UpdateAccountLabelRequest{}
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAccountLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountLabelRequest) ProtoMessage() {}

func (x *UpdateAccountLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountLabelRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAccountLabelRequest) GetAccountLabel() *AccountLabel {
	if x != nil {
		return x.AccountLabel
	}
	return nil
}

// Request message for the 'DeleteAccountLabel' method.
type DeleteAccountLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the label to delete.
	// Format:  accounts/{account}/labels/{label}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAccountLabelRequest) Reset() {
	*x = DeleteAccountLabelRequest{}
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAccountLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAccountLabelRequest) ProtoMessage() {}

func (x *DeleteAccountLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_labels_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAccountLabelRequest.ProtoReflect.Descriptor instead.
func (*DeleteAccountLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAccountLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_shopping_css_v1_accounts_labels_proto protoreflect.FileDescriptor

var file_google_shopping_css_v1_accounts_labels_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x03, 0x0a, 0x0c, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x52,
	0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x42, 0x0a, 0x09, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4d,
	0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d,
	0x41, 0x54, 0x49, 0x43, 0x10, 0x02, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x1f, 0x63, 0x73, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x21, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d,
	0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x7d, 0x2a,
	0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x32, 0x0c,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x0f, 0x0a, 0x0d,
	0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x12, 0x1f, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x90, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xac, 0x01, 0x0a, 0x19, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x6b, 0x0a, 0x19, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x58, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x73, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x32, 0x97, 0x06, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa9, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63,
	0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x4c, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x22, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x22, 0x53, 0xda, 0x41, 0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0d, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x32, 0x2c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8e, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x2a, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x3f, 0xca, 0x41, 0x12, 0x63, 0x73,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xb5, 0x01, 0x0a, 0x1a, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x63,
	0x73, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x73, 0x73, 0x70, 0x62, 0x3b, 0x63,
	0x73, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x43, 0x73, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c,
	0x43, 0x73, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x43, 0x73, 0x73, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_css_v1_accounts_labels_proto_rawDescOnce sync.Once
	file_google_shopping_css_v1_accounts_labels_proto_rawDescData = file_google_shopping_css_v1_accounts_labels_proto_rawDesc
)

func file_google_shopping_css_v1_accounts_labels_proto_rawDescGZIP() []byte {
	file_google_shopping_css_v1_accounts_labels_proto_rawDescOnce.Do(func() {
		file_google_shopping_css_v1_accounts_labels_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_css_v1_accounts_labels_proto_rawDescData)
	})
	return file_google_shopping_css_v1_accounts_labels_proto_rawDescData
}

var file_google_shopping_css_v1_accounts_labels_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_shopping_css_v1_accounts_labels_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_shopping_css_v1_accounts_labels_proto_goTypes = []any{
	(AccountLabel_LabelType)(0),       // 0: google.shopping.css.v1.AccountLabel.LabelType
	(*AccountLabel)(nil),              // 1: google.shopping.css.v1.AccountLabel
	(*ListAccountLabelsRequest)(nil),  // 2: google.shopping.css.v1.ListAccountLabelsRequest
	(*ListAccountLabelsResponse)(nil), // 3: google.shopping.css.v1.ListAccountLabelsResponse
	(*CreateAccountLabelRequest)(nil), // 4: google.shopping.css.v1.CreateAccountLabelRequest
	(*UpdateAccountLabelRequest)(nil), // 5: google.shopping.css.v1.UpdateAccountLabelRequest
	(*DeleteAccountLabelRequest)(nil), // 6: google.shopping.css.v1.DeleteAccountLabelRequest
	(*emptypb.Empty)(nil),             // 7: google.protobuf.Empty
}
var file_google_shopping_css_v1_accounts_labels_proto_depIdxs = []int32{
	0, // 0: google.shopping.css.v1.AccountLabel.label_type:type_name -> google.shopping.css.v1.AccountLabel.LabelType
	1, // 1: google.shopping.css.v1.ListAccountLabelsResponse.account_labels:type_name -> google.shopping.css.v1.AccountLabel
	1, // 2: google.shopping.css.v1.CreateAccountLabelRequest.account_label:type_name -> google.shopping.css.v1.AccountLabel
	1, // 3: google.shopping.css.v1.UpdateAccountLabelRequest.account_label:type_name -> google.shopping.css.v1.AccountLabel
	2, // 4: google.shopping.css.v1.AccountLabelsService.ListAccountLabels:input_type -> google.shopping.css.v1.ListAccountLabelsRequest
	4, // 5: google.shopping.css.v1.AccountLabelsService.CreateAccountLabel:input_type -> google.shopping.css.v1.CreateAccountLabelRequest
	5, // 6: google.shopping.css.v1.AccountLabelsService.UpdateAccountLabel:input_type -> google.shopping.css.v1.UpdateAccountLabelRequest
	6, // 7: google.shopping.css.v1.AccountLabelsService.DeleteAccountLabel:input_type -> google.shopping.css.v1.DeleteAccountLabelRequest
	3, // 8: google.shopping.css.v1.AccountLabelsService.ListAccountLabels:output_type -> google.shopping.css.v1.ListAccountLabelsResponse
	1, // 9: google.shopping.css.v1.AccountLabelsService.CreateAccountLabel:output_type -> google.shopping.css.v1.AccountLabel
	1, // 10: google.shopping.css.v1.AccountLabelsService.UpdateAccountLabel:output_type -> google.shopping.css.v1.AccountLabel
	7, // 11: google.shopping.css.v1.AccountLabelsService.DeleteAccountLabel:output_type -> google.protobuf.Empty
	8, // [8:12] is the sub-list for method output_type
	4, // [4:8] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_shopping_css_v1_accounts_labels_proto_init() }
func file_google_shopping_css_v1_accounts_labels_proto_init() {
	if File_google_shopping_css_v1_accounts_labels_proto != nil {
		return
	}
	file_google_shopping_css_v1_accounts_labels_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_css_v1_accounts_labels_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_css_v1_accounts_labels_proto_goTypes,
		DependencyIndexes: file_google_shopping_css_v1_accounts_labels_proto_depIdxs,
		EnumInfos:         file_google_shopping_css_v1_accounts_labels_proto_enumTypes,
		MessageInfos:      file_google_shopping_css_v1_accounts_labels_proto_msgTypes,
	}.Build()
	File_google_shopping_css_v1_accounts_labels_proto = out.File
	file_google_shopping_css_v1_accounts_labels_proto_rawDesc = nil
	file_google_shopping_css_v1_accounts_labels_proto_goTypes = nil
	file_google_shopping_css_v1_accounts_labels_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccountLabelsServiceClient is the client API for AccountLabelsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccountLabelsServiceClient interface {
	// Lists the labels owned by an account.
	ListAccountLabels(ctx context.Context, in *ListAccountLabelsRequest, opts ...grpc.CallOption) (*ListAccountLabelsResponse, error)
	// Creates a new label, not assigned to any account.
	CreateAccountLabel(ctx context.Context, in *CreateAccountLabelRequest, opts ...grpc.CallOption) (*AccountLabel, error)
	// Updates a label.
	UpdateAccountLabel(ctx context.Context, in *UpdateAccountLabelRequest, opts ...grpc.CallOption) (*AccountLabel, error)
	// Deletes a label and removes it from all accounts to which it was assigned.
	DeleteAccountLabel(ctx context.Context, in *DeleteAccountLabelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type accountLabelsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAccountLabelsServiceClient(cc grpc.ClientConnInterface) AccountLabelsServiceClient {
	return &accountLabelsServiceClient{cc}
}

func (c *accountLabelsServiceClient) ListAccountLabels(ctx context.Context, in *ListAccountLabelsRequest, opts ...grpc.CallOption) (*ListAccountLabelsResponse, error) {
	out := new(ListAccountLabelsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountLabelsService/ListAccountLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountLabelsServiceClient) CreateAccountLabel(ctx context.Context, in *CreateAccountLabelRequest, opts ...grpc.CallOption) (*AccountLabel, error) {
	out := new(AccountLabel)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountLabelsService/CreateAccountLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountLabelsServiceClient) UpdateAccountLabel(ctx context.Context, in *UpdateAccountLabelRequest, opts ...grpc.CallOption) (*AccountLabel, error) {
	out := new(AccountLabel)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountLabelsService/UpdateAccountLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountLabelsServiceClient) DeleteAccountLabel(ctx context.Context, in *DeleteAccountLabelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountLabelsService/DeleteAccountLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccountLabelsServiceServer is the server API for AccountLabelsService service.
type AccountLabelsServiceServer interface {
	// Lists the labels owned by an account.
	ListAccountLabels(context.Context, *ListAccountLabelsRequest) (*ListAccountLabelsResponse, error)
	// Creates a new label, not assigned to any account.
	CreateAccountLabel(context.Context, *CreateAccountLabelRequest) (*AccountLabel, error)
	// Updates a label.
	UpdateAccountLabel(context.Context, *UpdateAccountLabelRequest) (*AccountLabel, error)
	// Deletes a label and removes it from all accounts to which it was assigned.
	DeleteAccountLabel(context.Context, *DeleteAccountLabelRequest) (*emptypb.Empty, error)
}

// UnimplementedAccountLabelsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAccountLabelsServiceServer struct {
}

func (*UnimplementedAccountLabelsServiceServer) ListAccountLabels(context.Context, *ListAccountLabelsRequest) (*ListAccountLabelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountLabels not implemented")
}
func (*UnimplementedAccountLabelsServiceServer) CreateAccountLabel(context.Context, *CreateAccountLabelRequest) (*AccountLabel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAccountLabel not implemented")
}
func (*UnimplementedAccountLabelsServiceServer) UpdateAccountLabel(context.Context, *UpdateAccountLabelRequest) (*AccountLabel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccountLabel not implemented")
}
func (*UnimplementedAccountLabelsServiceServer) DeleteAccountLabel(context.Context, *DeleteAccountLabelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccountLabel not implemented")
}

func RegisterAccountLabelsServiceServer(s *grpc.Server, srv AccountLabelsServiceServer) {
	s.RegisterService(&_AccountLabelsService_serviceDesc, srv)
}

func _AccountLabelsService_ListAccountLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountLabelsServiceServer).ListAccountLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountLabelsService/ListAccountLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountLabelsServiceServer).ListAccountLabels(ctx, req.(*ListAccountLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountLabelsService_CreateAccountLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAccountLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountLabelsServiceServer).CreateAccountLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountLabelsService/CreateAccountLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountLabelsServiceServer).CreateAccountLabel(ctx, req.(*CreateAccountLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountLabelsService_UpdateAccountLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountLabelsServiceServer).UpdateAccountLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountLabelsService/UpdateAccountLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountLabelsServiceServer).UpdateAccountLabel(ctx, req.(*UpdateAccountLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountLabelsService_DeleteAccountLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccountLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountLabelsServiceServer).DeleteAccountLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountLabelsService/DeleteAccountLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountLabelsServiceServer).DeleteAccountLabel(ctx, req.(*DeleteAccountLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccountLabelsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.css.v1.AccountLabelsService",
	HandlerType: (*AccountLabelsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAccountLabels",
			Handler:    _AccountLabelsService_ListAccountLabels_Handler,
		},
		{
			MethodName: "CreateAccountLabel",
			Handler:    _AccountLabelsService_CreateAccountLabel_Handler,
		},
		{
			MethodName: "UpdateAccountLabel",
			Handler:    _AccountLabelsService_UpdateAccountLabel_Handler,
		},
		{
			MethodName: "DeleteAccountLabel",
			Handler:    _AccountLabelsService_DeleteAccountLabel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/css/v1/accounts_labels.proto",
}
